/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import org.eclipse.jdt.core.tests.compiler.parser.SourceField;
import org.eclipse.jdt.core.tests.compiler.parser.SourceImport;
import org.eclipse.jdt.core.tests.compiler.parser.SourceMethod;
import org.eclipse.jdt.core.tests.compiler.parser.SourcePackage;

public final class SourceType {
    private final int modifiers;
    private final int declarationStart;
    private int declarationEnd;
    private char[] fileName;
    private SourcePackage packageName;
    private SourceImport[] imports;
    private final char[] enclosingTypeName;
    private final char[] name;
    private final int nameSourceStart;
    private final int nameSourceEnd;
    private char[] superclassName;
    private char[][] interfaceNames;
    private SourceType[] memberTypes;
    private int numberOfMemberTypes;
    private SourceMethod[] methods;
    private int numberOfMethods;
    private SourceField[] fields;
    private SourceField[] recordComponents;
    private int numberOfFields;
    private int numberOfComponents;
    private final char[] source;
    SourceType parent;
    char[][] typeParameterNames;
    char[][][] typeParameterBounds;
    private char[] qualifiedName;
    private String defaultConstructor;

    public SourceType(char[] enclosingTypeName, int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclassName, char[][] interfaceNames, char[] source) {
        this.enclosingTypeName = enclosingTypeName;
        this.declarationStart = declarationStart;
        this.modifiers = modifiers;
        this.name = name;
        this.nameSourceStart = nameSourceStart;
        this.nameSourceEnd = nameSourceEnd;
        this.superclassName = superclassName;
        this.interfaceNames = interfaceNames;
        this.source = source;
    }

    protected void addField(SourceField sourceField) {
        if (this.fields == null) {
            this.fields = new SourceField[4];
        }
        if (this.numberOfFields == this.fields.length) {
            this.fields = new SourceField[this.numberOfFields * 2];
            System.arraycopy(this.fields, 0, this.fields, 0, this.numberOfFields);
        }
        this.fields[this.numberOfFields++] = sourceField;
    }

    protected void addRecordComponent(SourceField comp) {
        if (this.recordComponents == null) {
            this.recordComponents = new SourceField[4];
        }
        if (this.numberOfComponents == this.recordComponents.length) {
            this.recordComponents = new SourceField[this.numberOfComponents * 2];
            System.arraycopy(this.recordComponents, 0, this.recordComponents, 0, this.numberOfComponents);
        }
        this.recordComponents[this.numberOfComponents++] = comp;
    }

    protected void addMemberType(SourceType sourceMemberType) {
        if (this.memberTypes == null) {
            this.memberTypes = new SourceType[4];
        }
        if (this.numberOfMemberTypes == this.memberTypes.length) {
            this.memberTypes = new SourceType[this.numberOfMemberTypes * 2];
            System.arraycopy(this.memberTypes, 0, this.memberTypes, 0, this.numberOfMemberTypes);
        }
        this.memberTypes[this.numberOfMemberTypes++] = sourceMemberType;
    }

    protected void addMethod(SourceMethod sourceMethod) {
        if (this.methods == null) {
            this.methods = new SourceMethod[4];
        }
        if (this.numberOfMethods == this.methods.length) {
            this.methods = new SourceMethod[this.numberOfMethods * 2];
            System.arraycopy(this.methods, 0, this.methods, 0, this.numberOfMethods);
        }
        this.methods[this.numberOfMethods++] = sourceMethod;
    }

    public String displayModifiers() {
        StringBuilder buffer = new StringBuilder();
        if (this.modifiers == 0) {
            return null;
        }
        if ((this.modifiers & 1) != 0) {
            buffer.append("public ");
        }
        if ((this.modifiers & 4) != 0) {
            buffer.append("protected ");
        }
        if ((this.modifiers & 2) != 0) {
            buffer.append("private ");
        }
        if ((this.modifiers & 0x10) != 0) {
            buffer.append("final ");
        }
        if ((this.modifiers & 8) != 0) {
            buffer.append("static ");
        }
        if ((this.modifiers & 0x400) != 0) {
            buffer.append("abstract ");
        }
        if ((this.modifiers & 0x100) != 0) {
            buffer.append("native ");
        }
        if ((this.modifiers & 0x20) != 0) {
            buffer.append("synchronized ");
        }
        return buffer.toString().trim();
    }

    public String getActualName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.source, this.nameSourceStart, this.nameSourceEnd - this.nameSourceStart + 1);
        return buffer.toString();
    }

    public int getDeclarationSourceEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationStart;
    }

    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public SourceField[] getFields() {
        if (this.fields != null && this.fields.length != this.numberOfFields) {
            this.fields = new SourceField[this.numberOfFields];
            System.arraycopy(this.fields, 0, this.fields, 0, this.numberOfFields);
        }
        return this.fields;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[][] getImports() {
        if (this.imports == null) {
            return null;
        }
        int importLength = this.imports.length;
        char[][] importNames = new char[importLength][];
        int i = 0;
        int max = importLength;
        while (i < max) {
            importNames[i] = this.imports[i].name;
            ++i;
        }
        return importNames;
    }

    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    public SourceType[] getMemberTypes() {
        if (this.memberTypes != null && this.memberTypes.length != this.numberOfMemberTypes) {
            this.memberTypes = new SourceType[this.numberOfMemberTypes];
            System.arraycopy(this.memberTypes, 0, this.memberTypes, 0, this.numberOfMemberTypes);
        }
        return this.memberTypes;
    }

    public SourceMethod[] getMethods() {
        if (this.methods != null && this.methods.length != this.numberOfMethods) {
            this.methods = new SourceMethod[this.numberOfMethods];
            System.arraycopy(this.methods, 0, this.methods, 0, this.numberOfMethods);
        }
        return this.methods;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameSourceEnd() {
        return this.nameSourceEnd;
    }

    public int getNameSourceStart() {
        return this.nameSourceStart;
    }

    public char[] getPackageName() {
        return this.packageName.name;
    }

    public char[] getQualifiedName() {
        if (this.qualifiedName == null) {
            StringBuilder temp = new StringBuilder();
            temp.append(this.packageName);
            temp.append('.');
            temp.append(this.name);
            this.qualifiedName = temp.toString().toCharArray();
        }
        return this.qualifiedName;
    }

    public char[] getSuperclassName() {
        return this.superclassName;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isClass() {
        return (this.modifiers & 0x200) == 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) == 512;
    }

    public void setDeclarationSourceEnd(int position) {
        this.declarationEnd = position;
    }

    public void setDefaultConstructor(String s) {
        this.defaultConstructor = s;
    }

    public void setImports(SourceImport[] imports) {
        this.imports = imports;
    }

    public void setPackage(SourcePackage sourcePackage) {
        this.packageName = sourcePackage;
    }

    public void setSuperclass(char[] superclassName) {
        this.superclassName = superclassName;
    }

    public void setSuperinterfaces(char[][] superinterfacesNames) {
        this.interfaceNames = superinterfacesNames;
    }

    public String tabString(int tab) {
        Object s = "";
        int i = tab;
        while (i > 0) {
            s = (String)s + "\t";
            --i;
        }
        return s;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        int max;
        int i;
        StringBuilder buffer = new StringBuilder();
        if (this.packageName != null) {
            buffer.append(this.tabString(tab)).append(this.packageName);
        }
        if (this.imports != null) {
            int i2 = 0;
            int max2 = this.imports.length;
            while (i2 < max2) {
                buffer.append(this.tabString(tab)).append(this.imports[i2]);
                ++i2;
            }
        }
        buffer.append(this.tabString(tab));
        String displayModifiers = this.displayModifiers();
        if (displayModifiers != null) {
            buffer.append(displayModifiers).append(" ");
        }
        buffer.append(this.isInterface() ? "interface " : "class ").append(this.name).append(" ");
        if (this.superclassName != null) {
            buffer.append("extends ").append(this.superclassName).append(" ");
        }
        if (this.interfaceNames != null) {
            buffer.append("implements ");
            i = 0;
            max = this.interfaceNames.length;
            while (i < max) {
                buffer.append(this.interfaceNames[i]).append(", ");
                ++i;
            }
        }
        buffer.append("{\n");
        if (this.memberTypes != null) {
            i = 0;
            max = this.numberOfMemberTypes;
            while (i < max) {
                buffer.append(this.memberTypes[i].toString(tab + 1)).append("\n");
                ++i;
            }
        }
        if (this.fields != null) {
            i = 0;
            max = this.numberOfFields;
            while (i < max) {
                buffer.append(this.fields[i].toString(tab + 1)).append("\n");
                ++i;
            }
        }
        if (this.defaultConstructor != null) {
            buffer.append(this.tabString(tab + 1)).append(this.defaultConstructor);
        }
        if (this.methods != null) {
            i = 0;
            max = this.numberOfMethods;
            while (i < max) {
                buffer.append(this.methods[i].toString(tab + 1)).append("\n");
                ++i;
            }
        }
        buffer.append(this.tabString(tab)).append("}");
        return buffer.toString();
    }
}

