/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;

public class StringLiteralTest
extends TestCase {
    public void testAppend() {
        StringLiteral l1 = new StringLiteral(new char[]{'a'}, 2, 3, 4);
        StringLiteral l2 = new StringLiteral(new char[]{'b'}, 5, 6, 7);
        StringLiteral l3 = new StringLiteral(new char[]{'c'}, 8, 9, 10);
        ExtendedStringLiteral extendWithString = l1.extendWith(l2).extendWith(l3);
        ExtendedStringLiteral extendWithString2 = l1.extendWith((StringLiteral)l2.extendWith(l3));
        StringLiteralConcatenation extendsWithString = l1.extendsWith(l2).extendsWith(l3);
        StringLiteralConcatenation extendsWithString23 = l2.extendsWith(l3);
        StringLiteralConcatenation extendsWithString3 = l1.extendsWith((StringLiteral)extendsWithString23);
        ExtendedStringLiteral extendWithChar = l1.extendWith(new CharLiteral("'\\n'".toCharArray(), 5, 6)).extendWith(new CharLiteral("'\\t'".toCharArray(), 8, 9));
        List<StringLiteralConcatenation> allLiterals = List.of(extendWithString, extendWithString2, extendsWithString, extendsWithString3);
        for (StringLiteral stringLiteral : allLiterals) {
            String expected = stringLiteral == extendWithChar ? "a\n\t" : "abc";
            StringLiteralTest.assertEquals((String)expected, (String)new String(stringLiteral.source()));
            StringLiteralTest.assertEquals((int)2, (int)stringLiteral.sourceStart);
            StringLiteralTest.assertEquals((int)9, (int)stringLiteral.sourceEnd);
            StringLiteralTest.assertEquals((int)3, (int)stringLiteral.getLineNumber());
            stringLiteral.computeConstant();
            StringLiteralTest.assertEquals((String)expected, (String)stringLiteral.constant.stringValue());
        }
        StringLiteralConcatenation stringLiteralConcatenation = l1.extendsWith(l2);
        StringLiteral[] literals2 = stringLiteralConcatenation.getLiterals();
        StringLiteralTest.assertEquals((int)2, (int)literals2.length);
        StringLiteralTest.assertEquals((Object)l1, (Object)literals2[0]);
        StringLiteralTest.assertEquals((Object)l2, (Object)literals2[1]);
        StringLiteral[] literals = extendsWithString.getLiterals();
        StringLiteralTest.assertEquals((int)3, (int)literals.length);
        StringLiteralTest.assertEquals((Object)l1, (Object)literals[0]);
        StringLiteralTest.assertEquals((Object)l2, (Object)literals[1]);
        StringLiteralTest.assertEquals((Object)l3, (Object)literals[2]);
        StringLiteral[] literals3 = extendsWithString3.getLiterals();
        StringLiteralTest.assertEquals((int)2, (int)literals3.length);
        StringLiteralTest.assertEquals((Object)l1, (Object)literals3[0]);
        StringLiteralTest.assertEquals((Object)extendsWithString23, (Object)literals3[1]);
    }
}

