/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class SyntaxErrorTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = CompilerOptions.getFirstSupportedJdkLevel();

    public SyntaxErrorTest(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedSyntaxErrorDiagnosis, String testName) {
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        StringBuilder buffer = new StringBuilder(100);
        if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
            CategorizedProblem[] problems = compilationResult.getAllProblems();
            int count = problems.length;
            int problemCount = 0;
            char[] unitSource = compilationResult.compilationUnit.getContents();
            int i = 0;
            while (i < count) {
                if (problems[i] != null) {
                    if (problemCount == 0) {
                        buffer.append("----------\n");
                    }
                    buffer.append(++problemCount + (problems[i].isError() ? ". ERROR" : ". WARNING"));
                    buffer.append(" in " + new String(problems[i].getOriginatingFileName()).replace('/', '\\'));
                    try {
                        buffer.append(((DefaultProblem)problems[i]).errorReportSource(unitSource));
                        buffer.append("\n");
                        buffer.append(problems[i].getMessage());
                        buffer.append("\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    buffer.append("----------\n");
                }
                ++i;
            }
        }
        String computedSyntaxErrorDiagnosis = buffer.toString();
        SyntaxErrorTest.assertEquals("Invalid syntax error diagnosis" + testName, Util.convertToIndependantLineDelimiter(expectedSyntaxErrorDiagnosis), Util.convertToIndependantLineDelimiter(computedSyntaxErrorDiagnosis));
    }

    public void test01() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n public void solve(){\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n  X[] results = new X[10];\t\t\t\t\t\t\n  for(int i = 0; i < 10; i++){\t\t\t\t\t\n   X result = results[i];\t\t\t\t\t\t\n   boolean found = false;\t\t\t\t\t\t\n   for(int j = 0; j < 10; j++){\t\t\t\t\n    if (this.equals(result.documentName){\t\t\n     found = true;\t\t\t\t\t\t\t\t\n     break;\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n  return andResult;\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <parenthesis mismatch> (at line 9)\n\tif (this.equals(result.documentName){\t\t\n\t                                   ^\nSyntax error, insert \") Statement\" to complete BlockStatements\n----------\n";
        String testName = "<parenthesis mismatch>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test02() {
        String s = "class Bar {\t\t\t\n\tBar() {\t\t\t\t\n\t\tthis(fred().x{);\n\t}\t\t\t\t\t\n}\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <brace mismatch> (at line 3)\n\tthis(fred().x{);\n\t             ^\nSyntax error on token \"{\", delete this token\n----------\n";
        String testName = "<brace mismatch>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test03() {
        String s = "public class X { // should complain\t\n\tint foo(\t\t\t\t\t\t\t\n\t\t[ arg1, \t\t\t\t\t\t\n\t\t{ arg2, ]\t\t\t\t\t\t\n\t\t  arg3, \t\t\t\t\t\t\n\t){\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <parenthesis mismatch> (at line 3)\n\t[ arg1, \t\t\t\t\t\t\n\t^\nSyntax error on token \"[\", byte expected\n----------\n2. ERROR in <parenthesis mismatch> (at line 4)\n\t{ arg2, ]\t\t\t\t\t\t\n\t^\nSyntax error on token \"{\", byte expected\n----------\n3. ERROR in <parenthesis mismatch> (at line 4)\n\t{ arg2, ]\t\t\t\t\t\t\n\t        ^\nSyntax error on token \"]\", byte expected\n----------\n4. ERROR in <parenthesis mismatch> (at line 5)\n\targ3, \t\t\t\t\t\t\n\t    ^\nSyntax error on token \",\", SingleVariableDeclarator expected after this token\n----------\n";
        String testName = "<parenthesis mismatch>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test04() {
        String s = "public class X { // should not complain\t\n\tint foo(\t\t\t\t\t\t\t\t\n\t\t{ arg1, \t\t\t\t\t\t\t\n\t\t{ arg2, }\t\t\t\t\t\t\t\n\t\t  arg3, }\t\t\t\t\t\t\t\n\t){\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <no parenthesis mismatch> (at line 2)\n\tint foo(\t\t\t\t\t\t\t\t\n\t       ^\nSyntax error on token \"(\", = expected\n----------\n2. ERROR in <no parenthesis mismatch> (at line 5)\n\targ3, }\t\t\t\t\t\t\t\n\t^^^^\nSyntax error on token \"arg3\", delete this token\n----------\n3. ERROR in <no parenthesis mismatch> (at line 6)\n\t){\t\t\t\t\t\t\t\t\t\t\n\t^\nSyntax error on token \")\", ; expected\n----------\n";
        String testName = "<no parenthesis mismatch>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test05() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tpublic void foo() {\t\t\t\t\t\t\n\t\t(X) foo(); \t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 3)\n\t(X) foo(); \t\t\t\t\t\t\t\n\t  ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Assignment\n----------\n2. ERROR in <test> (at line 3)\n\t(X) foo(); \t\t\t\t\t\t\t\n\t  ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test06() {
        String s = "public class X { \t\t\t\t\t\t\t\n\tpublic void foo(int i) {\t\t\t\t\n\t\ti; \t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 3)\n\ti; \t\t\t\t\t\t\t\t\t\n\t^\nSyntax error, insert \"VariableDeclarators\" to complete LocalVariableDeclaration\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test07() {
        String s = "public class X { \t\t\t\t\t\t\t\t\t\t\t\n\tjava.lang.Object o[] = { new String(\"SUCCESS\") ; };\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 2)\n\tjava.lang.Object o[] = { new String(\"SUCCESS\") ; };\t\n\t                                               ^\nSyntax error on token \";\", , expected\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test08() {
        String s = "public class X { \t\t\t\t\t\t\t\t\t\t\t\n\tObject o[] = { new String(\"SUCCESS\") ; };\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 2)\n\tObject o[] = { new String(\"SUCCESS\") ; };\t\t\t\t\n\t                                     ^\nSyntax error on token \";\", , expected\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test09() {
        String s = "public class X { \t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tjava.lang.Object o[] = { new String(\"SUCCESS\") ; };\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 3)\n\tjava.lang.Object o[] = { new String(\"SUCCESS\") ; };\t\n\t                                               ^\nSyntax error on token \";\", , expected\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test10() {
        String s = "public class X { \t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tObject o[] = { new String(\"SUCCESS\") ; };\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 3)\n\tObject o[] = { new String(\"SUCCESS\") ; };\t\t\t\t\n\t                                     ^\nSyntax error on token \";\", , expected\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test11() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic interface Test {\t\t\t\t\t\t\n  public void myMethod()\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 3)\n\tpublic void myMethod()\t\t\t\t\t\t\n\t                     ^\nSyntax error, insert \";\" to complete MethodDeclaration\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test12() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic interface Test {\t\t\t\t\t\t\n  public void myMethod()\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 3)\n\tpublic void myMethod()\t\t\t\t\t\t\n\t                     ^\nSyntax error on token \")\", { expected after this token\n----------\n2. ERROR in <test> (at line 5)\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\t^\nSyntax error, insert \"}\" to complete InterfaceBody\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test13() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\npublic class Test {\t\t\t\t\t\t\t\n  public void foo() {\t\t\t\t\t\t\t\n    foo(a  \"\\\"\");\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 4)\n\tfoo(a  \"\\\"\");\t\t\t\t\t\t\t\n\t       ^^^^\nSyntax error on token \"\"\\\"\"\", delete this token\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test14() {
        String s = "public interface Test {\n  static {  }\n  {         }\n}\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 2)\n\tstatic {  }\n\t       ^^^^\nThe interface Test cannot define an initializer\n----------\n2. ERROR in <test> (at line 3)\n\t{         }\n\t^^^^^^^^^^^\nThe interface Test cannot define an initializer\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }

    public void test15() {
        String s = "package bug;\npublic class Test {\n  static int X;\n  String field = { String str;\n      switch (X) {\n        case 0:\n          str = \"zero\";\n          break;\n        default:\n          str = \"other\";\n          break;\n      }\n      this.field = str;\n  };\n  public static void main(String[] args) {\n    System.out.println(new Test().field);\n  }\n}\n";
        String expectedSyntaxErrorDiagnosis = "----------\n1. ERROR in <test> (at line 4)\n\tString field = { String str;\n\t               ^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in <test> (at line 4)\n\tString field = { String str;\n\t                           ^\nSyntax error on token \";\", { expected after this token\n----------\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedSyntaxErrorDiagnosis, testName);
    }
}

