/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public abstract class AbstractBatchCompilerTest
extends AbstractRegressionTest {
    public static final String OUTPUT_DIR_PLACEHOLDER = "---OUTPUT_DIR_PLACEHOLDER---";
    public static final String LIB_DIR_PLACEHOLDER = "---LIB_DIR_PLACEHOLDER---";
    protected static Normalizer outputDirNormalizer = File.separatorChar == '/' ? new StringNormalizer(new StringNormalizer(null, OUTPUT_DIR, "---OUTPUT_DIR_PLACEHOLDER---"), LIB_DIR, "---LIB_DIR_PLACEHOLDER---") : new StringNormalizer(new StringNormalizer(new StringNormalizer(null, File.separator, "/"), OUTPUT_DIR, "---OUTPUT_DIR_PLACEHOLDER---"), LIB_DIR, "---LIB_DIR_PLACEHOLDER---");
    protected static final String JRE_HOME_DIR = Util.getJREDirectory();
    protected static final Main MAIN = new Main(null, null, false, null, null);
    private static boolean CASCADED_JARS_CREATED;

    public static boolean isJREVersionEqualTo(String compilerVersion) {
        String specVersion = System.getProperty("java.specification.version");
        return specVersion != null && Integer.valueOf(specVersion) == Integer.valueOf(compilerVersion);
    }

    public AbstractBatchCompilerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CASCADED_JARS_CREATED = false;
    }

    protected void createCascadedJars() throws IOException {
        if (CASCADED_JARS_CREATED) {
            return;
        }
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib2.jar\n", "p/S1.java", "package p;\npublic class S1 {\n}"}, LIB_DIR + "/lib1.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/B.java", "package p;\npublic class B {\n}", "p/R.java", "package p;\npublic class R {\n  public static final int R2 = 2;\n}"}, new String[]{"p/S2.java", "package p;\npublic class S2 {\n}"}, LIB_DIR + "/lib2.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/C.java", "package p;\npublic class C {\n}", "p/R.java", "package p;\npublic class R {\n  public static final int R3 = 3;\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib4.jar\n"}, LIB_DIR + "/lib3.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/D.java", "package p;\npublic class D {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib1.jar lib3.jar\n"}, LIB_DIR + "/lib4.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/C.java", "package p;\npublic class C {\n}", "p/R.java", "package p;\npublic class R {\n  public static final int R3 = 3;\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: s/lib6.jar\n"}, LIB_DIR + "/lib5.jar", CompilerOptions.getFirstSupportedJavaVersion());
        new File(LIB_DIR + "/s").mkdir();
        Util.createJar(new String[]{"p/D.java", "package p;\npublic class D {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: ../lib7.jar\n"}, LIB_DIR + "/s/lib6.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib2.jar\n"}, LIB_DIR + "/lib7.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/F.java", "package p;\npublic class F {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: " + LIB_DIR + "/lib3.jar lib1.jar\n"}, LIB_DIR + "/lib8.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/G.java", "package p;\npublic class G {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib1.jar\nClass-Path: lib3.jar\n"}, LIB_DIR + "/lib9.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, new String[]{"META-INF/MANIFEST.MF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib2.jar\n"}, LIB_DIR + "/lib10.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path:\n"}, LIB_DIR + "/lib11.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(null, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path:lib1.jar\n"}, LIB_DIR + "/lib12.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(null, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path:lib1.jar lib1.jar\n"}, LIB_DIR + "/lib13.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(null, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\n Class-Path: lib1.jar\n"}, LIB_DIR + "/lib14.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(null, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib1.jar"}, LIB_DIR + "/lib15.jar", CompilerOptions.getFirstSupportedJavaVersion());
        Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: \n lib2.jar\n", "p/S1.java", "package p;\npublic class S1 {\n}"}, LIB_DIR + "/lib16.jar", CompilerOptions.getFirstSupportedJavaVersion());
        new File(LIB_DIR + "/dir").mkdir();
        Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: ../lib2.jar\n"}, LIB_DIR + "/dir/lib17.jar", CompilerOptions.getFirstSupportedJavaVersion());
        CASCADED_JARS_CREATED = true;
    }

    protected String getLibraryClassesAsQuotedString() {
        String[] paths = Util.getJavaClassLibs();
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        int i = 0;
        int max = paths.length;
        while (i < max) {
            if (i != 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(paths[i]);
            ++i;
        }
        buffer.append('\"');
        return String.valueOf(buffer);
    }

    protected String getExtDirectory() {
        return JRE_HOME_DIR + "/lib/ext";
    }

    protected void runConformTest(String[] testFiles, String commandLine, String expectedSuccessOutOutputString, String expectedSuccessErrOutputString, boolean shouldFlushOutputDirectory) {
        this.runTest(true, testFiles, commandLine, expectedSuccessOutOutputString, expectedSuccessErrOutputString, shouldFlushOutputDirectory, null);
    }

    protected void runNegativeTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory) {
        this.runTest(false, testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, null);
    }

    protected void runProgressTest(String[] testFiles, String commandLine, String expectedOutOutputString, String expectedErrOutputString, String expectedProgress) {
        this.runTest(true, testFiles, commandLine, expectedOutOutputString, expectedErrOutputString, true, new TestCompilationProgress());
    }

    protected void runProgressTest(boolean shouldCompileOK, String[] testFiles, String commandLine, String expectedOutOutputString, String expectedErrOutputString, TestCompilationProgress progress, String expectedProgress) {
        this.runTest(shouldCompileOK, testFiles, commandLine, expectedOutOutputString, expectedErrOutputString, true, progress);
        String actualProgress = progress.toString();
        if (!this.semiNormalizedComparison(expectedProgress, actualProgress, outputDirNormalizer)) {
            System.out.println(Util.displayString(outputDirNormalizer.normalized(actualProgress), 2));
            AbstractBatchCompilerTest.assertEquals("Unexpected progress", expectedProgress, actualProgress);
        }
    }

    protected void runTest(boolean shouldCompileOK, String[] testFiles, Object extraArguments, String expectedOutOutputString, String expectedErrOutputString, boolean shouldFlushOutputDirectory, TestCompilationProgress progress) {
        boolean compileOK;
        block28: {
            File outputDirectory = new File(OUTPUT_DIR);
            if (shouldFlushOutputDirectory) {
                Util.flushDirectoryContent(outputDirectory);
            }
            try {
                if (!outputDirectory.isDirectory()) {
                    outputDirectory.mkdirs();
                }
                if (testFiles == null) break block28;
                int i = 0;
                while (i < testFiles.length) {
                    String fileName = OUTPUT_DIR + File.separator + testFiles[i];
                    File file = new File(fileName);
                    File innerOutputDirectory = file.getParentFile();
                    if (!innerOutputDirectory.isDirectory()) {
                        innerOutputDirectory.mkdirs();
                    }
                    try (PrintWriter sourceFileWriter = new PrintWriter(new FileOutputStream(file));){
                        sourceFileWriter.write(testFiles[i + 1]);
                    }
                    i += 2;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        String printerWritersNameRoot = OUTPUT_DIR + File.separator + this.testName();
        String outFileName = printerWritersNameRoot + "out.txt";
        String errFileName = printerWritersNameRoot + "err.txt";
        PrintWriter out = null;
        PrintWriter err = null;
        try {
            try {
                out = new PrintWriter(new FileOutputStream(outFileName));
                err = new PrintWriter(new FileOutputStream(errFileName));
            }
            catch (FileNotFoundException e) {
                System.out.println(this.getClass().getName() + "#" + this.getName());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            compileOK = this.invokeCompiler(out, err, extraArguments, progress);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (err != null) {
                err.close();
            }
        }
        String outOutputString = Util.fileContent(outFileName);
        String errOutputString = Util.fileContent(errFileName);
        boolean compareOK = false;
        boolean outCompareOK = false;
        boolean errCompareOK = false;
        if (compileOK == shouldCompileOK) {
            outCompareOK = this.semiNormalizedComparison(expectedOutOutputString, outOutputString, outputDirNormalizer);
            boolean bl = compareOK = outCompareOK && (errCompareOK = this.semiNormalizedComparison(expectedErrOutputString, errOutputString, outputDirNormalizer));
        }
        if (!outCompareOK) {
            AbstractBatchCompilerTest.assertEquals("outputDirNormalizer should not affect expectedOutOutput", expectedOutOutputString, outputDirNormalizer.normalized(expectedOutOutputString));
        }
        if (!errCompareOK) {
            AbstractBatchCompilerTest.assertEquals("outputDirNormalizer should not affect expectedErrOutput", expectedErrOutputString, outputDirNormalizer.normalized(expectedErrOutputString));
        }
        if (compileOK != shouldCompileOK || !compareOK) {
            System.out.println(this.getClass().getName() + "#" + this.getName());
            if (testFiles != null) {
                int i = 0;
                while (i < testFiles.length) {
                    System.out.print(testFiles[i]);
                    System.out.println(" [");
                    System.out.println(testFiles[i + 1]);
                    System.out.println("]");
                    i += 2;
                }
            }
        }
        if (compileOK != shouldCompileOK) {
            System.out.println(errOutputString);
        }
        if (compileOK == shouldCompileOK && !compareOK) {
            System.out.println("------------ [START OUT] ------------\n------------- Expected: -------------\n" + expectedOutOutputString + "\n------------- but was:  -------------\n" + outOutputString + "\n--------- (cut and paste:) ----------\n" + outputDirNormalizer.normalized(outOutputString) + "\n------------- [END OUT] -------------\n------------ [START ERR] ------------\n------------- Expected: -------------\n" + expectedErrOutputString + "\n------------- but was:  -------------\n" + errOutputString + "\n--------- (cut and paste:) ----------\n" + outputDirNormalizer.normalized(errOutputString) + "\n------------- [END ERR] -------------\n");
        }
        if (shouldCompileOK) {
            AbstractBatchCompilerTest.assertTrue((String)("Unexpected problems [out: " + outOutputString + "][err: " + errOutputString + "]"), (boolean)compileOK);
        } else {
            AbstractBatchCompilerTest.assertFalse((String)("Unexpected success: [out: " + outOutputString + "][err: " + errOutputString + "]"), (boolean)compileOK);
        }
        if (!outCompareOK) {
            AbstractBatchCompilerTest.assertEquals("Unexpected standard output for invocation with arguments [" + String.valueOf(extraArguments) + "]", expectedOutOutputString, outOutputString);
        }
        if (!errCompareOK) {
            AbstractBatchCompilerTest.assertEquals("Unexpected error output for invocation with arguments [" + String.valueOf(extraArguments) + "]", expectedErrOutputString, errOutputString);
        }
    }

    protected boolean invokeCompiler(PrintWriter out, PrintWriter err, Object extraArguments, TestCompilationProgress compilationProgress) {
        try {
            String[] tokenizedCommandLine = Main.tokenize((String)((String)extraArguments));
            return new Main(out, err, false, null, (CompilationProgress)compilationProgress).compile(tokenizedCommandLine);
        }
        catch (RuntimeException e) {
            System.out.println(this.getClass().getName() + "#" + this.getName());
            e.printStackTrace();
            throw e;
        }
    }

    protected void runTest(boolean shouldCompileOK, String[] testFiles, String commandLine, Matcher outOutputStringMatcher, Matcher errOutputStringMatcher, boolean shouldFlushOutputDirectory) {
        boolean compileOK;
        File outputDirectory = new File(OUTPUT_DIR);
        if (shouldFlushOutputDirectory) {
            Util.flushDirectoryContent(outputDirectory);
        }
        try {
            if (!outputDirectory.isDirectory()) {
                outputDirectory.mkdirs();
            }
            int i = 0;
            while (i < testFiles.length) {
                String fileName = OUTPUT_DIR + File.separator + testFiles[i];
                File file = new File(fileName);
                File innerOutputDirectory = file.getParentFile();
                if (!innerOutputDirectory.isDirectory()) {
                    innerOutputDirectory.mkdirs();
                }
                try (PrintWriter sourceFileWriter = new PrintWriter(new FileOutputStream(file));){
                    sourceFileWriter.write(testFiles[i + 1]);
                }
                i += 2;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        String printerWritersNameRoot = OUTPUT_DIR + File.separator + this.testName();
        String outFileName = printerWritersNameRoot + "out.txt";
        String errFileName = printerWritersNameRoot + "err.txt";
        PrintWriter out = null;
        PrintWriter err = null;
        try {
            Main batchCompiler;
            try {
                out = new PrintWriter(new FileOutputStream(outFileName));
                err = new PrintWriter(new FileOutputStream(errFileName));
                batchCompiler = new Main(out, err, false, null, null);
            }
            catch (FileNotFoundException e) {
                System.out.println(this.getClass().getName() + "#" + this.getName());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            try {
                String[] tokenizeCommandLine = Main.tokenize((String)commandLine);
                compileOK = batchCompiler.compile(tokenizeCommandLine);
            }
            catch (RuntimeException e) {
                boolean compileOK2 = false;
                System.out.println(this.getClass().getName() + "#" + this.getName());
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (err != null) {
                err.close();
            }
        }
        String outOutputString = Util.fileContent(outFileName);
        String errOutputString = Util.fileContent(errFileName);
        boolean compareOK = false;
        boolean outCompareOK = false;
        boolean errCompareOK = false;
        String expectedErrOutputString = null;
        String expectedOutOutputString = null;
        if (compileOK == shouldCompileOK) {
            if (outOutputStringMatcher == null) {
                outCompareOK = true;
            } else {
                outCompareOK = outOutputStringMatcher.match(outOutputString);
                expectedOutOutputString = outOutputStringMatcher.expected();
            }
            if (errOutputStringMatcher == null) {
                errCompareOK = true;
            } else {
                errCompareOK = errOutputStringMatcher.match(errOutputString);
                expectedErrOutputString = errOutputStringMatcher.expected();
            }
            boolean bl = compareOK = outCompareOK && errCompareOK;
        }
        if (compileOK != shouldCompileOK || !compareOK) {
            System.out.println(this.getClass().getName() + "#" + this.getName());
            int i = 0;
            while (i < testFiles.length) {
                System.out.print(testFiles[i]);
                System.out.println(" [");
                System.out.println(testFiles[i + 1]);
                System.out.println("]");
                i += 2;
            }
        }
        if (compileOK != shouldCompileOK) {
            System.out.println(errOutputString);
        }
        if (compileOK == shouldCompileOK && !compareOK) {
            System.out.println("------------ [START OUT] ------------\n------------- Expected: -------------\n" + expectedOutOutputString + "\n------------- but was:  -------------\n" + outOutputString + "\n--------- (cut and paste:) ----------\n" + Util.displayString(outputDirNormalizer.normalized(outOutputString)) + "\n------------- [END OUT] -------------\n------------ [START ERR] ------------\n------------- Expected: -------------\n" + expectedErrOutputString + "\n------------- but was:  -------------\n" + errOutputString + "\n--------- (cut and paste:) ----------\n" + Util.displayString(outputDirNormalizer.normalized(errOutputString)) + "\n------------- [END ERR] -------------\n");
        }
        if (shouldCompileOK) {
            AbstractBatchCompilerTest.assertTrue((String)("Unexpected problems: " + errOutputString), (boolean)compileOK);
        } else {
            AbstractBatchCompilerTest.assertTrue((String)("Unexpected success: " + errOutputString), (!compileOK ? 1 : 0) != 0);
        }
        if (!outCompareOK) {
            AbstractBatchCompilerTest.assertEquals("Unexpected standard output for invocation with arguments [" + commandLine + "]", expectedOutOutputString, outOutputString);
        }
        if (!errCompareOK) {
            AbstractBatchCompilerTest.assertEquals("Unexpected error output for invocation with arguments [" + commandLine + "]", expectedErrOutputString, errOutputString);
        }
    }

    protected void runClasspathTest(String classpathInput, String[] expectedClasspathEntries, String expectedError) {
        File outputDirectory = new File(OUTPUT_DIR);
        if (!outputDirectory.isDirectory()) {
            outputDirectory.mkdirs();
        }
        ArrayList paths = new ArrayList(4);
        try {
            new Main(new PrintWriter(System.out), new PrintWriter(System.err), true, null, null).processPathEntries(4, paths, classpathInput, null, true, false);
        }
        catch (IllegalArgumentException e) {
            if (expectedError == null) {
                AbstractBatchCompilerTest.fail((String)("unexpected invalid input exception: " + e.getMessage()));
            } else if (!expectedError.equals(e.getMessage())) {
                System.out.println("\"" + e.getMessage() + "\"");
                AbstractBatchCompilerTest.assertEquals(expectedError, e.getMessage());
            }
            return;
        }
        if (expectedError == null) {
            int l = paths.size();
            AbstractBatchCompilerTest.assertEquals((String)"unexpected classpaths entries number: ", (int)(expectedClasspathEntries == null ? 0 : expectedClasspathEntries.length / 3), (int)l);
            int i = 0;
            int j = 0;
            while (i < l) {
                ClasspathLocation result = (ClasspathLocation)paths.get(i);
                String expected = expectedClasspathEntries[j++];
                String actual = result.toString();
                if (!actual.equals("ClasspathDirectory " + expected + File.separator) && !actual.equals("Classpath for jar file " + expected)) {
                    AbstractBatchCompilerTest.assertEquals("dir/jar " + expected, actual);
                }
                expected = expectedClasspathEntries[j++];
                if (result.accessRuleSet == null) {
                    AbstractBatchCompilerTest.assertNull((String)("actual access rule is null instead of <" + expected + ">"), (Object)expected);
                } else if (!result.accessRuleSet.toString(false).startsWith("AccessRuleSet " + expected)) {
                    System.out.println("\"" + result.accessRuleSet.toString(false) + "\"");
                    AbstractBatchCompilerTest.fail((String)("inappropriate rules (expected " + expected + ", got " + result.accessRuleSet.toString(false)));
                }
                expected = expectedClasspathEntries[j++];
                if (expected == null) {
                    AbstractBatchCompilerTest.assertNull((Object)result.destinationPath);
                } else if (expected == "none" && result.destinationPath != "none") {
                    AbstractBatchCompilerTest.fail((String)"expected 'none' output directory");
                } else if (!expected.equals(result.destinationPath)) {
                    System.out.println("\"" + result.destinationPath + "\"");
                    AbstractBatchCompilerTest.assertEquals(expected, result.destinationPath);
                }
                ++i;
            }
        } else {
            AbstractBatchCompilerTest.fail((String)("missing error: " + expectedError));
        }
    }

    protected void checkWidth(String message, int width) {
        BufferedReader reader = new BufferedReader(new StringReader(message.replaceAll("\t", "    ")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                AbstractBatchCompilerTest.assertTrue((String)("line exceeds " + width + "characters: " + line), (line.length() <= width ? 1 : 0) != 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean equals(String a, String b) {
        StringBuilder aBuffer = new StringBuilder(a);
        StringBuilder bBuffer = new StringBuilder(b);
        int length = aBuffer.length();
        boolean result = true;
        int bLength = bBuffer.length();
        if (length != bLength) {
            System.err.println("a and b lengths differ");
            if (length > bLength) {
                length = bLength;
            }
            result = false;
        }
        int i = 0;
        while (i < length) {
            if (aBuffer.charAt(i) != bBuffer.charAt(i)) {
                int beforeStart = i - 5;
                int beforeEnd = i - 1;
                int afterStart = i + 1;
                int afterEnd = i + 5;
                if (beforeStart < 0) {
                    beforeStart = 0;
                    if (beforeEnd < 0) {
                        beforeEnd = 0;
                    }
                }
                if (afterEnd >= length) {
                    afterEnd = length - 1;
                    if (afterStart >= length) {
                        afterStart = length - 1;
                    }
                }
                System.err.println("a and b differ at rank: " + i + "\na: ..." + aBuffer.substring(beforeStart, beforeEnd) + "<" + aBuffer.charAt(i) + ">" + aBuffer.substring(afterStart, afterEnd) + "...\nb: ..." + bBuffer.substring(beforeStart, beforeEnd) + "<" + bBuffer.charAt(i) + ">" + bBuffer.substring(afterStart, afterEnd) + "...");
                return false;
            }
            ++i;
        }
        return result;
    }

    protected boolean semiNormalizedComparison(String keep, String normalize, Normalizer normalizer) {
        if (keep == null) {
            return normalize == null;
        }
        if (normalize == null) {
            return false;
        }
        return AbstractBatchCompilerTest.equals(keep, normalizer.normalized(normalize));
    }

    protected static abstract class Matcher {
        protected Matcher() {
        }

        abstract boolean match(String var1);

        abstract String expected();
    }

    protected static abstract class Normalizer {
        private final Normalizer nextInChain;

        Normalizer(Normalizer nextInChain) {
            this.nextInChain = nextInChain;
        }

        String normalized(String originalValue) {
            String result = this.nextInChain == null ? Util.convertToIndependantLineDelimiter(originalValue) : this.nextInChain.normalized(originalValue);
            return result;
        }
    }

    protected static class StringNormalizer
    extends Normalizer {
        private final String match;
        private final int matchLength;
        private final String placeholder;

        StringNormalizer(Normalizer nextInChain, String match, String placeholder) {
            super(nextInChain);
            this.match = match;
            this.matchLength = match.length();
            this.placeholder = placeholder;
        }

        @Override
        String normalized(String originalValue) {
            int nextOccurrenceIndex;
            StringBuilder normalizedValueBuffer = new StringBuilder(originalValue);
            while ((nextOccurrenceIndex = normalizedValueBuffer.indexOf(this.match)) != -1) {
                normalizedValueBuffer.replace(nextOccurrenceIndex, nextOccurrenceIndex + this.matchLength, this.placeholder);
            }
            String result = super.normalized(normalizedValueBuffer.toString());
            return result;
        }
    }

    protected static class TestCompilationProgress
    extends CompilationProgress {
        boolean isCanceled = false;
        int workedSoFar = 0;
        StringBuilder buffer = new StringBuilder();

        protected TestCompilationProgress() {
        }

        public void begin(int remainingWork) {
            this.buffer.append("----------\n[worked: 0 - remaining: ").append(remainingWork).append("]\n");
        }

        public void done() {
            this.buffer.append("----------\n");
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void setTaskName(String name) {
            this.buffer.append(name).append('\n');
        }

        public String toString() {
            return this.buffer.toString();
        }

        public void worked(int workIncrement, int remainingWork) {
            this.workedSoFar += workIncrement;
            this.buffer.append("[worked: ").append(this.workedSoFar).append(" - remaining: ").append(remainingWork).append("]\n");
        }
    }
}

