/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class AbstractComparableTest
extends AbstractRegressionTest {
    protected static final String GOOGLE_INJECT_NAME = "com/google/inject/Inject.java";
    protected static final String GOOGLE_INJECT_CONTENT = "package com.google.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {\n\n  boolean optional() default false;\n}";
    protected static final String JAVAX_INJECT_NAME = "javax/inject/Inject.java";
    protected static final String JAVAX_INJECT_CONTENT = "package javax.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {}\n";
    protected static final String JAKARTA_INJECT_NAME = "jakarta/inject/Inject.java";
    protected static final String JAKARTA_INJECT_CONTENT = "package jakarta.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {}\n";
    protected static final String SPRINGFRAMEWORK_AUTOWIRED_NAME = "org/springframework/beans/factory/annotation/Autowired.java";
    protected static final String SPRINGFRAMEWORK_AUTOWIRED_CONTENT = "package org.springframework.beans.factory.annotation;\nimport java.lang.annotation.Documented;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\npublic @interface Autowired {\n\n\tboolean required() default true;\n\n}";
    protected static final String JUNIT_METHODSOURCE_NAME = "org/junit/jupiter/params/provider/MethodSource.java";
    protected static final String JUNIT_METHODSOURCE_CONTENT = "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}";

    public static Test buildComparableTestSuite(Class evaluationTestClass) {
        Test suite = AbstractComparableTest.buildMinimalComplianceTestSuite(evaluationTestClass, 32);
        TESTS_COUNTERS.put(evaluationTestClass.getName(), suite.countTestCases());
        return suite;
    }

    public AbstractComparableTest(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        return options;
    }

    protected String intersection(String ... types) {
        if (isJRE12Plus) {
            int index = -1;
            int i = 0;
            while (i < types.length) {
                if (!(!types[i].startsWith("Comparable") || types[i].endsWith("ConstantDesc") || types.length > i + 1 && types[i + 1].startsWith("CharSequence"))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                String[] temp = new String[types.length + 2];
                System.arraycopy(types, 0, temp, 0, ++index);
                temp[index] = "Constable";
                temp[index + 1] = "ConstantDesc";
                if (index < types.length) {
                    System.arraycopy(types, index, temp, index + 2, types.length - index);
                }
                types = temp;
            }
        }
        return String.join((CharSequence)" & ", types);
    }
}

