/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFormatException;

public abstract class AbstractModuleCompilationTest
extends AbstractBatchCompilerTest {
    protected static final String JAVAC_SOURCE_9_OPTIONS = "-source 9 -Xlint:-options";

    public AbstractModuleCompilationTest(String name) {
        super(name);
    }

    protected String getSourceDir() {
        return OUTPUT_DIR + File.separatorChar + "src";
    }

    protected String getEcjOutputDir() {
        return OUTPUT_DIR + File.separatorChar + "bin";
    }

    protected String getJavacOutputDir() {
        return OUTPUT_DIR + File.separatorChar + "javac";
    }

    protected void writeFileCollecting(List<String> collectedFiles, String directoryName, String fileName, String source) {
        this.writeFile(directoryName, fileName, source);
        collectedFiles.add(directoryName + File.separator + fileName);
    }

    protected void writeFile(String directoryName, String fileName, String source) {
        File directory = new File(directoryName);
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directoryName);
            return;
        }
        String filePath = directory.getAbsolutePath() + File.separator + fileName;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    protected void runConformModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString) {
        this.runConformModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    protected void runConformModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, AbstractRegressionTest.JavacTestOptions javacTestOptions) {
        for (String file : testFileNames) {
            commandLine.append(" \"").append(file).append("\"");
        }
        this.runConformModuleTest(new String[0], commandLine.toString(), expectedFailureOutOutputString, expectedFailureErrOutputString, false, javacTestOptions, null);
    }

    protected Set<String> runConformModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory) {
        return this.runConformModuleTest(testFiles, commandLine, expectedFailureErrOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, AbstractRegressionTest.JavacTestOptions.DEFAULT, null);
    }

    protected Set<String> runConformModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, AbstractRegressionTest.JavacTestOptions options, String javacCommandLine) {
        String ecjOutput = this.getEcjOutputDir();
        File ecjOutFile = new File(ecjOutput);
        if (!ecjOutFile.exists()) {
            ecjOutFile.mkdir();
        }
        String ecjCommandLine = commandLine.contains("-d ") ? commandLine : " -d " + ecjOutput + " " + commandLine;
        this.runConformTest(testFiles, ecjCommandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory);
        if (this.shouldRunJavac()) {
            HashSet<String> outFiles = new HashSet<String>();
            this.walkOutFiles(ecjOutput, outFiles, true);
            String javacOutput = this.getJavacOutputDir();
            File javacOutputDir = new File(javacOutput);
            String[] testFileNames = new String[testFiles.length / 2];
            int i = 0;
            while (i < testFileNames.length) {
                testFileNames[i] = testFiles[i * 2];
                ++i;
            }
            if (javacCommandLine == null) {
                javacCommandLine = " -d " + javacOutput + " " + this.adjustForJavac(commandLine, null);
            }
            for (AbstractRegressionTest.JavacCompiler javacCompiler : javacCompilers) {
                if (javacCompiler.compliance < 0x350000L) continue;
                if (options.skip(javacCompiler)) {
                    System.err.println("Skip testing javac in " + this.testName());
                    continue;
                }
                StringBuilder log = new StringBuilder();
                try {
                    long compileResult = javacCompiler.compile(javacOutputDir, (String)javacCommandLine, testFileNames, log, false);
                    log = this.trimJavacLog(log);
                    if (compileResult != 0L && !log.isEmpty()) {
                        AbstractRegressionTest.JavacTestOptions.Excuse excuse = options.excuseFor(javacCompiler);
                        boolean hasError = log.toString().lines().anyMatch(l -> l.contains("error:"));
                        int mismatch = hasError ? 4 : 32;
                        this.handleMismatch(javacCompiler, this.testName(), testFiles, "", expectedFailureOutOutputString, expectedFailureErrOutputString, log, "", "", excuse, mismatch);
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new AssertionFailedError(e.getMessage());
                }
                Set<String> expectedFiles = outFiles.stream().map(s -> s.replace(ecjOutput, javacOutput)).collect(Collectors.toSet());
                this.walkOutFiles(javacOutput, expectedFiles, false);
                for (String missingFile : expectedFiles) {
                    System.err.println("Missing output file from javac:    " + missingFile);
                }
            }
            return outFiles;
        }
        return null;
    }

    protected StringBuilder trimJavacLog(StringBuilder log) {
        return log;
    }

    protected void runNegativeModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, String javacErrorMatch) {
        this.runNegativeModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, javacErrorMatch, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    protected void runNegativeModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, String javacErrorMatch, AbstractRegressionTest.JavacTestOptions options) {
        for (String file : testFileNames) {
            commandLine.append(" \"").append(file).append("\"");
        }
        this.runNegativeModuleTest(new String[0], commandLine.toString(), expectedFailureOutOutputString, expectedFailureErrOutputString, false, javacErrorMatch, options);
    }

    protected void runNegativeModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch) {
        String prefix = "src" + File.separatorChar;
        int i = 0;
        while (i + 1 < testFiles.length) {
            testFiles[i] = prefix + testFiles[i];
            i += 2;
        }
        this.runNegativeModuleTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    void runNegativeModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch, AbstractRegressionTest.JavacTestOptions options) {
        String ecjOutput = this.getEcjOutputDir();
        File ecjOutFile = new File(ecjOutput);
        if (!ecjOutFile.exists()) {
            ecjOutFile.mkdir();
        }
        String ecjCommandLine = commandLine.contains("-d ") ? commandLine : " -d " + ecjOutput + " " + commandLine;
        this.runNegativeTest(testFiles, ecjCommandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory);
        if (this.shouldRunJavac()) {
            HashSet<String> outFiles = new HashSet<String>();
            this.walkOutFiles(ecjOutput, outFiles, true);
            String javacOutput = this.getJavacOutputDir();
            File outputDir = new File(javacOutput);
            String[] testFileNames = new String[testFiles.length / 2];
            int i = 0;
            while (i < testFileNames.length) {
                testFileNames[i] = testFiles[i * 2];
                ++i;
            }
            for (AbstractRegressionTest.JavacCompiler javacCompiler : javacCompilers) {
                if (javacCompiler.compliance < 0x350000L) continue;
                AbstractRegressionTest.JavacTestOptions.Excuse excuse = options.excuseFor(javacCompiler);
                String javacCommandLine = " -d " + javacOutput + " " + this.adjustForJavac(commandLine, null);
                StringBuilder log = new StringBuilder();
                int mismatch = 0;
                try {
                    long compileResult = javacCompiler.compile(outputDir, javacCommandLine, testFileNames, log, false);
                    if (compileResult == 0L) {
                        mismatch = 1;
                        javacErrorMatch = expectedFailureErrOutputString;
                        System.err.println("Previous error was from " + this.testName());
                    } else if (!log.toString().contains(javacErrorMatch)) {
                        mismatch = 4096;
                        System.err.println(this.testName() + ": Error match " + javacErrorMatch + " not found in \n" + log.toString());
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new AssertionFailedError(e.getMessage());
                }
                this.handleMismatch(javacCompiler, this.testName(), testFiles, javacErrorMatch, "", "", log, "", "", excuse, mismatch);
                Set<String> expectedFiles = outFiles.stream().map(s -> s.replace(ecjOutput, javacOutput)).collect(Collectors.toSet());
                this.walkOutFiles(javacOutput, expectedFiles, false);
                for (String missingFile : expectedFiles) {
                    System.out.println("Missing output file from javac in negative test:    " + missingFile);
                }
            }
        }
    }

    protected String adjustForJavac(String commandLine, String versionOptions) {
        String[] tokens = commandLine.split(" ");
        StringBuilder buf = new StringBuilder();
        boolean skipNext = false;
        int i = 0;
        while (i < tokens.length) {
            block24: {
                block23: {
                    if (!skipNext) break block23;
                    skipNext = false;
                    break block24;
                }
                switch (tokens[i].trim()) {
                    case "-9": {
                        if (versionOptions != null) break;
                        buf.append(' ').append(" --release 9 ");
                        break;
                    }
                    case "-8": {
                        if (versionOptions != null) break;
                        buf.append(' ').append(" --release 8 ");
                        break;
                    }
                    case "-22": {
                        if (versionOptions != null) break;
                        buf.append(' ').append(" --release 22 ");
                        break;
                    }
                    case "-23": {
                        if (versionOptions != null) break;
                        buf.append(' ').append(" --release 23 ");
                        break;
                    }
                    case "-24": {
                        if (versionOptions != null) break;
                        buf.append(' ').append(" --release 24 ");
                        break;
                    }
                    default: {
                        if (tokens[i].startsWith("-warn") || tokens[i].startsWith("-err") || tokens[i].startsWith("-info")) {
                            if (!tokens[i].contains("exports") || tokens[i].contains("-exports")) break;
                            buf.append(" -Xlint:exports ");
                            break;
                        }
                        if (tokens[i].trim().equals("-classNames")) {
                            skipNext = true;
                            break;
                        }
                        buf.append(tokens[i]).append(' ');
                    }
                }
            }
            ++i;
        }
        if (versionOptions != null) {
            buf.append(versionOptions);
        }
        return buf.toString();
    }

    private void walkOutFiles(String outputLocation, final Set<String> fileNames, final boolean add) {
        if (!new File(outputLocation).exists()) {
            return;
        }
        try {
            Files.walkFileTree(Path.of(outputLocation, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(".class")) {
                        if (add) {
                            fileNames.add(file.toString());
                        } else if (!fileNames.remove(file.toString())) {
                            System.err.println("Unexpected output file from javac: " + file.toString());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AssertionFailedError(e.getMessage());
        }
    }

    protected void assertClassFile(String msg, String fileName, Set<String> classFiles) {
        if (classFiles != null) {
            AbstractModuleCompilationTest.assertTrue((String)msg, (boolean)classFiles.contains(fileName));
        } else {
            AbstractModuleCompilationTest.assertTrue((String)msg, (boolean)new File(fileName).exists());
        }
    }

    @Override
    protected void verifyClassFile(String expectedOutput, String classFileName, int mode) throws IOException, ClassFormatException {
        this.verifyClassFile(expectedOutput, classFileName, mode, false);
    }

    protected void verifyClassFile(String expectedOutput, String classFileName, int mode, boolean skipJavac) throws IOException, ClassFormatException {
        AbstractModuleCompilationTest.verifyClassFile(expectedOutput, null, this.getEcjOutputDir() + File.separatorChar + classFileName, mode);
        if (!skipJavac && this.shouldRunJavac()) {
            AbstractModuleCompilationTest.verifyClassFile(expectedOutput, null, this.getJavacOutputDir() + File.separatorChar + classFileName, mode);
        }
    }

    class Runner
    extends AbstractRegressionTest.Runner {
        StringBuilder commandLine;
        String outputDir;
        List<String> fileNames;
        String javacVersionOptions;

        Runner() {
            super(AbstractModuleCompilationTest.this);
            this.commandLine = new StringBuilder();
            this.outputDir = OUTPUT_DIR;
            this.fileNames = new ArrayList<String>();
            this.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DEFAULT;
            this.expectedOutputString = "";
            this.expectedErrorString = "";
        }

        void createFile(String directoryName, String fileName, String source) {
            AbstractModuleCompilationTest.this.writeFileCollecting(this.fileNames, directoryName, fileName, source);
        }

        Set<String> runConformModuleTest() {
            if (!this.fileNames.isEmpty()) {
                this.shouldFlushOutputDirectory = false;
                if (this.testFiles == null) {
                    this.testFiles = new String[0];
                }
                for (String fileName : this.fileNames) {
                    this.commandLine.append(" \"").append(fileName).append("\"");
                }
            }
            String commandLineString = this.commandLine.toString();
            String javacCommandLine = AbstractModuleCompilationTest.this.adjustForJavac(commandLineString, this.javacVersionOptions);
            return AbstractModuleCompilationTest.this.runConformModuleTest(this.testFiles, commandLineString, this.expectedOutputString, this.expectedErrorString, this.shouldFlushOutputDirectory, this.javacTestOptions, javacCommandLine);
        }
    }
}

