/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractNullAnnotationTest
extends AbstractComparableTest {
    String[] LIBS;
    static final String CUSTOM_NONNULL_NAME = "org/foo/NonNull.java";
    static final String CUSTOM_NONNULL_CONTENT = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n";
    static final String CUSTOM_NONNULL_CONTENT_JSR308 = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface NonNull {\n}\n";
    static final String CUSTOM_NULLABLE_NAME = "org/foo/Nullable.java";
    static final String CUSTOM_NULLABLE_CONTENT = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n";
    static final String CUSTOM_NULLABLE_CONTENT_JSR308 = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Nullable {\n}\n";
    static final String CUSTOM_NNBD_NAME = "org/foo/NonNullByDefault.java";
    static final String CUSTOM_NNBD_CONTENT = "package org.foo;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({PACKAGE, TYPE, METHOD, CONSTRUCTOR })\npublic @interface NonNullByDefault {\n}\n";
    static boolean setNullRelatedOptions = true;

    public AbstractNullAnnotationTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setUpAnnotationLib();
    }

    protected void setUpAnnotationLib() throws IOException {
        if (this.LIBS == null) {
            String[] defaultLibs = this.getDefaultClassPaths();
            int len = defaultLibs.length;
            this.LIBS = new String[len + 1];
            System.arraycopy(defaultLibs, 0, this.LIBS, 0, len);
            this.LIBS[len] = this.getAnnotationLibPath();
            Bundle[] bundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().getBundles();
            File bundleFile = (File)Arrays.stream(bundles).filter(b -> "org.eclipse.jdt.annotation".equals(b.getSymbolicName())).findFirst().flatMap(FileLocator::getBundleFileLocation).orElseThrow();
            this.LIBS[len] = bundleFile.isDirectory() ? bundleFile.getPath() + "/bin" : bundleFile.getPath();
        }
    }

    protected String getAnnotationLibPath() throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jdt.annotation");
        File bundleFile = (File)FileLocator.getBundleFileLocation((Bundle)bundle).get();
        if (bundleFile.isDirectory()) {
            return bundleFile.getPath() + "/bin";
        }
        return bundleFile.getPath();
    }

    public static String getAnnotationV1LibPath() throws IOException {
        URL libEntry = Platform.getBundle((String)"org.eclipse.jdt.core.tests.compiler").getEntry("/lib/org.eclipse.jdt.annotation_1.2.100.v20241001-0914.jar");
        return FileLocator.toFileURL((URL)libEntry).getPath();
    }

    @Override
    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        if (setNullRelatedOptions) {
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", "enabled");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
            defaultOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "warning");
        }
        return defaultOptions;
    }

    protected void runNegativeNullTest(String[] sourceFiles, String expectedCompileError, String[] libs, boolean shouldFlush, Map options) {
        this.runNegativeTest(sourceFiles, expectedCompileError, libs, shouldFlush, options, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    void runNegativeTestWithLibs(String[] testFiles, String expectedErrorLog) {
        this.runNegativeTestWithLibs(false, testFiles, this.getCompilerOptions(), expectedErrorLog, false);
    }

    void runNegativeTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedErrorLog) {
        this.runNegativeTestWithLibs(shouldFlushOutputDirectory, testFiles, customOptions, expectedErrorLog, false);
    }

    void runNegativeTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedErrorLog, boolean skipJavaC) {
        this.runNegativeTest(shouldFlushOutputDirectory, testFiles, this.LIBS, customOptions, expectedErrorLog, skipJavaC ? AbstractRegressionTest.JavacTestOptions.SKIP : AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    void runNegativeTestWithLibs(String[] testFiles, Map customOptions, String expectedErrorLog) {
        this.runNegativeTestWithLibs(false, testFiles, customOptions, expectedErrorLog);
    }

    void runNegativeTestWithLibs(String[] testFiles, Map customOptions, String expectedErrorLog, boolean skipJavac) {
        this.runNegativeTestWithLibs(false, testFiles, customOptions, expectedErrorLog, skipJavac);
    }

    void runConformTestWithLibs(String[] testFiles, Map customOptions, String expectedCompilerLog) {
        this.runConformTestWithLibs(true, testFiles, customOptions, expectedCompilerLog);
    }

    void runConformTestWithLibs(String[] testFiles, Map customOptions, String expectedCompilerLog, String expectedOutput) {
        this.runConformTestWithLibs(true, testFiles, customOptions, expectedCompilerLog, expectedOutput);
    }

    void runConformTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedCompilerLog, String expectedOutput) {
        this.runConformTest(shouldFlushOutputDirectory, testFiles, this.LIBS, customOptions, expectedCompilerLog, expectedOutput, "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    void runConformTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedCompilerLog) {
        this.runConformTest(shouldFlushOutputDirectory, testFiles, this.LIBS, customOptions, expectedCompilerLog, "", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    void runWarningTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedCompilerLog) {
        this.runWarningTestWithLibs(shouldFlushOutputDirectory, testFiles, customOptions, expectedCompilerLog, "");
    }

    void runWarningTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedCompilerLog, String expectedOutput) {
        this.runConformTest(shouldFlushOutputDirectory, testFiles, this.LIBS, customOptions, expectedCompilerLog, expectedOutput, "", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    void runConformTest(String[] testFiles, Map customOptions, String expectedOutputString) {
        this.runConformTest(testFiles, expectedOutputString, null, true, null, customOptions, null);
    }
}

