/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.TypeElement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.compiler.regression.Requestor;
import org.eclipse.jdt.core.tests.junit.extension.StopableTestCase;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.TestVerifier;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.eclipse.jdt.internal.core.util.Messages;
import org.osgi.framework.Bundle;

public abstract class AbstractRegressionTest
extends AbstractCompilerTest
implements StopableTestCase {
    static final String[] env = (String[])System.getenv().entrySet().stream().filter(e -> !"JAVA_TOOL_OPTIONS".equals(e.getKey()) && !"_JAVA_OPTIONS".equals(e.getKey())).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
    protected static int[] DIFF_COUNTERS = new int[3];
    protected static final String EVAL_DIRECTORY = org.eclipse.jdt.core.tests.util.Util.getOutputDirectory() + File.separator + "eval";
    public static int INDENT = 2;
    protected static final String JAVA_NAME = File.pathSeparatorChar == ':' ? "java" : "java.exe";
    protected static final String JAVAC_NAME = File.pathSeparatorChar == ':' ? "javac" : "javac.exe";
    protected static String JAVAC_OUTPUT_DIR_NAME = org.eclipse.jdt.core.tests.util.Util.getOutputDirectory() + File.separator + "javac";
    static File JAVAC_OUTPUT_DIR;
    protected static String javacCommandLineHeader;
    protected static PrintWriter javacFullLog;
    private static String javacFullLogFileName;
    protected static String javaCommandLineHeader;
    protected static boolean javacTestErrorFlag;
    protected static String javacTestName;
    protected static IPath jdkRootDirPath;
    protected static List<JavacCompiler> javacCompilers;
    public static final String OUTPUT_DIR;
    public static final String LIB_DIR;
    public static final String PACKAGE_INFO_NAME;
    public static final String MODULE_INFO_NAME;
    public static boolean SHIFT;
    public static String PREVIEW_ALLOWED_LEVEL;
    protected static final String SOURCE_DIRECTORY;
    protected String[] classpaths;
    protected boolean createdVerifier;
    protected INameEnvironment javaClassLib;
    protected TestVerifier verifier;
    protected boolean shouldSwallowCaptureId;

    static {
        javacCompilers = null;
        OUTPUT_DIR = org.eclipse.jdt.core.tests.util.Util.getOutputDirectory() + File.separator + "regression";
        LIB_DIR = org.eclipse.jdt.core.tests.util.Util.getOutputDirectory() + File.separator + "lib";
        PACKAGE_INFO_NAME = new String(TypeConstants.PACKAGE_INFO_NAME);
        MODULE_INFO_NAME = new String(TypeConstants.MODULE_INFO_NAME);
        SHIFT = false;
        PREVIEW_ALLOWED_LEVEL = JavaCore.latestSupportedJavaVersion();
        SOURCE_DIRECTORY = org.eclipse.jdt.core.tests.util.Util.getOutputDirectory() + File.separator + "source";
    }

    public AbstractRegressionTest(String name) {
        super(name);
    }

    protected static void buildMinimalComplianceTestSuite(int minimalCompliance, int inheritedDepth, TestSuite suite, Class<?> evaluationTestClass) {
        int complianceLevels = AbstractRegressionTest.getPossibleComplianceLevels();
        int[][] nArray = complianceTestLevelMapping;
        int n = complianceTestLevelMapping.length;
        int n2 = 0;
        while (n2 < n) {
            int[] map = nArray[n2];
            if ((complianceLevels & map[0]) != 0) {
                long complianceLevelForJavaVersion = ClassFileConstants.getComplianceLevelForJavaVersion((int)map[1]);
                AbstractRegressionTest.checkCompliance(evaluationTestClass, minimalCompliance, suite, complianceLevels, inheritedDepth, map[0], map[1], AbstractRegressionTest.getVersionString(complianceLevelForJavaVersion));
            }
            ++n2;
        }
    }

    protected static void checkCompliance(Class<?> evaluationTestClass, int minimalCompliance, TestSuite suite, int complianceLevels, int inheritedDepth, int abstractCompilerTestCompliance, int classFileConstantsVersion, String release) {
        int lev = complianceLevels & abstractCompilerTestCompliance;
        if (lev != 0) {
            if (lev < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + release + "!");
            } else {
                suite.addTest(AbstractRegressionTest.buildUniqueComplianceTestSuite(evaluationTestClass, ClassFileConstants.getComplianceLevelForJavaVersion((int)classFileConstantsVersion), inheritedDepth));
            }
        }
    }

    public static Test buildUniqueComplianceTestSuite(Class<?> evaluationTestClass, long uniqueCompliance, int inheritedDepth) {
        long highestLevel = AbstractRegressionTest.highestComplianceLevels();
        if (highestLevel < uniqueCompliance) {
            String complianceString = highestLevel == 0x360000L ? "10" : (highestLevel == 0x350000L ? "9" : (highestLevel <= CompilerOptions.getFirstSupportedJdkLevel() ? CompilerOptions.getFirstSupportedJavaVersion() : ((highestLevel = ClassFileConstants.getLatestJDKLevel()) > 0L ? CompilerOptions.versionFromJdkLevel((long)highestLevel) : "unknown")));
            System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + complianceString + "!");
            return new TestSuite();
        }
        RegressionTestSetup complianceSuite = new RegressionTestSetup(uniqueCompliance);
        List tests = AbstractRegressionTest.buildTestsList(evaluationTestClass, inheritedDepth);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            complianceSuite.addTest((Test)tests.get(index));
            ++index;
        }
        return complianceSuite;
    }

    protected boolean checkPreviewAllowed() {
        return this.complianceLevel == ClassFileConstants.getLatestJDKLevel();
    }

    protected void checkClassFile(String className, String source, String expectedOutput) throws ClassFormatException, IOException {
        this.checkClassFile("", className, source, expectedOutput, 4);
    }

    protected void checkClassFile(String className, String source, String expectedOutput, int mode) throws ClassFormatException, IOException {
        this.checkClassFile("", className, source, expectedOutput, mode);
    }

    protected void checkClassFile(String directoryName, String className, String disassembledClassName, String source, String expectedOutput, int mode, boolean suppressConsole) throws ClassFormatException, IOException {
        this.compileAndDeploy(source, directoryName, className, suppressConsole);
        try {
            File directory = new File(EVAL_DIRECTORY, directoryName);
            if (!directory.exists()) {
                AbstractRegressionTest.assertTrue((String)(".class file not generated properly in " + String.valueOf(directory)), (boolean)false);
            }
            File f = new File(directory, disassembledClassName + ".class");
            byte[] classFileBytes = Util.getFileByteContent((File)f);
            ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
            String result = disassembler.disassemble(classFileBytes, "\n", mode);
            int index = result.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
            }
            if (index == -1) {
                AbstractRegressionTest.assertEquals("Wrong contents", expectedOutput, result);
            }
            try {
                ClassFileReader.read((byte[])Files.readAllBytes(f.toPath()), (String)(className + ".class"), (boolean)true);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        finally {
            this.removeTempClass(className);
        }
    }

    protected void checkClassFile(String directoryName, String className, String source, String expectedOutput, int mode) throws ClassFormatException, IOException {
        this.checkClassFile(directoryName, className, className, source, expectedOutput, mode, false);
    }

    protected ClassFileReader getInternalClassFile(String directoryName, String className, String disassembledClassName, String source) throws ClassFormatException, IOException {
        this.compileAndDeploy(source, directoryName, className, true);
        try {
            File directory = new File(EVAL_DIRECTORY, directoryName);
            if (!directory.exists()) {
                AbstractRegressionTest.assertTrue((String)(".class file not generated properly in " + String.valueOf(directory)), (boolean)false);
            }
            File f = new File(directory, disassembledClassName + ".class");
            ClassFileReader classFileReader = null;
            try {
                classFileReader = ClassFileReader.read((byte[])Files.readAllBytes(f.toPath()), (String)(className + ".class"), (boolean)true);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            ClassFileReader classFileReader2 = classFileReader;
            return classFileReader2;
        }
        finally {
            this.removeTempClass(className);
        }
    }

    protected void checkDisassembledClassFile(String fileName, String className, String expectedOutput) throws Exception {
        this.checkDisassembledClassFile(fileName, className, expectedOutput, 1);
    }

    protected void checkDisassembledClassFile(String fileName, String className, String expectedOutput, int mode) throws Exception {
        File classFile = new File(fileName);
        if (!classFile.exists()) {
            AbstractRegressionTest.assertTrue((String)".class file doesn't exist", (boolean)false);
        }
        byte[] classFileBytes = Util.getFileByteContent((File)classFile);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", mode);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 2));
        }
        if (index == -1) {
            AbstractRegressionTest.assertEquals("Wrong contents", expectedOutput, result);
        }
        if ((index = result.indexOf(Messages.classformat_classformatexception)) != -1) {
            int start = Math.max(0, index - 300);
            int end = index + Messages.classformat_classformatexception.length();
            AbstractRegressionTest.fail((String)("ClassFormatException swallowed in Disassembler:\n..." + result.substring(start, end)));
        }
        ClassFileReader.read((byte[])Files.readAllBytes(classFile.toPath()), (String)(className + ".class"), (boolean)true);
    }

    protected static void verifyClassFile(String expectedOutput, String unexpectedOutput, String classFileName, int mode) throws IOException, ClassFormatException {
        int index;
        if (!((String)classFileName).startsWith(OUTPUT_DIR)) {
            classFileName = OUTPUT_DIR + File.separator + (String)classFileName;
        }
        File f = new File((String)classFileName);
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", mode);
        if (expectedOutput != null) {
            index = result.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
                System.out.println("...");
            }
            if (index == -1) {
                AbstractRegressionTest.assertEquals("Wrong contents", expectedOutput, result);
            }
        }
        if (unexpectedOutput != null) {
            index = result.indexOf(unexpectedOutput);
            AbstractRegressionTest.assertTrue((String)"Unexpected output found", (index == -1 ? 1 : 0) != 0);
        }
    }

    protected void verifyNegativeClassFile(String unExpectedOutput, String classFileName, int mode) throws IOException, ClassFormatException {
        AbstractRegressionTest.verifyClassFile(null, unExpectedOutput, classFileName, mode);
    }

    protected void verifyClassFile(String expectedOutput, String classFileName, int mode) throws IOException, ClassFormatException {
        AbstractRegressionTest.verifyClassFile(expectedOutput, null, classFileName, mode);
    }

    protected void compileAndDeploy(String source, String directoryName, String className, boolean suppressConsole) {
        String processAnnot;
        File directory = new File(SOURCE_DIRECTORY);
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + SOURCE_DIRECTORY);
            return;
        }
        if (directoryName != null && directoryName.length() != 0 && !(directory = new File(SOURCE_DIRECTORY, directoryName)).exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + String.valueOf(directory));
            return;
        }
        String fileName = directory.getAbsolutePath() + File.separator + className + ".java";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StringBuilder buffer = new StringBuilder().append("\"").append(fileName).append("\" -d \"").append(EVAL_DIRECTORY);
        String string = processAnnot = this.enableAPT ? "" : "-proc:none";
        if (this.complianceLevel == 0x340000L) {
            buffer.append("\" -1.8 " + processAnnot);
        } else if (this.complianceLevel == 0x350000L) {
            buffer.append("\" -9 " + processAnnot);
        } else if (this.complianceLevel == 0x360000L) {
            buffer.append("\" -10 " + processAnnot);
        } else {
            int major = (int)(this.complianceLevel >> 16);
            buffer.append("\" -" + (major - 44));
        }
        if (this.complianceLevel == ClassFileConstants.getLatestJDKLevel() && this.enablePreview) {
            buffer.append(" --enable-preview ");
        }
        buffer.append(" -preserveAllLocals -proceedOnError -nowarn -g -classpath \"").append(org.eclipse.jdt.core.tests.util.Util.getJavaClassLibsAsString()).append(SOURCE_DIRECTORY).append("\"");
        OutputStream out = System.out;
        OutputStream err = System.err;
        if (suppressConsole) {
            out = err = new OutputStream(){

                @Override
                public void write(int b) {
                }
            };
        }
        BatchCompiler.compile((String)buffer.toString(), (PrintWriter)new PrintWriter(out), (PrintWriter)new PrintWriter(err), null);
    }

    protected void checkCompilerLog(String[] testFiles, Requestor requestor, String[] alternatePlatformIndependantExpectedLogs, Throwable exception) {
        String computedProblemLog = org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(requestor.problemLog.toString());
        if (this.shouldSwallowCaptureId) {
            computedProblemLog = Pattern.compile("capture#(\\d+)").matcher(computedProblemLog).replaceAll("capture");
        }
        ProblemLog problemLog = new ProblemLog(computedProblemLog);
        int i = 0;
        while (i < alternatePlatformIndependantExpectedLogs.length) {
            if (problemLog.sameAs(alternatePlatformIndependantExpectedLogs[i])) {
                return;
            }
            ++i;
        }
        this.logTestTitle();
        System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(computedProblemLog, INDENT, SHIFT));
        this.logTestFiles(false, testFiles);
        if (exception == null) {
            AbstractRegressionTest.assertEquals("Invalid problem log ", alternatePlatformIndependantExpectedLogs[i - 1], computedProblemLog);
        }
    }

    protected void dualPrintln(String message) {
        System.out.println(message);
        javacFullLog.println(message);
    }

    protected void executeClass(String sourceFile, String expectedSuccessOutputString, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor) {
        String className = sourceFile.substring(0, sourceFile.length() - 5).replace('/', '.').replace('\\', '.');
        if (className.endsWith(PACKAGE_INFO_NAME)) {
            return;
        }
        if (vmArguments != null) {
            if (this.verifier != null) {
                this.verifier.shutDown();
            }
            this.verifier = new TestVerifier(false);
            this.createdVerifier = true;
        }
        boolean passed = this.verifier.verifyClassFiles(sourceFile, className, expectedSuccessOutputString, this.classpaths, null, vmArguments);
        AbstractRegressionTest.assertTrue((String)this.verifier.failureReason, (boolean)passed);
        if (vmArguments != null) {
            if (this.verifier != null) {
                this.verifier.shutDown();
            }
            this.verifier = new TestVerifier(false);
            this.createdVerifier = true;
        }
    }

    protected String findReferences(String classFilePath) {
        final StringBuilder references = new StringBuilder(10);
        JavaSearchParticipant participant = new JavaSearchParticipant(){
            final SearchParticipant searchParticipant = this;

            public SearchDocument getDocument(String documentPath) {
                return new SearchDocument(documentPath, this.searchParticipant){

                    public byte[] getByteContents() {
                        try {
                            return Util.getFileByteContent((File)new File(this.getPath()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }

                    public char[] getCharContents() {
                        return null;
                    }

                    public String getEncoding() {
                        return null;
                    }
                };
            }
        };
        SearchDocument document = participant.getDocument(new File(classFilePath).getPath());
        BinaryIndexer indexer = new BinaryIndexer(document){

            protected void addIndexEntry(char[] category, char[] key) {
                references.append(category);
                references.append('/');
                references.append(key);
                references.append('\n');
            }
        };
        indexer.indexDocument();
        String computedReferences = references.toString();
        return computedReferences;
    }

    protected ClassFileReader getClassFileReader(String fileName, String className) {
        File classFile = new File(fileName);
        AbstractRegressionTest.assertTrue((String)(".class file doesn't exist:" + fileName), (boolean)classFile.exists());
        try {
            ClassFileReader reader = ClassFileReader.read((byte[])Files.readAllBytes(classFile.toPath()), (String)(className + ".class"), (boolean)true);
            return reader;
        }
        catch (org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected INameEnvironment[] getClassLibs(boolean useDefaultClasspaths, Map<String, String> options) {
        String encoding;
        if (options == null) {
            options = this.getCompilerOptions();
        }
        if ("".equals(encoding = this.getCompilerOptions().get("org.eclipse.jdt.core.encoding"))) {
            encoding = null;
        }
        String release = null;
        if ("enabled".equals(options.get("org.eclipse.jdt.core.compiler.release"))) {
            release = this.getCompilerOptions().get("org.eclipse.jdt.core.compiler.compliance");
        }
        if (useDefaultClasspaths && encoding == null) {
            return DefaultJavaRuntimeEnvironment.create(this.classpaths, release);
        }
        INameEnvironment[] classLibs = new INameEnvironment[]{new FileSystem(this.classpaths, new String[0], encoding, release)};
        return classLibs;
    }

    protected INameEnvironment[] getClassLibs(boolean useDefaultClasspaths) {
        return this.getClassLibs(useDefaultClasspaths, null);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "warning");
        return defaultOptions;
    }

    protected boolean isMinimumCompliant(long compliance) {
        Map<String, String> options = this.getCompilerOptions();
        CompilerOptions compOptions = new CompilerOptions(options);
        return compOptions.complianceLevel >= compliance;
    }

    protected void enableAllWarningsForIrritants(Map<String, String> options, IrritantSet irritants) {
        int[] bits = irritants.getBits();
        int i = 0;
        while (i < bits.length) {
            int bit = bits[i];
            int b = 0;
            while (b < 29) {
                int single = bit & 1 << b;
                if (single != 0 && (single |= i << 29) != 0x40004000) {
                    String optionKey = CompilerOptions.optionKeyFromIrritant((int)single);
                    options.put(optionKey, "warning");
                }
                ++b;
            }
            ++i;
        }
    }

    protected String[] getDefaultClassPaths() {
        return DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
    }

    protected String[] getLibsWithNullAnnotations() throws IOException {
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        Bundle[] bundles = Platform.getBundles((String)"org.eclipse.jdt.annotation", (String)"[2.0.0,3.0.0)");
        File bundleFile = (File)FileLocator.getBundleFileLocation((Bundle)bundles[0]).get();
        libs[len] = bundleFile.isDirectory() ? bundleFile.getPath() + "/bin" : bundleFile.getPath();
        return libs;
    }

    protected IErrorHandlingPolicy getErrorHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        return new InMemoryNameEnvironment(testFiles, this.getClassLibs(classPaths == null, options));
    }

    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths) {
        return this.getNameEnvironment(testFiles, classPaths, null);
    }

    protected IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    protected CompilationUnit[] getCompilationUnits(String[] testFiles) {
        return org.eclipse.jdt.core.tests.util.Util.compilationUnits(testFiles);
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
        if (setUp instanceof RegressionTestSetup) {
            RegressionTestSetup regressionTestSetUp = (RegressionTestSetup)setUp;
            this.javaClassLib = regressionTestSetUp.javaClassLib;
            this.verifier = regressionTestSetUp.verifier;
        }
    }

    void logTestFiles(boolean logTitle, String[] testFiles) {
        if (logTitle) {
            this.logTestTitle();
        }
        int i = 0;
        while (i < testFiles.length) {
            System.out.print(testFiles[i]);
            System.out.println(" [");
            String content = testFiles[i + 1];
            if (content.length() > 10000) {
                System.out.println(content.substring(0, 10000));
                System.out.println("...(truncated)");
            } else {
                System.out.println(content);
            }
            System.out.println("]");
            i += 2;
        }
    }

    void logTestTitle() {
        System.out.println(this.getClass().getName() + "#" + this.getName());
    }

    protected void printFiles(String[] testFiles) {
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            System.out.println(testFiles[i++]);
            String content = testFiles[i];
            if (content.length() > 10000) {
                System.out.println(content.substring(0, 10000));
                System.out.println("...(truncated)");
            } else {
                System.out.println(content);
            }
            ++i;
        }
        System.out.println("");
    }

    protected void printJavacResultsSummary() {
        if (this.shouldRunJavac()) {
            Integer count = (Integer)TESTS_COUNTERS.get(CURRENT_CLASS_NAME);
            if (count != null) {
                int newCount = count - 1;
                TESTS_COUNTERS.put(CURRENT_CLASS_NAME, newCount);
                if (newCount == 0) {
                    if (DIFF_COUNTERS[0] != 0 || DIFF_COUNTERS[1] != 0 || DIFF_COUNTERS[2] != 0) {
                        this.dualPrintln("===========================================================================");
                        this.dualPrintln("Results summary:");
                    }
                    if (DIFF_COUNTERS[0] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[0] + " test(s) where Javac found errors/warnings but Eclipse did not");
                    }
                    if (DIFF_COUNTERS[1] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[1] + " test(s) where Eclipse found errors/warnings but Javac did not");
                    }
                    if (DIFF_COUNTERS[2] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[2] + " test(s) where Eclipse and Javac did not have same output");
                    }
                    System.out.println("\n");
                }
            }
            this.dualPrintln("\n\nFull results sent to " + javacFullLogFileName);
            javacFullLog.flush();
        }
    }

    protected void removeTempClass(String className) {
        int max;
        int i;
        File dir = new File(SOURCE_DIRECTORY);
        String[] fileNames = dir.list();
        if (fileNames != null) {
            i = 0;
            max = fileNames.length;
            while (i < max) {
                if (fileNames[i].indexOf(className) != -1) {
                    org.eclipse.jdt.core.tests.util.Util.delete(SOURCE_DIRECTORY + File.separator + fileNames[i]);
                }
                ++i;
            }
        }
        if ((fileNames = (dir = new File(EVAL_DIRECTORY)).list()) != null) {
            i = 0;
            max = fileNames.length;
            while (i < max) {
                if (fileNames[i].indexOf(className) != -1) {
                    org.eclipse.jdt.core.tests.util.Util.delete(EVAL_DIRECTORY + File.separator + fileNames[i]);
                }
                ++i;
            }
        }
    }

    protected void runConformTest(String[] testFiles) {
        this.runTest(true, testFiles, null, null, false, null, false, null, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, ASTVisitor visitor) {
        this.runTest(true, testFiles, new String[0], null, false, null, false, null, false, null, null, false, null, null, null, visitor, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutputString) {
        this.runConformTest(false, JavacTestOptions.DEFAULT, testFiles, expectedOutputString);
    }

    protected void runConformTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedOutputString) {
        this.runTest(true, testFiles, null, null, false, null, false, null, false, null, expectedOutputString, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runConformTest(String[] testFiles, Map<String, String> customOptions) {
        this.runTest(true, testFiles, null, customOptions, false, null, false, null, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        this.runConformTest(testFiles, expectedOutput, customOptions, null);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions, String[] vmArguments, Charset charset) {
        this.runTest(true, testFiles, null, customOptions, false, null, false, null, false, vmArguments, expectedOutput, null, JavacTestOptions.DEFAULT, charset);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions, String[] vmArguments, JavacTestOptions javacOptions) {
        this.runTest(true, testFiles, null, customOptions, false, null, false, null, false, vmArguments, expectedOutput, null, javacOptions);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions, String[] vmArguments) {
        this.runTest(true, testFiles, null, customOptions, false, null, false, null, false, vmArguments, expectedOutput, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String[] dependantFiles, String expectedSuccessOutputString) {
        this.runTest(true, testFiles, dependantFiles, null, false, null, false, null, false, null, null, false, null, expectedSuccessOutputString, null, null, expectedSuccessOutputString, JavacTestOptions.DEFAULT, Charset.defaultCharset());
    }

    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, null, false, null, false, null, false, vmArguments, expectedOutputString, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map<String, String> customOptions, ICompilerRequestor customRequestor) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, customRequestor, false, null, false, vmArguments, expectedOutputString, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedSuccessOutputString, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, boolean skipJavac) {
        this.runConformTest(testFiles, expectedSuccessOutputString, classLib, shouldFlushOutputDirectory, vmArguments, customOptions, clientRequestor, skipJavac, skipJavac ? JavacTestOptions.SKIP : JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedSuccessOutputString, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, boolean skipJavac, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLib, customOptions, false, clientRequestor, false, null, false, vmArguments, expectedSuccessOutputString, null, javacTestOptions);
    }

    protected static void javacUsePathOption(String option) {
        if (javacCompilers != null) {
            for (JavacCompiler compiler : javacCompilers) {
                compiler.usePathOption(option);
            }
        }
    }

    protected void runJavac(String[] testFiles, String expectedProblemLog, String expectedSuccessOutputString, boolean shouldFlushOutputDirectory) {
        String testName = null;
        Process compileProcess = null;
        Process execProcess = null;
        try {
            try {
                testName = this.testName();
                File javacOutputDirectory = new File(JAVAC_OUTPUT_DIR_NAME);
                if (shouldFlushOutputDirectory) {
                    org.eclipse.jdt.core.tests.util.Util.delete(javacOutputDirectory);
                }
                this.writeFiles(testFiles);
                StringBuilder cmdLine = new StringBuilder(javacCommandLineHeader);
                String[] classpath = org.eclipse.jdt.core.tests.util.Util.concatWithClassLibs(JAVAC_OUTPUT_DIR_NAME, false);
                StringBuilder cp = new StringBuilder(" -classpath ");
                int length = classpath.length;
                int i = 0;
                while (i < length) {
                    if (i > 0) {
                        cp.append(File.pathSeparatorChar);
                    }
                    if (classpath[i].indexOf(" ") != -1) {
                        cp.append("\"" + classpath[i] + "\"");
                    } else {
                        cp.append(classpath[i]);
                    }
                    ++i;
                }
                cmdLine.append((CharSequence)cp);
                i = 0;
                while (i < testFiles.length) {
                    cmdLine.append(' ');
                    cmdLine.append(testFiles[i]);
                    i += 2;
                }
                compileProcess = Runtime.getRuntime().exec(cmdLine.toString().split("\\s"), env, this.outputTestDirectory);
                Logger errorLogger = new Logger(compileProcess.getErrorStream(), "ERROR");
                Logger outputLogger = new Logger(compileProcess.getInputStream(), "OUTPUT");
                errorLogger.start();
                outputLogger.start();
                int exitValue = compileProcess.waitFor();
                errorLogger.join();
                outputLogger.join();
                if (!testName.equals(javacTestName)) {
                    javacTestName = testName;
                    javacTestErrorFlag = false;
                    javacFullLog.println("-----------------------------------------------------------------");
                    javacFullLog.println(CURRENT_CLASS_NAME + " " + testName);
                }
                if (exitValue != 0) {
                    javacTestErrorFlag = true;
                }
                if (errorLogger.buffer.length() > 0) {
                    javacFullLog.println("--- javac err: ---");
                    javacFullLog.println(errorLogger.buffer.toString());
                }
                if (outputLogger.buffer.length() > 0) {
                    javacFullLog.println("--- javac out: ---");
                    javacFullLog.println(outputLogger.buffer.toString());
                }
                if (expectedProblemLog == null || expectedProblemLog.length() == 0) {
                    if (exitValue != 0) {
                        System.out.println("----------------------------------------");
                        System.out.println(testName + " - Javac has found error(s) but Eclipse expects conform result:\n");
                        javacFullLog.println("JAVAC_MISMATCH: Javac has found error(s) but Eclipse expects conform result");
                        System.out.println(errorLogger.buffer.toString());
                        this.printFiles(testFiles);
                        DIFF_COUNTERS[0] = DIFF_COUNTERS[0] + 1;
                    } else {
                        if (errorLogger.buffer.length() > 0) {
                            System.out.println("----------------------------------------");
                            System.out.println(testName + " - Javac has found warning(s) but Eclipse expects conform result:\n");
                            javacFullLog.println("JAVAC_MISMATCH: Javac has found warning(s) but Eclipse expects conform result");
                            System.out.println(errorLogger.buffer.toString());
                            this.printFiles(testFiles);
                            DIFF_COUNTERS[0] = DIFF_COUNTERS[0] + 1;
                        }
                        if (expectedSuccessOutputString != null && !javacTestErrorFlag) {
                            StringBuilder javaCmdLine = new StringBuilder(javaCommandLineHeader);
                            javaCmdLine.append((CharSequence)cp);
                            javaCmdLine.append(' ').append(testFiles[0].substring(0, testFiles[0].indexOf(46)));
                            execProcess = Runtime.getRuntime().exec(javaCmdLine.toString().split("\\s"), env, this.outputTestDirectory);
                            Logger logger = new Logger(execProcess.getInputStream(), "");
                            logger.start();
                            exitValue = execProcess.waitFor();
                            logger.join();
                            String javaOutput = logger.buffer.toString().trim();
                            if (!expectedSuccessOutputString.equals(javaOutput)) {
                                System.out.println("----------------------------------------");
                                System.out.println(testName + " - Javac and Eclipse runtime output is not the same:");
                                javacFullLog.println("JAVAC_MISMATCH: Javac and Eclipse runtime output is not the same");
                                this.dualPrintln("eclipse:");
                                this.dualPrintln(expectedSuccessOutputString);
                                this.dualPrintln("javac:");
                                this.dualPrintln(javaOutput);
                                System.out.println("\n");
                                this.printFiles(testFiles);
                                DIFF_COUNTERS[2] = DIFF_COUNTERS[2] + 1;
                            }
                        }
                    }
                } else if (errorLogger.buffer.length() == 0) {
                    System.out.println("----------------------------------------");
                    System.out.println(testName + " - Eclipse has found error(s)/warning(s) but Javac did not find any:");
                    javacFullLog.println("JAVAC_MISMATCH: Eclipse has found error(s)/warning(s) but Javac did not find any");
                    this.dualPrintln("eclipse:");
                    this.dualPrintln(expectedProblemLog);
                    this.printFiles(testFiles);
                    DIFF_COUNTERS[1] = DIFF_COUNTERS[1] + 1;
                } else if (expectedProblemLog.indexOf("ERROR") > 0 && exitValue == 0) {
                    System.out.println("----------------------------------------");
                    System.out.println(testName + " - Eclipse has found error(s) but Javac only found warning(s):");
                    javacFullLog.println("JAVAC_MISMATCH: Eclipse has found error(s) but Javac only found warning(s)");
                    this.dualPrintln("eclipse:");
                    this.dualPrintln(expectedProblemLog);
                    System.out.println("javac:");
                    System.out.println(errorLogger.buffer.toString());
                    this.printFiles(testFiles);
                    DIFF_COUNTERS[1] = DIFF_COUNTERS[1] + 1;
                }
            }
            catch (InterruptedException e1) {
                if (compileProcess != null) {
                    compileProcess.destroy();
                }
                if (execProcess != null) {
                    execProcess.destroy();
                }
                System.out.println(testName + ": OpenJDK javac compilation was aborted!");
                javacFullLog.println("JAVAC_WARNING: OpenJDK javac compilation was aborted!");
                e1.printStackTrace(javacFullLog);
                org.eclipse.jdt.core.tests.util.Util.delete(this.outputTestDirectory);
            }
            catch (Throwable e) {
                System.out.println(testName + ": could not launch OpenJDK javac compilation!");
                e.printStackTrace();
                javacFullLog.println("JAVAC_ERROR: could not launch OpenJDK javac compilation!");
                e.printStackTrace(javacFullLog);
                org.eclipse.jdt.core.tests.util.Util.delete(this.outputTestDirectory);
            }
        }
        finally {
            org.eclipse.jdt.core.tests.util.Util.delete(this.outputTestDirectory);
        }
    }

    protected boolean runJavac(String options, String[] testFileNames, String currentDirectoryPath) {
        Process compileProcess = null;
        try {
            StringBuilder cmdLine = new StringBuilder(javacCommandLineHeader);
            cmdLine.append(' ');
            cmdLine.append(options);
            int i = 0;
            while (i < testFileNames.length) {
                cmdLine.append(' ');
                cmdLine.append(testFileNames[i]);
                ++i;
            }
            File currentDirectory = new File(currentDirectoryPath);
            compileProcess = Runtime.getRuntime().exec(cmdLine.toString().split("\\s"), env, currentDirectory);
            Logger errorLogger = new Logger(compileProcess.getErrorStream(), "ERROR");
            errorLogger.start();
            int exitValue = compileProcess.waitFor();
            errorLogger.join();
            if (exitValue != 0) {
                return false;
            }
            if (errorLogger.buffer.length() > 0) {
                System.err.println("--- javac err: ---");
                System.err.println(errorLogger.buffer.toString());
                return false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (compileProcess != null) {
                compileProcess.destroy();
            }
        }
        return true;
    }

    protected void runJavac(String[] testFiles, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, boolean shouldFlushOutputDirectory, JavacTestOptions options, String[] vmArguments, String[] classLibraries, boolean libsOnModulePath) {
        String newOptions;
        if (options == JavacTestOptions.SKIP) {
            return;
        }
        if (options == null) {
            options = JavacTestOptions.DEFAULT;
        }
        if ((newOptions = options.getCompilerOptions()).indexOf(" -d ") < 0) {
            newOptions = newOptions.concat(" -d .");
        }
        if (newOptions.indexOf(" -Xlint") < 0) {
            newOptions = newOptions.concat(" -Xlint");
        }
        if (newOptions.indexOf(" -implicit") < 0) {
            newOptions = newOptions.concat(" -implicit:none");
        }
        if (classLibraries == null) {
            classLibraries = this.classpaths;
        }
        if (classLibraries != null) {
            ArrayList<String> filteredLibs = new ArrayList<String>();
            String[] stringArray = classLibraries;
            int n = classLibraries.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                if (!lib.startsWith(jdkRootDirPath.toString())) {
                    filteredLibs.add(lib);
                }
                ++n2;
            }
            if (!filteredLibs.isEmpty()) {
                newOptions = newOptions.concat(libsOnModulePath ? " --module-path " : " -classpath ").concat(String.join((CharSequence)File.pathSeparator, filteredLibs.toArray(new String[filteredLibs.size()])));
            }
        }
        String testName = this.testName();
        for (JavacCompiler compiler : javacCompilers) {
            if (options.skip(compiler) || compiler.compliance != this.complianceLevel) continue;
            JavacTestOptions.Excuse excuse = options.excuseFor(compiler);
            StringBuilder compilerLog = new StringBuilder();
            File javacOutputDirectory = null;
            int mismatch = 0;
            String[] sourceFileNames = null;
            try {
                javacOutputDirectory = new File(JAVAC_OUTPUT_DIR_NAME + File.separator + compiler.rawVersion);
                if (shouldFlushOutputDirectory) {
                    org.eclipse.jdt.core.tests.util.Util.delete(javacOutputDirectory);
                } else {
                    this.deleteSourceFiles(javacOutputDirectory);
                }
                javacOutputDirectory.mkdirs();
                int i = 0;
                int length = testFiles.length;
                while (i < length) {
                    File dir;
                    String fileName = testFiles[i++];
                    String contents = testFiles[i++];
                    fileName = this.expandFileNameForJavac(fileName);
                    File file = new File(javacOutputDirectory, fileName);
                    if (fileName.lastIndexOf(47) >= 0 && !(dir = file.getParentFile()).exists()) {
                        dir.mkdirs();
                    }
                    org.eclipse.jdt.core.tests.util.Util.writeToFile(contents, file.getPath());
                }
                int testFilesLength = testFiles.length;
                sourceFileNames = new String[testFilesLength / 2];
                int i2 = 0;
                int j = 0;
                while (i2 < testFilesLength) {
                    sourceFileNames[j] = this.expandFileNameForJavac(testFiles[i2]);
                    i2 += 2;
                    ++j;
                }
                long compilerResult = compiler.compile(javacOutputDirectory, newOptions, sourceFileNames, compilerLog);
                if (!testName.equals(javacTestName)) {
                    javacTestName = testName;
                    javacTestErrorFlag = false;
                }
                if ((compilerResult & 0xFFFFFFFFL) != 0L) {
                    javacTestErrorFlag = true;
                }
                if (expectingCompilerErrors) {
                    if ((compilerResult & 0xFFFFFFFFL) == 0L) {
                        mismatch = (compilerResult & 0xFFFFFFFF00000000L) == 0L ? 1 : 2;
                    }
                } else if ((compilerResult & 0xFFFFFFFFL) != 0L) {
                    mismatch = expectedCompilerLog != null && expectedCompilerLog.length() > 0 ? 8 : 4;
                } else if (expectedCompilerLog != null) {
                    if (expectedCompilerLog.length() > 0 && (compilerResult & 0xFFFFFFFF00000000L) == 0L) {
                        mismatch = 16;
                    } else if (expectedCompilerLog.length() == 0 && (compilerResult & 0xFFFFFFFF00000000L) != 0L) {
                        mismatch = 32;
                    }
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                mismatch = 256;
            }
            catch (Throwable e) {
                e.printStackTrace();
                mismatch = 512;
            }
            String output = null;
            String err = null;
            try {
                String className = testFiles[0].substring(0, testFiles[0].length() - 5);
                if (!(expectedOutputString == null && expectedErrorString == null || javacTestErrorFlag || mismatch != 0 || sourceFileNames == null || className.endsWith(PACKAGE_INFO_NAME) || className.endsWith(MODULE_INFO_NAME))) {
                    int l;
                    JavaRuntime runtime = JavaRuntime.fromCurrentVM();
                    StringBuilder stderr = new StringBuilder();
                    StringBuilder stdout = new StringBuilder();
                    String vmOptions = "";
                    if (vmArguments != null && (l = vmArguments.length) > 0) {
                        StringBuilder buffer = new StringBuilder(vmArguments[0]);
                        int i = 1;
                        while (i < l) {
                            buffer.append(' ');
                            buffer.append(vmArguments[i]);
                            ++i;
                        }
                        vmOptions = buffer.toString();
                    }
                    runtime.execute(javacOutputDirectory, vmOptions, className, stdout, stderr);
                    if (expectedOutputString != null && !expectedOutputString.equals(output = stdout.toString().trim())) {
                        mismatch = 64;
                    }
                    if (expectedErrorString != null && mismatch == 0 && !this.errorStringMatch(expectedErrorString, err = this.adjustErrorOutput(stderr.toString().trim()))) {
                        mismatch = 128;
                    }
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                mismatch = 1024;
            }
            catch (Throwable e) {
                e.printStackTrace();
                mismatch = 2048;
            }
            this.handleMismatch(compiler, testName, testFiles, expectedCompilerLog, expectedOutputString, expectedErrorString, compilerLog, output, err, excuse, mismatch);
        }
    }

    private void deleteSourceFiles(File directory) {
        try {
            if (!directory.exists()) {
                return;
            }
            Files.walk(directory.toPath(), new FileVisitOption[0]).filter(f -> f.toString().endsWith(".java")).map(java.nio.file.Path::toFile).filter(File::isFile).forEach(File::delete);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean errorStringMatch(String expectedErrorStringStart, String actualError) {
        if (expectedErrorStringStart == null) {
            return true;
        }
        if (actualError.indexOf("java.lang.NoSuchMethodError: main") != -1 || actualError.indexOf("Error: Main method not found in class") != -1) {
            return true;
        }
        if (expectedErrorStringStart.length() == 0) {
            return expectedErrorStringStart.equals(actualError);
        }
        return actualError.startsWith(expectedErrorStringStart);
    }

    protected String expandFileNameForJavac(String fileName) {
        return fileName;
    }

    void handleMismatch(JavacCompiler compiler, String testName, String[] testFiles, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, StringBuilder compilerLog, String output, String err, JavacTestOptions.Excuse excuse, int mismatch) {
        if (mismatch != 0) {
            if (excuse != null && excuse.clears(mismatch)) {
                excuse = null;
            } else {
                System.err.println("----------------------------------------");
                this.logTestFiles(true, testFiles);
                switch (mismatch) {
                    case 1: {
                        AbstractRegressionTest.assertEquals(testName + " - Eclipse found error(s) but Javac did not find any", "", expectedCompilerLog.toString());
                        break;
                    }
                    case 2: {
                        AbstractRegressionTest.assertEquals(testName + " - Eclipse found error(s) but Javac only found warning(s)", expectedCompilerLog.toString(), compilerLog.toString());
                        break;
                    }
                    case 4: {
                        AbstractRegressionTest.assertEquals(testName + " - Javac found error(s) but Eclipse did not find any", "", compilerLog.toString());
                        break;
                    }
                    case 8: {
                        AbstractRegressionTest.assertEquals(testName + " - Javac found error(s) but Eclipse only found warning(s)", expectedCompilerLog.toString(), compilerLog.toString());
                        break;
                    }
                    case 16: {
                        AbstractRegressionTest.assertEquals(testName + " - Eclipse found warning(s) but Javac did not find any", "", expectedCompilerLog.toString());
                        break;
                    }
                    case 32: {
                        AbstractRegressionTest.assertEquals(testName + " - Javac found warning(s) but Eclipse did not find any", "", compilerLog.toString());
                        break;
                    }
                    case 64: {
                        AbstractRegressionTest.assertEquals(testName + " - Eclipse/Javac standard output mismatch", expectedOutputString, output);
                        break;
                    }
                    case 128: {
                        AbstractRegressionTest.assertEquals(testName + " - Eclipse/Javac standard error mismatch", expectedErrorString, err);
                        break;
                    }
                    case 256: 
                    case 512: {
                        AbstractRegressionTest.fail((String)(testName + " - Javac failure"));
                        break;
                    }
                    case 1024: 
                    case 2048: {
                        AbstractRegressionTest.fail((String)(testName + " - Java failure"));
                        break;
                    }
                    case 4096: {
                        AbstractRegressionTest.fail((String)(testName + " Javac failure did not match \"" + expectedCompilerLog + "\""));
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected mismatch value: " + mismatch);
                    }
                }
            }
        }
        if (excuse != null) {
            if (excuse.isIntermittent) {
                System.err.println(testName + ": unused execuse (intermittent bug) " + String.valueOf(excuse) + " for compiler " + String.valueOf(compiler));
            } else {
                AbstractRegressionTest.fail((String)(testName + ": unused excuse " + String.valueOf(excuse) + " for compiler " + String.valueOf(compiler)));
            }
        }
    }

    private String adjustErrorOutput(String error) {
        String excPrefix = "Exception in thread \"main\" ";
        if (error.startsWith("Exception in thread \"main\" ")) {
            return error.substring("Exception in thread \"main\" ".length()) + "\n";
        }
        return error;
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(false, null, testFiles, expectedCompilerLog);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedCompilerLog) {
        this.runTest(true, testFiles, null, null, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, boolean performStatementRecovery) {
        this.runNegativeTest(false, null, testFiles, expectedCompilerLog, performStatementRecovery);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedCompilerLog, boolean performStatementRecovery) {
        this.runTest(true, testFiles, null, null, performStatementRecovery, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedProblemLog, String[] classLib, boolean shouldFlushOutputDirectory) {
        this.runNegativeTest(false, null, testFiles, expectedProblemLog, classLib, shouldFlushOutputDirectory);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedProblemLog, String[] classLib, boolean shouldFlushOutputDirectory) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLib, null, false, new Requestor(false, null, false, false), expectedProblemLog == null || expectedProblemLog.indexOf("ERROR") != -1, expectedProblemLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions) {
        this.runNegativeTest(testFiles, expectedCompilerLog, classLibraries, shouldFlushOutputDirectory, null, customOptions);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, vmArguments, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, String expectedErrorString) {
        this.runNegativeTest(testFiles, expectedCompilerLog, classLibraries, shouldFlushOutputDirectory, customOptions, expectedErrorString, JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, expectedErrorString, javacTestOptions);
    }

    protected void runNegativeTest(String[] testFiles, String expectedProblemLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, boolean generateOutput, boolean showCategory, boolean showWarningToken) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(generateOutput, null, showCategory, showWarningToken), expectedProblemLog == null || expectedProblemLog.indexOf("ERROR") != -1, expectedProblemLog, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, boolean generateOutput, boolean showCategory, boolean showWarningToken, boolean skipJavac, boolean performStatementsRecovery) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, performStatementsRecovery, new Requestor(generateOutput, null, showCategory, showWarningToken), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, boolean generateOutput, boolean showCategory, boolean showWarningToken, boolean skipJavac, JavacTestOptions javacOptions, boolean performStatementsRecovery) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, performStatementsRecovery, new Requestor(generateOutput, null, showCategory, showWarningToken), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : javacOptions);
    }

    protected void runTest(String[] testFiles, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, boolean forceExecution, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor customRequestor, boolean skipJavac) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, customRequestor, expectingCompilerErrors, expectedCompilerLog, forceExecution, vmArguments, expectedOutputString, expectedErrorString, skipJavac ? JavacTestOptions.SKIP : JavacTestOptions.DEFAULT);
    }

    protected void runTest(String[] testFiles, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, boolean forceExecution, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, clientRequestor, expectingCompilerErrors, expectedCompilerLog, forceExecution, vmArguments, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    protected void runTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map<String, String> customOptions, boolean performStatementsRecovery, ICompilerRequestor customRequestor, boolean expectingCompilerErrors, String expectedCompilerLog, boolean forceExecution, String[] vmArguments, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, new String[0], classLibraries, false, customOptions, performStatementsRecovery, customRequestor, expectingCompilerErrors, expectedCompilerLog, null, forceExecution, vmArguments, expectedOutputString, expectedErrorString, null, expectedOutputString, javacTestOptions, Charset.defaultCharset());
    }

    private void runTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map<String, String> customOptions, boolean performStatementsRecovery, ICompilerRequestor customRequestor, boolean expectingCompilerErrors, String expectedCompilerLog, boolean forceExecution, String[] vmArguments, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions, Charset charset) {
        this.runTest(shouldFlushOutputDirectory, testFiles, new String[0], classLibraries, false, customOptions, performStatementsRecovery, customRequestor, expectingCompilerErrors, expectedCompilerLog, null, forceExecution, vmArguments, expectedOutputString, expectedErrorString, null, expectedOutputString, javacTestOptions, charset);
    }

    protected void runNegativeTestMultiResult(String[] testFiles, Map options, String[] alternateCompilerErrorLogs) {
        this.runTest(false, testFiles, new String[0], null, false, options, false, new Requestor(false, null, false, false), true, null, alternateCompilerErrorLogs, false, null, null, null, null, null, JavacTestOptions.DEFAULT, Charset.defaultCharset());
    }

    private void runTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] dependantFiles, String[] classLibraries, boolean libsOnModulePath, Map<String, String> customOptions, boolean performStatementsRecovery, ICompilerRequestor customRequestor, boolean expectingCompilerErrors, String expectedCompilerLog, String[] alternateCompilerLogs, boolean forceExecution, String[] vmArguments, String expectedOutputString, String expectedErrorString, ASTVisitor visitor, String expectedJavacOutputString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, dependantFiles, classLibraries, libsOnModulePath, customOptions, performStatementsRecovery, customRequestor, expectingCompilerErrors, expectedCompilerLog, alternateCompilerLogs, forceExecution, vmArguments, expectedOutputString, expectedErrorString, visitor, expectedJavacOutputString, javacTestOptions, Charset.defaultCharset());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void runTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] dependantFiles, String[] classLibraries, boolean libsOnModulePath, Map<String, String> customOptions, boolean performStatementsRecovery, ICompilerRequestor customRequestor, boolean expectingCompilerErrors, String expectedCompilerLog, String[] alternateCompilerLogs, boolean forceExecution, String[] vmArguments, String expectedOutputString, String expectedErrorString, final ASTVisitor visitor, String expectedJavacOutputString, JavacTestOptions javacTestOptions, Charset charset) {
        block36: {
            block37: {
                if (shouldFlushOutputDirectory) {
                    org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(new File(AbstractRegressionTest.OUTPUT_DIR));
                }
                if (testFiles != null && testFiles.length % 2 != 0) {
                    AbstractRegressionTest.fail((String)"odd number of strings in testFiles");
                }
                requestor = customRequestor instanceof Requestor != false ? (Requestor)customRequestor : new Requestor(forceExecution, customRequestor, false, false);
                requestor.outputPath = AbstractRegressionTest.OUTPUT_DIR.endsWith(File.separator) != false ? AbstractRegressionTest.OUTPUT_DIR : AbstractRegressionTest.OUTPUT_DIR + File.separator;
                options = this.getCompilerOptions();
                if (customOptions != null) {
                    options.putAll(customOptions);
                }
                compilerOptions = new CompilerOptions(options);
                compilerOptions.performMethodsFullRecovery = performStatementsRecovery;
                compilerOptions.performStatementsRecovery = performStatementsRecovery;
                nameEnvironment = this.getNameEnvironment(dependantFiles, classLibraries, options);
                batchCompiler = new Compiler(nameEnvironment, this.getErrorHandlingPolicy(), compilerOptions, requestor, this.getProblemFactory()){

                    public void process(CompilationUnitDeclaration unit, int i) {
                        super.process(unit, i);
                        if (visitor != null) {
                            unit.traverse(visitor, unit.scope);
                        }
                    }
                };
                if (this.enableAPT) {
                    batchCompiler.annotationProcessorManager = this.getAnnotationProcessorManager(batchCompiler);
                }
                compilerOptions.produceReferenceInfo = true;
                exception /* !! */  = null;
                try {
                    try {
                        batchCompiler.compile((ICompilationUnit[])this.getCompilationUnits(testFiles));
                        break block36;
                    }
                    catch (RuntimeException e) {
                        exception /* !! */  = e;
                        throw e;
                    }
                    catch (Error e) {
                        exception /* !! */  = e;
                        throw e;
                    }
                }
                catch (Throwable var27_29) {
                    nameEnvironment.cleanup();
                    alternatePlatformIndepentLogs = null;
                    if (expectedCompilerLog != null) {
                        alternatePlatformIndepentLogs = new String[]{org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(expectedCompilerLog)};
                        break block37;
                    }
                    if (alternateCompilerLogs == null) break block37;
                    alternatePlatformIndepentLogs = new String[alternateCompilerLogs.length];
                    i = 0;
                    ** while (i < alternateCompilerLogs.length)
                }
lbl-1000:
                // 1 sources

                {
                    alternatePlatformIndepentLogs[i] = org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(alternateCompilerLogs[i]);
                    ++i;
                    continue;
                }
            }
            if (alternatePlatformIndepentLogs != null) {
                this.checkCompilerLog(testFiles, requestor, alternatePlatformIndepentLogs, exception /* !! */ );
            }
            if (exception /* !! */  == null) {
                if (expectingCompilerErrors) {
                    if (!requestor.hasErrors) {
                        this.logTestFiles(true, testFiles);
                        AbstractRegressionTest.fail((String)"Unexpected success");
                    }
                } else if (requestor.hasErrors && !"".equals(requestor.problemLog)) {
                    this.logTestFiles(true, testFiles);
                    System.out.println("Copy-paste compiler log:");
                    System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(requestor.problemLog.toString()), AbstractRegressionTest.INDENT, AbstractRegressionTest.SHIFT));
                    AbstractRegressionTest.assertEquals("Unexpected failure", "", requestor.problemLog);
                }
            }
            throw var27_29;
        }
        nameEnvironment.cleanup();
        alternatePlatformIndepentLogs = null;
        if (expectedCompilerLog != null) {
            alternatePlatformIndepentLogs = new String[]{org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(expectedCompilerLog)};
        } else if (alternateCompilerLogs != null) {
            alternatePlatformIndepentLogs = new String[alternateCompilerLogs.length];
            i = 0;
            while (i < alternateCompilerLogs.length) {
                alternatePlatformIndepentLogs[i] = org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(alternateCompilerLogs[i]);
                ++i;
            }
        }
        if (alternatePlatformIndepentLogs != null) {
            this.checkCompilerLog(testFiles, requestor, alternatePlatformIndepentLogs, exception /* !! */ );
        }
        if (exception /* !! */  == null) {
            if (expectingCompilerErrors) {
                if (!requestor.hasErrors) {
                    this.logTestFiles(true, testFiles);
                    AbstractRegressionTest.fail((String)"Unexpected success");
                }
            } else if (requestor.hasErrors && !"".equals(requestor.problemLog)) {
                this.logTestFiles(true, testFiles);
                System.out.println("Copy-paste compiler log:");
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(requestor.problemLog.toString()), AbstractRegressionTest.INDENT, AbstractRegressionTest.SHIFT));
                AbstractRegressionTest.assertEquals("Unexpected failure", "", requestor.problemLog);
            }
        }
        if (!(requestor.hasErrors && !forceExecution || (className = (sourceFile = testFiles[0]).substring(0, sourceFile.length() - 5).replace('/', '.').replace('\\', '.')).endsWith(AbstractRegressionTest.PACKAGE_INFO_NAME) || className.endsWith(AbstractRegressionTest.MODULE_INFO_NAME))) {
            if (vmArguments != null) {
                if (this.verifier != null) {
                    this.verifier.shutDown();
                }
                this.verifier = new TestVerifier(false);
                this.createdVerifier = true;
            }
            if (!(passed = this.verifier.verifyClassFiles(sourceFile, className, expectedOutputString, expectedErrorString, this.classpaths, null, vmArguments))) {
                System.out.println(this.getClass().getName() + "#" + this.getName());
                execErrorString = this.verifier.getExecutionError();
                if (execErrorString != null && execErrorString.length() > 0) {
                    System.out.println("[ERR]:" + execErrorString);
                }
                if ((execOutputString = this.verifier.getExecutionOutput()) != null && execOutputString.length() > 0) {
                    System.out.println("[OUT]:" + execOutputString);
                }
                this.logTestFiles(false, testFiles);
                AbstractRegressionTest.assertEquals(this.verifier.failureReason, expectedErrorString == null ? "" : expectedErrorString, execErrorString);
                AbstractRegressionTest.assertEquals(this.verifier.failureReason, expectedOutputString == null ? "" : expectedOutputString, execOutputString);
            }
            AbstractRegressionTest.assertTrue((String)this.verifier.failureReason, (boolean)passed);
            if (vmArguments != null) {
                if (this.verifier != null) {
                    this.verifier.shutDown();
                }
                this.verifier = new TestVerifier(false);
                this.createdVerifier = true;
            }
        }
        if (this.shouldRunJavac() && javacTestOptions != JavacTestOptions.SKIP) {
            this.runJavac(testFiles, expectingCompilerErrors, expectedCompilerLog, expectedJavacOutputString, expectedErrorString, shouldFlushOutputDirectory, javacTestOptions, vmArguments, classLibraries, libsOnModulePath);
        }
    }

    protected AbstractAnnotationProcessorManager getAnnotationProcessorManager(Compiler compiler) {
        try {
            DummyAnnotationProcessingManager annotationManager = new DummyAnnotationProcessingManager();
            annotationManager.configure(compiler, new String[0]);
            annotationManager.setErr(new PrintWriter(System.err));
            annotationManager.setOut(new PrintWriter(System.out));
            return annotationManager;
        }
        catch (UnsupportedClassVersionError e) {
            System.err.println(e);
            return null;
        }
    }

    public void runConformTest(String[] testFiles, JavacTestOptions javacTestOptions) {
        this.runTest(true, testFiles, null, null, false, null, false, "", false, null, "", "", javacTestOptions);
    }

    protected void runConformTest(boolean shouldFlushOutputDirectory, String[] testFiles, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, null, null, false, null, false, expectedCompilerLog, false, null, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    protected void runConformTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, false, expectedCompilerLog, false, null, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, JavacTestOptions javacTestOptions) {
        this.runTest(true, testFiles, null, null, false, null, true, expectedCompilerLog, false, null, null, null, javacTestOptions);
    }

    protected void runNegativeTest(String[] testFiles, String[] dependentFiles, String expectedCompilerLog, JavacTestOptions javacTestOptions) {
        this.runTest(true, testFiles, dependentFiles, null, false, null, false, null, true, expectedCompilerLog, null, false, null, null, null, null, null, javacTestOptions, Charset.defaultCharset());
    }

    protected void runNegativeTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, String expectedCompilerLog, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, javacTestOptions);
    }

    protected void runNegativeTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, true, expectedCompilerLog, true, null, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    protected boolean shouldRunJavac() {
        return RUN_JAVAC || RUN_JAVAC_OPT_IN && this.runJavacOptIn;
    }

    @Override
    protected void setUp() throws Exception {
        System.out.println(this.getClass().getName() + "." + this.getName());
        super.setUp();
        if (this.verifier == null) {
            this.verifier = new TestVerifier(true);
            this.createdVerifier = true;
        }
        if (this.shouldRunJavac()) {
            this.setupJavac();
        }
    }

    private void setupJavac() throws Exception {
        if (this.isFirst()) {
            if (javacFullLog == null) {
                JAVAC_OUTPUT_DIR = new File(JAVAC_OUTPUT_DIR_NAME);
                String jdkRootDirectory = System.getProperty("jdk.root");
                jdkRootDirPath = jdkRootDirectory == null ? new Path(org.eclipse.jdt.core.tests.util.Util.getJREDirectory()) : new Path(jdkRootDirectory);
                StringBuilder cmdLineHeader = new StringBuilder(jdkRootDirPath.append("bin").append(JAVA_NAME).toString());
                javaCommandLineHeader = cmdLineHeader.toString();
                cmdLineHeader = new StringBuilder(jdkRootDirPath.append("bin").append(JAVAC_NAME).toString());
                String version = JavacCompiler.getVersion(cmdLineHeader.toString());
                cmdLineHeader.append(" -classpath . ");
                cmdLineHeader.append(" -d ");
                cmdLineHeader.append((String)(JAVAC_OUTPUT_DIR_NAME.indexOf(" ") != -1 ? "\"" + JAVAC_OUTPUT_DIR_NAME + "\"" : JAVAC_OUTPUT_DIR_NAME));
                String firstSupportedVersion = CompilerOptions.getFirstSupportedJavaVersion();
                cmdLineHeader.append(" -source " + firstSupportedVersion + " -deprecation -Xlint ");
                javacCommandLineHeader = cmdLineHeader.toString();
                new File(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()).mkdirs();
                javacFullLogFileName = org.eclipse.jdt.core.tests.util.Util.getOutputDirectory() + File.separatorChar + version.replace(' ', '_') + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".txt";
                javacFullLog = new PrintWriter(new FileOutputStream(javacFullLogFileName));
                javacFullLog.println(version);
                System.out.println("***************************************************************************");
                System.out.println("* OpenJDK javac compiler " + JavacCompiler.getBuild(javaCommandLineHeader) + " output archived into file:");
                System.out.println("* " + javacFullLogFileName);
                System.out.println("***************************************************************************");
                javacCompilers = new ArrayList<JavacCompiler>();
                String jdkRoots = System.getProperty("jdk.roots");
                if (jdkRoots == null) {
                    javacCompilers.add(new JavacCompiler(jdkRootDirPath.toString()));
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(jdkRoots, File.pathSeparator);
                    while (tokenizer.hasMoreTokens()) {
                        javacCompilers.add(new JavacCompiler(tokenizer.nextToken()));
                    }
                }
            }
            CURRENT_CLASS_NAME = this.getClass().getName();
            this.dualPrintln("***************************************************************************");
            System.out.print("* Comparison with OpenJDK javac compiler for class ");
            this.dualPrintln(CURRENT_CLASS_NAME.substring(CURRENT_CLASS_NAME.lastIndexOf(46) + 1) + " (" + String.valueOf(TESTS_COUNTERS.get(CURRENT_CLASS_NAME)) + " tests)");
            System.out.println("***************************************************************************");
            AbstractRegressionTest.DIFF_COUNTERS[0] = 0;
            AbstractRegressionTest.DIFF_COUNTERS[1] = 0;
            AbstractRegressionTest.DIFF_COUNTERS[2] = 0;
        }
    }

    @Override
    public void stop() {
        this.verifier.shutDown();
    }

    @Override
    protected void tearDown() throws Exception {
        File libDir;
        File outputDir;
        if (this.createdVerifier) {
            this.stop();
        }
        if ((outputDir = new File(OUTPUT_DIR)).exists()) {
            org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(outputDir);
        }
        if ((libDir = new File(LIB_DIR)).exists()) {
            org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(libDir);
        }
        super.tearDown();
        if (this.shouldRunJavac()) {
            if (JAVAC_OUTPUT_DIR.exists()) {
                org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(JAVAC_OUTPUT_DIR);
            }
            this.printJavacResultsSummary();
        }
    }

    protected String getCompilerTestsPluginDirectoryPath() {
        try {
            URL platformURL = Platform.getBundle((String)"org.eclipse.jdt.core.tests.compiler").getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Map<String, String> setPresetPreviewOptions() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", JavaCore.latestSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", JavaCore.latestSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", JavaCore.latestSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        return options;
    }

    static class CustomFileSystem
    extends FileSystem {
        CustomFileSystem(Collection<String> limitModules) {
            super(org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs(), new String[0], null, limitModules);
        }
    }

    class DummyAnnotationProcessingManager
    extends BaseAnnotationProcessorManager {
        ProcessorInfo processorInfo = null;

        DummyAnnotationProcessingManager() {
        }

        public ProcessorInfo discoverNextProcessor() {
            ProcessorInfo temp = this.processorInfo;
            this.processorInfo = null;
            return temp;
        }

        public void reportProcessorException(Processor p, Exception e) {
            throw new AbortCompilation(null, (Throwable)e);
        }

        public void setProcessors(Object[] processors) {
        }

        public void configure(Object batchCompiler, String[] options) {
            this._processingEnv = new DummyEnvironmentImpl((Compiler)batchCompiler);
        }

        public void processAnnotations(CompilationUnitDeclaration[] units, ReferenceBinding[] referenceBindings, boolean isLastRound) {
            if (this.processorInfo == null) {
                this.processorInfo = new ProcessorInfo((Processor)new DummyProcessor());
            }
            super.processAnnotations(units, referenceBindings, isLastRound);
        }

        public void configureFromPlatform(Compiler compiler, Object compilationUnitLocator, Object javaProject, boolean isTestCode) {
        }

        class DummyEnvironmentImpl
        extends BaseProcessingEnvImpl {
            public DummyEnvironmentImpl(Compiler compiler) {
                this._compiler = compiler;
            }

            public Locale getLocale() {
                return Locale.getDefault();
            }
        }

        @SupportedAnnotationTypes(value={"*"})
        class DummyProcessor
        extends AbstractProcessor {
            DummyProcessor() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                return true;
            }
        }
    }

    static class JavaRuntime {
        private final String rootDirectoryPath;
        private final String javaPathName;
        String version;
        String rawVersion;
        int minor;
        private static HashMap runtimes = new HashMap();

        static JavaRuntime runtimeFor(JavacCompiler compiler) throws IOException, InterruptedException {
            JavaRuntime cached = (JavaRuntime)runtimes.get(compiler.rawVersion);
            if (cached == null) {
                cached = new JavaRuntime(compiler.rootDirectoryPath, compiler.version, compiler.rawVersion, compiler.minor);
                runtimes.put(compiler.rawVersion, cached);
            }
            return cached;
        }

        public static JavaRuntime fromCurrentVM() throws IOException, InterruptedException {
            String rawVersion = System.getProperty("java.version");
            JavaRuntime cached = (JavaRuntime)runtimes.get(rawVersion);
            if (cached == null) {
                String jreRootDirPath = org.eclipse.jdt.core.tests.util.Util.getJREDirectory();
                String version = JavacCompiler.versionFromRawVersion(rawVersion, jreRootDirPath);
                int minor = JavacCompiler.minorFromRawVersion(version, rawVersion);
                cached = new JavaRuntime(jreRootDirPath, version, rawVersion, minor);
                runtimes.put(rawVersion, cached);
            }
            return cached;
        }

        private JavaRuntime(String rootDirectoryPath, String version, String rawVersion, int minor) throws IOException, InterruptedException {
            this.rootDirectoryPath = rootDirectoryPath;
            this.javaPathName = new File(this.rootDirectoryPath + File.separator + "bin" + File.separator + JAVA_NAME).toPath().normalize().toAbsolutePath().toString();
            this.version = version;
            this.rawVersion = rawVersion;
            this.minor = minor;
        }

        int execute(File directory, String options, String className, StringBuilder stdout, StringBuilder stderr) throws IOException, InterruptedException {
            Process executionProcess = null;
            try {
                StringBuilder cmdLine = new StringBuilder(this.javaPathName);
                if (options.contains("-cp ")) {
                    cmdLine.append(' ');
                } else {
                    cmdLine.append(" -classpath . ");
                }
                cmdLine.append(options);
                cmdLine.append(' ');
                cmdLine.append(className);
                executionProcess = Runtime.getRuntime().exec(cmdLine.toString().split("\\s+"), env, directory);
                Logger outputLogger = new Logger(executionProcess.getInputStream(), "RUNTIME OUTPUT", stdout == null ? new StringBuilder() : stdout);
                outputLogger.start();
                Logger errorLogger = new Logger(executionProcess.getErrorStream(), "RUNTIME ERROR", stderr == null ? new StringBuilder() : stderr);
                errorLogger.start();
                int result = executionProcess.waitFor();
                outputLogger.join();
                errorLogger.join();
                int n = result;
                return n;
            }
            finally {
                if (executionProcess != null) {
                    executionProcess.destroy();
                }
            }
        }
    }

    static class JavacCompiler {
        String rootDirectoryPath;
        String javacPathName;
        String version;
        int minor;
        String rawVersion;
        long compliance;
        public static final long EXIT_VALUE_MASK = 0xFFFFFFFFL;
        public static final long ERROR_LOG_MASK = -4294967296L;
        private String classpath;

        JavacCompiler(String rootDirectoryPath) throws IOException, InterruptedException {
            this(rootDirectoryPath, null);
        }

        JavacCompiler(String rootDirectoryPath, String rawVersion) throws IOException, InterruptedException {
            this.rootDirectoryPath = rootDirectoryPath;
            this.javacPathName = new File(rootDirectoryPath + File.separator + "bin" + File.separator + JAVAC_NAME).toPath().normalize().toAbsolutePath().toString();
            if (rawVersion == null) {
                rawVersion = JavacCompiler.getVersion(this.javacPathName);
            }
            this.version = JavacCompiler.versionFromRawVersion(rawVersion, this.javacPathName);
            this.compliance = CompilerOptions.versionToJdkLevel((String)this.version);
            this.minor = JavacCompiler.minorFromRawVersion(this.version, rawVersion);
            this.rawVersion = rawVersion;
            this.classpath = " -classpath ";
        }

        protected void usePathOption(String option) {
            this.classpath = option;
        }

        static String getVersion(String javacPathName) throws IOException, InterruptedException {
            Process fetchVersionProcess = null;
            try {
                int eol;
                fetchVersionProcess = Runtime.getRuntime().exec(new String[]{javacPathName, "-version"}, env, null);
                Logger versionStdErrLogger = new Logger(fetchVersionProcess.getErrorStream(), "");
                Logger versionStdOutLogger = new Logger(fetchVersionProcess.getInputStream(), "");
                versionStdErrLogger.start();
                versionStdOutLogger.start();
                fetchVersionProcess.waitFor();
                versionStdErrLogger.join();
                versionStdOutLogger.join();
                String loggedVersion = versionStdErrLogger.buffer.toString();
                if (loggedVersion.isEmpty()) {
                    loggedVersion = versionStdOutLogger.buffer.toString();
                }
                if ((eol = loggedVersion.indexOf(10)) != -1) {
                    loggedVersion = loggedVersion.substring(0, eol);
                }
                if (loggedVersion.startsWith("javac ")) {
                    loggedVersion = loggedVersion.substring(6, loggedVersion.length());
                }
                String string = loggedVersion;
                return string;
            }
            finally {
                if (fetchVersionProcess != null) {
                    fetchVersionProcess.destroy();
                }
            }
        }

        static String getBuild(String javaPathName) throws IOException, InterruptedException {
            Process fetchVersionProcess = null;
            try {
                int eol;
                fetchVersionProcess = Runtime.getRuntime().exec(new String[]{javaPathName, "-version"}, env, null);
                Logger versionStdErrLogger = new Logger(fetchVersionProcess.getErrorStream(), "");
                Logger versionStdOutLogger = new Logger(fetchVersionProcess.getInputStream(), "");
                versionStdErrLogger.start();
                versionStdOutLogger.start();
                fetchVersionProcess.waitFor();
                versionStdErrLogger.join();
                versionStdOutLogger.join();
                String loggedVersion = versionStdErrLogger.buffer.toString();
                if (loggedVersion.isEmpty()) {
                    loggedVersion = versionStdOutLogger.buffer.toString();
                }
                if ((eol = loggedVersion.indexOf(10)) != -1) {
                    int open = loggedVersion.indexOf(40, eol + 1);
                    int close = loggedVersion.indexOf(41, open);
                    if (open != -1 && close != -1) {
                        loggedVersion = loggedVersion.substring(open, close + 1);
                    }
                }
                String string = loggedVersion;
                return string;
            }
            finally {
                if (fetchVersionProcess != null) {
                    fetchVersionProcess.destroy();
                }
            }
        }

        static String versionFromRawVersion(String rawVersion, String javacPathName) {
            if (rawVersion.indexOf("1.4") != -1 || javacPathName != null && javacPathName.indexOf("1.4") != -1) {
                return "1.4";
            }
            if (rawVersion.indexOf("1.5") != -1) {
                return "1.5";
            }
            if (rawVersion.indexOf("1.6") != -1) {
                return "1.6";
            }
            if (rawVersion.indexOf("1.7") != -1) {
                return "1.7";
            }
            if (rawVersion.indexOf("1.8") != -1) {
                return "1.8";
            }
            if (rawVersion.startsWith("9")) {
                return "9";
            }
            if (rawVersion.startsWith("10")) {
                return "10";
            }
            if (rawVersion.startsWith("11")) {
                return "11";
            }
            if (rawVersion.startsWith("12")) {
                return "12";
            }
            if (rawVersion.startsWith("13")) {
                return "13";
            }
            if (rawVersion.startsWith("14")) {
                return "14";
            }
            if (rawVersion.startsWith("15")) {
                return "15";
            }
            if (rawVersion.startsWith("16")) {
                return "16";
            }
            if (rawVersion.startsWith("17")) {
                return "17";
            }
            if (rawVersion.startsWith("18")) {
                return "18";
            }
            if (rawVersion.startsWith("19")) {
                return "19";
            }
            if (rawVersion.startsWith("20")) {
                return "20";
            }
            if (rawVersion.startsWith("21")) {
                return "21";
            }
            if (rawVersion.startsWith("22")) {
                return "22";
            }
            if (rawVersion.startsWith("23")) {
                return "23";
            }
            if (rawVersion.startsWith("24")) {
                return "24";
            }
            throw new RuntimeException("unknown javac version: " + rawVersion);
        }

        static int minorFromRawVersion(String version, String rawVersion) {
            block156: {
                block154: {
                    block152: {
                        block150: {
                            block148: {
                                if (version == "1.8") {
                                    if ("1.8.0-ea".equals(rawVersion) || "1.8.0".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("1.8.0_40".equals(rawVersion)) {
                                        return 1000;
                                    }
                                    if ("1.8.0_45".equals(rawVersion)) {
                                        return 1100;
                                    }
                                    if ("1.8.0_60".equals(rawVersion)) {
                                        return 1500;
                                    }
                                    if ("1.8.0_131".equals(rawVersion)) {
                                        return 1700;
                                    }
                                    if ("1.8.0_152".equals(rawVersion)) {
                                        return 1900;
                                    }
                                    if ("1.8.0_162".equals(rawVersion)) {
                                        return 2100;
                                    }
                                    if ("1.8.0_171".equals(rawVersion)) {
                                        return 2200;
                                    }
                                    if ("1.8.0_172".equals(rawVersion)) {
                                        return 2300;
                                    }
                                    if ("1.8.0_181".equals(rawVersion)) {
                                        return 2400;
                                    }
                                    if ("1.8.0_182".equals(rawVersion)) {
                                        return 2500;
                                    }
                                    if ("1.8.0_202".equals(rawVersion)) {
                                        return 2600;
                                    }
                                    if ("1.8.0_212".equals(rawVersion)) {
                                        return 2700;
                                    }
                                }
                                if (version == "9") {
                                    if ("9".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("9.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("9.0.4".equals(rawVersion)) {
                                        return 256;
                                    }
                                }
                                if (version == "10") {
                                    if ("10".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("10.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("10.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version == "11") {
                                    if ("11".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("11.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("11.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version == "12") {
                                    if ("12".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("12.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("12.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version == "13") {
                                    if ("13-ea".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("13".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("13.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("13.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version == "14") {
                                    if ("14-ea".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("14".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("14.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("14.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version == "15") {
                                    if ("15-ea".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("15".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("15.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("15.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version == "16") {
                                    if ("16-ea".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("16".equals(rawVersion)) {
                                        return 0;
                                    }
                                    if ("16.0.1".equals(rawVersion)) {
                                        return 64;
                                    }
                                    if ("16.0.2".equals(rawVersion)) {
                                        return 128;
                                    }
                                }
                                if (version != "17") break block148;
                                switch (rawVersion) {
                                    case "17-ea": {
                                        return 0;
                                    }
                                    case "17": {
                                        return 0;
                                    }
                                    case "17.0.1": {
                                        return 64;
                                    }
                                    case "17.0.2": {
                                        return 128;
                                    }
                                    case "17.0.3": {
                                        return 192;
                                    }
                                    case "17.0.4": {
                                        return 256;
                                    }
                                    case "17.0.5": {
                                        return 320;
                                    }
                                    case "17.0.6": {
                                        return 384;
                                    }
                                }
                            }
                            if (version == "18") {
                                if ("18-ea".equals(rawVersion)) {
                                    return 0;
                                }
                                if ("18".equals(rawVersion)) {
                                    return 0;
                                }
                                if ("18.0.1".equals(rawVersion)) {
                                    return 64;
                                }
                                if ("18.0.2".equals(rawVersion)) {
                                    return 128;
                                }
                            }
                            if (version == "19") {
                                if ("19-ea".equals(rawVersion)) {
                                    return 0;
                                }
                                if ("19".equals(rawVersion)) {
                                    return 0;
                                }
                                if ("19.0.1".equals(rawVersion)) {
                                    return 64;
                                }
                                if ("19.0.2".equals(rawVersion)) {
                                    return 128;
                                }
                            }
                            if (version == "20") {
                                if ("20-ea".equals(rawVersion)) {
                                    return 0;
                                }
                                if ("20".equals(rawVersion)) {
                                    return 0;
                                }
                                if ("20.0.1".equals(rawVersion)) {
                                    return 64;
                                }
                                if ("20.0.2".equals(rawVersion)) {
                                    return 128;
                                }
                            }
                            if (version != "21") break block150;
                            switch (rawVersion) {
                                case "21": {
                                    return 0;
                                }
                                case "21.0.1": {
                                    return 64;
                                }
                                case "21.0.2": {
                                    return 128;
                                }
                            }
                        }
                        if (version != "22") break block152;
                        switch (rawVersion) {
                            case "22": {
                                return 0;
                            }
                            case "22.0.1": {
                                return 64;
                            }
                            case "22.0.2": {
                                return 128;
                            }
                        }
                    }
                    if (version != "23") break block154;
                    switch (rawVersion) {
                        case "23": 
                        case "23-ea": {
                            return 0;
                        }
                        case "23.0.1": {
                            return 64;
                        }
                        case "23.0.2": {
                            return 128;
                        }
                    }
                }
                if (version != "24") break block156;
                switch (rawVersion) {
                    case "24-beta": 
                    case "24": 
                    case "24-ea": {
                        return 0;
                    }
                    case "24.0.1": {
                        return 64;
                    }
                }
            }
            throw new RuntimeException("unknown raw javac version: " + rawVersion);
        }

        long compile(File directory, String options, String[] sourceFileNames, StringBuilder log) throws IOException, InterruptedException {
            return this.compile(directory, options, sourceFileNames, log, true);
        }

        long compile(File directory, String options, String[] sourceFileNames, StringBuilder log, boolean extendCommandLine) throws IOException, InterruptedException {
            Process compileProcess = null;
            long result = 0L;
            try {
                if (!directory.exists()) {
                    directory.mkdir();
                }
                StringBuilder cmdLine = new StringBuilder(this.javacPathName);
                cmdLine.append(this.classpath);
                cmdLine.append(". ");
                cmdLine.append(options);
                if (extendCommandLine) {
                    int i = 0;
                    while (i < sourceFileNames.length) {
                        cmdLine.append(' ');
                        cmdLine.append(sourceFileNames[i]);
                        ++i;
                    }
                }
                String cmdLineAsString = "Linux".equals(System.getProperty("os.name")) ? cmdLine.toString().replaceAll("\"", "") : cmdLine.toString();
                compileProcess = Runtime.getRuntime().exec(cmdLineAsString.split("\\s+"), env, directory);
                Logger errorLogger = new Logger(compileProcess.getErrorStream(), "ERROR", log == null ? new StringBuilder() : log);
                errorLogger.start();
                int compilerResult = compileProcess.waitFor();
                result |= (long)compilerResult;
                errorLogger.join();
                if (errorLogger.buffer.length() > 0) {
                    System.err.println("--- javac err: ---");
                    System.err.println(errorLogger.buffer.toString());
                    result |= 0xFFFFFFFF00000000L;
                }
            }
            finally {
                if (compileProcess != null) {
                    compileProcess.destroy();
                }
            }
            return result;
        }
    }

    protected static class JavacTestOptions {
        static final JavacTestOptions DEFAULT = new JavacTestOptions();
        static final JavacTestOptions SKIP = new JavacTestOptions(){

            @Override
            boolean skip(JavacCompiler compiler) {
                return true;
            }
        };
        static final JavacTestOptions SKIP_UNTIL_FRAMEWORK_FIX = new JavacTestOptions(){

            @Override
            boolean skip(JavacCompiler compiler) {
                return true;
            }
        };
        long minJavacCompliance = 0L;
        private String compilerOptions = "";

        static JavacTestOptions forRelease(String release) {
            JavacTestOptions options = new JavacTestOptions(Long.parseLong(release));
            if (isJRE9Plus) {
                options.setCompilerOptions("--release " + release);
            } else {
                options.setCompilerOptions("--source 1." + release + " --target 1." + release);
            }
            return options;
        }

        static JavacTestOptions forRelease(String release, String additionalOptions) {
            String result;
            JavacTestOptions options = new JavacTestOptions(Long.parseLong(release));
            String string = result = isJRE9Plus ? "--release " + release : "--source 1." + release + " --target 1." + release;
            if (additionalOptions != null) {
                result = result + " " + additionalOptions;
            }
            options.setCompilerOptions(result);
            return options;
        }

        static JavacTestOptions forReleaseWithPreview(String release) {
            JavacTestOptions options = new JavacTestOptions(Long.parseLong(release));
            if (!isJRE9Plus) {
                throw new IllegalArgumentException("preview not supported at release " + release);
            }
            options.setCompilerOptions("--release " + release + " --enable-preview -Xlint:-preview");
            return options;
        }

        static JavacTestOptions forReleaseWithPreview(String release, String additionalOptions) {
            String result;
            JavacTestOptions options = new JavacTestOptions(Long.parseLong(release));
            if (isJRE9Plus) {
                result = "--release " + release + " --enable-preview -Xlint:-preview";
                if (additionalOptions != null) {
                    result = result + " " + additionalOptions;
                }
            } else {
                throw new IllegalArgumentException("preview not supported at release " + release);
            }
            options.setCompilerOptions(result);
            return options;
        }

        public JavacTestOptions() {
        }

        public JavacTestOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
        }

        public JavacTestOptions(long compliance) {
            this.minJavacCompliance = compliance;
        }

        String getCompilerOptions() {
            return this.compilerOptions;
        }

        public void setCompilerOptions(String options) {
            this.compilerOptions = options;
        }

        boolean skip(JavacCompiler compiler) {
            if (this.minJavacCompliance > 0L) {
                return compiler.compliance < this.minJavacCompliance;
            }
            return false;
        }

        Excuse excuseFor(JavacCompiler compiler) {
            return null;
        }

        public static class DubiousOutcome
        extends Excuse {
            public static DubiousOutcome EclipseErrorsJavacNone = new DubiousOutcome(1);
            public static DubiousOutcome JavacErrorsEclipseNone = new DubiousOutcome(4);
            public static DubiousOutcome JDK8319461 = new DubiousOutcome(4);

            DubiousOutcome(int mismatchType) {
                super(mismatchType);
            }
        }

        public static class EclipseHasABug
        extends Excuse {
            public static EclipseHasABug EclipseBug159851 = new EclipseHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            };
            public static EclipseHasABug EclipseBug177715 = new EclipseHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x340000L ? this : null;
                }
            };
            public static EclipseHasABug EclipseBug207935 = new EclipseHasABug(17);
            public static EclipseHasABug EclipseBug216558 = new EclipseHasABug(4);
            public static EclipseHasABug EclipseBug235550 = new EclipseHasABug(4);
            public static EclipseHasABug EclipseBug235809 = new EclipseHasABug(64);
            public static EclipseHasABug EclipseBug236217 = new EclipseHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x340000L ? this : null;
                }
            };
            public static EclipseHasABug EclipseBug236236 = new EclipseHasABug(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return this;
                }
            };
            public static EclipseHasABug EclipseBug236242 = new EclipseHasABug(2){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x330000L ? this : null;
                }
            };
            public static EclipseHasABug EclipseBug236243 = new EclipseHasABug(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x320000L ? this : null;
                }
            };
            public static EclipseHasABug EclipseBug236379 = new EclipseHasABug(16){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return null;
                }
            };
            public static EclipseHasABug EclipseBug424410 = new EclipseHasABug(4);
            public static EclipseHasABug EclipseBug427719 = new EclipseHasABug(8);
            public static EclipseHasABug EclipseBug421922 = new EclipseHasABug(1);
            public static EclipseHasABug EclipseBug428061 = new EclipseHasABug(12);
            public static EclipseHasABug EclipseBug510528 = new EclipseHasABug(4);
            public static EclipseHasABug EclipseBug531531 = new EclipseHasABug(1);

            EclipseHasABug(int mismatchType) {
                super(mismatchType);
            }
        }

        public static class EclipseJustification
        extends Excuse {
            public static final EclipseJustification EclipseBug72704 = new EclipseJustification(1);
            public static final EclipseJustification EclipseBug83902 = new EclipseJustification(16){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug83902b = new EclipseJustification(8);
            public static final EclipseJustification EclipseBug95021 = new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x330000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug126712 = new EclipseJustification(64){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug126744 = new EclipseJustification(4);
            public static final EclipseJustification EclipseBug151275 = new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug159214 = new EclipseJustification(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x320000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug169017 = new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug180789 = new EclipseJustification(2);
            public static final EclipseJustification EclipseBug218677 = new EclipseJustification(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x320000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug234815 = new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseBug235543 = new EclipseJustification(1);
            public static final EclipseJustification EclipseBug235546 = new EclipseJustification(4);
            public static final EclipseJustification EclipseBug449063 = new EclipseJustification(64);
            public static final EclipseJustification EclipseBug561549 = new EclipseJustification(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x350000L ? this : null;
                }
            };
            public static final EclipseJustification EclipseJustification0001 = new EclipseJustification(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            };

            EclipseJustification(int mismatchType) {
                super(mismatchType);
            }
        }

        public static class Excuse
        extends JavacTestOptions {
            protected int mismatchType;
            public boolean isIntermittent;
            public static Excuse EclipseHasSomeMoreWarnings = new Excuse(16);
            public static Excuse EclipseWarningConfiguredAsError = new Excuse(3);
            public static Excuse JavacCompilesBogusReferencedFileAgain = new Excuse(1);
            public static Excuse JavacDoesNotCompileCorrectSource = new JavacHasABug(4);
            public static Excuse JavacCompilesIncorrectSource = new JavacHasABug(19);
            public static Excuse JavacGeneratesIncorrectCode = new JavacHasABug(64);
            public static Excuse JavacHasWarningsEclipseNotConfigured = new JavacHasABug(32);
            public static Excuse JavacHasErrorsEclipseHasWarnings = new JavacHasABug(8);
            public static Excuse JavacHasErrorsEclipseHasNone = new JavacHasABug(4);

            Excuse(int mismatchType) {
                this.mismatchType = mismatchType;
            }

            @Override
            Excuse excuseFor(JavacCompiler compiler) {
                return this;
            }

            public boolean clears(int mismatch) {
                return this.mismatchType == 0 || (this.mismatchType & mismatch) == mismatch;
            }
        }

        public static class JavacBug8179483
        extends JavacHasABug {
            String extraJavacOptions;

            public JavacBug8179483(String extraJavacOptions) {
                super(1);
                this.extraJavacOptions = extraJavacOptions;
            }

            @Override
            String getCompilerOptions() {
                return super.getCompilerOptions() + this.extraJavacOptions;
            }
        }

        public static class JavacBug8221413
        extends JavacHasABug {
            String extraJavacOptions;

            public JavacBug8221413(String extraJavacOptions) {
                super(4);
                this.extraJavacOptions = extraJavacOptions;
            }

            @Override
            String getCompilerOptions() {
                return super.getCompilerOptions() + this.extraJavacOptions;
            }
        }

        public static class JavacBug8226510
        extends JavacHasABug {
            String extraJavacOptions;

            public JavacBug8226510(String extraJavacOptions) {
                super(2);
                this.extraJavacOptions = extraJavacOptions;
            }

            @Override
            String getCompilerOptions() {
                return super.getCompilerOptions() + this.extraJavacOptions;
            }
        }

        public static class JavacBug8341408
        extends JavacBugExtraJavacOptionsPlusMismatch {
            public JavacBug8341408() {
                super("--enable-preview -source 24 -Xlint:-preview", 64);
            }
        }

        public static class JavacBugExtraJavacOptionsPlusMismatch
        extends JavacHasABug {
            String extraJavacOptions;

            public JavacBugExtraJavacOptionsPlusMismatch(String extraJavacOptions, int mismatchType) {
                super(mismatchType);
                this.extraJavacOptions = extraJavacOptions;
            }

            @Override
            String getCompilerOptions() {
                return super.getCompilerOptions() + this.extraJavacOptions;
            }
        }

        public static class JavacHasABug
        extends Excuse {
            long pivotCompliance;
            int pivotMinor;
            int[] minorsFixed;
            static final int NO_FIX = -1;
            static final int IRRELEVANT = -2;
            public static JavacHasABug JavacBug4094180 = new JavacHasABug(1);
            public static JavacHasABug JavacBug4660984 = new JavacHasABug(4);
            public static JavacHasABug JavacBug5042462 = new JavacHasABug(4, 0x330000L, 0);
            public static JavacHasABug JavacBug5061359 = new JavacHasABug(1, 0x330000L, 0);
            public static JavacHasABug JavacBug6302954 = new JavacHasABug(4, 0x330000L, 0);
            public static JavacHasABug JavacBug6400189 = new JavacHasABug(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x320000L ? this : null;
                }
            };
            public static JavacHasABug JavacBug6500701 = new JavacHasABug(64, 0x330000L, 0);
            public static JavacHasABug JavacBug6531075 = new JavacHasABug(64, 0x330000L, 0);
            public static JavacHasABug JavacBug6569404 = new JavacHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x320000L && compiler.minor >= 10 ? this : null;
                }
            };
            public static JavacHasABug JavacBug6557661 = new JavacHasABug(1);
            public static JavacHasABug JavacBug6573446 = new JavacHasABug(1);
            public static JavacHasABug JavacBug6575821 = new JavacHasABug(4, 0x320000L, 10);
            public static JavacHasABug JavacBug8033810 = new JavacHasABug(1);
            public static JavacHasABug JavacBug8144673 = new JavacHasABug(4, 0x350000L, 64);
            public static JavacHasABug JavacBug8204534 = new JavacHasABug(1, 0x370000L, 0);
            public static JavacHasABug JavacBug8207032 = new JavacHasABug(1, 0x370000L, 0);
            public static JavacHasABug JavacBug8044196 = new JavacHasABug(1, 0x350000L, 0, true);
            public static JavacHasABug JavacBug6337964 = new JavacHasABug(4, 0x320000L, 1045, true);
            public static JavacHasABug JavacBug8144832 = new JavacHasABug(4, 0x350000L, 0);
            public static JavacHasABug JavacBug8179483_switchExpression = new JavacBug8179483(" --release 23 --enable-preview -Xlint:-preview");
            public static JavacHasABug JavacBug8221413_switchExpression = new JavacBug8221413(" --release 12 --enable-preview -Xlint:-preview");
            public static JavacHasABug JavacBug8226510_switchExpression = new JavacBug8226510(" --release 12 --enable-preview -Xlint:-preview");
            public static JavacHasABug JavacBug8337980 = new JavacHasABug(1, 0x440000L, 0);
            public static JavacHasABug JavacBug8343306 = new JavacHasABug(1, 0x440000L, 0);
            public static JavacHasABug JavacBug8348928 = new JavacHasABug(2);
            public static JavacHasABug JavacBug8348410 = new JavacHasABug(1);
            public static JavacHasABug JavacBugFixed_6_10 = new JavacHasABug(0, 0x320000L, 1000);
            public static JavacHasABug JavacBugFixed_6_10_b24 = new JavacHasABug(0, 0x320000L, 1010);
            public static JavacHasABug JavacBugFixed_7 = new JavacHasABug(0, 0x330000L, 0);
            public static JavacHasABug JavacBugFixed_901 = new JavacHasABug(0, 0x350000L, 64);
            public static JavacHasABug JavacThrowsAnException = new JavacHasABug(4);
            public static JavacHasABug JavacThrowsAnExceptionForJava_1_5_0_16 = new JavacHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance != 0x310000L || compiler.minor != 1600 ? null : this;
                }
            };
            public static JavacHasABug JavacThrowsAnExceptionForJava_since9_EclipseWarns = new JavacHasABug(8){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x350000L ? null : this;
                }
            };
            public static JavacHasABug NoWarningForMissingJavadocTag = new JavacHasABug(1);
            public static JavacHasABug NoWarningForDuplicateJavadocTag = new JavacHasABug(1);

            JavacHasABug(int mismatchType) {
                super(mismatchType);
            }

            private JavacHasABug(int mismatchType, long pivotCompliance, int pivotMinor) {
                super(mismatchType);
                this.pivotCompliance = pivotCompliance;
                this.pivotMinor = pivotMinor;
            }

            public JavacHasABug(int mismatchType, long pivotCompliance, int pivotMinor, boolean intermittent) {
                this(mismatchType, pivotCompliance, pivotMinor);
                this.isIntermittent = intermittent;
            }

            @Override
            Excuse excuseFor(JavacCompiler compiler) {
                if (this.minorsFixed != null) {
                    if (compiler.compliance == 0x340000L) {
                        return this.minorsFixed[5] > compiler.minor || this.minorsFixed[5] < 0 ? this : null;
                    }
                    throw new RuntimeException();
                }
                if (this.pivotCompliance > 0L) {
                    if (this.pivotCompliance < compiler.compliance) {
                        return null;
                    }
                    if (this.pivotCompliance > compiler.compliance) {
                        return this;
                    }
                    return this.pivotMinor > compiler.minor ? this : null;
                }
                if (this.pivotCompliance < 0L) {
                    if (this.pivotCompliance < -compiler.compliance) {
                        return null;
                    }
                    if (this.pivotCompliance > -compiler.compliance) {
                        return this;
                    }
                    return this.pivotMinor <= compiler.minor ? this : null;
                }
                return this;
            }
        }

        static class MismatchType {
            static final int EclipseErrorsJavacNone = 1;
            static final int EclipseErrorsJavacWarnings = 2;
            static final int JavacErrorsEclipseNone = 4;
            static final int JavacErrorsEclipseWarnings = 8;
            static final int EclipseWarningsJavacNone = 16;
            static final int JavacWarningsEclipseNone = 32;
            static final int StandardOutputMismatch = 64;
            static final int ErrorOutputMismatch = 128;
            static final int JavacAborted = 256;
            static final int JavacNotLaunched = 512;
            static final int JavaAborted = 1024;
            static final int JavaNotLaunched = 2048;
            static final int CompileErrorMismatch = 4096;

            MismatchType() {
            }
        }

        public static class SuppressWarnings
        extends JavacTestOptions {
            public SuppressWarnings(String token) {
                this.setCompilerOptions("-Xlint:-" + token);
            }
        }
    }

    static class Logger
    extends Thread {
        StringBuilder buffer;
        InputStream inputStream;
        String type;

        Logger(InputStream inputStream, String type) {
            this.inputStream = inputStream;
            this.type = type;
            this.buffer = new StringBuilder();
        }

        Logger(InputStream inputStream, String type, StringBuilder buffer) {
            this.inputStream = inputStream;
            this.type = type;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.buffer.append(line).append("\n");
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class ProblemLog {
        final Set<String> logEntry = new HashSet<String>();

        public ProblemLog(String log) {
            String[] entries = log.split("----------\n");
            Pattern pattern = Pattern.compile("\\A(\\d*\\. )");
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                Matcher matcher = pattern.matcher(entry);
                if (matcher.find()) {
                    entry = entry.substring(matcher.end());
                }
                this.logEntry.add(entry);
                ++n2;
            }
        }

        public boolean sameAs(String toTest) {
            ProblemLog log = new ProblemLog(toTest);
            return this.equals(log);
        }

        public int hashCode() {
            return this.logEntry.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProblemLog other = (ProblemLog)obj;
            return this.logEntry.equals(other.logEntry);
        }
    }

    protected class Runner {
        boolean shouldFlushOutputDirectory = true;
        public String[] testFiles;
        public String[] dependantFiles;
        public String[] classLibraries;
        public boolean libsOnModulePath;
        public Map<String, String> customOptions;
        boolean performStatementsRecovery;
        boolean generateOutput;
        ICompilerRequestor customRequestor;
        public String expectedCompilerLog;
        String[] alternateCompilerLogs;
        boolean showCategory;
        boolean showWarningToken;
        boolean skipJavac;
        public String expectedJavacOutputString;
        public JavacTestOptions javacTestOptions;
        boolean forceExecution;
        String[] vmArguments;
        String expectedOutputString;
        String expectedErrorString;
        ASTVisitor visitor;

        protected void runConformTest() {
            AbstractRegressionTest.this.runTest(this.shouldFlushOutputDirectory, this.testFiles, this.dependantFiles != null ? this.dependantFiles : new String[]{}, this.classLibraries, this.libsOnModulePath, this.customOptions, this.performStatementsRecovery, new Requestor(this.generateOutput, this.customRequestor, this.showCategory, this.showWarningToken), false, this.expectedCompilerLog, this.alternateCompilerLogs, this.forceExecution, this.vmArguments, this.expectedOutputString, this.expectedErrorString, this.visitor, this.expectedJavacOutputString != null ? this.expectedJavacOutputString : this.expectedOutputString, this.skipJavac ? JavacTestOptions.SKIP : this.javacTestOptions);
        }

        public void runNegativeTest() {
            AbstractRegressionTest.this.runTest(this.shouldFlushOutputDirectory, this.testFiles, this.dependantFiles != null ? this.dependantFiles : new String[]{}, this.classLibraries, this.libsOnModulePath, this.customOptions, this.performStatementsRecovery, new Requestor(this.generateOutput, this.customRequestor, this.showCategory, this.showWarningToken), true, this.expectedCompilerLog, this.alternateCompilerLogs, this.forceExecution, this.vmArguments, this.expectedOutputString, this.expectedErrorString, this.visitor, this.expectedJavacOutputString != null ? this.expectedJavacOutputString : this.expectedOutputString, this.skipJavac ? JavacTestOptions.SKIP : this.javacTestOptions);
        }

        protected void runWarningTest() {
            AbstractRegressionTest.this.runTest(this.shouldFlushOutputDirectory, this.testFiles, this.dependantFiles != null ? this.dependantFiles : new String[]{}, this.classLibraries, this.libsOnModulePath, this.customOptions, this.performStatementsRecovery, new Requestor(this.generateOutput, this.customRequestor, this.showCategory, this.showWarningToken), false, this.expectedCompilerLog, this.alternateCompilerLogs, this.forceExecution, this.vmArguments, this.expectedOutputString, this.expectedErrorString, this.visitor, this.expectedJavacOutputString != null ? this.expectedJavacOutputString : this.expectedOutputString, this.skipJavac ? JavacTestOptions.SKIP : this.javacTestOptions);
        }
    }
}

