/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BasicModule;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class AbstractRegressionTest9
extends AbstractRegressionTest {
    protected Map<String, IModule> moduleMap = new HashMap<String, IModule>();
    protected Map<String, String> file2module = new HashMap<String, String>();

    public AbstractRegressionTest9(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.moduleMap.clear();
        this.file2module.clear();
        DefaultJavaRuntimeEnvironment.cleanUpDefaultJreClassLibs();
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(classPaths == null, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    @Override
    protected CompilationUnit[] getCompilationUnits(String[] testFiles) {
        HashMap<String, char[]> moduleFiles = new HashMap<String, char[]>();
        CompilationUnit[] compilationUnits = Util.compilationUnits(testFiles);
        int i = 0;
        while (i < testFiles.length) {
            IModule module = this.extractModuleDesc(testFiles[i], testFiles[i + 1], (ICompilationUnit)compilationUnits[i / 2]);
            if (module != null) {
                this.moduleMap.put(String.valueOf(module.name()), module);
                moduleFiles.put(testFiles[0], module.name());
            }
            i += 2;
        }
        i = 0;
        while (i < compilationUnits.length) {
            char[] fileName = compilationUnits[i].getFileName();
            String fileNameString = String.valueOf(compilationUnits[i].getFileName());
            if (CharOperation.endsWith((char[])fileName, (char[])TypeConstants.MODULE_INFO_FILE_NAME)) {
                compilationUnits[i].module = (char[])moduleFiles.get(fileNameString);
            } else {
                String modName = this.file2module.get(fileNameString.replace(File.separator, "/"));
                if (modName != null) {
                    compilationUnits[i].module = modName.toCharArray();
                }
            }
            ++i;
        }
        return compilationUnits;
    }

    @Override
    protected String expandFileNameForJavac(String fileName) {
        String fileNameAsKey = ((String)fileName).replace(File.separator, "/");
        if (this.file2module != null && this.file2module.containsKey(fileNameAsKey)) {
            fileName = new String(this.file2module.get(fileNameAsKey)) + File.separator + (String)fileName;
        }
        return fileName;
    }

    private IModule extractModuleDesc(String fileName, String fileContent, ICompilationUnit cu) {
        CompilationResult compilationResult;
        Parser parser;
        CompilationUnitDeclaration unit;
        if (fileName.toLowerCase().endsWith("module-info.java") && (unit = (parser = this.createParser()).parse(cu, compilationResult = new CompilationResult(cu, 0, 1, 10))).isModuleInfo() && unit.moduleDeclaration != null) {
            return new BasicModule(unit.moduleDeclaration, null);
        }
        return null;
    }

    public Parser createParser() {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("org.eclipse.jdt.core.compiler.source", "9");
        return new Parser(new ProblemReporter(this.getErrorHandlingPolicy(), new CompilerOptions(opts), this.getProblemFactory()), false);
    }

    public void associateToModule(String moduleName, String ... fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.file2module.put(fileName, moduleName);
            ++n2;
        }
    }
}

