/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class AmbiguousMethodTest
extends AbstractComparableTest {
    public AmbiguousMethodTest(String name) {
        super(name);
    }

    public static Test suite() {
        return AmbiguousMethodTest.buildComparableTestSuite(AmbiguousMethodTest.testClass());
    }

    public static Class testClass() {
        return AmbiguousMethodTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map compilerOptions = super.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        return compilerOptions;
    }

    public void test000() {
        this.runConformTest(new String[]{"Test.java", "public class Test { public static void main(String[] args) { new B().foo(new C()); } }\nclass A { void foo(A a) {} }\nclass B extends A { void foo(B b) { System.out.println(1); } }\nclass C extends B {}"}, "1");
    }

    public void test000a() {
        this.runConformTest(new String[]{"Test.java", "public class Test { public static void main(String[] args) { new Subtype<String>().foo(1, \"works\"); } }\nclass Supertype<T1> { <U1> void foo(U1 u, T1 t) {} }\nclass Subtype <T2> extends Supertype<T2> { <U3> void foo(U3 u, T2 t) { System.out.println(t); } }"}, "works");
    }

    public void test001() {
        this.runConformTest(new String[]{"C.java", "public class C { public static void main(String[] args) { new B().m(\"works\"); } }\nclass B extends A { @Override <T extends Comparable<T>> void m(T t) { System.out.println(t); } }\nabstract class A { abstract <T extends Comparable<T>> void m(T t); }"}, "works");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic interface I1<E1> { void method(E1 o); }\n\tstatic interface I2<E2> { void method(E2 o); }\n\tstatic interface I3<E3, E4> extends I1<E3>, I2<E4> {}\n\tstatic class Class1 implements I3<String, String> {\n\t\tpublic void method(String o) { System.out.println(o); }\n\t}\n\tpublic static void main(String[] args) {\n\t\tI3<String, String> i = new Class1();\n\t\ti.method(\"works\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tstatic interface I3<E3, E4> extends I1<E3>, I2<E4> {}\n\t                 ^^\nName clash: The method method(E2) of type X.I2<E2> has the same erasure as method(E1) of type X.I1<E1> but does not override it\n----------\n");
    }

    public void test002a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic interface I1<E> { void method(E o); }\n\tstatic interface I2<E> { void method(E o); }\n\tstatic interface I3<E> extends I1<E>, I2<E> {}\n\tstatic class Class1 implements I3<String> {\n\t\tpublic void method(String o) { System.out.println(o); }\n\t}\n\tpublic static void main(String[] args) {\n\t\tI3<String> i = new Class1();\n\t\ti.method(\"works\");\n\t}\n}"}, "works");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void foo() { new BB().test(); } }\nclass AA<T> { void test() {} }\nclass BB extends AA<CC> { <U> void test() {} }\nclass CC {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X { void foo() { new BB().test(); } }\n\t                                       ^^^^\nThe method test() is ambiguous for the type BB\n----------\n2. ERROR in X.java (at line 3)\n\tclass BB extends AA<CC> { <U> void test() {} }\n\t                                   ^^^^^^\nName clash: The method test() of type BB has the same erasure as test() of type AA<T> but does not override it\n----------\n");
    }

    public void test003a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid singleMatch() { System.out.print(new BB().test(new N(), new Integer(1))); }\n\tvoid betterMatch() { System.out.print(new CC().test(new N(), new Integer(1))); }\n\tvoid worseMatch() { System.out.print(new DD().test(new N(), new Integer(1))); }\n\tpublic static void main(String[] s) {\n\t\tnew X().singleMatch();\n\t\tnew X().betterMatch();\n\t\tnew X().worseMatch();\n\t}\n}\nclass AA<T> { int test(T t, Number num) { return 1; } }\nclass BB extends AA<N> { @Override int test(N n, Number num) { return 2; } }\nclass CC extends AA<M> { <U extends Number> int test(N n, U u) { return 3; } }\nclass DD extends AA<N> { <U extends Number> int test(M m, U u) { return 4; } }\nclass M {}\nclass N extends M {}"}, "231");
    }

    public void test003b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid ambiguous() { new BB().test(new N()); }\n\tvoid exactMatch() { new CC().test(new N()); }\n}\nclass AA<T> { void test(T t) {} }\nclass BB extends AA<N> { <U> void test(N n) {} }\nclass CC extends AA<N> { @Override void test(N n) {} }\nclass M {}\nclass N extends M {}"}, "----------\n1. ERROR in X.java (at line 2)\r\n\tvoid ambiguous() { new BB().test(new N()); }\r\n\t                            ^^^^\nThe method test(N) is ambiguous for the type BB\n----------\n");
    }

    public void test003c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid ambiguous() { new BB().test(new N(), Integer.valueOf(1)); }\n}\nclass AA<T> { void test(T t, Integer i) {} }\nclass BB extends AA<M> { <U extends Number> void test(N n, U u) {} }\nclass M {}\nclass N extends M {}"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid ambiguous() { new BB().test(new N(), Integer.valueOf(1)); }\n\t                            ^^^^\nThe method test(N, Integer) is ambiguous for the type BB\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer> m) {\n\t\tm.id(Integer.valueOf(111));\n\t}\n}\nclass C<T extends Number> { public void id(T t) {} }\nclass M<TT> extends C<Integer> { public <ZZ> void id(Integer i) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tm.id(Integer.valueOf(111));\n\t  ^^\nThe method id(Integer) is ambiguous for the type M<Integer>\n----------\n");
    }

    public void test004a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer> m) {\n\t\tm.id(new Integer(111));\n\t}\n}\nclass C<T extends Number> { public void id(T t) {} }\nclass M<TT> extends C<Integer> { public void id(Integer i) {} }\n"}, "");
    }

    public void test005() {
        String expectedCompilerLog = "----------\n1. ERROR in X.java (at line 2)\n\t<S extends A> void foo() { }\n\t                   ^^^^^\nDuplicate method foo() in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N extends B> N foo() { return null; }\n\t                ^^^^^\nDuplicate method foo() in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <S extends A> void foo() { }\n\t\t <N extends B> N foo() { return null; }\n\t\t void test () {\n\t\t \tnew X().foo();\n\t\t }\n}\nclass A {}\nclass B {}\n"}, expectedCompilerLog);
    }

    public void test006() {
        String expectedCompilerLog = "----------\n1. ERROR in X.java (at line 3)\n\tnew Y<Object>().foo(\"X\");\n\t                ^^^\nThe method foo(Object) is ambiguous for the type Y<Object>\n----------\n2. ERROR in X.java (at line 4)\n\tnew Y<Object>().foo2(\"X\");\n\t                ^^^^\nThe method foo2(Object) is ambiguous for the type Y<Object>\n----------\n3. ERROR in X.java (at line 10)\n\tvoid foo(T2 t) {}\n\t     ^^^^^^^^^\nName clash: The method foo(T2) of type Y<T2> has the same erasure as foo(U1) of type X<T> but does not override it\n----------\n4. ERROR in X.java (at line 11)\n\t<U3> void foo2(T2 t) {}\n\t          ^^^^^^^^^^\nName clash: The method foo2(T2) of type Y<T2> has the same erasure as foo2(U2) of type X<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   void test() {\n   \tnew Y<Object>().foo(\"X\");\n   \tnew Y<Object>().foo2(\"X\");\n   }\n\t<U1> U1 foo(U1 t) {return null;}\n\t<U2> U2 foo2(U2 t) {return null;}\n}\nclass Y<T2> extends X<T2> {\n\tvoid foo(T2 t) {}\n\t<U3> void foo2(T2 t) {}\n}\n"}, expectedCompilerLog);
    }

    public void test007() {
        this.runNegativeTest(new String[]{"B.java", "public class B {\n   public static void main(String[] args) {\n   \tnew M().foo(Integer.valueOf(1), 2);\n   \tnew N().foo(Integer.valueOf(1), 2);\n   }\n}interface I { void foo(Number arg1, Number arg2); }\nclass M {\n\tpublic void foo(int arg1, int arg2) {}\n\tpublic void foo(Number arg1, Number arg2) {}\n}\nclass N implements I {\n\tpublic void foo(int arg1, int arg2) {}\n\tpublic void foo(Number arg1, Number arg2) {}\n}\n"}, "----------\n1. ERROR in B.java (at line 3)\r\n\tnew M().foo(Integer.valueOf(1), 2);\r\n\t        ^^^\nThe method foo(int, int) is ambiguous for the type M\n----------\n2. ERROR in B.java (at line 4)\r\n\tnew N().foo(Integer.valueOf(1), 2);\r\n\t        ^^^\nThe method foo(int, int) is ambiguous for the type N\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"AA.java", "public class AA {\n   public static void main(String[] a) { System.out.print(new C().test(new T())); }\n}class S {}\nclass T extends S {}\nclass B { <U extends S> int test(U u) {return -1;} }\nclass C extends B { @Override int test(S s) {return 1;} }"}, "1");
    }

    public void test008a() {
        this.runNegativeTest(new String[]{"A.java", "public class A { void check() { new C().test(new T()); } }\nclass S {}\nclass T extends S {}\nclass B { int test(S s) {return 1;} }\nclass C extends B { <U extends S> int test(U u) {return -1;} }"}, "----------\n1. ERROR in A.java (at line 1)\n\tpublic class A { void check() { new C().test(new T()); } }\n\t                                        ^^^^\nThe method test(T) is ambiguous for the type C\n----------\n2. ERROR in A.java (at line 5)\n\tclass C extends B { <U extends S> int test(U u) {return -1;} }\n\t                                      ^^^^^^^^^\nName clash: The method test(U) of type C has the same erasure as test(S) of type B but does not override it\n----------\n");
    }

    public void test009() {
        String[] testFiles = new String[]{"T.java", "import java.util.*;\npublic class T {\n   void test() {\n   \tOrderedSet<String> os = null;\n   \tos.add(\"hello\");\n   \tOrderedSet<Integer> os2 = null;\n   \tos2.add(1);\n   }\n}\ninterface OrderedSet<E> extends List<E>, Set<E> { boolean add(E o); }\n"};
        this.runNegativeTest(testFiles, "----------\n1. WARNING in T.java (at line 5)\n\tos.add(\"hello\");\n\t^^\nNull pointer access: The variable os can only be null at this location\n----------\n2. WARNING in T.java (at line 7)\n\tos2.add(1);\n\t^^^\nNull pointer access: The variable os2 can only be null at this location\n----------\n3. ERROR in T.java (at line 10)\n\tinterface OrderedSet<E> extends List<E>, Set<E> { boolean add(E o); }\n\t          ^^^^^^^^^^\nDuplicate default methods named spliterator with the parameters () and () are inherited from the types Set<E> and List<E>\n----------\n");
    }

    public void test009a() {
        this.runConformTest(new String[]{"T.java", "import java.util.*;\npublic class T {\n   void test() {\n   \tOrderedSet<String> os = null;\n   \tos.add(\"hello\");\n   \tOrderedSet<Integer> os2 = null;\n   \tos2.add(1);\n   }\n}\ninterface OrderedSet<E> extends List<E>, Set<E> {\n\tboolean add(E o);\n   default Spliterator<E> spliterator() { return null; }\n}\n"}, "");
    }

    public void test010a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  \tinterface Listener {}\n  \tinterface ErrorListener {}\n  \tstatic <L1 extends Listener & ErrorListener> Object createParser(L1 l) { return null; }\n  \tstatic <L2 extends ErrorListener & Listener> Object createParser(L2 l) { return null; }\n   public static void main(String[] s) {\n   \tclass A implements Listener, ErrorListener {}\n   \tcreateParser(new A());\n   }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcreateParser(new A());\n\t^^^^^^^^^^^^\nThe method createParser(A) is ambiguous for the type X\n----------\n");
    }

    public void test010b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \tinterface Listener {}\n  \tinterface ErrorListener {}\n  \tstatic <L1 extends Listener> int createParser(L1 l) { return 1; }\n  \tstatic <L2 extends ErrorListener & Listener> int createParser(L2 l) { return 2; }\n   public static void main(String[] s) {\n   \tclass A implements Listener, ErrorListener {}\n   \tSystem.out.print(createParser(new A()));\n   }\n}"}, "2");
    }

    public void test010c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  \tinterface Listener {}\n  \tinterface ErrorListener {}\n  \tstatic int createParser(Listener l) { return 1; }\n  \tstatic <L extends ErrorListener & Listener> int createParser(L l) { return 2; }\n   public static void main(String[] s) {\n   \tclass A implements Listener, ErrorListener {}\n   \tSystem.out.print(createParser(new A()));\n   }\n}"}, "2");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A extends Number> extends Y<A> {\n\t<T> void foo(A n, T t) throws ExOne {}\n\tvoid test(X<Integer> x) throws ExTwo { x.foo(Integer.valueOf(1), Integer.valueOf(2)); }\n\tvoid test2(X x) throws ExTwo { x.foo(Integer.valueOf(1), Integer.valueOf(2)); }\n}\nclass Y<C extends Number> {\n\tvoid foo(C x, C n) throws ExTwo {}\n}\nclass ExOne extends Exception {static final long serialVersionUID = 1;}\nclass ExTwo extends Exception {static final long serialVersionUID = 2;}"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid test2(X x) throws ExTwo { x.foo(Integer.valueOf(1), Integer.valueOf(2)); }\n\t           ^\nX is a raw type. References to generic type X<A> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tvoid test2(X x) throws ExTwo { x.foo(Integer.valueOf(1), Integer.valueOf(2)); }\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method foo(Number, Number) belongs to the raw type Y. References to generic type Y<C> should be parameterized\n----------\n");
    }

    public void test011a() {
        String expectedCompilerLog = "----------\n1. ERROR in Combined.java (at line 2)\n\t<T extends Comparable<T>> void pickOne(T value) throws ExOne {}\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method pickOne(T) is the same as another method in type Combined<A,B>\n----------\n2. ERROR in Combined.java (at line 3)\n\t<T> T pickOne(Comparable<T> value) throws ExTwo { return null;}\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method pickOne(Comparable<T>) is the same as another method in type Combined<A,B>\n----------\n";
        this.runNegativeTest(new String[]{"Combined.java", "public class Combined<A, B> {\n\t<T extends Comparable<T>> void pickOne(T value) throws ExOne {}\n\t<T> T pickOne(Comparable<T> value) throws ExTwo { return null;}\n\tvoid pickOne(Combined<Integer,Integer> c) throws ExOne { c.pickOne(\"test\"); }\n\t<T extends Number> void pickTwo(Number n, T t) throws ExOne {}\n\tvoid pickTwo(A x, Number n) throws ExTwo {}\n\tvoid pickTwo(Combined<Integer,Integer> c) throws ExTwo { c.pickTwo(Integer.valueOf(1), 2); }\n}\nclass ExOne extends Exception {static final long serialVersionUID = 1;}\nclass ExTwo extends Exception {static final long serialVersionUID = 2;}"}, expectedCompilerLog);
    }

    public void test011b() {
        String expectedCompilerLog = "----------\n1. ERROR in Test1.java (at line 2)\n\t<T extends Comparable<T>> void pickOne(T value) throws ExOne {}\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method pickOne(T) is the same as another method in type Test1<AA,BB>\n----------\n2. ERROR in Test1.java (at line 3)\n\t<T> T pickOne(Comparable<T> value) throws ExTwo { return null;}\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method pickOne(Comparable<T>) is the same as another method in type Test1<AA,BB>\n----------\n3. WARNING in Test1.java (at line 4)\n\tvoid pickOne2(Test1<Integer,Integer> c) throws ExOne { c.pickOne((Comparable) \"test\"); }\n\t                                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation pickOne(Comparable) of the generic method pickOne(T) of type Test1<Integer,Integer>\n----------\n4. WARNING in Test1.java (at line 4)\n\tvoid pickOne2(Test1<Integer,Integer> c) throws ExOne { c.pickOne((Comparable) \"test\"); }\n\t                                                                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n";
        this.runNegativeTest(new String[]{"Test1.java", "public class Test1<AA, BB> {\n\t<T extends Comparable<T>> void pickOne(T value) throws ExOne {}\n\t<T> T pickOne(Comparable<T> value) throws ExTwo { return null;}\n\tvoid pickOne2(Test1<Integer,Integer> c) throws ExOne { c.pickOne((Comparable) \"test\"); }\n}\nclass ExOne extends Exception {static final long serialVersionUID = 1;}\nclass ExTwo extends Exception {static final long serialVersionUID = 2;}"}, expectedCompilerLog);
    }

    public void test012() {
        this.runConformTest(new String[]{"XX.java", "public class XX {\n\tpublic static void main(String[] s) { System.out.println(new B().id(new Integer(1))); }\n}\nclass A<T extends Number> { public int id(T t) {return 2;} }\nclass B extends A<Integer> { public int id(Integer i) {return 1;} }"}, "1");
    }

    public void test012a() {
        this.runNegativeTest(new String[]{"XX.java", "public class XX {\n\tpublic static void main(String[] s) { System.out.println(new B().id(Integer.valueOf(1))); }\n}\nclass A<T extends Number> { public int id(T t) {return 2;} }\nclass B extends A<Integer> { public <ZZ> int id(Integer i) {return 1;} }"}, "----------\n1. ERROR in XX.java (at line 2)\r\n\tpublic static void main(String[] s) { System.out.println(new B().id(Integer.valueOf(1))); }\r\n\t                                                                 ^^\nThe method id(Integer) is ambiguous for the type B\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<E extends A> void m(E e) { System.out.print(1); }\n\t<E extends B> void m(E e) { System.out.print(2); }\n\tpublic static void main(String[] args) {\n\t\tnew X().m(new A());\n\t\tnew X().m(new B());\n\t}\n}\nclass A {}\nclass B extends A {}\n"}, "12");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid a(G x) { System.out.print(1); }\n\tvoid b(F x) { System.out.print(2); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tG<C> g = null;\n\t\tnew X().a(h);\n\t\tnew X().a(g);\n\t\tnew X().b(h);\n\t\tnew X().b(g);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "1122");
    }

    public void test014a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid a(G<C> x) { System.out.print(1); }\n\tvoid b(F<C> x) { System.out.print(2); }\n\tpublic static void main(String[] args) {\n\t\tH h = null;\n\t\tG g = null;\n\t\tnew X().a(h);\n\t\tnew X().a(g);\n\t\tnew X().b(h);\n\t\tnew X().b(g);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "1122");
    }

    public void test014b() {
        this.runConformTest(new String[]{"X0.java", "public class X0 {\n\tvoid two(G x) { System.out.print(1); }\n\tvoid two(F<A> x) { System.out.print(2); }\n\tvoid three(G x) { System.out.print(3); }\n\tvoid three(F<B> x) { System.out.print(4); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X0().two(h);\n\t\tnew X0().three(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "13");
    }

    public void test014c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid a(G x) {}\n\tvoid a(F<C> x) {}\n\tvoid b(G<C> x) {}\n\tvoid b(F x) {}\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X().a(h);\n\t\tnew X().b(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "----------\n1. WARNING in X.java (at line 2)\r\n\tvoid a(G x) {}\r\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\r\n\tvoid b(F x) {}\r\n\t       ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n3. ERROR in X.java (at line 8)\r\n\tnew X().a(h);\r\n\t        ^\nThe method a(G) is ambiguous for the type X\n----------\n");
    }

    public void test014d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid one(G<B> x) {}\n\tvoid one(F<B> x) {}\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X().one(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "----------\n1. ERROR in X.java (at line 6)\r\n\tnew X().one(h);\r\n\t        ^^^\nThe method one(G<B>) in the type X is not applicable for the arguments (H<C>)\n----------\n");
    }

    public void test014e() {
        this.runConformTest(new String[]{"X1.java", "public class X1 {\n\tvoid two(G<C> x) { System.out.print(1); }\n\tvoid two(F<B> x) { System.out.print(2); }\n\tvoid three(G<B> x) { System.out.print(3); }\n\tvoid three(F<C> x) { System.out.print(4); }\n\tvoid four(G<C> x) { System.out.print(5); }\n\tvoid four(F<C> x) { System.out.print(6); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X1().two(h);\n\t\tnew X1().three(h);\n\t\tnew X1().four(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "145");
    }

    public void test014f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<E1, E2 extends B> void three(G<E2> x) {}\n\t<E3 extends C> void three(F<E3> x) {}\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X().three(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "----------\n1. ERROR in X.java (at line 6)\r\n\tnew X().three(h);\r\n\t        ^^^^^\nThe method three(G<C>) is ambiguous for the type X\n----------\n");
    }

    public void test014g() {
        this.runConformTest(new String[]{"X3.java", "public class X3 {\n\t<E1, E2 extends B> void one(G<E2> x) { System.out.print(1); }\n\t<E3 extends B> void one(F<E3> x) { System.out.print(2); }\n\t<E1, E2 extends C> void two(G<E2> x) { System.out.print(3); }\n\t<E3 extends B> void two(F<E3> x) { System.out.print(4); }\n\t<E1, E2 extends C> void four(G<E2> x) { System.out.print(5); }\n\t<E3 extends C> void four(F<E3> x) { System.out.print(6); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tnew X3().one(h);\n\t\tnew X3().two(h);\n\t\tnew X3().four(h);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "135");
    }

    public void test014h() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid x(G x) { System.out.print(true); }\n\tvoid x(F x) { System.out.print(false); }\n\tvoid x2(G<C> x) { System.out.print(true); }\n\tvoid x2(F<C> x) { System.out.print(false); }\n\tvoid a(G x) {}\n\tvoid a(F<C> x) {}\n\tvoid a2(G x) {}\n\t<T extends C> void a2(F<T> x) {}\n\tvoid a3(G x) {}\n\t<T extends F<C>> void a3(T x) {}\n\tvoid a4(G x) {}\n\t<T extends C, S extends F<T>> void a4(S x) {}\n\t<T extends G> void a5(T x) {}\n\tvoid a5(F<C> x) {}\n\t<T extends G> void a6(T x) {}\n\t<T extends C, S extends F<T>> void a6(S x) {}\n\tvoid b(G<C> x) { System.out.print(true); }\n\tvoid b(F x) { System.out.print(false); }\n\tvoid b2(G<C> x) { System.out.print(true); }\n\t<T extends F> void b2(T x) { System.out.print(false); }\n\t<T extends C> void b3(G<T> x) { System.out.print(true); }\n\tvoid b3(F x) { System.out.print(false); }\n\t<T extends G<C>> void b4(T x) { System.out.print(true); }\n\tvoid b4(F x) { System.out.print(false); }\n\t<T extends C, S extends G<T>> void b5(S x) { System.out.print(true); }\n\tvoid b5(F x) { System.out.print(false); }\n\tvoid c(G x) { System.out.print(true); }\n\t<T extends C> void c(F x) { System.out.print(false); }\n\tpublic static void main(String[] args) {\n\t\tH<C> h = null;\n\t\tH hraw = null;\n\t\tnew X().x(h);\n\t\tnew X().x(hraw);\n\t\tnew X().x2(h);\n\t\tnew X().x2(hraw);\n\t\tnew X().b(h);\n\t\tnew X().b(hraw);\n\t\tnew X().b2(h);\n\t\tnew X().b2(hraw);\n\t\tnew X().b3(h);\n\t\tnew X().b3(hraw);\n\t\tnew X().b4(h);\n\t\tnew X().b4(hraw);\n\t\tnew X().b5(h);\n\t\tnew X().b5(hraw);\n\t\tnew X().c(h);\n\t\tnew X().c(hraw);\n\t}\n}\nclass A {}\nclass B extends A {}\nclass C extends B {}\nclass F<T1> {} \nclass G<T2> extends F<T2> {}\nclass H<T3> extends G<T3> {}"}, "truetruetruetruetruetruetruetruetruetruetruetruetruetruetruetrue");
        this.runNegativeTest(new String[]{"Y.java", "public class Y extends X {\n\tpublic static void ambiguousCases() {\n\t\tH<C> h = null;\n\t\tH hraw = null;\n\t\tnew X().a(h);\n\t\tnew X().a(hraw);\n\t\tnew X().a2(h);\n\t\tnew X().a2(hraw);\n\t\tnew X().a3(h);\n\t\tnew X().a3(hraw);\n\t\tnew X().a4(h);\n\t\tnew X().a4(hraw);\n\t\tnew X().a5(h);\n\t\tnew X().a5(hraw);\n\t\tnew X().a6(h);\n\t\tnew X().a6(hraw);\n\t}\n}\n"}, "----------\n1. WARNING in Y.java (at line 4)\n\tH hraw = null;\n\t^\nH is a raw type. References to generic type H<T3> should be parameterized\n----------\n2. ERROR in Y.java (at line 5)\n\tnew X().a(h);\n\t        ^\nThe method a(G) is ambiguous for the type X\n----------\n3. ERROR in Y.java (at line 6)\n\tnew X().a(hraw);\n\t        ^\nThe method a(G) is ambiguous for the type X\n----------\n4. ERROR in Y.java (at line 7)\n\tnew X().a2(h);\n\t        ^^\nThe method a2(G) is ambiguous for the type X\n----------\n5. ERROR in Y.java (at line 8)\n\tnew X().a2(hraw);\n\t        ^^\nThe method a2(G) is ambiguous for the type X\n----------\n6. ERROR in Y.java (at line 13)\n\tnew X().a5(h);\n\t        ^^\nThe method a5(H<C>) is ambiguous for the type X\n----------\n7. ERROR in Y.java (at line 14)\n\tnew X().a5(hraw);\n\t        ^^\nThe method a5(H) is ambiguous for the type X\n----------\n", null, false);
    }

    public void test014i() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T> {}\ninterface J<T> extends I<T> {}\n\nclass X {\n\tvoid a(G x) {}\n\t<T extends C, S extends F<T>> void a(S x) {}\n\n\tvoid b(G x) {}\n\tvoid b(F x) {}\n\n\tvoid c(G x) {}\n\tvoid c(F<?> x) {}\n\n\tvoid d(G x) {}\n\tvoid d(F<C> x) {}\n\n\tvoid e(G x) {}\n\t<T extends C> void e(F<T> x) {}\n\n\tvoid f(G x) {}\n\t<S extends F> void f(S x) {}\n\n\tvoid g(G x) {}\n\t<S extends F & J<S>> void g(S x) {}\n\n\t<T extends G> void a2(T x) {}\n\t<T extends C, S extends F<T>> void a2(S x) {}\n\n\t<T extends G> void b2(T x) {}\n\tvoid b2(F x) {}\n\n\t<T extends G> void c2(T x) {}\n\tvoid c2(F<?> x) {}\n\n\t<T extends G> void d2(T x) {}\n\tvoid d2(F<C> x) {}\n\n\t<T extends G> void e2(T x) {}\n\t<T extends C> void e2(F<T> x) {}\n\n\t<T extends G> void f2(T x) {}\n\t<S extends F & J> void f2(S x) {}\n\n\t<T extends G> void g2(T x) {}\n\t<S extends F & J<S>> void g2(S x) {}\n\n\tvoid test() {\n\t\tX x = new X();\n\t\tH<C> h = null;\n\t\tH hraw = null;\n\n\t\tx.a(h);\n\t\tx.a(hraw);\n\n\t\tx.b(h);\n\t\tx.b(hraw);\n\n\t\tx.c(h);\n\t\tx.c(hraw);\n\n\t\tx.d(h);\n\t\tx.d(hraw);\n\n\t\tx.e(h);\n\t\tx.e(hraw);\n\n\t\tx.f(h);\n\t\tx.f(hraw);\n\n\t\tx.g(h);\n\t\tx.g(hraw);\n\n\t\tx.a2(h);\n\t\tx.a2(hraw);\n\n\t\tx.b2(h);\t\n\t\tx.b2(hraw);\n\n\t\tx.c2(h);\n\t\tx.c2(hraw);\n\n\t\tx.d2(h);\n\t\tx.d2(hraw);\n\n\t\tx.e2(h);\n\t\tx.e2(hraw);\n\n\t\tx.f2(h);\n\t\tx.f2(hraw);\n\n\t\tx.g2(h);\t\n\t\tx.g2(hraw);\n\t}\n}\n\nclass A {}\nclass B extends A {}\nclass C extends B implements I {}\nclass F<T1> {} \nclass G<T2> extends F<T2> implements J<T2> {}\nclass H<T3> extends G<T3> {}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid a(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n2. WARNING in X.java (at line 8)\n\tvoid b(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\tvoid b(F x) {}\n\t       ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n4. WARNING in X.java (at line 11)\n\tvoid c(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n5. WARNING in X.java (at line 14)\n\tvoid d(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n6. WARNING in X.java (at line 17)\n\tvoid e(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n7. WARNING in X.java (at line 20)\n\tvoid f(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n8. WARNING in X.java (at line 21)\n\t<S extends F> void f(S x) {}\n\t           ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n9. WARNING in X.java (at line 23)\n\tvoid g(G x) {}\n\t       ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n10. WARNING in X.java (at line 24)\n\t<S extends F & J<S>> void g(S x) {}\n\t           ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n11. WARNING in X.java (at line 26)\n\t<T extends G> void a2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n12. WARNING in X.java (at line 29)\n\t<T extends G> void b2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n13. WARNING in X.java (at line 30)\n\tvoid b2(F x) {}\n\t        ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n14. WARNING in X.java (at line 32)\n\t<T extends G> void c2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n15. WARNING in X.java (at line 35)\n\t<T extends G> void d2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n16. WARNING in X.java (at line 38)\n\t<T extends G> void e2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n17. WARNING in X.java (at line 41)\n\t<T extends G> void f2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n18. WARNING in X.java (at line 42)\n\t<S extends F & J> void f2(S x) {}\n\t           ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n19. WARNING in X.java (at line 42)\n\t<S extends F & J> void f2(S x) {}\n\t               ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n20. WARNING in X.java (at line 44)\n\t<T extends G> void g2(T x) {}\n\t           ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n21. WARNING in X.java (at line 45)\n\t<S extends F & J<S>> void g2(S x) {}\n\t           ^\nF is a raw type. References to generic type F<T1> should be parameterized\n----------\n22. WARNING in X.java (at line 50)\n\tH hraw = null;\n\t^\nH is a raw type. References to generic type H<T3> should be parameterized\n----------\n23. ERROR in X.java (at line 61)\n\tx.d(h);\n\t  ^\nThe method d(G) is ambiguous for the type X\n----------\n24. ERROR in X.java (at line 62)\n\tx.d(hraw);\n\t  ^\nThe method d(G) is ambiguous for the type X\n----------\n25. ERROR in X.java (at line 64)\n\tx.e(h);\n\t  ^\nThe method e(G) is ambiguous for the type X\n----------\n26. ERROR in X.java (at line 65)\n\tx.e(hraw);\n\t  ^\nThe method e(G) is ambiguous for the type X\n----------\n27. ERROR in X.java (at line 82)\n\tx.d2(h);\n\t  ^^\nThe method d2(H<C>) is ambiguous for the type X\n----------\n28. ERROR in X.java (at line 83)\n\tx.d2(hraw);\n\t  ^^\nThe method d2(H) is ambiguous for the type X\n----------\n29. ERROR in X.java (at line 85)\n\tx.e2(h);\n\t  ^^\nThe method e2(H<C>) is ambiguous for the type X\n----------\n30. ERROR in X.java (at line 86)\n\tx.e2(hraw);\n\t  ^^\nThe method e2(H) is ambiguous for the type X\n----------\n31. WARNING in X.java (at line 98)\n\tclass C extends B implements I {}\n\t                             ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n");
    }

    public void test015() {
        this.runConformTest(new String[]{"E.java", "public class E {\n\tpublic static void main(String[] s) {\n\t\tIJ ij = new K();\n\t\ttry { ij.m(); } catch(E11 e) {}\n\t}\n}\ninterface I { void m() throws E1; }\ninterface J { void m() throws E11; }\ninterface IJ extends I, J {}\nclass K implements IJ { public void m() {} }\nclass E1 extends Exception { static final long serialVersionUID = 1; }\nclass E11 extends E1 { static final long serialVersionUID = 2; }\nclass E2 extends Exception { static final long serialVersionUID = 3; }"}, "");
    }

    public void _test016() {
        this.runConformTest(new String[]{"E.java", "public class E {\n\tpublic static void main(String[] s) {\n\t\tIJ ij = new K();\n\t\ttry { ij.m(); } catch(E11 e) {}\n\t}\n}\ninterface I { void m() throws E1; }\ninterface J { void m() throws E2, E11; }\ninterface IJ extends I, J {}\nclass K implements IJ { public void m() {} }\nclass E1 extends Exception { static final long serialVersionUID = 1; }\nclass E11 extends E1 { static final long serialVersionUID = 2; }\nclass E2 extends Exception { static final long serialVersionUID = 3; }"}, "");
    }

    public void _test016a() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tpublic static void main(String[] s) {\n\t\tIJ ij = new K();\n\t\tij.m();\n\t\ttry { ij.m(); } catch(E2 e) {}\n\t}\n}\ninterface I { void m() throws E1; }\ninterface J { void m() throws E2, E11; }\ninterface IJ extends I, J {}\nclass K implements IJ { public void m() {} }\nclass E1 extends Exception { static final long serialVersionUID = 1; }\nclass E11 extends E1 { static final long serialVersionUID = 2; }\nclass E2 extends Exception { static final long serialVersionUID = 3; }"}, "----------\n1. ERROR in E.java (at line 4)\r\n\tij.m();\r\n\t^^^^^^\nUnhandled exception type E11\n----------\n2. ERROR in E.java (at line 5)\r\n\ttry { ij.m(); } catch(E2 e) {}\r\n\t      ^^^^^^\nUnhandled exception type E11\n----------\n3. ERROR in E.java (at line 5)\r\n\ttry { ij.m(); } catch(E2 e) {}\r\n\t                      ^^\nUnreachable catch block for E2. This exception is never thrown from the try statement body\n----------\n");
    }

    public void test017() {
        this.runConformTest(new String[]{"AbstractFilter.java", "import java.util.*;\npublic class AbstractFilter<T> implements IFilter<T> {\n\tpublic final <E extends T> boolean selekt(E obj) { return true; }\n\tpublic final <E extends T> List<E> filter(List<E> elements) {\n\t\tif ((elements == null) || (elements.size() == 0)) return elements;\n\t\tList<E> okElements = new ArrayList<E>(elements.size());\n\t\tfor (E obj : elements) {\n\t\t\tif (selekt(obj)) okElements.add(obj);\n\t\t}\n\t\treturn okElements;\t}\n}\ninterface IFilter<T> {\n\t<E extends T> boolean selekt(E obj);\n\t<E extends T> List<E> filter(List<E> elements);\n}"}, "");
    }

    public void test021() {
        String expectedCompilerLog = "----------\n1. WARNING in Y.java (at line 3)\n\tpublic class Y<V extends String> extends X<V> {\n\t                         ^^^^^^\nThe type parameter V should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. WARNING in Y.java (at line 4)\n\tpublic static <W extends String> Y<W> make(Class<W> clazz) {\n\t                         ^^^^^^\nThe type parameter W should not be bounded by the final type String. Final types cannot be further extended\n----------\n3. ERROR in Y.java (at line 4)\n\tpublic static <W extends String> Y<W> make(Class<W> clazz) {\n\t                                      ^^^^^^^^^^^^^^^^^^^^\nErasure of method make(Class<W>) is the same as another method in type Y<V>\n----------\n4. ERROR in Y.java (at line 8)\n\tpublic static <U extends Object> X<U> make(Class<U> clazz) {\n\t                                      ^^^^^^^^^^^^^^^^^^^^\nErasure of method make(Class<U>) is the same as another method in type Y<V>\n----------\n5. WARNING in Y.java (at line 13)\n\tY.make(getClazz());\n\t^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation make(Class) of the generic method make(Class<W>) of type Y\n----------\n6. WARNING in Y.java (at line 13)\n\tY.make(getClazz());\n\t       ^^^^^^^^^^\nType safety: The expression of type Class needs unchecked conversion to conform to Class<String>\n----------\n7. WARNING in Y.java (at line 15)\n\tpublic static Class getClazz() {\n\t              ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n";
        this.runNegativeTest(new String[]{"Y.java", "class X<T extends Object> {\n}\npublic class Y<V extends String> extends X<V> {\n  public static <W extends String> Y<W> make(Class<W> clazz) {\n    System.out.print(true);\n    return new Y<W>();\n  }\n  public static <U extends Object> X<U> make(Class<U> clazz) {\n    System.out.print(false);\n    return new X<U>();\n  }\n  public static void main(String[] args) throws Exception {\n    Y.make(getClazz());\n  }\n  public static Class getClazz() {\n    return String.class;\n  }\n}"}, expectedCompilerLog);
    }

    public void test022() {
        String expectedCompilerLog = "----------\n1. WARNING in X.java (at line 3)\n\tclass Y<V extends String> extends X<V> {\n\t                  ^^^^^^\nThe type parameter V should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. WARNING in X.java (at line 4)\n\tpublic <W extends String> Y<W> make(Class<W> clazz) {\n\t                  ^^^^^^\nThe type parameter W should not be bounded by the final type String. Final types cannot be further extended\n----------\n3. ERROR in X.java (at line 4)\n\tpublic <W extends String> Y<W> make(Class<W> clazz) {\n\t                               ^^^^^^^^^^^^^^^^^^^^\nErasure of method make(Class<W>) is the same as another method in type Y<V>\n----------\n4. ERROR in X.java (at line 7)\n\tpublic <U extends Object> X<U> make(Class<U> clazz) {\n\t                               ^^^^^^^^^^^^^^^^^^^^\nErasure of method make(Class<U>) is the same as another method in type Y<V>\n----------\n5. WARNING in X.java (at line 12)\n\tY y = new Y();\n\t^\nY is a raw type. References to generic type Y<V> should be parameterized\n----------\n6. WARNING in X.java (at line 12)\n\tY y = new Y();\n\t          ^\nY is a raw type. References to generic type Y<V> should be parameterized\n----------\n7. WARNING in X.java (at line 13)\n\ty.make(String.class);\n\t^^^^^^^^^^^^^^^^^^^^\nType safety: The method make(Class) belongs to the raw type Y. References to generic type Y<V> should be parameterized\n----------\n8. WARNING in X.java (at line 14)\n\ty.make(getClazz());\n\t^^^^^^^^^^^^^^^^^^\nType safety: The method make(Class) belongs to the raw type Y. References to generic type Y<V> should be parameterized\n----------\n9. WARNING in X.java (at line 15)\n\ty.make(getClazz().newInstance().getClass());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method make(Class) belongs to the raw type Y. References to generic type Y<V> should be parameterized\n----------\n10. WARNING in X.java (at line 17)\n\tpublic static Class getClazz() {\n\t              ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Object> {\n}\nclass Y<V extends String> extends X<V> {\n  public <W extends String> Y<W> make(Class<W> clazz) {\n    return new Y<W>();\n  }\n  public <U extends Object> X<U> make(Class<U> clazz) {\n    return new X<U>();\n  }\n  @SuppressWarnings({\"deprecation\"})\n  public static void main(String[] args) throws Exception {\n    Y y = new Y();\n    y.make(String.class);\n    y.make(getClazz());\n    y.make(getClazz().newInstance().getClass());\n  }\n  public static Class getClazz() {\n    return String.class;\n  }\n}"}, expectedCompilerLog);
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static void staticFoo(Collection<?> p) {\n    System.out.print(1);\n  }\n  public static <T extends List<?>> void staticFoo(T p) {\n    System.out.print(2);\n  }\n  public void foo(Collection<?> p) {\n    System.out.print(1);\n  }\n  public <T extends List<?>> void foo(T p) {\n    System.out.print(2);\n  }\n  public void foo2(Collection<?> p) {\n    System.out.print(1);\n  }\n  public void foo2(List<?> p) {\n    System.out.print(2);\n  }\n  public static void main(String[] args) {\n    staticFoo(new ArrayList<String>(Arrays.asList(\"\")));\n    new X().foo(new ArrayList<String>(Arrays.asList(\"\")));\n    new X().foo2(new ArrayList<String>(Arrays.asList(\"\")));\n  }\n}"}, "222");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void foo(L1<?> p) {\n    System.out.println(1);\n  }\n  public static <T extends L2<?>> void foo(T p) {\n    System.out.println(2);\n  }\n  public static void main(String[] args) {\n    foo(new L3<String>());\n  }\n}", "L1.java", "public interface L1<T> {\n}", "L2.java", "public interface L2<T> extends L1<T> {\n}", "L3.java", "public class L3<T> implements L2<T> {\n  public L3() {\n  }\n}"}, "2");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  J m = new Y();\n  void foo() {\n    m.foo(1.0f);\n  }\n}", "I.java", "public interface I {\n  <T extends Number> T foo(final Number p);\n}", "J.java", "public interface J extends I {\n  Float foo(final Number p);\n}", "Y.java", "public class Y implements J {\n  public Float foo(final Number p){\n    return null;\n  }\n}"}, "");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    (new Y()).foo(1.0f);\n  }\n}", "I.java", "public interface I {\n  <T extends Number> T foo(final Number p);\n}", "J.java", "public interface J extends I {\n  Float foo(final Number p);\n}", "Y.java", "public class Y implements J {\n  public Float foo(final Number p){\n    return null;  }\n}"}, "");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"J.java", "public interface J {\n  <T extends Number> T foo(final Number p);\n  Float foo(final Number p);\n}"}, "----------\n1. ERROR in J.java (at line 2)\n\t<T extends Number> T foo(final Number p);\n\t                     ^^^^^^^^^^^^^^^^^^^\nDuplicate method foo(Number) in type J\n----------\n2. ERROR in J.java (at line 3)\n\tFloat foo(final Number p);\n\t      ^^^^^^^^^^^^^^^^^^^\nDuplicate method foo(Number) in type J\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "interface Irrelevant {}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends Irrelevant, I {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"});
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "interface J {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"});
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "interface J {\n  Object foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"}, "");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "interface Irrelevant {}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends Irrelevant, I {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n}\npublic abstract class X implements Irrelevant, I, J, K {\n  void foo() {\n    foo(0.0f);\n  }\n}"});
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(Number n);\n}\nabstract class J {\n  abstract String foo(Number n);\n}\npublic class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n  public String foo(Number n) {\n    return null;\n  }\n}"}, "");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(Number n);\n}\nabstract class J {\n  abstract String foo(Number n);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}"});
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}"});
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    String s = ((J) this).foo(0.0f);\n  }\n}"}, "");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    Object o = ((I) this).foo(0.0f);\n  }\n}"}, "");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    String s = ((I) this).foo(0.0f);\n    s = this.foo(0.0f);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tString s = ((I) this).foo(0.0f);\n\t           ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to String\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}\nclass Z extends X {\n  @Override  public String foo(float f) {\n    return null;\n  }\n}"});
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  Object foo(float f);\n}\nabstract class J {\n  public abstract String foo(float f);\n}\npublic abstract class X extends J implements I {\n  void bar() {\n    foo(0.0f);\n  }\n}\nclass Z extends X {\n  @Override\n  public Object foo(float f) {\n    return null;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 14)\n\tpublic Object foo(float f) {\n\t       ^^^^^^\nThe return type is incompatible with J.foo(float)\n----------\n");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "interface I<E> {}\nclass Y<E> {}\npublic class X<E extends Y<E>> implements I<E> {\n  public static <E extends Y<E>> X<E> bar(X<E> s) {\n    return null;\n  }\n  public static <E extends Y<E>> X<E> bar(I<E> c) {\n    return null;\n  }\n  public static <E extends Y<E>> X<E> foo(X<E> s) {\n    X<E> result = bar(s);\n    return result;\n  }\n}"}, "");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "abstract class Y<T> implements I<T> {\n}\ninterface I<T> { \n}\ninterface J<T> {\n}\nclass X {\n  public static <V extends J<? super V>> V foo(final I<V> a)\n  {\n    return null;\n  }\n  public static <V extends J<? super V>> V foo(final Y<V> a)\n  {\n    return null;\n  }\n  public static <V extends J<? super V>> void test(final Y<V> a)\n  {\n    foo(a);\n  }\n}"}, "");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "abstract class Y<T, U> implements I<T, U> {\n}\ninterface I<T, U> { \n}\ninterface J<T, U> {\n}\nclass X {\n  public static <V extends J<V, W>, W extends J<V, W>> V foo(final I<V, W> a)\n  {\n    return null;\n  }\n  public static <V extends J<V, W>, W extends J<V, W>> V foo(final Y<V, W> a)\n  {\n    return null;\n  }\n  public static <V extends J<V, W>, W extends J<V, W>> void test(final Y<V, W> a)\n  {\n    foo(a);\n  }\n}"}, "");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends I & J> {\n  void foo(T t) {\n  }\n}\ninterface I {\n  public int method();\n}\ninterface J {\n  public boolean method();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends I & J> {\n\t               ^\nThe return types are incompatible for the inherited methods I.method(), J.method()\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug5061359);
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends I & J> {\n  void foo(T t) {\n    t.method();\n    t.bar();\n    if (t.CONSTANT > 0);\n  }\n}\ninterface I {\n  public int method();\n  void bar();\n}\ninterface J {\n  public boolean method();\n  static final int CONSTANT = 0;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T extends I & J> {\n\t               ^\nThe return types are incompatible for the inherited methods I.method(), J.method()\n----------\n2. ERROR in X.java (at line 3)\n\tt.method();\n\t  ^^^^^^\nThe method method() is ambiguous for the type T\n----------\n3. WARNING in X.java (at line 5)\n\tif (t.CONSTANT > 0);\n\t      ^^^^^^^^\nThe static field J.CONSTANT should be accessed in a static way\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  public int method();\n}\ninterface J {\n  public boolean method();\n}\nclass X implements I, J {\n  public int method() {\n    return 0;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic int method() {\n\t       ^^^\nThe return type is incompatible with J.method()\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends I & J> {\n  void foo(T t) {\n  }\n}\ninterface I {\n  public int method();\n}\ninterface J {\n  public int method();\n}\n"}, "");
    }

    public void test051() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug427719, new String[]{"X.java", "interface I<T> {\n}\nclass Y {\n  void bar(I<?> x) {\n  }\n}\npublic class X extends Y {\n  void foo() {\n    bar(new Z());\n  }\n  void bar(Z x) {\n  }\n  private static final class Z implements I {\n  }\n}\n"}, this.complianceLevel < 0x370000L ? "----------\n1. WARNING in X.java (at line 9)\n\tbar(new Z());\n\t    ^^^^^^^\nAccess to enclosing constructor X.Z() is emulated by a synthetic accessor method\n----------\n2. WARNING in X.java (at line 13)\n\tprivate static final class Z implements I {\n\t                                        ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n" : "----------\n1. WARNING in X.java (at line 13)\n\tprivate static final class Z implements I {\n\t                                        ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n");
    }

    public void test052() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n}\nclass Y {\n  void bar(I<?> x) {\n  }\n}\npublic class X extends Y {\n  void foo() {\n    bar(new Z());\n  }\n  void bar(Z x) {\n  }\n  private static final class Z implements I<String> {\n  }\n}\n"}, "");
    }

    public void test053() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug427719, new String[]{"X.java", "interface I<T> {\n}\nclass Y {\n  void bar(I<?> x) {\n  }\n}\npublic class X extends Y {\n  void foo() {\n    bar(new Z(){});\n  }\n  void bar(Z x) {\n  }\n  private static class Z implements I {\n  }\n}\n"}, this.complianceLevel < 0x370000L ? "----------\n1. WARNING in X.java (at line 9)\n\tbar(new Z(){});\n\t        ^^^\nAccess to enclosing constructor X.Z() is emulated by a synthetic accessor method\n----------\n2. WARNING in X.java (at line 13)\n\tprivate static class Z implements I {\n\t                                  ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n" : "----------\n1. WARNING in X.java (at line 13)\n\tprivate static class Z implements I {\n\t                                  ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n");
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void bar(Z x) {\n    System.out.println(\"bar(Z)\");\n  }\n  void bar(I<?> x) {\n    System.out.println(\"bar(I)\");\n  }\n  public static void main(String args[]) {\n    (new X()).bar(new Z());\n  }\n}\ninterface I<T> {}\nclass Z implements I<Object> {}"}, "bar(Z)");
    }

    public void _test055() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T> {}\nclass X {\n  void bar(Z x) {\n    System.out.println(\"bar(Z)\");\n  }\n  void bar(I<?> x) {\n    System.out.println(\"bar(I)\");\n  }\n  public static void main(String args[]) {\n    (new X()).bar(new Z());\n  }\n}\nclass Z implements I {}"}, "ERR");
    }

    public void test057() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n\t@Override <T4, G4 extends I<T4>> T4 foo(G4 g) { return super.foo(g); }\n}\nclass Y extends Z {\n\t@Override <T3, G3 extends I<T3>> T3 foo(G3 g) { return super.foo(g); }\n}\nclass Z {\n\t<T2, G2 extends I<T2>> T2 foo(G2 g) { return null; }\n}\ninterface I<T1> {}"}, "");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "public class X extends A {\n\tvoid x(G g) { System.out.print(1); }\n\tvoid x(G g, G g2) { System.out.print(1); }\n\tpublic static void main(String[] s) {\n\t\tH h = new H();\n\t\tnew X().x(h);\n\t\tnew X().x(h, h);\n\t}\n}\nclass A<T> {\n\tvoid x(T t) { System.out.print(2); }\n\t<U> void x(T t, U u) { System.out.print(2); }\n}\nclass F<T> {}\nclass G<T> extends F<T> {}\nclass H<T> extends G<T> {}"}, "11");
    }

    public void test058a() {
        this.runConformTest(new String[]{"X.java", "public class X extends java.util.ArrayList {\n\tprivate static final long serialVersionUID = 1L;\n\tpublic void add(Comparable o) {}\n\tpublic void test() { add(\"hello\"); }\n}"}, "");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {\n\tX() {}\n\tX(String s) {}\n\tX(T t) {}\n\tvoid foo(String s) {}\n\tvoid foo(T t) {}\n}\nclass NoErrorSubclass extends X<String> {}\nclass StringOnlySubClass extends X<String> {\n\tStringOnlySubClass(String s) { super(s); }\n\t@Override void foo(String s) { super.foo(s); }\n}\nclass Test {\n\tObject o = new X<String>(\"xyz\");\n\tvoid test(X<String> x) { x.foo(\"xyz\"); }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tclass NoErrorSubclass extends X<String> {}\n\t      ^^^^^^^^^^^^^^^\nDuplicate methods named foo with the parameters (T) and (String) are defined by the type X<String>\n----------\n2. ERROR in X.java (at line 10)\n\tStringOnlySubClass(String s) { super(s); }\n\t                               ^^^^^^^^^\nThe constructor X<String>(String) is ambiguous\n----------\n3. ERROR in X.java (at line 11)\n\t@Override void foo(String s) { super.foo(s); }\n\t                                     ^^^\nThe method foo(String) is ambiguous for the type X<String>\n----------\n4. ERROR in X.java (at line 14)\n\tObject o = new X<String>(\"xyz\");\n\t           ^^^^^^^^^^^^^^^^^^^^\nThe constructor X<String>(String) is ambiguous\n----------\n5. ERROR in X.java (at line 15)\n\tvoid test(X<String> x) { x.foo(\"xyz\"); }\n\t                           ^^^\nThe method foo(String) is ambiguous for the type X<String>\n----------\n");
    }

    public void test059a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.TreeMap;\nclass X {\n\tvoid test(TreeMap<String, Object> tm) {\n\t\tTreeMap copy = new TreeMap(tm);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tTreeMap copy = new TreeMap(tm);\n\t^^^^^^^\nTreeMap is a raw type. References to generic type TreeMap<K,V> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tTreeMap copy = new TreeMap(tm);\n\t               ^^^^^^^^^^^^^^^\nType safety: The constructor TreeMap(SortedMap) belongs to the raw type TreeMap. References to generic type TreeMap<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tTreeMap copy = new TreeMap(tm);\n\t                   ^^^^^^^\nTreeMap is a raw type. References to generic type TreeMap<K,V> should be parameterized\n----------\n");
    }

    public void test060() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic void bar(K<T, Object> p) {\n\t\tnew Y(p);\n\t\tnew Y((J<T, Object>) p);\n\t\tnew Y((I<T, Object>) p);\n\t}\n}\nclass Y<T, U> {\n\tY(I<? extends T, ? extends U> p) {}\n\tY(J<T, ? extends U> p) {}\n}\ninterface I<T, U> {}\ninterface J<T, U> extends I<T, U> {}\ninterface K<T, U> extends I<T, U>, J<T, U> {}"}, "");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic void bar(K<T, Object> p) {\n\t\tnew Y(p);\n\t\tnew Y((J<T, Object>) p);\n\t\tnew Y((I<T, Object>) p);\n\t}\n}\nclass Y<T, U> {\n\tY(I<? extends T, ? extends U> p) {}\n\tY(J<T, ? extends U> p) {}\n}\ninterface I<T, U> {}\ninterface J<T, U> {}\ninterface K<T, U> extends I<T, U>, J<T, U> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Y(p);\n\t^^^^^^^^\nThe constructor Y(I) is ambiguous\n----------\n2. WARNING in X.java (at line 3)\n\tnew Y(p);\n\t    ^\nY is a raw type. References to generic type Y<T,U> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tnew Y((J<T, Object>) p);\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The constructor Y(J) belongs to the raw type Y. References to generic type Y<T,U> should be parameterized\n----------\n4. WARNING in X.java (at line 4)\n\tnew Y((J<T, Object>) p);\n\t    ^\nY is a raw type. References to generic type Y<T,U> should be parameterized\n----------\n5. WARNING in X.java (at line 5)\n\tnew Y((I<T, Object>) p);\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The constructor Y(I) belongs to the raw type Y. References to generic type Y<T,U> should be parameterized\n----------\n6. WARNING in X.java (at line 5)\n\tnew Y((I<T, Object>) p);\n\t    ^\nY is a raw type. References to generic type Y<T,U> should be parameterized\n----------\n");
    }

    public void test062() {
        this.runConformTest(new String[]{"X.java", "enum E implements I {\n\tF;\n}\ninterface I {}\ninterface Spec {\n\t<T1 extends Enum<T1> & I> void method(T1 t);\n}\nabstract class X implements Spec {\n\tpublic <T2 extends Enum<T2> & I> void method(T2 t) {}\n\tvoid test() { method(E.F); }\n}"}, "");
    }

    public void test063() {
        this.runConformTest(new String[]{"Test.java", "interface I<R> {}\nclass X<T extends I> {\n\tvoid method(X<?> that) {}\n}\nclass Y<T extends I> extends X<T> {\n\t@Override void method(X<? extends I> that) { System.out.print(1); }\n}\npublic class Test {\n\tpublic static void main(String[] args) { new Y().method((X) null); }\n}"}, "1");
    }

    public void test064() {
        this.runConformTest(new String[]{"A.java", "interface I<E> {\n\tvoid x(I<? extends E> i);\n}\npublic abstract class A implements I {\n\tpublic void x(I i) {}\n}\nclass B extends A {\n\tvoid y(A a) { super.x(a); }\n}"}, "");
    }

    public void test065() {
        this.runConformTest(new String[]{"A.java", "public abstract class A {\n\tabstract <T extends Number & Comparable<T>> void m(T x);\n}\nclass B extends A {\n\t@Override <T extends Number & Comparable<T>> void m(T x) {}\n}"}, "");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.*;\npublic class A {\n\tvoid foo(Collection<Object[]> c) {}\n\tvoid foo(Collection<Object[]> c, Object o) {}\n\tpublic static void main(String[] args) {\n\t\tnew B().foo(new ArrayList());\n\t\tnew B().foo(new ArrayList(), args[0]);\n\t}\n}\nclass B extends A {\n\tvoid foo(ArrayList a) {}\n\tvoid foo(ArrayList a, Object o) {}\n}"}, "----------\n1. ERROR in A.java (at line 6)\n\tnew B().foo(new ArrayList());\n\t        ^^^\nThe method foo(ArrayList) is ambiguous for the type B\n----------\n2. WARNING in A.java (at line 6)\n\tnew B().foo(new ArrayList());\n\t                ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n3. ERROR in A.java (at line 7)\n\tnew B().foo(new ArrayList(), args[0]);\n\t        ^^^\nThe method foo(ArrayList, Object) is ambiguous for the type B\n----------\n4. WARNING in A.java (at line 7)\n\tnew B().foo(new ArrayList(), args[0]);\n\t                ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n5. WARNING in A.java (at line 11)\n\tvoid foo(ArrayList a) {}\n\t         ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n6. WARNING in A.java (at line 12)\n\tvoid foo(ArrayList a, Object o) {}\n\t         ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n");
    }

    public void test067() {
        this.runConformTest(new String[]{"A.java", "import java.util.*;\npublic class A {\n\tvoid foo(Collection<Object[]> c) {}\n\tpublic static void main(String[] args) {\n\t\tnew B().foo(new ArrayList<Object>());\n\t}\n}\nclass B extends A {\n\tvoid foo(ArrayList<Object> a) {System.out.print(1);}\n}"}, "1");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "interface A { X<? extends A> foo(); }\ninterface B extends A { X<? extends B> foo(); }\ninterface C extends B, A {}\ninterface D extends A, B {}\npublic class X<T> {\n\tpublic void bar() {\n\t\tC c = null;\n\t\tX<? extends B> c_b = c.foo();\n\t\tD d = null;\n\t\t X<? extends B> d_b = d.foo();\n\t}\n}"}, "");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.java", "interface A { X<? extends B> foo(); }\ninterface B extends A { X<? extends A> foo(); }\ninterface C extends B, A {}\ninterface D extends A, B {}\npublic class X<T> {\n\tvoid test(C c, D d) {\n\t\tX<? extends B> c_b = c.foo();\n\t\t X<? extends B> d_b = d.foo();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tinterface B extends A { X<? extends A> foo(); }\n\t                        ^^^^^^^^^^^^^^\nThe return type is incompatible with A.foo()\n----------\n");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.java", "interface A { X<? extends A> foo(); }\ninterface B { X<? extends B> foo(); }\ninterface C extends B, A {}\ninterface D extends A, B {}\npublic class X<T> {\n\tpublic static void main(String[] args) {\n\t\tC c = null;\n\t\tX<? extends B> c_b = c.foo();\n\t\tD d = null;\n\t\t X<? extends B> d_b = d.foo();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tinterface C extends B, A {}\n\t          ^\nThe return types are incompatible for the inherited methods B.foo(), A.foo()\n----------\n2. ERROR in X.java (at line 4)\n\tinterface D extends A, B {}\n\t          ^\nThe return types are incompatible for the inherited methods A.foo(), B.foo()\n----------\n3. ERROR in X.java (at line 8)\n\tX<? extends B> c_b = c.foo();\n\t                       ^^^\nThe method foo() is ambiguous for the type C\n----------\n4. ERROR in X.java (at line 10)\n\tX<? extends B> d_b = d.foo();\n\t                       ^^^\nThe method foo() is ambiguous for the type D\n----------\n");
    }

    public void test071() {
        this.runConformTest(new String[]{"Y.java", "interface I {\n\tInteger a();\n\tFloat b();\n}\ninterface J {\n\tInteger a();\n\tDouble c();\n}\nabstract class X {\n\tpublic abstract Float b();\n\tpublic Double c() { return null; }\n}\nabstract class Y extends X implements I, J {\n\tvoid test() {\n\t\tInteger i = a();\n\t\tFloat f = b();\n\t\tDouble d = c();\n\t}\n}"}, "");
    }

    public void test072() {
        this.runConformTest(new String[]{"Y.java", "interface I {\n\tNumber a();\n\tNumber b();\n}\ninterface J {\n\tInteger a();\n\tNumber c();\n}\nabstract class X {\n\tpublic abstract Float b();\n\tpublic Double c() { return null; }\n}\nabstract class Y extends X implements I, J {\n\tvoid test() {\n\t\tInteger i = a();\n\t\tFloat f = b();\n\t\tDouble d = c();\n\t}\n}\nabstract class Y2 extends X implements J, I {\n\tvoid test() {\n\t\tInteger i = a();\n\t\tFloat f = b();\n\t\tDouble d = c();\n\t}\n}"}, "");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"Y.java", "interface I {\n\tint a();\n\tint b();\n}\ninterface J {\n\tbyte a();\n\tint c();\n}\nabstract class X {\n\tpublic abstract byte b();\n\tpublic byte c() { return 1; }\n}\nabstract class Y extends X implements I, J {\n\tvoid test() {\n\t\tbyte a = a();\n\t\tbyte b = b();\n\t\tbyte c = c();\n\t}\n}\nabstract class Y2 extends X implements J, I {\n\tvoid test() {\n\t\tbyte a = a();\n\t\tbyte b = b();\n\t\tbyte c = c();\n\t}\n}"}, "----------\n1. ERROR in Y.java (at line 13)\n\tabstract class Y extends X implements I, J {\n\t               ^\nThe return types are incompatible for the inherited methods J.c(), X.c()\n----------\n2. ERROR in Y.java (at line 13)\n\tabstract class Y extends X implements I, J {\n\t               ^\nThe return types are incompatible for the inherited methods I.b(), X.b()\n----------\n3. ERROR in Y.java (at line 13)\n\tabstract class Y extends X implements I, J {\n\t               ^\nThe return types are incompatible for the inherited methods I.a(), J.a()\n----------\n4. ERROR in Y.java (at line 20)\n\tabstract class Y2 extends X implements J, I {\n\t               ^^\nThe return types are incompatible for the inherited methods J.c(), X.c()\n----------\n5. ERROR in Y.java (at line 20)\n\tabstract class Y2 extends X implements J, I {\n\t               ^^\nThe return types are incompatible for the inherited methods I.b(), X.b()\n----------\n6. ERROR in Y.java (at line 20)\n\tabstract class Y2 extends X implements J, I {\n\t               ^^\nThe return types are incompatible for the inherited methods J.a(), I.a()\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.EclipseHasABug.EclipseBug427719, new String[]{"Y.java", "interface I<T> {}\nclass A {\n\tvoid a(I x) {}\n\tvoid b(I<?> x) {}\n\tvoid b(I<?>[] x) {}\n\t<U> void c(I<?> x) {}\n}\nclass B extends A {}\nclass C extends B implements I {\n\tvoid a(C c) {}\n\tvoid b(C c) {}\n\tvoid b(C[] c) {}\n\tvoid c(C c) {}\n}\nclass D extends C {\n    void test() {\n        a(new C());\n        a(new D());\n        b(new C());\n        b(new D());\n        b(new C[0]);\n        b(new D[0]);\n        c(new C());\n        c(new D());\n    }\n}\nclass A2<T> {\n\tvoid a(I x) {}\n\tvoid b(I<?> x) {}\n\t<U> void c(I<?> x) {}\n\tvoid d(I<T> x) {}\n}\nclass B2 extends A2 {}\nclass C2 extends B2 implements I {\n\tvoid a(C2 c) {}\n\tvoid b(C2 c) {}\n\tvoid c(C2 c) {}\n\tvoid d(C2 c) {}\n}\nclass D2 extends C2 {\n    void test() {\n        a(new C2());\n        a(new D2());\n        b(new C2());\n        b(new D2());\n        c(new C2());\n        c(new D2());\n        d(new C2());\n        d(new D2());\n    }\n}\npublic class Y {}\n"}, "----------\n1. WARNING in Y.java (at line 3)\n\tvoid a(I x) {}\n\t       ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n2. WARNING in Y.java (at line 9)\n\tclass C extends B implements I {\n\t                             ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n3. WARNING in Y.java (at line 28)\n\tvoid a(I x) {}\n\t       ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n4. WARNING in Y.java (at line 33)\n\tclass B2 extends A2 {}\n\t                 ^^\nA2 is a raw type. References to generic type A2<T> should be parameterized\n----------\n5. WARNING in Y.java (at line 34)\n\tclass C2 extends B2 implements I {\n\t                               ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"C.java", "abstract class A<T extends Comparable> {\n\tabstract int x(T val);\n}\nclass B<T extends Comparable> extends A<T> {\n\t@Override int x(T val) { return 0; }\n}\nclass C extends B<Double> {\n    int test(Double val) { return x(val); }\n}"}, "----------\n1. WARNING in C.java (at line 1)\n\tabstract class A<T extends Comparable> {\n\t                           ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. WARNING in C.java (at line 4)\n\tclass B<T extends Comparable> extends A<T> {\n\t                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test076() {
        String output = "----------\n1. ERROR in X.java (at line 8)\n\t<U> J<String> b();\n\t              ^^^\nName clash: The method b() of type J<E> has the same erasure as b() of type I<E> but does not override it\n----------\n2. ERROR in X.java (at line 15)\n\tJ<Integer> b = ints.a();\n\t               ^^^^^^^^\nType mismatch: cannot convert from J<String> to J<Integer>\n----------\n3. ERROR in X.java (at line 16)\n\tJ<Object> c = ints.a();\n\t              ^^^^^^^^\nType mismatch: cannot convert from J<String> to J<Object>\n----------\n4. WARNING in X.java (at line 17)\n\tJ d = ints.a();\n\t^\nJ is a raw type. References to generic type J<E> should be parameterized\n----------\n5. ERROR in X.java (at line 19)\n\tI<Integer> f = ints.a();\n\t               ^^^^^^^^\nType mismatch: cannot convert from J<String> to I<Integer>\n----------\n6. ERROR in X.java (at line 20)\n\tI<Object> g = ints.a();\n\t              ^^^^^^^^\nType mismatch: cannot convert from J<String> to I<Object>\n----------\n7. WARNING in X.java (at line 21)\n\tI h = ints.a();\n\t^\nI is a raw type. References to generic type I<E> should be parameterized\n----------\n8. ERROR in X.java (at line 24)\n\tints.b();\n\t     ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n9. ERROR in X.java (at line 25)\n\tJ<String> a = ints.b();\n\t                   ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n10. ERROR in X.java (at line 26)\n\tJ<Integer> b = ints.b();\n\t                    ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n11. ERROR in X.java (at line 27)\n\tJ<Object> c = ints.b();\n\t                   ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n12. WARNING in X.java (at line 28)\n\tJ d = ints.b();\n\t^\nJ is a raw type. References to generic type J<E> should be parameterized\n----------\n13. ERROR in X.java (at line 28)\n\tJ d = ints.b();\n\t           ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n14. ERROR in X.java (at line 29)\n\tI<String> e = ints.b();\n\t                   ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n15. ERROR in X.java (at line 30)\n\tI<Integer> f = ints.b();\n\t                    ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n16. ERROR in X.java (at line 31)\n\tI<Object> g = ints.b();\n\t                   ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n17. WARNING in X.java (at line 32)\n\tI h = ints.b();\n\t^\nI is a raw type. References to generic type I<E> should be parameterized\n----------\n18. ERROR in X.java (at line 32)\n\tI h = ints.b();\n\t           ^\nThe method b() is ambiguous for the type J<Integer>\n----------\n19. WARNING in X.java (at line 39)\n\tJ d = ints.c();\n\t^\nJ is a raw type. References to generic type J<E> should be parameterized\n----------\n20. WARNING in X.java (at line 43)\n\tI h = ints.c();\n\t^\nI is a raw type. References to generic type I<E> should be parameterized\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "interface I<E> {\n\tI<String> a();\n\tI<String> b();\n\t<T1> I<T1> c();\n}\ninterface J<E> extends I<E> {\n\tJ<String> a();\n\t<U> J<String> b();\n\t<T2> J<T2> c();\n}\nclass X {\n\tvoid a(J<Integer> ints) {\n\t\tints.a();\n\t\tJ<String> a = ints.a();\n\t\tJ<Integer> b = ints.a();\n\t\tJ<Object> c = ints.a();\n\t\tJ d = ints.a();\n\t\tI<String> e = ints.a();\n\t\tI<Integer> f = ints.a();\n\t\tI<Object> g = ints.a();\n\t\tI h = ints.a();\n\t}\n\tvoid b(J<Integer> ints) {\n\t\tints.b();\n\t\tJ<String> a = ints.b();\n\t\tJ<Integer> b = ints.b();\n\t\tJ<Object> c = ints.b();\n\t\tJ d = ints.b();\n\t\tI<String> e = ints.b();\n\t\tI<Integer> f = ints.b();\n\t\tI<Object> g = ints.b();\n\t\tI h = ints.b();\n\t}\n\tvoid c(J<Integer> ints) {\n\t\tints.c();\n\t\tJ<String> a = ints.c();\n\t\tJ<Integer> b = ints.c();\n\t\tJ<Object> c = ints.c();\n\t\tJ d = ints.c();\n\t\tI<String> e = ints.c();\n\t\tI<Integer> f = ints.c();\n\t\tI<Object> g = ints.c();\n\t\tI h = ints.c();\n\t}\n}"}, output);
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "abstract class X implements I {\n\tpublic <A extends J<A, D>, D extends J<A, D>> A method(A arg) { return null; }\n\tvoid test(Y<String> c) { method(c); }\n}\ninterface I {\n\t<A extends J<A,D>, D extends J<A,D>> A method(A arg);\n}\ninterface J<A extends J<A,D>, D extends J<A,D>> {}\nclass Y<E> implements J<Y<E>, Y<E>> {}"}, "");
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tclass Field<T> { T value; }\n\t<T> void a(T value) {}\n\t<T> void a(Field<T> field) {}\n\t<T extends Number> void b(T value) {}\n\t<T> void b(Field<T> field) {}\n\tvoid c(String value) {}\n\tvoid c(Field<String> field) {}\n\tvoid test(X x) {\n\t\tx.a(null);\n\t\tx.<String>a(null);\n\t\tx.b(null);\n\t\tx.<Integer>b(null);\n\t\tx.c(null);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\tx.b(null);\n\t  ^\nThe method b(Number) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 13)\n\tx.<Integer>b(null);\n\t           ^\nThe method b(Integer) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 14)\n\tx.c(null);\n\t  ^\nThe method c(String) is ambiguous for the type X\n----------\n");
    }

    public void test079() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T> {}\nclass A {}\nclass B extends A {}\ninterface One {\n    I<B> x() throws IllegalAccessError;\n    <T extends A> I<T> y() throws IllegalAccessError;\n}\ninterface Two extends One {\n    <T extends A> I<T> x() throws IllegalAccessError;\n    I<B> y() throws IllegalAccessError;\n}\nclass X {\n    void x(Two t) { t.x(); }\n    void y(Two t) { t.y(); }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t<T extends A> I<T> x() throws IllegalAccessError;\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method x() of type Two has the same erasure as x() of type One but does not override it\n----------\n2. WARNING in X.java (at line 10)\n\tI<B> y() throws IllegalAccessError;\n\t^\nType safety: The return type I<B> for y() from the type Two needs unchecked conversion to conform to I<A> from the type One\n----------\n");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "public class X<Tout extends Object> {\n   static public abstract class BaseA {};\n\tstatic public abstract class BaseB extends BaseA {};\n\tstatic public class Real extends BaseB {};\n\tstatic BaseA ask(String prompt) {\n\t    Real impl = new Real();\n\t    return (BaseA) ask(prompt, impl);\n\t}\n\tstatic BaseA ask(String prompt, Real impl) {\n\t    return null;\n\t}\n\tstatic <T extends BaseA> T ask(String prompt, T impl) {\n\t    return null;\n\t}\n\tstatic public void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test081() {
        this.runConformTest(new String[]{"C.java", "class A<ModelType extends D, ValueType> implements I<ModelType, ValueType> {\n    public void doSet(ModelType valueGetter) {\n        this.set((ValueType) valueGetter.getObject());\n    }\n    public void set(Object object) {\n        System.out.println(\"In A.set(Object)\");\n    }\n}\nclass B extends A<E, CharSequence> {\n\tpublic void set(CharSequence string) {\n        System.out.println(\"In B.set(CharSequence)\");\n    }\n}\npublic class C extends B {\n    static public void main(String[] args) {\n        C c = new C();\n        c.run();\n    }\n    public void run() {\n        E e = new E<String>(String.class);\n        this.doSet(e);\n    }\n}\nclass D {\n    public Object getObject() {\n        return null;\n    }\n}\nclass E<Type extends CharSequence> extends D {\n    private Class<Type> typeClass;\n    public E(Class<Type> typeClass) {\n        this.typeClass = typeClass;\n    }\n    public Type getObject() {\n        try {\n            return (Type) typeClass.newInstance();\n        } catch (Exception e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\ninterface I<ModelType, ValueType> {\n    public void doSet(ModelType model);\n    public void set(ValueType value);\n}\n"}, "In B.set(CharSequence)");
    }

    public void test082() {
        this.runConformTest(new String[]{"C.java", "class A<ModelType extends D, ValueType> extends I<ModelType, ValueType> {\n    public void doSet(ModelType valueGetter) {\n        this.set((ValueType) valueGetter.getObject());\n    }\n    public void set(Object object) {\n        System.out.println(\"In A.set(Object)\");\n    }\n}\nclass B extends A<E, CharSequence> {\n\tpublic void set(CharSequence string) {\n        System.out.println(\"In B.set(CharSequence)\");\n    }\n}\npublic class C extends B {\n    static public void main(String[] args) {\n        C c = new C();\n        c.run();\n    }\n    public void run() {\n        E e = new E<String>(String.class);\n        this.doSet(e);\n    }\n}\nclass D {\n    public Object getObject() {\n        return null;\n    }\n}\nclass E<Type extends CharSequence> extends D {\n    private Class<Type> typeClass;\n    public E(Class<Type> typeClass) {\n        this.typeClass = typeClass;\n    }\n    public Type getObject() {\n        try {\n            return (Type) typeClass.newInstance();\n        } catch (Exception e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\nabstract class I<ModelType, ValueType> {\n    public abstract void doSet(ModelType model);\n    public abstract void set(ValueType value);\n}\n"}, "In B.set(CharSequence)");
    }

    public void test083() {
        this.runConformTest(new String[]{"C.java", "class A<ModelType extends D, ValueType> implements I<ModelType, ValueType> {\n    public void doSet(ModelType valueGetter) {\n        this.set((ValueType) valueGetter.getObject());\n    }\n    public void set(Object object) {\n        System.out.println(\"In A.set(Object)\");\n    }\n}\nclass B extends A<E, CharSequence> implements I<E, CharSequence> {\n\tpublic void set(CharSequence string) {\n        System.out.println(\"In B.set(CharSequence)\");\n    }\n}\npublic class C extends B {\n    static public void main(String[] args) {\n        C c = new C();\n        c.run();\n    }\n    public void run() {\n        E e = new E<String>(String.class);\n        this.doSet(e);\n    }\n}\nclass D {\n    public Object getObject() {\n        return null;\n    }\n}\nclass E<Type extends CharSequence> extends D {\n    private Class<Type> typeClass;\n    public E(Class<Type> typeClass) {\n        this.typeClass = typeClass;\n    }\n    public Type getObject() {\n        try {\n            return (Type) typeClass.newInstance();\n        } catch (Exception e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\ninterface I<ModelType, ValueType> {\n    public void doSet(ModelType model);\n    public void set(ValueType value);\n}\n"}, "In B.set(CharSequence)");
    }

    public void test084() {
        this.runConformTest(new String[]{"C.java", "abstract class A<ModelType extends D, ValueType> implements I<ModelType, ValueType> {\n    public void doSet(ModelType valueGetter) {\n        this.set((ValueType) valueGetter.getObject());\n    }\n    public void set(Object object) {\n        System.out.println(\"In A.set(Object)\");\n    }\n}\nclass B extends A<E, CharSequence> {\n}\npublic class C extends B {\n    static public void main(String[] args) {\n        C c = new C();\n        c.run();\n    }\n    public void run() {\n        E e = new E<String>(String.class);\n        this.doSet(e);\n    }\n}\nclass D {\n    public Object getObject() {\n        return null;\n    }\n}\nclass E<Type extends CharSequence> extends D {\n    private Class<Type> typeClass;\n    public E(Class<Type> typeClass) {\n        this.typeClass = typeClass;\n    }\n    public Type getObject() {\n        try {\n            return (Type) typeClass.newInstance();\n        } catch (Exception e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\ninterface I<ModelType, ValueType> {\n    public void doSet(ModelType model);\n    public void set(ValueType value);\n}\n"}, "In A.set(Object)");
    }

    public void test085() {
        this.runConformTest(new String[]{"C.java", "class A<ModelType extends D, ValueType> implements I<ModelType, ValueType> {\n    public void doSet(ModelType valueGetter) {\n        this.set((ValueType) valueGetter.getObject());\n    }\n    public void set(Object object) {\n        System.out.println(\"In A.set(Object)\");\n    }\n}\nclass B extends A<E, CharSequence> {\n}\npublic class C extends B {\n    static public void main(String[] args) {\n        C c = new C();\n        c.run();\n    }\n    public void run() {\n        E e = new E<String>(String.class);\n        this.doSet(e);\n    }\n}\nclass D {\n    public Object getObject() {\n        return null;\n    }\n}\nclass E<Type extends CharSequence> extends D {\n    private Class<Type> typeClass;\n    public E(Class<Type> typeClass) {\n        this.typeClass = typeClass;\n    }\n    public Type getObject() {\n        try {\n            return (Type) typeClass.newInstance();\n        } catch (Exception e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\ninterface I<ModelType, ValueType> {\n    public void doSet(ModelType model);\n    public void set(ValueType value);\n}\n"}, "In A.set(Object)");
    }

    public void test086() {
        this.runConformTest(new String[]{"C.java", "class A<ModelType extends D, ValueType> {\n    public void doSet(ModelType valueGetter) {\n        this.set((ValueType) valueGetter.getObject());\n    }\n    public void set(Object object) {\n        System.out.println(\"In A.set(Object)\");\n    }\n}\nclass B extends A<E, CharSequence> {\n\tpublic void set(CharSequence string) {\n        System.out.println(\"In B.set(CharSequence)\");\n    }\n}\npublic class C extends B {\n    static public void main(String[] args) {\n        C c = new C();\n        c.run();\n    }\n    public void run() {\n        E e = new E<String>(String.class);\n        this.doSet(e);\n    }\n}\nclass D {\n    public Object getObject() {\n        return null;\n    }\n}\nclass E<Type extends CharSequence> extends D {\n    private Class<Type> typeClass;\n    public E(Class<Type> typeClass) {\n        this.typeClass = typeClass;\n    }\n    public Type getObject() {\n        try {\n            return (Type) typeClass.newInstance();\n        } catch (Exception e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\ninterface I<ModelType, ValueType> {\n    public void doSet(ModelType model);\n    public void set(ValueType value);\n}\n"}, "In A.set(Object)");
    }

    public void test087() {
        String source = "import java.util.Collection;\nimport java.util.List;\npublic class X {\n    public static <T> List<T> with(List<? extends T> p) { return null; } \n    public static <T> Collection<T> with(Collection<T> p) { return null; }\n    static { with(null); }\n} \n";
        this.runConformTest(new String[]{"X.java", source});
    }

    public void test088a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    int foo () { return 0; } \n    double foo() { return 0.0; }\n} \n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint foo () { return 0; } \n\t    ^^^^^^\nDuplicate method foo() in type X\n----------\n2. ERROR in X.java (at line 3)\n\tdouble foo() { return 0.0; }\n\t       ^^^^^\nDuplicate method foo() in type X\n----------\n");
    }

    public void test088b() {
        this.runNegativeTest(new String[]{"X.java", "public interface X {\n    int foo (); \n    double foo();\n} \n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint foo (); \n\t    ^^^^^^\nDuplicate method foo() in type X\n----------\n2. ERROR in X.java (at line 3)\n\tdouble foo();\n\t       ^^^^^\nDuplicate method foo() in type X\n----------\n");
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    int m2(List<Integer> a) {return 0;} \n    double m2(List<Integer> b) {return 0.0;}\n} \n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint m2(List<Integer> a) {return 0;} \n\t    ^^^^^^^^^^^^^^^^^^^\nDuplicate method m2(List<Integer>) in type X\n----------\n2. ERROR in X.java (at line 4)\n\tdouble m2(List<Integer> b) {return 0.0;}\n\t       ^^^^^^^^^^^^^^^^^^^\nDuplicate method m2(List<Integer>) in type X\n----------\n");
    }

    public void testBug426521() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.List;\n\nclass Test {\n    <U> void m(List<U> l, U v) { }\n\n    <V> void m(List<V> l1, List<V> l2) { }\n\n    void test(List<Object> l) {\n        m(l, l); //JDK 6/7 give ambiguity here - EJC compiles ok\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 9)\n\tm(l, l); //JDK 6/7 give ambiguity here - EJC compiles ok\n\t^\nThe method m(List<Object>, Object) is ambiguous for the type Test\n----------\n");
    }

    public void testBug428845() {
        this.runNegativeTest(new String[]{"AmbiguousTest.java", "import java.io.File;\npublic class AmbiguousTest {\n  static interface IInterface {\n    public void method(File file);\n  }\n  static abstract class AbstractClass implements IInterface {\n    public void method(File file) {\n      System.err.println(\"file\");\n    }\n    public void method(String string) {\n      System.err.println(\"string\");\n    }\n  }\n  private static AbstractClass newAbstractClass() {\n    return new AbstractClass() {};\n  }\n  public static void main(String[] args) {\n    newAbstractClass().method(null);\n  }\n}"}, "----------\n1. ERROR in AmbiguousTest.java (at line 18)\n\tnewAbstractClass().method(null);\n\t                   ^^^^^^\nThe method method(File) is ambiguous for the type AmbiguousTest.AbstractClass\n----------\n");
    }

    public void testBug458563() {
        this.runConformTest(new String[]{"X.java", "interface IStoredNode<T> extends INodeHandle<DocumentImpl>, NodeHandle { }\ninterface NodeHandle extends INodeHandle<DocumentImpl> { }\nclass DocumentImpl implements INodeHandle<DocumentImpl> {\n\tpublic Object getNodeId() {return null;}\n}\ninterface INodeHandle<D> {\n    public Object  getNodeId();\n}\npublic class X {\n\tpublic void foo(IStoredNode bar) {\n\t\tbar.getNodeId();\n\t}\n}"});
    }

    public void testBug458563a() {
        this.runConformTest(new String[]{"X.java", "interface IStoredNode<T> extends INodeHandle<DocumentImpl>, NodeHandle { }\ninterface NodeHandle extends INodeHandle<DocumentImpl> { }\nclass DocumentImpl implements INodeHandle<DocumentImpl> {\n\tpublic Object getNodeId() {return null;}\n}\ninterface INodeHandle<D> {\n    public Object  getNodeId();\n}\npublic class X {\n\tpublic void foo(IStoredNode<?> bar) {\n\t\tbar.getNodeId();\n\t}\n}"});
    }

    public void testBug466730() {
        this.runConformTest(new String[]{"bug/Base.java", "package bug;\npublic class Base {\n\tpublic static Object works() {\n        throw new IllegalStateException();\n\t}\n    public static <T> T fails() {\n        throw new IllegalStateException();\n    }\n}\n", "bug/Derived.java", "package bug;\npublic class Derived extends Base {}\n", "bug/StaticImportBug.java", "package bug;\nimport static bug.Base.*;\nimport static bug.Derived.*;\npublic class StaticImportBug {\n\tvoid m() {\n\t\tjava.util.Objects.requireNonNull(works());\n\t\tjava.util.Objects.requireNonNull(fails());\n\t}\n}\n"});
    }
}

