/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.Requestor;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.junit.Assert;

public class AnnotationTest
extends AbstractComparableTest {
    String reportMissingJavadocComments = null;
    private String repeatableIntroText;
    private String repeatableTrailerText;

    public AnnotationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return AnnotationTest.buildComparableTestSuite(AnnotationTest.class);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        }
        return options;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        if (this.javaClassLib != null) {
            this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
            return new InMemoryNameEnvironment(testFiles, new INameEnvironment[]{this.javaClassLib});
        }
        return super.getNameEnvironment(testFiles, classPaths, options);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.reportMissingJavadocComments = null;
        this.repeatableIntroText = "Duplicate annotation of non-repeatable type ";
        this.repeatableTrailerText = ". Only annotation types marked @Repeatable can be used multiple times at one target.\n";
        this.javaClassLib = null;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public @interface X { \n\tString value(); \n}"}, "");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public @Foo class X {\n}\n\n@interface Foo {\n\tString value();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic @Foo class X {\n\t       ^^^^\nThe annotation @Foo must define the attribute value\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\tBar value();\n}\n\n@interface Bar {\n\tFoo value();\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tBar value();\n\t^^^\nCycle detected: a cycle exists between annotation attributes of Foo and Bar\n----------\n2. ERROR in Foo.java (at line 6)\n\tFoo value();\n\t^^^\nCycle detected: a cycle exists between annotation attributes of Bar and Foo\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "@interface Nested {\n\tString name() default \"Hans\";\n\tN2 nest();\n}\n@interface N2 {\n\tNested n2() default @Nested(name=\"Haus\", nest= @N2);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tN2 nest();\n\t^^\nCycle detected: a cycle exists between annotation attributes of Nested and N2\n----------\n2. ERROR in X.java (at line 6)\n\tNested n2() default @Nested(name=\"Haus\", nest= @N2);\n\t^^^^^^\nCycle detected: a cycle exists between annotation attributes of N2 and Nested\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\tFoo value();\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tFoo value();\n\t^^^\nCycle detected: the annotation type Foo cannot contain attributes of the annotation type itself\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo extends Object {\n}\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\tpublic @interface Foo extends Object {\n\t                  ^^^\nAnnotation type declaration cannot have an explicit superclass\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo implements Cloneable {\n}\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\tpublic @interface Foo implements Cloneable {\n\t                  ^^^\nAnnotation type declaration cannot have explicit superinterfaces\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\tString value(int i);\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tString value(int i);\n\t       ^^^^^^^^^^^^\nAnnotation attributes cannot have parameters\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"Foo.java", "public @interface Foo {\n\t<T> T value();\n}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\t<T> T value();\n\t    ^\nInvalid type T for the annotation attribute Foo.value; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n2. ERROR in Foo.java (at line 2)\n\t<T> T value();\n\t      ^^^^^^^\nAnnotation attributes cannot be generic\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\t\n\tRunnable value();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tRunnable value();\n\t^^^^^^^^\nInvalid type Runnable for the annotation attribute X.value; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\t\n\tvalue();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvalue();\n\t^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "@Object\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Object\n\t ^^^^^^\nObject is not an annotation type\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "@Foo @Foo\npublic class X {\n}\n@interface Foo {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo @Foo\n\t^^^^\n" + this.repeatableIntroText + "@Foo" + this.repeatableTrailerText + "----------\n2. ERROR in X.java (at line 1)\n\t@Foo @Foo\n\t     ^^^^\n" + this.repeatableIntroText + "@Foo" + this.repeatableTrailerText + "----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "@Foo(\"hello\") public class X {\n}\n\n@interface Foo {\n\tString id() default \"\";\n\tString value() default \"\";\n}\n"}, "");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "@Foo(\"hello\") public class X {\n}\n\n@interface Foo {\n\tString id() default \"\";\n\tString value() default \"\";\n\tString foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo(\"hello\") public class X {\n\t^^^^\nThe annotation @Foo must define the attribute foo\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "@Foo(\n\t\tid = \"hello\") public class X {\n}\n\n@interface Foo {\n\tString id() default \"\";\n\tString value() default \"\";\n\tString foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo(\n\t^^^^\nThe annotation @Foo must define the attribute foo\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\n@interface Author {\n\tName name();\n}\npublic class X {\n\t\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\")) \n\tvoid foo() {\n\t}\n}\n"}, "");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\n@interface Author {\n\tName name();\n}\n@Author(@Name(first=\"Joe\",last=\"Hacker\")) \npublic class X {\n\t\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\")) \n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Author(@Name(first=\"Joe\",last=\"Hacker\")) \n\t^^^^^^^\nThe annotation @Author must define the attribute name\n----------\n2. ERROR in X.java (at line 8)\n\t@Author(@Name(first=\"Joe\",last=\"Hacker\")) \n\t        ^^^^^\nThe attribute value is undefined for the annotation type Author\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\n@interface Author {\n\tName name();\n}\npublic class X {\n\t\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")) \n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")) \n\t                                   ^^^^\nDuplicate attribute last in annotation @Name\n----------\n2. ERROR in X.java (at line 10)\n\t@Author(name = @Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")) \n\t                                                ^^^^\nDuplicate attribute last in annotation @Name\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseJustification0001);
    }

    public void test018b() {
        this.runNegativeTest(new String[]{"X.java", "@interface Name {\n\tString first();\n\tString last();\n}\npublic class X {\n\t@Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")\n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")\n\t                    ^^^^\nDuplicate attribute last in annotation @Name\n----------\n2. ERROR in X.java (at line 6)\n\t@Name(first=\"Bill\", last=\"Yboy\", last=\"dup\")\n\t                                 ^^^^\nDuplicate attribute last in annotation @Name\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tClass value() default X.clazz();\n}\n\npublic class X {\n\t@Foo( clazz() )\n\tvoid foo() {}\n\tstatic Class clazz() { return X.class; }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tClass value() default X.clazz();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tClass value() default X.clazz();\n\t                      ^^^^^^^^^\nThe value for annotation attribute Foo.value must be a class literal\n----------\n3. ERROR in X.java (at line 6)\n\t@Foo( clazz() )\n\t      ^^^^^^^\nThe value for annotation attribute Foo.value must be a class literal\n----------\n4. WARNING in X.java (at line 8)\n\tstatic Class clazz() { return X.class; }\n\t       ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tint value() default X.val();\n}\n\npublic class X {\n\t@Foo( val() )\n\tvoid foo() {}\n\tstatic int val() { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint value() default X.val();\n\t                    ^^^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n2. ERROR in X.java (at line 6)\n\t@Foo( val() )\n\t      ^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tString value() default X.val();\n}\n\npublic class X {\n\t@Foo( val() )\n\tvoid foo() {}\n\tstatic String val() { return \"\"; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tString value() default X.val();\n\t                       ^^^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n2. ERROR in X.java (at line 6)\n\t@Foo( val() )\n\t      ^^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {\n\tString[] value() default null;\n}\n\npublic class X {\n\t@Foo( null )\n\tvoid foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tString[] value() default null;\n\t                         ^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n2. ERROR in X.java (at line 6)\n\t@Foo( null )\n\t      ^^^^\nThe value for annotation attribute Foo.value must be a constant expression\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n\tString[] value() default {};\n}\n\npublic class X {\n\t@Foo( {} )\n\tvoid foo() {}\n}\n"}, "");
    }

    public void test024() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\tString[] value() default {};\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo({})\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test025() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\tString[] value() default {};\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test026() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tint value() default 8;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test027() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tbyte value() default (byte)255;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test028() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tboolean value() default true;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test029() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tchar value() default ' ';\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test030() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tshort value() default (short)1024;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test031() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tdouble value() default 0.0;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test032() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tfloat value() default -0.0f;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test033() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tlong value() default 1234567890L;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test034() {
        this.runConformTest(new String[]{"Foo.java", "public @interface Foo {\n\t\tString value() default \"Hello, World\";\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test035() {
        this.runConformTest(new String[]{"Foo.java", "enum E {\n\tCONST1\n}\n@interface Foo {\n\tE value() default E.CONST1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test036() {
        this.runConformTest(new String[]{"Foo.java", "@interface Foo {\n\tClass value() default Object.class;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test037() {
        this.runConformTest(new String[]{"Foo.java", "@interface Y {\n\tint id() default 8;\n\tClass type();\n}\npublic @interface Foo {\n\tY value() default @Y(id=10,type=Object.class);\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@Foo()\n\tvoid foo() {}\n}\n"}, "", null, false, null);
    }

    public void test038() {
        this.runConformTest(new String[]{"Foo.java", "@interface Foo {\n\tint id() default 8;\n\tClass type();\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Foo(type=String.class) public class X {\n}"}, "", null, false, null);
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tnative int id() default 0;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tnative int id() default 0;\n\t           ^^^^\nIllegal modifier for the annotation attribute X.id; only public & abstract are permitted\n----------\n");
    }

    public void test039a() {
        String extra = this.complianceLevel < 0x3D0000L ? "" : "----------\n1. WARNING in X.java (at line 2)\n\tstrictfp double val() default 0.1;\n\t^^^^^^^^\nFloating-point expressions are always strictly evaluated from source level 17. Keyword 'strictfp' is not required.\n";
        int offset = this.complianceLevel < 0x3D0000L ? 0 : 1;
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tstrictfp double val() default 0.1;\n\tsynchronized String id() default \"zero\";\n}"}, extra + "----------\n" + (1 + offset) + ". ERROR in X.java (at line 2)\n\tstrictfp double val() default 0.1;\n\t                ^^^^^\nIllegal modifier for the annotation attribute X.val; only public & abstract are permitted\n----------\n" + (2 + offset) + ". ERROR in X.java (at line 3)\n\tsynchronized String id() default \"zero\";\n\t                    ^^^^\nIllegal modifier for the annotation attribute X.id; only public & abstract are permitted\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tint[] tab;\n\tint[] value();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[] tab;\n\t      ^^^\nThe blank final field tab may not have been initialized\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tint[] tab = value();\n\tint[] value();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[] tab = value();\n\t            ^^^^^\nCannot make a static reference to the non-static method value() from the type X\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "public @interface X {\n\tint[] tab = { 0 , \"aaa\".length() };\n}\n"}, "");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tint value;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint value;\n\t    ^^^^^\nThe blank final field value may not have been initialized\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tprotected int value = 0;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tprotected int value = 0;\n\t              ^^^^^\nIllegal modifier for the annotation field X.value; only public, static & final are permitted\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n    int id () default 10L; \n    int[] ids() default { 10L };\n    Class cls() default new Object();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint id () default 10L; \n\t                  ^^^\nType mismatch: cannot convert from long to int\n----------\n2. ERROR in X.java (at line 3)\n\tint[] ids() default { 10L };\n\t                      ^^^\nType mismatch: cannot convert from long to int\n----------\n3. WARNING in X.java (at line 4)\n\tClass cls() default new Object();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 4)\n\tClass cls() default new Object();\n\t                    ^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Class\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n    boolean val() default true;\n}\n\npublic class X {\n\n\tboolean bar() {\n\t\treturn false;\n\t}\n    @I(val = bar()) void foo() {\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t@I(val = bar()) void foo() {\n\t         ^^^^^\nThe value for annotation attribute I.val must be a constant expression\n----------\n");
    }

    public void test047() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    boolean[] val() default {true};\n}\n\npublic class X {\n    @I(val = false) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(val={false})\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
        ClassFileReader fileReader = ClassFileReader.read((File)new File(OUTPUT_DIR + File.separator + "I.class"));
        AnnotationTest.assertEquals((String)"Not an annotation type declaration", (int)4, (int)TypeDeclaration.kind((int)fileReader.getModifiers()));
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n     boolean[] value();\n}\n\npublic class X {\n     @I(value={false, X.class != null }) void foo() {\n     }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@I(value={false, X.class != null }) void foo() {\n\t                 ^^^^^^^^^^^^^^^\nThe value for annotation attribute I.value must be a constant expression\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.*;\n\n@Documented\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE)\n@interface MyAnn {\n  String value() default \"Default Message\";\n}\n\n@MyAnn\npublic class X {\n\tpublic @MyAnn void something() { }\t\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tpublic @MyAnn void something() { }\t\n\t       ^^^^^^\nThe annotation @MyAnn is disallowed for this location\n----------\n");
    }

    public void test050() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    String[] value();\n}\n\npublic class X {\n    @I(\"Hello\") void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value={\"Hello\"})\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test051() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    String value() default \"Hello\";\n}\n\npublic class X {\n    @I(\"Hi\") void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=\"Hi\")\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test052() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    int value() default 0;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=(int) 2)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test053() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    byte value() default 0;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=(byte) 2)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test054() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    short value() default 0;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=(short) 2)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test055() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    char value() default ' ';\n}\n\npublic class X {\n    @I('@') void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value='@')\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test056() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    long value() default 6;\n}\n\npublic class X {\n    @I(Long.MAX_VALUE) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=9223372036854775807L)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test057() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    float value();\n}\n\npublic class X {\n    @I(-0.0f) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=-0.0f)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test058() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    double value();\n}\n\npublic class X {\n    @I(-0.0) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=-0.0)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test059() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n    double value() default 0.0;\n    int id();\n}\n@interface I {\n    Foo value();\n}\n\npublic class X {\n    @I(@Foo(id=5)) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=@Foo(id=(int) 5))\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test060() throws Exception {
        this.runConformTest(new String[]{"X.java", "enum Color {\tBLUE, RED, GREEN\n}\n@interface I {\n    Color value() default Color.GREEN;\n}\n\npublic class X {\n    @I(Color.RED) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value=Color.RED)\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test061() throws Exception {
        this.runConformTest(new String[]{"X.java", "enum Color {\tBLUE, RED, GREEN\n}\n@interface I {\n    Color[] value() default { Color.GREEN };\n}\n\npublic class X {\n    @I(Color.RED) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(value={Color.RED})\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test062() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n    double value() default 0.0;\n    int id() default 0;\n}\nenum Color {\tBLUE, RED, GREEN\n}\n@interface I {\n    Color[] enums() default { Color.GREEN };\n    Foo[] annotations() default { @Foo() };\n    int[] ints() default { 0, 1, 2, 3 };\n    byte[] bytes() default { 0 };\n    short[] shorts() default { 0 };\n    long[] longs() default { Long.MIN_VALUE, Long.MAX_VALUE };\n    String[] strings() default { \"\" };\n    boolean[] booleans() default { true, false };\n    float[] floats() default { Float.MAX_VALUE };\n    double[] doubles() default { Double.MAX_VALUE };\n}\n\npublic class X {\n    @I(enums=Color.RED,\n\t\tannotations=@Foo(),\n\t\tints=2,\n\t\tbytes=1,\n\t\tshorts=5,\n\t\tlongs=Long.MIN_VALUE,\n\t\tstrings=\"Hi\",\n\t\tbooleans=true,\n\t\tfloats=0.0f,\n\t\tdoubles=-0.0) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  @I(enums={Color.RED},\n    annotations={@Foo},\n    ints={(int) 2},\n    bytes={(byte) 1},\n    shorts={(short) 5},\n    longs={-9223372036854775808L},\n    strings={\"Hi\"},\n    booleans={true},\n    floats={0.0f},\n    doubles={-0.0})\n  void foo();";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            AnnotationTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test063() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n    double value() default 0.0;\n    int id() default 0;\n}\nenum Color {\tBLUE, RED, GREEN\n}\n@interface I {\n    Color enums() default Color.GREEN;\n    Foo annotations() default @Foo();\n    int ints() default 0;\n    byte bytes() default 0;\n    short shorts() default 0;\n    long longs() default Long.MIN_VALUE;\n    String strings() default \"\";\n    boolean booleans() default true;\n    float floats() default Float.MAX_VALUE;\n    double doubles() default Double.MAX_VALUE;\n}\n\npublic class X {\n    @I(enums=Color.RED,\n\t\tannotations=@Foo(),\n\t\tints=2,\n\t\tbytes=1,\n\t\tshorts=5,\n\t\tlongs=Long.MIN_VALUE,\n\t\tstrings=\"Hi\",\n\t\tbooleans=true,\n\t\tfloats=0.0f,\n\t\tdoubles=-0.0) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  @I(enums=Color.RED,\n    annotations=@Foo,\n    ints=(int) 2,\n    bytes=(byte) 1,\n    shorts=(short) 5,\n    longs=-9223372036854775808L,\n    strings=\"Hi\",\n    booleans=true,\n    floats=0.0f,\n    doubles=-0.0)\n  void foo();";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            AnnotationTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test064() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    String[] names();\n}\n\npublic class X {\n    @I(names={\"Hello\"}) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(names={\"Hello\"})\n  void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test065() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    Class[] classes();\n}\n\npublic class X {\n    @I(classes = {X.class, I.class}) public void foo(){\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  @I(classes={X,I})\n  public void foo();";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    short value() default 0;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n\n"}, "");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n    int value() default 0L;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint value() default 0L;\n\t                    ^^\nType mismatch: cannot convert from long to int\n----------\n");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    short[] value() default 2;\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "@interface I {\n    short[] value() default { 2 };\n}\n\npublic class X {\n    @I(2) void foo() {\n    }\n}\n"}, "");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n    int[][] ids();\n    Object[][] obs();\n}\n\npublic class X {\n\n    @I(ids = {{1 , 2}, { 3 }}) public void foo(){\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[][] ids();\n\t^^^^^^^\nInvalid type int[][] for the annotation attribute I.ids; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n2. ERROR in X.java (at line 3)\n\tObject[][] obs();\n\t^^^^^^^^^^\nInvalid type Object[][] for the annotation attribute I.obs; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n3. ERROR in X.java (at line 8)\n\t@I(ids = {{1 , 2}, { 3 }}) public void foo(){\n\t^^\nThe annotation @I must define the attribute obs\n----------\n4. ERROR in X.java (at line 8)\n\t@I(ids = {{1 , 2}, { 3 }}) public void foo(){\n\t          ^^^^^^^\nThe value for annotation attribute I.ids must be a constant expression\n----------\n5. ERROR in X.java (at line 8)\n\t@I(ids = {{1 , 2}, { 3 }}) public void foo(){\n\t                   ^^^^^\nThe value for annotation attribute I.ids must be a constant expression\n----------\n");
    }

    public void test071() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n\tint hashCode();\n\tObject clone();\n}\n\npublic class X {\n    @I(hashCode = 0) public void foo(){\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint hashCode();\n\t    ^^^^^^^^^^\nThe annotation type I cannot override the method Annotation.hashCode()\n----------\n2. ERROR in X.java (at line 3)\n\tObject clone();\n\t^^^^^^\nInvalid type Object for the annotation attribute I.clone; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n3. ERROR in X.java (at line 3)\n\tObject clone();\n\t       ^^^^^^^\nThe annotation type I cannot override the method Object.clone()\n----------\n4. ERROR in X.java (at line 7)\n\t@I(hashCode = 0) public void foo(){\n\t^^\nThe annotation @I must define the attribute clone\n----------\n");
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n}\n\npublic class X {\n    @I(hashCode = 0) public void foo(){\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@I(hashCode = 0) public void foo(){\n\t   ^^^^^^^^\nThe attribute hashCode is undefined for the annotation type I\n----------\n");
    }

    public void test073() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n    double value() default 0.0;\n    int id() default 0;\n}\nenum Color {\tBLUE, RED, GREEN\n}\n@interface I {\n    Color[] enums() default Color.GREEN;\n    Foo[] annotations() default @Foo();\n    int[] ints() default 0;\n    byte[] bytes() default 1;\n    short[] shorts() default 3;\n    long[] longs() default Long.MIN_VALUE;\n    String[] strings() default \"\";\n    boolean[] booleans() default true;\n    float[] floats() default Float.MAX_VALUE;\n    double[] doubles() default Double.MAX_VALUE;\n    Class[] classes() default I.class;\n}\n\npublic class X {\n    @I(enums=Color.RED,\n\t\tannotations=@Foo(),\n\t\tints=2,\n\t\tbytes=1,\n\t\tshorts=5,\n\t\tlongs=Long.MIN_VALUE,\n\t\tstrings=\"Hi\",\n\t\tbooleans=true,\n\t\tfloats=0.0f,\n\t\tdoubles=-0.0) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "I.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "abstract @interface I extends java.lang.annotation.Annotation {\n  \n  // Method descriptor #8 ()[LColor;\n  public abstract Color[] enums() default {Color.GREEN};\n  \n  // Method descriptor #13 ()[LFoo;\n  public abstract Foo[] annotations() default {@Foo};\n  \n  // Method descriptor #16 ()[I\n  public abstract int[] ints() default {(int) 0};\n  \n  // Method descriptor #19 ()[B\n  public abstract byte[] bytes() default {(byte) 1};\n  \n  // Method descriptor #22 ()[S\n  public abstract short[] shorts() default {(short) 3};\n  \n  // Method descriptor #25 ()[J\n  public abstract long[] longs() default {-9223372036854775808L};\n  \n  // Method descriptor #29 ()[Ljava/lang/String;\n  public abstract java.lang.String[] strings() default {\"\"};\n  \n  // Method descriptor #32 ()[Z\n  public abstract boolean[] booleans() default {true};\n  \n  // Method descriptor #34 ()[F\n  public abstract float[] floats() default {3.4028235E38f};\n  \n  // Method descriptor #37 ()[D\n  public abstract double[] doubles() default {1.7976931348623157E308};\n  \n  // Method descriptor #41 ()[Ljava/lang/Class;\n  public abstract java.lang.Class[] classes() default {I};\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            AnnotationTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test074() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface Foo {\n    double value() default 0.0;\n    int id() default 0;\n}\nenum Color {\tBLUE, RED, GREEN\n}\n@interface I {\n    Color _enum() default Color.GREEN;\n    Foo _annotation() default @Foo;\n    int _int() default 0;\n    byte _byte() default 1;\n    short _short() default 3;\n    long _long() default Long.MIN_VALUE;\n    String _string() default \"\";\n    boolean _boolean() default true;\n    float _float() default Float.MAX_VALUE;\n    double _double() default Double.MAX_VALUE;\n    Class _class() default I.class;\n}\npublic class X {\n    @I(_enum=Color.RED,\n\t\t_annotation=@Foo(),\n\t\t_int=2,\n\t\t_byte=1,\n\t\t_short=5,\n\t\t_long=Long.MIN_VALUE,\n\t\t_string=\"Hi\",\n\t\t_boolean=true,\n\t\t_float=0.0f,\n\t\t_double=-0.0) void foo() {\n    }\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "I.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "abstract @interface I extends java.lang.annotation.Annotation {\n  \n  // Method descriptor #8 ()LColor;\n  public abstract Color _enum() default Color.GREEN;\n  \n  // Method descriptor #13 ()LFoo;\n  public abstract Foo _annotation() default @Foo;\n  \n  // Method descriptor #16 ()I\n  public abstract int _int() default (int) 0;\n  \n  // Method descriptor #19 ()B\n  public abstract byte _byte() default (byte) 1;\n  \n  // Method descriptor #22 ()S\n  public abstract short _short() default (short) 3;\n  \n  // Method descriptor #25 ()J\n  public abstract long _long() default -9223372036854775808L;\n  \n  // Method descriptor #29 ()Ljava/lang/String;\n  public abstract java.lang.String _string() default \"\";\n  \n  // Method descriptor #32 ()Z\n  public abstract boolean _boolean() default true;\n  \n  // Method descriptor #34 ()F\n  public abstract float _float() default 3.4028235E38f;\n  \n  // Method descriptor #37 ()D\n  public abstract double _double() default 1.7976931348623157E308;\n  \n  // Method descriptor #41 ()Ljava/lang/Class;\n  public abstract java.lang.Class _class() default I;\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            AnnotationTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target ({FIELD, FIELD})\n@interface Tgt {\n\tE[] foo();\n\tint[] bar();\n}\nenum E {\n\tBLEU, BLANC, ROUGE\n}\n\n@Tgt( foo = { E.BLEU, E.BLEU}, bar = { 0, 0} )\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Target ({FIELD, FIELD})\n\t                 ^^^^^\nDuplicate element FIELD specified in annotation @Target\n----------\n2. ERROR in X.java (at line 13)\n\t@Tgt( foo = { E.BLEU, E.BLEU}, bar = { 0, 0} )\n\t^^^^\nThe annotation @Tgt is disallowed for this location\n----------\n");
    }

    public void test076() {
        this.runNegativeTest(new String[]{"X.java", "private @interface TestAnnot {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tprivate @interface TestAnnot {\n\t                   ^^^^^^^^^\nIllegal modifier for the annotation type TestAnnot; only public & abstract are permitted\n----------\n");
    }

    public void test077() {
        String expectedOutput = "----------\n1. ERROR in X.java (at line 14)\n\tvoid foo() {}\n\t     ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "class Further {\n\tvoid bar() {}\n}\n\nclass Other extends Further {\n}\n\ninterface Baz {\n\tvoid baz();\n}\n\npublic class X extends Other implements Baz {\n\t@Override\n\tvoid foo() {}\n\t@Override\n\tvoid bar() {}\n\t@Override\n\tpublic void baz() {}\n}\n"}, expectedOutput);
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n\tX() {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tX() {}\n\t^^^\nAnnotation type declaration cannot have a constructor\n----------\n");
    }

    public void test079() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(RUNTIME)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}\n\n@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "@Attr(tst=-1)");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(CLASS)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}\n\n@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(SOURCE)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}\n\n@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null");
    }

    public void test082() {
        this.runConformTest(new String[]{"Attr.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(SOURCE)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null", null, false, null);
    }

    public void test083() {
        this.runConformTest(new String[]{"Attr.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(CLASS)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "null", null, false, null);
    }

    public void test084() {
        this.runConformTest(new String[]{"Attr.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(RUNTIME)\n@Target({TYPE})\n@interface Attr {\n  public int tst() default -1;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "@Attr \npublic class X {\n  public static void main(String args[]) {\n  \tObject e = X.class.getAnnotation(Attr.class);\n  \tSystem.out.print(e);\n  }\n}"}, "@Attr(tst=-1)", null, false, null);
    }

    public void test085() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\n\npublic class X {\n\n  @Retention(RetentionPolicy.RUNTIME) @Target(ElementType.TYPE) @interface\nTestAnnotation {\n\n    String testAttribute();\n\n  }\n  @TestAnnotation(testAttribute = \"test\") class A {\n  }\n\n  public static void main(String[] args) {\n    System.out.print(A.class.isAnnotationPresent(TestAnnotation.class));\n  }\n\n}"}, "true");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\n\n@Target({}) @interface I {}\n@I public class X {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@I public class X {}\n\t^^\nThe annotation @I is disallowed for this location\n----------\n");
    }

    public void test087() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target(TYPE)\n@interface Annot {\n}\n\n@Annot\npublic @interface X {\n}\n"}, "");
    }

    public void test088() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target(LOCAL_VARIABLE)\n@interface Annot {\n}\n\npublic class X {\n\tvoid foo(@Annot int i) {\n\t\t@Annot int j;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tvoid foo(@Annot int i) {\n\t         ^^^^^^\nThe annotation @Annot is disallowed for this location\n----------\n");
    }

    public void test089() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.PARAMETER) @interface I {}\n    \n    void m(@I int i){\n    }\n}"}, "");
    }

    public void test090() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.TYPE) @interface Annot1 {}\n    \n    @Annot1 @interface Annot2 {}\n}"}, "");
    }

    public void test091() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.TYPE) @interface Marker {}\n    \n    @Marker static int i = 123;\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Marker static int i = 123;\n\t^^^^^^^\nThe annotation @X.Marker is disallowed for this location\n----------\n");
    }

    public void test092() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n\npublic class X {\n\n    @Target(ElementType.FIELD) @interface Marker {}\n    \n    @Marker static int i = 123;\n}"}, "");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Inherited;\n\n@Deprecated\n@Inherited\nclass A {\n}\n\nclass B extends A {\n}\n\nclass C extends B {\n}\n\npublic class X {\n\tC c;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Inherited\n\t^^^^^^^^^^\nThe annotation @Inherited is disallowed for this location\n----------\n");
    }

    public void test094() {
        this.runConformTest(new String[]{"I.java", "import java.lang.annotation.Target;\n\n@Target({}) @interface I {}"}, "");
        this.runNegativeTest(new String[]{"X.java", "@I public class X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\t@I public class X {}\n\t^^\nThe annotation @I is disallowed for this location\n----------\n", null, false, null);
    }

    public void test095() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Ann {}\n\npublic class X {\n\t@Ann\n\tvoid foo() {}\n}\n"}, "");
    }

    public void test096() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.annotation.RetentionPolicy.*;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Annotation;\nimport java.lang.reflect.Method;\n\n@Retention(CLASS) @interface Attr {\n}\n\n@Retention(RUNTIME) @interface Foo {\n\tint id() default 0;\n}\n@Foo(id=5) @Attr public class X {\n\tpublic void foo(@Foo(id=5) @Attr final int j, @Attr final int k, int n) {\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tClass c = X.class;\n\t\t\tAnnotation[] annots = c.getAnnotations();\n\t\t\tSystem.out.print(annots.length);\n\t\t\tMethod method = c.getMethod(\"foo\", Integer.TYPE, Integer.TYPE, Integer.TYPE);\n\t\t\tAnnotation[][] annotations = method.getParameterAnnotations();\n\t\t\tfinal int length = annotations.length;\n\t\t\tSystem.out.print(length);\n\t\t\tif (length == 3) {\n\t\t\t\tSystem.out.print(annotations[0].length);\n\t\t\t\tSystem.out.print(annotations[1].length);\n\t\t\t\tSystem.out.print(annotations[2].length);\n\t\t\t}\n\t\t} catch(NoSuchMethodException e) {\n\t\t}\n\t}\n}"}, "13100");
    }

    public void test097() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n\tint id default 0;\n}\n\n@I() public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(X.class.getAnnotation(I.class));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint id default 0;\n\t       ^^^^^^^\nSyntax error on token \"default\", = expected\n----------\n");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"X.java", "@interface I {\n\tint id default 0;\n}\n\n@I() public class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(X.class.getAnnotation(I.class));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint id default 0;\n\t       ^^^^^^^\nSyntax error on token \"default\", = expected\n----------\n");
    }

    public void test099() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.lang.reflect.Method;\n\npublic class X {\n    public static void main(String[] args) {\n        Object o = new X();\n        for (Method m : o.getClass().getMethods()) {\n            if (m.isAnnotationPresent(MyAnon.class)) {\n                System.out.println(m.getAnnotation(MyAnon.class).c());\n            }\n        }\n    }\n    @MyAnon(c = X.class) \n    public void foo() {}\n\n    @Retention(RetentionPolicy.RUNTIME) \n    public @interface MyAnon {\n        Class c();\n    }\n    public interface I {\n    }\n}"}, "class X");
    }

    public void test100() {
        this.runConformTest(new String[]{"X.java", "abstract class Foo {\n\tabstract protected boolean accept(Object o);\n}\n\npublic class X extends Foo {\n\t@Override \n\tprotected boolean accept(Object o) { return false; }\n}\n"}, "");
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Target;\n\n@Target(Element)\npublic @interface X {\n\t\n\tboolean UML() default false;\n\tboolean platformDependent() default true;\n\tboolean OSDependent() default true;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@Target(Element)\n\t        ^^^^^^^\nElement cannot be resolved to a variable\n----------\n");
    }

    public void test102() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  @TestAnnotation(testAttribute = \"test\") class A {\n  }\n  public static void main(String[] args) {\n    System.out.print(A.class.isAnnotationPresent(TestAnnotation.class));\n  }\n}", "TestAnnotation.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\n@Retention(RetentionPolicy.RUNTIME) @Target(ElementType.TYPE) public @interface\nTestAnnotation {\n    String testAttribute();\n}\n"}, "true");
    }

    public void test103() {
        this.runConformTest(new String[]{"TestAnnotation.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\n@Retention(RetentionPolicy.RUNTIME) @Target(ElementType.TYPE) public @interface\nTestAnnotation {\n    String testAttribute();\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n  @TestAnnotation(testAttribute = \"test\") class A {\n  }\n  public static void main(String[] args) {\n    System.out.print(A.class.isAnnotationPresent(TestAnnotation.class));\n  }\n}"}, "true", null, false, null);
    }

    public void test104() {
        this.runConformTest(new String[]{"X.java", "@interface ValuesAnnotation {\n\tbyte[] byteArrayValue();\n\tchar[] charArrayValue();\n\tboolean[] booleanArrayValue();\n\tint[] intArrayValue();\n\tshort[] shortArrayValue();\n\tlong[] longArrayValue();\n\tfloat[] floatArrayValue();\n\tdouble[] doubleArrayValue();\n\tString[] stringArrayValue();\n\tValuesEnum[] enumArrayValue();\n\tValueAttrAnnotation[] annotationArrayValue();\n\tClass[] classArrayValue();\n\tbyte byteValue();\n\tchar charValue();\n\tboolean booleanValue();\n\tint intValue();\n\tshort shortValue();\n\tlong longValue();\n\tfloat floatValue();\n\tdouble doubleValue();\n\tString stringValue();\n\tValuesEnum enumValue();\n\tValueAttrAnnotation annotationValue();\n\tClass classValue();\n}\nenum ValuesEnum {\n\tONE, TWO;\n}\n\n@interface ValueAttrAnnotation {\n\tString value() default \"\";\n}\n@interface ValueAttrAnnotation1 {\n\tString value();\n}\n@interface ValueAttrAnnotation2 {\n\tString value();\n}\n@ValuesAnnotation(\n  byteValue = 1,\n  charValue = 'A',\n  booleanValue = true,\n  intValue = 1,\n  shortValue = 1,\n  longValue = 1L,\n  floatValue = 1.0f,\n  doubleValue = 1.0d,\n  stringValue = \"A\",\n\n  enumValue = ValuesEnum.ONE,\n  annotationValue = @ValueAttrAnnotation( \"annotation\"),\n  classValue = X.class,\n\n  byteArrayValue = { 1, -1},\n  charArrayValue = { 'c', 'b', (char)-1},\n  booleanArrayValue = {true, false},\n  intArrayValue = { 1, -1},\n  shortArrayValue = { (short)1, (short)-1},\n  longArrayValue = { 1L, -1L},\n  floatArrayValue = { 1.0f, -1.0f},\n  doubleArrayValue = { 1.0d, -1.0d},\n  stringArrayValue = { \"aa\", \"bb\"},\n\n  enumArrayValue = {ValuesEnum.ONE, ValuesEnum.TWO},\n  annotationArrayValue = {@ValueAttrAnnotation( \"annotation1\"),\n@ValueAttrAnnotation( \"annotation2\")},\n  classArrayValue = {X.class, X.class}\n)\n@ValueAttrAnnotation1( \"classAnnotation1\")\n@ValueAttrAnnotation2( \"classAnnotation2\")\npublic class X {\n\n  @ValueAttrAnnotation1( \"fieldAnnotation1\")\n  @ValueAttrAnnotation2( \"fieldAnnotation2\")\n  public String testfield = \"test\";\n\n  @ValueAttrAnnotation1( \"methodAnnotation1\")\n  @ValueAttrAnnotation2( \"methodAnnotation2\")\n  @ValueAttrAnnotation()\n  public void testMethod( \n      @ValueAttrAnnotation1( \"param1Annotation1\") \n      @ValueAttrAnnotation2( \"param1Annotation2\") String param1, \n      @ValueAttrAnnotation1( \"param2Annotation1\") \n      @ValueAttrAnnotation2( \"param2Annotation2\") int param2) {\n    // @ValueAttrAnnotation( \"codeAnnotation\")\n  }\n}\n"}, "");
    }

    public void test105() {
        this.runConformTest(new String[]{"Property.java", "import java.lang.annotation.Documented;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n\n@Documented\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface Property\n{\n  String property();\n  String identifier() default \"\";\n}", "Properties.java", "import java.lang.annotation.Documented;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n\n@Documented\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface Properties {\n  Property[] value();\n}", "X.java", "@Properties({\n  @Property(property = \"prop\", identifier = \"someIdentifier\"),\n  @Property(property = \"type\")\n})\npublic interface X {\n  void setName();\n  String getName();\n}"}, "");
        try {
            byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
            new ClassFileReader(classFileBytes, "X.java".toCharArray(), true);
        }
        catch (org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException e) {
            AnnotationTest.assertTrue((String)"ClassFormatException", (boolean)false);
        }
        catch (IOException e) {
            AnnotationTest.assertTrue((String)"IOException", (boolean)false);
        }
    }

    public void test106() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n    int[] bar() default null;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint[] bar() default null;\n\t                    ^^^^\nThe value for annotation attribute X.bar must be a constant expression\n----------\n");
    }

    public void test107() {
        this.runNegativeTest(new String[]{"X.java", "@interface Ann {\n    int[] bar();\n}\n@Ann(bar=null) class X {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Ann(bar=null) class X {}\n\t         ^^^^\nThe value for annotation attribute Ann.bar must be a constant expression\n----------\n");
    }

    public void test108() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {}\n\n@interface Bar {\n    Foo[] foo() default null;\n}\n\n@Bar(foo=null)\npublic class X { \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFoo[] foo() default null;\n\t                    ^^^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n2. ERROR in X.java (at line 7)\n\t@Bar(foo=null)\n\t         ^^^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n");
    }

    public void test109() {
        this.runNegativeTest(new String[]{"X.java", "@interface Foo {}\n\n@interface Bar {\n    Foo[] foo() default \"\";\n}\n\n@Bar(foo=\"\")\npublic class X { \n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFoo[] foo() default \"\";\n\t                    ^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n2. ERROR in X.java (at line 7)\n\t@Bar(foo=\"\")\n\t         ^^\nThe value for annotation attribute Bar.foo must be some @Foo annotation \n----------\n");
    }

    public void test110() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.util.Arrays;\n\n@interface Ann {\n}\n\ninterface Iface extends Ann {\n}\n\nabstract class Klass implements Ann {\n}\n\nclass SubKlass extends Klass {\n\tpublic Class<? extends Annotation> annotationType() {\n\t\treturn null;\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = SubKlass.class;\n\t\tSystem.out.print(\"Classes:\");\n\t\twhile (c != Object.class) {\n\t\t\tSystem.out.print(\"-> \" + c.getName());\n\t\t\tc = c.getSuperclass();\n\t\t}\n\n\t\tSystem.out.print(\", Interfaces:\");\n\t\tc = SubKlass.class;\n\t\twhile (c != Object.class) {\n\t\t\tClass[] i = c.getInterfaces();\n\t\t\tSystem.out.print(\"-> \" + Arrays.asList(i));\n\t\t\tc = c.getSuperclass();\n\t\t}\n\t}\n}\n"}, "Classes:-> SubKlass-> Klass, Interfaces:-> []-> [interface Ann]");
    }

    public void test111() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        String expectedOutput = "----------\n1. WARNING in X.java (at line 8)\n\tinterface Iface extends Ann {\n\t                        ^^^\nThe annotation type Ann should not be used as a superinterface for Iface\n----------\n2. WARNING in X.java (at line 11)\n\tabstract class Klass implements Ann {\n\t                                ^^^\nThe annotation type Ann should not be used as a superinterface for Klass\n----------\n3. ERROR in X.java (at line 14)\n\tclass SubKlass extends Klass {\n\t      ^^^^^^^^\nThe type SubKlass must implement the inherited abstract method Ann.foo()\n----------\n4. WARNING in X.java (at line 20)\n\tclass AnnImpl implements Ann {\n\t                         ^^^\nThe annotation type Ann should not be used as a superinterface for AnnImpl\n----------\n5. ERROR in X.java (at line 21)\n\tpublic boolean equals(Object obj) { return false; }\n\t               ^^^^^^^^^^^^^^^^^^\nThe method equals(Object) of type AnnImpl should be tagged with @Override since it actually overrides a superclass method\n----------\n6. ERROR in X.java (at line 22)\n\tpublic int hashCode() { return 0; }\n\t           ^^^^^^^^^^\nThe method hashCode() of type AnnImpl should be tagged with @Override since it actually overrides a superclass method\n----------\n7. ERROR in X.java (at line 23)\n\tpublic String toString() { return null; }\n\t              ^^^^^^^^^^\nThe method toString() of type AnnImpl should be tagged with @Override since it actually overrides a superclass method\n----------\n8. WARNING in X.java (at line 30)\n\tClass c = SubKlass.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n9. WARNING in X.java (at line 41)\n\tClass[] i = c.getInterfaces();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n";
        this.runNegativeTest(true, new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.util.Arrays;\n\n@interface Ann {\n\tint foo();\n}\n\ninterface Iface extends Ann {\n}\n\nabstract class Klass implements Ann {\n}\n\nclass SubKlass extends Klass {\n\tpublic Class<? extends Annotation> annotationType() {\n\t\treturn null;\n\t}\n}\n\nclass AnnImpl implements Ann {\n    public boolean equals(Object obj) { return false; }\n    public int hashCode() { return 0; }\n    public String toString() { return null; }\n    public Class<? extends Annotation> annotationType() { return null; }\n    public int foo() { return 0; }\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tClass c = SubKlass.class;\n\t\tSystem.out.println(\"Classes:\");\n\t\twhile (c != Object.class) {\n\t\t\tSystem.out.println(\"-> \" + c.getName());\n\t\t\tc = c.getSuperclass();\n\t\t}\n\n\t\tSystem.out.println();\n\t\tSystem.out.println(\"Interfaces:\");\n\t\tc = SubKlass.class;\n\t\twhile (c != Object.class) {\n\t\t\tClass[] i = c.getInterfaces();\n\t\t\tSystem.out.println(\"-> \" + Arrays.asList(i));\n\t\t\tc = c.getSuperclass();\n\t\t}\n\t}\n}\n"}, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test112() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n  String foo1() default \"\";\n}\n@Annot(foo1=zzz)\npublic class X {\n  static final String zzz =  \"\";\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Annot(foo1=zzz)\n\t            ^^^\nzzz cannot be resolved to a variable\n----------\n");
    }

    public void test113() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tString foo();\n}\n@Annot( foo = new String(){} )\npublic class X {\n\t\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Annot( foo = new String(){} )\n\t                  ^^^^^^\nAn anonymous class cannot subclass the final class String\n----------\n");
    }

    public void test114() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tClass foo();\n}\n@Annot( foo = M.class )\npublic class X {\n\tclass M {}\n\t\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tClass foo();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\t@Annot( foo = M.class )\n\t              ^\nM cannot be resolved to a type\n----------\n");
    }

    public void test115() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n\tClass foo();\n\tString bar() default \"\";\n}\n@Annot(foo = M.class, bar = baz()+s)\npublic class X {\n\tclass M {\n\t}\n\tfinal static String s = \"\";\n\tString baz() { return null; }\n\t@Annot(foo = T.class, bar = s)\n\t<T> T foo(T t, String s) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tClass foo();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\t@Annot(foo = M.class, bar = baz()+s)\n\t             ^\nM cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\t@Annot(foo = M.class, bar = baz()+s)\n\t                            ^^^\nThe method baz() is undefined for the type X\n----------\n4. ERROR in X.java (at line 5)\n\t@Annot(foo = M.class, bar = baz()+s)\n\t                                  ^\ns cannot be resolved to a variable\n----------\n5. ERROR in X.java (at line 11)\n\t@Annot(foo = T.class, bar = s)\n\t             ^^^^^^^\nIllegal class literal for the type parameter T\n----------\n6. WARNING in X.java (at line 12)\n\t<T> T foo(T t, String s) {\n\t                      ^\nThe parameter s is hiding a field from type X\n----------\n");
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.java", "/** @deprecated */\n@Deprecated\npublic class X {\n}\n", "Y.java", "public class Y {\n\tX x;\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 2)\n\tX x;\n\t^\nThe type X is deprecated\n----------\n2. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test117() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n}\n", "Y.java", "public class Y {\n\tX x;\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 2)\n\tX x;\n\t^\nThe type X is deprecated\n----------\n2. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test118() {
        this.runNegativeTest(new String[]{"X.java", "@interface Deprecated {}\n\n@Deprecated // not the real @Deprecated interface\npublic class X {\n}\n", "Y.java", "public class Y {\n\tX x;\n\tZork z;\n}\n"}, "----------\n1. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test119() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n\tvoid foo(){}\n}\n", "Y.java", "public class Y extends X {\n\tvoid foo(){ super.foo(); }\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t     ^^^^^\nThe method foo() of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t                  ^^^\nThe method foo() from the type X is deprecated\n----------\n4. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n\tvoid foo(){}\n}\n", "Y.java", "public class Y extends X {\n\tvoid foo(){ super.foo(); }\n\tZork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t     ^^^^^\nThe method foo() of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n3. WARNING in Y.java (at line 2)\n\tvoid foo(){ super.foo(); }\n\t                  ^^^\nThe method foo() from the type X is deprecated\n----------\n4. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test121() {
        this.runNegativeTest(new String[]{"X.java", "/** @deprecated */\npublic class X {\n\t/** @deprecated */\n\tpublic static class Y {\n\t}\n\t/** @deprecated */\n\tint i;\n\t/** @deprecated */\n\tpublic void flag() {}\n\tvoid doNotFlag() {}\n  Zork z;\n} \n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic class X {\n\t             ^\nThe deprecated type X should be annotated with @Deprecated\n----------\n2. WARNING in X.java (at line 4)\n\tpublic static class Y {\n\t                    ^\nThe deprecated type X.Y should be annotated with @Deprecated\n----------\n3. WARNING in X.java (at line 7)\n\tint i;\n\t    ^\nThe deprecated field X.i should be annotated with @Deprecated\n----------\n4. WARNING in X.java (at line 9)\n\tpublic void flag() {}\n\t            ^^^^^^\nThe deprecated method flag() of type X should be annotated with @Deprecated\n----------\n5. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test122() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.reflect.Method;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nclass GenericWithInnerAnnotation<T> {\n    @Retention(RetentionPolicy.RUNTIME)\n    @Target(ElementType.METHOD)\n    public @interface MyAnnotation {\n    }\n}\npublic class X extends GenericWithInnerAnnotation<Integer> {\n    @MyAnnotation\n    public void aMethod() {\n    }\n    \n    public static void main(String[] args) {\n       try {\n           Method method = X.class.getDeclaredMethod(\"aMethod\", new Class[]{});\n           System.out.print(method.getName());\n           Annotation[] annotations = method.getAnnotations();\n           System.out.println(annotations.length);\n       } catch(NoSuchMethodException e) {\n       }\n    }\n}"}, "aMethod1");
    }

    public void test123() {
        this.runNegativeTest(new String[]{"X.java", "class SuperX {\n\n    static void notOverridden() {\n        return;\n    }\n}\n\npublic class X extends SuperX {\n\n    static void notOverridden() {\n        return;\n    }\n  Zork z;\n} \n"}, "----------\n1. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test124() {
        this.runNegativeTest(new String[]{"X.java", "class SuperX {\n\n    void notOverridden() {\n        return;\n    }\n}\n\npublic class X extends SuperX {\n\n    void notOverridden() {\n        return;\n    }\n  Zork z;\n} \n"}, "----------\n1. WARNING in X.java (at line 10)\n\tvoid notOverridden() {\n\t     ^^^^^^^^^^^^^^^\nThe method notOverridden() of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test125() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n\npublic class X implements Ann {\n\t\n\tAnn ann = new X();\n\tpublic Class<? extends Annotation>  annotationType() {\n\t\treturn null;\n\t}\n}\n\n@interface Ann {}\n\n"}, "");
    }

    public void test126() {
        this.runNegativeTest(new String[]{"X.java", "public interface X {\n   Zork z;\n   X clone();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test127() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\npublic class X {\n   void foo(){}\n}\n", "Y.java", "public class Y extends X {\n  @SuppressWarnings(\"all\")\n   void foo(){ super.foo(); }\n   Zork z;\n}\n"}, "----------\n1. WARNING in Y.java (at line 1)\n\tpublic class Y extends X {\n\t                       ^\nThe type X is deprecated\n----------\n2. ERROR in Y.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test128() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n    void foo(List list) {\n        List<String> ls1 = list;\n    }\n    @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n    void bar(List list) {\n        List<String> ls2 = list;\n    }\n   Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid foo(List list) {\n\t         ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tList<String> ls1 = list;\n\t                   ^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n3. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test129() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\n@SuppressWarnings(\"unchecked\")\npublic class X {\n\tvoid foo() {\n\t\tMap<String, String>[] map = new HashMap[10];\n\t}\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test130() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        String[] warnings = CompilerOptions.warningOptionNames();
        int i = 0;
        int ceil = warnings.length;
        while (i < ceil) {
            customOptions.put(warnings[i], "warning");
            ++i;
        }
        this.runConformTest(true, new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n  }\n}\n"}, null, customOptions, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. WARNING in X.java (at line 2)\n\tpublic static void main(String[] args) {\n\t                   ^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n3. WARNING in X.java (at line 2)\n\tpublic static void main(String[] args) {\n  }\n\t                                       ^^^^^\nEmpty block should be documented\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test131() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"all\")\npublic class X {\n  public static void main(String[] args) {\n    Zork z;\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test132() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t\t// Zork z;\n\t}\n\n\tclass S implements Serializable {\n\t\tString dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tW.deprecated();\n\t  ^^^^^^^^^^\nThe method deprecated() from the type W is deprecated\n----------\n2. WARNING in X.java (at line 8)\n\tList<X> l = new Vector();\n\t            ^^^^^^^^^^^^\nType safety: The expression of type Vector needs unchecked conversion to conform to List<X>\n----------\n3. WARNING in X.java (at line 8)\n\tList<X> l = new Vector();\n\t                ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n4. WARNING in X.java (at line 12)\n\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nfinally block does not complete normally\n----------\n5. WARNING in X.java (at line 18)\n\tclass S implements Serializable {\n\t      ^\nThe serializable class S does not declare a static final serialVersionUID field of type long\n----------\n", null, true, null, "java.lang.Error");
    }

    public void test133() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\n@SuppressWarnings( { \"deprecation\",//$NON-NLS-1$\n\t\t\"finally\",//$NON-NLS-1$\n\t\t\"rawtypes\",//$NON-NLS-1$\n\t\t\"serial\",//$NON-NLS-1$\n\t\t\"unchecked\"//$NON-NLS-1$\n})\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t}\n\n\tclass S implements Serializable {\n\t\tZork dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 24)\n\tZork dummy;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test134() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\npublic class X {\n\t@SuppressWarnings( { \"deprecation\",//$NON-NLS-1$\n\t\t\t\"finally\",//$NON-NLS-1$\n\t\t\t\"rawtypes\",//$NON-NLS-1$\n\t\t\t\"unchecked\"//$NON-NLS-1$\n\t})\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t}\n\n\t@SuppressWarnings({\"unchecked\", \"rawtypes\"}//$NON-NLS-1$//$NON-NLS-2$\n\t)\n\tList<X> l = new Vector();\n\n\t@SuppressWarnings(\"serial\"//$NON-NLS-1$\n\t)\n\tclass S implements Serializable {\n\t\tZork dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 29)\n\tZork dummy;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test135() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"all\")//$NON-NLS-1$\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\timport java.util.List;\n\t^^^^^^\nSyntax error on token \"import\", package expected\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test136() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\"//$NON-NLS-1$\n\t)\n\tprivate static final String marker = \"never used mark\"; //$NON-NLS-1$\n\n\tpublic static void main(String[] args) {\n\t\tZork z;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test137() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        String[] warnings = CompilerOptions.warningOptionNames();
        int i = 0;
        int ceil = warnings.length;
        while (i < ceil) {
            customOptions.put(warnings[i], "warning");
            ++i;
        }
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.Vector;\n\n@SuppressWarnings(\"all\")\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tW.deprecated();\n\t\tList<X> l = new Vector();\n\t\tl.size();\n\t\ttry {\n\t\t\t// do nothing\n\t\t} finally {\n\t\t\tthrow new Error();\n\t\t}\n\t\tZork z;\n\t}\n\n\tclass S implements Serializable {\n\t\tString dummy;\n\t}\n}", "W.java", "public class W {\n\t// @deprecated\n\t@Deprecated\n\tstatic void deprecated() {\n\t\t// do nothing\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. WARNING in X.java (at line 7)\n\tpublic static void main(String[] args) {\n\t                   ^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing comment for public declaration\n----------\n3. WARNING in X.java (at line 8)\n\tW.deprecated();\n\t  ^^^^^^^^^^\nThe method deprecated() from the type W is deprecated\n----------\n4. WARNING in X.java (at line 9)\n\tList<X> l = new Vector();\n\t            ^^^^^^^^^^^^\nType safety: The expression of type Vector needs unchecked conversion to conform to List<X>\n----------\n5. WARNING in X.java (at line 9)\n\tList<X> l = new Vector();\n\t                ^^^^^^\nVector is a raw type. References to generic type Vector<E> should be parameterized\n----------\n6. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n7. WARNING in X.java (at line 19)\n\tclass S implements Serializable {\n\t      ^\nThe serializable class S does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in W.java (at line 1)\n\tpublic class W {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n", null, true, customOptions);
    }

    public void test138() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"zork\")//$NON-NLS-1$\npublic class X {\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\t@SuppressWarnings(\"zork\")//$NON-NLS-1$\n\t                  ^^^^^^\nUnsupported @SuppressWarnings(\"zork\")\n----------\n2. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, customOptions);
    }

    public void test139() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"zork\", \"warningToken\"})//$NON-NLS-1$//$NON-NLS-2$\npublic class X {\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\t@SuppressWarnings({\"zork\", \"warningToken\"})//$NON-NLS-1$//$NON-NLS-2$\n\t                   ^^^^^^\nUnsupported @SuppressWarnings(\"zork\")\n----------\n2. WARNING in X.java (at line 1)\n\t@SuppressWarnings({\"zork\", \"warningToken\"})//$NON-NLS-1$//$NON-NLS-2$\n\t                           ^^^^^^^^^^^^^^\nUnsupported @SuppressWarnings(\"warningToken\")\n----------\n3. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, customOptions);
    }

    public void test140() {
        String expectedOutput = "----------\n1. ERROR in X.java (at line 6)\n\tstatic void foo(){}\t\n\t            ^^^^^\nThe method foo() of type Bar must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  static void foo(){}\n}\nclass Bar extends X {\n  @Override\n  static void foo(){}\t\n}\n\n"}, expectedOutput, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test141() {
        this.runNegativeTest(new String[]{"X.java", "@interface X1 {\n\tClass<? extends Throwable>[] expected1() default {};\n\tClass<? super Throwable>[] expected2() default {};\n\tClass<?>[] expected3() default {};\n}\n\npublic class X {\n\t@X1(expected1=Throwable.class, expected2={})\n\tpublic static void main(String[] args) {\n\t\t\n\t}\n\tvoid foo() {\n\t\tClass<? extends Throwable>[] c1 = {};\n\t\tClass<? super Throwable>[] c2 = {};\n\t\tClass<?>[] c3 = {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tClass<? extends Throwable>[] c1 = {};\n\t                                  ^^\nCannot create a generic array of Class<? extends Throwable>\n----------\n2. ERROR in X.java (at line 14)\n\tClass<? super Throwable>[] c2 = {};\n\t                                ^^\nCannot create a generic array of Class<? super Throwable>\n----------\n");
    }

    public void test142() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n  Zork z;\n}\n"}, "----------\n1. ERROR in p\\OldStuff.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null);
    }

    public void test142b() {
        HashMap<String, String> raiseInvalidJavadocSeverity = new HashMap<String, String>(2);
        raiseInvalidJavadocSeverity.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n  Zork z;\n}\n"}, "----------\n1. ERROR in p\\OldStuff.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, raiseInvalidJavadocSeverity);
    }

    public void test142c() {
        HashMap<String, String> raiseDeprecationReduceInvalidJavadocSeverity = new HashMap<String, String>(2);
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
        this.runNegativeTest(true, new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n}\n"}, null, raiseDeprecationReduceInvalidJavadocSeverity, "----------\n1. WARNING in X.java (at line 1)\n\t@SuppressWarnings(\"deprecation\")\n\t                  ^^^^^^^^^^^^^\nUnnecessary @SuppressWarnings(\"deprecation\")\n----------\n2. ERROR in X.java (at line 2)\n\tpublic class X extends p.OldStuff {\n\t                         ^^^^^^^^\nThe type OldStuff is deprecated\n----------\n3. ERROR in X.java (at line 8)\n\tsuper.foo();\n\t      ^^^\nThe method foo() from the type OldStuff is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test143() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends p.OldStuff {\n\t@SuppressWarnings(\"all\")\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n  Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X extends p.OldStuff {\n\t                         ^^^^^^^^\nThe type OldStuff is deprecated\n----------\n----------\n1. ERROR in p\\OldStuff.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test144() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tZork z;\n\t@SuppressWarnings(\"all\")  \n\tpublic static class EverythingWrong {\n\t\tprivate EverythingWrong() {}\n\t\t@BeforeClass public void notStaticBC() {}\n\t\t@BeforeClass static void notPublicBC() {}\n\t\t@BeforeClass public static int nonVoidBC() { return 0; }\n\t\t@BeforeClass public static void argumentsBC(int i) {}\n\t\t@BeforeClass public static void fineBC() {}\n\t\t@AfterClass public void notStaticAC() {}\n\t\t@AfterClass static void notPublicAC() {}\n\t\t@AfterClass public static int nonVoidAC() { return 0; }\n\t\t@AfterClass public static void argumentsAC(int i) {}\n\t\t@AfterClass public static void fineAC() {}\n\t\t@After public static void staticA() {}\n\t\t@After void notPublicA() {}\n\t\t@After public int nonVoidA() { return 0; }\n\t\t@After public void argumentsA(int i) {}\n\t\t@After public void fineA() {}\n\t\t@Before public static void staticB() {}\n\t\t@Before void notPublicB() {}\n\t\t@Before public int nonVoidB() { return 0; }\n\t\t@Before public void argumentsB(int i) {}\n\t\t@Before public void fineB() {}\n\t\t@Test public static void staticT() {}\n\t\t@Test void notPublicT() {}\n\t\t@Test public int nonVoidT() { return 0; }\n\t\t@Test public void argumentsT(int i) {}\n\t\t@Test public void fineT() {}\n\t}\n\t@Test public void testFailures() throws Exception {\n\t\tList<Exception> problems= new TestIntrospector(EverythingWrong.class).validateTestMethods();\n\t\tint errorCount= 1 + 4 * 5; // missing constructor plus four invalid methods for each annotation */\n\t\tassertEquals(errorCount, problems.size());\n\t}\n\tpublic static junit.framework.Test suite() {\n\t\treturn null; // new JUnit4TestAdapter(TestMethodTest.class);\n\t}\n\tvoid assertEquals(int i, int j) {\n\t}\n}\n@interface BeforeClass {}\n@interface AfterClass {}\n@interface Test {}\n@interface After {}\n@interface Before {}\nclass TestIntrospector {\n\tTestIntrospector(Class c) {}\n\tList validateTestMethods() { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 34)\n\tList<Exception> problems= new TestIntrospector(EverythingWrong.class).validateTestMethods();\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Exception>\n----------\n3. ERROR in X.java (at line 38)\n\tpublic static junit.framework.Test suite() {\n\t              ^^^^^\njunit cannot be resolved to a type\n----------\n4. WARNING in X.java (at line 50)\n\tTestIntrospector(Class c) {}\n\t                 ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n5. WARNING in X.java (at line 51)\n\tList validateTestMethods() { return null; }\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test145() {
        this.runNegativeTest(new String[]{"X.java", "@interface Annot {\n  int foo();\n  int bar();\n}\n\npublic class X {\n  static final int yyy = 0;\n  @Annot(foo=zzz, bar = yyy)\n  static final int zzz = 0;\n}\n\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Annot(foo=zzz, bar = yyy)\n\t           ^^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test146() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(value={})\npublic class X {\n}\n"}, "");
    }

    public void test147() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"nls\"})\npublic class X<T> {\n\t String test= \"\";\n}"}, "", null, true, options);
    }

    public void test148() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static void foo() {\n\t\t @interface Bar {\n\t\t\tpublic String bar = \"BUG\";\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t@interface Bar {\n\t           ^^^\nThe member annotation Bar can only be defined inside a top-level class or interface or in a static context\n----------\n");
    }

    public void test149() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\t@Annot(foo = zzz)\n\t\tfinal int zzz = 0;\n\n\t\t@Annot(foo = kkk)\n\t\tint kkk = 1;\n\n\t}\n\t@Annot(foo = fff)\n\tfinal int fff = 0;\n\t\n\t@Annot(foo = Member.ttt)\n\tstatic class Member {\n\t\tfinal static int ttt = 2;\n\t}\n}\n@interface Annot {\n\tint foo();\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@Annot(foo = kkk)\n\t             ^^^\nThe value for annotation attribute Annot.foo must be a constant expression\n----------\n2. ERROR in X.java (at line 10)\n\t@Annot(foo = fff)\n\t             ^^^\nCannot reference a field before it is defined\n----------\n");
    }

    public void test150() {
        this.runConformTest(true, new String[]{"X.java", "@SuppressWarnings(\"assertIdentifier\")\nclass X {}"}, "----------\n1. WARNING in X.java (at line 1)\n\t@SuppressWarnings(\"assertIdentifier\")\n\t                  ^^^^^^^^^^^^^^^^^^\nUnsupported @SuppressWarnings(\"assertIdentifier\")\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test151() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"boxing\"})\npublic class X {\n\t static void foo(int i) {}\n\t public static void main(String[] args) {\n\t\tfoo(Integer.valueOf(0));\n\t }\n}"}, "", null, true, options);
    }

    public void test152() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"boxing\"})\npublic class X {\n\t static void foo(Integer i) {}\n\t public static void main(String[] args) {\n\t\tfoo(0);\n\t }\n}"}, "", null, true, options);
    }

    public void test153() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
        this.runConformTest(new String[]{"X.java", "enum E { A, B, C }\npublic class X {\n    @SuppressWarnings({\"incomplete-switch\"})\n\t public static void main(String[] args) {\n\t\tfor (E e : E.values()) {\n\t\t\tswitch(e) {\n\t\t\t\tcase A :\n\t\t\t\t\tSystem.out.println(e);\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t }\n}"}, options);
    }

    public void test154() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t static int i;\n    @SuppressWarnings({\"hiding\"})\n\t public static void main(String[] args) {\n\t\tfor (int i = 0, max = args.length; i < max; i++) {\n\t\t\tSystem.out.println(args[i]);\n\t\t}\n\t }\n}"}, "", null, true, options);
    }

    public void test155() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"hiding\"})\npublic class X {\t\n\t{ int x = \n\t\tnew Object() { \t\n\t\t\tint foo() {\t\n\t\t\t\tint x = 0;\n\t\t\t\treturn x;\t\n\t\t\t}\t\n\t\t}.foo();\t\n\t}\t\n}\n"}, "", null, true, options);
    }

    public void test156() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "class T {}\n@SuppressWarnings({\"hiding\"})\npublic class X<T> {\n}\n"}, "", null, true, options);
    }

    public void test157() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
        runner.testFiles = new String[]{"X.java", "public class X {\n   @SuppressWarnings({\"hiding\"})\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new BX();\n\t\t} catch(BX e) {\n\t\t} catch(AX e) {\n\t\t}\n\t}\n} \n@SuppressWarnings({\"serial\"})\nclass AX extends Exception {}\n@SuppressWarnings({\"serial\"})\nclass BX extends AX {}\n"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.SKIP;
        runner.runConformTest();
    }

    public void test157b() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
        runner.testFiles = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new BX();\n\t\t} catch(BX e) {\n\t\t} catch(AX e) {\n\t\t}\n\t}\n} \n@SuppressWarnings({\"serial\"})\nclass AX extends Exception {}\n@SuppressWarnings({\"serial\"})\nclass BX extends AX {}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 6)\n\t} catch(AX e) {\n\t        ^^\nUnreachable catch block for AX. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n";
        runner.runWarningTest();
    }

    public void test158() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   @SuppressWarnings({\"finally\"})\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new AX();\n\t\t} finally {\n\t\t\treturn;\n\t\t}\n\t}\n} \n@SuppressWarnings({\"serial\"})\nclass AX extends Exception {}"}, "", null, true, options);
    }

    public void test159() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
        runner.testFiles = new String[]{"X.java", "@SuppressWarnings({\"static-access\"})\npublic class X extends XZ {\n\t\n\tvoid foo() {\n\t\tint j = X.S;\n\t\tint k = super.S;\n\t\tint l = XZ.S;\n\t\tint m = XY.S;\n\t\t\n\t\tbar();\n\t\tX.bar();\n\t\tXY.bar();\n\t\tXZ.bar();\n\t}\n}\nclass XY {\n\tstatic int S = 10;\n\tstatic void bar(){}\n}\nclass XZ extends XY {\n}"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.SKIP;
        runner.runConformTest();
    }

    public void test160() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
        runner.testFiles = new String[]{"X.java", "@SuppressWarnings(\"static-access\")\npublic class X {\n\tvoid foo() {\n\t\tint m = new XY().S;\n\t}\n}\nclass XY {\n\tstatic int S = 10;\n}"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.SKIP;
        runner.runConformTest();
    }

    public void test161() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"unqualified-field-access\")\npublic class X {\n\tint i;\n\tint foo() {\n\t\treturn i;\n\t}\n}"}, "", null, true, options);
    }

    public void test162() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "warning");
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings({\"unchecked\", \"rawtypes\"})\npublic class X<T> {\n    \n    public static void main(String[] args) {\n        AX ax = new AX();\n        AX ax2 = ax.p;\n        ax.p = new AX<String>();\n        ax.q = new AX<String>();\n        ax.r = new AX<Object>();\n        System.out.println(ax2);\n    }\n}\n\nclass AX <P> {\n    AX<P> p;\n    AX<Object> q;\n    AX<String> r;\n    BX<String> s;\n}\n\nclass BX<Q> {\n}\n"}, "", null, true, options);
    }

    public void test163() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n@SuppressWarnings(\"unused\")\npublic class X<T> {\n    \n    public void foo(int i) throws java.io.IOException {\n       int j = 0;\n\t\tclass C {\n\t\t\tprivate void bar() {}\n\t\t}\n    }\n}", "Y.java", "public class Y extends Zork {\n}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
    }

    public void test164() {
        String[] testFiles = new String[]{"X.java", "@SuppressWarnings({\"synthetic-access\", \"unused\"})\npublic class X {\n    private int i;\n\t private void bar() {}\n    public void foo() {\n       class C {\n\t\t\tprivate void bar() {\n\t\t\t\tSystem.out.println(i);\n\t\t\t\ti = 0;\n\t\t\t\tbar();\n\t\t\t}\n\t\t};\n\t\tnew C().bar();\n    }\n}"};
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "warning");
        if (this.isMinimumCompliant(0x370000L)) {
            this.runConformTest(testFiles);
            return;
        }
        this.runNegativeTest(testFiles, "", null, true, options);
    }

    public void test165() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        this.runConformTest(true, new String[]{"X.java", "/**\n * @see Y\n */\n@SuppressWarnings(\"deprecation\")\npublic class X extends Y {\n\t /**\n\t  * @see Y#foo()\n\t  * @see Y#j\n\t  */\n    public void foo() {\n\t\tsuper.foo();\n    }\n}", "Y.java", "/**\n * @deprecated\n */\npublic class Y {\n\t/**\n\t * @deprecated\n\t */\n\tpublic void foo() {}\n\t/**\n\t * @deprecated\n\t */\n\tpublic int j;\n}"}, null, options, "", null, null, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test166() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Inherited;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Inherited()\n@interface ParameterAnnotation {\n\tString value() default \"Default\";\n}\n@interface ClassAnnotation {\n\tString value() default \"Default\";\n}\n\nenum EnumClass{\n\tValue1, Value2, Value3\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@Inherited()\n@interface ValueAnnotation {\n\tString value() default \"Default\";\n\tboolean booleanValue() default true;\n\tchar charValue() default 'q';\n\tbyte byteValue() default 123;\n\tshort shortValue() default 12345;\n\tint intValue() default 1234567890;\n\tfloat floatValue() default 12345.6789f;\n\tdouble doubleValue() default 12345.6789;\n\tlong longValue() default 1234567890123456789l;\n\tString stringValue() default \"stringValue\";\n\tEnumClass enumValue() default EnumClass.Value1;\n\tClass classValue() default EnumClass.class;\n\tClassAnnotation annotationValue() default @ClassAnnotation();\n\tboolean[] booleanArrayValue() default {true, false};\n\tchar[] charArrayValue() default {'q', 'm'};\n\tbyte[] byteArrayValue() default {123, -123};\n\tshort[] shortArrayValue() default {12345, -12345};\n\tint[] intArrayValue() default {1234567890, -1234567890};\n\tfloat[] floatArrayValue() default {12345.6789f, -12345.6789f};\n\tdouble[] doubleArrayValue() default {12345.6789, -12345.6789};\n\tlong[] longArrayValue() default {1234567890123456789l, -1234567890123456789l};\n\tString[] stringArrayValue() default {\"stringValue\", \"valueString\"};\n\tEnumClass[] enumArrayValue() default {EnumClass.Value1, EnumClass.Value2};\n\tClass[] classArrayValue() default {X.class, EnumClass.class};\n\tClassAnnotation[] annotationArrayValue() default {@ClassAnnotation(), @ClassAnnotation()};\n}\n\npublic class X {\n\t@ValueAnnotation(\n\t\tvalue=\"ValueAnnotation\",\n\t\tbooleanValue=true,\n\t\tcharValue='m',\n\t\tbyteValue=-123,\n\t\tshortValue=-12345,\n\t\tintValue=-1234567890,\n\t\tfloatValue=-12345.6789f,\n\t\tdoubleValue=-12345.6789,\n\t\tlongValue=-1234567890123456789l,\n\t\tstringValue=\"valueString\",\n\t\tenumValue=EnumClass.Value3,\n\t\tclassValue=X.class,\n\t\tannotationValue=@ClassAnnotation(value=\"ClassAnnotation\"),\n\t\tbooleanArrayValue={\n\t\t\tfalse,\n\t\t\ttrue\n\t\t},\n\t\tcharArrayValue={\n\t\t\t'm',\n\t\t\t'q'\n\t\t},\n\t\tbyteArrayValue={\n\t\t\t-123,\n\t\t\t123\n\t\t},\n\t\tshortArrayValue={\n\t\t\t-12345,\n\t\t\t12345\n\t\t},\n\t\tintArrayValue={\n\t\t\t-1234567890,\n\t\t\t1234567890\n\t\t},\n\t\tfloatArrayValue={\n\t\t\t-12345.6789f,\n\t\t\t12345.6789f\n\t\t},\n\t\tdoubleArrayValue={\n\t\t\t-12345.6789,\n\t\t\t12345.6789\n\t\t},\n\t\tlongArrayValue={\n\t\t\t-1234567890123456789l,\n\t\t\t1234567890123456789l\n\t\t},\n\t\tstringArrayValue={\n\t\t\t\"valueString\",\n\t\t\t\"stringValue\"\n\t\t},\n\t\tenumArrayValue={\n\t\t\tEnumClass.Value2,\n\t\t\tEnumClass.Value1\n\t\t},\n\t\tclassArrayValue={\n\t\t\tEnumClass.class,\n\t\t\tX.class\n\t\t},\n\t\tannotationArrayValue={\n\t\t\t@ClassAnnotation(value=\"ClassAnnotation1\"),\n\t\t\t@ClassAnnotation(value=\"ClassAnnotation2\")\n\t\t})\n\tpublic String field;\n\t@ValueAnnotation(\n\t\tvalue=\"ValueAnnotation\",\n\t\tbooleanValue=true,\n\t\tcharValue='m',\n\t\tbyteValue=-123,\n\t\tshortValue=-12345,\n\t\tintValue=-1234567890,\n\t\tfloatValue=-12345.6789f,\n\t\tdoubleValue=-12345.6789,\n\t\tlongValue=-1234567890123456789l,\n\t\tstringValue=\"valueString\",\n\t\tenumValue=EnumClass.Value3,\n\t\tclassValue=X.class,\n\t\tannotationValue=@ClassAnnotation(value=\"ClassAnnotation\"),\n\t\tbooleanArrayValue={\n\t\t\tfalse,\n\t\t\ttrue\n\t\t},\n\t\tcharArrayValue={\n\t\t\t'm',\n\t\t\t'q'\n\t\t},\n\t\tbyteArrayValue={\n\t\t\t-123,\n\t\t\t123\n\t\t},\n\t\tshortArrayValue={\n\t\t\t-12345,\n\t\t\t12345\n\t\t},\n\t\tintArrayValue={\n\t\t\t-1234567890,\n\t\t\t1234567890\n\t\t},\n\t\tfloatArrayValue={\n\t\t\t-12345.6789f,\n\t\t\t12345.6789f\n\t\t},\n\t\tdoubleArrayValue={\n\t\t\t-12345.6789,\n\t\t\t12345.6789\n\t\t},\n\t\tlongArrayValue={\n\t\t\t-1234567890123456789l,\n\t\t\t1234567890123456789l\n\t\t},\n\t\tstringArrayValue={\n\t\t\t\"valueString\",\n\t\t\t\"stringValue\"\n\t\t},\n\t\tenumArrayValue={\n\t\t\tEnumClass.Value2,\n\t\t\tEnumClass.Value1\n\t\t},\n\t\tclassArrayValue={\n\t\t\tEnumClass.class,\n\t\t\tX.class\n\t\t},\n\t\tannotationArrayValue={\n\t\t\t@ClassAnnotation(value=\"ClassAnnotation1\"),\n\t\t\t@ClassAnnotation(value=\"ClassAnnotation2\")\n\t\t})\n\tpublic X(@ParameterAnnotation(value=\"ParameterAnnotation\") @Deprecated() String param1, @ParameterAnnotation(value=\"ParameterAnnotation\") String param2) {\n\t}\n\t@ValueAnnotation(\n\t\tvalue=\"ValueAnnotation\",\n\t\tbooleanValue=true,\n\t\tcharValue='m',\n\t\tbyteValue=-123,\n\t\tshortValue=-12345,\n\t\tintValue=-1234567890,\n\t\tfloatValue=-12345.6789f,\n\t\tdoubleValue=-12345.6789,\n\t\tlongValue=-1234567890123456789l,\n\t\tstringValue=\"valueString\",\n\t\tenumValue=EnumClass.Value3,\n\t\tclassValue=X.class,\n\t\tannotationValue=@ClassAnnotation(value=\"ClassAnnotation\"),\n\t\tbooleanArrayValue={\n\t\t\tfalse,\n\t\t\ttrue\n\t\t},\n\t\tcharArrayValue={\n\t\t\t'm',\n\t\t\t'q'\n\t\t},\n\t\tbyteArrayValue={\n\t\t\t-123,\n\t\t\t123\n\t\t},\n\t\tshortArrayValue={\n\t\t\t-12345,\n\t\t\t12345\n\t\t},\n\t\tintArrayValue={\n\t\t\t-1234567890,\n\t\t\t1234567890\n\t\t},\n\t\tfloatArrayValue={\n\t\t\t-12345.6789f,\n\t\t\t12345.6789f\n\t\t},\n\t\tdoubleArrayValue={\n\t\t\t-12345.6789,\n\t\t\t12345.6789\n\t\t},\n\t\tlongArrayValue={\n\t\t\t-1234567890123456789l,\n\t\t\t1234567890123456789l\n\t\t},\n\t\tstringArrayValue={\n\t\t\t\"valueString\",\n\t\t\t\"stringValue\"\n\t\t},\n\t\tenumArrayValue={\n\t\t\tEnumClass.Value2,\n\t\t\tEnumClass.Value1\n\t\t},\n\t\tclassArrayValue={\n\t\t\tEnumClass.class,\n\t\t\tX.class\n\t\t},\n\t\tannotationArrayValue={\n\t\t\t@ClassAnnotation(value=\"ClassAnnotation1\"),\n\t\t\t@ClassAnnotation(value=\"ClassAnnotation2\")\n\t\t})\n\tpublic void method(@ParameterAnnotation(value=\"ParameterAnnotation\") @Deprecated() String param1, @ParameterAnnotation(value=\"ParameterAnnotation\") String param2){\n\t}\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        new ClassFileReader(classFileBytes, "X.java".toCharArray(), true);
        disassembler.disassemble(classFileBytes, "\n", 1);
    }

    public void test167() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic foo(@Deprecated() String s) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic foo(@Deprecated() String s) {\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test168() {
        String expectedOutput = "----------\n1. ERROR in X.java (at line 2)\n\t@Override I clone();\n\t            ^^^^^^^\nThe method clone() of type I must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t@Override I clone();\n\tvoid foo();\n}\n\ninterface J extends I {\n\t@Override void foo();\n}\n"}, expectedOutput);
    }

    public void test169() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(true, new String[]{"X.java", "@SuppressWarnings(\"serial\")\npublic class X extends Exception {\n\tString s = \"Hello\"; \n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 3)\n\tString s = \"Hello\"; \n\t           ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test170() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(new String[]{"X.java", "public class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n}"}, "", null, true, null, customOptions, null);
    }

    public void test171() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(true, new String[]{"X.java", "public class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X extends Exception {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 4)\n\t@SuppressWarnings(\"serial\")\n\t                  ^^^^^^^^\nUnnecessary @SuppressWarnings(\"serial\")\n----------\n3. WARNING in X.java (at line 5)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test172() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(true, new String[]{"X.java", "@SuppressWarnings(\"serial\")\npublic class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 5)\n\t@SuppressWarnings(\"serial\")\n\t                  ^^^^^^^^\nUnnecessary @SuppressWarnings(\"serial\")\n----------\n2. WARNING in X.java (at line 6)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test173() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        this.runConformTest(true, new String[]{"X.java", "@interface Annot {\n    String value() default \"NONE\";\n}\n@Annot(\"serial\")\npublic class X extends Exception {\n   @SuppressWarnings(\"nls\")\n\tString s = \"Hello\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 5)\n\tpublic class X extends Exception {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 8)\n\t@SuppressWarnings(\"serial\")\n\t                  ^^^^^^^^\nUnnecessary @SuppressWarnings(\"serial\")\n----------\n3. WARNING in X.java (at line 9)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test174() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        String source = "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\")\n\tString s = null; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}";
        this.runConformTest(true, new String[]{"X.java", "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\")\n\tString s = null; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 11)\n\t@SuppressWarnings(\"serial\")\n\t                  ^^^^^^^^\nUnnecessary @SuppressWarnings(\"serial\")\n----------\n2. WARNING in X.java (at line 12)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test175() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        String source = "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\") String s = \"value\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}";
        this.runConformTest(true, new String[]{"X.java", "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\") String s = \"value\"; \n   @SuppressWarnings(\"serial\")\n\tString s2 = \"Hello2\"; \n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 9)\n\t@Annot2(value=\"nls\") String s = \"value\"; \n\t                                ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. WARNING in X.java (at line 10)\n\t@SuppressWarnings(\"serial\")\n\t                  ^^^^^^^^\nUnnecessary @SuppressWarnings(\"serial\")\n----------\n3. WARNING in X.java (at line 11)\n\tString s2 = \"Hello2\"; \n\t            ^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test176() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        String source = "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\") String s = \"value\"; \n   @SuppressWarnings({\"serial\", \"nls\"})\n\tString s2 = \"Hello2\"; \n\t@Annot(value=5) void foo() {}\n}";
        this.runConformTest(true, new String[]{"X.java", "@interface Annot {\n    int value() default 0;\n}\n@interface Annot2 {\n    String value();\n}\n@Annot(value=5)\npublic class X {\n   @Annot2(value=\"nls\") String s = \"value\"; \n   @SuppressWarnings({\"serial\", \"nls\"})\n\tString s2 = \"Hello2\"; \n\t@Annot(value=5) void foo() {}\n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 9)\n\t@Annot2(value=\"nls\") String s = \"value\"; \n\t                                ^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. WARNING in X.java (at line 10)\n\t@SuppressWarnings({\"serial\", \"nls\"})\n\t                   ^^^^^^^^\nUnnecessary @SuppressWarnings(\"serial\")\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test177() {
        this.runConformTest(new String[]{"X.java", "public @interface X {\n  public static final Integer foo = B.zzz; \n  public static final int foo3 = B.zzz2; \n}\nclass B {\n  public static final Integer zzz = new Integer(0);\n  public static final int zzz2 = 0;\n}\n"}, "");
    }

    public void test178() {
        this.runConformTest(true, new String[]{"X.java", "import java.util.*;\npublic class X {\n\tprivate void testme(boolean check) {\n\t\tArrayList<Integer> aList = new ArrayList<Integer>();\n\t\tfor (@SuppressWarnings(\"unusedLocal\")\n\t\tInteger i : aList) {\n\t\t\tSystem.out.println(\"checking\");\n\t\t}\n\t}\n}\n"}, null, "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test179() {
        this.runConformTest(true, new String[]{"X.java", "import static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\n@Target({TYPE, FIELD, METHOD,\n         PARAMETER, CONSTRUCTOR,\n         LOCAL_VARIABLE, PACKAGE,})\n@Retention(CLASS)\npublic @interface X {}"}, "", "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6337964);
    }

    public void test180() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Field;\n\npublic class X {\n  @Deprecated public static Object x, y, z;\n\n  public static void main(String[] args) {\n    Class c = X.class;\n    int counter = 0;\n    for (Field f : c.getFields()) {\n      counter += f.getDeclaredAnnotations().length;\n    }\n    System.out.print(counter);\n  }\n}"}, "3");
    }

    public void test181() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Field;\n\npublic class X {\n  public static Object x, y, z;\n\n  public static void main(String[] args) {\n    Class c = X.class;\n    int counter = 0;\n    for (Field f : c.getFields()) {\n      counter += f.getDeclaredAnnotations().length;\n    }\n    System.out.print(counter);\n  }\n}"}, "0");
    }

    public void test182() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Y y) {\n\t\ty.initialize(null, null, null);\n\t}\n}\n\n\n", "Y.java", "public class Y {\n\n\t/**\n\t * @deprecated\n\t */\n\tpublic void initialize(Zork z, String s) {\n\t}\n\n\tpublic void initialize(Zork z, String s, Thread t) {\n\t}\n}\n\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ty.initialize(null, null, null);\n\t  ^^^^^^^^^^\nThe method initialize(Zork, String, Thread) from the type Y refers to the missing type Zork\n----------\n----------\n1. WARNING in Y.java (at line 6)\n\tpublic void initialize(Zork z, String s) {\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe deprecated method initialize(Zork, String) of type Y should be annotated with @Deprecated\n----------\n2. ERROR in Y.java (at line 6)\n\tpublic void initialize(Zork z, String s) {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in Y.java (at line 6)\n\tpublic void initialize(Zork z, String s) {\n\t                            ^\nJavadoc: Missing tag for parameter z\n----------\n4. ERROR in Y.java (at line 6)\n\tpublic void initialize(Zork z, String s) {\n\t                                      ^\nJavadoc: Missing tag for parameter s\n----------\n5. ERROR in Y.java (at line 9)\n\tpublic void initialize(Zork z, String s, Thread t) {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test183() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Y y) {\n\t\tint i = y.initialize;\n\t}\n}\n\n", "Y.java", "public class Y {\n\n\t/**\n\t * @deprecated\n\t */\n\tpublic Zork initialize;\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = y.initialize;\n\t        ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 3)\n\tint i = y.initialize;\n\t          ^^^^^^^^^^\nThe field Y.initialize is deprecated\n----------\n----------\n1. ERROR in Y.java (at line 6)\n\tpublic Zork initialize;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in Y.java (at line 6)\n\tpublic Zork initialize;\n\t            ^^^^^^^^^^\nThe deprecated field Y.initialize should be annotated with @Deprecated\n----------\n");
    }

    public void test184() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tY.initialize i;\n\t}\n}\n\n\n", "Y.java", "public class Y {\n\n\t/**\n\t * @deprecated\n\t */\n\tpublic class initialize extends Zork {\n\t}\n}\n\n\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tY.initialize i;\n\t  ^^^^^^^^^^\nThe type Y.initialize is deprecated\n----------\n----------\n1. WARNING in Y.java (at line 6)\n\tpublic class initialize extends Zork {\n\t             ^^^^^^^^^^\nThe deprecated type Y.initialize should be annotated with @Deprecated\n----------\n2. ERROR in Y.java (at line 6)\n\tpublic class initialize extends Zork {\n\t                                ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test185() {
        this.runNegativeTest(new String[]{"X.java", "import p.A;\n@SuppressWarnings(\"all\")\npublic class X {\n\tvoid foo(A a) {\n\t\tZork z;\n\t}\n}\n\nclass Y {\n\tA a;\n}\n", "p/A.java", "package p;\n@Deprecated\npublic class A {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 10)\n\tA a;\n\t^\nThe type A is deprecated\n----------\n");
    }

    public void test186() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n\t@Deprecated\n\tclass Y implements p2.I {\n\t\tZork z;\n\t}\n}\n", "p2/I.java", "package p2;\n@Deprecated\npublic interface I {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test187() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nimport p2.I;\n@Deprecated\npublic class X {\n\tZork z;\n}\n", "p2/I.java", "package p2;\n@Deprecated\npublic interface I {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test188() {
        this.runNegativeTest(new String[]{"X.java", "@interface A1 {\n\tint[] values();\n}\n@A1(values = new int[] { 1, 2 })\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t@A1(values = new int[] { 1, 2 })\n\t             ^^^^^^^^^^^^^^^^^^\nThe value for annotation attribute A1.values must be an array initializer\n----------\n");
    }

    public void test189() {
        this.runConformTest(true, new String[]{"A1.java", "@A2(@A1(m1 = \"u\"))\npublic @interface A1 {\n  String m1();\n  String m2() default \"v\";\n}\n", "A2.java", "@A2(@A1(m1 = \"u\", m2 = \"w\"))\npublic @interface A2 {\n  A1[] value();\n}\n"}, "", "", null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
        this.runConformTest(false, new String[]{"A1.java", "@A2(@A1(m1 = \"u\"))\npublic @interface A1 {\n  String m1();\n  String m3() default \"v\";\n}\n"}, null, "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test190() {
        this.runConformTest(new String[]{"A.java", "public @interface A {\n  int value();\n}\n"}, "");
        String binName1 = OUTPUT_DIR + File.separator + "bin1";
        File bin1 = new File(binName1);
        bin1.mkdir();
        String[] javaClassLibs = org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs();
        int javaClassLibsLength = javaClassLibs.length;
        String[] xClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, xClassLibs, 0, javaClassLibsLength);
        xClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        xClassLibs[javaClassLibsLength + 1] = binName1;
        new File(OUTPUT_DIR + File.separator + "A.class").renameTo(new File(binName1 + File.separator + "A.class"));
        this.runConformTest(new String[]{"X.java", "public class X {\n    @A(0)\n    void foo() {\n        System.out.println(\"SUCCESS\");\n    }\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", xClassLibs, false, null);
        String binName2 = OUTPUT_DIR + File.separator + "bin2";
        File bin2 = new File(binName2);
        bin2.mkdir();
        new File(OUTPUT_DIR + File.separator + "X.class").renameTo(new File(binName2 + File.separator + "X.class"));
        String[] yClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, yClassLibs, 0, javaClassLibsLength);
        yClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        yClassLibs[javaClassLibsLength + 1] = binName2;
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", yClassLibs, false, null);
    }

    public void test191() {
        this.runConformTest(new String[]{"A.java", "@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\npublic @interface A {\n  int value();\n}\n"}, "");
        String binName1 = OUTPUT_DIR + File.separator + "bin1";
        File bin1 = new File(binName1);
        bin1.mkdir();
        String[] javaClassLibs = org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs();
        int javaClassLibsLength = javaClassLibs.length;
        String[] xClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, xClassLibs, 0, javaClassLibsLength);
        xClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        xClassLibs[javaClassLibsLength + 1] = binName1;
        new File(OUTPUT_DIR + File.separator + "A.class").renameTo(new File(binName1 + File.separator + "A.class"));
        this.runConformTest(new String[]{"X.java", "public class X {\n    @A(0)\n    void foo() {\n        System.out.println(\"SUCCESS\");\n    }\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", xClassLibs, false, null);
        String binName2 = OUTPUT_DIR + File.separator + "bin2";
        File bin2 = new File(binName2);
        bin2.mkdir();
        new File(OUTPUT_DIR + File.separator + "X.class").renameTo(new File(binName2 + File.separator + "X.class"));
        String[] yClassLibs = new String[javaClassLibsLength + 2];
        System.arraycopy(javaClassLibs, 0, yClassLibs, 0, javaClassLibsLength);
        yClassLibs[javaClassLibsLength] = OUTPUT_DIR;
        yClassLibs[javaClassLibsLength + 1] = binName2;
        this.runConformTest(new String[]{"Y.java", "public class Y {\n    public static void main(String args[]) {\n        new X().foo();\n    }\n}"}, "SUCCESS", yClassLibs, false, null);
    }

    public void test192() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@ATest(groups={\"a\",\"b\"})\n\tvoid foo(){\n\t}\n\t@ATest(groups=\"c\")\n\tvoid bar(){\n\t}\n}\n@interface ATest {\n\tString[] groups();\n}\n"}, "");
    }

    public void test193() {
        this.runNegativeTest(new String[]{"A.java", "public @interface A {\n\tA circular1();\n}\n@interface B {\n\tA circular2();\n}"}, "----------\n1. ERROR in A.java (at line 2)\n\tA circular1();\n\t^\nCycle detected: the annotation type A cannot contain attributes of the annotation type itself\n----------\n");
        this.runNegativeTest(new String[]{"A.java", "public @interface A {\n\tB circular2();\n\tA circular1();\n}\n@interface B {\n\tA circular();\n}"}, "----------\n1. ERROR in A.java (at line 2)\n\tB circular2();\n\t^\nCycle detected: a cycle exists between annotation attributes of A and B\n----------\n2. ERROR in A.java (at line 3)\n\tA circular1();\n\t^\nCycle detected: the annotation type A cannot contain attributes of the annotation type itself\n----------\n3. ERROR in A.java (at line 6)\n\tA circular();\n\t^\nCycle detected: a cycle exists between annotation attributes of B and A\n----------\n");
        this.runNegativeTest(new String[]{"A.java", "public @interface A {\n\tA circular1();\n\tB circular2();\n}\n@interface B {\n\tA circular();\n}"}, "----------\n1. ERROR in A.java (at line 2)\n\tA circular1();\n\t^\nCycle detected: the annotation type A cannot contain attributes of the annotation type itself\n----------\n2. ERROR in A.java (at line 3)\n\tB circular2();\n\t^\nCycle detected: a cycle exists between annotation attributes of A and B\n----------\n3. ERROR in A.java (at line 6)\n\tA circular();\n\t^\nCycle detected: a cycle exists between annotation attributes of B and A\n----------\n");
    }

    public void test194() {
        String expectedOutput = "----------\n1. ERROR in X.java (at line 5)\n\t@Override\n\t^^^^^^^^^\nThe annotation @Override is disallowed for this location\n----------\n2. ERROR in X.java (at line 9)\n\tpublic static void foo() {}\n\t                   ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "class Base {\n    public static void foo() {}\n}\npublic class X extends Base {\n\t@Override\n\tX(){}\n\t\n    @Override\n    public static void foo() {}\n}\n"}, expectedOutput);
    }

    public void test195() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"cast\")\n\tvoid foo() {\n\t\tString s = (String) \"hello\";\n\t}\n\tvoid bar() {\n\t\tString s = (String) \"hello\";\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tString s = (String) \"hello\";\n\t           ^^^^^^^^^^^^^^^^\nUnnecessary cast from String to String\n----------\n2. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test196() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n    enum MyEnum {\n        VAL_1, VAL_2\n    }\n    public MyEnum theValue() default null;\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic MyEnum theValue() default null;\n\t                                 ^^^^\nThe value for annotation attribute X.theValue must be an enum constant expression\n----------\n");
    }

    public void test197() {
        String expectedOutput = "----------\n1. WARNING in p\\X.java (at line 4)\n\tvoid foo() {\n\t     ^^^^^\nThe method X.foo() does not override the inherited method from OldStuff since it is private to a different package\n----------\n2. ERROR in p\\X.java (at line 4)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() of type X must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X extends q.OldStuff {\n\t@Override\n\tvoid foo() {\n\t}\n}\n", "q/OldStuff.java", "package q;\npublic class OldStuff {\n\tvoid foo() {\n\t}\t\n}\n"}, expectedOutput);
    }

    public void test198() {
        this.runNegativeTest(new String[]{"X.java", "@interface Anno {\n        boolean b() default false;\n        String[] c() default \"\";\n}\n@Anno(b = {})\npublic class X {\n\t@Anno(c = { 0 })\n\tvoid foo(){}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@Anno(b = {})\n\t          ^^\nType mismatch: cannot convert from Object[] to boolean\n----------\n2. ERROR in X.java (at line 7)\n\t@Anno(c = { 0 })\n\t            ^\nType mismatch: cannot convert from int to String\n----------\n");
    }

    public void test199() {
        this.runConformTest(true, new String[]{"X.java", "@interface AttributeOverrides {\n\tAttributeOverride[] value();\n}\n@interface AttributeOverride {\n\tString name();\n\tColumn column();\n}\n@interface Column {\n\tString name();\n}\n@AttributeOverrides({\n    @AttributeOverride( name=\"city\", column=@Column( name=\"DIAB99C_TXCTY\" )),\n    @AttributeOverride( name=\"state\", column=@Column( name=\"DIAB99C_TXSTAT\" )),\n    @AttributeOverride( name=\"zipCode\", column=@Column( name=\"DIAB99C_TXZIP\")),\n}) public class X {}"}, "", "", null, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6337964);
    }

    public void test200() {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n  int clone();\n  String finalize();\n  boolean getClass();\n  long notify();\n  double notifyAll();\n  float wait();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tint clone();\n\t    ^^^^^^^\nThe annotation type X cannot override the method Object.clone()\n----------\n2. ERROR in X.java (at line 3)\n\tString finalize();\n\t       ^^^^^^^^^^\nThe annotation type X cannot override the method Object.finalize()\n----------\n3. ERROR in X.java (at line 4)\n\tboolean getClass();\n\t        ^^^^^^^^^^\nThe annotation type X cannot override the method Object.getClass()\n----------\n4. ERROR in X.java (at line 5)\n\tlong notify();\n\t     ^^^^^^^^\nThe annotation type X cannot override the method Object.notify()\n----------\n5. ERROR in X.java (at line 6)\n\tdouble notifyAll();\n\t       ^^^^^^^^^^^\nThe annotation type X cannot override the method Object.notifyAll()\n----------\n6. ERROR in X.java (at line 7)\n\tfloat wait();\n\t      ^^^^^^\nThe annotation type X cannot override the method Object.wait()\n----------\n");
    }

    public void test201() {
        this.runNegativeTest(new String[]{"X.java", "@interface X {\n  char hashCode();\n  int annotationType();\n  Class toString();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tchar hashCode();\n\t     ^^^^^^^^^^\nThe annotation type X cannot override the method Annotation.hashCode()\n----------\n2. ERROR in X.java (at line 3)\n\tint annotationType();\n\t    ^^^^^^^^^^^^^^^^\nThe annotation type X cannot override the method Annotation.annotationType()\n----------\n3. WARNING in X.java (at line 4)\n\tClass toString();\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 4)\n\tClass toString();\n\t      ^^^^^^^^^^\nThe annotation type X cannot override the method Annotation.toString()\n----------\n");
    }

    public void test202() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n @Ann(m=Object)\n private int foo;\n private NonExisting bar;\n }\n @interface Ann {\n String m();\n }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=Object)\n\t       ^^^^^^\nObject cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar;\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test203() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=Object())\n\tprivate void foo(){}\n\tprivate NonExisting bar(){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=Object())\n\t       ^^^^^^\nThe method Object() is undefined for the type X\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test204() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=bar(null))\n\tprivate void foo(){}\n\tprivate NonExisting bar(NonExisting ne){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=bar(null))\n\t       ^^^\nThe method bar(NonExisting) from the type X refers to the missing type NonExisting\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t                        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test205() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=foo())\n\tprivate void foo(){}\n\tprivate NonExisting bar(NonExisting ne){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=foo())\n\t       ^^^^^\nType mismatch: cannot convert from void to String\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(NonExisting ne){}\n\t                        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test206() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Ann(m=bar())\n\tprivate void foo(){}\n\tprivate NonExisting bar(){}\n}\n@interface Ann {\n    String m();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=bar())\n\t       ^^^\nThe method bar() from the type X refers to the missing type NonExisting\n----------\n2. ERROR in X.java (at line 4)\n\tprivate NonExisting bar(){}\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test207() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n@Ann(m=foo)\n private NonExisting foo;\n private NonExisting bar;\n }\n @interface Ann {\n String m();\n }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Ann(m=foo)\n\t       ^^^\nCannot reference a field before it is defined\n----------\n2. ERROR in X.java (at line 2)\n\t@Ann(m=foo)\n\t       ^^^\nNonExisting cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\tprivate NonExisting foo;\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 4)\n\tprivate NonExisting bar;\n\t        ^^^^^^^^^^^\nNonExisting cannot be resolved to a type\n----------\n");
    }

    public void test208() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(X.FOO) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(X.FOO) class MyClass {\n\t              ^^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test209() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(value=X.FOO) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(value=X.FOO) class MyClass {\n\t                    ^^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test210() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum[] value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(value= { X.FOO }) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(value= { X.FOO }) class MyClass {\n\t                       ^^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test211() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum[] value();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\n@MyAnnotation(value= { null }) class MyClass {\n}\npublic class X {\n    public static final MyEnum FOO = MyEnum.TWO;\n    public static void main(String[] args) {\n        MyAnnotation annotation =\n                MyClass.class.getAnnotation(MyAnnotation.class);\n        System.out.println(annotation.value().toString());\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(value= { null }) class MyClass {\n\t                       ^^^^\nThe value for annotation attribute MyAnnotation.value must be an enum constant expression\n----------\n");
    }

    public void test212() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public MyEnum[] values();\n}\nenum MyEnum {\n    ONE, TWO, THREE\n}\npublic class X {\n\n\t\tprivate static final MyEnum[] myValues = { MyEnum.ONE, MyEnum.TWO };\n       @MyAnnotation(values=myValues) \n       public void dothetrick(){} \n\n        public static void main(String[] args)throws Exception {\n                MyAnnotation sluck = X.class.getMethod(\"dothetrick\", new Class[0]).getAnnotation(MyAnnotation.class);\n                System.out.println(sluck.values().length);\n        }\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\t@MyAnnotation(values=myValues) \n\t                     ^^^^^^^^\nThe value for annotation attribute MyAnnotation.values must be an array initializer\n----------\n");
    }

    public void test213() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n@Retention(RUNTIME) @interface MyAnnotation {\n    public int[] values();\n}\npublic class X {\n\n\t\tprivate static final int[] myValues = { 1, 2, 3 };\n       @MyAnnotation(values=myValues) \n       public void dothetrick(){} \n\n        public static void main(String[] args)throws Exception {\n                MyAnnotation sluck = X.class.getMethod(\"dothetrick\", new Class[0]).getAnnotation(MyAnnotation.class);\n                System.out.println(sluck.values().length);\n        }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t@MyAnnotation(values=myValues) \n\t                     ^^^^^^^^\nThe value for annotation attribute MyAnnotation.values must be an array initializer\n----------\n");
    }

    public void test214() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        String expectedOutput = "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo();\n\t     ^^^^^\nThe method foo() of type I must override or implement a supertype method\n----------\n";
        this.runNegativeTest(true, new String[]{"X.java", "interface I {\n  @Override\n  void foo();\n  void bar();\n}\npublic class X implements I {\n  @Override\n  public void foo() {}\n  public void bar() {}\n}\ninterface J extends I {\n\t@Override\n\tvoid foo();\n}\n"}, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test215() {
        String[] sources = new String[]{"I.java", "public interface I {\n  void foo();\n}\n", "X.java", "abstract class X implements I {\n}\n", "Y.java", "class Y extends X {\n  @Override\n  public void foo() {}\n}\n"};
        this.runConformTest(sources, "");
    }

    public void test216() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\npublic class X {\n  void bar(MyConstructor constructor, Class<Ann> ann) {\n    constructor.getAnnotation(ann).message();\n  }\n}\n@interface Ann {\n  String message();\n}\nclass MyConstructor<V> {\n  public <T extends Annotation> T getAnnotation(Class<T> c) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid bar(MyConstructor constructor, Class<Ann> ann) {\n\t         ^^^^^^^^^^^^^\nMyConstructor is a raw type. References to generic type MyConstructor<V> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type MyConstructor. References to generic type MyConstructor<V> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t                               ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n");
    }

    public void test217() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        String expectedOutput = "----------\n1. WARNING in X.java (at line 3)\n\tvoid bar(MyConstructor constructor, Class<Ann> ann) {\n\t         ^^^^^^^^^^^^^\nMyConstructor is a raw type. References to generic type MyConstructor<V> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type MyConstructor. References to generic type MyConstructor<V> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tconstructor.getAnnotation(ann).message();\n\t                               ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n";
        this.runNegativeTest(true, new String[]{"X.java", "import java.lang.annotation.Annotation;\npublic class X {\n  void bar(MyConstructor constructor, Class<Ann> ann) {\n    constructor.getAnnotation(ann).message();\n  }\n}\n@interface Ann {\n  String message();\n}\ninterface Z {\n  <T extends Annotation> T getAnnotation(Class<T> c);\n}\nclass MyAccessibleObject implements Z {\n  public <T extends Annotation> T getAnnotation(Class<T> c) { return null; }\n}\nclass MyConstructor<V> {\n  public <T extends Annotation> T getAnnotation(Class<T> c) { return null; }\n}\n"}, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test218() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.reflect.Constructor;\npublic class X {\n  void bar(Constructor constructor, Class<Ann> ann) {\n    constructor.getAnnotation(ann).message();\n  }\n}\n@interface Ann {\n  String message();\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid bar(Constructor constructor, Class<Ann> ann) {\n\t         ^^^^^^^^^^^\nConstructor is a raw type. References to generic type Constructor<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tconstructor.getAnnotation(ann).message();\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getAnnotation(Class) belongs to the raw type Constructor. References to generic type Constructor<T> should be parameterized\n----------\n3. ERROR in X.java (at line 5)\n\tconstructor.getAnnotation(ann).message();\n\t                               ^^^^^^^\nThe method message() is undefined for the type Annotation\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6400189);
    }

    public void test219() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1(MyA2.XX)\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1 value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1(MyA2.XX)\n\t      ^^^^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test220() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1({MyA2.XX})\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1[] value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1({MyA2.XX})\n\t       ^^^^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test221() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1(null)\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1 value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1(null)\n\t      ^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test222() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        @MyB1({null})\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1[] value();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@MyB1({null})\n\t       ^^^^\nThe value for annotation attribute MyB1.value must be some @MyA1 annotation \n----------\n");
    }

    public void test223() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        @MyB1(@MyA1())\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1 value();\n}"}, "");
    }

    public void test224() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        @MyB1({@MyA1(), @MyA1})\n        public void foo(){}\n}", "MyA1.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA1 {\n}", "MyA2.java", "import static java.lang.annotation.ElementType.TYPE;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE\n})\npublic @interface MyA2 {\n        public static final MyA1 XX = null;\n}", "MyB1.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Target;\n\n@Target( {\n\tTYPE, METHOD\n})\npublic @interface MyB1 {\n        MyA1[] value();\n}"}, "");
    }

    public void test225() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public void myMethod() {\n    @MyAnnot1()\n  }\n}\n@interface MyAnnot1 {\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t@MyAnnot1()\n\t          ^\nSyntax error, insert \"enum Identifier\" to complete EnumHeader\n----------\n2. ERROR in X.java (at line 3)\n\t@MyAnnot1()\n\t          ^\nSyntax error, insert \"EnumBody\" to complete BlockStatements\n----------\n", null, true, null, false, false, false, false, true);
    }

    public void test226() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public @interface Annot {\n        float[] value();\n        Class<X>[] classe();\n    }\n    @Annot(value={x}, classe={Zork.class,zork})\n    class Inner {\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@Annot(value={x}, classe={Zork.class,zork})\n\t              ^\nx cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 6)\n\t@Annot(value={x}, classe={Zork.class,zork})\n\t                          ^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\t@Annot(value={x}, classe={Zork.class,zork})\n\t                          ^^^^^^^^^^\nClass<Zork> cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\t@Annot(value={x}, classe={Zork.class,zork})\n\t                                     ^^^^\nzork cannot be resolved to a variable\n----------\n5. ERROR in X.java (at line 6)\n\t@Annot(value={x}, classe={Zork.class,zork})\n\t                                     ^^^^\nThe value for annotation attribute X.Annot.classe must be a class literal\n----------\n");
    }

    public void test227() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic @interface X<T> {}\n\t                    ^\nSyntax error, annotation declaration cannot have type parameters\n----------\n");
    }

    public void test228() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unchecked\") //unused\n\tvoid doNoEvil(){\n\t}\n}\n", "Y.java", "public class Y {\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\t@SuppressWarnings(\"unchecked\") //unused\n\t                  ^^^^^^^^^^^\nUnnecessary @SuppressWarnings(\"unchecked\")\n----------\n----------\n1. ERROR in Y.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test229() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings({\"unchecked\",\"all\"})\n\tvoid doNoEvil(){\n\t}\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test230() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.enableAllWarningsForIrritants(options, IrritantSet.UNUSED);
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t@SuppressWarnings({\"zork\", \"unused\" })\n\tvoid foo() {}\n}\n@SuppressWarnings({\"all\"})\nclass X2 {\n\t@SuppressWarnings({\"zork\", \"unused\" })\n\tvoid foo() {}\n}\n"}, null, options, "----------\n1. WARNING in X.java (at line 2)\n\t@SuppressWarnings({\"zork\", \"unused\" })\n\t                   ^^^^^^\nUnsupported @SuppressWarnings(\"zork\")\n----------\n2. ERROR in X.java (at line 2)\n\t@SuppressWarnings({\"zork\", \"unused\" })\n\t                           ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n3. ERROR in X.java (at line 7)\n\t@SuppressWarnings({\"zork\", \"unused\" })\n\t                           ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test231() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.enableAllWarningsForIrritants(options, IrritantSet.UNUSED);
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t@SuppressWarnings({\"zork\", \"unused\",\"all\"})\n\tvoid foo() {}\n}\n\n@SuppressWarnings({\"all\"})\nclass X2 {\n\t@SuppressWarnings(\"unused\")\n\tvoid foo() {}\n\tObject z;\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\t@SuppressWarnings({\"zork\", \"unused\",\"all\"})\n\t                           ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n2. ERROR in X.java (at line 8)\n\t@SuppressWarnings(\"unused\")\n\t                  ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test232() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    @SuppressWarnings({\"finally\",\"finally\"})\n    public int test(int p) {\n    \ttry {\n\t\treturn 1;\n\t} finally {\n\t\treturn 2;\n\t}\n    }\n}\nclass Y {}"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\t@SuppressWarnings({\"finally\",\"finally\"})\n\t                             ^^^^^^^^^\nUnnecessary @SuppressWarnings(\"finally\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test233() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings({\"finally\",\"finally\"})\n    public int test(int p) {\n    \ttry {\n\t\treturn Zork;\n\t} finally {\n\t\treturn 2;\n\t}\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\t@SuppressWarnings({\"finally\",\"finally\"})\n\t                             ^^^^^^^^^\nUnnecessary @SuppressWarnings(\"finally\")\n----------\n2. ERROR in X.java (at line 5)\n\treturn Zork;\n\t       ^^^^\nZork cannot be resolved to a variable\n----------\n");
    }

    public void test234() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings(\"finally\")\n    public int test(int p) {\n\t\treturn Zork;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn Zork;\n\t       ^^^^\nZork cannot be resolved to a variable\n----------\n");
    }

    public void test235() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n        void foo() {\n                ArrayList al = null;\n                @SuppressWarnings(\"unchecked\")\n                List<String> ls = al;\n        }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tArrayList al = null;\n\t^^^^^^^^^\nArrayList cannot be resolved to a type\n----------\n");
    }

    public void test236() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tvoid foo() {\n\t\t@SuppressWarnings(\"unchecked\")\n\t\tList<String> ls = bar();\n\t}\n\tArrayList bar() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<String> ls = bar();\n\t                  ^^^\nThe method bar() from the type X refers to the missing type ArrayList\n----------\n2. ERROR in X.java (at line 7)\n\tArrayList bar() {\n\t^^^^^^^^^\nArrayList cannot be resolved to a type\n----------\n");
    }

    public void test237() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X<B extends ArrayList> {\n\tB get() { return null; }\n\tvoid foo() {\n\t\t@SuppressWarnings(\"unchecked\")\n\t\tList<String> ls = get();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X<B extends ArrayList> {\n\t                         ^^^^^^^^^\nArrayList cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tList<String> ls = get();\n\t                  ^^^\nThe method get() from the type X<B> refers to the missing type ArrayList\n----------\n");
    }

    public void test238() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t@SuppressWarnings({\"zork\",\"all\"})\n\tvoid foo() {}\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\t@SuppressWarnings({\"zork\",\"all\"})\n\t                   ^^^^^^\nUnsupported @SuppressWarnings(\"zork\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test239() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X implements I {}\n@SuppressWarnings(\"unused\")\nclass Y extends X implements I {\n\tZork z;\n}\nclass Z extends X implements I {}\ninterface I {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 6)\n\tclass Z extends X implements I {}\n\t                             ^\nRedundant superinterface I for the type Z, already defined by X\n----------\n", null, false, options);
    }

    public void test240() {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated @Zork\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Deprecated @Zork\n\t             ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test241() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\t@SuppressWarnings(\"unchecked\")\n\tpublic static <T> T asClassUnchecked(Object object, T requiredClassObject) {\n\t\treturn (T) object;\n\t}\n\tpublic static void main(String... args) {\n\t\ttry {\n\t\t\tX[] xs = X.asClassUnchecked(\"abc\", (X[])null);\n\t\t\tSystem.out.println(xs.length);\n\t\t} catch(ClassCastException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS", null, false, null, options, null);
    }

    public void test242() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic final class X implements Serializable {\n    class SMember extends String {}  \n    @Annot(value = new SMember())\n     void bar() {}\n    @Annot(value = \n            new X(){\n                    ZorkAnonymous1 z;\n                    void foo() {\n                            this.bar();\n                            Zork2 z;\n                    }\n            })\n\tvoid foo() {}\n}\n@interface Annot {\n        String value();\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic final class X implements Serializable {\n\t                   ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 3)\n\tclass SMember extends String {}  \n\t                      ^^^^^^\nThe type SMember cannot subclass the final class String\n----------\n3. ERROR in X.java (at line 4)\n\t@Annot(value = new SMember())\n\t               ^^^^^^^^^^^^^\nType mismatch: cannot convert from X.SMember to String\n----------\n4. ERROR in X.java (at line 7)\n\tnew X(){\n\t    ^\nAn anonymous class cannot subclass the final class X\n----------\n5. ERROR in X.java (at line 8)\n\tZorkAnonymous1 z;\n\t^^^^^^^^^^^^^^\nZorkAnonymous1 cannot be resolved to a type\n----------\n");
    }

    public void test243() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings(\"unchecked\")\n\tvoid foo() {\n\t\t\n\t}\n}\t\n"}, "", null, false, null, options, null);
    }

    public void test244() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings(\"unchecked\")\n\tvoid foo() {\n\t\t\n\t}\n}\t\n"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\t@SuppressWarnings(\"unchecked\")\n\t                  ^^^^^^^^^^^\nUnnecessary @SuppressWarnings(\"unchecked\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test245() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        this.enableAllWarningsForIrritants(options, IrritantSet.UNUSED);
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\tvoid foo() {\n\t\t\n\t}\n}\t\n"}, null, options, "----------\n1. INFO in X.java (at line 3)\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\t                   ^^^^^^^^^^^\nAt least one of the problems in category 'unchecked' is not analysed due to a compiler option being ignored\n----------\n2. ERROR in X.java (at line 3)\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\t                               ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test245_ignored() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressWarningsNotFullyAnalysed", "ignore");
        this.enableAllWarningsForIrritants(options, IrritantSet.UNUSED);
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\tvoid foo() {\n\t\t\n\t}\n}\t\n"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\t                               ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test245_error() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressWarningsNotFullyAnalysed", "error");
        this.enableAllWarningsForIrritants(options, IrritantSet.UNUSED);
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\tvoid foo() {\n\t\t\n\t}\n}\t\n"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\t                   ^^^^^^^^^^^\nAt least one of the problems in category 'unchecked' is not analysed due to a compiler option being ignored\n----------\n2. ERROR in X.java (at line 3)\n\t@SuppressWarnings({\"unchecked\",\"unused\"})\n\t                               ^^^^^^^^\nUnnecessary @SuppressWarnings(\"unused\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test246() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings(\"all\")\n\tvoid foo() {\n\t\t\n\t}\n}\t\n"}, "", null, false, null, options, null);
    }

    public void test247() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(new String[]{"TestAnnotation.java", "public @interface TestAnnotation {\n\tClass targetItem() default void.class;\n}"}, "");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@TestAnnotation\n\tprivate String foo;\n}"}, "", null, false, null, options, null);
    }

    public void test248() {
        this.runNegativeTest(new String[]{"TestAnnotation.java", "public @interface TestAnnotation {\n\tString targetItem() default void.class;\n}"}, "----------\n1. ERROR in TestAnnotation.java (at line 2)\n\tString targetItem() default void.class;\n\t                            ^^^^^^^^^^\nType mismatch: cannot convert from Class<Void> to String\n----------\n");
    }

    public void test249() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Zork\npublic class X {}"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Zork\n\t ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "public class X {";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test250() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\n@Zork\n@Annot(1)\npublic class X {}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(RUNTIME)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Zork\n\t ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "@java.lang.Deprecated\n@Annot(value=(int) 1)\npublic class X {";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test251() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "@Deprecated\n@Zork\n@Annot(1)\npublic class X {}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(CLASS)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Zork\n\t ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "@Annot(value=(int) 1)\n@java.lang.Deprecated\npublic class X {";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test252() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(@Deprecated @Zork @Annot(2) int i) {}\n}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(CLASS)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(@Deprecated @Zork @Annot(2) int i) {}\n\t                             ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #22 @java.lang.Deprecated(\n        )\n    RuntimeInvisibleParameterAnnotations: \n      Number of annotations for parameter 0: 2\n        #17 @Zork(\n        )\n        #18 @Annot(\n          #19 value=(int) 2 (constant type)\n        )\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test253() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(@Deprecated @Zork @Annot(2) int i) {}\n}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(RUNTIME)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(@Deprecated @Zork @Annot(2) int i) {}\n\t                             ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 2\n        #19 @java.lang.Deprecated(\n        )\n        #20 @Annot(\n          #21 value=(int) 2 (constant type)\n        )\n    RuntimeInvisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #17 @Zork(\n        )\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test254() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(@Deprecated int j, @Zork @Annot(3) int i) {}\n}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(RUNTIME)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(@Deprecated int j, @Zork @Annot(3) int i) {}\n\t                                    ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #19 @java.lang.Deprecated(\n        )\n      Number of annotations for parameter 1: 1\n        #20 @Annot(\n          #21 value=(int) 3 (constant type)\n        )\n    RuntimeInvisibleParameterAnnotations: \n      Number of annotations for parameter 0: 0\n      Number of annotations for parameter 1: 1\n        #17 @Zork(\n        )\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test255() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(@Deprecated int j, @Annot(\"\") @Deprecated int i) {}\n}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(RUNTIME)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(@Deprecated int j, @Annot(\"\") @Deprecated int i) {}\n\t                                          ^^\nType mismatch: cannot convert from String to int\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #17 @java.lang.Deprecated(\n        )\n      Number of annotations for parameter 1: 1\n        #17 @java.lang.Deprecated(\n        )\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test256() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(@Deprecated int j, @Annot(\"\") @Deprecated int i) {}\n}", "Annot.java", "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(CLASS)\n@interface Annot {\n\tint value() default -1;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(@Deprecated int j, @Annot(\"\") @Deprecated int i) {}\n\t                                          ^^\nType mismatch: cannot convert from String to int\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "    RuntimeVisibleParameterAnnotations: \n      Number of annotations for parameter 0: 1\n        #20 @java.lang.Deprecated(\n        )\n      Number of annotations for parameter 1: 1\n        #20 @java.lang.Deprecated(\n        )";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test257() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static interface IFoo {\n        public boolean eval(String s);\n    }\n    static class Foo implements IFoo {\n        @Override\n        public boolean eval(String s) {\n            return true;\n        }\n    }\n}\n"}, "");
    }

    public void test258() {
        String expectedOutput = "----------\n1. ERROR in X.java (at line 9)\n\tvoid bar();//3\n\t     ^^^^^\nThe method bar() of type Bar must override or implement a supertype method\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "interface Foo {\n\t@Override\n\tString toString();//1\n}\ninterface Bar extends Foo {\n\t@Override\n\tString toString();//2\n\t@Override\n\tvoid bar();//3\n}\nclass BarImpl implements Bar {\n\t@Override\n\tpublic void bar() {}//4\n}\n"}, expectedOutput);
    }

    public void test259() {
        this.runConformTest(new String[]{"Jpf.java", "public class Jpf {\n\t@interface Action {\n\t\tForward[] forwards();\n\t}\n\t@interface Forward {\n\t\tString name();\n\t\tString path();\n\t\tActionOutput[] actionOutputs();\n\t}\n\t@interface ActionOutput {\n\t\tString name();\n\t\tClass type();\n\t}\n\t@Jpf.Action( \n\t\t\tforwards = { \n\t\t\t\t\t@Jpf.Forward(\n\t\t\t\t\t\t\tname = \"success\", \n\t\t\t\t\t\t\tpath = \"results.jsp\", \n\t\t\t\t\t\t\tactionOutputs = { \n\t\t\t\t\t\t\t\t\t@Jpf.ActionOutput(\n\t\t\t\t\t\t\t\t\t\t\tname = \"mybeanmethodResult\", \n\t\t\t\t\t\t\t\t\t\t\ttype = java.lang.String[].class) }) })\n\tpublic Forward mybeanmethod() {\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void test260() {
        this.runConformTest(new String[]{"X.java", "@X.StringAnnotation(X.CONSTANT_EXPRESSION)\npublic class X {\n  public @interface StringAnnotation {\n    String value();\n  }\n  public final static String CONSTANT = \"Constant\";\n  public final static String CONSTANT_EXPRESSION = CONSTANT + \"Expression\";\n}\n"}, "");
    }

    public void test261() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Other().foo();\n\t}\n}\n", "Annot.java", "public @interface Annot {\n\tClass value();\n}\n", "Other.java", "public class Other {\n\t@Annot(value = Other[].class)\n\tvoid foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS", null, true, null, options, null);
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Other().foo();\n\t}\n}\n"}, "SUCCESS", null, false, null, options, null);
    }

    public void test262() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Other().foo();\n\t}\n}\n", "Annot.java", "public @interface Annot {\n\tString[] values();\n}\n", "Other.java", "public class Other {\n\t@Annot(values = {\"foo\",\"bar\"})\n\tvoid foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS", null, true, null, options, null);
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Other().foo();\n\t}\n}\n"}, "SUCCESS", null, false, null, options, null);
    }

    public void test263() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Other().foo();\n\t}\n}\n", "Annot.java", "public @interface Annot {\n\tString[] values();\n}\n", "Other.java", "public class Other {\n\t@Annot(values = {\"foo\",\"bar\"})\n\tvoid foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS", null, true, null, options, null);
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Other().foo();\n\t}\n}\n"}, "SUCCESS", null, false, null, options, null);
    }

    public void test264() {
        this.runConformTest(new String[]{"X.java", "@interface Anno {\n\tString value();\n}\n\n@Anno(X.B)\npublic class X {\n\tpublic static final String A = \"a\";\n\tpublic static final String B = A + \"b\";\n}\n"}, "");
    }

    public void test265() {
        FileSystem nameEnvironment = new FileSystem(org.eclipse.jdt.core.tests.util.Util.getJavaClassLibs(), new String[0], null);
        IErrorHandlingPolicy errorHandlingPolicy = new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.performMethodsFullRecovery = false;
        compilerOptions.performStatementsRecovery = false;
        Requestor requestor = new Requestor(false, null, false, false);
        requestor.outputPath = "bin/";
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        Compiler compiler = new Compiler((INameEnvironment)nameEnvironment, errorHandlingPolicy, compilerOptions, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        compiler.options.produceReferenceInfo = true;
        String code = "@java.lang.SuppressWarnings(\"test\")\npackage testpack;\n";
        CompilationUnit source = new CompilationUnit(code.toCharArray(), "testpack/package-info.java", null);
        compiler.resolve((ICompilationUnit)source, true, true, false);
        char[][] compoundName = new char[][]{"testpack".toCharArray(), "package-info".toCharArray()};
        ReferenceBinding type = compiler.lookupEnvironment.getType((char[][])compoundName);
        AnnotationBinding[] annotations = null;
        if (type != null && type.isValidBinding()) {
            annotations = type.getAnnotations();
        }
        AnnotationTest.assertTrue((String)"Annotations missing on package-info interface", (annotations != null && annotations.length == 1 ? 1 : 0) != 0);
        AnnotationTest.assertEquals("Wrong annotation on package-info interface ", "@SuppressWarnings((String)\"test\")", annotations[0].toString());
        nameEnvironment.cleanup();
        if (requestor.hasErrors && !requestor.problemLog.contains("The annotation @SuppressWarnings is disallowed for this location") && !requestor.problemLog.contains("annotations are only available if source level is 1.5 or greater")) {
            Assert.assertNull((String)"problem", (Object)requestor.problemLog);
        }
        compiler = null;
    }

    public void test266() {
        this.runNegativeTest(new String[]{"p/package-info.java", "@Deprecated\n@Deprecated\npackage p;"}, "----------\n1. ERROR in p\\package-info.java (at line 1)\n\t@Deprecated\n\t^^^^^^^^^^^\n" + this.repeatableIntroText + "@Deprecated" + this.repeatableTrailerText + "----------\n2. ERROR in p\\package-info.java (at line 2)\n\t@Deprecated\n\t^^^^^^^^^^^\n" + this.repeatableIntroText + "@Deprecated" + this.repeatableTrailerText + "----------\n");
    }

    public void test267() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runNegativeTest(true, new String[]{"com/SomeTest.java", "package com;\nimport static com.SomeTest.UNCHECKED;\n@SuppressWarnings(UNCHECKED)\npublic class SomeTest {\n    public static final String UNCHECKED = \"unchecked\";\n}\n"}, null, customOptions, "----------\n1. ERROR in com\\SomeTest.java (at line 3)\n\t@SuppressWarnings(UNCHECKED)\n\t                  ^^^^^^^^^\nUnnecessary @SuppressWarnings(\"unchecked\")\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test268() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprotected enum E {\n\t\tE1, E2\n\t}\n\tprotected @interface Anno1 { E value(); }\n\tprotected @interface Anno2 { E value(); }\n\tprotected @interface Anno3 { E value(); }\n\t@Anno1(true ? E.E1 : E.E2)\n\t@Anno2(bar())\n\t@Anno3(((E.E1)))\n\tpublic void foo() {\n\t}\n\tpublic E bar() { return E.E1; }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Anno1(true ? E.E1 : E.E2)\n\t       ^^^^^^^^^^^^^^^^^^\nThe value for annotation attribute X.Anno1.value must be an enum constant expression\n----------\n2. ERROR in X.java (at line 9)\n\t@Anno2(bar())\n\t       ^^^^^\nThe value for annotation attribute X.Anno2.value must be an enum constant expression\n----------\n");
    }

    public void test269() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        String[] warnings = CompilerOptions.warningOptionNames();
        int i = 0;
        int ceil = warnings.length;
        while (i < ceil) {
            customOptions.put(warnings[i], "warning");
            ++i;
        }
        this.runConformTest(true, new String[]{"X.java", "@interface X {}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 1)\n\t@interface X {}\n\t             ^^\nEmpty block should be documented\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test270() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test<T> {\n\t@interface Anno {\n\t\tAnno value();\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\tAnno value();\n\t^^^^\nCycle detected: the annotation type Test.Anno cannot contain attributes of the annotation type itself\n----------\n");
    }

    public void test271() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface A {}\npublic class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate void foo(@A Object o) {}\n}"}, "");
        String expectedOutput = "  // Method descriptor #15 (Ljava/lang/Object;)V\n  // Stack: 0, Locals: 2\n  private void foo(@A java.lang.Object o);\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 1);
    }

    public void test273() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface A {}\npublic class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate X(@A Object o) {}\n}"}, "");
        String expectedOutput = "  // Method descriptor #6 (Ljava/lang/Object;)V\n  // Stack: 1, Locals: 2\n  private X(@A java.lang.Object o);\n";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 1);
    }

    public void test274a() {
        String[] testString = new String[]{"T.java", "public interface T {\n        void m();\n}\nabstract class A implements T {\n}\nclass B extends A {\n        public void m() {}\n}\n"};
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "enabled");
        String expectedOutput = "----------\n1. ERROR in T.java (at line 7)\n\tpublic void m() {}\n\t            ^^^\nThe method m() of type B should be tagged with @Override since it actually overrides a superinterface method\n----------\n";
        this.runNegativeTest(true, testString, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test274b() {
        String[] testString = new String[]{"Over.java", "interface I {\n        void m();\n}\npublic class Over implements I {\n        public void m() {}\n}\n"};
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "enabled");
        String expectedOutput = "----------\n1. ERROR in Over.java (at line 5)\n\tpublic void m() {}\n\t            ^^^\nThe method m() of type Over should be tagged with @Override since it actually overrides a superinterface method\n----------\n";
        this.runNegativeTest(true, testString, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test274c() {
        String[] testString = new String[]{"B.java", "interface A {\n        void m();\n}\npublic interface B extends A {\n        void m();\n}\n"};
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "enabled");
        String expectedOutput = "----------\n1. ERROR in B.java (at line 5)\n\tvoid m();\n\t     ^^^\nThe method m() of type B should be tagged with @Override since it actually overrides a superinterface method\n----------\n";
        this.runNegativeTest(true, testString, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test274d() {
        String[] testString = new String[]{"A.java", "public interface A {\n        String toString();\n}\n"};
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "enabled");
        String expectedOutput = "----------\n1. ERROR in A.java (at line 2)\n\tString toString();\n\t       ^^^^^^^^^^\nThe method toString() of type A should be tagged with @Override since it actually overrides a superinterface method\n----------\n";
        this.runNegativeTest(true, testString, null, customOptions, expectedOutput, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test275() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "enabled");
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static final boolean DEBUG = false;\n//\t@SuppressWarnings(\"unused\")\n\tpublic void foo() {\n\t\tif (DEBUG)\n\t\t\tSystem.out.println(\"true\");\n\t\telse\n\t\t\tSystem.out.println(\"false\");\n\t\t\n\t}\n}\n"}, null, customOptions, "----------\n1. WARNING in X.java (at line 6)\n\tSystem.out.println(\"true\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n", "", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test276() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "enabled");
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static final boolean DEBUG = false;\n\t@SuppressWarnings(\"unused\")\n\tpublic void foo() {\n\t\tif (DEBUG)\n\t\t\tSystem.out.println(\"true\");\n\t\telse\n\t\t\tSystem.out.println(\"false\");\n\t\t\n\t}\n}\n"}, null, customOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test277() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "disabled");
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic static final boolean DEBUG = false;\n\t@SuppressWarnings(\"unused\")\n\tpublic void foo() {\n\t\tif (0 < 1)\n\t\t\tSystem.out.println(\"true\");\n\t\telse\n\t\t\tSystem.out.println(\"false\");\n\t\t\n\t}\n}\n"}, null, customOptions, "", "", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test278() {
        String[] testString = new String[]{"A.java", "import javax.swing.JComponent;\npublic class A extends JComponent {\n   @Override\n\tprotected void paintComponent(Graphics g) {   }\n}\n"};
        String expectedOutput = "----------\n1. WARNING in A.java (at line 2)\n\tpublic class A extends JComponent {\n\t             ^\nThe serializable class A does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in A.java (at line 4)\n\tprotected void paintComponent(Graphics g) {   }\n\t                              ^^^^^^^^\nGraphics cannot be resolved to a type\n----------\n";
        this.runNegativeTest(testString, expectedOutput);
    }

    public void test279() {
        String[] testString = new String[]{"A.java", "public class A {\n    public @interface Inline {\n        String value();\n    }\n    @Inline(\"foo\")\n    public Zork test;\n    public native void method();\n}"};
        String expectedOutput = "----------\n1. ERROR in A.java (at line 6)\n\tpublic Zork test;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(testString, expectedOutput);
    }

    public void test280() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "public class A {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}\n"};
        this.runConformTest(testFiles, null, null, true, null, customOptions, null);
    }

    public void test281() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "public class A {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}\n"};
        String expectedErrorString = "----------\n1. ERROR in A.java (at line 3)\n\tprivate int i;\n\t            ^\nThe value of the field A.i is not used\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test282() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "import java.util.Map;\npublic class A {\n\t@SuppressWarnings({\"rawtypes\", \"unused\"})\n\tprivate Map<String, String> i;\n}\n"};
        this.runConformTest(testFiles, null, null, true, null, customOptions, null);
    }

    public void test283() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "public class A {\n\t@SuppressWarnings(\"all\")\n\tprivate void i;\n}\n"};
        String expectedErrorString = "----------\n1. ERROR in A.java (at line 3)\n\tprivate void i;\n\t             ^\nvoid is an invalid type for the variable i\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test284() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"X.java", "public class X {\n    void m() {\n        @SuppressWarnings(\"cast\")\n        int i= (int) 0;\n        @SuppressWarnings(\"cast\")\n        byte b= (byte) i;\n        System.out.println(b);\n    }\n}"};
        String expectedErrorString = "----------\n1. ERROR in X.java (at line 5)\n\t@SuppressWarnings(\"cast\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"cast\")\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test285() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"X.java", "public class X {\n    void m() {\n        @SuppressWarnings(\"cast\")\n        int i= (int) 0;\n        @SuppressWarnings(\"cast\")\n        byte b= (byte) i;\n        System.out.println(b);\n    }\n}"};
        String expectedErrorString = "----------\n1. ERROR in X.java (at line 5)\n\t@SuppressWarnings(\"cast\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"cast\")\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test286() {
        HashMap<String, String> raiseDeprecationReduceInvalidJavadocSeverity = new HashMap<String, String>(2);
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        raiseDeprecationReduceInvalidJavadocSeverity.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X extends p.OldStuff {\n\t/**\n\t * @see p.OldStuff#foo()\n\t */\n\t@Override\n\tpublic void foo() {\n\t\tsuper.foo();\n\t}\n}\n", "p/OldStuff.java", "package p;\n@Deprecated\npublic class OldStuff {\n\tpublic void foo() {\n\t}\t\n}\n"}, "", null, true, null, raiseDeprecationReduceInvalidJavadocSeverity, null);
    }

    public void test287() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\t@SuppressWarnings(\"rawtypes\")\n\tvoid foo(ArrayList arg) {\n\t\tfor (\n\t\t\t@SuppressWarnings(\"unchecked\")\n\t\t\tboolean a= arg.add(1), b= arg.add(1);\n\t\t\tBoolean.FALSE;\n\t\t) {\n\t\t\tSystem.out.println(a && b);\n\t\t}\n\t}\n}"}, "", null, true, null, options, null);
    }

    public void test288() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\t@SuppressWarnings(\"rawtypes\")\n\tArrayList arg;\n\t@SuppressWarnings(\"unchecked\")\n\tboolean a= arg.add(1), b= arg.add(1);\n}"}, "", null, true, null, options, null);
    }

    public void test289() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tvoid foo(ArrayList arg) {\n\t\tfor (\n\t\t\t@Deprecated\n\t\t\t@Other\n\t\t\t@SuppressWarnings(\"unchecked\")\n\t\t\tboolean a= arg.add(1), b= arg.add(1);\n\t\t\tBoolean.FALSE;\n\t\t) {\n\t\t\tSystem.out.println(a && b);\n\t\t}\n\t}\n}", "Other.java", "@interface Other {}"}, "", null, true, null, options, null);
    }

    public void test290() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nclass X {\n\t@SuppressWarnings(\"rawtypes\")\n\tvoid foo(ArrayList arg) {\n\t\t@SuppressWarnings(\"unchecked\")\n\t\tboolean aa = arg.add(1), bb = arg.add(1);\n\t\tif (bb)\n\t\t\tSystem.out.println(\"hi\");\n\t}\n}"}, "", null, true, null, options, null);
    }

    public void test291() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nclass X {\n\t@SuppressWarnings(\"rawtypes\")\n\tvoid foo(ArrayList arg) {\n\t\t@SuppressWarnings(\"unchecked\")\n\t\tboolean aa = arg.add(1), bb = arg.add(1);\n\t\tif (aa)\n\t\t\tSystem.out.println(\"hi\");\n\t}\n}"}, "", null, true, null, options, null);
    }

    public void test292() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nclass X {\n\t@SuppressWarnings(\"rawtypes\")\n\tvoid foo(ArrayList arg) {\n\t\t@SuppressWarnings(\"unchecked\")\n\t\tboolean aa = arg.add(1), bb = arg.add(1);\n\t}\n}"}, "", null, true, null, options, null);
    }

    public void test293() {
        this.runConformTest(new String[]{"X.java", "@A(name = X.QUERY_NAME, query = X.QUERY)\npublic class X {\n    public static final String QUERY_NAME = \"client.query.name\";\n    private static final String QUERY = \"from Client\";\n}\n@interface A{\n    String name();\n    String query();\n}\n"}, "");
    }

    public void test294() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "/** */\npublic class A {\n\t@SuppressWarnings(\"javadoc\")\n\tpublic int foo(int i) { return 0; }\n}\n"};
        this.runConformTest(testFiles, null, null, true, null, customOptions, null);
    }

    public void test295() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "/** */\npublic class A {\n\t/**\n\t * @param j the given param/\n\t */\n\t@SuppressWarnings(\"javadoc\")\n\tpublic int foo(int i) { return 0; }\n}\n"};
        this.runConformTest(testFiles, null, null, true, null, customOptions, null);
    }

    public void test296() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        String[] testFiles = new String[]{"A.java", "/** */\npublic class A {\n\t/**\n\t * @param i/\n\t */\n\t@SuppressWarnings(\"javadoc\")\n\tpublic int foo(int i) { return 0; }\n}\n"};
        this.runConformTest(testFiles, null, null, true, null, customOptions, null);
    }

    public void test297() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.comparingIdentical", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        runner.expectedCompilerLog = "----------\n1. ERROR in A.java (at line 15)\n\treturn i == i;\n\t       ^^^^^^\nComparing identical expressions\n----------\n";
        runner.expectedCompilerLog = "----------\n1. ERROR in A.java (at line 10)\n\tpublic final Object build(Class<? super Object>... objects) {\n\t                                                   ^^^^^^^\nType safety: Potential heap pollution via varargs parameter objects\n----------\n2. ERROR in A.java (at line 15)\n\treturn i == i;\n\t       ^^^^^^\nComparing identical expressions\n----------\n";
        runner.testFiles = new String[]{"A.java", "public class A {\n\tpublic void one() {\n\t\t@SuppressWarnings(\"unused\")\n\t\tObject object = new Object();\n\t}\n\tpublic void two() {\n\t\t@SuppressWarnings({ \"unchecked\", \"unused\" })\n\t\tObject object = build();\n\t}\n\tpublic final Object build(Class<? super Object>... objects) {\n\t\treturn null;\n\t}\n\tpublic boolean bar() {\n\t\tint i = 0;\n\t\treturn i == i;\n\t}\n}"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testBug366003() {
        this.runNegativeTest(new String[]{"snippet/Bug366003.java", "package snippet;\npublic class Bug366003 {\n    public void foo(@NonNull Object o1) {\n        System.out.println(o1.toString()); // OK: o1 cannot be null\n    }         \n    @NonNull Object bar(@Nullable String s1) {\n        foo(null); // cannot pass null argument\n        @NonNull String s= null; // cannot assign null value\n        @NonNull String t= s1; // cannot assign potentially null value\n        return null; // cannot return null value\n    }\n}\norg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n"}, "----------\n1. ERROR in snippet\\Bug366003.java (at line 3)\n\tpublic void foo(@NonNull Object o1) {\n\t                 ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n2. ERROR in snippet\\Bug366003.java (at line 6)\n\t@NonNull Object bar(@Nullable String s1) {\n\t ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n3. ERROR in snippet\\Bug366003.java (at line 6)\n\t@NonNull Object bar(@Nullable String s1) {\n\t                     ^^^^^^^^\nNullable cannot be resolved to a type\n----------\n4. ERROR in snippet\\Bug366003.java (at line 8)\n\t@NonNull String s= null; // cannot assign null value\n\t ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n5. ERROR in snippet\\Bug366003.java (at line 9)\n\t@NonNull String t= s1; // cannot assign potentially null value\n\t ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n6. ERROR in snippet\\Bug366003.java (at line 12)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n7. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \"Identifier (\" to complete MethodHeaderName\n----------\n8. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \")\" to complete MethodDeclaration\n----------\n9. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \";\" to complete MethodDeclaration\n----------\n10. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n11. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n12. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                       ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n13. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                                                      ^^^^^^^^\nNullable cannot be resolved to a type\n----------\n14. ERROR in snippet\\Bug366003.java (at line 13)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                                                                           ^\nSyntax error, insert \";\" to complete ConstructorDeclaration\n----------\n");
    }

    public void testBug366003b() {
        this.runNegativeTest(new String[]{"snippet/Bug366003.java", "package snippet;\npublic class Bug366003 {\n    public void foo(@Blah Object o1) {        \nSystem.out.println(o1.toString()); // OK: o1 cannot be null     }         \n@Blah Object bar(@BlahBlah String s1) {         foo(null); // cannot pass\nnull argument         @Blah String s= null; // cannot assign null value     \n    @Blah String t= s1; // cannot assign potentially null value         \nreturn null; // cannot return null value     }\n}\n\norg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n"}, "----------\n1. ERROR in snippet\\Bug366003.java (at line 3)\n\tpublic void foo(@Blah Object o1) {        \n\t                 ^^^^\nBlah cannot be resolved to a type\n----------\n2. ERROR in snippet\\Bug366003.java (at line 4)\n\tSystem.out.println(o1.toString()); // OK: o1 cannot be null     }         \n\t                                 ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n3. ERROR in snippet\\Bug366003.java (at line 5)\n\t@Blah Object bar(@BlahBlah String s1) {         foo(null); // cannot pass\n\t ^^^^\nBlah cannot be resolved to a type\n----------\n4. ERROR in snippet\\Bug366003.java (at line 5)\n\t@Blah Object bar(@BlahBlah String s1) {         foo(null); // cannot pass\n\t                  ^^^^^^^^\nBlahBlah cannot be resolved to a type\n----------\n5. ERROR in snippet\\Bug366003.java (at line 6)\n\tnull argument         @Blah String s= null; // cannot assign null value     \n\t^^^^\nSyntax error on token \"null\", @ expected\n----------\n6. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \"Identifier (\" to complete MethodHeaderName\n----------\n7. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \")\" to complete MethodDeclaration\n----------\n8. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \";\" to complete MethodDeclaration\n----------\n9. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t            ^^^^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n10. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n11. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                       ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n12. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                                                      ^^^^^^^^\nNullable cannot be resolved to a type\n----------\n13. ERROR in snippet\\Bug366003.java (at line 11)\n\torg.eclipse.User.User(@NonNull String name, int uid, @Nullable String email)\n\t                                                                           ^\nSyntax error, insert \";\" to complete ConstructorDeclaration\n----------\n");
    }

    public void testBug366003c() {
        this.runNegativeTest(new String[]{"snippet/Bug366003.java", "package snippet;\npublic class Bug366003 {\n    void foo(Object o1) {\n    }\norg.User(@Bla String a)"}, "----------\n1. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t^^^\nSyntax error, insert \"Identifier (\" to complete MethodHeaderName\n----------\n2. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t^^^\nSyntax error, insert \")\" to complete MethodDeclaration\n----------\n3. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t^^^\nSyntax error, insert \";\" to complete MethodDeclaration\n----------\n4. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t^^^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n5. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t    ^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n6. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t          ^^^\nBla cannot be resolved to a type\n----------\n7. ERROR in snippet\\Bug366003.java (at line 5)\n\torg.User(@Bla String a)\n\t                      ^\nSyntax error, insert \";\" to complete ConstructorDeclaration\n----------\n");
    }

    public void testBug366003d() {
        this.runNegativeTest(new String[]{"snippet/Bug366003.java", "package snippet; \npublic class Bug366003 {\n\tvoid foo() {\n\t\ttry {\n\t\t\tSystem.out.println(\"\");\n\t\t} catch (Exeption eFirst) {\n\t\t\te } catch (@Blah Exception eSecond) {\n\t\t\te }\n\t}\n}\n"}, "----------\n1. ERROR in snippet\\Bug366003.java (at line 7)\n\te } catch (@Blah Exception eSecond) {\n\t^\nSyntax error, insert \"VariableDeclarators\" to complete LocalVariableDeclaration\n----------\n2. ERROR in snippet\\Bug366003.java (at line 7)\n\te } catch (@Blah Exception eSecond) {\n\t^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n3. ERROR in snippet\\Bug366003.java (at line 8)\n\te }\n\t^\nSyntax error, insert \"VariableDeclarators\" to complete LocalVariableDeclaration\n----------\n4. ERROR in snippet\\Bug366003.java (at line 8)\n\te }\n\t^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void testBug366003e() {
        this.runNegativeTest(new String[]{"snippet/Bug366003.java", "package snippet;\npublic class Bug366003 {\n        void foo(Object o1){}\n        @Blah org.User(@Bla String str){}\n}\n"}, "----------\n1. ERROR in snippet\\Bug366003.java (at line 4)\n\t@Blah org.User(@Bla String str){}\n\t ^^^^\nBlah cannot be resolved to a type\n----------\n2. ERROR in snippet\\Bug366003.java (at line 4)\n\t@Blah org.User(@Bla String str){}\n\t          ^^^^\nSyntax error on token \"User\", Identifier expected after this token\n----------\n3. ERROR in snippet\\Bug366003.java (at line 4)\n\t@Blah org.User(@Bla String str){}\n\t          ^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n4. ERROR in snippet\\Bug366003.java (at line 4)\n\t@Blah org.User(@Bla String str){}\n\t                ^^^\nBla cannot be resolved to a type\n----------\n");
    }

    public void testBug365437a() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.enableAllWarningsForIrritants(customOptions, IrritantSet.NULL);
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        String[] testFiles = new String[]{"p/A.java", "package p;\nimport p1.*;\npublic class A {\n\t@p1.PreDestroy\n\tprivate void foo1(){}\n\t@PreDestroy\n\tprivate void foo2(){}\n\t@SuppressWarnings(\"null\")\n\t@PostConstruct\n\tprivate void foo1a(){}\n\t@PostConstruct\n\tprivate void foo2a(){}\n\t@Deprecated\tprivate void foo3(){}}\n", "p1/PreDestroy.java", "package p1;\npublic @interface PreDestroy{}", "p1/PostConstruct.java", "package p1;\npublic @interface PostConstruct{}"};
        String expectedErrorString = "----------\n1. WARNING in p\\A.java (at line 8)\n\t@SuppressWarnings(\"null\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"null\")\n----------\n2. ERROR in p\\A.java (at line 13)\n\t@Deprecated\tprivate void foo3(){}}\n\t           \t             ^^^^^^\nThe method foo3() from the type A is never used locally\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug365437b() {
        if (isJRE11Plus) {
            return;
        }
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "p.NonNull");
        String[] testFiles = new String[]{"A.java", "import javax.annotation.*;\npublic class A {\n\t@javax.annotation.PreDestroy\n\tprivate void foo1(){}\n\t@PreDestroy\n\tprivate void foo2(){}\n\t@javax.annotation.Resource\n\tprivate void foo1a(){}\n\t@Resource\n\t@p.NonNull\n\tprivate Object foo2a(){ return new Object();}\n\t@javax.annotation.PostConstruct\n\t@Deprecated\n\tprivate void foo3(){}\n\t@p.NonNull\n\tprivate Object foo3a(){ return new Object();}\n}\n", "p/NonNull.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}"};
        String expectedErrorString = "----------\n1. ERROR in A.java (at line 16)\n\tprivate Object foo3a(){ return new Object();}\n\t               ^^^^^^^\nThe method foo3a() from the type A is never used locally\n----------\n";
        INameEnvironment save = this.javaClassLib;
        try {
            if (isJRE9Plus) {
                List<String> limitModules = Arrays.asList("java.se", "java.xml.ws.annotation");
                this.javaClassLib = new AbstractRegressionTest.CustomFileSystem(limitModules);
            }
            this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, isJRE9Plus ? AbstractRegressionTest.JavacTestOptions.SKIP : AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
        }
        finally {
            this.javaClassLib = save;
        }
    }

    public void testBug365437c() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.enableAllWarningsForIrritants(customOptions, IrritantSet.NULL);
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        String[] testFiles = new String[]{"p/A.java", "package p;\nimport p1.*;\npublic class A {\n\t@p1.PreDestroy\n\tprivate void foo1(){}\n\t@PreDestroy\n\tprivate void foo2(){}\n\t@SuppressWarnings(\"null\")\n\t@PostConstruct\n\tprivate void foo1a(){}\n\t@PostConstruct\n\tprivate void foo2a(){}\n\t@SafeVarargs\tprivate final void foo3(Object... o){}}\n", "p1/PreDestroy.java", "package p1;\npublic @interface PreDestroy{}", "p1/PostConstruct.java", "package p1;\npublic @interface PostConstruct{}"};
        String expectedErrorString = "----------\n1. WARNING in p\\A.java (at line 8)\n\t@SuppressWarnings(\"null\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"null\")\n----------\n2. ERROR in p\\A.java (at line 13)\n\t@SafeVarargs\tprivate final void foo3(Object... o){}}\n\t            \t                   ^^^^^^^^^^^^^^^^^\nThe method foo3(Object...) from the type A is never used locally\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug365437d() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.enableAllWarningsForIrritants(customOptions, IrritantSet.NULL);
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "p.NonNullByDefault");
        this.runNegativeTest(true, new String[]{"Example.java", "class Example {\n  @p.Annot\n  private Example() {\n  }\n  public Example(int i) {\n  }\n}\nclass E1 {\n\t @Deprecated\n    private E1() {}\n    public E1(long l) {}\n}\nclass E2 {\n\t @SuppressWarnings(\"null\")\n    private E2() {}\n    public E2(long l) {}\n}\nclass E3 {\n\t @p.NonNullByDefault\n    private E3() {}\n    public E3(long l) {}\n}\nclass E4 {\n\t @Deprecated\n\t @p.Annot\n    private E4() {}\n    public E4(long l) {}\n}\n", "p/NonNullByDefault.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,CONSTRUCTOR})\npublic @interface NonNullByDefault {\n}", "p/Annot.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE, CONSTRUCTOR})\npublic @interface Annot {\n}"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 10)\n\tprivate E1() {}\n\t        ^^^^\nThe constructor E1() is never used locally\n----------\n2. WARNING in Example.java (at line 14)\n\t@SuppressWarnings(\"null\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"null\")\n----------\n3. ERROR in Example.java (at line 15)\n\tprivate E2() {}\n\t        ^^^^\nThe constructor E2() is never used locally\n----------\n4. ERROR in Example.java (at line 20)\n\tprivate E3() {}\n\t        ^^^^\nThe constructor E3() is never used locally\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug365437e() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.enableAllWarningsForIrritants(customOptions, IrritantSet.NULL);
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "p.NonNull");
        this.runNegativeTest(true, new String[]{"Example.java", "class Example {\n  @p.Annot\n  private int Ex;\n}\nclass E1 {\n\t @Deprecated\n    private int E1;\n}\nclass E2 {\n\t @SuppressWarnings(\"null\")\n    private int E2;\n}\nclass E3 {\n\t @p.NonNull\n    private Object E3 = new Object();\n}\nclass E4 {\n\t @Deprecated\n\t @p.Annot\n    private int E4;\n}\n", "p/NonNull.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE, FIELD})\npublic @interface NonNull {\n}", "p/Annot.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE, FIELD})\npublic @interface Annot {\n}"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 7)\n\tprivate int E1;\n\t            ^^\nThe value of the field E1.E1 is not used\n----------\n2. WARNING in Example.java (at line 10)\n\t@SuppressWarnings(\"null\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"null\")\n----------\n3. ERROR in Example.java (at line 11)\n\tprivate int E2;\n\t            ^^\nThe value of the field E2.E2 is not used\n----------\n4. ERROR in Example.java (at line 15)\n\tprivate Object E3 = new Object();\n\t               ^^\nThe value of the field E3.E3 is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug365437f() {
        Map<String, String> customOptions = this.getCompilerOptions();
        this.enableAllWarningsForIrritants(customOptions, IrritantSet.NULL);
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "p.NonNullByDefault");
        this.runNegativeTest(true, new String[]{"Example.java", "class Example {\n  @p.Annot\n  private class Ex{}\n}\nclass E1 {\n\t @Deprecated\n    private class E11{}\n}\nclass E2 {\n\t @SuppressWarnings(\"null\")\n    private class E22{}\n}\nclass E3 {\n\t @p.NonNullByDefault\n    private class E33{}\n}\nclass E4 {\n\t @Deprecated\n\t @p.Annot\n    private class E44{}\n}\n", "p/NonNullByDefault.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER})\npublic @interface NonNullByDefault {\n}", "p/Annot.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE, CONSTRUCTOR})\npublic @interface Annot {\n}"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 7)\n\tprivate class E11{}\n\t              ^^^\nThe type E1.E11 is never used locally\n----------\n2. WARNING in Example.java (at line 10)\n\t@SuppressWarnings(\"null\")\n\t                  ^^^^^^\nUnnecessary @SuppressWarnings(\"null\")\n----------\n3. ERROR in Example.java (at line 11)\n\tprivate class E22{}\n\t              ^^^\nThe type E2.E22 is never used locally\n----------\n4. ERROR in Example.java (at line 15)\n\tprivate class E33{}\n\t              ^^^\nThe type E3.E33 is never used locally\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug376590a() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(true, new String[]{"com/google/inject/Inject.java", "package com.google.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {\n\n  boolean optional() default false;\n}", "Example.java", "import com.google.inject.Inject;\nclass Example {\n  private @Inject Object o;\n  private @Inject Example() {}\n  public Example(Object o) { this.o = o; }\n  private @Inject void setO(Object o) { this.o = o;}\n}\n"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 3)\n\tprivate @Inject Object o;\n\t                       ^\nThe value of the field Example.o is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug376590b() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(true, new String[]{"javax/inject/Inject.java", "package javax.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {}\n", "Example.java", "class Example {\n  private @javax.inject.Inject Object o;\n  private Example() {} // also warn here: no @Inject\n  public Example(Object o) { this.o = o; }\n  private @javax.inject.Inject void setO(Object o) { this.o = o;}\n}\n"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 2)\n\tprivate @javax.inject.Inject Object o;\n\t                                    ^\nThe value of the field Example.o is not used\n----------\n2. ERROR in Example.java (at line 3)\n\tprivate Example() {} // also warn here: no @Inject\n\t        ^^^^^^^^^\nThe constructor Example() is never used locally\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug376590c() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "p.NonNull");
        this.runNegativeTest(true, new String[]{"javax/inject/Inject.java", "package javax.inject;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\nimport java.lang.annotation.Target;\n@Target({ METHOD, CONSTRUCTOR, FIELD })\n@Retention(RUNTIME)\npublic @interface Inject {}\n", "Example.java", "import javax.inject.Inject;\nclass Example {\n  private @Inject @p.NonNull Object o; // do warn, annotations don't signal a read\n  private @Deprecated @Inject String old; // do warn, annotations don't signal a read\n  private @Inject @p.Annot Object o2;\n}\n", "p/NonNull.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE,FIELD})\npublic @interface NonNull {\n}", "p/Annot.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Target({TYPE, METHOD,PARAMETER,LOCAL_VARIABLE, CONSTRUCTOR, FIELD})\npublic @interface Annot {\n}"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 3)\n\tprivate @Inject @p.NonNull Object o; // do warn, annotations don't signal a read\n\t                                  ^\nThe value of the field Example.o is not used\n----------\n2. ERROR in Example.java (at line 4)\n\tprivate @Deprecated @Inject String old; // do warn, annotations don't signal a read\n\t                                   ^^^\nThe value of the field Example.old is not used\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug376429a() {
        this.runNegativeTest(new String[]{"Try.java", "public @interface Try { \n\tbyte[] value(); \n\t@Try t();\n\t@Try u();\n}"}, "----------\n1. ERROR in Try.java (at line 3)\n\t@Try t();\n\t^^^^\nThe annotation @Try must define the attribute value\n----------\n2. ERROR in Try.java (at line 3)\n\t@Try t();\n\t     ^^^\nReturn type for the method is missing\n----------\n3. ERROR in Try.java (at line 3)\n\t@Try t();\n\t     ^^^\nReturn type for the method is missing\n----------\n4. ERROR in Try.java (at line 4)\n\t@Try u();\n\t^^^^\nThe annotation @Try must define the attribute value\n----------\n5. ERROR in Try.java (at line 4)\n\t@Try u();\n\t     ^^^\nReturn type for the method is missing\n----------\n");
    }

    public void testBug376429b() {
        this.runNegativeTest(new String[]{"Try.java", "public @interface Try { \n\t@Try t();\n\tbyte[] value(); \n}"}, "----------\n1. ERROR in Try.java (at line 2)\n\t@Try t();\n\t^^^^\nThe annotation @Try must define the attribute value\n----------\n2. ERROR in Try.java (at line 2)\n\t@Try t();\n\t     ^^^\nReturn type for the method is missing\n----------\n");
    }

    public void testBug371832() throws Exception {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "error");
        String[] testFiles = new String[]{"A.java", "import java.util.List;\n@SuppressWarnings(\"serial\")\npublic class A implements java.io.Serializable {\n\tvoid foo() { \n\t}\n}\n"};
        String expectedErrorString = "----------\n1. ERROR in A.java (at line 1)\n\timport java.util.List;\n\t       ^^^^^^^^^^^^^^\nThe import java.util.List is never used\n----------\n";
        this.runNegativeTest(true, testFiles, null, customOptions, expectedErrorString, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug384663() {
        String[] testFiles = new String[]{"annotations/test/IExtendsInterface.java", "package annotations.test;\npublic interface IExtendsInterface extends Interface {}\n", "annotations/test/Interface.java", "package annotations.test;\npublic interface Interface {}\n", "annotations/test/package-info.java", "@AnnotationDefinition(\"Test1\") \npackage annotations.test;\nimport annotations.AnnotationDefinition;", "annotations/AnnotationDefinition.java", "package annotations;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.PACKAGE)\npublic @interface AnnotationDefinition {\n\tString value();\n}"};
        this.runConformTest(testFiles);
    }

    public void _testBug386356_1() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport javax.xml.bind.annotation.adapters.XmlAdapter;\npublic abstract class X extends XmlAdapter<String,X> {\n}", "p/package-info.java", "@XmlJavaTypeAdapters({ @XmlJavaTypeAdapter(value = X.class, type = X.class) })\npackage p;\nimport javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;   \nimport javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;"});
    }

    public void testBug386356_2() {
        if (isJRE11Plus) {
            return;
        }
        INameEnvironment save = this.javaClassLib;
        try {
            if (isJRE9Plus) {
                List<String> limitModules = Arrays.asList("java.se", "java.xml.bind");
                this.javaClassLib = new AbstractRegressionTest.CustomFileSystem(limitModules);
            }
            this.runConformTest(new String[]{"com/ermahgerd/Ermahgerd.java", "package com.ermahgerd;\n\npublic class Ermahgerd {\n}", "com/ermahgerd/package-info.java", "@XmlJavaTypeAdapters({ @XmlJavaTypeAdapter(value = ErmahgerdXmlAdapter.class, type = Ermahgerd.class) })\npackage com.ermahgerd;\nimport javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;\nimport javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;", "com/ermahgerd/ErmahgerdXmlAdapter.java", "package com.ermahgerd;\n\nimport javax.xml.bind.annotation.adapters.XmlAdapter;\n\npublic class ErmahgerdXmlAdapter extends XmlAdapter<String,Ermahgerd> {\n\n\t@Override\n\tpublic String marshal(Ermahgerd arg0) throws Exception {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\t@Override\n\tpublic Ermahgerd unmarshal(String arg0) throws Exception {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n}"}, isJRE9Plus ? AbstractRegressionTest.JavacTestOptions.SKIP : AbstractRegressionTest.JavacTestOptions.DEFAULT);
        }
        finally {
            this.javaClassLib = save;
        }
    }

    public void test384567() {
        this.runNegativeTest(new String[]{"xy/X.java", "public final synchronized @Foo private package xy;\nclass X {\n}\n\n@interface Foo {\n}\n"}, "----------\n1. ERROR in xy\\X.java (at line 1)\n\tpublic final synchronized @Foo private package xy;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n2. ERROR in xy\\X.java (at line 1)\n\tpublic final synchronized @Foo private package xy;\n\t                          ^^^^\nPackage annotations must be in file package-info.java\n----------\n");
    }

    public void test384567_2() {
        this.runNegativeTest(new String[]{"xy/X.java", "public final synchronized private package xy;\nclass X {\n}\n\n"}, "----------\n1. ERROR in xy\\X.java (at line 1)\n\tpublic final synchronized private package xy;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n");
    }

    public void test416107a() {
        if (this.complianceLevel < 0x3C0000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\t @interface Bar {\n\t\t\tpublic String bar = \"BUG\";\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\t@interface Bar {\n\t           ^^^\nThe member annotation Bar can only be defined inside a top-level class or interface or in a static context\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\t @interface Bar {\n\t\t\tpublic String bar = \"BUG\";\n\t\t}\n\t}\n}"}, "");
        }
    }

    public void test416107b() {
        if (this.complianceLevel < 0x3C0000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\tinterface Bar {\n\t\t\tpublic String bar = \"BUG\";\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tinterface Bar {\n\t          ^^^\nThe member interface Bar can only be defined inside a top-level class or interface or in a static context\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "public class X {\n\tclass Y {\n\t\tinterface Bar {\n\t\t\tpublic String bar = \"BUG\";\n\t\t}\n\t}\n}"}, "");
        }
    }

    public void test427367() throws Exception {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        this.runNegativeTest(new String[]{"X.java", "@interface Annot1 {\n   Thread.State value() default Thread.State.NEW;\n   int value2() default 1;\n}\n@interface Annot2 {\n   Thread.State value() default Thread.State.NEW;\n}\n@Annot1(value = XXThread.State.BLOCKED, value2 = 42)\n@Annot2(value = XYThread.State.BLOCKED)\npublic class X {}"}, "----------\n1. ERROR in X.java (at line 8)\n\t@Annot1(value = XXThread.State.BLOCKED, value2 = 42)\n\t                ^^^^^^^^\nXXThread cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 9)\n\t@Annot2(value = XYThread.State.BLOCKED)\n\t                ^^^^^^^^\nXYThread cannot be resolved to a variable\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "@Annot1@Annot2\npublic class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 3, Locals: 1\n  public X();\n     0  new java.lang.Error [8]\n     3  dup\n     4  ldc <String \"Unresolved compilation problems: \\n\\tXXThread cannot be resolved to a variable\\n\\tXYThread cannot be resolved to a variable\\n\"> [10]\n     6  invokespecial java.lang.Error(java.lang.String) [12]\n     9  athrow\n      Line numbers:\n        [pc: 0, line: 8]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X\n\n}";
        try {
            this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 1);
        }
        catch (ClassFormatException cfe) {
            AnnotationTest.fail((String)"Error reading classfile");
        }
    }

    public void test376977() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import p.Outer;\n@Outer(nest= {@Nested()})\npublic class X {}", "p/Outer.java", "package p;\npublic @interface Outer {\n   Nested[] nest();}", "p/Nested.java", "package p;\npublic @interface Nested {\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Outer(nest= {@Nested()})\n\t               ^^^^^^\nNested cannot be resolved to a type\n----------\n", null, true, null, false, false, false);
    }

    public void test438437() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target({ElementType.TYPE_USE, ElementType.FIELD})\n@interface TUF {} \n@Target({ElementType.FIELD})\n@interface F {} \n@Target({ElementType.TYPE_USE})\n@interface TU1 {} \n@Target({ElementType.LOCAL_VARIABLE})\n@interface LV {} \n@Target({ElementType.TYPE_USE})\n@interface TU2 {} \nclass Y {}\npublic enum X {\n\t@TUF E1,\n\t@F E2,\n\t@TU1 E3,\n\t@LV E4,\n\t@TUF @TU1 @F E5,\n\t@TUF @TU1 @F @TU2 E6;\n\t@TUF Y y11;\n\t@F Y y12;\n\t@TU1 Y y13;\n\t@LV Y y14;\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\t@TU1 E3,\n\t^^^^\nSyntax error, type annotations are illegal here\n----------\n2. ERROR in X.java (at line 18)\n\t@LV E4,\n\t^^^\nThe annotation @LV is disallowed for this location\n----------\n3. ERROR in X.java (at line 19)\n\t@TUF @TU1 @F E5,\n\t     ^^^^\nSyntax error, type annotations are illegal here\n----------\n4. ERROR in X.java (at line 20)\n\t@TUF @TU1 @F @TU2 E6;\n\t     ^^^^\nSyntax error, type annotations are illegal here\n----------\n5. ERROR in X.java (at line 20)\n\t@TUF @TU1 @F @TU2 E6;\n\t             ^^^^\nSyntax error, type annotations are illegal here\n----------\n6. ERROR in X.java (at line 24)\n\t@LV Y y14;\n\t^^^\nThe annotation @LV is disallowed for this location\n----------\n");
    }

    public void test434556() throws Exception {
        this.runNegativeTest(new String[]{"A.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tint i();\n}\npublic class A {\n  @C(b={},i=42)\n  public void xxx() {}\n  public static void main(String []argv) throws Exception {\n\tSystem.out.println(A.class.getDeclaredMethod(\"xxx\").getAnnotations()[0]);  \n  }\n}"}, "----------\n1. ERROR in A.java (at line 8)\n\t@C(b={},i=42)\n\t   ^\nThe attribute b is undefined for the annotation type C\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "@C(i=(int) 42)\n  public void xxx();\n     0  new java.lang.Error [20]\n     3  dup\n     4  ldc <String \"Unresolved compilation problem: \\n\\tThe attribute b is undefined for the annotation type C\\n\"> [22]\n     6  invokespecial java.lang.Error(java.lang.String) [24]\n     9  athrow\n      Line numbers:\n        [pc: 0, line: 8]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: A\n  \n";
        try {
            this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "A.class", "A", expectedOutput, 1);
        }
        catch (ClassFormatException cfe) {
            AnnotationTest.fail((String)"Error reading classfile");
        }
    }

    public void test433747() throws Exception {
        String[] src = new String[]{"p/package-info.java", "@PackageAnnot(\"p123456\")\npackage p;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE)\n@interface PackageAnnot {\n\tString value();\n}\n"};
        this.runNegativeTest(src, "----------\n1. ERROR in p\\package-info.java (at line 1)\n\t@PackageAnnot(\"p123456\")\n\t^^^^^^^^^^^^^\nThe annotation @PackageAnnot is disallowed for this location\n----------\n", null, true, null, true, false, false);
    }

    public void test456960() throws Exception {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        this.runNegativeTest(new String[]{"X.java", "@Bar(String)\npublic class X {\n}", "Bar.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.RUNTIME)\n@interface Bar {\n\tClass<?>[] value();\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Bar(String)\n\t     ^^^^^^\nString cannot be resolved to a variable\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "public class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 3, Locals: 1\n  public X();\n     0  new java.lang.Error [8]\n     3  dup\n     4  ldc <String \"Unresolved compilation problem: \\n\\tString cannot be resolved to a variable\\n\"> [10]\n     6  invokespecial java.lang.Error(java.lang.String) [12]\n     9  athrow\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X\n}";
        try {
            this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput, 1);
        }
        catch (ClassFormatException cfe) {
            AnnotationTest.fail((String)"Error reading classfile");
        }
    }

    public void test449330() throws Exception {
        String[] testFiles = new String[]{"p/X.java", "package p;\n@java.lang.annotation.Target(value={java.lang.annotation.ElementType.TYPE})\n@interface X { public java.lang.String name(); }\n", "p/package-info.java", "@X(name=\"HELLO\")\npackage p;\n"};
        this.runNegativeTest(testFiles, "----------\n1. ERROR in p\\package-info.java (at line 1)\n\t@X(name=\"HELLO\")\n\t^^\nThe annotation @X is disallowed for this location\n----------\n");
    }

    public void test449330a() throws Exception {
        String[] testFiles = new String[]{"p/X.java", "package p;\n@java.lang.annotation.Target(value={java.lang.annotation.ElementType.TYPE})\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\n@interface X { public java.lang.String name(); }\n", "p/package-info.java", "@X(name=\"HELLO\")\npackage p;\n"};
        this.runNegativeTest(testFiles, "----------\n1. ERROR in p\\package-info.java (at line 1)\n\t@X(name=\"HELLO\")\n\t^^\nThe annotation @X is disallowed for this location\n----------\n");
    }

    public void test449330b() throws Exception {
        String[] testFiles = new String[]{"p/X.java", "package p;\n@interface X { public java.lang.String name(); }\n", "p/package-info.java", "@X(name=\"HELLO\")\npackage p;\n"};
        this.runConformTest(testFiles, "");
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "p/package-info.class", "", "HELLO");
    }

    public void testBug386692() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(true, new String[]{"org/springframework/beans/factory/annotation/Autowired.java", "package org.springframework.beans.factory.annotation;\nimport java.lang.annotation.Documented;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\npublic @interface Autowired {\n\n\tboolean required() default true;\n\n}", "Example.java", "class Example {\n  private @org.springframework.beans.factory.annotation.Autowired Object o;\n  private Example() {}\n  public Example(Object o) { this.o = o; }\n  private @org.springframework.beans.factory.annotation.Autowired void setO(Object o) { this.o = o;}\n}\n"}, null, customOptions, "----------\n1. ERROR in Example.java (at line 2)\n\tprivate @org.springframework.beans.factory.annotation.Autowired Object o;\n\t                                                                       ^\nThe value of the field Example.o is not used\n----------\n2. ERROR in Example.java (at line 3)\n\tprivate Example() {}\n\t        ^^^^^^^^^\nThe constructor Example() is never used locally\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug464977() throws Exception {
        if (this.complianceLevel > 0x340000L) {
            return;
        }
        boolean apt = this.enableAPT;
        String source = "@Deprecated\npublic class DeprecatedClass {\n}";
        String version = "";
        if (this.complianceLevel == 0x340000L) {
            version = "1.8 : 52.0";
        }
        String expectedOutput = "// Compiled from DeprecatedClass.java (version " + version + ", super bit, deprecated)\n@Deprecated\npublic class DeprecatedClass {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public DeprecatedClass();\n    0  aload_0 [this]\n    1  invokespecial Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 2]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: DeprecatedClass\n\n}";
        try {
            this.enableAPT = true;
            this.checkClassFile("DeprecatedClass", source, expectedOutput, 9);
        }
        finally {
            this.enableAPT = apt;
        }
    }

    public void testBug469584() {
        this.runNegativeTest(new String[]{"CCETest.java", "import java.lang.annotation.*;\n\n@Retention({RetentionPolicy.CLASS, RetentionPolicy.RUNTIME})\npublic @interface CCETest {\n\n}\n"}, "----------\n1. ERROR in CCETest.java (at line 3)\n\t@Retention({RetentionPolicy.CLASS, RetentionPolicy.RUNTIME})\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from RetentionPolicy[] to RetentionPolicy\n----------\n");
    }

    public void test472178() throws Exception {
        String source = "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.Iterator;\n \n/**\n * @author gglab\n */\npublic class Test<X> extends ArrayList<X> {\n    public void iterateRemove()\n    {\n        for (Iterator<X> iter = this.iterator(); iter.hasNext();) {\n            Object key = iter.next();\n            @Flowannotation\n            Foo<@Flowannotation String> f = new Foo<String>();\n            @Flowannotation long l = (@Flowannotation long)f.getI(); // this line causes parse error\n            iter.remove();\n        }\n    }\n \n    @Flowannotation\n    class Foo<@Flowannotation T>\n    {\n        @Flowannotation\n        public int getI()\n        {\n            return 3;\n        }\n    }\n \n    @Target({ ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.METHOD, ElementType.LOCAL_VARIABLE,           ElementType.TYPE, ElementType.FIELD,\n            ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})\n    @Retention(RetentionPolicy.RUNTIME)\n    @interface Flowannotation {}\n    public static void main(String[] args) {}\n}";
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 3, Locals: 6\n  public void iterateRemove();\n     0  aload_0 [this]\n     1  invokevirtual Test.iterator() : Iterator [17]\n     4  astore_1 [iter]\n     5  goto 37\n     8  aload_1 [iter]\n     9  invokeinterface Iterator.next() : Object [21] [nargs: 1]\n    14  astore_2 [key]\n    15  new Test$Foo [27]\n    18  dup\n    19  aload_0 [this]\n    20  invokespecial Test$Foo(Test) [29]\n    23  astore_3 [f]\n    24  aload_3 [f]\n    25  invokevirtual Test$Foo.getI() : int [32]\n    28  i2l\n    29  lstore 4 [l]\n    31  aload_1 [iter]\n    32  invokeinterface Iterator.remove() : void [36] [nargs: 1]\n    37  aload_1 [iter]\n    38  invokeinterface Iterator.hasNext() : boolean [39] [nargs: 1]\n    43  ifne 8\n    46  return\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 8, line: 15]\n        [pc: 15, line: 17]\n        [pc: 24, line: 18]\n        [pc: 31, line: 19]\n        [pc: 37, line: 14]\n        [pc: 46, line: 21]\n      Local variable table:\n        [pc: 0, pc: 47] local: this index: 0 type: Test\n        [pc: 5, pc: 46] local: iter index: 1 type: Iterator\n        [pc: 15, pc: 37] local: key index: 2 type: Object\n        [pc: 24, pc: 37] local: f index: 3 type: Foo\n        [pc: 31, pc: 37] local: l index: 4 type: long\n      Local variable type table:\n        [pc: 0, pc: 47] local: this index: 0 type: Test<X>\n        [pc: 5, pc: 46] local: iter index: 1 type: Iterator<X>\n        [pc: 24, pc: 37] local: f index: 3 type: String>\n      Stack map table: number of frames 2\n        [pc: 8, append: {Iterator}]\n        [pc: 37, same]\n    RuntimeVisibleTypeAnnotations: \n      #55 @Flowannotation(\n        target type = 0x47 CAST\n        offset = 24\n        type argument index = 0\n      )\n      #55 @Flowannotation(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 24, pc: 37] index: 3\n        location = [INNER_TYPE]\n      )\n      #55 @Flowannotation(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 24, pc: 37] index: 3\n        location = [INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n      #55 @Flowannotation(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 31, pc: 37] index: 4\n      )\n";
        this.checkClassFile("Test", source, expectedOutput, 9);
    }

    public void testBug470665() throws Exception {
        boolean apt = this.enableAPT;
        String errMessage = this.isMinimumCompliant(0x370000L) ? "----------\n1. ERROR in A.java (at line 10)\n\t};\n\t^\nSyntax error on token \"}\", delete this token\n----------\n----------\n" : "----------\n1. ERROR in A.java (at line 10)\n\t};\n\t^\nSyntax error on token \"}\", delete this token\n----------\n----------\n1. WARNING in B.java (at line 12)\n\tX x = new X();\n\t      ^^^^^^^\nAccess to enclosing constructor B.X() is emulated by a synthetic accessor method\n----------\n";
        String[] sources = new String[]{"A.java", "public final class A {\n\tString myString;\n\tpublic interface B {\n\t\tvoid test();\n\t}\n\tprivate final B b = new B() {\n\t\t@Override\n\t\tpublic void test() {}\n\t}\n};\n}", "B.java", "public class B {\n\t  private static class X {\n\t    static final Object instance1;\n\t    static {\n\t      try {\n\t        instance1 = new Object();\n\t      } catch (Throwable e) {\n\t        throw new AssertionError(e);\n\t      }\n\t    }\n\t  }\n\t  X x = new X();\n\t  Object o = X.instance1;\n}"};
        try {
            this.enableAPT = true;
            this.runNegativeTest(sources, errMessage);
        }
        finally {
            this.enableAPT = apt;
        }
    }

    public void testBug506888a() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        runner.testFiles = new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"incomplete-switch\"})\n\tvoid foo() {\n\t}\n}\t\n"};
        runner.expectedCompilerLog = "----------\n1. INFO in X.java (at line 3)\n\t@SuppressWarnings({\"incomplete-switch\"})\n\t                   ^^^^^^^^^^^^^^^^^^^\nAt least one of the problems in category 'incomplete-switch' is not analysed due to a compiler option being ignored\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug506888b() throws Exception {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"incomplete-switch\"})\n\tvoid foo(Color c) {\n\t\tswitch(c) {\n\t\t}\n\t}\n\tenum Color { BLUE, RED; } \n}\t\n"}, options);
    }

    public void testBug506888c() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.missingDefaultCase", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "warning");
        runner.testFiles = new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"incomplete-switch\", \"unchecked\"})\n\tvoid foo(Color c) {\n\t\tswitch(c) {\n\t\t}\n\t}\n\tenum Color { BLUE, RED; } \n}\t\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in X.java (at line 3)\n\t@SuppressWarnings({\"incomplete-switch\", \"unchecked\"})\n\t                                        ^^^^^^^^^^^\nUnnecessary @SuppressWarnings(\"unchecked\")\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings;
        runner.runWarningTest();
    }

    public void testBug506888d() throws Exception {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"incomplete-switch\"})\n\tvoid foo() {\n\t}\n}\t\n"}, "", null, true, options);
    }

    public void testBug506888e() throws Exception {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"unused\"})\n\tvoid foo() {}\n}\t\n"}, "", null, true, options);
    }

    public void testBug506888f() throws Exception {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        class MyCompilerRequestor
        implements ICompilerRequestor {
            String[] problemArguments = null;

            MyCompilerRequestor() {
            }

            public void acceptResult(CompilationResult result) {
                CategorizedProblem[] categorizedProblemArray = result.getAllProblems();
                int n = categorizedProblemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CategorizedProblem problem = categorizedProblemArray[n2];
                    String[] arguments = problem.getArguments();
                    if (arguments != null && arguments.length > 0) {
                        this.problemArguments = arguments;
                        return;
                    }
                    ++n2;
                }
            }
        }
        MyCompilerRequestor requestor = new MyCompilerRequestor();
        this.runTest(new String[]{"X.java", "public class X {\n\t\n\t@SuppressWarnings({\"unused\"})\n\tvoid foo() {\n\t}\n}\t\n"}, false, "----------\n1. INFO in X.java (at line 3)\n\t@SuppressWarnings({\"unused\"})\n\t                   ^^^^^^^^\nAt least one of the problems in category 'unused' is not analysed due to a compiler option being ignored\n----------\n", "", "", false, null, true, null, options, (ICompilerRequestor)new Requestor(true, requestor, false, true), AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
        AnnotationTest.assertNotNull((Object)requestor.problemArguments);
        AnnotationTest.assertEquals((int)1, (int)requestor.problemArguments.length);
        AnnotationTest.assertEquals("org.eclipse.jdt.core.compiler.problem.unusedParameter", requestor.problemArguments[0]);
    }

    public void testBug537593_001() {
        String[] opts;
        String[] files = new String[]{"X.java", "\npublic class X {\n\n\tprotected void bar(Z z) {\n\t\tSystem.out.println(z.toString());\n\t}\n\n\tpublic void foo() {\n\t\tbar(() -> {\n\t\t\tfoo2(new I() {\n\t\t\t\t@SuppressWarnings({\"unused\"})\n\t\t\t\tpublic void bar2() {}\n\t\t\t});\n\t\t});\n\t}\n\tpublic static void main(String[] args) {}\n\n\tpublic Z foo2(I i) {\n\t\treturn i == null ? null : null;\n\t}\n}\n\ninterface Z {\n\tvoid apply();\n}\n\ninterface I {}\n\n"};
        Map<String, String> options = this.getCompilerOptions();
        String[] stringArray = opts = new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", "org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter", "org.eclipse.jdt.core.compiler.problem.unusedImport", "org.eclipse.jdt.core.compiler.problem.unusedLabel", "org.eclipse.jdt.core.compiler.problem.unusedLocal", "org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "org.eclipse.jdt.core.compiler.problem.unusedParameter", "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", "org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments"};
        int n = opts.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            options.put(option, "warning");
            ++n2;
        }
        class MyCompilerRequestor
        implements ICompilerRequestor {
            String[] problemArguments = null;

            MyCompilerRequestor() {
            }

            public void acceptResult(CompilationResult result) {
                CategorizedProblem[] categorizedProblemArray = result.getAllProblems();
                int n = categorizedProblemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CategorizedProblem problem = categorizedProblemArray[n2];
                    String[] arguments = problem.getArguments();
                    if (arguments != null && arguments.length > 0) {
                        this.problemArguments = arguments;
                        return;
                    }
                    ++n2;
                }
            }
        }
        MyCompilerRequestor requestor = new MyCompilerRequestor();
        this.runTest(files, false, "", "", "", false, null, true, null, options, (ICompilerRequestor)new Requestor(true, requestor, false, true), AbstractRegressionTest.JavacTestOptions.DEFAULT);
        AnnotationTest.assertNull((Object)requestor.problemArguments);
    }

    public void testBug542520a() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        runner.testFiles = new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\nimport org.junit.jupiter.params.provider.MethodSource;\npublic class ExampleTest {\n\n\t @MethodSource(\"getIntegers\")\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> getIntegers() {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testBug542520b() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        runner.testFiles = new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\npublic class ExampleTest {\n\n\t @org.junit.jupiter.params.provider.MethodSource(\"getIntegers\")\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> getIntegers() {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testBug542520c() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        runner.testFiles = new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\nimport org.junit.jupiter.params.provider.MethodSource;\npublic class ExampleTest {\n\n\t @MethodSource\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> testIntegers() {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testBug542520d() throws Exception {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runNegativeTest(true, new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\nimport org.junit.jupiter.params.provider.MethodSource;\npublic class ExampleTest {\n\n\t @MethodSource(\"getIntegers\")\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> getIntegers(int i) {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in ExampleTest.java (at line 9)\n\tprivate static List<Integer> getIntegers(int i) {\n\t                             ^^^^^^^^^^^^^^^^^^\nThe method getIntegers(int) from the type ExampleTest is never used locally\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug546084a() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        runner.testFiles = new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\nimport org.junit.jupiter.params.provider.MethodSource;\npublic class ExampleTest {\n\n\t private final String TEST_METHOD_PREFIX = \"get\";\n\t @MethodSource(TEST_METHOD_PREFIX + \"Integers\")\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> getIntegers() {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testBug546084b() throws Exception {
        this.runNegativeTest(new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\nimport org.junit.jupiter.params.provider.MethodSource;\npublic class ExampleTest {\n\n\t @MethodSource(Object.class)\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> getIntegers(int i) {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"}, "----------\n1. ERROR in ExampleTest.java (at line 6)\n\t@MethodSource(Object.class)\n\t              ^^^^^^^^^^^^\nType mismatch: cannot convert from Class<Object> to String[]\n----------\n2. WARNING in ExampleTest.java (at line 9)\n\tprivate static List<Integer> getIntegers(int i) {\n\t                             ^^^^^^^^^^^^^^^^^^\nThe method getIntegers(int) from the type ExampleTest is never used locally\n----------\n");
    }

    public void testBug546084c() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        runner.testFiles = new String[]{"org/junit/jupiter/params/provider/MethodSource.java", "package org.junit.jupiter.params.provider;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Target({ElementType.ANNOTATION_TYPE, ElementType.METHOD})\n@Retention(RetentionPolicy.RUNTIME)\npublic @interface MethodSource {\n\n\tString[] value() default \"\";\n\n}", "ExampleTest.java", "import java.util.Arrays;\nimport java.util.List;\nimport org.junit.jupiter.params.provider.MethodSource;\npublic class ExampleTest {\n\n\t @MethodSource({ \"getIntegers\" })\n\t void testIntegers(Integer integer) {}\n\t \n\t private static List<Integer> getIntegers() {\n\t\treturn Arrays.asList(0, 5, 1);\n\t}\n}\n"};
        runner.runConformTest();
    }

    public void testBug490698_comment16() {
        this.runConformTest(new String[]{"foo/bar/AnnotationError.java", "package foo.bar;\n\nimport static java.lang.annotation.ElementType.FIELD;\nimport static java.lang.annotation.RetentionPolicy.RUNTIME;\n\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport java.util.function.Predicate;\n\npublic class AnnotationError<T> {\n\n\tpublic enum P {\n\t\tAAA\n\t}\n\n\t@Target(FIELD)\n\t@Retention(RUNTIME)\n\tpublic @interface A {\n\t\tP value();\n\t}\n\n\t@Target(FIELD)\n\t@Retention(RUNTIME)\n\tpublic @interface FF {\n\t}\n\n\tpublic static class Bool extends AnnotationError<Boolean> {\n\t}\n\n\t@A(P.AAA)\n\t@FF\n\tpublic static final AnnotationError.Bool FOO = new AnnotationError.Bool();\n}\n"});
    }

    public void testBugVisibility() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString z() { return Y.MSG; }\n\t@Deprecated(since = Y.MSG)\n\tstatic class Y {\n\t\tprivate final static String MSG = \"msg\";\n\t}\n}"}, "");
    }

    public void testIssue2400() {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        Map<String, String> customOptions = this.getCompilerOptions();
        String bkup = customOptions.get("org.eclipse.jdt.core.compiler.annotation.nullanalysis");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        try {
            this.runNegativeTest(new String[]{"TestClass.java", "package test;\n@com.Missing\n@java.lang.Deprecated\npublic class TestClass {\n}", "com.java", "package test;\npublic class com {\n\ttest.TestClass value;}"}, "----------\n1. ERROR in TestClass.java (at line 2)\n\t@com.Missing\n\t ^^^^^^^^^^^\ncom.Missing cannot be resolved to a type\n----------\n----------\n1. WARNING in com.java (at line 3)\n\ttest.TestClass value;}\n\t     ^^^^^^^^^\nThe type TestClass is deprecated\n----------\n", null, true, customOptions);
        }
        finally {
            customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", bkup);
        }
    }

    public void testIssue4107() {
        if (this.complianceLevel < 0x350000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tZork z = null;\n}\n\n@interface MyAnnot {\n\tshort values()[];\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 6)\n\tshort values()[];\n\t      ^^^^^^^^^^\nExtended dimensions are discouraged in an annotation attribute declaration\n----------\n", null, true);
    }

    public void testGH4243() throws Exception {
        if (this.complianceLevel < 0x3C0000L) {
            return;
        }
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = this.getCompilerOptions();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", "p.nonnullbydefault");
        runner.testFiles = new String[]{"p/Main.java", "package p;\nimport java.lang.annotation.*;\n\n@nonnullbydefault\n@Main.NeededAnnotation\npublic final class Main {\n\n   public static void main(String[] args) {\n      for (Annotation anno : Main.class.getAnnotations()) {\n         System.out.println(anno);\n      }\n   }\n\n   public record Foo(String needed) {}\n\n   @Retention(RetentionPolicy.RUNTIME)\n   @interface NeededAnnotation {}\n}\n", "p/nonnullbydefault.java", "package p;\npublic @interface nonnullbydefault {}\n"};
        runner.expectedOutputString = "@p.Main.NeededAnnotation()";
        runner.runConformTest();
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "p" + File.separator + "Main.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "@p.nonnullbydefault\n@p.Main.NeededAnnotation\npublic final class p.Main {\n";
        if (actualOutput.indexOf(expectedOutput) == -1) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        AnnotationTest.assertTrue((String)"unexpected bytecode sequence", (actualOutput.indexOf(expectedOutput) != -1 ? 1 : 0) != 0);
    }
}

