/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ArrayTest
extends AbstractRegressionTest {
    public ArrayTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ArrayTest.buildAllCompliancesTestSuite(ArrayTest.testClass());
    }

    public static Class testClass() {
        return ArrayTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int[] x= new int[] {,};\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n        float[] tab = new float[] {-0.0f};\n        System.out.print(tab[0]);\n    }\n}"}, "-0.0");
    }

    public void test003() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n        float[] tab = new float[] {0.0f};\n        System.out.print(tab[0]);\n    }\n}"}, "0.0");
    }

    public void test004() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n        int[] tab = new int[] {-0};\n        System.out.print(tab[0]);\n    }\n}"}, "0");
    }

    public void test005() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t private static final Object X[] = new Object[]{null,null};\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  static {};\n    0  iconst_2\n    1  anewarray java.lang.Object [3]\n    4  putstatic X.X : java.lang.Object[] [9]\n    7  return\n      Line numbers:\n        [pc: 0, line: 2]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            ArrayTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tchar[][][] array = new char[][][10];\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tchar[][][] array = new char[][][10];\n\t                                ^^\nCannot specify an array dimension after an empty dimension\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic long lfield;\n\t\n\tpublic static void main(String[] args) {\n\t\tlfield = args.length;\n\t\tlfield = args(args).length;\n\t\t\n\t}\n\tstatic String[] args(String[] args) {\n\t\treturn args;\n\t}\n}\n"}, "");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic String getTexts(int i) [] {\n\t\tString[] texts = new String[1];\n\t\treturn texts; \n\t}\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tX x = { 10, zork() };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX x = { 10, zork() };\n\t      ^^^^^^^^^^^^^^\nType mismatch: cannot convert from int[] to X\n----------\n2. ERROR in X.java (at line 3)\n\tX x = { 10, zork() };\n\t            ^^^^\nThe method zork() is undefined for the type X\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tint i = {};\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = {};\n\t        ^^\nType mismatch: cannot convert from Object[] to int\n----------\n");
    }

    public void test011() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tObject[][] all = new String[1][];\n\t\t\tall[0] = new Object[0];\n\t\t} catch (ArrayStoreException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_1\n     1  anewarray java.lang.String[] [16]\n     4  astore_1 [all]\n     5  aload_1 [all]\n     6  iconst_0\n     7  iconst_0\n     8  anewarray java.lang.Object [3]\n    11  aastore\n    12  goto 24\n    15  astore_1 [e]\n    16  getstatic java.lang.System.out : java.io.PrintStream [18]\n    19  ldc <String \"SUCCESS\"> [24]\n    21  invokevirtual java.io.PrintStream.println(java.lang.String) : void [26]\n    24  return\n      Exception Table:\n        [pc: 0, pc: 12] -> 15 when : java.lang.ArrayStoreException\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 5, line: 5]\n        [pc: 12, line: 6]\n        [pc: 16, line: 7]\n        [pc: 24, line: 9]\n      Local variable table:\n        [pc: 0, pc: 25] local: args index: 0 type: java.lang.String[]\n        [pc: 5, pc: 12] local: all index: 1 type: java.lang.Object[][]\n        [pc: 16, pc: 24] local: e index: 1 type: java.lang.ArrayStoreException\n";
        File f = new File(OUTPUT_DIR + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ArrayTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test012() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.Map;\n\npublic class X {\n\tMap fValueMap;\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic Object[][] getAllChoices() {\n\t\tObject[][] all = new String[this.fValueMap.size()][];\n\t\treturn all;\n\t}\n}"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #35 ()[[Ljava/lang/Object;\n  // Stack: 1, Locals: 2\n  public java.lang.Object[][] getAllChoices();\n     0  aload_0 [this]\n     1  getfield X.fValueMap : java.util.Map [36]\n     4  invokeinterface java.util.Map.size() : int [38] [nargs: 1]\n     9  anewarray java.lang.String[] [44]\n    12  astore_1 [all]\n    13  aload_1 [all]\n    14  areturn\n      Line numbers:\n        [pc: 0, line: 10]\n        [pc: 13, line: 11]\n      Local variable table:\n        [pc: 0, pc: 15] local: this index: 0 type: X\n        [pc: 13, pc: 15] local: all index: 1 type: java.lang.Object[][]\n";
        File f = new File(OUTPUT_DIR + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ArrayTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    String[] m(String arg) {\n        System.out.println(argument + argument);\n        return new String[] { argument + argument, argument/*no problem*/ };\n    }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(argument + argument);\n\t                   ^^^^^^^^\nargument cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 3)\n\tSystem.out.println(argument + argument);\n\t                              ^^^^^^^^\nargument cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 4)\n\treturn new String[] { argument + argument, argument/*no problem*/ };\n\t                      ^^^^^^^^\nargument cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 4)\n\treturn new String[] { argument + argument, argument/*no problem*/ };\n\t                                 ^^^^^^^^\nargument cannot be resolved to a variable\n----------\n5. ERROR in X.java (at line 4)\n\treturn new String[] { argument + argument, argument/*no problem*/ };\n\t                                           ^^^^^^^^\nargument cannot be resolved to a variable\n----------\n");
    }

    public void test014() throws Exception {
        Map<String, String> optionsMap = this.getCompilerOptions();
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(long[] longs) throws Exception {\n\t\tlong[] other = longs.clone();\n\t}\n}\n"}, "", optionsMap);
    }

    public void test015() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(long[] longs) throws Exception {\n\t\tlong[] other = longs.clone();\n\t}\n}\n"}, "");
    }

    public void test016() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(long[] longs) throws Exception {\n\t\tObject other = longs.clone();\n\t}\n}\n"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([J)V\n  // Stack: 1, Locals: 3\n  void foo(long[] longs) throws java.lang.Exception;\n    0  aload_1 [longs]\n    1  invokevirtual long[].clone() : java.lang.Object [19]\n    4  astore_2 [other]\n    5  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 5, line: 4]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            ArrayTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test017() throws Exception {
        Map<String, String> optionsMap = this.getCompilerOptions();
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(long[] longs) throws Exception {\n\t\tObject other = longs.clone();\n\t}\n}\n"}, "", null, true, null, optionsMap, null);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([J)V\n  // Stack: 1, Locals: 3\n  void foo(long[] longs) throws java.lang.Exception;\n    0  aload_1 [longs]\n    1  invokevirtual long[].clone() : java.lang.Object [19]\n    4  astore_2 [other]\n    5  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 5, line: 4]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            ArrayTest.assertEquals("unexpected bytecode sequence", expectedOutput, actualOutput);
        }
    }

    public void test018() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X<p> {\n\tvoid foo(p.O[] elems)  {\n\t}\n   void bar() {\n        foo(new Object[0]);\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(p.O[] elems)  {\n\t         ^^^^^\nIllegal qualified access from the type parameter p\n----------\n2. ERROR in X.java (at line 5)\n\tfoo(new Object[0]);\n\t^^^\nThe method foo(Object[]) is undefined for the type X<p>\n----------\n");
    }

    public void test019() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tX [][][] x = new X[10][10][];\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }
}

