/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class BatchCompilerTest2
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return BatchCompilerTest2.buildMinimalComplianceTestSuite(BatchCompilerTest2.testClass(), 256);
    }

    public static Class testClass() {
        return BatchCompilerTest2.class;
    }

    public BatchCompilerTest2(String name) {
        super(name);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\tZork z;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -10 --enable-preview", "", "Preview of features is supported only at the latest source level\n", true);
    }

    public void test002() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\tZork z;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --enable-preview -" + CompilerOptions.getLatestVersion() + " ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (Integer  x, var y) -> {System.out.println(\"SUCCESS \" + x);};\n        lam.apply(20, 200);\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer z);\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --enable-preview -" + CompilerOptions.getLatestVersion() + " ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tI lam = (Integer  x, var y) -> {System.out.println(\"SUCCESS \" + x);};\n\t                         ^\n'var' cannot be mixed with non-var parameters\n----------\n1 problem (1 error)\n", true);
    }

    public void test004_previewUnused() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --enable-preview -" + CompilerOptions.getLatestVersion() + " ", "", "", true);
        String expectedOutput = ".0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test004_previewUsed() throws Exception {
        this.runConformTest(new String[]{"X.java", "import module java.base;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --enable-preview -" + CompilerOptions.getLatestVersion() + " ", "", "", true);
        String expectedOutput = ".65535, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test006() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -source 11", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 11 : 55.0, super bit)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void testBug540123a() throws Exception {
        this.runConformTest(new String[]{"SecurePrefs.java", "public class SecurePrefs {\n  public SecurePrefs node (String s) {\n\t  System.out.println(s);\n\t  return null;\n  }\n}", "SecurePrefsRoot.java", "public class SecurePrefsRoot extends SecurePrefs {\n\n\tpublic void foo() {\n\t\tSecurePrefs node = node(\"Hello\");\n\t\tif (node != null)\n\t\t\tSystem.out.println(node.toString());\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew SecurePrefsRoot().foo();\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "SecurePrefsRoot.java\" \"" + OUTPUT_DIR + File.separator + "SecurePrefs.java\" -source 1.8 -target 1.8", "", "", true);
        String expectedOutput = "invokevirtual SecurePrefsRoot.node(java.lang.String) : SecurePrefs [14]";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "SecurePrefsRoot.class", "SecurePrefsRoot", expectedOutput);
    }

    public void testBug540123b() throws Exception {
        this.runConformTest(new String[]{"SecurePrefs.java", "public class SecurePrefs {\n  public SecurePrefs node (String s) {\n\t  System.out.println(s);\n\t  return null;\n  }\n}", "SecurePrefsRoot.java", "public class SecurePrefsRoot extends SecurePrefs {\n\n\tpublic void foo() {\n\t\tSecurePrefs node = node(\"Hello\");\n\t\tif (node != null)\n\t\t\tSystem.out.println(node.toString());\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew SecurePrefsRoot().foo();\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "SecurePrefsRoot.java\" \"" + OUTPUT_DIR + File.separator + "SecurePrefs.java\" -source 1.8", "", "", true);
        String expectedOutput = "invokevirtual SecurePrefsRoot.node(java.lang.String) : SecurePrefs [14]";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "SecurePrefsRoot.class", "SecurePrefsRoot", expectedOutput);
    }

    public void testBug540123c() throws Exception {
        this.runConformTest(new String[]{"SecurePrefs.java", "public class SecurePrefs {\n  public SecurePrefs node (String s) {\n\t  System.out.println(s);\n\t  return null;\n  }\n}", "SecurePrefsRoot.java", "public class SecurePrefsRoot extends SecurePrefs {\n\n\tpublic void foo() {\n\t\tSecurePrefs node = node(\"Hello\");\n\t\tif (node != null)\n\t\t\tSystem.out.println(node.toString());\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew SecurePrefsRoot().foo();\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "SecurePrefsRoot.java\" \"" + OUTPUT_DIR + File.separator + "SecurePrefs.java\" -target 1.8", "", "", true);
        String expectedOutput = "invokevirtual SecurePrefsRoot.node(java.lang.String) : SecurePrefs [14]";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "SecurePrefsRoot.class", "SecurePrefsRoot", expectedOutput);
    }

    public void testBug540123d() throws Exception {
        this.runConformTest(new String[]{"SecurePrefs.java", "public class SecurePrefs {\n  public SecurePrefs node (String s) {\n\t  System.out.println(s);\n\t  return null;\n  }\n}", "SecurePrefsRoot.java", "public class SecurePrefsRoot extends SecurePrefs {\n\n\tpublic void foo() {\n\t\tSecurePrefs node = node(\"Hello\");\n\t\tif (node != null)\n\t\t\tSystem.out.println(node.toString());\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew SecurePrefsRoot().foo();\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "SecurePrefsRoot.java\" \"" + OUTPUT_DIR + File.separator + "SecurePrefs.java\" -1.8", "", "", true);
        String expectedOutput = "invokevirtual SecurePrefsRoot.node(java.lang.String) : SecurePrefs [14]";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "SecurePrefsRoot.class", "SecurePrefsRoot", expectedOutput);
    }

    public void testBug540123e() throws Exception {
        this.runConformTest(new String[]{"SecurePrefs.java", "public class SecurePrefs {\n  public SecurePrefs node (String s) {\n\t  System.out.println(s);\n\t  return null;\n  }\n}", "SecurePrefsRoot.java", "public class SecurePrefsRoot extends SecurePrefs {\n\n\tpublic void foo() {\n\t\tSecurePrefs node = node(\"Hello\");\n\t\tif (node != null)\n\t\t\tSystem.out.println(node.toString());\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew SecurePrefsRoot().foo();\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "SecurePrefsRoot.java\" \"" + OUTPUT_DIR + File.separator + "SecurePrefs.java\" -1.8", "", "", true);
        String expectedOutput = "invokevirtual SecurePrefsRoot.node(java.lang.String) : SecurePrefs [14]";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "SecurePrefsRoot.class", "SecurePrefsRoot", expectedOutput);
    }

    public void testBug562473() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -source " + CompilerOptions.getLatestVersion() + " -target " + CompilerOptions.getLatestVersion() + " ", "", "", true);
    }

    public void testBug568802() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        String libPath = currentWorkingDirectoryPath + File.separator + "lib568802.jar";
        try {
            try {
                Util.createJar(new String[]{"hello/World.java;\n", "package hello;\npublic class World {}\n", "module-info.java;\n", "module HelloModule {}\n"}, libPath, "11", false);
                this.runConformTest(new String[]{"X.java", "import hello.World;\npublic class X {\n\t World field = new World();\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" -cp " + libPath + " -source " + CompilerOptions.getLatestVersion() + " -target " + CompilerOptions.getLatestVersion() + " ", "", "", true);
            }
            catch (IOException e) {
                System.err.println("BatchCompilerTest2#testBug568802 could not write to current working directory " + currentWorkingDirectoryPath);
                new File(libPath).delete();
            }
        }
        finally {
            new File(libPath).delete();
        }
    }

    public void testIssue114() {
        this.runNegativeTest(new String[]{"Foo.java", "import com.sun.imageio.plugins.png.PNGImageReader;\nimport com.sun.imageio.plugins.png.PNGImageReaderSpi;\n\npublic class Foo {\n        PNGImageReader r;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "Foo.java\" --release 9 --add-exports java.desktop/com.sun.imageio.plugins.png=ALL-UNNAMED", "", "Exporting a package from system module 'java.desktop' is not allowed with --release\n", true);
    }

    public void testIssue147() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.reflect.Method;\n\n\npublic class X {\n\tpublic final Object invoke(Object self) throws Throwable {\n\n\t\t\tMethod method = null;\n\t\t\ttry {\n\t\t\t\tMethodHandle methodHandle = MethodHandles.lookup().unreflect(method );\n\t\t\t\treturn methodHandle.invoke(self);\n\t\t\t} catch (IllegalArgumentException e) {\n\t\t\t\tthrow e;\n\t\t\t} \n\t\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" --release 9 ", "", "", true);
        String expectedOutput = "java.lang.invoke.MethodHandle.invoke(java.lang.Object)";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }
}

