/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;

public class BatchCompilerTest_15
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return BatchCompilerTest_15.buildMinimalComplianceTestSuite(BatchCompilerTest_15.testClass(), 4096);
    }

    public static Class testClass() {
        return BatchCompilerTest_15.class;
    }

    public BatchCompilerTest_15(String name) {
        super(name);
    }

    public void testBug564047_001() {
        if (!AbstractBatchCompilerTest.isJREVersionEqualTo("15")) {
            return;
        }
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            System.err.println("BatchCompilerTest#testBug564047_001 could not access the current working directory " + currentWorkingDirectoryPath);
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            System.err.println("BatchCompilerTest#testBug564047_001 current working directory is not a directory " + currentWorkingDirectoryPath);
        } else {
            String lib1Path = currentWorkingDirectoryPath + File.separator + "lib1.jar";
            try {
                try {
                    Util.createJar(new String[]{"p/Y.java", "package p;\npublic sealed class Y permits Z{}", "p/Z.java", "package p;\npublic final class Z extends Y{}"}, lib1Path, "15", true);
                    this.runNegativeTest(new String[]{"src/p/X.java", "package p;\npublic class X extends Y {\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\" -cp " + lib1Path + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\" --release 15 --enable-preview -g -preserveAllLocals -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 2)\n\tpublic class X extends Y {\n\t                       ^\nThe class X with a sealed direct supertype Y should be declared either final, sealed, or non-sealed\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 2)\n\tpublic class X extends Y {\n\t                       ^\nThe class X cannot extend the class Y as it is not a permitted subtype of Y\n----------\n2 problems (2 errors)\n", true);
                }
                catch (IOException e) {
                    System.err.println("BatchCompilerTest#testBug563430_001 could not write to current working directory " + currentWorkingDirectoryPath);
                    new File(lib1Path).delete();
                }
            }
            finally {
                new File(lib1Path).delete();
            }
        }
    }
}

