/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Test;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.BatchCompilerTest;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BatchCompilerTest_17
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return BatchCompilerTest_17.buildMinimalComplianceTestSuite(BatchCompilerTest_17.testClass(), 16384);
    }

    public static Class<BatchCompilerTest_17> testClass() {
        return BatchCompilerTest_17.class;
    }

    public BatchCompilerTest_17(String name) {
        super(name);
    }

    public void testParallelCompilation() throws Throwable {
        Path root = Files.createDirectories(Paths.get(OUTPUT_DIR, new String[0]), new FileAttribute[0]);
        String[] sources = new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().printHello();\n\t\tnew Thread(() -> {\n\t\t\tnew X().printHello();\n\t\t}).start();\n\t}\n\tprivate void printHello() {\n\t\tSystem.out.println(\"Hello \" + Thread.currentThread());\n\t}\n}", "ExampleEnum.java", "public enum ExampleEnum {\n\tA, B, C;\n}\n"};
        int i = 0;
        while (i < sources.length) {
            Files.writeString(root.resolve(sources[i]), (CharSequence)sources[i + 1], new OpenOption[0]);
            i += 2;
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>(this.compileParallel(sources));
        Optional<Object> err = map.values().stream().filter(x -> x instanceof Throwable).findFirst();
        if (err.isPresent()) {
            throw (Throwable)err.get();
        }
    }

    public Map<String, Object> compileParallel(String[] sources) throws Exception {
        int threads = Math.max(16, 2 * Runtime.getRuntime().availableProcessors());
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ConcurrentHashMap<String, Object> results = new ConcurrentHashMap<String, Object>();
        int i = 0;
        while (i < threads) {
            String name = String.format("Compile-Thread-%02d", i);
            executor.execute(() -> {
                Thread.currentThread().setName(name);
                try {
                    try {
                        results.put(name, this.compile(sources, startLatch));
                    }
                    catch (Throwable e) {
                        results.put(name, e);
                        finishLatch.countDown();
                    }
                }
                finally {
                    finishLatch.countDown();
                }
            });
            ++i;
        }
        startLatch.countDown();
        finishLatch.await();
        executor.shutdownNow();
        return results;
    }

    private String compile(String[] sources, CountDownLatch startLatch) throws Exception {
        String folder = "BatchCompilerTest_17_" + Thread.currentThread().getName();
        File outputFolder = new File(OUTPUT_DIR, folder);
        Files.createDirectories(outputFolder.toPath(), new FileAttribute[0]);
        final StringBuilder output = new StringBuilder();
        final StringBuilder error = new StringBuilder();
        startLatch.await();
        this.runTest(true, sources, "\"" + OUTPUT_DIR + File.separator + sources[0] + "\" -g -nowarn -target 11 -source 11 --release 11 -encoding UTF-8 -d \"" + String.valueOf(outputFolder) + "\"", new BatchCompilerTest.SubstringMatcher(""){

            @Override
            boolean match(String out) {
                output.append(out);
                return super.match(out);
            }
        }, new AbstractBatchCompilerTest.Matcher(){

            @Override
            String expected() {
                return Util.EMPTY_STRING;
            }

            @Override
            boolean match(String err) {
                error.append(err);
                return err != null && err.length() == 0;
            }
        }, false);
        return "StdErr: " + String.valueOf(error) + " StdOut: " + String.valueOf(output);
    }

    public void testGHI1774_Expression() throws Exception {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && JavaCore.compareJavaVersions((String)javaVersion, (String)"18") < 0) {
            return;
        }
        String path = LIB_DIR;
        String libPath = null;
        libPath = path.endsWith(File.separator) ? path + "lib.jar" : path + File.separator + "lib.jar";
        org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y;\n\tpublic static Color getColor() {\n\t\treturn R;\n\t}\n}"}, libPath, "18");
        this.runConformTest(new String[]{"src/p/X.java", "package p;\nimport p.Color;\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tColor c = Color.getColor();\n\t\ttry {\n\t\t\tint a = switch (c) {\n\t\t\t\tcase R -> 1;\n\t\t\t\tcase Y -> 2;\n\t\t\t};\n\t\t} catch (IncompatibleClassChangeError e) {\n\t\t\tSystem.out.print(\"OK\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.print(\"NOT OK: \" + e);\n\t\t}\n\t\t\tSystem.out.print(\"END\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\" -cp \"" + LIB_DIR + File.separator + "lib.jar\" -sourcepath \"" + OUTPUT_DIR + File.separator + "src\" -source 18 -warn:none -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], new String[]{"--enable-preview"});
        BatchCompilerTest_17.assertEquals("Incorrect output", "END", this.verifier.getExecutionOutput());
        org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y, B;\n\tpublic static Color getColor() {\n\t\treturn B;\n\t}\n}"}, libPath, "18");
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], new String[]{"--enable-preview"});
        BatchCompilerTest_17.assertEquals("Incorrect output", "OKEND", this.verifier.getExecutionOutput());
    }
}

