/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;

public class BatchCompilerTest_21
extends AbstractBatchCompilerTest {
    public static Test suite() {
        return BatchCompilerTest_21.buildMinimalComplianceTestSuite(BatchCompilerTest_21.testClass(), 262144);
    }

    public static Class<BatchCompilerTest_21> testClass() {
        return BatchCompilerTest_21.class;
    }

    public BatchCompilerTest_21(String name) {
        super(name);
    }

    public void testGHI1774_Expression() throws Exception {
        String path = LIB_DIR;
        String libPath = null;
        libPath = path.endsWith(File.separator) ? path + "lib.jar" : path + File.separator + "lib.jar";
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y;\n\tpublic static Color getColor() {\n\t\treturn R;\n\t}\n}"}, libPath, "20");
        this.runConformTest(new String[]{"src/p/X.java", "package p;\nimport p.Color;\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tColor c = Color.getColor();\n\t\ttry {\n\t\t\tint a = switch (c) {\n             case null -> 0;\n\t\t\t\tcase R -> 1;\n\t\t\t\tcase Y -> 2;\n\t\t\t};\n\t\t} catch (MatchException e) {\n\t\t\tSystem.out.print(\"OK\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.print(\"NOT OK: \" + e);\n\t\t}\n\t\t\tSystem.out.print(\"END\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\" -cp \"" + LIB_DIR + File.separator + "lib.jar\" -sourcepath \"" + OUTPUT_DIR + File.separator + "src\" -source 21 -warn:none -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], new String[]{"--enable-preview"});
        BatchCompilerTest_21.assertEquals("Incorrect output", "END", this.verifier.getExecutionOutput());
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y, B;\n\tpublic static Color getColor() {\n\t\treturn B;\n\t}\n}"}, libPath, "20");
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], new String[]{"--enable-preview"});
        BatchCompilerTest_21.assertEquals("Incorrect output", "OKEND", this.verifier.getExecutionOutput());
    }

    public void testGHI1774_Statement() throws Exception {
        String path = LIB_DIR;
        String libPath = null;
        libPath = path.endsWith(File.separator) ? path + "lib.jar" : path + File.separator + "lib.jar";
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y;\n\tpublic static Color getColor() {\n\t\treturn R;\n\t}\n}"}, libPath, "20");
        this.runConformTest(new String[]{"src/p/X.java", "package p;\nimport p.Color;\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tColor c = Color.getColor();\n\t\ttry {\n\t\t\tswitch (c) {\n             case null -> System.out.println(\"Null\");\n\t\t\t\tcase R -> System.out.print(\"R\");\n\t\t\t\tcase Y -> System.out.println(\"Y\");\n\t\t\t};\n\t\t} catch (MatchException e) {\n\t\t\tSystem.out.print(\"OK!\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.print(\"NOT OK: \" + e);\n\t\t}\n\t\t\tSystem.out.print(\"END\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\" -cp \"" + LIB_DIR + File.separator + "lib.jar\" -sourcepath \"" + OUTPUT_DIR + File.separator + "src\" -source 21 -warn:none -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], new String[0]);
        BatchCompilerTest_21.assertEquals("Incorrect output", "REND", this.verifier.getExecutionOutput());
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y, B;\n\tpublic static Color getColor() {\n\t\treturn B;\n\t}\n}"}, libPath, "20");
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], new String[0]);
        BatchCompilerTest_21.assertEquals("Incorrect output", "OK!END", this.verifier.getExecutionOutput());
    }

    public void testIssue558_1() throws Exception {
        String path = LIB_DIR;
        String libPath = null;
        libPath = path.endsWith(File.separator) ? path + "lib.jar" : path + File.separator + "lib.jar";
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y;\n\tpublic static Color getColor() {\n\t\treturn R;\n\t}\n}"}, libPath, "21");
        this.runConformTest(new String[]{"src/p/X.java", "package p;\nimport p.Color;\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tColor c = Color.getColor();\n\t\ttry {\n\t\t\tint a = switch (c) {\n\t\t\t\tcase R -> 1;\n\t\t\t\tcase Y -> 2;\n\t\t\t};\n\t\t} catch (MatchException e) {\n\t\t\tSystem.out.print(\"OK\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.print(\"NOT OK: \" + e);\n\t\t}\n\t\t\tSystem.out.print(\"END\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\" -cp \"" + LIB_DIR + File.separator + "lib.jar\" -sourcepath \"" + OUTPUT_DIR + File.separator + "src\" -source 21 -warn:none -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], null);
        BatchCompilerTest_21.assertEquals("Incorrect output", "END", this.verifier.getExecutionOutput());
        Util.createJar(new String[]{"p/Color.java", "package p;\npublic enum Color {\n\tR, Y, B;\n\tpublic static Color getColor() {\n\t\treturn B;\n\t}\n}"}, libPath, "21");
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], null);
        BatchCompilerTest_21.assertEquals("Incorrect output", "OKEND", this.verifier.getExecutionOutput());
    }

    public void testIssue558_2() throws Exception {
        String path = LIB_DIR;
        String libPath = null;
        libPath = path.endsWith(File.separator) ? path + "lib.jar" : path + File.separator + "lib.jar";
        Util.createJar(new String[]{"p/I.java", "package p;\npublic sealed interface I {\n\tpublic static I getImpl() {\n\t\treturn new A();\n\t}\n}\nfinal class A implements I {}\nfinal class B implements I {}"}, libPath, "21");
        this.runConformTest(new String[]{"src/p/X.java", "package p;\nimport p.I;\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tI i = I.getImpl();\n\t\ttry {\n\t\t\tint r = switch (i) {\n\t\t\t\tcase A a -> 1;\n\t\t\t\tcase B b -> 2;\n\t\t\t};\n\t\t} catch (MatchException e) {\n\t\t\tSystem.out.print(\"OK\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.print(\"NOT OK: \" + e);\n\t\t}\n\t\t\tSystem.out.print(\"END\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\" -cp \"" + LIB_DIR + File.separator + "lib.jar\" -sourcepath \"" + OUTPUT_DIR + File.separator + "src\" -source 21 -warn:none -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], null);
        BatchCompilerTest_21.assertEquals("Incorrect output", "END", this.verifier.getExecutionOutput());
        Util.createJar(new String[]{"p/I.java", "package p;\npublic sealed interface I {\n\tpublic static I getImpl() {\n\t\treturn new C();\n\t}\n}\nfinal class A implements I {}\nfinal class B implements I {}\nfinal class C implements I {}"}, libPath, "21");
        this.verifier.execute("p.X", new String[]{OUTPUT_DIR + File.separator + "bin", libPath}, new String[0], null);
        BatchCompilerTest_21.assertEquals("Incorrect output", "OKEND", this.verifier.getExecutionOutput());
    }
}

