/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class BinaryLiteralTest
extends AbstractRegressionTest {
    public BinaryLiteralTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BinaryLiteralTest.buildMinimalComplianceTestSuite(BinaryLiteralTest.testClass(), 32);
    }

    public static Class testClass() {
        return BinaryLiteralTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b001);\n\t}\n}"}, "1");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0b);\n\t                   ^^\nInvalid binary literal number (only '0' and '1' are expected)\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b2);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0b2);\n\t                   ^^\nInvalid binary literal number (only '0' and '1' are expected)\n----------\n");
    }

    public void test004() {
        Map<String, String> customedOptions = this.getCompilerOptions();
        customedOptions.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        customedOptions.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        customedOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b1110000);\n\t}\n}"}, "", null, true, customedOptions);
    }

    public void test005() {
        Map<String, String> customedOptions = this.getCompilerOptions();
        customedOptions.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        customedOptions.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        customedOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(-0b1110000);\n\t}\n}"}, "", null, true, customedOptions);
    }

    public void test006() {
        Map<String, String> customedOptions = this.getCompilerOptions();
        customedOptions.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        customedOptions.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        customedOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0b1113000);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(0b1113000);\n\t                        ^^^^\nSyntax error on token \"3000\", delete this token\n----------\n", null, true, customedOptions);
    }
}

