/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BootstrapMethodAttributeTest
extends AbstractRegressionTest {
    public BootstrapMethodAttributeTest(String name) {
        super(name);
    }

    public static Class testClass() {
        return BootstrapMethodAttributeTest.class;
    }

    public static Test suite() {
        return BootstrapMethodAttributeTest.buildMinimalComplianceTestSuite(BootstrapMethodAttributeTest.testClass(), 32);
    }

    public void test001() throws Exception {
        String expectedOutput;
        String path;
        byte[] classFileBytes;
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String actualOutput = disassembler.disassemble(classFileBytes = Util.getFileByteContent((File)new File(path = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "TestBootstrapMethodAtt.class")), "\n", 1);
        int index = actualOutput.indexOf(expectedOutput = "//  (version 1.2 : 46.0, no super bit)\npublic class test.G {\n  \n  // Method descriptor #2 ()V\n  // Stack: 0, Locals: 0\n  public static void call();\n    0  invokedynamic 0 dyn() : void [18]\n    5  return\n\nBootstrap methods:\n  0 : # 17 arguments: {#1}\n}");
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            BootstrapMethodAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }
}

