/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;

public class ClassFileReaderTest_17
extends AbstractRegressionTest {
    public static Test suite() {
        return ClassFileReaderTest_17.buildMinimalComplianceTestSuite(ClassFileReaderTest_17.testClass(), 16384);
    }

    public static Class testClass() {
        return ClassFileReaderTest_17.class;
    }

    public ClassFileReaderTest_17(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.complianceLevel = 0x3D0000L;
    }

    public void testBug564227_001() throws Exception {
        String source = "sealed class X permits Y, Z{\n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}\nfinal class Y extends X{}\nfinal class Z extends X{}\n";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        char[][] permittedSubtypesNames = classFileReader.getPermittedSubtypesNames();
        ClassFileReaderTest_17.assertEquals((int)2, (int)permittedSubtypesNames.length);
        char[][] expected = new char[][]{"Y".toCharArray(), "Z".toCharArray()};
        ClassFileReaderTest_17.assertTrue((boolean)CharOperation.equals((char[][])permittedSubtypesNames, (char[][])expected));
    }

    public void testBug565782_001() throws Exception {
        String source = "sealed interface I {}\nenum X implements I {\n    ONE {};\n    public static void main(String[] args) {\n        System.out.println(0);\n   }\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        char[][] permittedSubtypesNames = classFileReader.getPermittedSubtypesNames();
        ClassFileReaderTest_17.assertEquals((int)1, (int)permittedSubtypesNames.length);
        char[][] expected = new char[][]{"X$1".toCharArray()};
        ClassFileReaderTest_17.assertTrue((boolean)CharOperation.equals((char[][])permittedSubtypesNames, (char[][])expected));
        int modifiers = classFileReader.getModifiers();
        ClassFileReaderTest_17.assertTrue((String)"sealed modifier expected", ((modifiers & 0x10000000) != 0 ? 1 : 0) != 0);
    }

    public void testBug565782_002() throws Exception {
        String source = "sealed interface I {}\nclass X {\n\tenum E implements I {\n   \tONE {};\n\t}\n   public static void main(String[] args) {\n      \tSystem.out.println(0);\n   }\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X.E", "X$E", source);
        char[][] permittedSubtypesNames = classFileReader.getPermittedSubtypesNames();
        ClassFileReaderTest_17.assertEquals((int)1, (int)permittedSubtypesNames.length);
        char[][] expected = new char[][]{"X$E$1".toCharArray()};
        ClassFileReaderTest_17.assertTrue((boolean)CharOperation.equals((char[][])permittedSubtypesNames, (char[][])expected));
        int modifiers = classFileReader.getModifiers();
        ClassFileReaderTest_17.assertTrue((String)"sealed modifier expected", ((modifiers & 0x10000000) != 0 ? 1 : 0) != 0);
    }

    public void testBug545510_1() throws Exception {
        String source = "strictfp class X {\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        int modifiers = classFileReader.getModifiers();
        ClassFileReaderTest_17.assertTrue((String)"strictfp modifier not expected", ((modifiers & 0x800) == 0 ? 1 : 0) != 0);
    }

    public void testBug545510_2() throws Exception {
        String source = "class X {\n  strictfp void foo() {}\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod[] methods = classFileReader.getMethods();
        IBinaryMethod method = methods[1];
        int modifiers = method.getModifiers();
        ClassFileReaderTest_17.assertTrue((String)"strictfp modifier not expected", ((modifiers & 0x800) == 0 ? 1 : 0) != 0);
    }

    public void testBug545510_3() throws Exception {
        String source = "strictfp class X {\n  void foo() {}\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod[] methods = classFileReader.getMethods();
        IBinaryMethod method = methods[1];
        int modifiers = method.getModifiers();
        ClassFileReaderTest_17.assertTrue((String)"strictfp modifier not expected", ((modifiers & 0x800) == 0 ? 1 : 0) != 0);
    }

    public void testWildcardBinding() throws Exception {
        String source = "public class X {    \n    public static void main(String[] args) {\n\t\tgetHasValue().addValueChangeListener(evt -> {System.out.println(\"hello\");});\t\t\n    }\n    public static HasValue<?, ?> getHasValue() { \n        return new HasValue<HasValue.ValueChangeEvent<String>, String>() { \n\t\t\t@Override\n\t\t\tpublic void addValueChangeListener(\n\t\t\t\t\tHasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<String>> listener) {\n\t\t\t\tlistener.valueChanged(null);\n\t\t\t}\n\t\t};\n    }    \n}\n\ninterface HasValue<E extends HasValue.ValueChangeEvent<V>,V> {    \n    public static interface ValueChangeEvent<V> {}    \n    public static interface ValueChangeListener<E extends HasValue.ValueChangeEvent<?>> {\n        void valueChanged(E event);\n    }    \n    void addValueChangeListener(HasValue.ValueChangeListener<? super E> listener);\n}\n";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod[] methods = classFileReader.getMethods();
        IBinaryMethod method = methods[3];
        String name = new String(method.getSelector());
        ClassFileReaderTest_17.assertTrue((String)"invalid name", (boolean)"lambda$0".equals(name));
        String descriptor = new String(method.getMethodDescriptor());
        ClassFileReaderTest_17.assertTrue((String)"invalid descriptor", (boolean)"(LHasValue$ValueChangeEvent;)V".equals(descriptor));
    }
}

