/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;

public class ClassFileReaderTest_1_8
extends AbstractRegressionTest {
    public static Test suite() {
        return ClassFileReaderTest_1_8.buildMinimalComplianceTestSuite(ClassFileReaderTest_1_8.testClass(), 32);
    }

    public static Class testClass() {
        return ClassFileReaderTest_1_8.class;
    }

    public ClassFileReaderTest_1_8(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.complianceLevel = CompilerOptions.getFirstSupportedJdkLevel();
    }

    public void test001_classTypeParameter() throws Exception {
        String source = "import java.lang.annotation.*;\npublic class X<@Foo T1,@Bar(iii=99) T2> {}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int iii() default -1;\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryTypeAnnotation[] typeAnnotations = classFileReader.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; CLASS_TYPE_PARAMETER(type_parameter_index=0)", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(iii=(int)99) CLASS_TYPE_PARAMETER(type_parameter_index=1)", this.printTypeAnnotation(typeAnnotations[1]));
    }

    public void test001a_classTypeParameterDifferingRetentions() throws Exception {
        String source = "import java.lang.annotation.*;\npublic class X<@Foo T1,@Bar(iii=99) T2> {}\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int iii() default -1;\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryTypeAnnotation[] typeAnnotations = classFileReader.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(iii=(int)99) CLASS_TYPE_PARAMETER(type_parameter_index=1)", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; CLASS_TYPE_PARAMETER(type_parameter_index=0)", this.printTypeAnnotation(typeAnnotations[1]));
    }

    public void test002_methodTypeParameter() throws Exception {
        String source = "import java.lang.annotation.*;\npublic class X {\n\t<@Foo T1, @Bar(3) T2> void foo(T1 t1,T2 t2) {}\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_TYPE_PARAMETER(type_parameter_index=0)", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_TYPE_PARAMETER(type_parameter_index=1)", this.printTypeAnnotation(typeAnnotations[1]));
    }

    public void test003_classExtends() throws Exception {
        this.complianceLevel = CompilerOptions.getFirstSupportedJdkLevel();
        String source = "import java.lang.annotation.*;\npublic class X extends @Foo @Bar(iii=34) Object implements java.io.@Bar(iii=1) Serializable {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int iii() default -1;\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryTypeAnnotation[] typeAnnotations = classFileReader.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertEquals((int)3, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; CLASS_EXTENDS(type_index=-1)", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(iii=(int)34) CLASS_EXTENDS(type_index=-1)", this.printTypeAnnotation(typeAnnotations[1]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(iii=(int)1) CLASS_EXTENDS(type_index=0)", this.printTypeAnnotation(typeAnnotations[2]));
    }

    public void test004_classExtends() throws Exception {
        String source = "import java.lang.annotation.*;\npublic class X extends Y<@Foo String,@Bar Integer> implements I<@Foo String> {\n}\nclass Y<T1, T2> {}\ninterface I<T1> {}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int iii() default -1;\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryTypeAnnotation[] typeAnnotations = classFileReader.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertEquals((int)3, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; CLASS_EXTENDS(type_index=-1), location=[TYPE_ARGUMENT(0)]", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar; CLASS_EXTENDS(type_index=-1), location=[TYPE_ARGUMENT(1)]", this.printTypeAnnotation(typeAnnotations[1]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; CLASS_EXTENDS(type_index=0), location=[TYPE_ARGUMENT(0)]", this.printTypeAnnotation(typeAnnotations[2]));
    }

    public void test005_classTypeParameterBound() throws Exception {
        String source = "import java.lang.annotation.*;\npublic class X<U, T extends Y<@Foo String @Bar(1)[][]@Bar(2)[]> & @Bar(3) Cloneable> {}\nclass Y<T> {}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader classFileReader = this.getInternalClassFile("", "X", "X", source);
        IBinaryTypeAnnotation[] typeAnnotations = classFileReader.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertEquals((int)4, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; CLASS_TYPE_PARAMETER_BOUND(type_parameter_index=1, bound_index=0), location=[TYPE_ARGUMENT(0), ARRAY, ARRAY, ARRAY]", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)1) CLASS_TYPE_PARAMETER_BOUND(type_parameter_index=1, bound_index=0), location=[TYPE_ARGUMENT(0)]", this.printTypeAnnotation(typeAnnotations[1]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)2) CLASS_TYPE_PARAMETER_BOUND(type_parameter_index=1, bound_index=0), location=[TYPE_ARGUMENT(0), ARRAY, ARRAY]", this.printTypeAnnotation(typeAnnotations[2]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) CLASS_TYPE_PARAMETER_BOUND(type_parameter_index=1, bound_index=1)", this.printTypeAnnotation(typeAnnotations[3]));
    }

    public void test006_methodTypeParameterBound() throws Exception {
        String source = "import java.lang.annotation.*;\npublic class X{\n\t<T extends Y<@Foo Z @Bar(1)[][]@Bar(2)[]> & @Bar(3) Cloneable> void foo(T t) {}\n}\nclass Y<T> {}\nclass Z {}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)4, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_TYPE_PARAMETER_BOUND(type_parameter_index=0, bound_index=0), location=[TYPE_ARGUMENT(0), ARRAY, ARRAY, ARRAY]", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)1) METHOD_TYPE_PARAMETER_BOUND(type_parameter_index=0, bound_index=0), location=[TYPE_ARGUMENT(0)]", this.printTypeAnnotation(typeAnnotations[1]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)2) METHOD_TYPE_PARAMETER_BOUND(type_parameter_index=0, bound_index=0), location=[TYPE_ARGUMENT(0), ARRAY, ARRAY]", this.printTypeAnnotation(typeAnnotations[2]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_TYPE_PARAMETER_BOUND(type_parameter_index=0, bound_index=1)", this.printTypeAnnotation(typeAnnotations[3]));
    }

    public void test007_field() throws Exception {
        String source = "import java.lang.annotation.*;\nimport java.util.Map;\npublic class X{\n\t@Foo Map<@Bar(1) String, @Bar(2) String @Bar(3)[] @Bar(4)[] @Bar(5)[]> field3;\n}\nclass Y<T> {}\nclass Z {}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryField field = this.getField(cfr, "field3");
        ClassFileReaderTest_1_8.assertNotNull((Object)field);
        IBinaryTypeAnnotation[] typeAnnotations = field.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)6, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; FIELD", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)1) FIELD, location=[TYPE_ARGUMENT(0)]", this.printTypeAnnotation(typeAnnotations[1]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)2) FIELD, location=[TYPE_ARGUMENT(1), ARRAY, ARRAY, ARRAY]", this.printTypeAnnotation(typeAnnotations[2]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) FIELD, location=[TYPE_ARGUMENT(1)]", this.printTypeAnnotation(typeAnnotations[3]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)4) FIELD, location=[TYPE_ARGUMENT(1), ARRAY]", this.printTypeAnnotation(typeAnnotations[4]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)5) FIELD, location=[TYPE_ARGUMENT(1), ARRAY, ARRAY]", this.printTypeAnnotation(typeAnnotations[5]));
    }

    public void test008_methodReturn() throws Exception {
        String source = "import java.lang.annotation.*;\nimport java.util.Map;\npublic class X{\n\t@Bar(3) @Foo int foo() {\n\t\treturn 1;\n\t}\n\t@Bar(3) int @Foo [] foo2() {\n\t\treturn null;\n\t}\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[1]));
        method = this.getMethod(cfr, "foo2");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_RETURN, location=[ARRAY]", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[1]));
    }

    public void test009_methodReceiver() throws Exception {
        String source = "import java.lang.annotation.*;\nimport java.util.Map;\npublic class X{\n\tvoid foo(@Bar(3) X this) {}\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)1, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_RECEIVER", this.printTypeAnnotation(typeAnnotations[0]));
    }

    public void test010_methodFormalParameter() throws Exception {
        String source = "import java.lang.annotation.*;\nimport java.util.Map;\npublic class X{\n\tvoid foo(@Bar(3) String s, @Foo int i) {}\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_FORMAL_PARAMETER(method_formal_parameter_index=0)", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_FORMAL_PARAMETER(method_formal_parameter_index=1)", this.printTypeAnnotation(typeAnnotations[1]));
    }

    public void test011_throws() throws Exception {
        String source = "import java.lang.annotation.*;\nimport java.util.Map;\npublic class X{\n\tvoid foo() throws @Foo Exception, @Bar(1) Throwable {}\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LFoo; THROWS(throws_type_index=0)", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)1) THROWS(throws_type_index=1)", this.printTypeAnnotation(typeAnnotations[1]));
    }

    public void test012_annotationMethodReturn() throws Exception {
        String source = "import java.lang.annotation.*;\nimport java.util.Map;\npublic @interface X{\n\t@Bar(3) @Foo int foo();\n\t@Bar(3) int @Foo [] foo2();\n\t@Bar(7) @Foo String value() default \"aaa\";\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Foo {\n}\n@Retention(RetentionPolicy.CLASS)\n@Target(ElementType.TYPE_USE)\n@interface Bar {\n        int value() default -1;\n}";
        ClassFileReader cfr = this.getInternalClassFile("", "X", "X", source);
        IBinaryMethod method = this.getMethod(cfr, "foo");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        IBinaryTypeAnnotation[] typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[1]));
        method = this.getMethod(cfr, "foo2");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)3) METHOD_RETURN, location=[ARRAY]", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[1]));
        method = this.getMethod(cfr, "value");
        ClassFileReaderTest_1_8.assertNotNull((Object)method);
        typeAnnotations = method.getTypeAnnotations();
        ClassFileReaderTest_1_8.assertNotNull((Object)typeAnnotations);
        ClassFileReaderTest_1_8.assertEquals((int)2, (int)typeAnnotations.length);
        ClassFileReaderTest_1_8.assertEquals("@LBar;(value=(int)7) METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[0]));
        ClassFileReaderTest_1_8.assertEquals("@LFoo; METHOD_RETURN", this.printTypeAnnotation(typeAnnotations[1]));
        ClassFileReaderTest_1_8.assertEquals(((Constant)method.getDefaultValue()).stringValue(), "aaa");
    }

    public void testBug548596() {
        String[] libs = this.getDefaultClassPaths();
        int len = libs.length;
        String[] stringArray = libs;
        libs = new String[len + 1];
        System.arraycopy(stringArray, 0, libs, 0, len);
        libs[libs.length - 1] = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "Test548596.jar";
        this.runConformTest(new String[]{"j/Usage.java", "package j;\n\nimport k.A.B.C;\n\npublic class Usage {\n    C c;\n}"}, "", libs, false, null);
    }

    public void testGH2625() {
        String[] libs = this.getDefaultClassPaths();
        int len = libs.length;
        String[] stringArray = libs;
        libs = new String[len + 1];
        System.arraycopy(stringArray, 0, libs, 0, len);
        libs[libs.length - 1] = this.getCompilerTestsPluginDirectoryPath() + File.separator + "workspace" + File.separator + "TestGH2625.jar";
        this.runConformTest(new String[]{"Test.java", "import a.A;\npublic class Test {\n\tvoid test(A a) {\n\t\ta.m(null, null, 0L);\n\t}\n}\n"}, "", libs, false, null);
    }

    private String printTypeAnnotation(IBinaryTypeAnnotation typeAnnotation) {
        StringBuilder sb = new StringBuilder();
        IBinaryAnnotation annotation = typeAnnotation.getAnnotation();
        sb.append('@').append(annotation.getTypeName());
        IBinaryElementValuePair[] pairs = annotation.getElementValuePairs();
        if (pairs.length != 0) {
            sb.append('(');
            int i = 0;
            while (i < pairs.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(pairs[i].getName()).append('=').append(pairs[i].getValue());
                ++i;
            }
            sb.append(')');
        }
        sb.append(' ');
        int targetType = typeAnnotation.getTargetType();
        switch (targetType) {
            case 0: {
                sb.append("CLASS_TYPE_PARAMETER(type_parameter_index=").append(typeAnnotation.getTypeParameterIndex()).append(')');
                break;
            }
            case 1: {
                sb.append("METHOD_TYPE_PARAMETER(type_parameter_index=").append(typeAnnotation.getTypeParameterIndex()).append(')');
                break;
            }
            case 16: {
                sb.append("CLASS_EXTENDS(type_index=").append((short)typeAnnotation.getSupertypeIndex()).append(')');
                break;
            }
            case 17: {
                sb.append("CLASS_TYPE_PARAMETER_BOUND(type_parameter_index=").append(typeAnnotation.getTypeParameterIndex()).append(", bound_index=").append(typeAnnotation.getBoundIndex()).append(')');
                break;
            }
            case 18: {
                sb.append("METHOD_TYPE_PARAMETER_BOUND(type_parameter_index=").append(typeAnnotation.getTypeParameterIndex()).append(", bound_index=").append(typeAnnotation.getBoundIndex()).append(')');
                break;
            }
            case 19: {
                sb.append("FIELD");
                break;
            }
            case 20: {
                sb.append("METHOD_RETURN");
                break;
            }
            case 21: {
                sb.append("METHOD_RECEIVER");
                break;
            }
            case 22: {
                sb.append("METHOD_FORMAL_PARAMETER(method_formal_parameter_index=").append(typeAnnotation.getMethodFormalParameterIndex()).append(')');
                break;
            }
            case 23: {
                sb.append("THROWS(throws_type_index=").append(typeAnnotation.getThrowsTypeIndex()).append(')');
                break;
            }
            default: {
                throw new IllegalStateException("nyi " + targetType);
            }
        }
        int[] typepath = typeAnnotation.getTypePath();
        if (typepath != IBinaryTypeAnnotation.NO_TYPE_PATH) {
            sb.append(", location=[");
            int i = 0;
            int max = typepath.length;
            while (i < max) {
                if (i > 0) {
                    sb.append(", ");
                }
                switch (typepath[i]) {
                    case 0: {
                        sb.append("ARRAY");
                        break;
                    }
                    case 1: {
                        sb.append("INNER_TYPE");
                        break;
                    }
                    case 2: {
                        sb.append("WILDCARD");
                        break;
                    }
                    case 3: {
                        sb.append("TYPE_ARGUMENT(").append(typepath[i + 1]).append(')');
                    }
                }
                i += 2;
            }
            sb.append(']');
        }
        return sb.toString();
    }

    private IBinaryMethod getMethod(ClassFileReader cfr, String methodname) {
        IBinaryMethod[] methods = cfr.getMethods();
        if (methods == null) {
            return null;
        }
        char[] methodnameAsCharArray = methodname.toCharArray();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            if (CharOperation.equals((char[])methods[i].getSelector(), (char[])methodnameAsCharArray)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private IBinaryField getField(ClassFileReader cfr, String fieldname) {
        IBinaryField[] fields = cfr.getFields();
        if (fields == null) {
            return null;
        }
        char[] fieldnameAsCharArray = fieldname.toCharArray();
        int i = 0;
        int max = fields.length;
        while (i < max) {
            if (CharOperation.equals((char[])fields[i].getName(), (char[])fieldnameAsCharArray)) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }
}

