/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class CollisionCase
extends AbstractRegressionTest {
    public CollisionCase(String name) {
        super(name);
    }

    public static Test suite() {
        return CollisionCase.buildAllCompliancesTestSuite(CollisionCase.testClass());
    }

    public static Class testClass() {
        return CollisionCase.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import foo.bar;\npublic class X {\t\n    foo\tafoo; \n    bar\tabar; \n    public static void main(String[] args) {\t\n\t\tSystem.out.print(\"SUCCESS\");\t\n    }\t\n}\t\n", "foo.java", "public class foo {}\n", "foo/bar.java", "package foo;\npublic class bar {}\n"}, "SUCCESS");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n    foo\tafoo; \n    foo.bar\tabar; \n}\t\n", "foo.java", "public class foo {}\n", "foo/bar.java", "package foo;\npublic class bar {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfoo.bar\tabar; \n\t^^^^^^^\nfoo.bar cannot be resolved to a type\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tclass MyFoo {\n\t\tclass Bar {}\n\t}\n\tstatic class MyFoo$Bar {}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tstatic class MyFoo$Bar {}\n\t             ^^^^^^^^^\nDuplicate nested type MyFoo$Bar\n----------\n");
    }
}

