/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import junit.framework.Test;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class CompilerInvocationTests
extends AbstractRegressionTest {
    private static Map categoryNames;

    public CompilerInvocationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return CompilerInvocationTests.buildAllCompliancesTestSuite(CompilerInvocationTests.testClass());
    }

    public static Class testClass() {
        return CompilerInvocationTests.class;
    }

    public void test001_irritant_warning_token() {
        HashMap<String, String> matcher = new HashMap<String, String>();
        int group = 0;
        while (group < 4) {
            int i = 0;
            while (i < 29) {
                int irritant = (group << 29) + (1 << i);
                String token = CompilerOptions.warningTokenFromIrritant((int)irritant);
                if (token != null) {
                    matcher.put(token, token);
                    CompilerInvocationTests.assertTrue((CompilerOptions.warningTokenToIrritants((String)token) != null ? 1 : 0) != 0);
                }
                ++i;
            }
            ++group;
        }
        matcher.put("preview", "preview");
        String[] allTokens = CompilerOptions.warningTokens;
        int length = allTokens.length;
        matcher.put("all", "all");
        CompilerInvocationTests.assertEquals((int)allTokens.length, (int)matcher.size());
        int i = 0;
        while (i < length) {
            Object object = matcher.get(allTokens[i]);
            CompilerInvocationTests.assertNotNull(object);
            ++i;
        }
    }

    public void test002_problem_categories() {
        try {
            Class<IProblem> iProblemClass = IProblem.class;
            Field[] fields = IProblem.class.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                int problemId;
                int maskedProblemId;
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && (maskedProblemId = (problemId = field.getInt(iProblemClass)) & 0x1FFFFF) != 0 && maskedProblemId != 0x1FFFFF && ProblemReporter.getProblemCategory((int)1, (int)problemId) == 0) {
                    CompilerInvocationTests.fail((String)("unspecified category for problem " + field.getName()));
                }
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            CompilerInvocationTests.fail((String)"could not access members");
        }
    }

    static String taskTagsAsCutAndPaste(CategorizedProblem[] tasks) {
        String[] arguments;
        if (tasks == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < tasks.length - 1) {
            arguments = tasks[i].getArguments();
            System.out.print("\t\t\"[");
            System.out.print(arguments[0]);
            System.out.print(',');
            System.out.print(arguments[1]);
            System.out.print(',');
            System.out.print(arguments[2]);
            System.out.println("]\\n\" +");
            ++i;
        }
        arguments = tasks[tasks.length - 1].getArguments();
        System.out.print("\t\t\"[");
        System.out.print(arguments[0]);
        System.out.print(',');
        System.out.print(arguments[1]);
        System.out.print(',');
        System.out.print(arguments[2]);
        System.out.println("]\\n\"");
        return result.toString();
    }

    static String taskTagsAsStrings(CategorizedProblem[] tasks) {
        StringBuilder result = new StringBuilder();
        if (tasks != null) {
            int i = 0;
            while (i < tasks.length) {
                String[] arguments = tasks[i].getArguments();
                result.append('[');
                result.append(arguments[0]);
                result.append(',');
                result.append(arguments[1]);
                result.append(',');
                result.append(arguments[2]);
                result.append(']');
                result.append("\n");
                ++i;
            }
        }
        return result.toString();
    }

    public void runTaskTagsOptionsTest(String[] testFiles, Map customOptions, String expectedTags) {
        TasksReader reader = new TasksReader();
        Hashtable options = JavaCore.getDefaultOptions();
        if (customOptions != null) {
            options.putAll(customOptions);
        }
        this.runConformTest(testFiles, "", null, true, null, options, reader, true);
        String tags = CompilerInvocationTests.taskTagsAsStrings(reader.result.tasks);
        if (!tags.equals(expectedTags)) {
            System.out.println(this.getClass().getName() + "#" + this.getName());
            System.out.println("Effective results:");
            System.out.println(tags);
            System.out.println("Cut and paste:");
            CompilerInvocationTests.taskTagsAsCutAndPaste(reader.result.tasks);
            CompilerInvocationTests.assertEquals(expectedTags, tags);
        }
    }

    public void test003_task_tags_options() {
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, null, "[FIXME, message contents,HIGH]\n[TODO, message contents,NORMAL]\n[XXX, message contents,NORMAL]\n");
    }

    public void _test004_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME, message contents,NORMAL]\n[TODO, message contents,NORMAL]\n[XXX, message contents,NORMAL]\n");
    }

    public void _test005_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", ",,");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME,message contents,NORMAL]\n[TODO,message contents,NORMAL]\n[XXX,message contents,NORMAL]\n");
    }

    public void _test006_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "A,B,C,D,E");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME,message contents,NORMAL]\n[TODO,message contents,NORMAL]\n[XXX,message contents,NORMAL]\n");
    }

    public void test007_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,NORMAL,NORMAL");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME, message contents,NORMAL]\n[TODO, message contents,NORMAL]\n[XXX, message contents,NORMAL]\n");
    }

    public void _test008_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,NORMAL");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME,message contents,NORMAL]\n[TODO,message contents,NORMAL]\n[XXX,message contents,NORMAL]\n");
    }

    public void test009_missing_message_templates() {
        CompilerInvocationTests.assertEquals("Unable to retrieve the error message for problem id: 2097151. Check compiler resources.", new DefaultProblemFactory().getLocalizedMessage(Integer.MAX_VALUE, new String[0]));
    }

    public void test010_missing_elaboration_templates() {
        CompilerInvocationTests.assertEquals("Unable to retrieve the error message elaboration for elaboration id: 1073741823. Check compiler resources.", new DefaultProblemFactory().getLocalizedMessage(0, 0x3FFFFFFF, new String[]{"Zork"}));
    }

    public void test011_problem_categories() {
        try {
            class ProblemAttributes {
                boolean deprecated;
                int category;

                ProblemAttributes(int category) {
                    this.category = category;
                }

                ProblemAttributes(boolean deprecated) {
                    this.deprecated = deprecated;
                }
            }
            ProblemAttributes DEPRECATED = new ProblemAttributes(true);
            HashMap<String, ProblemAttributes> expectedProblemAttributes = new HashMap<String, ProblemAttributes>();
            expectedProblemAttributes.put("AbstractMethodCannotBeOverridden", new ProblemAttributes(50));
            expectedProblemAttributes.put("AbstractMethodInAbstractClass", new ProblemAttributes(50));
            expectedProblemAttributes.put("AbstractMethodInEnum", new ProblemAttributes(50));
            expectedProblemAttributes.put("AbstractMethodMustBeImplemented", new ProblemAttributes(50));
            expectedProblemAttributes.put("AbstractMethodMustBeImplementedOverConcreteMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("AbstractMethodsInConcreteClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("AbstractServiceImplementation", new ProblemAttributes(40));
            expectedProblemAttributes.put("AllocatingLocalInStaticContext", new ProblemAttributes(40));
            expectedProblemAttributes.put("AmbiguousConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("AmbiguousConstructorInDefaultConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("AmbiguousConstructorInImplicitConstructorCall", new ProblemAttributes(50));
            expectedProblemAttributes.put("AmbiguousField", new ProblemAttributes(50));
            expectedProblemAttributes.put("AmbiguousMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("AmbiguousType", new ProblemAttributes(40));
            expectedProblemAttributes.put("AnnotatedTypeArgumentToUnannotated", new ProblemAttributes(90));
            expectedProblemAttributes.put("AnnotatedTypeArgumentToUnannotatedSuperHint", new ProblemAttributes(90));
            expectedProblemAttributes.put("AnnotationCannotOverrideMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("AnnotationCircularity", new ProblemAttributes(40));
            expectedProblemAttributes.put("AnnotationCircularitySelfReference", new ProblemAttributes(40));
            expectedProblemAttributes.put("AnnotationFieldNeedConstantInitialization", DEPRECATED);
            expectedProblemAttributes.put("AnnotationMembersCannotHaveParameters", new ProblemAttributes(20));
            expectedProblemAttributes.put("AnnotationMembersCannotHaveTypeParameters", new ProblemAttributes(20));
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveConstructor", new ProblemAttributes(20));
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperclass", new ProblemAttributes(20));
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperinterfaces", new ProblemAttributes(20));
            expectedProblemAttributes.put("AnnotationTypeUsedAsSuperInterface", new ProblemAttributes(80));
            expectedProblemAttributes.put("AnnotationValueMustBeAnEnumConstant", new ProblemAttributes(60));
            expectedProblemAttributes.put("AnnotationValueMustBeAnnotation", new ProblemAttributes(60));
            expectedProblemAttributes.put("AnnotationValueMustBeArrayInitializer", new ProblemAttributes(60));
            expectedProblemAttributes.put("AnnotationValueMustBeClassLiteral", new ProblemAttributes(60));
            expectedProblemAttributes.put("AnnotationValueMustBeConstant", new ProblemAttributes(60));
            expectedProblemAttributes.put("AnonymousClassCannotExtendFinalClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("ApplicableMethodOverriddenByInapplicable", new ProblemAttributes(50));
            expectedProblemAttributes.put("ArgumentHidingField", new ProblemAttributes(100));
            expectedProblemAttributes.put("ArgumentHidingLocalVariable", new ProblemAttributes(100));
            expectedProblemAttributes.put("ArgumentIsNeverUsed", new ProblemAttributes(120));
            expectedProblemAttributes.put("ArgumentTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoid", new ProblemAttributes(50));
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoidArray", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("ArrayConstantsOnlyInArrayInitializers", new ProblemAttributes(20));
            expectedProblemAttributes.put("ArrayReferencePotentialNullReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("ArrayReferenceRequired", new ProblemAttributes(60));
            expectedProblemAttributes.put("AssignmentHasNoEffect", new ProblemAttributes(90));
            expectedProblemAttributes.put("AssignmentToMultiCatchParameter", new ProblemAttributes(60));
            expectedProblemAttributes.put("AssignmentToResource", new ProblemAttributes(60));
            expectedProblemAttributes.put("AutoManagedResourceNotBelow17", new ProblemAttributes(20));
            expectedProblemAttributes.put("AutoManagedVariableResourceNotBelow9", new ProblemAttributes(20));
            expectedProblemAttributes.put("BinaryLiteralNotBelow17", new ProblemAttributes(20));
            expectedProblemAttributes.put("BodyForAbstractMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("BodyForNativeMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("BoundCannotBeArray", new ProblemAttributes(40));
            expectedProblemAttributes.put("BoundHasConflictingArguments", new ProblemAttributes(40));
            expectedProblemAttributes.put("BoundMustBeAnInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("BoxingConversion", new ProblemAttributes(80));
            expectedProblemAttributes.put("BytecodeExceeds64KLimit", new ProblemAttributes(60));
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForClinit", new ProblemAttributes(60));
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForConstructor", new ProblemAttributes(60));
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForSwitchTable", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotAllocateVoidArray", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotDeclareEnumSpecialMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("CannotDefineAnnotationInLocalType", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotDefineDimensionExpressionsWithInit", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotDefineEnumInLocalType", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotDefineInterfaceInLocalType", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotDefineStaticInitializerInLocalType", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotExtendEnum", new ProblemAttributes(40));
            expectedProblemAttributes.put("CannotHideAnInstanceMethodWithAStaticMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("CannotImplementIncompatibleNullness", new ProblemAttributes(90));
            expectedProblemAttributes.put("CannotImportPackage", new ProblemAttributes(30));
            expectedProblemAttributes.put("CannotInferElidedTypes", new ProblemAttributes(40));
            expectedProblemAttributes.put("CannotInferInvocationType", new ProblemAttributes(40));
            expectedProblemAttributes.put("CannotInvokeSuperConstructorInEnum", new ProblemAttributes(50));
            expectedProblemAttributes.put("CannotOverrideAStaticMethodWithAnInstanceMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("CannotReadSource", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotReturnInInitializer", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotThrowNull", new ProblemAttributes(60));
            expectedProblemAttributes.put("CannotThrowType", new ProblemAttributes(40));
            expectedProblemAttributes.put("CannotUseDiamondWithAnonymousClasses", new ProblemAttributes(40));
            expectedProblemAttributes.put("CannotUseDiamondWithExplicitTypeArguments", new ProblemAttributes(40));
            expectedProblemAttributes.put("CannotUseSuperInCodeSnippet", new ProblemAttributes(60));
            expectedProblemAttributes.put("ClassExtendFinalClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("CodeCannotBeReached", new ProblemAttributes(60));
            expectedProblemAttributes.put("CodeSnippetMissingClass", new ProblemAttributes(60));
            expectedProblemAttributes.put("CodeSnippetMissingMethod", new ProblemAttributes(60));
            expectedProblemAttributes.put("ConstNonNullFieldComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("ContainerAnnotationTypeHasNonDefaultMembers", new ProblemAttributes(40));
            expectedProblemAttributes.put("ContainerAnnotationTypeHasShorterRetention", new ProblemAttributes(40));
            expectedProblemAttributes.put("ContainerAnnotationTypeHasWrongValueType", new ProblemAttributes(40));
            expectedProblemAttributes.put("ContainerAnnotationTypeMustHaveValue", new ProblemAttributes(40));
            expectedProblemAttributes.put("ContradictoryNullAnnotations", new ProblemAttributes(90));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsOnBound", new ProblemAttributes(90));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsInferred", new ProblemAttributes(90));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsInferredFunctionType", new ProblemAttributes(90));
            expectedProblemAttributes.put("ComparingIdentical", new ProblemAttributes(90));
            expectedProblemAttributes.put("ConflictingImport", new ProblemAttributes(30));
            expectedProblemAttributes.put("ConflictingNullAnnotations", new ProblemAttributes(90));
            expectedProblemAttributes.put("ConstructedArrayIncompatible", new ProblemAttributes(50));
            expectedProblemAttributes.put("ConstructionTypeMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("ConflictingInheritedNullAnnotations", new ProblemAttributes(90));
            expectedProblemAttributes.put("ConstructorReferenceNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("ConstructorVarargsArgumentNeedCast", new ProblemAttributes(90));
            expectedProblemAttributes.put("CyclicModuleDependency", new ProblemAttributes(160));
            expectedProblemAttributes.put("CorruptedSignature", new ProblemAttributes(10));
            expectedProblemAttributes.put("DanglingReference", new ProblemAttributes(50));
            expectedProblemAttributes.put("DeadCode", new ProblemAttributes(90));
            expectedProblemAttributes.put("DefaultMethodNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("DefaultMethodOverridesObjectMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("DefaultTrueAndFalseCases", new ProblemAttributes(180));
            expectedProblemAttributes.put("DereferencingNullableExpression", new ProblemAttributes(90));
            expectedProblemAttributes.put("DiamondNotBelow17", new ProblemAttributes(40));
            expectedProblemAttributes.put("DirectInvocationOfAbstractMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("DisallowedTargetForContainerAnnotationType", new ProblemAttributes(40));
            expectedProblemAttributes.put("DisallowedTargetForAnnotation", new ProblemAttributes(40));
            expectedProblemAttributes.put("DisallowedExplicitThisParameter", new ProblemAttributes(20));
            expectedProblemAttributes.put("DiscouragedReference", new ProblemAttributes(150));
            expectedProblemAttributes.put("DuplicateAnnotation", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateAnnotationNotMarkedRepeatable", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateAnnotationMember", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateBlankFinalFieldInitialization", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateBounds", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateBoundInIntersectionCast", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateCase", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateDefaultCase", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateExports", new ProblemAttributes(160));
            expectedProblemAttributes.put("DuplicateField", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateFinalLocalInitialization", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateImport", new ProblemAttributes(30));
            expectedProblemAttributes.put("DuplicateInheritedMethods", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateInheritedDefaultMethods", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateLabel", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateMethodErasure", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateModifierForArgument", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateModifierForField", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateModifierForMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateModifierForType", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateModifierForVariable", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateModuleRef", new ProblemAttributes(160));
            expectedProblemAttributes.put("DuplicateNestedType", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateOpens", new ProblemAttributes(160));
            expectedProblemAttributes.put("DuplicateParameterizedMethods", new ProblemAttributes(50));
            expectedProblemAttributes.put("DuplicateRequires", new ProblemAttributes(160));
            expectedProblemAttributes.put("DuplicateResource", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateServices", new ProblemAttributes(160));
            expectedProblemAttributes.put("DuplicateSuperInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateTargetInTargetAnnotation", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateTypeVariable", new ProblemAttributes(60));
            expectedProblemAttributes.put("DuplicateTypes", new ProblemAttributes(40));
            expectedProblemAttributes.put("DuplicateUses", new ProblemAttributes(160));
            expectedProblemAttributes.put("EmptyControlFlowStatement", new ProblemAttributes(90));
            expectedProblemAttributes.put("EnclosingInstanceInConstructorCall", new ProblemAttributes(60));
            expectedProblemAttributes.put("EndOfSource", new ProblemAttributes(20));
            expectedProblemAttributes.put("EnumAbstractMethodMustBeImplemented", new ProblemAttributes(50));
            expectedProblemAttributes.put("EnumConstantCannotDefineAbstractMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("EnumConstantMustImplementAbstractMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("EnumConstantsCannotBeSurroundedByParenthesis", new ProblemAttributes(20));
            expectedProblemAttributes.put("EnumStaticFieldInInInitializerContext", new ProblemAttributes(50));
            expectedProblemAttributes.put("EnumSwitchCannotTargetField", new ProblemAttributes(50));
            expectedProblemAttributes.put("ExceptionParameterIsNeverUsed", new ProblemAttributes(120));
            expectedProblemAttributes.put("ExceptionTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("ExplicitThisParameterNotInLambda", new ProblemAttributes(20));
            expectedProblemAttributes.put("ExplicitThisParameterNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("ExplicitlyClosedAutoCloseable", new ProblemAttributes(80));
            expectedProblemAttributes.put("ExportingForeignPackage", new ProblemAttributes(160));
            expectedProblemAttributes.put("ExportedPackageDoesNotExistOrIsEmpty", new ProblemAttributes(160));
            expectedProblemAttributes.put("ExpressionShouldBeAVariable", new ProblemAttributes(20));
            expectedProblemAttributes.put("ExternalProblemFixable", new ProblemAttributes(60));
            expectedProblemAttributes.put("ExternalProblemNotFixable", new ProblemAttributes(60));
            expectedProblemAttributes.put("ExplicitAnnotationTargetRequired", new ProblemAttributes(40));
            expectedProblemAttributes.put("FallthroughCase", new ProblemAttributes(90));
            expectedProblemAttributes.put("FieldComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("FieldHidingField", new ProblemAttributes(100));
            expectedProblemAttributes.put("FieldHidingLocalVariable", new ProblemAttributes(100));
            expectedProblemAttributes.put("FieldMissingDeprecatedAnnotation", new ProblemAttributes(80));
            expectedProblemAttributes.put("FieldMustBeFinal", new ProblemAttributes(60));
            expectedProblemAttributes.put("FieldTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("FieldWithUnresolvedOwningAnnotation", new ProblemAttributes(60));
            expectedProblemAttributes.put("FinalBoundForTypeVariable", new ProblemAttributes(80));
            expectedProblemAttributes.put("FinalFieldAssignment", new ProblemAttributes(50));
            expectedProblemAttributes.put("FinalMethodCannotBeOverridden", new ProblemAttributes(50));
            expectedProblemAttributes.put("FinalOuterLocalAssignment", new ProblemAttributes(60));
            expectedProblemAttributes.put("FinallyMustCompleteNormally", new ProblemAttributes(90));
            expectedProblemAttributes.put("ForbiddenReference", new ProblemAttributes(150));
            expectedProblemAttributes.put("GenericConstructorTypeArgumentMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("GenericInferenceError", new ProblemAttributes(60));
            expectedProblemAttributes.put("GenericMethodTypeArgumentMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("GenericTypeCannotExtendThrowable", new ProblemAttributes(40));
            expectedProblemAttributes.put("HidingEnclosingType", new ProblemAttributes(40));
            expectedProblemAttributes.put("HierarchyCircularity", new ProblemAttributes(40));
            expectedProblemAttributes.put("HierarchyCircularitySelfReference", new ProblemAttributes(40));
            expectedProblemAttributes.put("HierarchyHasProblems", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalAbstractModifierCombinationForMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalStrictfpForAbstractInterfaceMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalAccessFromTypeVariable", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalAnnotationForBaseType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalCast", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalClassLiteralForTypeVariable", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalDeclarationOfThisParameter", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalDefaultModifierSpecification", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalDefinitionToNonNullParameter", new ProblemAttributes(90));
            expectedProblemAttributes.put("IllegalDimension", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalEnclosingInstanceSpecification", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalExtendedDimensions", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalExtendedDimensionsForVarArgs", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalGenericArray", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalHexaLiteral", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalInstanceofParameterizedType", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalInstanceofTypeParameter", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalBasetypeInIntersectionCast", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierCombinationFinalAbstractForClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierCombinationFinalVolatileForField", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierCombinationForInterfaceMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierCombinationForPrivateInterfaceMethod9", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForAnnotationField", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalModifierForAnnotationMemberType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForAnnotationMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForAnnotationType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForArgument", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("StrictfpNotRequired", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalModifierForEnum", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForEnumConstant", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForEnumConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForField", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForInterfaceField", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod18", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForLocalClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForLocalEnum", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForMemberClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForMemberEnum", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForMemberInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForModule", new ProblemAttributes(160));
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod9", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifierForVariable", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalModifiersForElidedType", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalModifiers", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalParameterNullityRedefinition", new ProblemAttributes(90));
            expectedProblemAttributes.put("IllegalPrimitiveOrArrayTypeForEnclosingInstance", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalQualifiedEnumConstantLabel", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalQualifiedParameterizedTypeAllocation", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis2", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalRedefinitionOfTypeVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("IllegalReturnNullityRedefinition", new ProblemAttributes(90));
            expectedProblemAttributes.put("IllegalReturnNullityRedefinitionFreeTypeVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("IllegalRedefinitionToNonNullParameter", new ProblemAttributes(90));
            expectedProblemAttributes.put("IllegalStaticModifierForMemberType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalTypeAnnotationsInStaticMemberAccess", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalTypeArgumentsInRawConstructorReference", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalTypeForExplicitThis", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalTypeVariableSuperReference", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalUnderscorePosition", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalUsageOfQualifiedTypeReference", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalUsageOfTypeAnnotations", new ProblemAttributes(20));
            expectedProblemAttributes.put("IllegalVararg", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalVarargInLambda", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForField", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMemberType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("IllegalVisibilityModifierForInterfaceMemberType", new ProblemAttributes(40));
            expectedProblemAttributes.put("ImplicitObjectBoundNoNullDefault", new ProblemAttributes(60));
            expectedProblemAttributes.put("ImportAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ImportInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ImportInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ImportNotFound", new ProblemAttributes(30));
            expectedProblemAttributes.put("ImportNotVisible", DEPRECATED);
            expectedProblemAttributes.put("IncompatibleCaseType", new ProblemAttributes(180));
            expectedProblemAttributes.put("IncompatibleExceptionInInheritedMethodThrowsClause", new ProblemAttributes(50));
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClause", new ProblemAttributes(50));
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClauseForNonInheritedInterfaceMethod", new ProblemAttributes(100));
            expectedProblemAttributes.put("IncompatibleLambdaParameterType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncompatibleMethodReference", new ProblemAttributes(50));
            expectedProblemAttributes.put("IncompatibleReturnType", new ProblemAttributes(50));
            expectedProblemAttributes.put("IncompatibleReturnTypeForNonInheritedInterfaceMethod", new ProblemAttributes(100));
            expectedProblemAttributes.put("IncompatibleTypesInConditionalOperator", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncompatibleTypesInEqualityOperator", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncompatibleTypesInForeach", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncorrectArityForParameterizedConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncorrectArityForParameterizedMethod", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncorrectArityForParameterizedType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncorrectEnclosingInstanceReference", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncorrectSwitchType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IncorrectSwitchType17", new ProblemAttributes(40));
            expectedProblemAttributes.put("IndirectAccessToStaticField", new ProblemAttributes(80));
            expectedProblemAttributes.put("IndirectAccessToStaticMethod", new ProblemAttributes(80));
            expectedProblemAttributes.put("IndirectAccessToStaticType", new ProblemAttributes(80));
            expectedProblemAttributes.put("InheritedDefaultMethodConflictsWithOtherInherited", new ProblemAttributes(50));
            expectedProblemAttributes.put("InheritedFieldHidesEnclosingName", new ProblemAttributes(50));
            expectedProblemAttributes.put("InheritedIncompatibleReturnType", new ProblemAttributes(50));
            expectedProblemAttributes.put("InheritedMethodHidesEnclosingName", new ProblemAttributes(50));
            expectedProblemAttributes.put("InheritedMethodReducesVisibility", new ProblemAttributes(50));
            expectedProblemAttributes.put("InheritedParameterLackingNonNullAnnotation", new ProblemAttributes(90));
            expectedProblemAttributes.put("InheritedTypeHidesEnclosingName", new ProblemAttributes(40));
            expectedProblemAttributes.put("InitializerMustCompleteNormally", new ProblemAttributes(60));
            expectedProblemAttributes.put("InstanceFieldDuringConstructorInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("InstanceMethodDuringConstructorInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("InterfaceAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("InterfaceCannotHaveConstructors", new ProblemAttributes(20));
            expectedProblemAttributes.put("InterfaceCannotHaveInitializers", new ProblemAttributes(40));
            expectedProblemAttributes.put("InterfaceInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("InterfaceInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("InterfaceNotFound", DEPRECATED);
            expectedProblemAttributes.put("InterfaceNotFunctionalInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("InterfaceNotVisible", DEPRECATED);
            expectedProblemAttributes.put("InterfaceStaticMethodInvocationNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("InterfaceSuperInvocationNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("InternalTypeNameProvided", new ProblemAttributes(40));
            expectedProblemAttributes.put("IntersectionCastNotBelow18", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidAnnotationMemberType", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidArrayConstructorReference", new ProblemAttributes(50));
            expectedProblemAttributes.put("InvalidBinary", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidBreak", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidCatchBlockSequence", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidCharacterConstant", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidClassInstantiation", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidContinue", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidDigit", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidEncoding", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidEscape", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidExplicitConstructorCall", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidExpressionAsStatement", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidFileNameForPackageAnnotations", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidFloat", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidHexa", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidHighSurrogate", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidInput", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidLowSurrogate", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidLocationForModifiers", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidNullToSynchronized", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidOctal", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidOpensStatement", new ProblemAttributes(160));
            expectedProblemAttributes.put("InvalidOperator", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidParameterizedExceptionType", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidParenthesizedExpression", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidServiceIntfType", new ProblemAttributes(160));
            expectedProblemAttributes.put("InvalidServiceImplType", new ProblemAttributes(160));
            expectedProblemAttributes.put("InvalidTypeExpression", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidTypeArguments", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidTypeForCollection", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidTypeForCollectionTarget14", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidTypeForStaticImport", new ProblemAttributes(30));
            expectedProblemAttributes.put("InvalidTypeToSynchronized", new ProblemAttributes(60));
            expectedProblemAttributes.put("InvalidTypeVariableExceptionType", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidUnaryExpression", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUnicodeEscape", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUnionTypeReferenceSequence", new ProblemAttributes(40));
            expectedProblemAttributes.put("InvalidUsageOfAnnotationDeclarations", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfAnnotations", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfEnumDeclarations", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfForeachStatements", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfStaticImports", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfTypeAnnotations", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfTypeArguments", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfTypeParameters", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForAnnotationDeclaration", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForEnumDeclaration", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfVarargs", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidUsageOfWildcard", new ProblemAttributes(20));
            expectedProblemAttributes.put("InvalidVoidExpression", new ProblemAttributes(60));
            expectedProblemAttributes.put("IsClassPathCorrect", new ProblemAttributes(10));
            expectedProblemAttributes.put("IsClassPathCorrectWithReferencingType", new ProblemAttributes(10));
            expectedProblemAttributes.put("JavadocAmbiguousConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocAmbiguousField", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocAmbiguousMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocAmbiguousMethodReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocAmbiguousType", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocDuplicateParamName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocDuplicateProvidesTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocDuplicateReturnTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocDuplicateTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocDuplicateThrowsClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocDuplicateUsesTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocEmptyReturnTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocGenericConstructorTypeArgumentMismatch", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocGenericMethodTypeArgumentMismatch", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocHiddenReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInheritedFieldHidesEnclosingName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInheritedMethodHidesEnclosingName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInheritedNameHidesEnclosingTypeName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInternalTypeNameProvided", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidMemberTypeQualification", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidModuleQualification", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidParamName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidParamTagName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidParamTagTypeParameter", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidProvidesClass", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidProvidesClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSeeArgs", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSeeHref", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSeeReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSeeUrlReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidThrowsClass", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidThrowsClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidUsesClass", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidUsesClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidValueReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMalformedSeeReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMessagePrefix", new ProblemAttributes(60));
            expectedProblemAttributes.put("JavadocMissing", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingHashCharacter", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingIdentifier", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingParamName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingParamTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingProvidesClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingProvidesTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingReturnTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingSeeReference", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingTagDescription", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingThrowsClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingThrowsTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingUsesClassName", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocMissingUsesTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNoMessageSendOnArrayType", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNoMessageSendOnBaseType", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNonGenericConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNonGenericMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNonStaticTypeFromStaticInvocation", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNotAccessibleType", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNotVisibleConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNotVisibleField", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNotVisibleMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocNotVisibleType", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocParameterMismatch", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocParameterizedConstructorArgumentTypeMismatch", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocParameterizedMethodArgumentTypeMismatch", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUndefinedConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUndefinedField", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUndefinedMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUndefinedType", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUnexpectedTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUnexpectedText", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSnippet", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSnippetMissingColon", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSnippetContentNewLine", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSnippetRegionNotClosed", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSnippetRegexSubstringTogether", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocInvalidSnippetDuplicateRegions", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUnterminatedInlineTag", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedConstructor", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedField", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedMethod", new ProblemAttributes(70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedType", new ProblemAttributes(70));
            expectedProblemAttributes.put("LambdaDescriptorMentionsUnmentionable", new ProblemAttributes(60));
            expectedProblemAttributes.put("LambdaExpressionNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("LambdaRedeclaresArgument", new ProblemAttributes(60));
            expectedProblemAttributes.put("LambdaRedeclaresLocal", new ProblemAttributes(60));
            expectedProblemAttributes.put("LambdaShapeComputationError", new ProblemAttributes(60));
            expectedProblemAttributes.put("LocalVariableCanOnlyBeNull", DEPRECATED);
            expectedProblemAttributes.put("LocalVariableCannotBeNull", DEPRECATED);
            expectedProblemAttributes.put("LocalVariableHidingField", new ProblemAttributes(100));
            expectedProblemAttributes.put("LocalVariableHidingLocalVariable", new ProblemAttributes(100));
            expectedProblemAttributes.put("LocalVariableIsNeverUsed", new ProblemAttributes(120));
            expectedProblemAttributes.put("LocalVariableMayBeNull", DEPRECATED);
            expectedProblemAttributes.put("MaskedCatch", new ProblemAttributes(90));
            expectedProblemAttributes.put("MandatoryCloseNotShown", new ProblemAttributes(90));
            expectedProblemAttributes.put("MandatoryCloseNotShownAtExit", new ProblemAttributes(90));
            expectedProblemAttributes.put("MessageSendWithUnresolvedOwningAnnotation", new ProblemAttributes(60));
            expectedProblemAttributes.put("MethodButWithConstructorName", new ProblemAttributes(80));
            expectedProblemAttributes.put("MethodCanBePotentiallyStatic", new ProblemAttributes(80));
            expectedProblemAttributes.put("MethodCanBeStatic", new ProblemAttributes(80));
            expectedProblemAttributes.put("MethodMissingDeprecatedAnnotation", new ProblemAttributes(80));
            expectedProblemAttributes.put("MethodMustOverride", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodMustOverrideOrImplement", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodNameClash", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodNameClashHidden", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodReducesVisibility", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodReferenceNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("MethodReferenceSwingsBothWays", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodRequiresBody", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodReturnsVoid", new ProblemAttributes(50));
            expectedProblemAttributes.put("MethodVarargsArgumentNeedCast", new ProblemAttributes(90));
            expectedProblemAttributes.put("MisplacedTypeAnnotations", new ProblemAttributes(20));
            expectedProblemAttributes.put("MissingArgumentsForParameterizedMemberType", new ProblemAttributes(40));
            expectedProblemAttributes.put("MissingDefaultCase", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingEnclosingInstance", new ProblemAttributes(40));
            expectedProblemAttributes.put("MissingEnclosingInstanceForConstructorCall", new ProblemAttributes(40));
            expectedProblemAttributes.put("MissingEnumConstantCase", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingEnumConstantCaseDespiteDefault", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingEnumDefaultCase", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnPackage", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnType", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingNullAnnotationImplicitlyUsed", new ProblemAttributes(10));
            expectedProblemAttributes.put("MissingOverrideAnnotation", new ProblemAttributes(80));
            expectedProblemAttributes.put("MissingOverrideAnnotationForInterfaceMethodImplementation", new ProblemAttributes(80));
            expectedProblemAttributes.put("MissingRequiresTransitiveForTypeInAPI", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingReturnType", new ProblemAttributes(40));
            expectedProblemAttributes.put("MissingSemiColon", new ProblemAttributes(20));
            expectedProblemAttributes.put("MissingSerialVersion", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingSynchronizedModifierInInheritedMethod", new ProblemAttributes(90));
            expectedProblemAttributes.put("MissingTypeInConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("MissingTypeInLambda", new ProblemAttributes(50));
            expectedProblemAttributes.put("ModifierOnRequiresJavaBase", new ProblemAttributes(160));
            expectedProblemAttributes.put("ModifierOnRequiresJavaBasePreview", new ProblemAttributes(160));
            expectedProblemAttributes.put("MissingTypeForInference", new ProblemAttributes(60));
            expectedProblemAttributes.put("UnterminatedTextBlock", new ProblemAttributes(180));
            expectedProblemAttributes.put("MissingTypeInMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("MissingValueForAnnotationMember", new ProblemAttributes(40));
            expectedProblemAttributes.put("MissingValueFromLambda", new ProblemAttributes(60));
            expectedProblemAttributes.put("ModuleNotRead", new ProblemAttributes(160));
            expectedProblemAttributes.put("MultiCatchNotBelow17", new ProblemAttributes(20));
            expectedProblemAttributes.put("MultipleFunctionalInterfaces", new ProblemAttributes(40));
            expectedProblemAttributes.put("StaticInterfaceMethodNotBelow18", new ProblemAttributes(20));
            expectedProblemAttributes.put("MustDefineEitherDimensionExpressionsOrInitializer", new ProblemAttributes(60));
            expectedProblemAttributes.put("MustSpecifyPackage", new ProblemAttributes(60));
            expectedProblemAttributes.put("NativeMethodsCannotBeStrictfp", new ProblemAttributes(50));
            expectedProblemAttributes.put("NeedToEmulateConstructorAccess", new ProblemAttributes(80));
            expectedProblemAttributes.put("NeedToEmulateFieldReadAccess", new ProblemAttributes(80));
            expectedProblemAttributes.put("NeedToEmulateFieldWriteAccess", new ProblemAttributes(80));
            expectedProblemAttributes.put("SyntheticAccessorNotEnclosingMethod", new ProblemAttributes(80));
            expectedProblemAttributes.put("NeedToEmulateMethodAccess", new ProblemAttributes(80));
            expectedProblemAttributes.put("NestedServiceImpl", new ProblemAttributes(40));
            expectedProblemAttributes.put("NoAdditionalBoundAfterTypeVariable", new ProblemAttributes(40));
            expectedProblemAttributes.put("NoFieldOnBaseType", new ProblemAttributes(50));
            expectedProblemAttributes.put("NoGenericLambda", new ProblemAttributes(40));
            expectedProblemAttributes.put("NoImplicitStringConversionForCharArrayExpression", new ProblemAttributes(90));
            expectedProblemAttributes.put("NoMessageSendOnArrayType", new ProblemAttributes(50));
            expectedProblemAttributes.put("NoMessageSendOnBaseType", new ProblemAttributes(50));
            expectedProblemAttributes.put("NoSuperInInterfaceContext", new ProblemAttributes(20));
            expectedProblemAttributes.put("NonBlankFinalLocalAssignment", new ProblemAttributes(60));
            expectedProblemAttributes.put("NonConstantExpression", new ProblemAttributes(60));
            expectedProblemAttributes.put("NonDenotableTypeArgumentForAnonymousDiamond", new ProblemAttributes(40));
            expectedProblemAttributes.put("NonExternalizedStringLiteral", new ProblemAttributes(140));
            expectedProblemAttributes.put("NonGenericConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("NonGenericMethod", new ProblemAttributes(40));
            expectedProblemAttributes.put("NonGenericType", new ProblemAttributes(40));
            expectedProblemAttributes.put("NonNullArrayContentNotInitialized", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonNullDefaultDetailIsNotEvaluated", new ProblemAttributes(60));
            expectedProblemAttributes.put("NonNullExpressionComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonNullMessageSendComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonNullSpecdFieldComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonNullTypeVariableFromLegacyMethod", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonNullMethodTypeVariableFromLegacyMethod", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonPublicTypeInAPI", new ProblemAttributes(90));
            expectedProblemAttributes.put("NonStaticAccessToStaticField", new ProblemAttributes(80));
            expectedProblemAttributes.put("NonStaticAccessToStaticMethod", new ProblemAttributes(80));
            expectedProblemAttributes.put("NonStaticContextForEnumMemberType", new ProblemAttributes(60));
            expectedProblemAttributes.put("NonStaticFieldFromStaticInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("NonStaticOrAlienTypeReceiver", new ProblemAttributes(50));
            expectedProblemAttributes.put("NonStaticTypeFromStaticInvocation", new ProblemAttributes(60));
            expectedProblemAttributes.put("NotAnnotationType", new ProblemAttributes(40));
            expectedProblemAttributes.put("NotAccessibleConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotAccessibleField", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotAccessibleMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotAccessibleType", new ProblemAttributes(40));
            expectedProblemAttributes.put("NotAccessiblePackage", new ProblemAttributes(30));
            expectedProblemAttributes.put("NotExportedTypeInAPI", new ProblemAttributes(90));
            expectedProblemAttributes.put("ConflictingPackageFromModules", new ProblemAttributes(160));
            expectedProblemAttributes.put("ConflictingPackageFromOtherModules", new ProblemAttributes(160));
            expectedProblemAttributes.put("NotOwningResourceField", new ProblemAttributes(90));
            expectedProblemAttributes.put("NotVisibleConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotVisibleConstructorInDefaultConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotVisibleConstructorInImplicitConstructorCall", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotVisibleField", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotVisibleMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("NotVisibleType", new ProblemAttributes(40));
            expectedProblemAttributes.put("NullableFieldReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullAnnotationAtQualifyingType", new ProblemAttributes(20));
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocation", new ProblemAttributes(60));
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocationAtType", new ProblemAttributes(60));
            expectedProblemAttributes.put("NullExpressionReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullLocalVariableComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullLocalVariableInstanceofYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullLocalVariableReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityMismatchAgainstFreeTypeVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotation", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotationSuperHint", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityMismatchTypeArgument", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotation", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetail", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetailSuperHint", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullNotCompatibleToFreeTypeVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("NullSourceString", new ProblemAttributes(20));
            expectedProblemAttributes.put("NullUnboxing", new ProblemAttributes(90));
            expectedProblemAttributes.put("NumericValueOutOfRange", new ProblemAttributes(60));
            expectedProblemAttributes.put("ObjectCannotBeGeneric", new ProblemAttributes(60));
            expectedProblemAttributes.put("ObjectCannotHaveSuperTypes", new ProblemAttributes(60));
            expectedProblemAttributes.put("ObjectHasNoSuperclass", new ProblemAttributes(40));
            expectedProblemAttributes.put("ObjectMustBeClass", new ProblemAttributes(60));
            expectedProblemAttributes.put("OuterLocalMustBeEffectivelyFinal", new ProblemAttributes(60));
            expectedProblemAttributes.put("OuterLocalMustBeFinal", new ProblemAttributes(60));
            expectedProblemAttributes.put("OverrideAddingReturnOwning", new ProblemAttributes(90));
            expectedProblemAttributes.put("OverrideReducingParamterOwning", new ProblemAttributes(90));
            expectedProblemAttributes.put("OverridingDeprecatedMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("OverridingDeprecatedSinceVersionMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("OverridingTerminallyDeprecatedMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("OverridingTerminallyDeprecatedSinceVersionMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("OverridingMethodWithoutSuperInvocation", new ProblemAttributes(90));
            expectedProblemAttributes.put("OverridingNonVisibleMethod", new ProblemAttributes(100));
            expectedProblemAttributes.put("OwningFieldInNonResourceClass", new ProblemAttributes(90));
            expectedProblemAttributes.put("OwningFieldShouldImplementClose", new ProblemAttributes(90));
            expectedProblemAttributes.put("PackageCollidesWithType", new ProblemAttributes(40));
            expectedProblemAttributes.put("PackageDoesNotExistOrIsEmpty", new ProblemAttributes(160));
            expectedProblemAttributes.put("PackageIsNotExpectedPackage", new ProblemAttributes(60));
            expectedProblemAttributes.put("ParameterAssignment", new ProblemAttributes(80));
            expectedProblemAttributes.put("ParameterLackingNonNullAnnotation", new ProblemAttributes(90));
            expectedProblemAttributes.put("ParameterLackingNullableAnnotation", new ProblemAttributes(90));
            expectedProblemAttributes.put("ParameterMismatch", new ProblemAttributes(50));
            expectedProblemAttributes.put("ParameterizedConstructorArgumentTypeMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("ParameterizedMethodArgumentTypeMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("ParameterWithUnresolvedOwningAnnotation", new ProblemAttributes(60));
            expectedProblemAttributes.put("ParsingError", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorDeleteToken", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorDeleteTokens", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorInsertToComplete", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorInsertToCompletePhrase", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorInsertToCompleteScope", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorInsertTokenAfter", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorInsertTokenBefore", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorInvalidToken", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorMergeTokens", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorMisplacedConstruct", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorNoSuggestion", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorNoSuggestionForTokens", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorOnKeyword", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorOnKeywordNoSuggestion", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorReplaceTokens", new ProblemAttributes(20));
            expectedProblemAttributes.put("ParsingErrorUnexpectedEOF", new ProblemAttributes(20));
            expectedProblemAttributes.put("PatternVariableNotInScope", new ProblemAttributes(180));
            expectedProblemAttributes.put("PatternVariableRedefined", new ProblemAttributes(60));
            expectedProblemAttributes.put("PatternSubtypeOfExpression", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalModifierForPatternVariable", new ProblemAttributes(60));
            expectedProblemAttributes.put("PatternVariableRedeclared", new ProblemAttributes(60));
            expectedProblemAttributes.put("PolymorphicMethodNotBelow17", new ProblemAttributes(50));
            expectedProblemAttributes.put("PossibleAccidentalBooleanAssignment", new ProblemAttributes(90));
            expectedProblemAttributes.put("PotentialHeapPollutionFromVararg", new ProblemAttributes(130));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseable", new ProblemAttributes(90));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseableAtExit", new ProblemAttributes(90));
            expectedProblemAttributes.put("PotentialNullLocalVariableReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("PotentialNullExpressionReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("PotentialNullMessageSendReference", new ProblemAttributes(90));
            expectedProblemAttributes.put("PotentialNullUnboxing", new ProblemAttributes(90));
            expectedProblemAttributes.put("ProviderMethodOrConstructorRequiredForServiceImpl", new ProblemAttributes(40));
            expectedProblemAttributes.put("PublicClassMustMatchFileName", new ProblemAttributes(40));
            expectedProblemAttributes.put("PatternSwitchNullOnlyOrFirstWithDefault", new ProblemAttributes(180));
            expectedProblemAttributes.put("PatternSwitchCaseDefaultOnlyAsSecond", new ProblemAttributes(180));
            expectedProblemAttributes.put("RawMemberTypeCannotBeParameterized", new ProblemAttributes(40));
            expectedProblemAttributes.put("RawTypeReference", new ProblemAttributes(130));
            expectedProblemAttributes.put("RecordComponentIncompatibleNullnessVsInheritedAccessor", new ProblemAttributes(90));
            expectedProblemAttributes.put("RecursiveConstructorInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("RedefinedArgument", new ProblemAttributes(60));
            expectedProblemAttributes.put("RedefinedLocal", new ProblemAttributes(60));
            expectedProblemAttributes.put("RedundantSpecificationOfTypeArguments", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantLocalVariableNullAssignment", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullAnnotation", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullCheckAgainstNonNullType", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnConstNonNullField", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnField", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullExpression", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullSpecdField", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullLocalVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullMessageSend", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnNullLocalVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullCheckOnSpecdNonNullLocalVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotation", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationModule", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationPackage", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationType", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationMethod", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationLocal", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationField", new ProblemAttributes(120));
            expectedProblemAttributes.put("RedundantSuperinterface", new ProblemAttributes(120));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityMismatch", new ProblemAttributes(90));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityUnchecked", new ProblemAttributes(90));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedef", new ProblemAttributes(90));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedefUnchecked", new ProblemAttributes(90));
            expectedProblemAttributes.put("ReferenceToForwardField", new ProblemAttributes(50));
            expectedProblemAttributes.put("RequiredNonNullButProvidedFreeTypeVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedNull", new ProblemAttributes(90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedPotentialNull", new ProblemAttributes(90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedSpecdNullable", new ProblemAttributes(90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedUnknown", new ProblemAttributes(90));
            expectedProblemAttributes.put("ReferenceToForwardTypeVariable", new ProblemAttributes(40));
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsDocumented", new ProblemAttributes(40));
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsInherited", new ProblemAttributes(40));
            expectedProblemAttributes.put("RepeatableAnnotationTypeTargetMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("RepeatableAnnotationWithRepeatingContainerAnnotation", new ProblemAttributes(40));
            expectedProblemAttributes.put("RepeatedAnnotationWithContainerAnnotation", new ProblemAttributes(40));
            expectedProblemAttributes.put("ResourceHasToImplementAutoCloseable", new ProblemAttributes(40));
            expectedProblemAttributes.put("ResourceIsNotAValue", new ProblemAttributes(60));
            expectedProblemAttributes.put("ReturnTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeCannotBeVoidArray", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("ReturnTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("SafeVarargsOnFixedArityMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("SafeVarargsOnNonFinalInstanceMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("ServiceImplDefaultConstructorNotPublic", new ProblemAttributes(40));
            expectedProblemAttributes.put("ServiceImplNotDefinedByModule", new ProblemAttributes(40));
            expectedProblemAttributes.put("ShouldImplementHashcode", new ProblemAttributes(90));
            expectedProblemAttributes.put("ShouldMarkMethodAsOwning", new ProblemAttributes(90));
            expectedProblemAttributes.put("ShouldReturnValue", new ProblemAttributes(50));
            expectedProblemAttributes.put("ShouldReturnValueHintMissingDefault", new ProblemAttributes(50));
            expectedProblemAttributes.put("SpecdNonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes(90));
            expectedProblemAttributes.put("StaticInheritedMethodConflicts", new ProblemAttributes(50));
            expectedProblemAttributes.put("StaticMemberOfParameterizedType", new ProblemAttributes(40));
            expectedProblemAttributes.put("StaticMethodRequested", new ProblemAttributes(50));
            expectedProblemAttributes.put("StaticMethodShouldBeAccessedStatically", new ProblemAttributes(50));
            expectedProblemAttributes.put("StaticResourceField", new ProblemAttributes(90));
            expectedProblemAttributes.put("StringConstantIsExceedingUtf8Limit", new ProblemAttributes(60));
            expectedProblemAttributes.put("SuperAccessCannotBypassDirectSuper", new ProblemAttributes(40));
            expectedProblemAttributes.put("SuperCallCannotBypassOverride", new ProblemAttributes(50));
            expectedProblemAttributes.put("SuperInterfaceMustBeAnInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("SuperInterfacesCollide", new ProblemAttributes(40));
            expectedProblemAttributes.put("SuperTypeUsingWildcard", new ProblemAttributes(40));
            expectedProblemAttributes.put("SuperclassAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("SuperclassInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("SuperclassInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("SuperclassMustBeAClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("SuperclassNotFound", DEPRECATED);
            expectedProblemAttributes.put("SuperclassNotVisible", DEPRECATED);
            expectedProblemAttributes.put("SuperfluousSemicolon", new ProblemAttributes(90));
            expectedProblemAttributes.put("SwitchOnEnumNotBelow15", new ProblemAttributes(40));
            expectedProblemAttributes.put("SwitchOnStringsNotBelow17", new ProblemAttributes(40));
            expectedProblemAttributes.put("TargetTypeNotAFunctionalInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("Task", new ProblemAttributes(60));
            expectedProblemAttributes.put("ThisInStaticContext", new ProblemAttributes(60));
            expectedProblemAttributes.put("ThisSuperDuringConstructorInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("ToleratedMisplacedTypeAnnotations", new ProblemAttributes(20));
            expectedProblemAttributes.put("TooManyArgumentSlots", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyArrayDimensions", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyBytesForStringConstant", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyConstantsInConstantPool", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyFields", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyLocalVariableSlots", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyMethods", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManyParametersForSyntheticMethod", new ProblemAttributes(60));
            expectedProblemAttributes.put("TooManySyntheticArgumentSlots", new ProblemAttributes(60));
            expectedProblemAttributes.put("TypeAnnotationAtQualifiedName", new ProblemAttributes(20));
            expectedProblemAttributes.put("TypeArgumentMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("TypeArgumentsForRawGenericConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("TypeArgumentsForRawGenericMethod", new ProblemAttributes(40));
            expectedProblemAttributes.put("TypeCollidesWithPackage", new ProblemAttributes(40));
            expectedProblemAttributes.put("TypeHidingType", new ProblemAttributes(100));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromMethod", new ProblemAttributes(100));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromType", new ProblemAttributes(100));
            expectedProblemAttributes.put("TypeMismatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("TypeMissingDeprecatedAnnotation", new ProblemAttributes(80));
            expectedProblemAttributes.put("TypeParameterHidingType", new ProblemAttributes(100));
            expectedProblemAttributes.put("UnboxingConversion", new ProblemAttributes(80));
            expectedProblemAttributes.put("UncheckedAccessOfValueOfFreeTypeVariable", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnclosedCloseable", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnclosedCloseableAtExit", new ProblemAttributes(90));
            expectedProblemAttributes.put("UndefinedAnnotationMember", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedConstructorInDefaultConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedConstructorInImplicitConstructorCall", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedField", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedLabel", new ProblemAttributes(60));
            expectedProblemAttributes.put("UndefinedMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedModule", new ProblemAttributes(160));
            expectedProblemAttributes.put("UndefinedModuleAddReads", new ProblemAttributes(10));
            expectedProblemAttributes.put("UndefinedName", new ProblemAttributes(50));
            expectedProblemAttributes.put("UndefinedType", new ProblemAttributes(40));
            expectedProblemAttributes.put("UndefinedTypeVariable", new ProblemAttributes(60));
            expectedProblemAttributes.put("UnderscoresInLiteralsNotBelow17", new ProblemAttributes(20));
            expectedProblemAttributes.put("UndocumentedEmptyBlock", new ProblemAttributes(80));
            expectedProblemAttributes.put("UnexpectedStaticModifierForField", new ProblemAttributes(50));
            expectedProblemAttributes.put("UnexpectedStaticModifierForMethod", new ProblemAttributes(50));
            expectedProblemAttributes.put("UnhandledException", new ProblemAttributes(40));
            expectedProblemAttributes.put("UnhandledExceptionInDefaultConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("UnhandledExceptionInImplicitConstructorCall", new ProblemAttributes(40));
            expectedProblemAttributes.put("UnhandledExceptionOnAutoClose", new ProblemAttributes(40));
            expectedProblemAttributes.put("UnhandledWarningToken", new ProblemAttributes(120));
            expectedProblemAttributes.put("UninitializedBlankFinalField", new ProblemAttributes(50));
            expectedProblemAttributes.put("UninitializedBlankFinalFieldHintMissingDefault", new ProblemAttributes(50));
            expectedProblemAttributes.put("UninitializedFreeTypeVariableField", new ProblemAttributes(90));
            expectedProblemAttributes.put("UninitializedFreeTypeVariableFieldHintMissingDefault", new ProblemAttributes(90));
            expectedProblemAttributes.put("UninitializedLocalVariable", new ProblemAttributes(60));
            expectedProblemAttributes.put("UninitializedLocalVariableHintMissingDefault", new ProblemAttributes(60));
            expectedProblemAttributes.put("UninitializedNonNullField", new ProblemAttributes(90));
            expectedProblemAttributes.put("UninitializedNonNullFieldHintMissingDefault", new ProblemAttributes(90));
            expectedProblemAttributes.put("UninternedIdentityComparison", new ProblemAttributes(20));
            expectedProblemAttributes.put("UnlikelyCollectionMethodArgumentType", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnlikelyEqualsArgumentType", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnmatchedBracket", new ProblemAttributes(20));
            expectedProblemAttributes.put("UnnamedPackageInNamedModule", new ProblemAttributes(160));
            expectedProblemAttributes.put("UnnecessaryArgumentCast", DEPRECATED);
            expectedProblemAttributes.put("UnnecessaryCast", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnnecessaryElse", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnnecessaryInstanceof", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnnecessaryNLSTag", new ProblemAttributes(140));
            expectedProblemAttributes.put("UnnecessaryNullCaseInSwitchOverNonNull", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnqualifiedFieldAccess", new ProblemAttributes(80));
            expectedProblemAttributes.put("UnreachableCatch", new ProblemAttributes(40));
            expectedProblemAttributes.put("UnresolvedVariable", new ProblemAttributes(50));
            expectedProblemAttributes.put("UnsafeCast", new ProblemAttributes(40));
            expectedProblemAttributes.put("UnsafeElementTypeConversion", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeGenericArrayForVarargs", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeGenericCast", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeNullnessCast", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnsafeRawConstructorInvocation", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeRawFieldAssignment", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeRawGenericConstructorInvocation", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeRawGenericMethodInvocation", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeRawMethodInvocation", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeReturnTypeOverride", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnsafeTypeConversion", new ProblemAttributes(130));
            expectedProblemAttributes.put("UnstableAutoModuleName", new ProblemAttributes(90));
            expectedProblemAttributes.put("ConflictingPackageInModules", new ProblemAttributes(160));
            expectedProblemAttributes.put("UnterminatedComment", new ProblemAttributes(20));
            expectedProblemAttributes.put("UnterminatedString", new ProblemAttributes(20));
            expectedProblemAttributes.put("UnusedConstructorDeclaredThrownException", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedImport", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedLabel", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedMethodDeclaredThrownException", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedObjectAllocation", new ProblemAttributes(90));
            expectedProblemAttributes.put("UnusedPrivateConstructor", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedPrivateField", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedPrivateMethod", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedPrivateType", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedTypeArgumentsForConstructorInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("UnusedTypeParameter", new ProblemAttributes(120));
            expectedProblemAttributes.put("UnusedTypeArgumentsForMethodInvocation", new ProblemAttributes(50));
            expectedProblemAttributes.put("UnusedWarningToken", new ProblemAttributes(120));
            expectedProblemAttributes.put("UseAssertAsAnIdentifier", new ProblemAttributes(80));
            expectedProblemAttributes.put("UseEnumAsAnIdentifier", new ProblemAttributes(80));
            expectedProblemAttributes.put("IllegalUseOfUnderscoreAsAnIdentifier", new ProblemAttributes(20));
            expectedProblemAttributes.put("ErrorUseOfUnderscoreAsAnIdentifier", new ProblemAttributes(20));
            expectedProblemAttributes.put("UsingDeprecatedConstructor", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedField", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedModule", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedPackage", new ProblemAttributes(160));
            expectedProblemAttributes.put("UsingDeprecatedType", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionConstructor", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionField", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionModule", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionPackage", new ProblemAttributes(160));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionType", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedConstructor", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedField", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedModule", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedPackage", new ProblemAttributes(160));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedType", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionConstructor", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionField", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionMethod", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionModule", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionPackage", new ProblemAttributes(160));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionType", new ProblemAttributes(110));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionType", new ProblemAttributes(110));
            expectedProblemAttributes.put("VarCannotBeUsedWithTypeArguments", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarCannotBeMixedWithNonVarParams", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarIsNotAllowedHere", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarIsReserved", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarIsReservedInFuture", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarLocalCannotBeArray", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarLocalCannotBeArrayInitalizers", new ProblemAttributes(40));
            expectedProblemAttributes.put("VarLocalCannotBeLambda", new ProblemAttributes(40));
            expectedProblemAttributes.put("VarLocalCannotBeMethodReference", new ProblemAttributes(40));
            expectedProblemAttributes.put("VarLocalInitializedToNull", new ProblemAttributes(40));
            expectedProblemAttributes.put("VarLocalInitializedToVoid", new ProblemAttributes(40));
            expectedProblemAttributes.put("VarLocalMultipleDeclarators", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarLocalReferencesItself", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarLocalCannotBeArray", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarLocalWithoutInitizalier", new ProblemAttributes(20));
            expectedProblemAttributes.put("VarargsElementTypeNotVisible", new ProblemAttributes(50));
            expectedProblemAttributes.put("VarargsElementTypeNotVisibleForConstructor", new ProblemAttributes(50));
            expectedProblemAttributes.put("VarargsConflict", new ProblemAttributes(50));
            expectedProblemAttributes.put("VariableTypeCannotBeVoid", new ProblemAttributes(60));
            expectedProblemAttributes.put("VariableTypeCannotBeVoidArray", DEPRECATED);
            expectedProblemAttributes.put("VoidMethodReturnsValue", new ProblemAttributes(50));
            expectedProblemAttributes.put("WildcardConstructorInvocation", new ProblemAttributes(40));
            expectedProblemAttributes.put("WildcardFieldAssignment", new ProblemAttributes(40));
            expectedProblemAttributes.put("WildcardMethodInvocation", new ProblemAttributes(40));
            expectedProblemAttributes.put("WrongCaseType", new ProblemAttributes(180));
            expectedProblemAttributes.put("illFormedParameterizationOfFunctionalInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("lambdaParameterTypeMismatched", new ProblemAttributes(40));
            expectedProblemAttributes.put("lambdaSignatureMismatched", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalArrayOfUnionType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalArrayTypeInIntersectionCast", new ProblemAttributes(40));
            expectedProblemAttributes.put("ProblemNotAnalysed", new ProblemAttributes(120));
            expectedProblemAttributes.put("SwitchExpressionsIncompatibleResultExpressionTypes", new ProblemAttributes(40));
            expectedProblemAttributes.put("SwitchExpressionsEmptySwitchBlock", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsNoResultExpression", new ProblemAttributes(40));
            expectedProblemAttributes.put("SwitchExpressionSwitchLabeledBlockCompletesNormally", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionLastStatementCompletesNormally", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionIllegalLastStatement", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionTrailingSwitchLabels", new ProblemAttributes(60));
            expectedProblemAttributes.put("switchMixedCase", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionMissingDefaultCase", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionNotBelow12", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchCaseLabelWithArrowNotBelow12", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionPreviewDisabled", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchCaseLabelWithArrowPreviewDisabled", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionBreakMissingValue", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionMissingEnumConstantCase", new ProblemAttributes(60));
            expectedProblemAttributes.put("PreviewFeatureDisabled", new ProblemAttributes(170));
            expectedProblemAttributes.put("PreviewFeatureUsed", new ProblemAttributes(170));
            expectedProblemAttributes.put("PreviewFeatureNotSupported", new ProblemAttributes(170));
            expectedProblemAttributes.put("PreviewFeaturesNotAllowed", new ProblemAttributes(180));
            expectedProblemAttributes.put("FeatureNotSupported", new ProblemAttributes(170));
            expectedProblemAttributes.put("PreviewAPIUsed", new ProblemAttributes(170));
            expectedProblemAttributes.put("PreviewAPIDisabled", new ProblemAttributes(170));
            expectedProblemAttributes.put("JavaVersionNotSupported", new ProblemAttributes(170));
            expectedProblemAttributes.put("JavaVersionTooRecent", new ProblemAttributes(170));
            expectedProblemAttributes.put("SwitchExpressionsYieldIncompatibleResultExpressionTypes", new ProblemAttributes(40));
            expectedProblemAttributes.put("SwitchExpressionsYieldEmptySwitchBlock", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldNoResultExpression", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionaYieldSwitchLabeledBlockCompletesNormally", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsYieldLastStatementCompletesNormally", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsYieldTrailingSwitchLabels", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchPreviewMixedCase", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldMissingDefaultCase", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldMissingValue", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldMissingEnumConstantCase", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldIllegalLastStatement", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsYieldBreakNotAllowed", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldUnqualifiedMethodWarning", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldUnqualifiedMethodError", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldOutsideSwitchExpression", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsYieldRestrictedGeneralWarning", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsYieldIllegalStatement", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsYieldTypeDeclarationWarning", new ProblemAttributes(60));
            expectedProblemAttributes.put("SwitchExpressionsYieldTypeDeclarationError", new ProblemAttributes(60));
            expectedProblemAttributes.put("MultiConstantCaseLabelsNotSupported", new ProblemAttributes(20));
            expectedProblemAttributes.put("ArrowInCaseStatementsNotSupported", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsNotSupported", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsBreakOutOfSwitchExpression", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsContinueOutOfSwitchExpression", new ProblemAttributes(20));
            expectedProblemAttributes.put("SwitchExpressionsReturnWithinSwitchExpression", new ProblemAttributes(20));
            expectedProblemAttributes.put("RecordIllegalModifierForRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalModifierForInnerRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalComponentNameInRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordNonStaticFieldDeclarationInRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordAccessorMethodHasThrowsClause", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCanonicalConstructorHasThrowsClause", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCanonicalConstructorVisibilityReduced", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordMultipleCanonicalConstructors", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCompactConstructorHasReturnStatement", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordDuplicateComponent", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalNativeModifierInRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordInstanceInitializerBlockInRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RestrictedTypeName", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalAccessorReturnType", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordAccessorMethodShouldNotBeGeneric", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordAccessorMethodShouldBePublic", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCanonicalConstructorShouldNotBeGeneric", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCanonicalConstructorHasReturnStatement", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCanonicalConstructorHasExplicitConstructorCall", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCompactConstructorHasExplicitConstructorCall", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordNestedRecordInherentlyStatic", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordAccessorMethodShouldNotBeStatic", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCannotExtendRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordComponentCannotBeVoid", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalVararg", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordStaticReferenceToOuterLocalVariable", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordCannotDefineRecordInLocalType", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordComponentsCannotHaveModifiers", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalParameterNameInCanonicalConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalExplicitFinalFieldAssignInCompactConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordMissingExplicitConstructorCallInNonCanonicalConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalStaticModifierForLocalClassOrInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalModifierForLocalRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordIllegalExtendedDimensionsForRecordComponent", new ProblemAttributes(20));
            expectedProblemAttributes.put("LocalStaticsIllegalVisibilityModifierForInterfaceLocalType", new ProblemAttributes(40));
            expectedProblemAttributes.put("IllegalModifierForLocalEnumDeclaration", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedMissingClassModifier", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedDisAllowedNonSealedModifierInClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedSuperClassDoesNotPermit", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedSuperInterfaceDoesNotPermit", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedMissingSealedModifier", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedMissingInterfaceModifier", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedDuplicateTypeInPermits", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedNotDirectSuperClass", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedPermittedTypeOutsideOfModule", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedPermittedTypeOutsideOfPackage", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedSealedTypeMissingPermits", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedInterfaceIsSealedAndNonSealed", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedDisAllowedNonSealedModifierInInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedNotDirectSuperInterface", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedLocalDirectSuperTypeSealed", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedAnonymousClassCannotExtendSealedType", new ProblemAttributes(40));
            expectedProblemAttributes.put("LocalReferencedInGuardMustBeEffectivelyFinal", new ProblemAttributes(180));
            expectedProblemAttributes.put("SealedSuperTypeInDifferentPackage", new ProblemAttributes(40));
            expectedProblemAttributes.put("SealedSuperTypeDisallowed", new ProblemAttributes(40));
            expectedProblemAttributes.put("SafeVarargsOnSyntheticRecordAccessor", new ProblemAttributes(true));
            expectedProblemAttributes.put("DiscouragedValueBasedTypeSynchronization", new ProblemAttributes(true));
            expectedProblemAttributes.put("ConstantWithPatternIncompatible", new ProblemAttributes(true));
            expectedProblemAttributes.put("IllegalFallthroughToPattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("IllegalFallthroughFromAPattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("OnlyOnePatternCaseLabelAllowed", new ProblemAttributes(true));
            expectedProblemAttributes.put("CannotMixPatternAndDefault", new ProblemAttributes(true));
            expectedProblemAttributes.put("CannotMixNullAndNonTypePattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("PatternDominated", new ProblemAttributes(true));
            expectedProblemAttributes.put("IllegalTotalPatternWithDefault", new ProblemAttributes(true));
            expectedProblemAttributes.put("EnhancedSwitchMissingDefault", new ProblemAttributes(true));
            expectedProblemAttributes.put("UnexpectedTypeinSwitchPattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("UnexpectedTypeinRecordPattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("RecordPatternMismatch", new ProblemAttributes(true));
            expectedProblemAttributes.put("PatternTypeMismatch", new ProblemAttributes(true));
            expectedProblemAttributes.put("RawTypeInRecordPattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("FalseConstantInGuard", new ProblemAttributes(true));
            expectedProblemAttributes.put("CannotInferRecordPatternTypes", new ProblemAttributes(true));
            expectedProblemAttributes.put("IllegalRecordPattern", new ProblemAttributes(true));
            expectedProblemAttributes.put("ImplicitClassMissingMainMethod", new ProblemAttributes(true));
            expectedProblemAttributes.put("ClassExtendFinalRecord", new ProblemAttributes(40));
            expectedProblemAttributes.put("RecordErasureIncompatibilityInCanonicalConstructor", new ProblemAttributes(40));
            expectedProblemAttributes.put("DimensionsIllegalOnRecordPattern", new ProblemAttributes(60));
            expectedProblemAttributes.put("JavadocInvalidModule", new ProblemAttributes(60));
            expectedProblemAttributes.put("UnderscoreCannotBeUsedHere", new ProblemAttributes(180));
            expectedProblemAttributes.put("UnnamedVariableMustHaveInitializer", new ProblemAttributes(180));
            expectedProblemAttributes.put("ExpressionInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("FieldReadInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("ThisInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("AllocationInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("MessageSendInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("DisallowedStatementInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("DuplicateExplicitConstructorCall", new ProblemAttributes(180));
            expectedProblemAttributes.put("SuperFieldAssignInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("SuperFieldAssignInEarlyConstructionContextLambda", new ProblemAttributes(180));
            expectedProblemAttributes.put("AssignFieldWithInitializerInEarlyConstructionContext", new ProblemAttributes(180));
            expectedProblemAttributes.put("ConstructorCallNotAllowedHere", new ProblemAttributes(180));
            expectedProblemAttributes.put("NamedPatternVariablesDisallowedHere", new ProblemAttributes(60));
            expectedProblemAttributes.put("OperandStackExceeds64KLimit", new ProblemAttributes(60));
            expectedProblemAttributes.put("OperandStackSizeInappropriate", new ProblemAttributes(60));
            expectedProblemAttributes.put("IllegalModifierCombinationForType", new ProblemAttributes(40));
            expectedProblemAttributes.put("LambdaParameterIsNeverUsed", new ProblemAttributes(120));
            expectedProblemAttributes.put("FunctionalInterfaceMayNotbeSealed", new ProblemAttributes(40));
            expectedProblemAttributes.put("CompactConstructorOnlyInRecords", new ProblemAttributes(40));
            expectedProblemAttributes.put("LocalMustBeEffectivelyFinal", new ProblemAttributes(60));
            expectedProblemAttributes.put("ResourceLocalMustBeEffectivelyFinal", new ProblemAttributes(60));
            expectedProblemAttributes.put("RecordAccessorMissingOverrideAnnotation", new ProblemAttributes(40));
            StringBuilder failures = new StringBuilder();
            StringBuilder correctResult = new StringBuilder(70000);
            Class<IProblem> iProblemClass = IProblem.class;
            Field[] fields = IProblem.class.getFields();
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Field field1 = (Field)o1;
                    Field field2 = (Field)o2;
                    return field1.getName().compareTo(field2.getName());
                }
            });
            boolean watchInternalCategory = false;
            boolean printHeader = true;
            int i = 0;
            int length = fields.length;
            while (i < length) {
                int problemId;
                int maskedProblemId;
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && (maskedProblemId = (problemId = field.getInt(iProblemClass)) & 0x1FFFFF) != 0 && maskedProblemId != 0x1FFFFF) {
                    String name = field.getName();
                    ProblemAttributes expectedAttributes = (ProblemAttributes)expectedProblemAttributes.get(name);
                    if (expectedAttributes == null) {
                        failures.append("missing expected problem attributes for problem " + name + "\n");
                        actualCategory = ProblemReporter.getProblemCategory((int)1, (int)problemId);
                        correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", new ProblemAttributes(CategorizedProblem." + this.categoryName(actualCategory) + "));\n");
                    } else if (!expectedAttributes.deprecated) {
                        actualCategory = ProblemReporter.getProblemCategory((int)1, (int)problemId);
                        correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", new ProblemAttributes(CategorizedProblem." + this.categoryName(actualCategory) + "));\n");
                        if (expectedAttributes.category != actualCategory) {
                            failures.append("category mismatch for problem " + name + " (expected " + this.categoryName(expectedAttributes.category) + ", got " + this.categoryName(actualCategory) + ")\n");
                        }
                        if (watchInternalCategory && actualCategory == 60) {
                            if (printHeader) {
                                printHeader = false;
                                System.err.println("CAT_INTERNAL for problems:");
                            }
                            System.err.println("\t" + name);
                        }
                    } else {
                        correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", DEPRECATED);\n");
                    }
                }
                ++i;
            }
            if (failures.length() > 0) {
                System.out.println(correctResult);
                System.out.println();
            }
            CompilerInvocationTests.assertEquals((String)failures.toString(), (int)0, (int)failures.length());
        }
        catch (IllegalAccessException e) {
            CompilerInvocationTests.fail((String)"could not access members");
        }
    }

    private String categoryName(int category) {
        if (categoryNames == null) {
            categoryNames = new HashMap();
            Field[] fields = CategorizedProblem.class.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                String name;
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && (name = field.getName()).startsWith("CAT_")) {
                    try {
                        categoryNames.put(field.getInt(CategorizedProblem.class), name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return (String)categoryNames.get(category);
    }

    public void test012_compiler_problems_tuning() {
        try {
            class ProblemAttributes {
                boolean skip;
                String option;

                ProblemAttributes(String option) {
                    this.option = option;
                }

                ProblemAttributes(boolean skip) {
                    this.skip = skip;
                }
            }
            ProblemAttributes SKIP = new ProblemAttributes(true);
            HashMap<String, ProblemAttributes> expectedProblemAttributes = new HashMap<String, ProblemAttributes>();
            expectedProblemAttributes.put("AbstractMethodCannotBeOverridden", SKIP);
            expectedProblemAttributes.put("AbstractMethodInAbstractClass", SKIP);
            expectedProblemAttributes.put("AbstractMethodInEnum", SKIP);
            expectedProblemAttributes.put("AbstractMethodMustBeImplemented", SKIP);
            expectedProblemAttributes.put("AbstractMethodMustBeImplementedOverConcreteMethod", SKIP);
            expectedProblemAttributes.put("AbstractMethodsInConcreteClass", SKIP);
            expectedProblemAttributes.put("AbstractServiceImplementation", SKIP);
            expectedProblemAttributes.put("AllocatingLocalInStaticContext", SKIP);
            expectedProblemAttributes.put("AmbiguousConstructor", SKIP);
            expectedProblemAttributes.put("AmbiguousConstructorInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("AmbiguousConstructorInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("AmbiguousField", SKIP);
            expectedProblemAttributes.put("AmbiguousMethod", SKIP);
            expectedProblemAttributes.put("AmbiguousType", SKIP);
            expectedProblemAttributes.put("AnnotatedTypeArgumentToUnannotated", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.annotatedTypeArgumentToUnannotated"));
            expectedProblemAttributes.put("AnnotatedTypeArgumentToUnannotatedSuperHint", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.annotatedTypeArgumentToUnannotated"));
            expectedProblemAttributes.put("AnnotationCannotOverrideMethod", SKIP);
            expectedProblemAttributes.put("AnnotationCircularity", SKIP);
            expectedProblemAttributes.put("AnnotationCircularitySelfReference", SKIP);
            expectedProblemAttributes.put("AnnotationFieldNeedConstantInitialization", SKIP);
            expectedProblemAttributes.put("AnnotationMembersCannotHaveParameters", SKIP);
            expectedProblemAttributes.put("AnnotationMembersCannotHaveTypeParameters", SKIP);
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveConstructor", SKIP);
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperclass", SKIP);
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperinterfaces", SKIP);
            expectedProblemAttributes.put("AnnotationTypeUsedAsSuperInterface", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface"));
            expectedProblemAttributes.put("AnnotationValueMustBeAnEnumConstant", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeAnnotation", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeArrayInitializer", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeClassLiteral", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeConstant", SKIP);
            expectedProblemAttributes.put("AnonymousClassCannotExtendFinalClass", SKIP);
            expectedProblemAttributes.put("ApplicableMethodOverriddenByInapplicable", SKIP);
            expectedProblemAttributes.put("ArgumentHidingField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("ArgumentHidingLocalVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("ArgumentIsNeverUsed", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedParameter"));
            expectedProblemAttributes.put("ArgumentTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoid", SKIP);
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoidArray", SKIP);
            expectedProblemAttributes.put("ArgumentTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ArgumentTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ArgumentTypeNotFound", SKIP);
            expectedProblemAttributes.put("ArgumentTypeNotVisible", SKIP);
            expectedProblemAttributes.put("ArrayConstantsOnlyInArrayInitializers", SKIP);
            expectedProblemAttributes.put("ArrayReferencePotentialNullReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("ArrayReferenceRequired", SKIP);
            expectedProblemAttributes.put("AssignmentHasNoEffect", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.noEffectAssignment"));
            expectedProblemAttributes.put("AssignmentToMultiCatchParameter", SKIP);
            expectedProblemAttributes.put("AssignmentToResource", SKIP);
            expectedProblemAttributes.put("AutoManagedResourceNotBelow17", SKIP);
            expectedProblemAttributes.put("AutoManagedVariableResourceNotBelow9", SKIP);
            expectedProblemAttributes.put("BinaryLiteralNotBelow17", SKIP);
            expectedProblemAttributes.put("BodyForAbstractMethod", SKIP);
            expectedProblemAttributes.put("BodyForNativeMethod", SKIP);
            expectedProblemAttributes.put("BoundCannotBeArray", SKIP);
            expectedProblemAttributes.put("BoundHasConflictingArguments", SKIP);
            expectedProblemAttributes.put("BoundMustBeAnInterface", SKIP);
            expectedProblemAttributes.put("BoxingConversion", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.autoboxing"));
            expectedProblemAttributes.put("BytecodeExceeds64KLimit", SKIP);
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForClinit", SKIP);
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForConstructor", SKIP);
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForSwitchTable", SKIP);
            expectedProblemAttributes.put("CannotAllocateVoidArray", SKIP);
            expectedProblemAttributes.put("CannotDeclareEnumSpecialMethod", SKIP);
            expectedProblemAttributes.put("CannotDefineAnnotationInLocalType", SKIP);
            expectedProblemAttributes.put("CannotDefineDimensionExpressionsWithInit", SKIP);
            expectedProblemAttributes.put("CannotDefineEnumInLocalType", SKIP);
            expectedProblemAttributes.put("CannotDefineInterfaceInLocalType", SKIP);
            expectedProblemAttributes.put("CannotDefineStaticInitializerInLocalType", SKIP);
            expectedProblemAttributes.put("CannotExtendEnum", SKIP);
            expectedProblemAttributes.put("CannotHideAnInstanceMethodWithAStaticMethod", SKIP);
            expectedProblemAttributes.put("CannotImportPackage", SKIP);
            expectedProblemAttributes.put("CannotImplementIncompatibleNullness", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("CannotInferElidedTypes", SKIP);
            expectedProblemAttributes.put("CannotInferInvocationType", SKIP);
            expectedProblemAttributes.put("CannotInvokeSuperConstructorInEnum", SKIP);
            expectedProblemAttributes.put("CannotOverrideAStaticMethodWithAnInstanceMethod", SKIP);
            expectedProblemAttributes.put("CannotReadSource", SKIP);
            expectedProblemAttributes.put("CannotReturnInInitializer", SKIP);
            expectedProblemAttributes.put("CannotThrowNull", SKIP);
            expectedProblemAttributes.put("CannotThrowType", SKIP);
            expectedProblemAttributes.put("CannotUseDiamondWithAnonymousClasses", SKIP);
            expectedProblemAttributes.put("CannotUseDiamondWithExplicitTypeArguments", SKIP);
            expectedProblemAttributes.put("CannotUseSuperInCodeSnippet", SKIP);
            expectedProblemAttributes.put("ClassExtendFinalClass", SKIP);
            expectedProblemAttributes.put("CodeCannotBeReached", SKIP);
            expectedProblemAttributes.put("CodeSnippetMissingClass", SKIP);
            expectedProblemAttributes.put("CodeSnippetMissingMethod", SKIP);
            expectedProblemAttributes.put("ComparingIdentical", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.comparingIdentical"));
            expectedProblemAttributes.put("ConstNonNullFieldComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("ConflictingImport", SKIP);
            expectedProblemAttributes.put("ConflictingNullAnnotations", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ConstructedArrayIncompatible", SKIP);
            expectedProblemAttributes.put("ConstructionTypeMismatch", SKIP);
            expectedProblemAttributes.put("ConflictingInheritedNullAnnotations", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ConstructorReferenceNotBelow18", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeHasNonDefaultMembers", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeHasShorterRetention", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeHasWrongValueType", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeMustHaveValue", SKIP);
            expectedProblemAttributes.put("ContradictoryNullAnnotations", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsOnBound", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsInferred", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsInferredFunctionType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ConstructorVarargsArgumentNeedCast", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast"));
            expectedProblemAttributes.put("CorruptedSignature", SKIP);
            expectedProblemAttributes.put("CyclicModuleDependency", SKIP);
            expectedProblemAttributes.put("DanglingReference", SKIP);
            expectedProblemAttributes.put("DeadCode", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deadCode"));
            expectedProblemAttributes.put("DefaultMethodNotBelow18", SKIP);
            expectedProblemAttributes.put("DefaultMethodOverridesObjectMethod", SKIP);
            expectedProblemAttributes.put("DefaultTrueAndFalseCases", SKIP);
            expectedProblemAttributes.put("DereferencingNullableExpression", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("DiamondNotBelow17", SKIP);
            expectedProblemAttributes.put("DirectInvocationOfAbstractMethod", SKIP);
            expectedProblemAttributes.put("DisallowedTargetForAnnotation", SKIP);
            expectedProblemAttributes.put("DisallowedTargetForContainerAnnotationType", SKIP);
            expectedProblemAttributes.put("DiscouragedReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.discouragedReference"));
            expectedProblemAttributes.put("DuplicateAnnotation", SKIP);
            expectedProblemAttributes.put("DuplicateAnnotationNotMarkedRepeatable", SKIP);
            expectedProblemAttributes.put("DuplicateAnnotationMember", SKIP);
            expectedProblemAttributes.put("DuplicateBlankFinalFieldInitialization", SKIP);
            expectedProblemAttributes.put("DuplicateBounds", SKIP);
            expectedProblemAttributes.put("DuplicateBoundInIntersectionCast", SKIP);
            expectedProblemAttributes.put("DuplicateCase", SKIP);
            expectedProblemAttributes.put("DuplicateDefaultCase", SKIP);
            expectedProblemAttributes.put("DuplicateExports", SKIP);
            expectedProblemAttributes.put("DuplicateField", SKIP);
            expectedProblemAttributes.put("DuplicateFinalLocalInitialization", SKIP);
            expectedProblemAttributes.put("DuplicateImport", SKIP);
            expectedProblemAttributes.put("DuplicateInheritedMethods", SKIP);
            expectedProblemAttributes.put("DuplicateInheritedDefaultMethods", SKIP);
            expectedProblemAttributes.put("DuplicateLabel", SKIP);
            expectedProblemAttributes.put("DuplicateMethod", SKIP);
            expectedProblemAttributes.put("DuplicateMethodErasure", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForArgument", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForField", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForMethod", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForType", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForVariable", SKIP);
            expectedProblemAttributes.put("DuplicateModuleRef", SKIP);
            expectedProblemAttributes.put("DuplicateNestedType", SKIP);
            expectedProblemAttributes.put("DuplicateOpens", SKIP);
            expectedProblemAttributes.put("DuplicateParameterizedMethods", SKIP);
            expectedProblemAttributes.put("DuplicateRequires", SKIP);
            expectedProblemAttributes.put("DuplicateResource", SKIP);
            expectedProblemAttributes.put("DuplicateServices", SKIP);
            expectedProblemAttributes.put("DuplicateSuperInterface", SKIP);
            expectedProblemAttributes.put("DuplicateTargetInTargetAnnotation", SKIP);
            expectedProblemAttributes.put("DuplicateTypeVariable", SKIP);
            expectedProblemAttributes.put("DuplicateTypes", SKIP);
            expectedProblemAttributes.put("DuplicateUses", SKIP);
            expectedProblemAttributes.put("EmptyControlFlowStatement", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.emptyStatement"));
            expectedProblemAttributes.put("EnclosingInstanceInConstructorCall", SKIP);
            expectedProblemAttributes.put("EndOfSource", SKIP);
            expectedProblemAttributes.put("EnumAbstractMethodMustBeImplemented", SKIP);
            expectedProblemAttributes.put("EnumConstantCannotDefineAbstractMethod", SKIP);
            expectedProblemAttributes.put("EnumConstantMustImplementAbstractMethod", SKIP);
            expectedProblemAttributes.put("EnumConstantsCannotBeSurroundedByParenthesis", SKIP);
            expectedProblemAttributes.put("EnumStaticFieldInInInitializerContext", SKIP);
            expectedProblemAttributes.put("EnumSwitchCannotTargetField", SKIP);
            expectedProblemAttributes.put("ExceptionParameterIsNeverUsed", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter"));
            expectedProblemAttributes.put("ExceptionTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("ExceptionTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ExceptionTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ExceptionTypeNotFound", SKIP);
            expectedProblemAttributes.put("ExceptionTypeNotVisible", SKIP);
            expectedProblemAttributes.put("ExplicitThisParameterNotInLambda", SKIP);
            expectedProblemAttributes.put("ExplicitThisParameterNotBelow18", SKIP);
            expectedProblemAttributes.put("ExplicitlyClosedAutoCloseable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable"));
            expectedProblemAttributes.put("ExportingForeignPackage", SKIP);
            expectedProblemAttributes.put("ExportedPackageDoesNotExistOrIsEmpty", SKIP);
            expectedProblemAttributes.put("ExpressionShouldBeAVariable", SKIP);
            expectedProblemAttributes.put("ExternalProblemFixable", SKIP);
            expectedProblemAttributes.put("ExternalProblemNotFixable", SKIP);
            expectedProblemAttributes.put("ExplicitAnnotationTargetRequired", SKIP);
            expectedProblemAttributes.put("FallthroughCase", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.fallthroughCase"));
            expectedProblemAttributes.put("FieldComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("FieldHidingField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.fieldHiding"));
            expectedProblemAttributes.put("FieldHidingLocalVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.fieldHiding"));
            expectedProblemAttributes.put("FieldMissingDeprecatedAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation"));
            expectedProblemAttributes.put("FieldMustBeFinal", SKIP);
            expectedProblemAttributes.put("FieldTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("FieldTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("FieldTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("FieldTypeNotFound", SKIP);
            expectedProblemAttributes.put("FieldTypeNotVisible", SKIP);
            expectedProblemAttributes.put("FieldWithUnresolvedOwningAnnotation", SKIP);
            expectedProblemAttributes.put("FinalBoundForTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.finalParameterBound"));
            expectedProblemAttributes.put("FinalFieldAssignment", SKIP);
            expectedProblemAttributes.put("FinalMethodCannotBeOverridden", SKIP);
            expectedProblemAttributes.put("FinalOuterLocalAssignment", SKIP);
            expectedProblemAttributes.put("FinallyMustCompleteNormally", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally"));
            expectedProblemAttributes.put("ForbiddenReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.forbiddenReference"));
            expectedProblemAttributes.put("GenericConstructorTypeArgumentMismatch", SKIP);
            expectedProblemAttributes.put("GenericInferenceError", SKIP);
            expectedProblemAttributes.put("GenericMethodTypeArgumentMismatch", SKIP);
            expectedProblemAttributes.put("GenericTypeCannotExtendThrowable", SKIP);
            expectedProblemAttributes.put("HidingEnclosingType", SKIP);
            expectedProblemAttributes.put("HierarchyCircularity", SKIP);
            expectedProblemAttributes.put("HierarchyCircularitySelfReference", SKIP);
            expectedProblemAttributes.put("HierarchyHasProblems", SKIP);
            expectedProblemAttributes.put("IllegalAbstractModifierCombinationForMethod", SKIP);
            expectedProblemAttributes.put("IllegalStrictfpForAbstractInterfaceMethod", SKIP);
            expectedProblemAttributes.put("IllegalAccessFromTypeVariable", SKIP);
            expectedProblemAttributes.put("IllegalAnnotationForBaseType", SKIP);
            expectedProblemAttributes.put("IllegalCast", SKIP);
            expectedProblemAttributes.put("IllegalClassLiteralForTypeVariable", SKIP);
            expectedProblemAttributes.put("IllegalDeclarationOfThisParameter", SKIP);
            expectedProblemAttributes.put("IllegalDefaultModifierSpecification", SKIP);
            expectedProblemAttributes.put("IllegalDefinitionToNonNullParameter", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalDimension", SKIP);
            expectedProblemAttributes.put("IllegalEnclosingInstanceSpecification", SKIP);
            expectedProblemAttributes.put("IllegalExtendedDimensions", SKIP);
            expectedProblemAttributes.put("IllegalExtendedDimensionsForVarArgs", SKIP);
            expectedProblemAttributes.put("IllegalGenericArray", SKIP);
            expectedProblemAttributes.put("IllegalHexaLiteral", SKIP);
            expectedProblemAttributes.put("IllegalInstanceofParameterizedType", SKIP);
            expectedProblemAttributes.put("IllegalInstanceofTypeParameter", SKIP);
            expectedProblemAttributes.put("IllegalBasetypeInIntersectionCast", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationFinalAbstractForClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationFinalVolatileForField", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationForInterfaceMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationForPrivateInterfaceMethod9", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationField", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationMemberType", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationType", SKIP);
            expectedProblemAttributes.put("IllegalModifierForArgument", SKIP);
            expectedProblemAttributes.put("IllegalModifierForClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierForConstructor", SKIP);
            expectedProblemAttributes.put("StrictfpNotRequired", SKIP);
            expectedProblemAttributes.put("IllegalModifierForEnum", SKIP);
            expectedProblemAttributes.put("IllegalModifierForEnumConstant", SKIP);
            expectedProblemAttributes.put("IllegalModifierForEnumConstructor", SKIP);
            expectedProblemAttributes.put("IllegalModifierForField", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterface", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceField", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod18", SKIP);
            expectedProblemAttributes.put("IllegalModifierForLocalClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierForLocalEnum", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMemberClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMemberEnum", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMemberInterface", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForModule", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod9", SKIP);
            expectedProblemAttributes.put("IllegalModifierForVariable", SKIP);
            expectedProblemAttributes.put("IllegalModifiersForElidedType", SKIP);
            expectedProblemAttributes.put("IllegalModifiers", SKIP);
            expectedProblemAttributes.put("IllegalParameterNullityRedefinition", SKIP);
            expectedProblemAttributes.put("IllegalPrimitiveOrArrayTypeForEnclosingInstance", SKIP);
            expectedProblemAttributes.put("IllegalQualifiedEnumConstantLabel", SKIP);
            expectedProblemAttributes.put("IllegalQualifiedParameterizedTypeAllocation", SKIP);
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis", SKIP);
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis2", SKIP);
            expectedProblemAttributes.put("IllegalRedefinitionOfTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalRedefinitionToNonNullParameter", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalReturnNullityRedefinition", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalReturnNullityRedefinitionFreeTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalStaticModifierForMemberType", SKIP);
            expectedProblemAttributes.put("IllegalTypeAnnotationsInStaticMemberAccess", SKIP);
            expectedProblemAttributes.put("IllegalTypeArgumentsInRawConstructorReference", SKIP);
            expectedProblemAttributes.put("IllegalTypeForExplicitThis", SKIP);
            expectedProblemAttributes.put("IllegalTypeVariableSuperReference", SKIP);
            expectedProblemAttributes.put("IllegalUnderscorePosition", SKIP);
            expectedProblemAttributes.put("IllegalUsageOfQualifiedTypeReference", SKIP);
            expectedProblemAttributes.put("IllegalUsageOfTypeAnnotations", SKIP);
            expectedProblemAttributes.put("IllegalVararg", SKIP);
            expectedProblemAttributes.put("IllegalVarargInLambda", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForField", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMemberType", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMethod", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierForInterfaceMemberType", SKIP);
            expectedProblemAttributes.put("ImplicitObjectBoundNoNullDefault", SKIP);
            expectedProblemAttributes.put("ImportAmbiguous", SKIP);
            expectedProblemAttributes.put("ImportInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ImportInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ImportNotFound", SKIP);
            expectedProblemAttributes.put("ImportNotVisible", SKIP);
            expectedProblemAttributes.put("IncompatibleCaseType", SKIP);
            expectedProblemAttributes.put("IncompatibleExceptionInInheritedMethodThrowsClause", SKIP);
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClause", SKIP);
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClauseForNonInheritedInterfaceMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod"));
            expectedProblemAttributes.put("IncompatibleReturnType", SKIP);
            expectedProblemAttributes.put("IncompatibleReturnTypeForNonInheritedInterfaceMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod"));
            expectedProblemAttributes.put("IncompatibleTypesInConditionalOperator", SKIP);
            expectedProblemAttributes.put("IncompatibleTypesInEqualityOperator", SKIP);
            expectedProblemAttributes.put("IncompatibleTypesInForeach", SKIP);
            expectedProblemAttributes.put("IncompatibleLambdaParameterType", SKIP);
            expectedProblemAttributes.put("IncompatibleMethodReference", SKIP);
            expectedProblemAttributes.put("IncorrectArityForParameterizedConstructor", SKIP);
            expectedProblemAttributes.put("IncorrectArityForParameterizedMethod", SKIP);
            expectedProblemAttributes.put("IncorrectArityForParameterizedType", SKIP);
            expectedProblemAttributes.put("IncorrectEnclosingInstanceReference", SKIP);
            expectedProblemAttributes.put("IncorrectSwitchType", SKIP);
            expectedProblemAttributes.put("IncorrectSwitchType17", SKIP);
            expectedProblemAttributes.put("IndirectAccessToStaticField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess"));
            expectedProblemAttributes.put("IndirectAccessToStaticMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess"));
            expectedProblemAttributes.put("IndirectAccessToStaticType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess"));
            expectedProblemAttributes.put("InheritedDefaultMethodConflictsWithOtherInherited", SKIP);
            expectedProblemAttributes.put("InheritedFieldHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InheritedIncompatibleReturnType", SKIP);
            expectedProblemAttributes.put("InheritedMethodHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InheritedMethodReducesVisibility", SKIP);
            expectedProblemAttributes.put("InheritedParameterLackingNonNullAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped"));
            expectedProblemAttributes.put("InheritedTypeHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InitializerMustCompleteNormally", SKIP);
            expectedProblemAttributes.put("InstanceFieldDuringConstructorInvocation", SKIP);
            expectedProblemAttributes.put("InstanceMethodDuringConstructorInvocation", SKIP);
            expectedProblemAttributes.put("InterfaceAmbiguous", SKIP);
            expectedProblemAttributes.put("InterfaceCannotHaveConstructors", SKIP);
            expectedProblemAttributes.put("InterfaceCannotHaveInitializers", SKIP);
            expectedProblemAttributes.put("InterfaceInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InterfaceInternalNameProvided", SKIP);
            expectedProblemAttributes.put("InterfaceNotFound", SKIP);
            expectedProblemAttributes.put("InterfaceNotFunctionalInterface", SKIP);
            expectedProblemAttributes.put("InterfaceNotVisible", SKIP);
            expectedProblemAttributes.put("InterfaceStaticMethodInvocationNotBelow18", SKIP);
            expectedProblemAttributes.put("InterfaceSuperInvocationNotBelow18", SKIP);
            expectedProblemAttributes.put("InternalTypeNameProvided", SKIP);
            expectedProblemAttributes.put("IntersectionCastNotBelow18", SKIP);
            expectedProblemAttributes.put("InvalidAnnotationMemberType", SKIP);
            expectedProblemAttributes.put("InvalidArrayConstructorReference", SKIP);
            expectedProblemAttributes.put("InvalidBinary", SKIP);
            expectedProblemAttributes.put("InvalidBreak", SKIP);
            expectedProblemAttributes.put("InvalidCatchBlockSequence", SKIP);
            expectedProblemAttributes.put("InvalidCharacterConstant", SKIP);
            expectedProblemAttributes.put("InvalidClassInstantiation", SKIP);
            expectedProblemAttributes.put("InvalidContinue", SKIP);
            expectedProblemAttributes.put("InvalidDigit", SKIP);
            expectedProblemAttributes.put("InvalidEncoding", SKIP);
            expectedProblemAttributes.put("InvalidEscape", SKIP);
            expectedProblemAttributes.put("InvalidExplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("InvalidExpressionAsStatement", SKIP);
            expectedProblemAttributes.put("InvalidFileNameForPackageAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidFloat", SKIP);
            expectedProblemAttributes.put("InvalidHexa", SKIP);
            expectedProblemAttributes.put("InvalidHighSurrogate", SKIP);
            expectedProblemAttributes.put("InvalidInput", SKIP);
            expectedProblemAttributes.put("InvalidLowSurrogate", SKIP);
            expectedProblemAttributes.put("InvalidLocationForModifiers", SKIP);
            expectedProblemAttributes.put("InvalidNullToSynchronized", SKIP);
            expectedProblemAttributes.put("InvalidOctal", SKIP);
            expectedProblemAttributes.put("InvalidOpensStatement", SKIP);
            expectedProblemAttributes.put("InvalidOperator", SKIP);
            expectedProblemAttributes.put("InvalidParameterizedExceptionType", SKIP);
            expectedProblemAttributes.put("InvalidParenthesizedExpression", SKIP);
            expectedProblemAttributes.put("InvalidServiceIntfType", SKIP);
            expectedProblemAttributes.put("InvalidServiceImplType", SKIP);
            expectedProblemAttributes.put("InvalidTypeArguments", SKIP);
            expectedProblemAttributes.put("InvalidTypeExpression", SKIP);
            expectedProblemAttributes.put("InvalidTypeForCollection", SKIP);
            expectedProblemAttributes.put("InvalidTypeForCollectionTarget14", SKIP);
            expectedProblemAttributes.put("InvalidTypeForStaticImport", SKIP);
            expectedProblemAttributes.put("InvalidTypeToSynchronized", SKIP);
            expectedProblemAttributes.put("InvalidTypeVariableExceptionType", SKIP);
            expectedProblemAttributes.put("InvalidUnaryExpression", SKIP);
            expectedProblemAttributes.put("InvalidUnicodeEscape", SKIP);
            expectedProblemAttributes.put("InvalidUnionTypeReferenceSequence", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfAnnotationDeclarations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfEnumDeclarations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfForeachStatements", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfReceiverAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfStaticImports", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeArguments", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeParameters", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForAnnotationDeclaration", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForEnumDeclaration", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfVarargs", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfWildcard", SKIP);
            expectedProblemAttributes.put("InvalidVoidExpression", SKIP);
            expectedProblemAttributes.put("IsClassPathCorrect", SKIP);
            expectedProblemAttributes.put("IsClassPathCorrectWithReferencingType", SKIP);
            expectedProblemAttributes.put("JavadocAmbiguousConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousMethodReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateParamName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateProvidesTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateReturnTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateThrowsClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateUsesTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocEmptyReturnTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocGenericConstructorTypeArgumentMismatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocGenericMethodTypeArgumentMismatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocHiddenReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInheritedFieldHidesEnclosingName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInheritedMethodHidesEnclosingName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInheritedNameHidesEnclosingTypeName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInternalTypeNameProvided", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidMemberTypeQualification", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidModuleQualification", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidParamName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidParamTagName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidParamTagTypeParameter", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidProvidesClass", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidProvidesClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeArgs", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeHref", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeUrlReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidThrowsClass", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidThrowsClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidUsesClass", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidUsesClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidValueReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMalformedSeeReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMessagePrefix", SKIP);
            expectedProblemAttributes.put("JavadocMissing", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingJavadocComments"));
            expectedProblemAttributes.put("JavadocMissingHashCharacter", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingIdentifier", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingParamName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingParamTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocMissingProvidesClass", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingProvidesClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingProvidesTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocMissingReturnTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocMissingSeeReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingTagDescription", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingThrowsClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingThrowsTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocMissingUsesClass", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingUsesClassName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingUsesTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocNoMessageSendOnArrayType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNoMessageSendOnBaseType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNonGenericConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNonGenericMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNonStaticTypeFromStaticInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotAccessibleType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocParameterMismatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocParameterizedConstructorArgumentTypeMismatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocParameterizedMethodArgumentTypeMismatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUnexpectedTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUnexpectedText", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSnippet", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSnippetMissingColon", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSnippetContentNewLine", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSnippetRegionNotClosed", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSnippetRegexSubstringTogether", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSnippetDuplicateRegions", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUnterminatedInlineTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("LambdaDescriptorMentionsUnmentionable", SKIP);
            expectedProblemAttributes.put("LambdaExpressionNotBelow18", SKIP);
            expectedProblemAttributes.put("LambdaRedeclaresArgument", SKIP);
            expectedProblemAttributes.put("LambdaRedeclaresLocal", SKIP);
            expectedProblemAttributes.put("LambdaShapeComputationError", SKIP);
            expectedProblemAttributes.put("LocalVariableCanOnlyBeNull", SKIP);
            expectedProblemAttributes.put("LocalVariableCannotBeNull", SKIP);
            expectedProblemAttributes.put("LocalVariableHidingField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("LocalVariableHidingLocalVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("LocalVariableIsNeverUsed", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedLocal"));
            expectedProblemAttributes.put("LocalVariableMayBeNull", SKIP);
            expectedProblemAttributes.put("MaskedCatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock"));
            expectedProblemAttributes.put("MandatoryCloseNotShown", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable"));
            expectedProblemAttributes.put("MandatoryCloseNotShownAtExit", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable"));
            expectedProblemAttributes.put("MessageSendWithUnresolvedOwningAnnotation", SKIP);
            expectedProblemAttributes.put("MethodButWithConstructorName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName"));
            expectedProblemAttributes.put("MethodCanBePotentiallyStatic", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic"));
            expectedProblemAttributes.put("MethodCanBeStatic", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic"));
            expectedProblemAttributes.put("MethodMissingDeprecatedAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation"));
            expectedProblemAttributes.put("MethodMustOverride", SKIP);
            expectedProblemAttributes.put("MethodMustOverrideOrImplement", SKIP);
            expectedProblemAttributes.put("MethodNameClash", SKIP);
            expectedProblemAttributes.put("MethodNameClashHidden", SKIP);
            expectedProblemAttributes.put("MethodReducesVisibility", SKIP);
            expectedProblemAttributes.put("MethodReferenceNotBelow18", SKIP);
            expectedProblemAttributes.put("MethodReferenceSwingsBothWays", SKIP);
            expectedProblemAttributes.put("MethodRequiresBody", SKIP);
            expectedProblemAttributes.put("MethodReturnsVoid", SKIP);
            expectedProblemAttributes.put("MethodVarargsArgumentNeedCast", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast"));
            expectedProblemAttributes.put("MisplacedTypeAnnotations", SKIP);
            expectedProblemAttributes.put("MissingArgumentsForParameterizedMemberType", SKIP);
            expectedProblemAttributes.put("MissingDefaultCase", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingDefaultCase"));
            expectedProblemAttributes.put("MissingEnclosingInstance", SKIP);
            expectedProblemAttributes.put("MissingEnclosingInstanceForConstructorCall", SKIP);
            expectedProblemAttributes.put("MissingEnumConstantCase", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch"));
            expectedProblemAttributes.put("MissingEnumConstantCaseDespiteDefault", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch"));
            expectedProblemAttributes.put("MissingEnumDefaultCase", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingDefaultCase"));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnPackage", new ProblemAttributes("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation"));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnType", new ProblemAttributes("org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation"));
            expectedProblemAttributes.put("MissingNullAnnotationImplicitlyUsed", SKIP);
            expectedProblemAttributes.put("MissingOverrideAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation"));
            expectedProblemAttributes.put("MissingOverrideAnnotationForInterfaceMethodImplementation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation"));
            expectedProblemAttributes.put("MissingRequiresTransitiveForTypeInAPI", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.APILeak"));
            expectedProblemAttributes.put("MissingReturnType", SKIP);
            expectedProblemAttributes.put("MissingSemiColon", SKIP);
            expectedProblemAttributes.put("MissingSerialVersion", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingSerialVersion"));
            expectedProblemAttributes.put("MissingSynchronizedModifierInInheritedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod"));
            expectedProblemAttributes.put("MissingTypeInConstructor", SKIP);
            expectedProblemAttributes.put("MissingTypeInLambda", SKIP);
            expectedProblemAttributes.put("ModifierOnRequiresJavaBase", SKIP);
            expectedProblemAttributes.put("ModifierOnRequiresJavaBasePreview", SKIP);
            expectedProblemAttributes.put("UnterminatedTextBlock", SKIP);
            expectedProblemAttributes.put("MissingTypeInMethod", SKIP);
            expectedProblemAttributes.put("MissingTypeForInference", SKIP);
            expectedProblemAttributes.put("MissingValueForAnnotationMember", SKIP);
            expectedProblemAttributes.put("MissingValueFromLambda", SKIP);
            expectedProblemAttributes.put("ModuleNotRead", SKIP);
            expectedProblemAttributes.put("MultiCatchNotBelow17", SKIP);
            expectedProblemAttributes.put("MultipleFunctionalInterfaces", SKIP);
            expectedProblemAttributes.put("StaticInterfaceMethodNotBelow18", SKIP);
            expectedProblemAttributes.put("MustDefineEitherDimensionExpressionsOrInitializer", SKIP);
            expectedProblemAttributes.put("MustSpecifyPackage", SKIP);
            expectedProblemAttributes.put("NativeMethodsCannotBeStrictfp", SKIP);
            expectedProblemAttributes.put("NeedToEmulateConstructorAccess", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NeedToEmulateFieldReadAccess", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NeedToEmulateFieldWriteAccess", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NeedToEmulateMethodAccess", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("SyntheticAccessorNotEnclosingMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NestedServiceImpl", SKIP);
            expectedProblemAttributes.put("NoAdditionalBoundAfterTypeVariable", SKIP);
            expectedProblemAttributes.put("NoFieldOnBaseType", SKIP);
            expectedProblemAttributes.put("NoGenericLambda", SKIP);
            expectedProblemAttributes.put("NoImplicitStringConversionForCharArrayExpression", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion"));
            expectedProblemAttributes.put("NoMessageSendOnArrayType", SKIP);
            expectedProblemAttributes.put("NoMessageSendOnBaseType", SKIP);
            expectedProblemAttributes.put("NoSuperInInterfaceContext", SKIP);
            expectedProblemAttributes.put("NonBlankFinalLocalAssignment", SKIP);
            expectedProblemAttributes.put("NonConstantExpression", SKIP);
            expectedProblemAttributes.put("NonDenotableTypeArgumentForAnonymousDiamond", SKIP);
            expectedProblemAttributes.put("NonExternalizedStringLiteral", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral"));
            expectedProblemAttributes.put("NonGenericConstructor", SKIP);
            expectedProblemAttributes.put("NonGenericMethod", SKIP);
            expectedProblemAttributes.put("NonGenericType", SKIP);
            expectedProblemAttributes.put("NonNullArrayContentNotInitialized", SKIP);
            expectedProblemAttributes.put("NonNullDefaultDetailIsNotEvaluated", SKIP);
            expectedProblemAttributes.put("NonNullExpressionComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullSpecdFieldComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullMessageSendComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullTypeVariableFromLegacyMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation"));
            expectedProblemAttributes.put("NonNullMethodTypeVariableFromLegacyMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation"));
            expectedProblemAttributes.put("NonPublicTypeInAPI", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.APILeak"));
            expectedProblemAttributes.put("NonStaticAccessToStaticField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver"));
            expectedProblemAttributes.put("NonStaticAccessToStaticMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver"));
            expectedProblemAttributes.put("NonStaticContextForEnumMemberType", SKIP);
            expectedProblemAttributes.put("NonStaticFieldFromStaticInvocation", SKIP);
            expectedProblemAttributes.put("NonStaticOrAlienTypeReceiver", SKIP);
            expectedProblemAttributes.put("NonStaticTypeFromStaticInvocation", SKIP);
            expectedProblemAttributes.put("NotAnnotationType", SKIP);
            expectedProblemAttributes.put("NotAccessibleConstructor", SKIP);
            expectedProblemAttributes.put("NotAccessibleField", SKIP);
            expectedProblemAttributes.put("NotAccessibleMethod", SKIP);
            expectedProblemAttributes.put("NotAccessibleType", SKIP);
            expectedProblemAttributes.put("NotAccessiblePackage", SKIP);
            expectedProblemAttributes.put("NotExportedTypeInAPI", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.APILeak"));
            expectedProblemAttributes.put("ConflictingPackageFromModules", SKIP);
            expectedProblemAttributes.put("ConflictingPackageFromOtherModules", SKIP);
            expectedProblemAttributes.put("NotOwningResourceField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis"));
            expectedProblemAttributes.put("NotVisibleConstructor", SKIP);
            expectedProblemAttributes.put("NotVisibleConstructorInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("NotVisibleConstructorInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("NotVisibleField", SKIP);
            expectedProblemAttributes.put("NotVisibleMethod", SKIP);
            expectedProblemAttributes.put("NotVisibleType", SKIP);
            expectedProblemAttributes.put("NullableFieldReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("NullAnnotationAtQualifyingType", SKIP);
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocation", SKIP);
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocationAtType", SKIP);
            expectedProblemAttributes.put("NullityMismatchAgainstFreeTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables"));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotationSuperHint", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityMismatchTypeArgument", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetail", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetailSuperHint", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("NullExpressionReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NullLocalVariableComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NullLocalVariableInstanceofYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NullLocalVariableReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NullNotCompatibleToFreeTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables"));
            expectedProblemAttributes.put("NullSourceString", SKIP);
            expectedProblemAttributes.put("NullUnboxing", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NumericValueOutOfRange", SKIP);
            expectedProblemAttributes.put("ObjectCannotBeGeneric", SKIP);
            expectedProblemAttributes.put("ObjectCannotHaveSuperTypes", SKIP);
            expectedProblemAttributes.put("ObjectHasNoSuperclass", SKIP);
            expectedProblemAttributes.put("ObjectMustBeClass", SKIP);
            expectedProblemAttributes.put("OuterLocalMustBeEffectivelyFinal", SKIP);
            expectedProblemAttributes.put("OuterLocalMustBeFinal", SKIP);
            expectedProblemAttributes.put("OverrideAddingReturnOwning", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.incompatibleOwningContract"));
            expectedProblemAttributes.put("OverrideReducingParamterOwning", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.incompatibleOwningContract"));
            expectedProblemAttributes.put("OverridingDeprecatedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("OverridingDeprecatedSinceVersionMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("OverridingTerminallyDeprecatedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("OverridingTerminallyDeprecatedSinceVersionMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("OverridingMethodWithoutSuperInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation"));
            expectedProblemAttributes.put("OverridingNonVisibleMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod"));
            expectedProblemAttributes.put("OwningFieldInNonResourceClass", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis"));
            expectedProblemAttributes.put("OwningFieldShouldImplementClose", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis"));
            expectedProblemAttributes.put("PackageCollidesWithType", SKIP);
            expectedProblemAttributes.put("PackageDoesNotExistOrIsEmpty", SKIP);
            expectedProblemAttributes.put("PackageIsNotExpectedPackage", SKIP);
            expectedProblemAttributes.put("ParameterAssignment", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.parameterAssignment"));
            expectedProblemAttributes.put("ParameterLackingNonNullAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped"));
            expectedProblemAttributes.put("ParameterLackingNullableAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ParameterMismatch", SKIP);
            expectedProblemAttributes.put("ParameterizedConstructorArgumentTypeMismatch", SKIP);
            expectedProblemAttributes.put("ParameterizedMethodArgumentTypeMismatch", SKIP);
            expectedProblemAttributes.put("ParameterWithUnresolvedOwningAnnotation", SKIP);
            expectedProblemAttributes.put("ParsingError", SKIP);
            expectedProblemAttributes.put("ParsingErrorDeleteToken", SKIP);
            expectedProblemAttributes.put("ParsingErrorDeleteTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertToComplete", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertToCompletePhrase", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertToCompleteScope", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertTokenAfter", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertTokenBefore", SKIP);
            expectedProblemAttributes.put("ParsingErrorInvalidToken", SKIP);
            expectedProblemAttributes.put("ParsingErrorMergeTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorMisplacedConstruct", SKIP);
            expectedProblemAttributes.put("ParsingErrorNoSuggestion", SKIP);
            expectedProblemAttributes.put("ParsingErrorNoSuggestionForTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorOnKeyword", SKIP);
            expectedProblemAttributes.put("ParsingErrorOnKeywordNoSuggestion", SKIP);
            expectedProblemAttributes.put("ParsingErrorReplaceTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorUnexpectedEOF", SKIP);
            expectedProblemAttributes.put("PatternVariableNotInScope", SKIP);
            expectedProblemAttributes.put("PatternVariableRedefined", SKIP);
            expectedProblemAttributes.put("PatternSubtypeOfExpression", SKIP);
            expectedProblemAttributes.put("IllegalModifierForPatternVariable", SKIP);
            expectedProblemAttributes.put("PatternVariableRedeclared", SKIP);
            expectedProblemAttributes.put("PolymorphicMethodNotBelow17", SKIP);
            expectedProblemAttributes.put("PossibleAccidentalBooleanAssignment", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment"));
            expectedProblemAttributes.put("PotentialHeapPollutionFromVararg", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable"));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseableAtExit", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable"));
            expectedProblemAttributes.put("PotentialNullExpressionReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PotentialNullLocalVariableReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PotentialNullUnboxing", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PotentialNullMessageSendReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("ProblemNotAnalysed", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.suppressWarningsNotFullyAnalysed"));
            expectedProblemAttributes.put("ProviderMethodOrConstructorRequiredForServiceImpl", SKIP);
            expectedProblemAttributes.put("PublicClassMustMatchFileName", SKIP);
            expectedProblemAttributes.put("PatternSwitchNullOnlyOrFirstWithDefault", SKIP);
            expectedProblemAttributes.put("PatternSwitchCaseDefaultOnlyAsSecond", SKIP);
            expectedProblemAttributes.put("RawMemberTypeCannotBeParameterized", SKIP);
            expectedProblemAttributes.put("RawTypeReference", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.rawTypeReference"));
            expectedProblemAttributes.put("RecordComponentIncompatibleNullnessVsInheritedAccessor", SKIP);
            expectedProblemAttributes.put("RecursiveConstructorInvocation", SKIP);
            expectedProblemAttributes.put("RedefinedArgument", SKIP);
            expectedProblemAttributes.put("RedefinedLocal", SKIP);
            expectedProblemAttributes.put("RedundantSpecificationOfTypeArguments", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments"));
            expectedProblemAttributes.put("RedundantLocalVariableNullAssignment", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullCheckAgainstNonNullType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnConstNonNullField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullExpression", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullSpecdField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullLocalVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullMessageSend", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNullLocalVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnSpecdNonNullLocalVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationModule", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationPackage", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationLocal", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantSuperinterface", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface"));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityMismatch", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityUnchecked", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedef", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedefUnchecked", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("ReferenceToForwardField", SKIP);
            expectedProblemAttributes.put("ReferenceToForwardTypeVariable", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsDocumented", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsInherited", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationTypeTargetMismatch", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationWithRepeatingContainerAnnotation", SKIP);
            expectedProblemAttributes.put("RepeatedAnnotationWithContainerAnnotation", SKIP);
            expectedProblemAttributes.put("RequiredNonNullButProvidedFreeTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedNull", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedPotentialNull", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedUnknown", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedSpecdNullable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ResourceHasToImplementAutoCloseable", SKIP);
            expectedProblemAttributes.put("ResourceIsNotAValue", SKIP);
            expectedProblemAttributes.put("ReturnTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("ReturnTypeCannotBeVoidArray", SKIP);
            expectedProblemAttributes.put("ReturnTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ReturnTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ReturnTypeMismatch", SKIP);
            expectedProblemAttributes.put("ReturnTypeNotFound", SKIP);
            expectedProblemAttributes.put("ReturnTypeNotVisible", SKIP);
            expectedProblemAttributes.put("SafeVarargsOnFixedArityMethod", SKIP);
            expectedProblemAttributes.put("SafeVarargsOnNonFinalInstanceMethod", SKIP);
            expectedProblemAttributes.put("ServiceImplDefaultConstructorNotPublic", SKIP);
            expectedProblemAttributes.put("ServiceImplNotDefinedByModule", SKIP);
            expectedProblemAttributes.put("ShouldImplementHashcode", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod"));
            expectedProblemAttributes.put("ShouldMarkMethodAsOwning", SKIP);
            expectedProblemAttributes.put("ShouldReturnValue", SKIP);
            expectedProblemAttributes.put("ShouldReturnValueHintMissingDefault", SKIP);
            expectedProblemAttributes.put("SpecdNonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("StaticInheritedMethodConflicts", SKIP);
            expectedProblemAttributes.put("StaticMemberOfParameterizedType", SKIP);
            expectedProblemAttributes.put("StaticMethodRequested", SKIP);
            expectedProblemAttributes.put("StaticMethodShouldBeAccessedStatically", SKIP);
            expectedProblemAttributes.put("StaticResourceField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.insufficientResourceAnalysis"));
            expectedProblemAttributes.put("StringConstantIsExceedingUtf8Limit", SKIP);
            expectedProblemAttributes.put("SuperAccessCannotBypassDirectSuper", SKIP);
            expectedProblemAttributes.put("SuperCallCannotBypassOverride", SKIP);
            expectedProblemAttributes.put("SuperInterfaceMustBeAnInterface", SKIP);
            expectedProblemAttributes.put("SuperInterfacesCollide", SKIP);
            expectedProblemAttributes.put("SuperTypeUsingWildcard", SKIP);
            expectedProblemAttributes.put("SuperclassAmbiguous", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod"));
            expectedProblemAttributes.put("SuperclassInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("SuperclassInternalNameProvided", SKIP);
            expectedProblemAttributes.put("SuperclassMustBeAClass", SKIP);
            expectedProblemAttributes.put("SuperclassNotFound", SKIP);
            expectedProblemAttributes.put("SuperclassNotVisible", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface"));
            expectedProblemAttributes.put("SuperfluousSemicolon", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.emptyStatement"));
            expectedProblemAttributes.put("SwitchOnEnumNotBelow15", SKIP);
            expectedProblemAttributes.put("SwitchOnStringsNotBelow17", SKIP);
            expectedProblemAttributes.put("TargetTypeNotAFunctionalInterface", SKIP);
            expectedProblemAttributes.put("Task", SKIP);
            expectedProblemAttributes.put("ThisInStaticContext", SKIP);
            expectedProblemAttributes.put("ThisSuperDuringConstructorInvocation", SKIP);
            expectedProblemAttributes.put("ToleratedMisplacedTypeAnnotations", SKIP);
            expectedProblemAttributes.put("TooManyArgumentSlots", SKIP);
            expectedProblemAttributes.put("TooManyArrayDimensions", SKIP);
            expectedProblemAttributes.put("TooManyBytesForStringConstant", SKIP);
            expectedProblemAttributes.put("TooManyConstantsInConstantPool", SKIP);
            expectedProblemAttributes.put("TooManyFields", SKIP);
            expectedProblemAttributes.put("TooManyLocalVariableSlots", SKIP);
            expectedProblemAttributes.put("TooManyMethods", SKIP);
            expectedProblemAttributes.put("TooManyParametersForSyntheticMethod", SKIP);
            expectedProblemAttributes.put("TooManySyntheticArgumentSlots", SKIP);
            expectedProblemAttributes.put("TypeAnnotationAtQualifiedName", SKIP);
            expectedProblemAttributes.put("TypeArgumentMismatch", SKIP);
            expectedProblemAttributes.put("TypeArgumentsForRawGenericConstructor", SKIP);
            expectedProblemAttributes.put("TypeArgumentsForRawGenericMethod", SKIP);
            expectedProblemAttributes.put("TypeCollidesWithPackage", SKIP);
            expectedProblemAttributes.put("TypeHidingType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("TypeMismatch", SKIP);
            expectedProblemAttributes.put("TypeMissingDeprecatedAnnotation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation"));
            expectedProblemAttributes.put("TypeParameterHidingType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("UnboxingConversion", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.autoboxing"));
            expectedProblemAttributes.put("UncheckedAccessOfValueOfFreeTypeVariable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables"));
            expectedProblemAttributes.put("UnclosedCloseable", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unclosedCloseable"));
            expectedProblemAttributes.put("UnclosedCloseableAtExit", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unclosedCloseable"));
            expectedProblemAttributes.put("UndefinedAnnotationMember", SKIP);
            expectedProblemAttributes.put("UndefinedConstructor", SKIP);
            expectedProblemAttributes.put("UndefinedConstructorInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("UndefinedConstructorInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("UndefinedField", SKIP);
            expectedProblemAttributes.put("UndefinedLabel", SKIP);
            expectedProblemAttributes.put("UndefinedMethod", SKIP);
            expectedProblemAttributes.put("UndefinedModule", SKIP);
            expectedProblemAttributes.put("UndefinedModuleAddReads", SKIP);
            expectedProblemAttributes.put("UndefinedName", SKIP);
            expectedProblemAttributes.put("UndefinedType", SKIP);
            expectedProblemAttributes.put("UndefinedTypeVariable", SKIP);
            expectedProblemAttributes.put("UnderscoresInLiteralsNotBelow17", SKIP);
            expectedProblemAttributes.put("UndocumentedEmptyBlock", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock"));
            expectedProblemAttributes.put("UnexpectedStaticModifierForField", SKIP);
            expectedProblemAttributes.put("UnexpectedStaticModifierForMethod", SKIP);
            expectedProblemAttributes.put("UnhandledException", SKIP);
            expectedProblemAttributes.put("UnhandledExceptionInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("UnhandledExceptionInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("UnhandledExceptionOnAutoClose", SKIP);
            expectedProblemAttributes.put("UnhandledWarningToken", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken"));
            expectedProblemAttributes.put("UninitializedBlankFinalField", SKIP);
            expectedProblemAttributes.put("UninitializedBlankFinalFieldHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninitializedFreeTypeVariableField", SKIP);
            expectedProblemAttributes.put("UninitializedFreeTypeVariableFieldHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninitializedLocalVariable", SKIP);
            expectedProblemAttributes.put("UninitializedLocalVariableHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninitializedNonNullField", SKIP);
            expectedProblemAttributes.put("UninitializedNonNullFieldHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninternedIdentityComparison", SKIP);
            expectedProblemAttributes.put("UnlikelyCollectionMethodArgumentType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType"));
            expectedProblemAttributes.put("UnlikelyEqualsArgumentType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType"));
            expectedProblemAttributes.put("UnmatchedBracket", SKIP);
            expectedProblemAttributes.put("UnnamedPackageInNamedModule", SKIP);
            expectedProblemAttributes.put("UnnecessaryArgumentCast", SKIP);
            expectedProblemAttributes.put("UnnecessaryCast", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck"));
            expectedProblemAttributes.put("UnnecessaryElse", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unnecessaryElse"));
            expectedProblemAttributes.put("UnnecessaryInstanceof", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck"));
            expectedProblemAttributes.put("UnnecessaryNLSTag", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral"));
            expectedProblemAttributes.put("UnnecessaryNullCaseInSwitchOverNonNull", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("UnqualifiedFieldAccess", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess"));
            expectedProblemAttributes.put("UnreachableCatch", SKIP);
            expectedProblemAttributes.put("UnresolvedVariable", SKIP);
            expectedProblemAttributes.put("UnsafeCast", SKIP);
            expectedProblemAttributes.put("UnsafeElementTypeConversion", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeGenericArrayForVarargs", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeGenericCast", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeNullnessCast", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("UnsafeRawConstructorInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawFieldAssignment", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawGenericConstructorInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawGenericMethodInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawMethodInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeReturnTypeOverride", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeTypeConversion", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnstableAutoModuleName", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unstableAutoModuleName"));
            expectedProblemAttributes.put("ConflictingPackageInModules", SKIP);
            expectedProblemAttributes.put("UnterminatedComment", SKIP);
            expectedProblemAttributes.put("UnterminatedString", SKIP);
            expectedProblemAttributes.put("UnusedConstructorDeclaredThrownException", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"));
            expectedProblemAttributes.put("UnusedImport", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedImport"));
            expectedProblemAttributes.put("UnusedLabel", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedLabel"));
            expectedProblemAttributes.put("UnusedMethodDeclaredThrownException", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"));
            expectedProblemAttributes.put("UnusedObjectAllocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation"));
            expectedProblemAttributes.put("UnusedPrivateConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedPrivateField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedPrivateMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedPrivateType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedTypeArgumentsForConstructorInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation"));
            expectedProblemAttributes.put("UnusedTypeParameter", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter"));
            expectedProblemAttributes.put("UnusedTypeArgumentsForMethodInvocation", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation"));
            expectedProblemAttributes.put("UnusedWarningToken", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.unusedWarningToken"));
            expectedProblemAttributes.put("UseAssertAsAnIdentifier", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.assertIdentifier"));
            expectedProblemAttributes.put("UseEnumAsAnIdentifier", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.enumIdentifier"));
            expectedProblemAttributes.put("IllegalUseOfUnderscoreAsAnIdentifier", SKIP);
            expectedProblemAttributes.put("ErrorUseOfUnderscoreAsAnIdentifier", SKIP);
            expectedProblemAttributes.put("UsingDeprecatedConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedModule", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedPackage", SKIP);
            expectedProblemAttributes.put("UsingDeprecatedType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionModule", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionPackage", SKIP);
            expectedProblemAttributes.put("UsingDeprecatedSinceVersionType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedModule", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedPackage", SKIP);
            expectedProblemAttributes.put("UsingTerminallyDeprecatedType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionConstructor", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionField", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionMethod", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionModule", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionPackage", SKIP);
            expectedProblemAttributes.put("UsingTerminallyDeprecatedSinceVersionType", new ProblemAttributes("org.eclipse.jdt.core.compiler.problem.terminalDeprecation"));
            expectedProblemAttributes.put("VarargsConflict", SKIP);
            expectedProblemAttributes.put("VarargsElementTypeNotVisible", SKIP);
            expectedProblemAttributes.put("VarargsElementTypeNotVisibleForConstructor", SKIP);
            expectedProblemAttributes.put("VariableTypeCannotBeVoid", SKIP);
            expectedProblemAttributes.put("VariableTypeCannotBeVoidArray", SKIP);
            expectedProblemAttributes.put("VoidMethodReturnsValue", SKIP);
            expectedProblemAttributes.put("WildcardConstructorInvocation", SKIP);
            expectedProblemAttributes.put("WildcardFieldAssignment", SKIP);
            expectedProblemAttributes.put("WildcardMethodInvocation", SKIP);
            expectedProblemAttributes.put("WrongCaseType", SKIP);
            expectedProblemAttributes.put("illFormedParameterizationOfFunctionalInterface", SKIP);
            expectedProblemAttributes.put("lambdaParameterTypeMismatched", SKIP);
            expectedProblemAttributes.put("lambdaSignatureMismatched", SKIP);
            expectedProblemAttributes.put("DisallowedExplicitThisParameter", SKIP);
            expectedProblemAttributes.put("IllegalArrayOfUnionType", SKIP);
            expectedProblemAttributes.put("IllegalArrayTypeInIntersectionCast", SKIP);
            expectedProblemAttributes.put("VarCannotBeUsedWithTypeArguments", SKIP);
            expectedProblemAttributes.put("VarCannotBeMixedWithNonVarParams", SKIP);
            expectedProblemAttributes.put("VarIsNotAllowedHere", SKIP);
            expectedProblemAttributes.put("VarIsReserved", SKIP);
            expectedProblemAttributes.put("VarIsReservedInFuture", SKIP);
            expectedProblemAttributes.put("VarLocalCannotBeArray", SKIP);
            expectedProblemAttributes.put("VarLocalCannotBeArrayInitalizers", SKIP);
            expectedProblemAttributes.put("VarLocalCannotBeLambda", SKIP);
            expectedProblemAttributes.put("VarLocalCannotBeMethodReference", SKIP);
            expectedProblemAttributes.put("VarLocalInitializedToNull", SKIP);
            expectedProblemAttributes.put("VarLocalInitializedToVoid", SKIP);
            expectedProblemAttributes.put("VarLocalMultipleDeclarators", SKIP);
            expectedProblemAttributes.put("VarLocalReferencesItself", SKIP);
            expectedProblemAttributes.put("VarLocalTooManyBrackets", SKIP);
            expectedProblemAttributes.put("VarLocalWithoutInitizalier", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsIncompatibleResultExpressionTypes", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsEmptySwitchBlock", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsNoResultExpression", SKIP);
            expectedProblemAttributes.put("SwitchExpressionSwitchLabeledBlockCompletesNormally", SKIP);
            expectedProblemAttributes.put("SwitchExpressionLastStatementCompletesNormally", SKIP);
            expectedProblemAttributes.put("SwitchExpressionIllegalLastStatement", SKIP);
            expectedProblemAttributes.put("SwitchExpressionTrailingSwitchLabels", SKIP);
            expectedProblemAttributes.put("switchMixedCase", SKIP);
            expectedProblemAttributes.put("SwitchExpressionMissingDefaultCase", SKIP);
            expectedProblemAttributes.put("SwitchExpressionNotBelow12", SKIP);
            expectedProblemAttributes.put("SwitchCaseLabelWithArrowNotBelow12", SKIP);
            expectedProblemAttributes.put("SwitchExpressionPreviewDisabled", SKIP);
            expectedProblemAttributes.put("SwitchCaseLabelWithArrowPreviewDisabled", SKIP);
            expectedProblemAttributes.put("SwitchExpressionBreakMissingValue", SKIP);
            expectedProblemAttributes.put("SwitchExpressionMissingEnumConstantCase", SKIP);
            expectedProblemAttributes.put("PreviewFeatureDisabled", SKIP);
            expectedProblemAttributes.put("PreviewFeatureUsed", SKIP);
            expectedProblemAttributes.put("PreviewFeatureNotSupported", SKIP);
            expectedProblemAttributes.put("PreviewFeaturesNotAllowed", SKIP);
            expectedProblemAttributes.put("FeatureNotSupported", SKIP);
            expectedProblemAttributes.put("PreviewAPIUsed", SKIP);
            expectedProblemAttributes.put("PreviewAPIDisabled", SKIP);
            expectedProblemAttributes.put("JavaVersionNotSupported", SKIP);
            expectedProblemAttributes.put("JavaVersionTooRecent", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldIncompatibleResultExpressionTypes", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldEmptySwitchBlock", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldNoResultExpression", SKIP);
            expectedProblemAttributes.put("SwitchExpressionaYieldSwitchLabeledBlockCompletesNormally", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldLastStatementCompletesNormally", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldTrailingSwitchLabels", SKIP);
            expectedProblemAttributes.put("SwitchPreviewMixedCase", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldMissingDefaultCase", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldMissingValue", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldMissingEnumConstantCase", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldIllegalLastStatement", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldBreakNotAllowed", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldUnqualifiedMethodWarning", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldUnqualifiedMethodError", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldOutsideSwitchExpression", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldRestrictedGeneralWarning", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldIllegalStatement", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldTypeDeclarationWarning", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsYieldTypeDeclarationError", SKIP);
            expectedProblemAttributes.put("MultiConstantCaseLabelsNotSupported", SKIP);
            expectedProblemAttributes.put("ArrowInCaseStatementsNotSupported", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsNotSupported", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsBreakOutOfSwitchExpression", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsContinueOutOfSwitchExpression", SKIP);
            expectedProblemAttributes.put("SwitchExpressionsReturnWithinSwitchExpression", SKIP);
            expectedProblemAttributes.put("RecordIllegalModifierForRecord", SKIP);
            expectedProblemAttributes.put("RecordIllegalModifierForInnerRecord", SKIP);
            expectedProblemAttributes.put("RecordIllegalComponentNameInRecord", SKIP);
            expectedProblemAttributes.put("RecordNonStaticFieldDeclarationInRecord", SKIP);
            expectedProblemAttributes.put("RecordAccessorMethodHasThrowsClause", SKIP);
            expectedProblemAttributes.put("RecordCanonicalConstructorHasThrowsClause", SKIP);
            expectedProblemAttributes.put("RecordCanonicalConstructorVisibilityReduced", SKIP);
            expectedProblemAttributes.put("RecordMultipleCanonicalConstructors", SKIP);
            expectedProblemAttributes.put("RecordCompactConstructorHasReturnStatement", SKIP);
            expectedProblemAttributes.put("RecordDuplicateComponent", SKIP);
            expectedProblemAttributes.put("RecordIllegalNativeModifierInRecord", SKIP);
            expectedProblemAttributes.put("RecordInstanceInitializerBlockInRecord", SKIP);
            expectedProblemAttributes.put("RestrictedTypeName", SKIP);
            expectedProblemAttributes.put("RecordIllegalAccessorReturnType", SKIP);
            expectedProblemAttributes.put("RecordAccessorMethodShouldNotBeGeneric", SKIP);
            expectedProblemAttributes.put("RecordAccessorMethodShouldBePublic", SKIP);
            expectedProblemAttributes.put("RecordCanonicalConstructorShouldNotBeGeneric", SKIP);
            expectedProblemAttributes.put("RecordCanonicalConstructorHasReturnStatement", SKIP);
            expectedProblemAttributes.put("RecordCanonicalConstructorHasExplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("RecordCompactConstructorHasExplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("RecordNestedRecordInherentlyStatic", SKIP);
            expectedProblemAttributes.put("RecordAccessorMethodShouldNotBeStatic", SKIP);
            expectedProblemAttributes.put("RecordCannotExtendRecord", SKIP);
            expectedProblemAttributes.put("RecordComponentCannotBeVoid", SKIP);
            expectedProblemAttributes.put("RecordIllegalVararg", SKIP);
            expectedProblemAttributes.put("RecordStaticReferenceToOuterLocalVariable", SKIP);
            expectedProblemAttributes.put("RecordCannotDefineRecordInLocalType", SKIP);
            expectedProblemAttributes.put("RecordMissingExplicitConstructorCallInNonCanonicalConstructor", SKIP);
            expectedProblemAttributes.put("RecordIllegalStaticModifierForLocalClassOrInterface", SKIP);
            expectedProblemAttributes.put("RecordIllegalExtendedDimensionsForRecordComponent", SKIP);
            expectedProblemAttributes.put("RecordIllegalModifierForLocalRecord", SKIP);
            expectedProblemAttributes.put("RecordComponentsCannotHaveModifiers", SKIP);
            expectedProblemAttributes.put("RecordIllegalParameterNameInCanonicalConstructor", SKIP);
            expectedProblemAttributes.put("RecordIllegalExplicitFinalFieldAssignInCompactConstructor", SKIP);
            expectedProblemAttributes.put("LocalStaticsIllegalVisibilityModifierForInterfaceLocalType", SKIP);
            expectedProblemAttributes.put("IllegalModifierForLocalEnumDeclaration", SKIP);
            expectedProblemAttributes.put("SealedMissingClassModifier", SKIP);
            expectedProblemAttributes.put("SealedDisAllowedNonSealedModifierInClass", SKIP);
            expectedProblemAttributes.put("SealedSuperClassDoesNotPermit", SKIP);
            expectedProblemAttributes.put("SealedSuperInterfaceDoesNotPermit", SKIP);
            expectedProblemAttributes.put("SealedMissingSealedModifier", SKIP);
            expectedProblemAttributes.put("SealedMissingInterfaceModifier", SKIP);
            expectedProblemAttributes.put("SealedDuplicateTypeInPermits", SKIP);
            expectedProblemAttributes.put("SealedNotDirectSuperClass", SKIP);
            expectedProblemAttributes.put("SealedPermittedTypeOutsideOfModule", SKIP);
            expectedProblemAttributes.put("SealedPermittedTypeOutsideOfPackage", SKIP);
            expectedProblemAttributes.put("SealedSealedTypeMissingPermits", SKIP);
            expectedProblemAttributes.put("SealedInterfaceIsSealedAndNonSealed", SKIP);
            expectedProblemAttributes.put("SealedDisAllowedNonSealedModifierInInterface", SKIP);
            expectedProblemAttributes.put("SealedSuperInterfaceDoesNotPermit", SKIP);
            expectedProblemAttributes.put("SealedNotDirectSuperInterface", SKIP);
            expectedProblemAttributes.put("SealedLocalDirectSuperTypeSealed", SKIP);
            expectedProblemAttributes.put("SealedSuperTypeInDifferentPackage", SKIP);
            expectedProblemAttributes.put("SealedSuperTypeDisallowed", SKIP);
            expectedProblemAttributes.put("SealedAnonymousClassCannotExtendSealedType", SKIP);
            expectedProblemAttributes.put("LocalReferencedInGuardMustBeEffectivelyFinal", SKIP);
            expectedProblemAttributes.put("SafeVarargsOnSyntheticRecordAccessor", SKIP);
            expectedProblemAttributes.put("DiscouragedValueBasedTypeSynchronization", SKIP);
            expectedProblemAttributes.put("ConstantWithPatternIncompatible", SKIP);
            expectedProblemAttributes.put("IllegalFallthroughToPattern", SKIP);
            expectedProblemAttributes.put("IllegalFallthroughFromAPattern", SKIP);
            expectedProblemAttributes.put("OnlyOnePatternCaseLabelAllowed", SKIP);
            expectedProblemAttributes.put("CannotMixPatternAndDefault", SKIP);
            expectedProblemAttributes.put("CannotMixNullAndNonTypePattern", SKIP);
            expectedProblemAttributes.put("PatternDominated", SKIP);
            expectedProblemAttributes.put("IllegalTotalPatternWithDefault", SKIP);
            expectedProblemAttributes.put("EnhancedSwitchMissingDefault", SKIP);
            expectedProblemAttributes.put("UnexpectedTypeinSwitchPattern", SKIP);
            expectedProblemAttributes.put("UnexpectedTypeinRecordPattern", SKIP);
            expectedProblemAttributes.put("RecordPatternMismatch", SKIP);
            expectedProblemAttributes.put("PatternTypeMismatch", SKIP);
            expectedProblemAttributes.put("RawTypeInRecordPattern", SKIP);
            expectedProblemAttributes.put("FalseConstantInGuard", SKIP);
            expectedProblemAttributes.put("CannotInferRecordPatternTypes", SKIP);
            expectedProblemAttributes.put("IllegalRecordPattern", SKIP);
            expectedProblemAttributes.put("ImplicitClassMissingMainMethod", SKIP);
            expectedProblemAttributes.put("ClassExtendFinalRecord", SKIP);
            expectedProblemAttributes.put("DimensionsIllegalOnRecordPattern", SKIP);
            expectedProblemAttributes.put("RecordErasureIncompatibilityInCanonicalConstructor", SKIP);
            expectedProblemAttributes.put("JavadocInvalidModule", SKIP);
            expectedProblemAttributes.put("UnderscoreCannotBeUsedHere", SKIP);
            expectedProblemAttributes.put("UnnamedVariableMustHaveInitializer", SKIP);
            expectedProblemAttributes.put("ExpressionInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("FieldReadInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("ThisInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("AllocationInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("MessageSendInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("DisallowedStatementInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("DuplicateExplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("SuperFieldAssignInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("SuperFieldAssignInEarlyConstructionContextLambda", SKIP);
            expectedProblemAttributes.put("AssignFieldWithInitializerInEarlyConstructionContext", SKIP);
            expectedProblemAttributes.put("ConstructorCallNotAllowedHere", SKIP);
            expectedProblemAttributes.put("NamedPatternVariablesDisallowedHere", SKIP);
            expectedProblemAttributes.put("OperandStackExceeds64KLimit", SKIP);
            expectedProblemAttributes.put("OperandStackSizeInappropriate", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationForType", SKIP);
            expectedProblemAttributes.put("LambdaParameterIsNeverUsed", SKIP);
            expectedProblemAttributes.put("FunctionalInterfaceMayNotbeSealed", SKIP);
            expectedProblemAttributes.put("CompactConstructorOnlyInRecords", SKIP);
            expectedProblemAttributes.put("LocalMustBeEffectivelyFinal", SKIP);
            expectedProblemAttributes.put("ResourceLocalMustBeEffectivelyFinal", SKIP);
            expectedProblemAttributes.put("RecordAccessorMissingOverrideAnnotation", SKIP);
            HashMap<Object, String> constantNamesIndex = new HashMap<Object, String>();
            Field[] fields = JavaCore.class.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                String fieldName;
                Field field = fields[i];
                if (field.getType() == String.class && (fieldName = field.getName()).startsWith("COMPILER_PB_")) {
                    constantNamesIndex.put(field.get(null), fieldName);
                }
                ++i;
            }
            fields = IProblem.class.getFields();
            StringBuilder failures = new StringBuilder();
            StringBuilder correctResult = new StringBuilder(70000);
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Field field1 = (Field)o1;
                    Field field2 = (Field)o2;
                    return field1.getName().compareTo(field2.getName());
                }
            });
            int i2 = 0;
            int length2 = fields.length;
            while (i2 < length2) {
                int problemId;
                int maskedProblemId;
                Field field = fields[i2];
                if (field.getType() == Integer.TYPE && (maskedProblemId = (problemId = field.getInt(null)) & 0x1FFFFF) != 0 && maskedProblemId != 0x1FFFFF) {
                    String name = field.getName();
                    ProblemAttributes expectedAttributes = (ProblemAttributes)expectedProblemAttributes.get(name);
                    String actualTuningOption = JavaCore.getOptionForConfigurableSeverity((int)problemId);
                    if (expectedAttributes == null) {
                        failures.append("missing expected problem attributes for problem " + name + "\n");
                    } else if (!expectedAttributes.skip && !expectedAttributes.option.equals(actualTuningOption)) {
                        failures.append("tuning option mismatch for problem " + name + " (expected " + expectedAttributes.option + ", got " + actualTuningOption + ")\n");
                    }
                    String optionFieldName = (String)constantNamesIndex.get(actualTuningOption);
                    correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", " + (String)(optionFieldName != null ? "new ProblemAttributes(JavaCore." + optionFieldName + ")" : "SKIP") + ");\n");
                }
                ++i2;
            }
            if (failures.length() > 0) {
                System.out.println(correctResult);
                System.out.println();
            }
            CompilerInvocationTests.assertEquals((String)failures.toString(), (int)0, (int)failures.length());
        }
        catch (IllegalAccessException e) {
            CompilerInvocationTests.fail((String)"could not access members");
        }
    }

    public void testuniqueIDs() throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = IProblem.class.getFields();
        HashMap<Integer, List> id2names = new HashMap<Integer, List>();
        int i = 0;
        int length = fields.length;
        while (i < length) {
            Field field = fields[i];
            if (field.getType() == Integer.TYPE && !this.isDeprecated(field)) {
                int problemId = field.getInt(null);
                List names = id2names.computeIfAbsent(problemId, k -> new ArrayList());
                names.add(field.getName());
            }
            ++i;
        }
        String duplicates = id2names.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> ((Integer)e.getKey()).toString() + ": " + ((List)e.getValue()).toString()).collect(Collectors.joining(", "));
        if (!duplicates.isEmpty()) {
            CompilerInvocationTests.fail((String)("The following problem IDs are used more than once: " + duplicates));
        }
    }

    private boolean isDeprecated(Field field) {
        Annotation[] annotationArray = field.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == Deprecated.class) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void testTooNewJavaVersionRequested() {
        HashMap<String, CallSite> options = new HashMap<String, CallSite>(JavaCore.getDefaultOptions());
        String latestJavaVersionSupportedByECJ = CompilerOptions.versionFromJdkLevel((long)ClassFileConstants.getLatestJDKLevel());
        String message = "----------\n1. WARNING in A.java (at line 1)\n\tclass A{}\n\t^\nCompiling for Java version 'XXX0' is not supported yet. Using 'XXX' instead\n----------\n".replaceAll("XXX", latestJavaVersionSupportedByECJ);
        options.put("org.eclipse.jdt.core.compiler.source", (CallSite)((Object)(latestJavaVersionSupportedByECJ + "0")));
        this.runNegativeTest(new String[]{"A.java", "class A{}"}, message, null, false, null, options);
    }

    static class TasksReader
    implements ICompilerRequestor {
        CompilationResult result;

        TasksReader() {
        }

        public void acceptResult(CompilationResult compilationResult) {
            this.result = compilationResult;
        }
    }
}

