/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class Compliance_1_7
extends AbstractComparableTest {
    public Compliance_1_7(String name) {
        super(name);
    }

    public static Test suite() {
        return Compliance_1_7.buildMinimalComplianceTestSuite(Compliance_1_7.testClass(), 32);
    }

    public void test1() {
        boolean check;
        this.runConformTest(new String[]{"p1/Z.java", "package p1;\nimport java.util.List;\npublic class Z  {\n\t@SafeVarargs\n\tpublic static <T> List<T> asList(T... a) {\n\t\treturn null;\n\t}\n}"}, "");
        String computedReferences = this.findReferences(OUTPUT_DIR + "/p1/Z.class");
        boolean bl = check = computedReferences.indexOf("annotationRef/SafeVarargs") >= 0;
        if (!check) {
            System.out.println(computedReferences);
        }
        Compliance_1_7.assertTrue((String)"did not indexed the reference to SafeVarargs", (boolean)check);
    }

    public void test2() {
        boolean check;
        this.runConformTest(new String[]{"p2/Z.java", "package p2;\nimport java.lang.annotation.Inherited;\n@Inherited\npublic @interface Z  {\n}"}, "");
        String computedReferences = this.findReferences(OUTPUT_DIR + "/p2/Z.class");
        boolean bl = check = computedReferences.indexOf("annotationRef/Inherited") >= 0;
        if (!check) {
            System.out.println(computedReferences);
        }
        Compliance_1_7.assertTrue((String)"did not indexed the reference to Inherited", (boolean)check);
    }

    public void testBug390889_a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runConformTest(new String[]{"MyComp.java", "import java.util.Comparator;\npublic class MyComp implements Comparator {\n\t@Override\n\tpublic int compare(Object o1, Object o2) {\n\t\treturn 0;\n\t}\n}\nclass MyStringComp implements Comparator<String> {\n\t@Override\n\tpublic int compare(String o1, String o2) {\n\t\treturn 0;\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug390889_b() {
        this.runConformTest(new String[]{"I1.java", "interface I0 {\n  void foo();\n}\npublic interface I1 extends I0 {\n  @Override\n  default void foo() {}\n}\n"});
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runConformTest(new String[]{"C1.java", "public class C1 implements I1 {\n}\n"}, "", null, false, null, options, null);
    }

    public void testBug390889_c() {
        this.runConformTest(new String[]{"I.java", "interface I {\n  default void foo() {}\n}\n"});
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        this.runConformTest(new String[]{"CI.java", "public class CI implements I {\n\t void test(I i) {\n      this.foo();\n      i.foo();\n    }\n}\n"}, "", null, false, null, options, null);
    }

    public static Class testClass() {
        return Compliance_1_7.class;
    }
}

