/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class Compliance_CLDC
extends AbstractRegressionTest {
    public Compliance_CLDC(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        return options;
    }

    public static Test suite() {
        return Compliance_CLDC.buildUniqueComplianceTestSuite(Compliance_CLDC.testClass(), CompilerOptions.getFirstSupportedJdkLevel());
    }

    public static Class testClass() {
        return Compliance_CLDC.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import java.awt.Image;\nimport java.awt.Toolkit;\nimport java.awt.image.ImageProducer;\nimport java.net.URL;\n\npublic class X {\n\n\tpublic Image loadImage(String name) {\n\t\tToolkit toolkit= Toolkit.getDefaultToolkit();\n\t\ttry {\n\t\t\tURL url= X.class.getResource(name);\n\t\t\treturn toolkit.createImage((ImageProducer) url.getContent());\n\t\t} catch (Exception ex) {\n\t\t}\n\t\treturn null;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\t\tSystem.out.println(\"OK\");\n\t}\n}"}, "OK");
    }

    public void test002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\t\tSystem.out.print(X.class != null);\n\t\t\tSystem.out.print(String.class != null);\n\t\t\tSystem.out.print(Object.class != null);\n\t\t\tSystem.out.print(X.class != null);\n\t}\n}"}, "truetruetruetrue");
    }

    public void test003() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\t\tSystem.out.print(int.class != null);\n\t}\n}"}, "true");
        String expectedOutput = "// Compiled from X.java (version 1.8 : 52.0, super bit)\npublic class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n  \n  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  getstatic java.lang.Integer.TYPE : java.lang.Class [22]\n     6  ifnull 13\n     9  iconst_1\n    10  goto 14\n    13  iconst_0\n    14  invokevirtual java.io.PrintStream.print(boolean) : void [28]\n    17  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 17, line: 5]\n      Local variable table:\n        [pc: 0, pc: 18] local: args index: 0 type: java.lang.String[]\n      Stack map table: number of frames 2\n        [pc: 13, same_locals_1_stack_item, stack: {java.io.PrintStream}]\n        [pc: 14, full, stack: {java.io.PrintStream, int}, locals: {java.lang.String[]}]\n}";
        this.checkDisassembledClassFile(OUTPUT_DIR + File.separator + "X.class", "X", expectedOutput);
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "import java.io.InputStream;\n\npublic class X {\n\tprivate static final Y[] A = new Y[1];\n\n\tpublic static void x() {\n\t\tfor (int i = 0; i < 0; i++) {\n\t\t\ttry {\n\t\t\t\tA[i] = foo(X.class.getResourceAsStream(\"\"), null);\n\t\t\t} catch (Throwable e) {\n\t\t\t}\n\t\t}\n\t}\n\n\tpublic static boolean a = false;\n\n\tprivate static int b = -1;\n\n\tprivate static int C = 0;\n\n\tpublic static void z(int c) {\n\t\tif (!a || (b == c && A[c].foo() == C)) {\n\t\t\treturn;\n\t\t}\n\t\ty();\n\t\tb = c;\n\t\ttry {\n\t\t\tA[c].bar();\n\t\t} catch (Throwable e) {\n\t\t}\n\t}\n\n\tpublic static void y() {\n\t}\n\n\tstatic Y foo(InputStream stream, String s) {\n\t\treturn null;\n\t}\n}", "Y.java", "interface Y {\n\tint foo();\n\tvoid bar();\n}"}, "");
    }
}

