/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultJavaRuntimeEnvironment
extends FileSystem {
    private static INameEnvironment[] defaultJreClassLibs;
    private static String[] javaLibsAndOutputDir;

    private DefaultJavaRuntimeEnvironment(String[] jreClasspaths, String release) {
        super(jreClasspaths, new String[0], null, release);
    }

    private DefaultJavaRuntimeEnvironment(FileSystem.Classpath[] jreClasspaths) {
        super(jreClasspaths, new String[0], false);
    }

    public static INameEnvironment[] create(String[] jreClasspaths) {
        return DefaultJavaRuntimeEnvironment.create(jreClasspaths, null);
    }

    public static INameEnvironment[] create(String[] jreClasspaths, String release) {
        if (defaultJreClassLibs == null && release != null && !release.equals("")) {
            defaultJreClassLibs = new INameEnvironment[1];
            FileSystem.Classpath[] classpath = new FileSystem.Classpath[jreClasspaths.length];
            int i = 0;
            while (i < classpath.length) {
                if (Util.isJrt((String)jreClasspaths[i])) {
                    File file = new File(jreClasspaths[0]);
                    classpath[i] = FileSystem.getOlderSystemRelease((String)file.getParentFile().getParent(), (String)release, null);
                } else {
                    classpath[i] = FileSystem.getClasspath((String)jreClasspaths[i], null, null);
                }
                ++i;
            }
            DefaultJavaRuntimeEnvironment.defaultJreClassLibs[0] = new DefaultJavaRuntimeEnvironment(classpath);
        }
        if (defaultJreClassLibs == null) {
            defaultJreClassLibs = new INameEnvironment[1];
            DefaultJavaRuntimeEnvironment.defaultJreClassLibs[0] = new DefaultJavaRuntimeEnvironment(jreClasspaths, release);
        }
        return defaultJreClassLibs;
    }

    public void cleanup() {
        FileSystem.Classpath outputFolder = this.classpaths[this.classpaths.length - 1];
        Iterator iterator = this.moduleLocations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((FileSystem.Classpath)entry.getValue()).equals(outputFolder)) continue;
            iterator.remove();
        }
        outputFolder.reset();
    }

    public static void cleanUpDefaultJreClassLibs() {
        if (defaultJreClassLibs != null && defaultJreClassLibs.length > 0 && defaultJreClassLibs[0] instanceof DefaultJavaRuntimeEnvironment) {
            defaultJreClassLibs[0].cleanup();
        }
    }

    static String[] getDefaultClassPaths() {
        if (javaLibsAndOutputDir == null) {
            javaLibsAndOutputDir = org.eclipse.jdt.core.tests.util.Util.concatWithClassLibs(AbstractRegressionTest.OUTPUT_DIR, false);
        }
        return javaLibsAndOutputDir;
    }
}

