/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class Deprecated15Test
extends AbstractRegressionTest {
    public Deprecated15Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Deprecated15Test.buildMinimalComplianceTestSuite(Deprecated15Test.testClass(), 32);
    }

    public void test001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        boolean isJDK9 = this.complianceLevel >= 0x350000L;
        this.runNegativeTest(new String[]{"p/X.java", "package p;\n/**\n * @deprecated\n */\npublic class X<T> {\n}\n", "Y.java", "import p.X;\npublic class Y {\n  Zork z;\n  void foo() {\n    X x;\n    X[] xs = { x };\n  }\n  void bar() {\n    p.X x;\n    p.X[] xs = { x };\n  }\n}\n"}, (isJDK9 ? "" : "----------\n1. WARNING in Y.java (at line 1)\n\timport p.X;\n\t       ^^^\nThe type X<T> is deprecated\n") + "----------\n2. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in Y.java (at line 5)\n\tX x;\n\t^\nThe type X<T> is deprecated\n----------\n3. WARNING in Y.java (at line 5)\n\tX x;\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in Y.java (at line 6)\n\tX[] xs = { x };\n\t^\nThe type X<T> is deprecated\n----------\n5. WARNING in Y.java (at line 6)\n\tX[] xs = { x };\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n6. WARNING in Y.java (at line 9)\n\tp.X x;\n\t^^^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n7. WARNING in Y.java (at line 9)\n\tp.X x;\n\t  ^\nThe type X<T> is deprecated\n----------\n8. WARNING in Y.java (at line 10)\n\tp.X[] xs = { x };\n\t^^^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n9. WARNING in Y.java (at line 10)\n\tp.X[] xs = { x };\n\t  ^\nThe type X<T> is deprecated\n----------\n", null, true, options);
    }

    public void test002() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runNegativeTest(true, new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n", "a/N1.java", "package a;\npublic class N1 {\n  @Deprecated\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 is deprecated\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 is deprecated\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^\nThe method foo() from the type N1.N2.N3 is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runConformTest(new String[]{"X.java", "class X {\n  void foo() {\n    class Local {\n      class Member1 {\n        void bar() {\n          Member2 m2; // Member2 is deprecated\n        }\n      }\n      @Deprecated\n      class Member2 {\n      }\n    }\n  }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test004() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated\n\tpublic static int x = 5, y= 10;\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x is deprecated\n----------\n2. ERROR in test1\\E02.java (at line 5)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t            ^\nThe type X is deprecated\n----------\n2. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t              ^^^^^\nThe type X.Inner is deprecated\n----------\n3. ERROR in p2\\C.java (at line 4)\n\ta.foo();\n\t  ^^^\nThe method foo() from the type X.Inner is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo(E01 arg) {\n\t\t// nop\n\t}\n}", "test1/E01.java", "package test1;\n@SuppressWarnings(\"all\") @Deprecated\npublic class E01 {\n\tpublic static int x = 5;\n}"}, null, customOptions, "----------\n1. ERROR in test1\\E02.java (at line 3)\n\tpublic void foo(E01 arg) {\n\t                ^^^\nThe type E01 is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public static Class testClass() {
        return Deprecated15Test.class;
    }
}

