/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;

public class Deprecated9Test
extends AbstractRegressionTest9 {
    public Deprecated9Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Deprecated9Test.buildMinimalComplianceTestSuite(Deprecated9Test.testClass(), 64);
    }

    @Override
    protected INameEnvironment[] getClassLibs(boolean useDefaultClasspaths) {
        if (this.javaClassLib != null) {
            String encoding = this.getCompilerOptions().get("org.eclipse.jdt.core.encoding");
            if ("".equals(encoding)) {
                encoding = null;
            }
            return new INameEnvironment[]{this.javaClassLib, new FileSystem(this.classpaths, new String[0], encoding)};
        }
        return super.getClassLibs(useDefaultClasspaths);
    }

    public void test002() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runNegativeTest(true, new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n", "a/N1.java", "package a;\npublic class N1 {\n  @Deprecated(since=\"1.2\",forRemoval=true)\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 has been deprecated since version 1.2 and marked for removal\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 has been deprecated and marked for removal\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^\nThe method foo() from the type N1.N2.N3 has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test002binary() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        runner.testFiles = new String[]{"a/N1.java", "package a;\npublic class N1 {\n  @Deprecated(since=\"1.2\",forRemoval=true)\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }}\n"};
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 has been deprecated since version 1.2 and marked for removal\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 has been deprecated and marked for removal\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^\nThe method foo() from the type N1.N2.N3 has been deprecated and marked for removal\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void test004() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(forRemoval=true,since=\"3\")\n\tpublic static int x = 5, y= 10;\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x has been deprecated since version 3 and marked for removal\n----------\n2. ERROR in test1\\E02.java (at line 5)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y has been deprecated since version 3 and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005a() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=true)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t            ^\nThe type X has been deprecated and marked for removal\n----------\n2. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t              ^^^^^\nThe type X.Inner has been deprecated and marked for removal\n----------\n3. ERROR in p2\\C.java (at line 4)\n\ta.foo();\n\t  ^^^\nThe method foo() from the type X.Inner has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005b() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "ignore");
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=true)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, customOptions);
    }

    public void test005c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "warning");
        runner.testFiles = new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {\n\t\t @java.lang.Deprecated(forRemoval=true)\n        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=false)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n\t @SuppressWarnings(\"deprecation\")\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in p2\\C.java (at line 5)\n\ta.foo();\n\t  ^^^\nThe method foo() from the type X.Inner has been deprecated and marked for removal\n----------\n";
        runner.runWarningTest();
    }

    public void test006() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo(E01 arg) {\n\t\t// nop\n\t}\n}", "test1/E01.java", "package test1;\n@SuppressWarnings(\"all\") @Deprecated(since=\"4\")\npublic class E01 {\n\tpublic static int x = 5;\n}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in test1\\E02.java (at line 3)\n\tpublic void foo(E01 arg) {\n\t                ^^^\nThe type E01 is deprecated since version 4\n----------\n";
        runner.runWarningTest();
    }

    public void test007() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n\t @java.lang.Deprecated(forRemoval=false)\n    public void foo() {}\n\t @java.lang.Deprecated(forRemoval=true)\n\t public void bar() {}\n}\n", "p2/C.java", "package p2;\nimport p1.X;\npublic class C extends X {\n    @Override public void foo() {}\n    @Override public void bar() {}\n}\n"}, null, customOptions, "----------\n1. WARNING in p2\\C.java (at line 4)\n\t@Override public void foo() {}\n\t                      ^^^^^\nThe method C.foo() overrides a deprecated method from X\n----------\n2. ERROR in p2\\C.java (at line 5)\n\t@Override public void bar() {}\n\t                      ^^^^^\nThe method C.bar() overrides a method from X that has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testSinceSource() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(since=\"1.0\") protected static class Old {}\n\t@Deprecated(since=\"2\") public static int x = 5, y= 10;\n\t@Deprecated(since=\"3.0.0\") public E01() {}\n\t@Deprecated(since=\"4-SNAPSHOT\") protected void old() {}\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(new E01.Old());\n\t\tE01 e = new E01();\n\t\te.old();\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n\tclass E03 extends E01 {\n\t\tprotected void old() {}\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                       ^^^^^^^\nThe constructor E01.Old() is deprecated since version 1.0\n----------\n2. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                           ^^^\nThe type E01.Old is deprecated since version 1.0\n----------\n3. WARNING in test1\\E02.java (at line 5)\n\tE01 e = new E01();\n\t            ^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n4. WARNING in test1\\E02.java (at line 6)\n\te.old();\n\t  ^^^\nThe method old() from the type E01 is deprecated since version 4-SNAPSHOT\n----------\n5. WARNING in test1\\E02.java (at line 7)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x is deprecated since version 2\n----------\n6. WARNING in test1\\E02.java (at line 8)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y is deprecated since version 2\n----------\n7. WARNING in test1\\E02.java (at line 10)\n\tclass E03 extends E01 {\n\t      ^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n8. WARNING in test1\\E02.java (at line 11)\n\tprotected void old() {}\n\t               ^^^^^\nThe method E02.E03.old() overrides a method from E01 that is deprecated since version 4-SNAPSHOT\n----------\n";
        runner.runWarningTest();
    }

    public void testSinceBinary() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(since=\"1.0\") protected static class Old {}\n\t@Deprecated(since=\"2\") public static int x = 5, y= 10;\n\t@Deprecated(since=\"3.0.0\") public E01() {}\n\t@Deprecated(since=\"4-SNAPSHOT\") protected void old() {}\n}"};
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(new E01.Old());\n\t\tE01 e = new E01();\n\t\te.old();\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n\tclass E03 extends E01 {\n\t\tprotected void old() {}\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                       ^^^^^^^\nThe constructor E01.Old() is deprecated since version 1.0\n----------\n2. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                           ^^^\nThe type E01.Old is deprecated since version 1.0\n----------\n3. WARNING in test1\\E02.java (at line 5)\n\tE01 e = new E01();\n\t            ^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n4. WARNING in test1\\E02.java (at line 6)\n\te.old();\n\t  ^^^\nThe method old() from the type E01 is deprecated since version 4-SNAPSHOT\n----------\n5. WARNING in test1\\E02.java (at line 7)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x is deprecated since version 2\n----------\n6. WARNING in test1\\E02.java (at line 8)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y is deprecated since version 2\n----------\n7. WARNING in test1\\E02.java (at line 10)\n\tclass E03 extends E01 {\n\t      ^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n8. WARNING in test1\\E02.java (at line 11)\n\tprotected void old() {}\n\t               ^^^^^\nThe method E02.E03.old() overrides a method from E01 that is deprecated since version 4-SNAPSHOT\n----------\n";
        runner.runWarningTest();
    }

    public void testSinceTerminally() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(since=\"1.0\", forRemoval=true) protected static class Old {}\n\t@Deprecated(since=\"2\", forRemoval=true) public static int x = 5, y= 10;\n\t@Deprecated(since=\"3.0.0\", forRemoval=true) public E01() {}\n\t@Deprecated(since=\"4-SNAPSHOT\", forRemoval=true) protected void old() {}\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(new E01.Old());\n\t\tE01 e = new E01();\n\t\te.old();\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n\tclass E03 extends E01 {\n\t\tprotected void old() {}\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                       ^^^^^^^\nThe constructor E01.Old() has been deprecated since version 1.0 and marked for removal\n----------\n2. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                           ^^^\nThe type E01.Old has been deprecated since version 1.0 and marked for removal\n----------\n3. ERROR in test1\\E02.java (at line 5)\n\tE01 e = new E01();\n\t            ^^^\nThe constructor E01() has been deprecated since version 3.0.0 and marked for removal\n----------\n4. ERROR in test1\\E02.java (at line 6)\n\te.old();\n\t  ^^^\nThe method old() from the type E01 has been deprecated since version 4-SNAPSHOT and marked for removal\n----------\n5. ERROR in test1\\E02.java (at line 7)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x has been deprecated since version 2 and marked for removal\n----------\n6. ERROR in test1\\E02.java (at line 8)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y has been deprecated since version 2 and marked for removal\n----------\n7. ERROR in test1\\E02.java (at line 10)\n\tclass E03 extends E01 {\n\t      ^^^\nThe constructor E01() has been deprecated since version 3.0.0 and marked for removal\n----------\n8. ERROR in test1\\E02.java (at line 11)\n\tprotected void old() {}\n\t               ^^^^^\nThe method E02.E03.old() overrides a method from E01 that has been deprecated since version 4-SNAPSHOT and marked for removal\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void testDeprecatedPackageExport() {
        this.associateToModule("mod1", "p1/package-info.java", "p1/C1.java", "p2/package-info.java", "p2/C2.java", "p3/package-info.java", "p3/C3.java", "p4/package-info.java", "p4/C4.java");
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"p1/package-info.java", "@Deprecated package p1;\n", "p1/C1.java", "package p1; public class C1 {}\n", "p2/package-info.java", "@Deprecated(since=\"13\") package p2;\n", "p2/C2.java", "package p2; public class C2 {}\n", "p3/package-info.java", "@Deprecated(since=\"13\",forRemoval=true) package p3;\n", "p3/C3.java", "package p3; public class C3 {}\n", "p4/package-info.java", "@Deprecated(since=\"14\",forRemoval=true) package p4;\n", "p4/C4.java", "package p4; public class C4 {}\n", "module-info.java", "module mod1 {\n\texports p1;\n\texports p2;\n\texports p3;\n\topens p4;\n}\n"};
        runner.runConformTest();
    }

    public void testDeprecatedModule() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"folder0/module-info.java", "@Deprecated module mod.dep {}\n", "folder1/module-info.java", "@Deprecated(since=\"42\") module mod.dep.since {}\n", "folder2/module-info.java", "@Deprecated(forRemoval=true) module mod.dep.terminally {}\n", "folder3/module-info.java", "@Deprecated(since=\"42\",forRemoval=true) module mod.dep.since.terminally {}\n", "module-info.java", "module mod1 {\n\trequires mod.dep;\n\trequires mod.dep.since;\n\trequires mod.dep.terminally;\n\trequires mod.dep.since.terminally;\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in module-info.java (at line 2)\n\trequires mod.dep;\n\t         ^^^^^^^\nThe module mod.dep is deprecated\n----------\n2. WARNING in module-info.java (at line 3)\n\trequires mod.dep.since;\n\t         ^^^^^^^^^^^^^\nThe module mod.dep.since is deprecated since version 42\n----------\n3. ERROR in module-info.java (at line 4)\n\trequires mod.dep.terminally;\n\t         ^^^^^^^^^^^^^^^^^^\nThe module mod.dep.terminally has been deprecated and marked for removal\n----------\n4. ERROR in module-info.java (at line 5)\n\trequires mod.dep.since.terminally;\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^\nThe module mod.dep.since.terminally has been deprecated since version 42 and marked for removal\n----------\n";
        runner.runNegativeTest();
    }

    public void testDeprecatedProvidedServices() {
        Deprecated9Test.javacUsePathOption(" --module-source-path ");
        this.associateToModule("mod0", "module-info.java", "p1/IServiceDep.java", "p1/IServiceDepSince.java", "p1/IServiceTermDep.java", "p1/IServiceTermDepSince.java");
        this.associateToModule("mod1", "p1impl/ServiceDep.java", "p1impl/ServiceDepSince.java", "p1impl/ServiceTermDep.java", "p1impl/ServiceTermDepSince.java");
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "info");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "warning");
        runner.testFiles = new String[]{"p1/IServiceDep.java", "package p1;\n@Deprecated\npublic interface IServiceDep {}\n", "p1/IServiceDepSince.java", "package p1;\n@Deprecated(since=\"2\")\npublic interface IServiceDepSince {}\n", "p1/IServiceTermDep.java", "package p1;\n@Deprecated(forRemoval=true)\npublic interface IServiceTermDep {}\n", "p1/IServiceTermDepSince.java", "package p1;\n@Deprecated(since=\"3\",forRemoval=true)\npublic interface IServiceTermDepSince {}\n", "module-info.java", "module mod0 {\n\texports p1;\n}\n", "p1impl/ServiceDep.java", "package p1impl;\n@Deprecated\npublic class ServiceDep implements p1.IServiceDep {}\n", "p1impl/ServiceDepSince.java", "package p1impl;\n@Deprecated(since=\"2\")\npublic class ServiceDepSince implements p1.IServiceDepSince {}\n", "p1impl/ServiceTermDep.java", "package p1impl;\n@Deprecated(forRemoval=true)\npublic class ServiceTermDep implements p1.IServiceTermDep {}\n", "p1impl/ServiceTermDepSince.java", "package p1impl;\n@Deprecated(since=\"3\",forRemoval=true)\npublic class ServiceTermDepSince implements p1.IServiceTermDepSince {}\n", "mod1/module-info.java", "module mod1 {\n\trequires mod0;\n\tprovides p1.IServiceDep with p1impl.ServiceDep;\n\tprovides p1.IServiceDepSince with p1impl.ServiceDepSince;\n\tprovides p1.IServiceTermDep with p1impl.ServiceTermDep;\n\tprovides p1.IServiceTermDepSince with p1impl.ServiceTermDepSince;\n}\n"};
        runner.expectedCompilerLog = "----------\n1. INFO in mod1\\module-info.java (at line 3)\n\tprovides p1.IServiceDep with p1impl.ServiceDep;\n\t            ^^^^^^^^^^^\nThe type IServiceDep is deprecated\n----------\n2. INFO in mod1\\module-info.java (at line 3)\n\tprovides p1.IServiceDep with p1impl.ServiceDep;\n\t                                    ^^^^^^^^^^\nThe type ServiceDep is deprecated\n----------\n3. INFO in mod1\\module-info.java (at line 4)\n\tprovides p1.IServiceDepSince with p1impl.ServiceDepSince;\n\t            ^^^^^^^^^^^^^^^^\nThe type IServiceDepSince is deprecated since version 2\n----------\n4. INFO in mod1\\module-info.java (at line 4)\n\tprovides p1.IServiceDepSince with p1impl.ServiceDepSince;\n\t                                         ^^^^^^^^^^^^^^^\nThe type ServiceDepSince is deprecated since version 2\n----------\n5. WARNING in mod1\\module-info.java (at line 5)\n\tprovides p1.IServiceTermDep with p1impl.ServiceTermDep;\n\t            ^^^^^^^^^^^^^^^\nThe type IServiceTermDep has been deprecated and marked for removal\n----------\n6. WARNING in mod1\\module-info.java (at line 5)\n\tprovides p1.IServiceTermDep with p1impl.ServiceTermDep;\n\t                                        ^^^^^^^^^^^^^^\nThe type ServiceTermDep has been deprecated and marked for removal\n----------\n7. WARNING in mod1\\module-info.java (at line 6)\n\tprovides p1.IServiceTermDepSince with p1impl.ServiceTermDepSince;\n\t            ^^^^^^^^^^^^^^^^^^^^\nThe type IServiceTermDepSince has been deprecated since version 3 and marked for removal\n----------\n8. WARNING in mod1\\module-info.java (at line 6)\n\tprovides p1.IServiceTermDepSince with p1impl.ServiceTermDepSince;\n\t                                             ^^^^^^^^^^^^^^^^^^^\nThe type ServiceTermDepSince has been deprecated since version 3 and marked for removal\n----------\n";
        runner.runWarningTest();
    }

    public void testDeprecatedUsedServices() {
        Deprecated9Test.javacUsePathOption(" --module-path ");
        this.associateToModule("mod0", "p1/IServiceDep.java", "p1/IServiceDepSince.java", "p1/IServiceTermDep.java", "p1/IServiceTermDepSince.java");
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "info");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "warning");
        runner.testFiles = new String[]{"p1/IServiceDep.java", "package p1;\n@Deprecated\npublic interface IServiceDep {}\n", "p1/IServiceDepSince.java", "package p1;\n@Deprecated(since=\"2\")\npublic interface IServiceDepSince {}\n", "p1/IServiceTermDep.java", "package p1;\n@Deprecated(forRemoval=true)\npublic interface IServiceTermDep {}\n", "p1/IServiceTermDepSince.java", "package p1;\n@Deprecated(since=\"3\",forRemoval=true)\npublic interface IServiceTermDepSince {}\n", "module-info.java", "module mod0 {\n\texports p1;\n}\n"};
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"module-info.java", "module mod2 {\n\trequires mod0;\n\tuses p1.IServiceDep;\n\tuses p1.IServiceDepSince;\n\tuses p1.IServiceTermDep;\n\tuses p1.IServiceTermDepSince;\n}\n"};
        runner.expectedCompilerLog = "----------\n1. INFO in module-info.java (at line 3)\n\tuses p1.IServiceDep;\n\t        ^^^^^^^^^^^\nThe type IServiceDep is deprecated\n----------\n2. INFO in module-info.java (at line 4)\n\tuses p1.IServiceDepSince;\n\t        ^^^^^^^^^^^^^^^^\nThe type IServiceDepSince is deprecated since version 2\n----------\n3. WARNING in module-info.java (at line 5)\n\tuses p1.IServiceTermDep;\n\t        ^^^^^^^^^^^^^^^\nThe type IServiceTermDep has been deprecated and marked for removal\n----------\n4. WARNING in module-info.java (at line 6)\n\tuses p1.IServiceTermDepSince;\n\t        ^^^^^^^^^^^^^^^^^^^^\nThe type IServiceTermDepSince has been deprecated since version 3 and marked for removal\n----------\n";
        runner.runWarningTest();
    }

    public void testBug533063_1() throws Exception {
        INameEnvironment save = this.javaClassLib;
        try {
            List<String> limitModules = Arrays.asList("java.se", "jdk.xml.bind");
            this.javaClassLib = new AbstractRegressionTest.CustomFileSystem(limitModules);
            AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
            runner.testFiles = new String[]{"module-info.java", "module my.mod {\n\trequires jdk.xml.bind;\n}\n"};
            if (isJRE11Plus) {
                runner.expectedCompilerLog = "----------\n1. ERROR in module-info.java (at line 2)\n\trequires jdk.xml.bind;\n\t         ^^^^^^^^^^^^\njdk.xml.bind cannot be resolved to a module\n----------\n";
                runner.runNegativeTest();
            } else {
                runner.expectedCompilerLog = "----------\n1. WARNING in module-info.java (at line 2)\n\trequires jdk.xml.bind;\n\t         ^^^^^^^^^^^^\nThe module jdk.xml.bind has been deprecated since version 9 and marked for removal\n----------\n";
                runner.runWarningTest();
            }
        }
        finally {
            this.javaClassLib = save;
        }
    }

    public void testBug533063_2() throws Exception {
        Deprecated9Test.javacUsePathOption(" --module-path ");
        this.runConformTest(new String[]{"dont.use/module-info.java", "@Deprecated(forRemoval=true,since=\"9\") module dont.use {}\n"});
        this.moduleMap.clear();
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"my.mod/module-info.java", "module my.mod {\n\trequires dont.use;\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in my.mod\\module-info.java (at line 2)\n\trequires dont.use;\n\t         ^^^^^^^^\nThe module dont.use has been deprecated since version 9 and marked for removal\n----------\n";
        runner.runWarningTest();
    }

    public void testBug534304() throws Exception {
        this.runNegativeTest(new String[]{"p1/C1.java", "package p1;\n\nimport pdep.Dep1;\n\npublic class C1 {\n\tDep1 f;\n}\n", "pdep/Dep1.java", "package pdep;\n\nimport pmissing.CMissing;\n\n@Deprecated(since=\"13\")\n@CMissing\npublic class Dep1 {\n\n}\n"}, "----------\n1. WARNING in p1\\C1.java (at line 6)\n\tDep1 f;\n\t^^^^\nThe type Dep1 is deprecated since version 13\n----------\n----------\n1. ERROR in pdep\\Dep1.java (at line 3)\n\timport pmissing.CMissing;\n\t       ^^^^^^^^\nThe import pmissing cannot be resolved\n----------\n2. ERROR in pdep\\Dep1.java (at line 6)\n\t@CMissing\n\t ^^^^^^^^\nCMissing cannot be resolved to a type\n----------\n");
    }

    public void testBug542795() throws Exception {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        runner.testFiles = new String[]{"test/ReaderWarningView.java", "package test;\n@java.lang.Deprecated\npublic class ReaderWarningView {}\n", "Test.java", "public class Test implements test.Screen.Component {}\n", "test/Screen.java", "package test;\n@interface Annot{ Class<?> value(); }\n@Annot(test.Screen.Component.class)\n@java.lang.Deprecated\npublic final class Screen {\n\t@java.lang.Deprecated\n\tpublic interface Component extends test.ReaderWarningView.Component {\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Test.java (at line 1)\n\tpublic class Test implements test.Screen.Component {}\n\t             ^^^^\nThe hierarchy of the type Test is inconsistent\n----------\n2. ERROR in Test.java (at line 1)\n\tpublic class Test implements test.Screen.Component {}\n\t                                  ^^^^^^\nThe type Screen is deprecated\n----------\n3. ERROR in Test.java (at line 1)\n\tpublic class Test implements test.Screen.Component {}\n\t                                         ^^^^^^^^^\nThe type Screen.Component is deprecated\n----------\n----------\n1. ERROR in test\\Screen.java (at line 7)\n\tpublic interface Component extends test.ReaderWarningView.Component {\n\t                                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\ntest.ReaderWarningView.Component cannot be resolved to a type\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH1431() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"Parent.java", "@Deprecated(since = AbstractChild.TEST_CONSTANT) // this now fails\npublic class Parent extends AbstractChild {\n    private static final String REF_OK = AbstractChild.TEST_CONSTANT; // this compiles OK\n}\n", "AbstractChild.java", "public abstract class AbstractChild implements Constants {\n    // redacted for brevity\n}\n", "Constants.java", "public interface Constants {\n    public static final String TEST_CONSTANT = \"this is a test\";\n}\n"};
        runner.runConformTest();
    }

    public void testGH1412() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"AbstractClass.java", "public abstract class AbstractClass<T> {}\n", "AnnotationWithClassValue.java", "public @interface AnnotationWithClassValue {\n\tClass<? extends AbstractClass<?>> value();\n}\n", "ConcreteClass.java", "//Adding @Deprecated here fixes the bug\n//@Deprecated\npublic class ConcreteClass extends AbstractClass<AnnotatedClass> {}\n", "AnnotatedClass.java", "@Deprecated\n@AnnotationWithClassValue(ConcreteClass.class) //Type mismatch: cannot convert from Class<ConcreteClass> to Class<? extends AbstractClass<?>>\npublic class AnnotatedClass {}\n"};
        runner.runConformTest();
    }

    public void testJEP211_2() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p1/C1.java", "package p1;\npublic class C1 {\n\t@Deprecated public class CInner {}\n\t@Deprecated(forRemoval=true) public static int ZERO = 0;\n}\n", "Test.java", "import p1.C1.CInner;\nimport static p1.C1.ZERO;\npublic class Test {\n\tCInner c;\n\tint z = ZERO;\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in Test.java (at line 4)\n\tCInner c;\n\t^^^^^^\nThe type C1.CInner is deprecated\n----------\n2. WARNING in Test.java (at line 5)\n\tint z = ZERO;\n\t        ^^^^\nThe field C1.ZERO has been deprecated and marked for removal\n----------\n";
        runner.runWarningTest();
    }

    public void testJEP211_3() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p1/C1.java", "package p1;\npublic class C1 {\n\t@Deprecated public static int ZERO = 0;\n\t@Deprecated public static int nothing() { return 0; };\n}\n", "Test.java", "import static p1.C1.*;\npublic class Test {\n\tint z = ZERO;\n\tint zz = nothing();\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in Test.java (at line 3)\n\tint z = ZERO;\n\t        ^^^^\nThe field C1.ZERO is deprecated\n----------\n2. WARNING in Test.java (at line 4)\n\tint zz = nothing();\n\t         ^^^^^^^\nThe method nothing() from the type C1 is deprecated\n----------\n";
        runner.runWarningTest();
    }

    public static Class<?> testClass() {
        return Deprecated9Test.class;
    }
}

