/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class DeprecatedTest
extends AbstractRegressionTest {
    protected char[][] invisibleType;

    public DeprecatedTest(String name) {
        super(name);
    }

    public static Test suite() {
        return DeprecatedTest.buildAllCompliancesTestSuite(DeprecatedTest.testClass());
    }

    @Override
    protected void tearDown() throws Exception {
        this.invisibleType = null;
        super.tearDown();
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        return new InMemoryNameEnvironment(testFiles, this.getClassLibs(classPaths == null, options)){

            @Override
            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                if (DeprecatedTest.this.invisibleType != null && CharOperation.equals((char[][])DeprecatedTest.this.invisibleType, (char[][])compoundTypeName)) {
                    return null;
                }
                return super.findType(compoundTypeName);
            }

            @Override
            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                char[] simpleName;
                char[][] packName;
                if (DeprecatedTest.this.invisibleType != null && DeprecatedTest.this.invisibleType.length == packageName.length + 1 && CharOperation.equals((char[][])packageName, (char[][])(packName = CharOperation.subarray((char[][])DeprecatedTest.this.invisibleType, (int)0, (int)(DeprecatedTest.this.invisibleType.length - 1)))) && CharOperation.equals((char[])(simpleName = DeprecatedTest.this.invisibleType[DeprecatedTest.this.invisibleType.length - 1]), (char[])typeName)) {
                    return null;
                }
                return super.findType(typeName, packageName);
            }
        };
    }

    public void test001() {
        this.runNegativeTest(new String[]{"p/B.java", "package p;\nclass B extends A {\n    float x = super.x;\n}\n", "p/A.java", "package p;\nclass A {\n    /** @deprecated */\n    int x = 1;\n}\n"}, "----------\n1. WARNING in p\\B.java (at line 3)\n\tfloat x = super.x;\n\t      ^\nThe field B.x is hiding a field from type A\n----------\n2. WARNING in p\\B.java (at line 3)\n\tfloat x = super.x;\n\t                ^\nThe field A.x is deprecated\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"p/C.java", "package p;\nclass C {\n    static int x = new A().x;\n}\n", "p/A.java", "package p;\nclass A {\n    /** @deprecated */\n    int x = 1;\n}\n"}, "----------\n1. WARNING in p\\C.java (at line 3)\n\tstatic int x = new A().x;\n\t                       ^\nThe field A.x is deprecated\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"p/Top.java", "package p;\npublic class Top {\n  \n  class M1 {\n    class M2 {}\n  };\n  \n  static class StaticM1 {\n    static class StaticM2 {\n      class NonStaticM3{}};\n  };\n  \npublic static void main(String argv[]){\n  Top tip = new Top();\n  System.out.println(\"Still alive 0\");\n  tip.testStaticMember();\n  System.out.println(\"Still alive 1\");\n  tip.testStaticMember1();\n  System.out.println(\"Still alive 2\");\n  tip.testStaticMember2();\n  System.out.println(\"Still alive 3\");\n  tip.testStaticMember3();\n  System.out.println(\"Still alive 4\");\n  tip.testStaticMember4();\n  System.out.println(\"Completed\");\n}\n  void testMember(){\n    new M1().new M2();}\n  void testStaticMember(){\n    new StaticM1().new StaticM2();}\n  void testStaticMember1(){\n    new StaticM1.StaticM2();}\n  void testStaticMember2(){\n    new StaticM1.StaticM2().new NonStaticM3();}\n  void testStaticMember3(){\n    // define an anonymous subclass of the non-static M3\n    new StaticM1.StaticM2().new NonStaticM3(){};\n  }   \n  void testStaticMember4(){\n    // define an anonymous subclass of the non-static M3\n    new StaticM1.StaticM2().new NonStaticM3(){\n      Object hello(){\n        return new StaticM1.StaticM2().new NonStaticM3();\n      }};\n      \n  }    \n}\n"}, "----------\n1. ERROR in p\\Top.java (at line 30)\n\tnew StaticM1().new StaticM2();}\n\t^^^^^^^^^^^^^^\nIllegal enclosing instance specification for type Top.StaticM1.StaticM2\n----------\n2. WARNING in p\\Top.java (at line 42)\n\tObject hello(){\n\t       ^^^^^^^\nThe method hello() from the type new Top.StaticM1.StaticM2.NonStaticM3(){} is never used locally\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"p/Warning.java", "package p;\nimport java.util.Date;\npublic class Warning {\npublic Warning() {\n     super();\n     Date dateObj = new Date();\n     dateObj.UTC(1,2,3,4,5,6);\n}\n}\n"}, "----------\n1. WARNING in p\\Warning.java (at line 7)\n\tdateObj.UTC(1,2,3,4,5,6);\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nThe static method UTC(int, int, int, int, int, int) from the type Date should be accessed in a static way\n----------\n2. WARNING in p\\Warning.java (at line 7)\n\tdateObj.UTC(1,2,3,4,5,6);\n\t        ^^^\nThe method UTC(int, int, int, int, int, int) from the type Date is deprecated\n----------\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n/**\n * @deprecated\n */\n \tpublic static class Y {\n\t}\n   public static void main(String[] args) {\t\n        System.out.print(\"SUCCESS\");\t\n\t}\t\n}"}, "SUCCESS", null, true, null, null, null);
        this.runNegativeTest(new String[]{"A.java", "public class A extends X.Y {}"}, "----------\n1. WARNING in A.java (at line 1)\n\tpublic class A extends X.Y {}\n\t                         ^\nThe type X.Y is deprecated\n----------\n", null, false, null);
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t  @deprecated\n\t */\n\t; // line comment\n\tstatic int i;\n   public static void main(String[] args) {\t\n        System.out.print(\"SUCCESS\");\t\n\t}\t\n}"}, "SUCCESS", null, true, null, null, null);
        this.runConformTest(false, new String[]{"A.java", "public class A {\n   public static void main(String[] args) {\t\n        System.out.print(X.i);\t\n\t}\t\n}"}, "", "0", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @deprecated\n */\npublic class X {\n}\n", "Y.java", "/**\n * @deprecated\n */\npublic class Y {\n  Zork z;\n  X x;\n  X foo() {\n    X x; // unexpected deprecated warning here\n  }\n}\n"}, "----------\n1. ERROR in Y.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in Y.java (at line 8)\n\tX x; // unexpected deprecated warning here\n\t  ^\nThe local variable x is hiding a field from type Y\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "/**\n * @deprecated\n */\npublic class X {\n}\n"}, "");
        this.runNegativeTest(new String[]{"Y.java", "/**\n * @deprecated\n */\npublic class Y {\n  Zork z;\n  void foo() {\n    X x; // unexpected deprecated warning here\n  }\n}\n"}, "----------\n1. ERROR in Y.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, null);
    }

    public void test008a() throws IOException {
        String jarPath = LIB_DIR + File.separator + "p008a" + File.separator + "x.jar";
        Util.createJar(new String[]{"X.java", "package p008a;\n@Deprecated\npublic class X {\n}\n"}, jarPath, CompilerOptions.getFirstSupportedJavaVersion());
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"Y.java", "public class Y {\n  void foo() {\n    p008a.X x;\n  }\n}\n"};
        String[] libs = this.getDefaultClassPaths();
        libs = Arrays.copyOf(libs, libs.length + 1);
        libs[libs.length - 1] = jarPath;
        runner.classLibraries = libs;
        runner.expectedCompilerLog = "----------\n1. WARNING in Y.java (at line 3)\n\tp008a.X x;\n\t      ^\nThe type X is deprecated\n----------\n";
        runner.runWarningTest();
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @deprecated\n */\npublic class X {\n}\n", "Y.java", "/**\n * @deprecated\n */\npublic class Y {\n  Zork z;\n  void foo() {\n    X x; // unexpected deprecated warning here\n  }\n}\n"}, "----------\n1. ERROR in Y.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test010() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runNegativeTest(new String[]{"X.java", "/**\n * @deprecated\n */\npublic class X {\n        /**\n         * @see I2#foo()\n         */\n        I1 foo() {\n                return null;\n        }\n       Zork z;\n}\n", "I1.java", "/**\n * @deprecated\n */\npublic interface I1 {\n\t\t // empty block\n}\n", "I2.java", "/**\n * @deprecated\n */\npublic interface I2 {\n\t\t I1 foo(); // unexpected warning here\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, customOptions);
    }

    public void test011() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\nimport p2.I;\n/** @deprecated */\npublic class X {\n\tZork z;\n}\n", "p2/I.java", "package p2;\n/** @deprecated */\npublic interface I {\n}\n"}, "----------\n1. ERROR in p1\\X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test012() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "ignore");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    void foo() {\n        /** @deprecated */\n        int i1 = Y.m;\n    }\n    /** @deprecated */\n    void bar() {\n        int i1 = Y.m;\n    }\n}\n", "Y.java", "public class Y {\n    /** @deprecated */\n    static int m;\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tint i1 = Y.m;\n\t           ^\nThe field Y.m is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "ignore");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    void foo() {\n        @Deprecated\n        int i1 = Y.m;\n    }\n    @Deprecated\n    void bar() {\n        int i1 = Y.m;\n    }\n}\n", "Y.java", "public class Y {\n    @Deprecated\n    static int m;\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tint i1 = Y.m;\n\t           ^\nThe field Y.m is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test014() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\n/**\n * @deprecated\n */\npublic class X {\n}\n", "Y.java", "import p.X;\npublic class Y {\n  Zork z;\n  void foo() {\n    X x;\n    X[] xs = { x };\n  }\n  void bar() {\n    p.X x;\n    p.X[] xs = { x };\n  }\n}\n"}, (this.complianceLevel >= 0x350000L ? "" : "----------\n1. WARNING in Y.java (at line 1)\n\timport p.X;\n\t       ^^^\nThe type X is deprecated\n") + "----------\n2. ERROR in Y.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in Y.java (at line 5)\n\tX x;\n\t^\nThe type X is deprecated\n----------\n3. WARNING in Y.java (at line 6)\n\tX[] xs = { x };\n\t^\nThe type X is deprecated\n----------\n4. WARNING in Y.java (at line 9)\n\tp.X x;\n\t  ^\nThe type X is deprecated\n----------\n5. WARNING in Y.java (at line 10)\n\tp.X[] xs = { x };\n\t  ^\nThe type X is deprecated\n----------\n");
    }

    public void test015() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runNegativeTest(true, new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n", "a/N1.java", "package a;\npublic class N1 {\n  /** @deprecated */\n  public class N2 {    public class N3 {      public void foo() {}    }  }}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 is deprecated\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 is deprecated\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^\nThe method foo() from the type N1.N2.N3 is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test016() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runNegativeTest(true, new String[]{"a/N1.java", "package a;\npublic class N1 {\n  /** @deprecated */\n  public class N2 {    public class N3 {      public void foo() {}    }  }}\n", "p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 is deprecated\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 is deprecated\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^\nThe method foo() from the type N1.N2.N3 is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test017() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "error");
        this.runConformTest(new String[]{"a/N1.java", "package a;\npublic class N1 {\n  /** @deprecated */\n  public class N2 {    public class N3 {      public void foo() {}    }  }  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n"}, "", null, true, null, customOptions, null, false);
    }

    public void test018() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runConformTest(new String[]{"a/N1.java", "package a;\npublic class N1 {\n  /** @deprecated */\n  public class N2 {    public class N3 {      public void foo() {}    }  }}\n"}, "", null, true, null, customOptions, null, false);
        this.runNegativeTest(false, new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 is deprecated\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 is deprecated\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^\nThe method foo() from the type N1.N2.N3 is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test019() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t/** @deprecated */\n\tpublic static int x = 5, y= 10;\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x is deprecated\n----------\n2. ERROR in test1\\E02.java (at line 5)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test020() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runNegativeTest(true, new String[]{"a.b.c.d/Deprecated.java", "package a.b.c.d;\npublic class Deprecated {\n\t/** @deprecated */\n\tpublic class Inner {\n\t\t/** @deprecated */\n\t\tpublic class Inn {\n\t\t}\n\t}\n\t/** @deprecated */\n\tpublic Deprecated foo(){ return null;}\n\t/** @deprecated */\n\tpublic Deprecated goo(){ return null;}\n\t/** @deprecated */\n\tpublic static Deprecated bar(){ return null;}\n}\n", "a.b.c.d.e/T.java", "package a.b.c.d.e;\nimport a.b.c.d.Deprecated;\npublic class T {\n\ta.b.c.d.Deprecated f;\n\ta.b.c.d.Deprecated.Inner.Inn g;\n\tDeprecated.Inner i;\n\tpublic void m() {\n\t\tf.foo().goo();\n\t\ta.b.c.d.Deprecated.bar();\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in a.b.c.d.e\\T.java (at line 5)\n\ta.b.c.d.Deprecated.Inner.Inn g;\n\t                   ^^^^^\nThe type Deprecated.Inner is deprecated\n----------\n2. ERROR in a.b.c.d.e\\T.java (at line 5)\n\ta.b.c.d.Deprecated.Inner.Inn g;\n\t                         ^^^\nThe type Deprecated.Inner.Inn is deprecated\n----------\n3. ERROR in a.b.c.d.e\\T.java (at line 6)\n\tDeprecated.Inner i;\n\t           ^^^^^\nThe type Deprecated.Inner is deprecated\n----------\n4. ERROR in a.b.c.d.e\\T.java (at line 8)\n\tf.foo().goo();\n\t  ^^^\nThe method foo() from the type Deprecated is deprecated\n----------\n5. ERROR in a.b.c.d.e\\T.java (at line 8)\n\tf.foo().goo();\n\t        ^^^\nThe method goo() from the type Deprecated is deprecated\n----------\n6. ERROR in a.b.c.d.e\\T.java (at line 9)\n\ta.b.c.d.Deprecated.bar();\n\t                   ^^^\nThe method bar() from the type Deprecated is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testJEP211_1() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"p1/C1.java", "package p1;\n@Deprecated public class C1 {}\n", "Test.java", "import p1.C1;\npublic class Test {\n\tC1 c;\n}\n"};
        runner.expectedCompilerLog = this.complianceLevel < 0x350000L ? "----------\n1. WARNING in Test.java (at line 1)\n\timport p1.C1;\n\t       ^^^^^\nThe type C1 is deprecated\n----------\n2. WARNING in Test.java (at line 3)\n\tC1 c;\n\t^^\nThe type C1 is deprecated\n----------\n" : "----------\n1. WARNING in Test.java (at line 3)\n\tC1 c;\n\t^^\nThe type C1 is deprecated\n----------\n";
        runner.runWarningTest();
    }

    public static Class testClass() {
        return DeprecatedTest.class;
    }
}

