/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class DubiousOutcomeTest
extends AbstractRegressionTest {
    public DubiousOutcomeTest(String name) {
        super(name);
    }

    public static Class<?> testClass() {
        return DubiousOutcomeTest.class;
    }

    public static Test suite() {
        return DubiousOutcomeTest.buildMinimalComplianceTestSuite(DubiousOutcomeTest.testClass(), 32);
    }

    public void testGH1591() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"Outer.java", "import java.io.Serializable;\nimport java.util.List;\nimport java.util.function.Supplier;\n\npublic class Outer {\n\tpublic void test() {\n\t\tSupplier<? extends List<? extends Serializable>> supplier = () -> null;\n\t\terror(supplier.get(), \"\");\n\t}\n\n\tpublic <T, V extends Serializable> void error(List<V> v2, T t) {}\n\n\t}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in Outer.java (at line 8)\n\terror(supplier.get(), \"\");\n\t^^^^^\nThe method error(List<V>, T) in the type Outer is not applicable for the arguments (capture#1-of ? extends List<? extends Serializable>, String)\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DubiousOutcome.EclipseErrorsJavacNone;
        runner.runNegativeTest();
    }

    public void testHohwille_20160104() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"CombinedInterface.java", "interface GenericInterface<V> {\n\tvoid setValue(V value);\n}\ninterface TypedInterface {\n\tvoid setValue(Boolean value);\n}\npublic interface CombinedInterface extends GenericInterface<Boolean>, TypedInterface {\n\tdefault void set(boolean value) {\n\t\tsetValue(Boolean.valueOf(value));\n\t}\n}\n"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DubiousOutcome.JavacErrorsEclipseNone;
        runner.runConformTest();
    }

    public void testHohwille_20180606() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"GenericTest.java", "public class GenericTest<A, B extends A> {\n\n\tprivate final GenericTest<? super A, ? super B> parent;\n\n\tpublic GenericTest(GenericTest<? super A, ? super B> parent) {\n\t\tsuper();\n\t\tthis.parent = parent;\n\t}\n}\n"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DubiousOutcome.JavacErrorsEclipseNone;
        runner.runConformTest();
    }

    public void testHohwille_20231104() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"PropertyFactoryManager.java", "interface WritableObservableValue<V> { }\ninterface ReadableProperty<V> { }\ninterface WritableProperty<V> extends WritableObservableValue<V>, ReadableProperty<V> { }\ninterface PropertyTypeInfo<V> {\n\tClass<V> getValueClass();\n}\ninterface MyPropertyFactory<V, P extends WritableProperty<V>> {\n\t<P2 extends ReadableProperty<V>> P2 create(PropertyTypeInfo<V> typeInfo);\n}\n\npublic interface PropertyFactoryManager {\n\t@SuppressWarnings({ \"rawtypes\" })\n\tdefault <V, P extends ReadableProperty<V>> MyPropertyFactory create(Class<P> propertyType, Class<V> valueClass) {\n\t\t// https://github.com/m-m-m/util/issues/166\n\t\tMyPropertyFactory factory = getRequiredFactory(propertyType, valueClass);\n\t\treturn factory;\n\t}\n\t@SuppressWarnings({ \"rawtypes\", \"unchecked\" })\n\tdefault <V, P extends ReadableProperty<V>> P create(Class<P> propertyType, PropertyTypeInfo<V> typeInfo) {\n\t\t// https://github.com/m-m-m/util/issues/166\n\t\tMyPropertyFactory factory = getRequiredFactory(propertyType, typeInfo.getValueClass());\n\t\treturn (P) factory.create(typeInfo);\n\t}\n\n\tdefault <V, P extends ReadableProperty<V>> MyPropertyFactory<V, ? extends P> getRequiredFactory(\n\t\t\tClass<P> propertyType, Class<V> valueType) {\n\t\treturn null;\n\t}\n}\n"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DubiousOutcome.JDK8319461;
        runner.runConformTest();
    }

    public void testJDK8319461() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"JDK8319461.java", "public class JDK8319461 {\n\tpublic <V, P extends ReadableProperty<V>> P create(Class<P> propertyType, Class<V> valueClass, String name) {\n\t\tFactory factory = getFactory(propertyType, valueClass);\n\t\treturn null;\n\t}\n\tpublic <V, P extends ReadableProperty<V>> Factory<V, ? extends P> getFactory(Class<P> propertyType, Class<V> valueType) {\n\t\tFactory<V, ? extends P> factory = null;\n\t\treturn factory;\n\t}\n\tpublic interface ReadableProperty<V> { }\n\tpublic interface WritableProperty<V> extends ReadableProperty<V> { }\n\tpublic interface Factory<V, P extends WritableProperty<V>> { }\n}\n"};
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DubiousOutcome.JDK8319461;
        runner.runConformTest();
    }
}

