/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.Requestor;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class EnclosingMethodAttributeTest
extends AbstractComparableTest {
    public EnclosingMethodAttributeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return EnclosingMethodAttributeTest.buildComparableTestSuite(EnclosingMethodAttributeTest.testClass());
    }

    public static Class testClass() {
        return EnclosingMethodAttributeTest.class;
    }

    public void test001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\npublic static void main(String[] args) throws Exception  {\n\tclass MyLocal$A {\n\t\tclass Member {\n\t\t}\n\t};\n\tSystem.out.print(MyLocal$A.Member.class.getEnclosingMethod() != null);\n\tSystem.out.print(MyLocal$A.Member.class.getEnclosingConstructor() != null);\n\n\tSystem.out.print(MyLocal$A.class.getEnclosingMethod()!= null);\n\tSystem.out.print(MyLocal$A.class.getEnclosingConstructor() != null);\t\n\t\n\tSystem.out.print(X.class.getEnclosingMethod() != null);\n\tSystem.out.print(X.class.getEnclosingConstructor() != null);\t\n}\npublic Object foo() {\n\treturn new Object() {};\n}\n}"}, "falsefalsetruefalsefalsefalse");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  Enclosing Method: #22  #24 X.foo()Ljava/lang/Object;\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            EnclosingMethodAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\npublic static void main(String[] args) throws Exception  {\n\tclass MyLocal$A {\n\t\tclass Member {\n\t\t\tpublic Object foo() {\n\t\t\t\treturn new Object() {};\n\t\t\t}\n\t\t}\n\t};\n\tSystem.out.print(MyLocal$A.Member.class.getEnclosingMethod() != null);\n\tSystem.out.print(MyLocal$A.Member.class.getEnclosingConstructor() != null);\n\n\tSystem.out.print(MyLocal$A.class.getEnclosingMethod()!= null);\n\tSystem.out.print(MyLocal$A.class.getEnclosingConstructor() != null);\t\n\t\n\tSystem.out.print(X.class.getEnclosingMethod() != null);\n\tSystem.out.print(X.class.getEnclosingConstructor() != null);\t\n}\n}"}, "falsefalsetruefalsefalsefalse");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1MyLocal$A$Member$1.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  Enclosing Method: #22  #24 X$1MyLocal$A$Member.foo()Ljava/lang/Object;\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            EnclosingMethodAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test003() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.*;\npublic class X {\n        public void test() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {\n                class LocalClass {\n                        public void method() {\n                        }\n                };\n                LocalClass localClass = new LocalClass();\n                Class cc = localClass.getClass();\n                System.out.println(\"enclosing class = \" + cc.getEnclosingClass());\n                System.out.println(\"enclosing method = \" + cc.getEnclosingMethod());\n        }\n        public static void main(String args[]) {\n                X t = new X();\n                try {\n                        t.test();\n                } catch (Exception e) {\n                        e.printStackTrace();\n                }\n        }\n}"}, "enclosing class = class X\nenclosing method = public void X.test() throws java.lang.NoSuchMethodException,java.lang.IllegalAccessException,java.lang.reflect.InvocationTargetException");
        INameEnvironment nameEnvironment = this.getNameEnvironment(new String[0], null);
        nameEnvironment.findType((char[][])new char[][]{new char[0], "X$1LocalClass".toCharArray()});
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(OUTPUT_DIR + File.separator + "X$1LocalClass.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  Inner classes:\n    [inner class info: #1 X$1LocalClass, outer class info: #0\n     inner name: #28 LocalClass, accessflags: 0 default]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            EnclosingMethodAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
        if ((index = actualOutput.indexOf(expectedOutput = "  Enclosing Method: #23  #25 X.test()V\n")) == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            EnclosingMethodAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test004() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.*;\ninterface I<E> {\n\tpublic String run();\n}\npublic class X {\n\tpublic Object test(String s, int i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {\n\t\treturn (new I<String>() {\t\t\tpublic String run() {\n\t\t\t\treturn \"SUCCESS\";\n\t\t\t}\n\t\t}).run();\n\t}\n\tpublic static void main(String args[]) {\n\t\tX t = new X();\n\t\ttry {\n\t\t\tSystem.out.println(t.test(\"\", 0));\n\t\t} catch (Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "SUCCESS");
        Requestor requestor = new Requestor(true, null, false, false);
        requestor.outputPath = OUTPUT_DIR.endsWith(File.separator) ? OUTPUT_DIR : OUTPUT_DIR + File.separator;
        Map options = this.getCompilerOptions();
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        INameEnvironment nameEnvironment = this.getNameEnvironment(new String[0], null);
        Compiler batchCompiler = new Compiler(nameEnvironment, this.getErrorHandlingPolicy(), compilerOptions, (ICompilerRequestor)requestor, this.getProblemFactory());
        ReferenceBinding binaryType = batchCompiler.lookupEnvironment.askForType((char[][])new char[][]{new char[0], "X$1".toCharArray()}, batchCompiler.lookupEnvironment.UnNamedModule);
        EnclosingMethodAttributeTest.assertNotNull((String)"Should not be null", (Object)binaryType);
    }

    public void testGH1905() throws Exception {
        if (this.complianceLevel < 0x360000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Object o = new Object () {};\n\tpublic static void main(String[] args) {\n\t\tvar outer = new Object() {\n\t\t\tObject inner = new Object() {\n\t\t\t\t//\n\t\t\t};\n\t\t};\n\t\tSystem.out.println(o.getClass().getEnclosingMethod());\n\t\tSystem.out.println(outer.getClass().getEnclosingMethod());\n\t\tSystem.out.println(outer.inner.getClass().getEnclosingMethod());\n\t}\n}\n"}, "null\npublic static void X.main(java.lang.String[])\nnull");
    }
}

