/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ExternalizeStringLiteralsTest_15
extends AbstractRegressionTest {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("-source 15");

    public ExternalizeStringLiteralsTest_15(String name) {
        super(name);
    }

    public static Test suite() {
        return ExternalizeStringLiteralsTest_15.buildMinimalComplianceTestSuite(ExternalizeStringLiteralsTest_15.testClass(), 4096);
    }

    public void test001() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(true, new String[]{"X.java", "public class X\n{\n    String x = \"\"\"\n        abcdefg\n        hijklmn\n        \"\"\";\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tString x = \"\"\"\n        abcdefg\n        hijklmn\n        \"\"\";\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", JAVAC_OPTIONS);
    }

    public void test002() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(true, new String[]{"X.java", "public class X\n{\n    String x = \"\"\"\n        abcdefg\n        hijklmn\n        \"\"\"; //$NON-NLS-1$ //$NON-NLS-2$\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\t\"\"\"; //$NON-NLS-1$ //$NON-NLS-2$\n\t                   ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n", JAVAC_OPTIONS);
    }

    public void test003() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(true, new String[]{"X.java", "public class X\n{\n    String x = \"\"\"\n        abcdefg\n        hijklmn\n        \"\"\";\n    @SuppressWarnings(\"nls\")\n    void foo() {\n        String x2 = \"\"\"\n            abcdefg\n            hijklmn\n            \"\"\";\n    }\n}"}, null, customOptions, "----------\n1. WARNING in X.java (at line 3)\n\tString x = \"\"\"\n        abcdefg\n        hijklmn\n        \"\"\";\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", JAVAC_OPTIONS);
    }

    public void test004() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(true, new String[]{"X.java", "class X {\n\n\tvoid foo() {\n\t\tString s6 = \"\"\"\n\t\t\tSUCCESS\n\t\t\t\"\"\";\n\t\tSystem.out.println(s6);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 4)\n\tString s6 = \"\"\"\n\t\t\tSUCCESS\n\t\t\t\"\"\";\n\t            ^^^^^^^^^^^^^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tString s6 = \"\"\"\n\t\t\tSUCCESS\n\t\t\t\"\"\"; //$NON-NLS-1$\n\t\tSystem.out.println(s6);\n\t}\n}"}, "SUCCESS", null, true, null, customOptions, null);
    }

    public void test006() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "15");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "15");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@Annot({\n\t\t@A(name = \"\"\"\n           name\n           \"\"\", //$NON-NLS-1$\n \t\tvalue = \"\"\"\n           Test\n           \"\"\") //$NON-NLS-1$\n\t})\n\t@X2(\"\"\"\n   \"\"\") //$NON-NLS-1$\n\tvoid foo() {\n\t}\n}\n@interface Annot {\n\tA[] value();\n}\n@interface A {\n\tString name();\n\tString value();\n}\n@interface X2 {\n\tString value();\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t\"\"\", //$NON-NLS-1$\n\t     ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n2. ERROR in X.java (at line 8)\n\t\"\"\") //$NON-NLS-1$\n\t     ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n3. ERROR in X.java (at line 11)\n\t\"\"\") //$NON-NLS-1$\n\t     ^^^^^^^^^^^^^\nUnnecessary $NON-NLS$ tag\n----------\n", null, true, customOptions);
    }

    public static Class testClass() {
        return ExternalizeStringLiteralsTest_15.class;
    }
}

