/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class FieldAccessTest
extends AbstractRegressionTest {
    public FieldAccessTest(String name) {
        super(name);
    }

    public static Test suite() {
        return FieldAccessTest.buildAllCompliancesTestSuite(FieldAccessTest.testClass());
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "error");
        return options;
    }

    public void test001() {
        this.runConformTest(new String[]{"foo/BaseFoo.java", "package foo;\nclass BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\npublic class Bar {\n int v = foo.NextFoo.VAL;\n}"}, "");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"foo/BaseFoo.java", "package foo;\npublic class BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\npublic class Bar {\n int v = foo.NextFoo.VAL;\n}"}, "----------\n1. ERROR in bar\\Bar.java (at line 3)\n\tint v = foo.NextFoo.VAL;\n\t                    ^^^\nThe static field BaseFoo.VAL should be accessed directly\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runConformTest(new String[]{"foo/BaseFoo.java", "package foo;\nclass BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\nimport foo.NextFoo;\npublic class Bar {\n\tNextFoo[] tab = new NextFoo[] { new NextFoo() };\n\tint v = tab[0].VAL;\n}"}, "", null, true, null, options, null);
    }

    public void test004() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(true, new String[]{"foo/BaseFoo.java", "package foo;\npublic class BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\nimport foo.NextFoo;\npublic class Bar {\n\tNextFoo[] tab = new NextFoo[] { new NextFoo() };\n\tint v = tab[0].VAL;\n}"}, null, options, "----------\n1. ERROR in bar\\Bar.java (at line 5)\n\tint v = tab[0].VAL;\n\t               ^^^\nThe static field BaseFoo.VAL should be accessed directly\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tprivate String memberVariable;\n\tpublic String getMemberVariable() {\n\t\treturn (memberVariable);\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 4)\n\treturn (memberVariable);\n\t        ^^^^^^^^^^^^^^\nUnqualified access to the field X.memberVariable \n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tprivate String memberVariable;\n\tpublic String getMemberVariable() {\n\t\treturn \\u0028memberVariable\\u0029;\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 4)\n\treturn \\u0028memberVariable\\u0029;\n\t             ^^^^^^^^^^^^^^\nUnqualified access to the field X.memberVariable \n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate void foo() {\n\t\tnew A().a2.a.test = 8;\n\t}\n}", "A.java", "class A {\n\tprivate int test;\n\tA a2;\n\tA a = new A();\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew A().a2.a.test = 8;\n\t             ^^^^\nThe field A.test is not visible\n----------\n", null, true, options);
    }

    public void test008() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate void foo() {\n\t\tnew A().a2.a.test = 8;\n\t}\n}", "A.java", "class A {\n\tint test;\n\tprivate A a2;\n\tA a = new A();\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew A().a2.a.test = 8;\n\t        ^^\nThe field A.a2 is not visible\n----------\n", null, true, options);
    }

    public void test009() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate void foo() {\n\t\tnew A().a2.a.test = 8;\n\t}\n}", "A.java", "class A {\n\tint test;\n\tA a2;\n\tprivate A a = new A();\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew A().a2.a.test = 8;\n\t           ^\nThe field A.a is not visible\n----------\n", null, true, options);
    }

    public void test010() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate void foo() {\n\t\tA.a2.a.test = 8;\n\t}\n}", "A.java", "class A {\n\tstatic int test;\n\tstatic A a2;\n\tstatic private A a = new A();\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tA.a2.a.test = 8;\n\t     ^\nThe field A.a is not visible\n----------\n", null, true, options);
    }

    public void test011() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate void foo() {\n\t\tA.a2.a.test = 8;\n\t}\n}", "A.java", "class A {\n\tstatic int test;\n\tstatic private A a2;\n\tstatic A a = new A();\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tA.a2.a.test = 8;\n\t  ^^\nThe field A.a2 is not visible\n----------\n", null, true, options);
    }

    public void test012() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate void foo() {\n\t\tA.a2.a.test = 8;\n\t}\n}", "A.java", "class A {\n\tprivate static int test;\n\tstatic A a2;\n\tA a = new A();\n}\n\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tA.a2.a.test = 8;\n\t       ^^^^\nThe field A.test is not visible\n----------\n", null, true, options);
    }

    public void test013() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A {\n\tprivate void foo() {\n\t\ttest = 8;\n\t}\n}", "A.java", "class A {\n\tprivate int test;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttest = 8;\n\t^^^^\nThe field A.test is not visible\n----------\n", null, true, options);
    }

    public void test014() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A {\n\tprivate void foo() {\n\t\tthis.test = 8;\n\t}\n}", "A.java", "class A {\n\tprivate int test;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthis.test = 8;\n\t     ^^^^\nThe field A.test is not visible\n----------\n", null, true, options);
    }

    public void test015() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A {\n\tprivate void foo() {\n\t\tMyA.test = 8;\n\t}\n}", "A.java", "class A {\n\tprivate static A MyA;\n\tstatic int test;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tMyA.test = 8;\n\t^^^\nThe field A.MyA is not visible\n----------\n", null, true, options);
    }

    public void test016() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A {\n\tprivate void foo() {\n\t\tMyA2.MyA.test = 8;\n\t}\n}", "A.java", "class A {\n\tprivate static A MyA;\n\tstatic A MyA2;\n\tstatic int test;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tMyA2.MyA.test = 8;\n\t     ^^^\nThe field A.MyA is not visible\n----------\n", null, true, options);
    }

    public void test017() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\tZork z;\n       private static class Inner1 {\n                private int field;\n       }\n       private static class Inner2 extends Inner1 {\n                private int field;\n                public void bar() {System.out.println(field);}\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
    }

    public void test018() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\tZork z;\n\t\tpublic static int field;\n       private static class Inner1 {\n                private int field;\n       }\n       private static class Inner2 extends Inner1 {\n                private int field;\n                public void bar() {System.out.println(field);}\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 5)\n\tprivate int field;\n\t            ^^^^^\nThe field X.Inner1.field is hiding a field from type X\n----------\n3. WARNING in X.java (at line 8)\n\tprivate int field;\n\t            ^^^^^\nThe field X.Inner2.field is hiding a field from type X\n----------\n", null, true, options);
    }

    public void test019() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\tZork z;\n       private static class Inner1 {\n                private int field;\n       }\n       private static class Inner2 extends Inner1 {\n                public void bar(int field) {System.out.println(field);}\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
    }

    public void test020() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\tZork z;\n\t\tpublic static int field;\n       private static class Inner1 {\n                private int field;\n       }\n       private static class Inner2 extends Inner1 {\n                public void bar(int field) {System.out.println(field);}\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 5)\n\tprivate int field;\n\t            ^^^^^\nThe field X.Inner1.field is hiding a field from type X\n----------\n3. WARNING in X.java (at line 8)\n\tpublic void bar(int field) {System.out.println(field);}\n\t                    ^^^^^\nThe parameter field is hiding a field from type X\n----------\n", null, true, options);
    }

    public void test021() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\tpublic void bar() {\n\t\tArrayList myList = new ArrayList();\n\t\tint len = myList.length;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tint len = myList.length;\n\t                 ^^^^^^\nlength cannot be resolved or is not a field\n----------\n", null, true, options);
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic int NEW_FIELD;\n}", "Y.java", "public class Y {\n\tvoid foo() {\n\t\tint i = X.OLD_FIELD;\n\t}\n\tvoid bar() {\n\t\tint j = X.OLD_FIELD;\n\t}\n}"}, "----------\n1. ERROR in Y.java (at line 3)\n\tint i = X.OLD_FIELD;\n\t          ^^^^^^^^^\nOLD_FIELD cannot be resolved or is not a field\n----------\n2. ERROR in Y.java (at line 6)\n\tint j = X.OLD_FIELD;\n\t          ^^^^^^^^^\nOLD_FIELD cannot be resolved or is not a field\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic abstract class A {\n    protected int field;\n}\n", "p2/B.java", "package p2;\nimport p1.A;\npublic abstract class B extends A {\n    protected int field;\n}\n"}, "----------\n1. WARNING in p2\\B.java (at line 4)\n\tprotected int field;\n\t              ^^^^^\nThe field B.field is hiding a field from type A\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic abstract class A extends Super {\n}\n", "p1/Super.java", "package p1;\npublic abstract class Super extends SuperSuper {\n}\n", "p1/SuperSuper.java", "package p1;\npublic abstract class SuperSuper {\n    protected int field;\n}\n", "p2/B.java", "package p2;\nimport p1.A;\npublic abstract class B extends A {\n    protected int field;\n}\n"}, "----------\n1. WARNING in p2\\B.java (at line 4)\n\tprotected int field;\n\t              ^^^^^\nThe field B.field is hiding a field from type SuperSuper\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic abstract class A extends Super {\n}\n", "p1/Super.java", "package p1;\npublic abstract class Super extends SuperSuper {\n}\n", "p1/SuperSuper.java", "package p1;\npublic abstract class SuperSuper implements Interface{\n}\n", "p1/Interface.java", "package p1;\npublic interface Interface{\n    int field = 123;\n}\n", "p2/B.java", "package p2;\nimport p1.A;\npublic abstract class B extends A {\n    protected int field;\n}\n"}, "----------\n1. WARNING in p2\\B.java (at line 4)\n\tprotected int field;\n\t              ^^^^^\nThe field B.field is hiding a field from type Interface\n----------\n");
    }

    public void testBug361039() {
        this.runNegativeTest(new String[]{"Bug361039.java", "public class Bug361039 {\n\tpublic Bug361039(boolean b) {\n\t}\n\tprivate Object foo() {\n\t\treturn new Bug361039(!((Boolean)this.f));\n\t}\n}\n"}, "----------\n1. ERROR in Bug361039.java (at line 5)\n\treturn new Bug361039(!((Boolean)this.f));\n\t                                     ^\nf cannot be resolved or is not a field\n----------\n");
    }

    public void testBug568959_001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public void foo(Object o) {\n   I i = () -> {\n     while (o.eq) {\n       // nothing\n     }\n   };\n }\n}\ninterface I { \n public abstract void run();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\twhile (o.eq) {\n\t         ^^\neq cannot be resolved or is not a field\n----------\n");
    }

    public static Class testClass() {
        return FieldAccessTest.class;
    }
}

