/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.jdt.core.tests.compiler.regression.NullReferenceImplTests;
import org.eclipse.jdt.core.tests.compiler.regression.NullReferenceImplTransformations;
import org.eclipse.jdt.core.tests.compiler.regression.TransitiveClosureHolder;

class Generator {
    Generator() {
    }

    static NullReferenceImplTests.State[] computeTransitiveClosure() {
        TransitiveClosureHolder transitiveClosure = new TransitiveClosureHolder();
        NullReferenceImplTests.State[] unknowns = transitiveClosure.notAlreadyKnowns();
        while (unknowns.length != 0) {
            transitiveClosure.markAllAsAlreadyKnown();
            int i = 0;
            int length = NullReferenceImplTransformations.transformations.length;
            while (i < length) {
                transitiveClosure.add(NullReferenceImplTransformations.transformations[i].computeOutputs(transitiveClosure.asArray()));
                ++i;
            }
            unknowns = transitiveClosure.notAlreadyKnowns();
        }
        return transitiveClosure.asArray();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Generator.printHelp(false);
            System.exit(1);
        }
        switch (args.length) {
            case 1: {
                if (args[0].equals("--help")) {
                    Generator.printHelp(true);
                    System.exit(0);
                    break;
                }
                Generator.printHelp(false);
                System.exit(1);
                break;
            }
            case 2: {
                if (args[0].equals("--printTruthTables")) {
                    File outputDir = new File(args[1]);
                    if (outputDir.isDirectory()) {
                        int i = 0;
                        int length = NullReferenceImplTransformations.transformations.length;
                        while (i < length) {
                            NullReferenceImplTransformations.transformations[i].printTruthTables(outputDir);
                            ++i;
                        }
                    }
                    System.exit(0);
                    break;
                }
                Generator.printHelp(false);
                System.exit(1);
                break;
            }
            case 3: {
                if (args[0].equals("--reinitializeFromComputedValues")) {
                    Generator.reinitializeFromComputedValues(args[1], args[2]);
                    System.out.println("Generator generated new file into " + args[2]);
                    System.exit(0);
                }
            }
            case 5: {
                if (args[0].equals("--reinitializeFromComments")) {
                    Generator.reinitializeFromComments(args[1], args[2], args[3], args[4]);
                    System.out.println("Generator generated new files into " + args[2] + " and " + args[4]);
                    System.exit(0);
                }
            }
            default: {
                Generator.printHelp(false);
                System.exit(1);
            }
        }
    }

    private static void reinitializeFromComments(String statesSource, String statesTarget, String transformationsSource, String transformationsTarget) {
        if (statesSource.equals(transformationsSource) || statesTarget.equals(transformationsTarget)) {
            throw new RuntimeException();
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(statesSource));
            BufferedWriter out = new BufferedWriter(new FileWriter(statesTarget));
            NullReferenceImplTests.State.reinitializeFromComment(in, out);
            in.close();
            out.close();
            File[] tempFiles = new File[]{File.createTempFile("generator", "java"), File.createTempFile("generator", "java")};
            in = new BufferedReader(new FileReader(transformationsSource));
            out = new BufferedWriter(new FileWriter(tempFiles[0]));
            NullReferenceImplTransformations.transformations[0].reinitializeFromComments(in, out);
            in.close();
            out.close();
            int i = 1;
            int length = NullReferenceImplTransformations.transformations.length - 1;
            while (i < length) {
                in = new BufferedReader(new FileReader(tempFiles[(i + 1) % 2]));
                out = new BufferedWriter(new FileWriter(tempFiles[i % 2]));
                NullReferenceImplTransformations.transformations[i].reinitializeFromComments(in, out);
                in.close();
                out.close();
                ++i;
            }
            in = new BufferedReader(new FileReader(tempFiles[(i + 1) % 2]));
            out = new BufferedWriter(new FileWriter(transformationsTarget));
            NullReferenceImplTransformations.transformations[i].reinitializeFromComments(in, out);
            in.close();
            out.close();
        }
        catch (Throwable t) {
            System.err.println("Generator error:");
            t.printStackTrace(System.err);
            System.exit(2);
        }
    }

    private static void reinitializeFromComputedValues(String source, String target) {
        int i = 0;
        int length = NullReferenceImplTransformations.transformations.length;
        while (i < length) {
            NullReferenceImplTransformations.transformations[i].hydrate();
            ++i;
        }
        NullReferenceImplTests.State[] transitiveClosure = Generator.computeTransitiveClosure();
        transitiveClosure = Generator.addSymbolicStates(transitiveClosure);
        Arrays.sort(transitiveClosure, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.valueOf(((NullReferenceImplTests.State)o1).value).compareTo(Integer.valueOf(((NullReferenceImplTests.State)o2).value));
            }
        });
        try {
            File[] tempFiles = new File[]{File.createTempFile("generator", "java"), File.createTempFile("generator", "java")};
            BufferedReader in = new BufferedReader(new FileReader(source));
            BufferedWriter out = new BufferedWriter(new FileWriter(tempFiles[0]));
            NullReferenceImplTransformations.transformations[0].reinitializeFromComputedValues(in, out, transitiveClosure);
            in.close();
            out.close();
            int i2 = 1;
            int length2 = NullReferenceImplTransformations.transformations.length - 1;
            while (i2 < length2) {
                in = new BufferedReader(new FileReader(tempFiles[(i2 + 1) % 2]));
                out = new BufferedWriter(new FileWriter(tempFiles[i2 % 2]));
                NullReferenceImplTransformations.transformations[i2].reinitializeFromComputedValues(in, out, transitiveClosure);
                in.close();
                out.close();
                ++i2;
            }
            in = new BufferedReader(new FileReader(tempFiles[(i2 + 1) % 2]));
            out = new BufferedWriter(new FileWriter(target));
            NullReferenceImplTransformations.transformations[i2].reinitializeFromComputedValues(in, out, transitiveClosure);
            in.close();
            out.close();
        }
        catch (Throwable t) {
            System.err.println("Generator error:");
            t.printStackTrace(System.err);
            System.exit(2);
        }
    }

    private static NullReferenceImplTests.State[] addSymbolicStates(NullReferenceImplTests.State[] transitiveClosure) {
        HashSet<NullReferenceImplTests.State> allStates = new HashSet<NullReferenceImplTests.State>();
        allStates.addAll(Arrays.asList(transitiveClosure));
        int i = 0;
        while (i < 64) {
            if (NullReferenceImplTests.State.states[i].symbolic) {
                allStates.add(NullReferenceImplTests.State.states[i]);
            }
            ++i;
        }
        return allStates.toArray(new NullReferenceImplTests.State[allStates.size()]);
    }

    private static void printHelp(boolean longText) {
        if (longText) {
            System.out.println("Generator use cases\n - when a brand new logic is experimented for the transitions, the best\n   way to go is to write explicit (inefficient) transformation code within\n   UnconditionalFlowInfo, then generate the literal initializers from\n   there; use the command\n   --reinitializeFromComputedValues <source file> <target file>\n   to this effect; in case of inconsistencies or errors, messages are\n   printed to the error output stream and the result should be considered as non reliable;\n - when only a few changes are made to state names or a specific\n   transitions, it should be possible to get the test initializers fixed\n   before UnconditionalFlowInfo implements those changes; use the command\n   --reinitializeFromComments <states source file> <states target file> <transformations source file> <transformations target file>\n   to this effect;\n - the same command can be used when, while the semantics of the system\n   are unchanged, the encoding is modified; it should then produce the\n   initializers according to the new encoding, as defined by the comment\n   for State.states, and the transformations as defined by their\n   respective comment;\n - when a given encoding is retained, its optimization may leverage truth\n   tables; use the --printTruthTables command to this effect.\n   \n\n");
            Generator.printHelp(false);
        } else {
            System.out.println("Usage:\nGenerator --help\n  prints a more detailed help message\nGenerator --printTruthTables\n  prints the truth tables of the transformations\nGenerator --reinitializeFromComments <source file> <target file>\n  generates into target file a copy of source file into which\n  transformations initializers have been reset from their definitions\nGenerator --reinitializeFromComputedValues <source file> <target file>\n  generates into target file a copy of source file into which\n  transformations definitions and initializers have been reset\n  according to the behavior of the current UnconditionalFlowInfo\n");
        }
    }
}

