/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.ILocalVariableTypeTableAttribute;
import org.eclipse.jdt.core.util.ILocalVariableTypeTableEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.core.util.ISignatureAttribute;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.core.util.Util;

public class GenericTypeSignatureTest
extends AbstractRegressionTest {
    static final String RUN_SUN_JAVAC = System.getProperty("run.javac");
    static boolean RunJavac = "enabled".equals(RUN_SUN_JAVAC);
    IPath dirPath = new Path(OUTPUT_DIR);

    public static Test suite() {
        return GenericTypeSignatureTest.buildMinimalComplianceTestSuite(GenericTypeSignatureTest.testClass(), 32);
    }

    public static Class testClass() {
        return GenericTypeSignatureTest.class;
    }

    public GenericTypeSignatureTest(String name) {
        super(name);
    }

    protected void cleanUp() {
        org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(new File(OUTPUT_DIR));
    }

    protected String[] getFileNames(String[] testFiles) {
        int length = testFiles.length;
        int max = length / 2;
        String[] fileNames = new String[max];
        int i = 0;
        while (i < max) {
            fileNames[i] = testFiles[i * 2];
            ++i;
        }
        return fileNames;
    }

    protected void runJavac(String testName, String[] testFiles) {
        try {
            this.writeFiles(testFiles);
            String[] fileNames = this.getFileNames(testFiles);
            Process process = null;
            try {
                String[] classpath = this.getDefaultClassPaths();
                StringBuilder cp = new StringBuilder();
                int length = classpath.length;
                int i = 0;
                while (i < length) {
                    if (classpath[i].indexOf(" ") != -1) {
                        cp.append("\"" + classpath[i] + "\"");
                    } else {
                        cp.append(classpath[i]);
                    }
                    if (i < length - 1) {
                        cp.append(";");
                    }
                    ++i;
                }
                IPath jdkDir = new Path(org.eclipse.jdt.core.tests.util.Util.getJREDirectory()).removeLastSegments(1);
                IPath javacPath = "Linux".equals(System.getProperty("os.name")) ? jdkDir.append("bin").append("javac") : jdkDir.append("bin").append("javac.exe");
                StringBuilder cmdLine = new StringBuilder(javacPath.toString());
                cmdLine.append(" -classpath ");
                cmdLine.append((CharSequence)cp);
                cmdLine.append(" -source 1.5 -deprecation -g -Xlint ");
                int i2 = 0;
                int length2 = fileNames.length;
                while (i2 < length2) {
                    cmdLine.append(fileNames[i2] + " ");
                    ++i2;
                }
                String cmdLineAsString = "Linux".equals(System.getProperty("os.name")) ? cmdLine.toString().replaceAll("\"", "") : cmdLine.toString();
                process = Runtime.getRuntime().exec(cmdLineAsString.split("\\s"), null, this.dirPath.toFile());
                Logger errorLogger = new Logger(process.getErrorStream(), "ERROR");
                Logger outputLogger = new Logger(process.getInputStream(), "OUTPUT");
                errorLogger.start();
                outputLogger.start();
                if (process.waitFor() != 0) {
                    System.out.println(testName + ": javac has found error(s)!");
                }
            }
            catch (IOException ioe) {
                System.out.println(testName + ": Not possible to launch OpenJDK javac compilation!");
            }
            catch (InterruptedException e1) {
                if (process != null) {
                    process.destroy();
                }
                System.out.println(testName + ": OpenJDK javac compilation was aborted!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void test001() {
        ILocalVariableTypeTableEntry entry;
        ClassFileReader classFileReader;
        String[] testsSource = new String[]{"X.java", "public class X <T> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n    public static void main(String[] args) {\n    \tX<X<String>> xs = new X<X<String>>(new X<String>(\"SUCCESS\"));\n        System.out.print(xs.t.t);\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;>Lp/A<TT;>;", new String(classFileReader.getGenericSignature()));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        IClassFileAttribute classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        char[] signature = signatureAttribute.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;>Lp/A<TT;>;", new String(signature));
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        int length = methodInfos.length;
        GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)2, (int)length);
        IMethodInfo mainMethod = null;
        int i = 0;
        while (i < length) {
            IMethodInfo methodInfo = methodInfos[i];
            if ("main".equals(new String(methodInfo.getName()))) {
                mainMethod = methodInfo;
                break;
            }
            ++i;
        }
        if (mainMethod == null) {
            GenericTypeSignatureTest.assertNotNull(mainMethod);
            return;
        }
        ICodeAttribute codeAttribute = mainMethod.getCodeAttribute();
        classFileAttribute = Util.getAttribute((ICodeAttribute)codeAttribute, (char[])IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ILocalVariableTypeTableAttribute localVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)classFileAttribute;
        ILocalVariableTypeTableEntry[] entries = localVariableTypeTableAttribute.getLocalVariableTypeTable();
        ILocalVariableTypeTableEntry xsEntry = null;
        int i2 = 0;
        int max = entries.length;
        while (i2 < max) {
            ILocalVariableTypeTableEntry entry2 = entries[i2];
            if ("xs".equals(new String(entry2.getName()))) {
                xsEntry = entry2;
                break;
            }
            ++i2;
        }
        if (xsEntry == null) {
            GenericTypeSignatureTest.assertNotNull(xsEntry);
            return;
        }
        signature = xsEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "LX<LX<Ljava/lang/String;>;>;", new String(signature));
        IMethodInfo constructorMethod = null;
        int i3 = 0;
        while (i3 < length) {
            IMethodInfo methodInfo = methodInfos[i3];
            if ("<init>".equals(new String(methodInfo.getName()))) {
                constructorMethod = methodInfo;
                break;
            }
            ++i3;
        }
        if (constructorMethod == null) {
            GenericTypeSignatureTest.assertNotNull(constructorMethod);
            return;
        }
        codeAttribute = constructorMethod.getCodeAttribute();
        classFileAttribute = Util.getAttribute((ICodeAttribute)codeAttribute, (char[])IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        localVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)classFileAttribute;
        entries = localVariableTypeTableAttribute.getLocalVariableTypeTable();
        ILocalVariableTypeTableEntry thisEntry = null;
        int i4 = 0;
        int max2 = entries.length;
        while (i4 < max2) {
            ILocalVariableTypeTableEntry entry3 = entries[i4];
            if ("this".equals(new String(entry3.getName()))) {
                thisEntry = entry3;
                break;
            }
            ++i4;
        }
        if (thisEntry == null) {
            GenericTypeSignatureTest.assertNotNull(thisEntry);
            return;
        }
        signature = thisEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "LX<TT;>;", new String(signature));
        ILocalVariableTypeTableEntry tEntry = null;
        int i5 = 0;
        int max3 = entries.length;
        while (i5 < max3) {
            entry = entries[i5];
            if ("t".equals(new String(entry.getName()))) {
                tEntry = entry;
                break;
            }
            ++i5;
        }
        if (tEntry == null) {
            GenericTypeSignatureTest.assertNotNull(tEntry);
            return;
        }
        signature = tEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "TT;", new String(signature));
        if (!RunJavac) {
            return;
        }
        this.cleanUp();
        this.runJavac("test001", testsSource);
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        signature = signatureAttribute.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;>Lp/A<TT;>;", new String(signature));
        methodInfos = classFileReader.getMethodInfos();
        length = methodInfos.length;
        GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)2, (int)length);
        mainMethod = null;
        i5 = 0;
        while (i5 < length) {
            IMethodInfo methodInfo = methodInfos[i5];
            if ("main".equals(new String(methodInfo.getName()))) {
                mainMethod = methodInfo;
                break;
            }
            ++i5;
        }
        if (mainMethod == null) {
            GenericTypeSignatureTest.assertNotNull((Object)mainMethod);
            return;
        }
        codeAttribute = mainMethod.getCodeAttribute();
        classFileAttribute = Util.getAttribute((ICodeAttribute)codeAttribute, (char[])IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        localVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)classFileAttribute;
        entries = localVariableTypeTableAttribute.getLocalVariableTypeTable();
        xsEntry = null;
        i5 = 0;
        max = entries.length;
        while (i5 < max) {
            entry = entries[i5];
            if ("xs".equals(new String(entry.getName()))) {
                xsEntry = entry;
                break;
            }
            ++i5;
        }
        if (xsEntry == null) {
            GenericTypeSignatureTest.assertNotNull((Object)xsEntry);
            return;
        }
        signature = xsEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "LX<LX<Ljava/lang/String;>;>;", new String(signature));
        constructorMethod = null;
        i5 = 0;
        while (i5 < length) {
            IMethodInfo methodInfo = methodInfos[i5];
            if ("<init>".equals(new String(methodInfo.getName()))) {
                constructorMethod = methodInfo;
                break;
            }
            ++i5;
        }
        if (constructorMethod == null) {
            GenericTypeSignatureTest.assertNotNull((Object)constructorMethod);
            return;
        }
        codeAttribute = constructorMethod.getCodeAttribute();
        classFileAttribute = Util.getAttribute((ICodeAttribute)codeAttribute, (char[])IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        localVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)classFileAttribute;
        entries = localVariableTypeTableAttribute.getLocalVariableTypeTable();
        thisEntry = null;
        i5 = 0;
        max = entries.length;
        while (i5 < max) {
            entry = entries[i5];
            if ("this".equals(new String(entry.getName()))) {
                thisEntry = entry;
                break;
            }
            ++i5;
        }
        if (thisEntry == null) {
            GenericTypeSignatureTest.assertNotNull((Object)thisEntry);
            return;
        }
        signature = thisEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "LX<TT;>;", new String(signature));
        tEntry = null;
        i5 = 0;
        max = entries.length;
        while (i5 < max) {
            entry = entries[i5];
            if ("t".equals(new String(entry.getName()))) {
                tEntry = entry;
                break;
            }
            ++i5;
        }
        if (tEntry == null) {
            GenericTypeSignatureTest.assertNotNull((Object)tEntry);
            return;
        }
        signature = tEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"no signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "TT;", new String(signature));
    }

    public void test002() {
        ILocalVariableTypeTableEntry entry;
        String[] testsSource = new String[]{"X.java", "class X extends p.A<String> {\n    X() {\n        super(null);\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected A(P p) {\n    }\n}"};
        this.runConformTest(testsSource);
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        IClassFileAttribute classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        GenericTypeSignatureTest.assertEquals("Wrong signature", "Lp/A<Ljava/lang/String;>;", new String(signatureAttribute.getSignature()));
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "p/A.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        char[] signature = signatureAttribute.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<P:Ljava/lang/Object;>Ljava/lang/Object;", new String(signature));
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        int length = methodInfos.length;
        GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)1, (int)length);
        IMethodInfo constructorMethod = methodInfos[0];
        ICodeAttribute codeAttribute = constructorMethod.getCodeAttribute();
        classFileAttribute = Util.getAttribute((ICodeAttribute)codeAttribute, (char[])IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ILocalVariableTypeTableAttribute localVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)classFileAttribute;
        ILocalVariableTypeTableEntry[] entries = localVariableTypeTableAttribute.getLocalVariableTypeTable();
        ILocalVariableTypeTableEntry thisEntry = null;
        int i = 0;
        int max = entries.length;
        while (i < max) {
            ILocalVariableTypeTableEntry entry2 = entries[i];
            if ("this".equals(new String(entry2.getName()))) {
                thisEntry = entry2;
                break;
            }
            ++i;
        }
        if (thisEntry == null) {
            GenericTypeSignatureTest.assertNotNull(thisEntry);
            return;
        }
        GenericTypeSignatureTest.assertEquals("Wrong signature", "Lp/A<TP;>;", new String(thisEntry.getSignature()));
        ILocalVariableTypeTableEntry tEntry = null;
        int i2 = 0;
        int max2 = entries.length;
        while (i2 < max2) {
            entry = entries[i2];
            if ("p".equals(new String(entry.getName()))) {
                tEntry = entry;
                break;
            }
            ++i2;
        }
        if (tEntry == null) {
            GenericTypeSignatureTest.assertNotNull(tEntry);
            return;
        }
        signature = tEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "TP;", new String(signature));
        if (!RunJavac) {
            return;
        }
        this.cleanUp();
        this.runJavac("test002", testsSource);
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        GenericTypeSignatureTest.assertEquals("Wrong signature", "Lp/A<Ljava/lang/String;>;", new String(signatureAttribute.getSignature()));
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "p/A.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        signature = signatureAttribute.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<P:Ljava/lang/Object;>Ljava/lang/Object;", new String(signature));
        methodInfos = classFileReader.getMethodInfos();
        length = methodInfos.length;
        GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)1, (int)length);
        constructorMethod = methodInfos[0];
        codeAttribute = constructorMethod.getCodeAttribute();
        classFileAttribute = Util.getAttribute((ICodeAttribute)codeAttribute, (char[])IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        localVariableTypeTableAttribute = (ILocalVariableTypeTableAttribute)classFileAttribute;
        entries = localVariableTypeTableAttribute.getLocalVariableTypeTable();
        thisEntry = null;
        i2 = 0;
        max2 = entries.length;
        while (i2 < max2) {
            entry = entries[i2];
            if ("this".equals(new String(entry.getName()))) {
                thisEntry = entry;
                break;
            }
            ++i2;
        }
        if (thisEntry == null) {
            GenericTypeSignatureTest.assertNotNull((Object)thisEntry);
            return;
        }
        signature = thisEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "Lp/A<TP;>;", new String(signature));
        tEntry = null;
        i2 = 0;
        max2 = entries.length;
        while (i2 < max2) {
            entry = entries[i2];
            if ("p".equals(new String(entry.getName()))) {
                tEntry = entry;
                break;
            }
            ++i2;
        }
        if (tEntry == null) {
            GenericTypeSignatureTest.assertNotNull((Object)tEntry);
            return;
        }
        signature = tEntry.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "TP;", new String(signature));
    }

    public void test003() {
        String[] testsSource = new String[]{"X.java", "public class X <T extends Object & p.B<? super T>> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}", "p/B.java", "package p;\npublic interface B<T> {\n}"};
        this.runConformTest(testsSource);
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        IClassFileAttribute classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;:Lp/B<-TT;>;>Lp/A<TT;>;", new String(signatureAttribute.getSignature()));
        if (!RunJavac) {
            return;
        }
        this.cleanUp();
        this.runJavac("test003", testsSource);
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;:Lp/B<-TT;>;>Lp/A<TT;>;", new String(signatureAttribute.getSignature()));
    }

    public void test004() {
        String[] testsSource = new String[]{"X.java", "public class X <T extends Object & p.B> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}", "p/B.java", "package p;\npublic interface B<T> {\n}"};
        this.runConformTest(testsSource);
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        IClassFileAttribute classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;:Lp/B;>Lp/A<TT;>;", new String(signatureAttribute.getSignature()));
        if (!RunJavac) {
            return;
        }
        this.cleanUp();
        this.runJavac("test004", testsSource);
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;:Lp/B;>Lp/A<TT;>;", new String(signatureAttribute.getSignature()));
    }

    public void test005() {
        String[] testsSource = new String[]{"X.java", "public class X <T extends Object & p.B & p.C> extends p.A<T> {\n    protected T t;\n    X(T t) {\n        super(t);\n        this.t = t;\n    }\n}", "p/A.java", "package p;\npublic class A<P> {\n    protected P p;\n    protected A(P p) {\n        this.p = p;\n    }\n}", "p/B.java", "package p;\npublic interface B<T> {\n}", "p/C.java", "package p;\npublic interface C<T> {\n}"};
        this.runConformTest(testsSource);
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        IClassFileAttribute classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        char[] signature = signatureAttribute.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;:Lp/B;:Lp/C;>Lp/A<TT;>;", new String(signature));
        if (!RunJavac) {
            return;
        }
        this.cleanUp();
        this.runJavac("test005", testsSource);
        classFileReader = ToolFactory.createDefaultClassFileReader((String)(OUTPUT_DIR + File.separator + "X.class"), (int)65535);
        GenericTypeSignatureTest.assertNotNull((Object)classFileReader);
        classFileAttribute = Util.getAttribute((IClassFileReader)classFileReader, (char[])IAttributeNamesConstants.SIGNATURE);
        GenericTypeSignatureTest.assertNotNull((Object)classFileAttribute);
        signatureAttribute = (ISignatureAttribute)classFileAttribute;
        signature = signatureAttribute.getSignature();
        GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
        GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;:Lp/B;:Lp/C;>Lp/A<TT;>;", new String(signature));
    }

    public void test006() {
        String[] testsSource = new String[]{"X.java", "public class X <T> {\n    protected T t;\n    X(T t) {\n        this.t = t;\n    }\n\tT foo(T t1) {\n\t\treturn t1;\n    }\n\tT field;\n    public static void main(String[] args) {\n        System.out.print(\"SUCCESS\");\n    }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;>Ljava/lang/Object;", new String(classFileReader.getGenericSignature()));
            IBinaryField[] fields = classFileReader.getFields();
            GenericTypeSignatureTest.assertNotNull((String)"No fields", (Object)fields);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)2, (int)fields.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "field", new String(fields[1].getName()));
            char[] signature = fields[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "TT;", new String(signature));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[1].getSelector()));
            signature = methods[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(TT;)TT;", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test007() {
        String[] testsSource = new String[]{"X.java", "public class X <T> {\n    protected T t;\n    X(T t) {\n        this.t = t;\n    }\n\tT foo(X<T> x1) {\n\t\treturn x1.t;\n    }\n\tX<T> field;\n    public static void main(String[] args) {\n        System.out.print(\"SUCCESS\");\n    }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;>Ljava/lang/Object;", new String(classFileReader.getGenericSignature()));
            IBinaryField[] fields = classFileReader.getFields();
            GenericTypeSignatureTest.assertNotNull((String)"No fields", (Object)fields);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)2, (int)fields.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "field", new String(fields[1].getName()));
            char[] signature = fields[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "LX<TT;>;", new String(signature));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[1].getSelector()));
            signature = methods[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LX<TT;>;)TT;", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test008() {
        String[] testsSource = new String[]{"X.java", "public class X  <T> {\n\tT newInstance() throws IllegalAccessException {\n\t    return null;\n\t}\n    public static void main(String[] args) {\n        System.out.print(\"SUCCESS\");\n    }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "newInstance", new String(methods[1].getSelector()));
            char[] signature = methods[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "()TT;", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test009() {
        String[] testsSource = new String[]{"X.java", "public class X<T> {\nclass MX<U> {\n}\n \npublic static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n}\nvoid foo(X<String>.MX<Thread> mx) {\n   System.out.println(\"SUCCESS\");\n}\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            char[] signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LX<Ljava/lang/String;>.MX<Ljava/lang/Thread;>;)V", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test010() {
        String[] testsSource = new String[]{"X.java", "public class X<T> {\nclass MX<U> {\n}\n \npublic static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n}\nvoid foo(X.MX mx) {\n   System.out.println(\"SUCCESS\");\n}\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            char[] signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNull((String)"Unexpected generic signature", (Object)signature);
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test011() {
        String[] testsSource = new String[]{"X.java", "public class X<T> {\n  class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n  }\n  void foo(X<String>.MX<?> mx) {\n\tSystem.out.println(\"SUCCESS\");\n  }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            char[] signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LX<Ljava/lang/String;>.MX<*>;)V", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    @Override
    protected void writeFiles(String[] testFiles) {
        IPath dirFilePath = (IPath)this.dirPath.clone();
        File dir = dirFilePath.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            dirFilePath = (IPath)this.dirPath.clone();
            String contents = testFiles[i + 1];
            String fileName = testFiles[i++];
            IPath filePath = dirFilePath.append(fileName);
            if (fileName.lastIndexOf(47) >= 0 && !(dir = (dirFilePath = filePath.removeLastSegments(1)).toFile()).exists()) {
                dir.mkdirs();
            }
            org.eclipse.jdt.core.tests.util.Util.writeToFile(contents, filePath.toString());
            ++i;
        }
    }

    public void test012() {
        String[] testsSource = new String[]{"X.java", "public class X<T> {\n  class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo(new X<String>().new MX<Thread>());\n  }\n  void foo(X.MX mx) {\t\t\t// no signature\n\tSystem.out.println(\"SUCCESS\");\n  }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            GenericTypeSignatureTest.assertNull((String)"Wrong signature", (Object)methods[2].getGenericSignature());
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test013() {
        String[] testsSource = new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X<T> {\n\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic <U> void foo(ArrayList<U> arr) {\n\t\tfor (U e : arr) {\n\t\t\tSystem.out.println(e);\n\t\t}\n\t}\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            char[] signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "<U:Ljava/lang/Object;>(Ljava/util/ArrayList<TU;>;)V", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test014() {
        String[] testsSource = new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n\tprivate List<X> games = new ArrayList<X>();\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryField[] fields = classFileReader.getFields();
            GenericTypeSignatureTest.assertNotNull((String)"No fields", (Object)fields);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)1, (int)fields.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "games", new String(fields[0].getName()));
            char[] signature = fields[0].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "Ljava/util/List<LX;>;", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test015() {
        String[] testsSource = new String[]{"X.java", "public interface X<T> {\n}"};
        this.runConformTest(testsSource, "");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            char[] signature = classFileReader.getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "<T:Ljava/lang/Object;>Ljava/lang/Object;", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test016() {
        String[] testsSource = new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X<T> {\n\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic <U> void foo(U[] arr) {\n\t}\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            char[] signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "<U:Ljava/lang/Object;>([TU;)V", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test017() {
        String[] testsSource = new String[]{"X.java", "public class X<T> {\n  static class MX<U> {\n  }\n\n  public static void main(String[] args) {\n    new X<Thread>().foo(new MX<Thread>());\n  }\n  void foo(X.MX<?> mx) {\n\tSystem.out.println(\"SUCCESS\");\n  }\n}"};
        this.runConformTest(testsSource, "SUCCESS");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)3, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[2].getSelector()));
            char[] signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LX$MX<*>;)V", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test018() {
        String[] testsSource = new String[]{"X.java", "public class X<K extends X.Key> {\n    public abstract static class Key {\n         public abstract String getName();\n    }\n    public class Holder {}\n    \n    void baz(X<K>.Holder h) {} // (LX<TK;>.Holder;)V\n    void bar(X.Holder h) {} // n/a\n    void foo(X<Key>.Holder h) {} // (LX<LX$Key;>.Holder;)V\n}\n"};
        this.runConformTest(testsSource, "");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)4, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "baz", new String(methods[1].getSelector()));
            char[] signature = methods[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LX<TK;>.Holder;)V", new String(signature));
            GenericTypeSignatureTest.assertEquals("Wrong name", "bar", new String(methods[2].getSelector()));
            signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo", new String(methods[3].getSelector()));
            signature = methods[3].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LX<LX$Key;>.Holder;)V", new String(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test019() {
        String[] testsSource = new String[]{"X.java", "public class X<K extends X.Key> {\n    public abstract static class Key {\n         public abstract String getName();\n    }\n    public class Holder {}\n    \n    X<K>.Holder foo() { return null; }\n    \n    static void bar() {\n    \tObject o = new X<Key>().foo();\n    \tclass Local<U> {\n    \t\tX<Key>.Holder field;\n    \t\tLocal<String> foo1() { return null; }\n    \t\tLocal<U> foo2() { return null; }\n    \t\tLocal foo3() { return null; }\n    \t}\n    }\n}\n"};
        this.runConformTest(testsSource, "");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X$1Local.class"));
            IBinaryField[] fields = classFileReader.getFields();
            GenericTypeSignatureTest.assertNotNull((String)"No fields", (Object)fields);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)1, (int)fields.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "field", new String(fields[0].getName()));
            char[] signature = fields[0].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "LX<LX$Key;>.Holder;", new String(signature));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)4, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo1", new String(methods[1].getSelector()));
            signature = methods[1].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "()LX$1Local<Ljava/lang/String;>;", new String(signature));
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo2", new String(methods[2].getSelector()));
            signature = methods[2].getGenericSignature();
            GenericTypeSignatureTest.assertNotNull((String)"No signature", (Object)signature);
            GenericTypeSignatureTest.assertEquals("Wrong signature", "()LX$1Local<TU;>;", new String(signature));
            GenericTypeSignatureTest.assertEquals("Wrong name", "foo3", new String(methods[3].getSelector()));
            signature = methods[3].getGenericSignature();
            GenericTypeSignatureTest.assertNull((String)"No signature", (Object)signature);
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void test020() {
        String[] testsSource = new String[]{"X.java", "public interface X<E extends Object & X.Entry> {\n  interface Entry {\n    interface Internal extends Entry {\n      Internal createEntry();\n    }\n  }\n}\n"};
        this.runConformTest(testsSource, "");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X$Entry$Internal.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)1, (int)methods.length);
            GenericTypeSignatureTest.assertEquals("Wrong name", "createEntry", new String(methods[0].getSelector()));
            char[] signature = methods[0].getGenericSignature();
            GenericTypeSignatureTest.assertNull((String)"Unexpected signature", (Object)signature);
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void testBug460491() {
        String[] testsSource = new String[]{"C.java", "public class C<E> {\n  static class F { }\n  interface G { }\n  class H { }\n  void m1(F f) {}\n  void m2(G g) {}\n  void m3(H h) {}\n}\n"};
        this.runConformTest(testsSource, "");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "C.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)4, (int)methods.length);
            IBinaryMethod m1 = methods[1];
            GenericTypeSignatureTest.assertEquals("Wrong name", "m1", new String(m1.getSelector()));
            char[] signature = m1.getGenericSignature();
            GenericTypeSignatureTest.assertNull((String)"Unexpected signature", (Object)signature);
            IBinaryMethod m2 = methods[2];
            GenericTypeSignatureTest.assertEquals("Wrong name", "m2", new String(m2.getSelector()));
            signature = m2.getGenericSignature();
            GenericTypeSignatureTest.assertNull((String)"Unexpected signature", (Object)signature);
            IBinaryMethod m3 = methods[3];
            GenericTypeSignatureTest.assertEquals("Wrong name", "m3", new String(m3.getSelector()));
            signature = m3.getGenericSignature();
            GenericTypeSignatureTest.assertEquals("Wrong signature", "(LC<TE;>.H;)V", String.valueOf(signature));
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    public void testGenericVarargsMethodReferenceLambdasHaveNoSignature() {
        String[] testsSource = new String[]{"X.java", "import java.util.Optional;\nimport java.util.stream.Stream;\npublic interface X {\n  static void m1() {\n    Optional.<Stream<String>>empty().orElseGet(Stream::of);\n  }\n\n  static <T> Stream<T> m2() {\n    return Optional.<Stream<T>>empty().orElseGet(Stream::of);\n  }\n}\n"};
        this.runConformTest(testsSource, "");
        try {
            ClassFileReader classFileReader = ClassFileReader.read((String)(OUTPUT_DIR + File.separator + "X.class"));
            IBinaryMethod[] methods = classFileReader.getMethods();
            GenericTypeSignatureTest.assertNotNull((String)"No methods", (Object)methods);
            GenericTypeSignatureTest.assertEquals((String)"Wrong size", (int)4, (int)methods.length);
            IBinaryMethod m1 = methods[0];
            GenericTypeSignatureTest.assertEquals("Wrong name", "m1", new String(m1.getSelector()));
            GenericTypeSignatureTest.assertNull((String)"Unexpected signature, m1 itself is not generic", (Object)m1.getGenericSignature());
            IBinaryMethod m2 = methods[1];
            GenericTypeSignatureTest.assertEquals("Wrong name", "m2", new String(m2.getSelector()));
            String signature = String.valueOf(m2.getGenericSignature());
            GenericTypeSignatureTest.assertEquals("Unexpected signature, m2 itself is generic", "<T:Ljava/lang/Object;>()Ljava/util/stream/Stream<TT;>;", signature);
            IBinaryMethod m1Lambda = methods[2];
            GenericTypeSignatureTest.assertEquals("Wrong name", "lambda$2", new String(m1Lambda.getSelector()));
            GenericTypeSignatureTest.assertNull((String)"Wrong signature - non denotable should have been suppressed", (Object)m1Lambda.getGenericSignature());
            IBinaryMethod m2Lambda = methods[3];
            GenericTypeSignatureTest.assertEquals("Wrong name", "lambda$3", new String(m2Lambda.getSelector()));
            GenericTypeSignatureTest.assertNull((String)"Wrong signature - non denotable should have been suppressed", (Object)m2Lambda.getGenericSignature());
        }
        catch (ClassFormatException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            GenericTypeSignatureTest.assertTrue((boolean)false);
        }
    }

    static class Logger
    extends Thread {
        StringBuilder buffer;
        InputStream inputStream;
        String type;

        Logger(InputStream inputStream, String type) {
            this.inputStream = inputStream;
            this.type = type;
            this.buffer = new StringBuilder();
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.buffer.append(this.type).append("->").append(line);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

