/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;

public class GenericsRegressionTest_9
extends AbstractRegressionTest9 {
    public GenericsRegressionTest_9(String name) {
        super(name);
    }

    public static Test suite() {
        return GenericsRegressionTest_9.buildMinimalComplianceTestSuite(GenericsRegressionTest_9.testClass(), 64);
    }

    public void testBug488663_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Y<String> bar() {\n\t\tY<String> y = new Y<>() {\n\t\t\t@Override\n\t\t\tpublic void foo(String s) {\n\t\t\t\tthis.s = s;\n\t \t\t}\n\t\t};\n\t\treturn y;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new X().bar();\n\t\ty.foo(\"Done\");\n\t\ty.print();\n\t}\n}\nabstract class Y<T> {\n\tString s;\n\tpublic abstract void foo(String s);\n\tpublic void print() {\n\t\tSystem.out.println(this.s);\n\t}\n}\n"}, "Done");
    }

    public void testBug488663_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic Y<String> bar() {\n\t\tY<String> y = new Y<>() {\n\t\t\t@Override\n\t\t\tpublic void foo(T t) {\n\t\t\t\tthis.s = t;\n\t\t\t}\n\t\t};\n\t\treturn y;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new X().bar();\n\t\ty.foo(\"Done\");\n\t\ty.print();\n\t}\n}\nabstract class Y<T> {\n\tT s;\n\tpublic abstract void foo(T t);\n\tpublic void print() {\n\t\tSystem.out.println(this.s);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tY<String> y = new Y<>() {\n\t                  ^^^^^\nThe type new Y<String>(){} must implement the inherited abstract method Y<String>.foo(String)\n----------\n2. ERROR in X.java (at line 5)\n\tpublic void foo(T t) {\n\t                ^\nT cannot be resolved to a type\n----------\n");
    }

    public void testBug488663_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n@SuppressWarnings(\"unused\") \n\tpublic static void main(String[] args) {\n\t\tY<?> y1 = new Y<>(){};\n\t\tY<String> y2 = new Y<>(){};\n\t\tY<? extends String> y3 = new Y<>() {};\n\t\tY<? super String> y4 = new Y<>() {};\n\t}\n}\nclass Y<T> {}\n"}, "");
    }

    public void testBug488663_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n@SuppressWarnings(\"unused\") \n\tpublic static void main(String[] args) {\n\t\tY<?> y1 = new X().new Y<>(){};\n\t\tY<String> y2 = new X().new Y<>(){};\n\t\tY<? extends String> y3 = new X().new Y<>() {};\n\t\tY<? super String> y4 = new X().new Y<>() {};\n\t}\n\n\tclass Y<T> {}\n}\n"}, "");
    }

    public void testBug488663_005() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\ninterface J{}\nclass Y<T extends I & J> {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tY<?> y = new Y<>() {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tY<?> y = new Y<>() {};\n\t             ^\nType Y<I & J> inferred for Y<>, is not valid for an anonymous class with '<>'\n----------\n");
    }

    public void testBug488663_006() {
        this.runNegativeTest(new String[]{"X.java", "class Y<T> {\n   Y(T x) {}\n}\n\nclass X {\n  public static void main(String[] args) {\n\t  Y<? extends Integer> fi = null;\n\t  Y<?> f = new Y<>(fi){};\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tY<?> f = new Y<>(fi){};\n\t             ^\nType Y<Y<capture#1-of ? extends Integer>> inferred for Y<>, is not valid for an anonymous class with '<>'\n----------\n");
    }

    public void testBug488663_007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tI<X> i = new I<>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(i.toString(x));\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}"}, "Success");
    }

    public void testBug488663_008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tx.print(x, new I<>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}"}, "Success");
    }

    public void testBug488663_009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tx.print(x, new Z<>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}\nabstract class Z<T> implements I<T> {}\n"}, "Success");
    }

    public void testBug488663_010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<>(() -> System.out.println(\"Done\")) {\n\t\t};\n\t}\n}\ninterface J {\n\tvoid doSomething();\n}\nclass Y<T> {\n\tpublic Y(J j) {\n\t\tj.doSomething();\n\t}\n}"}, "Done");
    }

    public void testBug488663_011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<>(Y::foo) {\n\t\t};\n\t}\n}\ninterface J {\n\tvoid doSomething();\n}\nclass Y<T> {\n\tpublic Y(J j) {\n\t\tj.doSomething();\n\t}\n\tstatic void foo() {\n\t\tSystem.out.println(\"Done\");\n\t}\n}"}, "Done");
    }

    public void testBug488663_012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<>(\"Done\", new I<>() {\n\t\t\t\tpublic void doSomething(String s) {\n\t\t\t\t\tSystem.out.println(s);\n\t\t\t\t}\n\t\t\t}){\n\t\t};\n\t}\n}\ninterface I<T> {\n\tvoid doSomething(T t);\n}\nclass Y<T> {\n\tpublic Y(T t, I<T> i) {\n\t\ti.doSomething(t);\n\t}\n}"}, "Done");
    }

    public void testBug488663_013() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tI<X> i = new I<X>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(i.toString(x));\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tI<X> i = new I<X>() {\n\t             ^\nRedundant specification of type arguments <X>\n----------\n", null, true, options);
    }

    public void testBug488663_014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"asdasfd\");\n\t\tx.print(x, new Z<>() {\n\t\t\tpublic String toString(String s) {\n\t\t\t\treturn s;\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}\nclass Z<T> implements I<T> {\n\tpublic String toString(T t) {\n\t\treturn \"\";\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 15)\n\tpublic String toString(String s) {\n\t              ^^^^^^^^^^^^^^^^^^\nThe method toString(String) of type new Z<X>(){} must override or implement a supertype method\n----------\n");
    }

    public void testBug488663_015() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test<T> {\n\tprivate static class Inner {\t\tpublic Inner(){}\n\t}\n\t<R> void print(I<R> i) {}\n\tpublic Inner get() {\n\t\treturn new Inner();\n\t}\n}\n", "Z.java", "class Z<T> implements I<T> {\n\tpublic Z(T t1) {}\n\tpublic String toString (T t) {\n\t\treturn t.toString();\n\t}\n}", "X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tTest<String> t = new Test<>();\n\t\tt.print(new Z<>(t.get()) {\n\t\t\t\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tt.print(new Z<>(t.get()) {\n\t            ^^^^^^^^^^^^\nThe type Test$Inner is not visible\n----------\n");
    }

    public void testBug488663_016() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test<T> {\n\tprivate static class Inner {\t\tpublic Inner(){}\n\t}\n\t<R extends Inner> void print(I<R> i) {}\n\tpublic Inner get() {\n\t\treturn new Inner();\n\t}\n}\n", "X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tTest<String> t = new Test<>();\n\t\tt.print(new I<>() {\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"\";\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tt.print(new I<>() {\n\t            ^^^^^\nThe type Test$Inner is not visible\n----------\n");
    }

    public void testBug517926() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"asdasfd\");\n\t\tx.print(x, new I<>() {\n\t\t\tpublic String name() {return null;}\n\t\t\tpublic String toString(X xx) {\n\t\t\t\treturn xx.toString();\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\nprivate String name() {return null;}\tString toString(T t);\ndefault String getName() {return name();}}"}, "----------\n1. ERROR in X.java (at line 15)\n\tpublic String name() {return null;}\n\t              ^^^^^^\nThe method name() of type new I<X>(){} must override or implement a supertype method\n----------\n");
    }

    public void testBug521815a() {
        this.runNegativeTest(new String[]{"a/b/X.java", "package a.b;\ninterface I{\n    public static class Inner { }\n}\nclass Cl {\n    public static class Inner {}\n}\npublic class X extends Cl implements I {}\n", "a/Y.java", "package p;\nimport static a.b.X.Inner;\npublic class Y {;\n\tInner t;\n}\n"}, "----------\n1. ERROR in a\\Y.java (at line 4)\n\tInner t;\n\t^^^^^\nThe type Inner is ambiguous\n----------\n");
    }

    public void testBug521815b() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"a/b/X.java", "package a.b;\ninterface I{\n    public static class Inner { }\n}\nclass Cl {\n    public static class Inner {}\n}\npublic class X extends Cl implements I {}\n", "a/Y.java", "package p;\nimport static a.b.X.Inner;\npublic class Y {;\n}\n"}, "----------\n1. WARNING in a\\Y.java (at line 2)\n\timport static a.b.X.Inner;\n\t              ^^^^^^^^^^^\nThe import a.b.X.Inner is never used\n----------\n");
    }

    public void testBug533644() {
        this.runConformTest(new String[]{"q/JobDetail.java", "package q;\nimport java.io.Serializable;\npublic interface JobDetail extends Serializable, Cloneable { }\n", "q/Scheduler.java", "package q;\nimport java.util.Map;\nimport java.util.Set;\npublic interface Scheduler {\n    void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace) throws SchedulerException;\n}\n", "q/SchedulerException.java", "package q;\npublic class SchedulerException extends Exception {\n    private static final long serialVersionUID = 174841398690789156L;\n}\n", "q/Trigger.java", "package q;\nimport java.io.Serializable;\npublic interface Trigger extends Serializable, Cloneable, Comparable<Trigger> {\n    public static final long serialVersionUID = -3904243490805975570L;\n}\n"});
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"ForwardingScheduler.java", "import java.util.Map;\nimport java.util.Set;\n\nimport q.JobDetail;\nimport q.Scheduler;\nimport q.SchedulerException;\nimport q.Trigger;\n\npublic class ForwardingScheduler implements Scheduler {\n  @Override\n  public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace)\n      throws SchedulerException {\n  }\n}\n"};
        runner.runConformTest();
    }

    public void testBug551913_001() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint foo() {\n\t\tjava.util.HashSet<String> a = new java.util.HashSet<>();\n\t\tjava.util.HashSet<String> b = new java.util.HashSet<String>(a) {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t\tpublic int x() {return 10;}\n\t\t};\n\t\treturn 10;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tX abc= new X();\n\t\tSystem.out.println(abc.foo());\t}}"}, "10", options);
    }

    public void testBug551913_002() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tjava.util.HashSet<String> a = new java.util.HashSet<>();\n\t\tjava.util.HashSet<String> b = new java.util.HashSet<String>(a) {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t\tpublic String toString() {return null;}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tjava.util.HashSet<String> b = new java.util.HashSet<String>(a) {\n\t                                            ^^^^^^^\nRedundant specification of type arguments <String>\n----------\n", null, true, options);
    }

    public void testBug551913_003() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tjava.util.HashSet<String> a = new java.util.HashSet<>();\n\t\tjava.util.HashSet<String> b = new java.util.HashSet<String>(a) {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t\tpublic String toString() {return asString();}\n           private String asString() { return null;}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tjava.util.HashSet<String> b = new java.util.HashSet<String>(a) {\n\t                                            ^^^^^^^\nRedundant specification of type arguments <String>\n----------\n", null, true, options);
    }

    public void testBug551913_004() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tjava.util.HashSet<String> a = new java.util.HashSet<>();\n\t\tjava.util.HashSet<String> b = new java.util.HashSet<String>(a) {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t\tpublic String toString() {return asString();}\n           public String asString() { return null;}\n\t\t};\n\t}\n}"}, "", null, true, options);
    }

    public void testGH1506() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.util.Arrays;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic Iterable<File> getStackFramesClassesLocations(Object element) {\n\t\treturn new Iterable<File>() {\n\t\t\t@Override\n\t\t\tpublic Iterator<File> iterator() {\n\t\t\t\treturn Arrays.stream(new Object[0]) //\n\t\t\t\t\t\t.map(frame -> getClassesLocation(frame)) //\n\t\t\t\t\t\t.iterator();\n\t\t\t}\n\t\t\t\n\t\t\tFile getClassesLocation(Object frame) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t};\n\t}\n}\n"}, "", null, true, options);
    }

    public void testGH1506_2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.util.Arrays;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic Iterable<File> getStackFramesClassesLocations(Object element) {\n\t\treturn new Iterable<File>() {\n\t\t\t@Override\n\t\t\tpublic Iterator<File> iterator() {\n\t\t\t\treturn Arrays.stream(new Object[0]) //\n\t\t\t\t\t\t.map(frame -> getClassesLocation(frame)) //\n\t\t\t\t\t\t.iterator();\n\t\t\t}\n\t\t\t\n\t\t\tprivate File getClassesLocation(Object frame) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\treturn new Iterable<File>() {\n\t           ^^^^^^^^\nRedundant specification of type arguments <File>\n----------\n", null, true, options);
    }

    public void testGH1506_3() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n    static class AX<T>{}\n    X(E e) {}\n    X() {}\n    public static void main(String[] args) {\n    \tX<? extends AX> x5 = new X<AX<String>>(new AX<String>() { private void foo() {} });\n\t}\n} \n"}, "----------\n1. WARNING in X.java (at line 6)\n\tX<? extends AX> x5 = new X<AX<String>>(new AX<String>() { private void foo() {} });\n\t            ^^\nX.AX is a raw type. References to generic type X.AX<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tX<? extends AX> x5 = new X<AX<String>>(new AX<String>() { private void foo() {} });\n\t                                                                       ^^^^^\nThe method foo() from the type new X.AX<String>(){} is never used locally\n----------\n", null, true, options);
    }

    public void testGH1506_4() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n    static class AX<T>{}\n    X(E e) {}\n    X() {}\n    public static void main(String[] args) {\n    \tX<? extends AX> x5 = new X<AX<String>>(new AX<String>() { public void foo() {} });\n\t}\n} \n"}, "----------\n1. WARNING in X.java (at line 6)\n\tX<? extends AX> x5 = new X<AX<String>>(new AX<String>() { public void foo() {} });\n\t            ^^\nX.AX is a raw type. References to generic type X.AX<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tX<? extends AX> x5 = new X<AX<String>>(new AX<String>() { public void foo() {} });\n\t                                                                      ^^^^^\nThe method foo() from the type new X.AX<String>(){} is never used locally\n----------\n", null, true, options);
    }

    public void testGH1560() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.List;\n\npublic class X<S, D> {\n\n\tpublic interface MMenuElement {}\n\tpublic interface IObservable {}\n\tpublic static class ListDiffVisitor<E> {}\n\tpublic interface IObservablesListener {}\n\tpublic interface IObservableCollection<E> extends IObservable, Collection<E> {}\n\tpublic static class ObservableEvent {}\n\tpublic interface IDiff {}\n\tpublic static class ListDiff<E> implements IDiff {\n\t\tpublic void accept(ListDiffVisitor<? super E> visitor) {}\n\t}\n\tpublic static class ListChangeEvent<E> extends ObservableEvent {\n\t\tpublic ListDiff<E> diff;\n\t}\n\tpublic interface IListChangeListener<E> extends IObservablesListener {\n\t\tvoid handleListChange(ListChangeEvent<? extends E> event);\n\t}\n\tpublic interface IObservableList<E> extends List<E>, IObservableCollection<E> {\n\t\tvoid addListChangeListener(IListChangeListener<? super E> listener);\n\t}\n\n\tpublic void foo() {\n\n\t\tIObservableList<MMenuElement> l;\n\n\t\tl.addListChangeListener(event -> event.diff.accept(new ListDiffVisitor<MMenuElement>() {})); // <> should not be recommended here!!!\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 30)\n\tl.addListChangeListener(event -> event.diff.accept(new ListDiffVisitor<MMenuElement>() {})); // <> should not be recommended here!!!\n\t^\nThe local variable l may not have been initialized\n----------\n", null, true, options);
    }

    public void testGH1560_2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.List;\n\npublic class X<S, D> {\n\n\tpublic interface MMenuElement {}\n\tpublic interface IObservable {}\n\tpublic static class ListDiffVisitor<E> {}\n\tpublic interface IObservablesListener {}\n\tpublic interface IObservableCollection<E> extends IObservable, Collection<E> {}\n\tpublic static class ObservableEvent {}\n\tpublic interface IDiff {}\n\tpublic static class ListDiff<E> implements IDiff {\n\t\tpublic void accept(ListDiffVisitor<? super E> visitor) {}\n\t}\n\tpublic static class ListChangeEvent<E> extends ObservableEvent {\n\t\tpublic ListDiff<E> diff;\n\t}\n\tpublic interface IListChangeListener<E> extends IObservablesListener {\n\t\tvoid handleListChange(ListChangeEvent<? extends E> event);\n\t}\n\tpublic interface IObservableList<E> extends List<E>, IObservableCollection<E> {\n\t\tvoid addListChangeListener(IListChangeListener<? super E> listener);\n\t}\n\n\tpublic void foo() {\n\n\t\tIObservableList<MMenuElement> l;\n\n\t\tl.addListChangeListener(event -> event.diff.accept(new ListDiffVisitor<>() {})); // non-denotable type error\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 30)\n\tl.addListChangeListener(event -> event.diff.accept(new ListDiffVisitor<>() {})); // non-denotable type error\n\t                                                       ^^^^^^^^^^^^^^^\nType X.ListDiffVisitor<capture#1-of ? extends X.MMenuElement> inferred for ListDiffVisitor<>, is not valid for an anonymous class with '<>'\n----------\n", null, true, options);
    }

    public void testGH2817() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"Test.java", "class A<T> {}\nclass B<T> {}\n\npublic interface Test {\n    <T> void use(T t, B<? super T> b);\n    <T> B<A<? super T>> create();\n\n    default void test() {\n        use(new A<Object[]>(), create());\n    }\n}\n"};
        runner.runConformTest();
    }

    public void testGH3501() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"X.java", "import java.util.Collections;\npublic class X {\n\tvoid test() {\n\t\tZork v = Collections.singleton(\"1\");\n\t}\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in X.java (at line 4)\n\tZork v = Collections.singleton(\"1\");\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        runner.runNegativeTest();
    }

    public void testGH3457() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic void test() {\n\t\tthis.error(new TypeToken<A2<?>>() {});\n\t}\n\n\tpublic <T extends B1> void error(TypeToken<? extends A1<? extends T>> type) {}\n\tpublic static abstract class TypeToken<T> {}\n\tpublic static class A1<T extends B1> {}\n\tpublic static class A2<T extends B2> extends A1<T> {}\n\n\tpublic static class B1 {}\n\tpublic static class B2 extends B1 {}\n}\n"});
    }

    public void testGH3457b() {
        this.runConformTest(new String[]{"QueryUtil.java", "import java.util.ArrayList;\nimport java.util.Collection;\n\ninterface IQuery<T> { }\n\npublic class QueryUtil {\n\tpublic static <T> IQuery<T> createCompoundQuery(IQuery<? extends T> query1, IQuery<T> query2, boolean and) {\n\t\tArrayList<IQuery<? extends T>> queries = new ArrayList<>(2);\n\t\tqueries.add(query1);\n\t\tqueries.add(query2);\n\t\treturn createCompoundQuery(queries, and);\n\t}\n\tpublic static <T> IQuery<T> createCompoundQuery(Collection<? extends IQuery<? extends T>> queries, boolean and) {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testGH3457c() {
        this.runConformTest(new String[]{"QueryUtil.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\n\ninterface IQuery<T> extends List<T> { }\n\npublic class QueryUtil {\n\tpublic static <T> IQuery<T> createCompoundQuery(IQuery<? extends T> query1, IQuery<T> query2, boolean and) {\n\t\tArrayList<IQuery<? extends T>> queries = new ArrayList<>(2);\n\t\tqueries.add(query1);\n\t\tqueries.add(query2);\n\t\treturn createCompoundQuery(queries, and);\n\t}\n\tpublic static <T> IQuery<T> createCompoundQuery(Collection<? extends List<? extends T>> queries, boolean and) {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testGH3948() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.Collections;\nimport java.util.List;\nimport java.util.function.BiConsumer;\nimport java.util.function.Function;\n\npublic class Foo {\n    private List<? extends Bar> value;\n\n    public void set(List<? extends Bar> value) {\n        this.value = value;\n    }\n\n    public List<Bar> get() {\n        return Collections.unmodifiableList(value);\n    }\n\n    public static void main(String[] args) {\n        test(Foo::get, Foo::set);\n    }\n\n    public static <U> void test(Function<Foo, List<U>> getter, BiConsumer<Foo, List<? extends U>> setter) {\n        // noop\n    }\n\n    public static interface Bar{}\n}\n"});
    }

    public void testGH4022a() {
        this.runConformTest(new String[]{"Bug.java", "import java.util.Collection;\nimport java.util.Set;\n\npublic abstract class Bug {\n\t// real code uses some guava method, so method signature  cannot be changed\n\tpublic abstract <T2> Collection<T2> toCollection(Iterable<? extends T2> elements);\n\n\tpublic abstract <T> Set<Class<? extends T>> getSubTypesAsSet(Class<T> type);\n\n\tpublic <T> Collection<Class<? extends T>> getSubTypesAsCollection(Class<T> superclassOrInterface)    {\n\t\t// compiles on older eclipse and javac 21\n\t\t// fails since d9d550f8ddeda45cf4d1b803a99afbd73abf57e4\n\t\treturn toCollection(getSubTypesAsSet(superclassOrInterface));\n\t}\n\n\tpublic <T> Collection<Class<? extends T>> getSubTypesAsCollectionFixed(Class<T> superclassOrInterface) {\n\t\t// type as suggested by eclipse when using \"extract local variable\"\n\t\tSet<Class<? extends T>> subTypesAsSet = getSubTypesAsSet(superclassOrInterface);\n\n\t\t// compiles\n\t\treturn toCollection(subTypesAsSet);\n\t}\n}\n"});
    }

    public void testGH4022b() {
        this.runConformTest(new String[]{"OtherExample.java", "import java.util.Set;\nimport java.util.function.Function;\n\ninterface TaskDefinition {\n\tpublic Set<String> getLabels();\n}\n\nabstract class FluentIterable<E> implements Iterable<E> {\n\tpublic abstract <T> FluentIterable<T> transformAndConcat(\n\t\t\tFunction<? super E, ? extends Iterable<? extends T>> function);\n\n\tpublic abstract Set<E> toSet();\n}\n\npublic abstract class OtherExample {\n\tpublic Set<String> getAllLabels(FluentIterable<TaskDefinition> from) {\n                // doesn't compile since d9d550f8ddeda45cf4d1b803a99afbd73abf57e4\n\t\treturn from.transformAndConcat((TaskDefinition input) -> input.getLabels()).toSet();\n\t}\n}\n"});
    }

    public void testGH4033() {
        this.runConformTest(new String[]{"Snippet.java", "import java.util.Collection;\nimport java.util.Iterator;\n\npublic class Snippet {\n\tinterface Apple {}\n\tinterface Banana<T1, T2> {}\n\tinterface Smoothie<T extends Apple, M extends Apple> extends Banana<T, String> {}\n\n\tpublic static void main(String[] args) {\n\t\tCollection<Smoothie<? extends Apple, ? extends Apple>> c = null;\n\t\tmethod(c);\n\t}\n\n\tstatic final <S extends Banana<? extends T, ?>, T> Iterator<T> method(\n\t\t\tCollection<S> c) {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testGH4039() {
        this.runConformTest(new String[]{"CollectionsSortReproducer.java", "import java.util.Collection;\nimport java.util.Collections;\nimport java.util.Iterator;\nimport java.util.List;\n\npublic class CollectionsSortReproducer {\n\tclass Cranberry<T_Value> implements Comparable<Cranberry<T_Value>> {\n\t\t@Override\n\t\tpublic int compareTo(Cranberry<T_Value> o) { return 0; }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tList<Cranberry<?>> l = Collections.emptyList();\n\t    Collections.sort(l);\n\t}\n}\n"});
    }

    public void testGH4003() {
        if (this.complianceLevel < 0x360000L) {
            return;
        }
        this.runConformTest(new String[]{"EclipseCompilerBugReproducer.java", "import java.util.List;\nimport java.util.concurrent.CompletableFuture;\nimport java.util.concurrent.CompletionStage;\nimport java.util.function.Function;\nimport java.util.function.Supplier;\n\npublic class EclipseCompilerBugReproducer {\n\n    public static final class Mono<T> {\n\n        public static <T> Mono<T> fromFuture(CompletionStage<? extends T> stage) {\n            return new Mono<>();\n        }\n\n        public static <T> Mono<T> fromFuture(\n                Supplier<? extends CompletionStage<? extends T>> stageSupplier) {\n            return new Mono<>();\n        }\n\n        public <R> Mono<R> flatMap(Function<? super T, Mono<? extends R>> mapper) { return new Mono<>(); }\n        public <R> Mono<R> map(Function<? super T, ? extends R> mapper)          { return new Mono<>(); }\n        public List<T>      collectList()                                        { return List.of(); }\n        public T            block()                                              { return null; }\n    }\n\n    static final class Bucket {\n        CompletionStage<String> get(String id) {\n            return CompletableFuture.completedFuture(\"value-for-\" + id);\n        }\n    }\n\n    /* ---------------------------------------------------------------------- */\n    /*  Reproducer                                                            */\n    /* ---------------------------------------------------------------------- */\n    public static void main(String[] args) {\n\n        var ids    = List.of(\"a\", \"b\", \"c\");\n        var bucket = new Bucket();\n\n        ids.stream()\n           .flatMap(id ->\n               Mono.fromFuture(() -> bucket.get(id))   // <-- fails in Eclipse\n                   .map(String::toUpperCase)\n                   .collectList()\n                   .stream())\n           .forEach(System.out::println);\n    }\n}\n"});
    }

    public void testGH4098() {
        this.runConformTest(new String[]{"ClassA.java", "import java.util.Collections;\nimport java.util.HashSet;\nimport java.util.Set;\n\npublic class ClassA {\n  public static void main(String[] args) {\n    Set<? super Integer> set = new HashSet<>(Set.of(1, 5));\n    System.out.println(Collections.unmodifiableSet(set));\n  }\n}\n"});
    }

    public void testIssue3907() {
        this.runConformTest(new String[]{"LoadExtension.java", "public class LoadExtension extends AbstractLoad<Integer> {\n}\n", "TestIntegrationExtension.java", "public final class TestIntegrationExtension implements Extension {\n\n}\n\n@ExtendWith(TestIntegrationExtension.class)\n@interface TestIntegration {\n}\n\n@interface ExtendWith {\n\tClass<? extends Extension>[] value();\n}\n\ninterface Extension {\n}\n\n\n/**\n * @deprecated\n */\n@TestIntegration()\n@Deprecated\nabstract class AbstractLoad<T extends Number> {\n\n}\n"});
    }

    public void testIssue3907_since() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = new String[]{"LoadExtension.java", "public class LoadExtension extends AbstractLoad<Integer> {\n}\n", "TestIntegrationExtension.java", "public final class TestIntegrationExtension implements Extension {\n\n}\n\n@ExtendWith(TestIntegrationExtension.class)\n@interface TestIntegration {\n}\n\n@interface ExtendWith {\n\tClass<? extends Extension>[] value();\n}\n\ninterface Extension {\n}\n\n\n/**\n * @deprecated\n */\n@TestIntegration()\n@Deprecated(since=\"13\")\nabstract class AbstractLoad<T extends Number> {\n\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in LoadExtension.java (at line 1)\n\tpublic class LoadExtension extends AbstractLoad<Integer> {\n\t                                   ^^^^^^^^^^^^\nThe type AbstractLoad<Integer> is deprecated since version 13\n----------\n";
        runner.runWarningTest();
    }

    public void testGH4308() {
        this.runConformTest(new String[]{"ClassA.java", "import java.lang.reflect.InvocationTargetException;\nimport java.util.HashSet;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class ClassA {\n\n\tprivate static final Map<ClassB, Consumer<ClassC>> S;\n\n\tstatic {\n\t\tS = load(ClassB.class).stream().collect(Collectors.toMap(s -> s, // Compilation error\n\t\t\t\ts -> s.ping() ? s::sync : ClassD.getInstance()::replay));\n\t}\n\n\tprivate static <T> Set<T> load(Class<T> clazz) {\n\t\tSet<T> set = new HashSet<>();\n\t\ttry {\n\t\t\tset.add(clazz.getConstructor().newInstance());\n\t\t} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException | SecurityException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\treturn set;\n\t}\n\n\tprivate static class ClassB {\n\t\tpublic ClassB() {}\n\t\tboolean ping() {\n\t\t\treturn false;\n\t\t}\n\t\tvoid sync(ClassC classC) { }\n\t}\n\n\tprivate static class ClassD {\n\t\tprivate static ClassD getInstance() {\n\t\t\treturn new ClassD();\n\t\t}\n\t\tvoid replay(ClassC classC) {\n\t\t\tSystem.out.println(\"replay\");\n\t\t}\n\t}\n\n\tprivate static class ClassC { }\n\n\tpublic static void main(String[] args) {\n\t\tS.values().forEach(consumer -> consumer.accept(new ClassC()));\n\t}\n}\n"}, "replay");
    }

    public static Class<GenericsRegressionTest_9> testClass() {
        return GenericsRegressionTest_9.class;
    }
}

