/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;
import org.eclipse.jdt.core.tests.util.PreviewTest;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImplicitTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.junit.Test;

@PreviewTest
public class ImplicitlyDeclaredClassesTest
extends AbstractRegressionTest9 {
    public static boolean optimizeStringLiterals = false;
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("--enable-preview -source 24");
    private static final String[] VMARGS = new String[]{"--enable-preview"};

    public ImplicitlyDeclaredClassesTest(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        this.runJavacOptIn = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.runJavacOptIn = false;
    }

    public static Class<?> testClass() {
        return ImplicitlyDeclaredClassesTest.class;
    }

    public static junit.framework.Test suite() {
        return ImplicitlyDeclaredClassesTest.buildMinimalComplianceTestSuite(ImplicitlyDeclaredClassesTest.testClass(), 0x200000);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        return this.getCompilerOptions(true);
    }

    protected Map<String, String> getCompilerOptions(boolean previewFlag) {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "24");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", previewFlag ? "enabled" : "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        return defaultOptions;
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, null, VMARGS, new AbstractRegressionTest.JavacTestOptions("-source 24 --enable-preview"));
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        this.runConformTest(testFiles, expectedOutput, customOptions, VMARGS, JAVAC_OPTIONS);
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        Map<String, String> customOptions = this.getCompilerOptions(true);
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = null;
        runner.runNegativeTest();
    }

    private CompilationUnitDeclaration parse(String source, String testName) {
        this.complianceLevel = 0x440000L;
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        options.enablePreviewFeatures = true;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnit sourceUnit = new CompilationUnit(source.toCharArray(), testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        return parser.parse((ICompilationUnit)sourceUnit, compilationResult);
    }

    private ImplicitTypeDeclaration implicitTypeDeclaration(CompilationUnitDeclaration cu) {
        return cu == null || cu.types == null ? null : (ImplicitTypeDeclaration)Stream.of(cu.types).filter(ImplicitTypeDeclaration.class::isInstance).map(ImplicitTypeDeclaration.class::cast).findAny().orElse(null);
    }

    @Test
    public void testParseExplicitClass() {
        CompilationUnitDeclaration res = this.parse("import java.lang.*;\npublic class A {}", "A.java");
        ImplicitlyDeclaredClassesTest.assertFalse((boolean)res.compilationResult.hasErrors());
        ImplicitlyDeclaredClassesTest.assertNull((Object)this.implicitTypeDeclaration(res));
    }

    @Test
    public void testParseOnlyMain() {
        CompilationUnitDeclaration res = this.parse("void main() {}", "A.java");
        ImplicitlyDeclaredClassesTest.assertFalse((boolean)res.hasErrors());
        ImplicitTypeDeclaration implicitTypeDeclaration = this.implicitTypeDeclaration(res);
        ImplicitlyDeclaredClassesTest.assertNotNull((Object)implicitTypeDeclaration);
        ImplicitlyDeclaredClassesTest.assertTrue((boolean)Stream.of(implicitTypeDeclaration.methods).anyMatch(m -> {
            if (!(m instanceof MethodDeclaration)) return false;
            MethodDeclaration method = (MethodDeclaration)m;
            if (!"main".equals(new String(method.selector))) return false;
            return true;
        }));
    }

    @Test
    public void testParseMixedMethodAndTypes() {
        CompilationUnitDeclaration res = this.parse("void hello() {}\npublic class B {}\nvoid main() {}\n", "A.java");
        ImplicitlyDeclaredClassesTest.assertFalse((boolean)res.compilationResult.hasErrors());
        ImplicitlyDeclaredClassesTest.assertEquals((int)3, (int)this.implicitTypeDeclaration((CompilationUnitDeclaration)res).methods.length);
        ImplicitlyDeclaredClassesTest.assertEquals((int)1, (int)res.types[0].memberTypes.length);
    }

    @Test
    public void testImplicitType001() {
        this.runNegativeTest(new String[]{"X.java", "public static void main(String[] args) {\n\tX x = new X();\n}\nclass XYZ {\n\tX x = new X();\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tX x = new X();\n\t^\nX cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tX x = new X();\n\t          ^\nX cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tX x = new X();\n\t^\nX cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 5)\n\tX x = new X();\n\t          ^\nX cannot be resolved to a type\n----------\n");
    }

    @Test
    public void testImplicitType002() {
        this.runNegativeTest(new String[]{"X.java", "private static void main(String[] args) {\n}\nclass XYZ {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tprivate static void main(String[] args) {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n");
    }

    @Test
    public void testImplicitType003() {
        this.runNegativeTest(new String[]{"X.java", "public static void main(int[] args) {\n}\nclass XYZ {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic static void main(int[] args) {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n");
    }

    @Test
    public void testImplicitType004() {
        this.runNegativeTest(new String[]{"X.java", "public static void main(String args) {\n}\nclass XYZ {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic static void main(String args) {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n");
    }

    @Test
    public void testImplicitType005() {
        this.runNegativeTest(new String[]{"X.java", "public static void not_main(String ... args) {\n}\nclass XYZ {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic static void not_main(String ... args) {\n\t^\nImplicitly declared class must have a candidate main method\n----------\n");
    }

    @Test
    public void testImplicitType006() throws IOException, ClassFormatException {
        this.runConformTest(new String[]{"X.java", "public static void main() {\n\tSystem.out.println(\"Hello\");\n}"}, "Hello");
        this.verifyClassFile("version 24 : 68.65535", "X.class", 4);
    }

    @Test
    public void testImplicitType007() {
        this.runConformTest(new String[]{"X.java", "public static void main(String[] args) {\n\tSystem.out.println(\"Hello\");\n}"}, "Hello");
    }

    @Test
    public void testImplicitType008() {
        this.runConformTest(new String[]{"X.java", "public static void main(String ... args) {\n\tSystem.out.println(\"Hello\");\n}"}, "Hello");
    }

    @Test
    public void testImplicitType009() {
        this.runConformTest(new String[]{"X.java", "static String str = \"1\";\npublic static void main(String ... args) {\n\tSystem.out.println(str);\n}"}, "1");
    }

    @Test
    public void testImplicitType011() {
        this.runConformTest(new String[]{"X.java", "interface I { int i = 1; }\nstatic int i = 1;\npublic static void main(String ... args) {\n\tSystem.out.println(i == 1 && I.i == 1);\n}"}, "true");
    }

    @Test
    public void testImplicitImport() {
        this.runNegativeTest(new String[]{"b/B.java", "package b;\nimport java.util.Collection;\npublic class B {\n\tpublic static void print(Collection<?> col) {\n\t\tSystem.out.print(col.size());\n\t}\n\tZork zork;\n}\n", "X.java", "void main() {\n\tb.B.print(Collections.emptySet());\n}"}, "----------\n1. ERROR in b\\B.java (at line 7)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testGH3137a() {
        this.runConformTest(new String[]{"X.java", "public static void main(String[] args) {\n\tprintln(\"Hello1\");\n\tprintln(\"Hello2\");\n}"}, "Hello1\nHello2");
    }

    public void testGH3137b() {
        this.runConformTest(new String[]{"X.java", "public static void main(String[] args) {\n\tString str = readln(\"Enter:\");\n\tprintln(str);\n}\n"}, "Enter:", null, VMARGS, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testGH3714() {
        this.runConformTest(new String[]{"Main.java", "import static java.io.IO.*;\npublic class Main {\n\tpublic static void main(String[] args) {\n\t\tprintln(\"Hello\");\n\t}\n}"}, "Hello", null, VMARGS, AbstractRegressionTest.JavacTestOptions.SKIP);
    }
}

