/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class InMemoryNameEnvironment
implements INameEnvironment {
    INameEnvironment[] classLibs;
    HashtableOfObject compilationUnits = new HashtableOfObject();

    public InMemoryNameEnvironment(String[] compilationUnits, INameEnvironment[] classLibs) {
        this.classLibs = classLibs;
        int i = 0;
        int length = compilationUnits.length - 1;
        while (i < length) {
            String fileName = compilationUnits[i];
            char[] contents = compilationUnits[i + 1].toCharArray();
            String dirName = "";
            int lastSlash = -1;
            lastSlash = fileName.lastIndexOf(47);
            if (lastSlash != -1) {
                dirName = fileName.substring(0, lastSlash);
            }
            char[] packageName = dirName.replace('/', '.').toCharArray();
            char[] cuName = fileName.substring(lastSlash == -1 ? 0 : lastSlash + 1, fileName.length() - 5).toCharArray();
            HashtableOfObject cus = (HashtableOfObject)this.compilationUnits.get(packageName);
            if (cus == null) {
                cus = new HashtableOfObject();
                this.compilationUnits.put(packageName, (Object)cus);
            }
            CompilationUnit unit = new CompilationUnit(contents, fileName, null);
            cus.put(cuName, (Object)unit);
            i += 2;
        }
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        return this.findType(compoundTypeName[compoundTypeName.length - 1], CharOperation.subarray((char[][])compoundTypeName, (int)0, (int)(compoundTypeName.length - 1)));
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        HashtableOfObject cus = (HashtableOfObject)this.compilationUnits.get(CharOperation.concatWith((char[][])packageName, (char)'.'));
        if (cus == null) {
            return this.findTypeFromClassLibs(typeName, packageName);
        }
        CompilationUnit unit = (CompilationUnit)cus.get(typeName);
        if (unit == null) {
            return this.findTypeFromClassLibs(typeName, packageName);
        }
        return new NameEnvironmentAnswer((ICompilationUnit)unit, null);
    }

    private NameEnvironmentAnswer findTypeFromClassLibs(char[] typeName, char[][] packageName) {
        int i = 0;
        while (i < this.classLibs.length) {
            NameEnvironmentAnswer answer = this.classLibs[i].findType(typeName, packageName);
            if (answer != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        char[] pkg = CharOperation.concatWith((char[][])parentPackageName, (char[])packageName, (char)'.');
        return this.compilationUnits.get(pkg) != null || this.isPackageFromClassLibs(parentPackageName, packageName);
    }

    public boolean isPackageFromClassLibs(char[][] parentPackageName, char[] packageName) {
        int i = 0;
        while (i < this.classLibs.length) {
            if (this.classLibs[i].isPackage(parentPackageName, packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void cleanup() {
        int i = 0;
        int max = this.classLibs.length;
        while (i < max) {
            this.classLibs[i].cleanup();
            ++i;
        }
        this.compilationUnits = new HashtableOfObject();
    }
}

