/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class InMemoryNameEnvironment9
extends InMemoryNameEnvironment
implements IModuleAwareNameEnvironment {
    Map<String, IModule> moduleMap = new HashMap<String, IModule>();

    public InMemoryNameEnvironment9(String[] compilationUnits, Map<String, IModule> moduleMap, INameEnvironment[] classLibs) {
        super(compilationUnits, classLibs);
        this.moduleMap = moduleMap;
    }

    protected <T> T fromFirstClassLib(Function<IModuleAwareNameEnvironment, T> function) {
        int i = 0;
        while (i < this.classLibs.length) {
            T answer;
            INameEnvironment env = this.classLibs[i];
            if (env instanceof IModuleAwareNameEnvironment && (answer = function.apply((IModuleAwareNameEnvironment)env)) != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    protected <T> T[] collect(Function<IModuleAwareNameEnvironment, T[]> function, Function<Integer, T[]> arraySupplier) {
        HashSet<T> mods = new HashSet<T>();
        int i = 0;
        while (i < this.classLibs.length) {
            T[] someMods;
            INameEnvironment env = this.classLibs[i];
            if (env instanceof IModuleAwareNameEnvironment && (someMods = function.apply((IModuleAwareNameEnvironment)env)) != null) {
                mods.addAll(Arrays.asList(someMods));
            }
            ++i;
        }
        return mods.toArray(arraySupplier.apply(mods.size()));
    }

    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        return this.fromFirstClassLib(env -> env.findType(compoundName, moduleName));
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        return this.fromFirstClassLib(env -> env.findType(typeName, packageName, moduleName));
    }

    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        return (char[][])this.collect(env -> env.getModulesDeclaringPackage(packageName, moduleName), n -> new char[n][]);
    }

    public char[][] listPackages(char[] moduleName) {
        return (char[][])this.collect(env -> env.listPackages(moduleName), n -> new char[n][]);
    }

    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        return Boolean.TRUE.equals(this.fromFirstClassLib(env -> env.hasCompilationUnit(qualifiedPackageName, moduleName, checkCUs) ? Boolean.TRUE : null));
    }

    public IModule getModule(char[] moduleName) {
        IModule mod = this.moduleMap.get(String.valueOf(moduleName));
        if (mod != null) {
            return mod;
        }
        return this.fromFirstClassLib(env -> env.getModule(moduleName));
    }

    public char[][] getAllAutomaticModules() {
        return (char[][])this.collect(IModuleAwareNameEnvironment::getAllAutomaticModules, n -> new char[n][]);
    }
}

