/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class InstanceofPrimaryPatternTest
extends AbstractRegressionTest {
    private static final AbstractRegressionTest.JavacTestOptions JAVAC_OPTIONS = new AbstractRegressionTest.JavacTestOptions("-source 17");

    public static Class<?> testClass() {
        return InstanceofPrimaryPatternTest.class;
    }

    public static Test suite() {
        return InstanceofPrimaryPatternTest.buildMinimalComplianceTestSuite(InstanceofPrimaryPatternTest.testClass(), 16384);
    }

    public InstanceofPrimaryPatternTest(String testName) {
        super(testName);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String javacLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedCompilerLog = expectedCompilerLog;
        runner.javacTestOptions = JAVAC_OPTIONS;
        runner.customOptions = customOptions;
        runner.expectedJavacOutputString = javacLog;
        runner.runNegativeTest();
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof String s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"Hello World!\");\n\t}\n}\n"}, "Hello World!");
    }

    public void test002() {
        String expectedDiagnostics = this.complianceLevel < 0x400000L ? "----------\n1. ERROR in X.java (at line 3)\n\tif (obj instanceof (String s)) {\n\t                   ^\nSyntax error on token \"(\", delete this token\n----------\n2. ERROR in X.java (at line 3)\n\tif (obj instanceof (String s)) {\n\t                             ^\nSyntax error on token \")\", delete this token\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tif (obj instanceof (String s)) {\n\t        ^^^^^^^^^^\nSyntax error on token \"instanceof\", ReferenceType expected after this token\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof (String s)) {\n\t\t\tSystem.out.println(s);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"Hello World!\");\n\t}\n}\n"}, expectedDiagnostics);
    }

    public void test003() {
        String expectedDiagnostics = this.complianceLevel < 0x400000L ? "----------\n1. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t        ^^^^^^^^^^\nSyntax error, insert \"Type\" to complete InstanceofClassic\n----------\n2. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t        ^^^^^^^^^^\nSyntax error, insert \") Statement\" to complete BlockStatements\n----------\n3. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t                     ^^^^^^\nSyntax error on token \"String\", ( expected after this token\n----------\n4. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t                               ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Assignment\n----------\n5. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t                               ^\nSyntax error, insert \";\" to complete Statement\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t                   ^\nSyntax error on token \"(\", invalid ReferenceType\n----------\n2. ERROR in X.java (at line 3)\n\tif (obj instanceof ((String s))) {\n\t                               ^\nSyntax error on token \")\", delete this token\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof ((String s))) {\n\t\t\tSystem.out.println(s);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"Hello World!\");\n\t}\n}\n"}, expectedDiagnostics);
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void foo(Object obj) {\n\t\tif (obj instanceof var s) {\n\t\t\tSystem.out.println(s);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"Hello World!\");\n\t\tZork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (obj instanceof var s) {\n\t                   ^^^\n'var' is not allowed here\n----------\n2. ERROR in X.java (at line 9)\n\tZork();\n\t^^^^\nThe method Zork() is undefined for the type X\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void foo(String s) {\n\t\tif (s instanceof Object o) {\n\t\t\tSystem.out.println(s1);\n\t\t}\n \t}\n  public static void main(String[] obj) {\n\t\tfoo(\"Hello World!\");\n\t}\n}\n"}, this.complianceLevel < 0x410000L ? "----------\n1. ERROR in X.java (at line 3)\n\tif (s instanceof Object o) {\n\t    ^\nExpression type cannot be a subtype of the Pattern type\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println(s1);\n\t                   ^^\ns1 cannot be resolved to a variable\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.println(s1);\n\t                   ^^\ns1 cannot be resolved to a variable\n----------\n");
    }

    public void testGH1076() {
        this.runNegativeTest(new String[]{"X.java", "class Test {\n    void check() {\n        Number n = Integer.valueOf(1);\n        if (n instanceof final Integer) {}\n        if (n instanceof final Integer x) {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (n instanceof final Integer) {}\n\t                 ^^^^^^^^^^^^^\nSyntax error, modifiers are not allowed here\n----------\n");
    }

    public void testGH1621() {
        this.runConformTest(new String[]{"ConsumerEndpointSpec.java", "import java.util.function.Consumer;\n\npublic class ConsumerEndpointSpec {\n\tpublic void setNotPropagatedHeaders(String... headers) {\n\t\tfor (String s: headers) System.out.print(s);\n\t}\n\tvoid foo(Object h) {\n\t\tif (h instanceof ConsumerEndpointSpec producingMessageHandler) {\n\t\t\tacceptIfNotEmpty(new String[] {\"OK\"}, producingMessageHandler::setNotPropagatedHeaders);\n\t\t}\n\t}\n\tpublic <T> void acceptIfNotEmpty(T[] value, Consumer<T[]> consumer) {\n\t\tconsumer.accept(value);\n\t}\n\tpublic static void main(String... args) {\n\t\tConsumerEndpointSpec obj = new ConsumerEndpointSpec();\n\t\tobj.foo(obj);\n\t}\n}\n"}, "OK", this.getCompilerOptions());
    }

    public void test577415() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject obj = new Object();\n\t\tif (obj instanceof Integer r) {\n\t\t    System.out.println();\n\t\t} else if (obj instanceof Double c) {\n\t\t    System.out.println();\n\t\t} else {\n\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t}\n\n\t\tif (obj instanceof Integer r) {\n\t\t    System.out.println();\n\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t    System.out.println();\n\t\t}\n\t\tzork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tzork();\n\t^^^^\nThe method zork() is undefined for the type X\n----------\n");
    }

    public void test577415_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject obj = new Object();\n\t\tif (obj instanceof Double c) {\n\t\t    System.out.println();\n\t\t} else {\n\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t}\n\n\t\tif (obj instanceof Integer r) {\n\t\t    System.out.println();\n\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t    System.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void test577415_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif (args != null) {\n\t\t\tObject obj = new Object();\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) {\n\t\t\t    System.out.println();\n\t\t\t} else {\n\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t}\n\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t    System.out.println();\n\t\t\t}\n\t\t}\n\t\tzork();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tzork();\n\t^^^^\nThe method zork() is undefined for the type X\n----------\n");
    }

    public void test577415_3() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif (args != null) {\n\t\t\tObject obj = new Object();\n\t\t\tif (obj instanceof Double c) {\n\t\t\t    System.out.println();\n\t\t\t} else {\n\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t}\n\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t    System.out.println();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void test577415_4() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tObject obj = new Object();\n\t\t\tif (obj instanceof Double c) {\n\t\t\t    System.out.println();\n\t\t\t} else {\n\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t}\n\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t    System.out.println();\n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tObject obj = new Object();\n\t\t\tif (obj instanceof Double c) {\n\t\t\t    System.out.println();\n\t\t\t} else {\n\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t}\n\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t    System.out.println();\n\t\t\t}\n\t\t} finally {\n\t\t\tObject obj = new Object();\n\t\t\tif (obj instanceof Double c) {\n\t\t\t    System.out.println();\n\t\t\t} else {\n\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t}\n\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t    System.out.println();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n2. ERROR in X.java (at line 26)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n3. ERROR in X.java (at line 39)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void test577415_5() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tsynchronized(args) {\n\t\t\tObject obj = new Object();\n\t\t\tif (obj instanceof Double c) {\n\t\t\t    System.out.println();\n\t\t\t} else {\n\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t}\n\n\t\t\tif (obj instanceof Integer r) {\n\t\t\t    System.out.println();\n\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t    System.out.println();\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void test577415_6() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t    try {\n\t        gain(args);\n\t    } catch (IllegalArgumentException iae) {\n\t        if (iae.getMessage().equals(\"invalid type\"))\n\t            System.out.println(\"All well\");\n\t    }\n\t}\n\tpublic static void gain(String[] args) {\n\t\tObject obj = new Object();\n\t\tif (obj instanceof Integer r) {\n\t\t    System.out.println();\n\t\t} else if (obj instanceof Double c) {\n\t\t    System.out.println();\n\t\t} else {\n\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t}\n\n\t\tif (obj instanceof Integer r) {\n\t\t    System.out.println();\n\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t    System.out.println();\n\t\t}\n\t}\n}\n"}, "All well", this.getCompilerOptions());
    }

    public void test577415_7() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t    try {\n\t        gain(new String[] {\"Hello\"});\n\t    } catch (IllegalArgumentException iae) {\n\t        if (iae.getMessage().equals(\"invalid type\"))\n\t            System.out.println(\"All well\");\n\t    }\n\t}\n\tpublic static void gain(String[] args) {\n\t\tswitch(args[0]) {\n\t\t\tcase \"Hello\" :\n\t\t\t\tObject obj = new Object();\n\t\t\t\tif (obj instanceof Integer r) {\n\t\t\t\t    System.out.println();\n\t\t\t\t} else if (obj instanceof Double c) {\n\t\t\t\t    System.out.println();\n\t\t\t\t} else {\n\t\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t\t}\n\n\t\t\t\tif (obj instanceof Integer r) {\n\t\t\t\t    System.out.println();\n\t\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t\t    System.out.println();\n\t\t\t\t}\n\t\t}\n\t}\n}\n"}, "All well", this.getCompilerOptions());
    }

    public void test577415_8() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t    try {\n\t        gain(new String[] {\"Hello\"});\n\t    } catch (IllegalArgumentException iae) {\n\t        if (iae.getMessage().equals(\"invalid type\"))\n\t            System.out.println(\"All well\");\n\t    }\n\t}\n\tpublic static void gain(String[] args) {\n\t\tswitch(args[0]) {\n\t\t\tcase \"Hello\" :\n\t\t\t\tObject obj = new Object();\n\t\t\t\tif (obj instanceof Double c) {\n\t\t\t\t    System.out.println();\n\t\t\t\t} else {\n\t\t\t\t    throw new IllegalArgumentException(\"invalid type\"); // works OK without this line\n\t\t\t\t}\n\n\t\t\t\tif (obj instanceof Integer r) {\n\t\t\t\t    System.out.println();\n\t\t\t\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t\t\t\t    System.out.println();\n\t\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 22)\n\t} else if (obj instanceof Double c) { // Eclipse Compilation Error: Duplicate variable c\n\t                                 ^\nA pattern variable with the same name is already defined in the statement\n----------\n");
    }

    public void testGH3074() {
        this.runNegativeTest(new String[]{"Example.java", "class Example<T> {\n\tprivate void foo(String x) {\n\t\tif (x instanceof Example<String> es) {\n\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Example.java (at line 3)\n\tif (x instanceof Example<String> es) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types String and Example<String>\n----------\n");
    }

    public void testIssue3222() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tinterface I  {\n\t\tint foo();\n\t}\n\n\tstatic void foo(I i) {\n        System.out.println(i.foo());\n    }\n\n\tpublic static void main(String[] args) {\n\t\tfoo(args instanceof String [] argv ? () -> argv.length + 13  : () -> 42);\n\t}\n\n}\n"}, "13");
    }

    public void testIssue3222_2() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tinterface I  {\n\t\tint foo();\n\t}\n\n\tstatic void foo(I i) {\n        System.out.println(i.foo());\n    }\n\n\tpublic static void main(String[] args) {\n\t\tfoo(!(args instanceof String [] argv) ? () -> 42 : () -> argv.length + 13);\n\t}\n\n}\n"}, "13");
    }

    public void testIssue3222_3() {
        if (this.complianceLevel < 0x410000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\n\npublic class X {\n  interface I {\n    int foo(Supplier<Integer> arg);\n    default int foo(Object arg) {\n      return 13;\n    }\n  }\n  public X() {\n    super();\n  }\n  public static void main(String[] argv) {\n    int i = ((I) (x) -> {\n  return x.get();\n}).foo((argv instanceof String [] args ? () -> args.length + 42 : (Supplier<Integer>) null));\n    System.out.println(i);\n  }\n}\n"}, "42");
    }

    public void testIssue3897() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tvar o = new Object();\n\t\tif (o instanceof ListInteger<? extends Integer> list) {\n\t\t\tSystem.out.println(\"List\");\n\t\t}\n\t\tSystem.out.println(\"Not List\");\n\t}\n\n\tclass ListInteger<T extends Integer> extends ArrayList<T> {\n\n\t}\n}\n"}, "Not List");
    }

    public void testIssue3897_2() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\ninterface I {}\n\nclass A implements I {}\nclass B implements I {}\n\npublic class X {\n\n\tpublic void main(String[] args) {\n        ListInteger<? extends B> li = (ListInteger<? extends B>) new Object();\n        ListInteger<? extends A> li2 = (ListInteger<? extends A>) new Object();\n        ArrayList<String> as = (ArrayList<String>) new Object();\n        Zork z;\n\t}\n\n\tclass ListInteger<T extends I> extends ArrayList<T> {\n\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tListInteger<? extends B> li = (ListInteger<? extends B>) new Object();\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to X.ListInteger<? extends B>\n----------\n2. WARNING in X.java (at line 12)\n\tListInteger<? extends A> li2 = (ListInteger<? extends A>) new Object();\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to X.ListInteger<? extends A>\n----------\n3. WARNING in X.java (at line 13)\n\tArrayList<String> as = (ArrayList<String>) new Object();\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to ArrayList<String>\n----------\n4. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n5. WARNING in X.java (at line 17)\n\tclass ListInteger<T extends I> extends ArrayList<T> {\n\t      ^^^^^^^^^^^\nThe serializable class ListInteger does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void testIssue3897_3() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\nclass Base {}\n\nclass A extends Base {}\nclass B extends Base {}\n\npublic class X {\n\n\tpublic void main(String[] args) {\n        ListInteger<? extends B> li = (ListInteger<? extends B>) new Object();\n        ListInteger<? extends A> li2 = (ListInteger<? extends A>) new Object();\n        ArrayList<String> as = (ArrayList<String>) new Object();\n        Zork z;\n\t}\n\n\tclass ListInteger<T extends Base> extends ArrayList<T> {\n\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tListInteger<? extends B> li = (ListInteger<? extends B>) new Object();\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to X.ListInteger<? extends B>\n----------\n2. WARNING in X.java (at line 12)\n\tListInteger<? extends A> li2 = (ListInteger<? extends A>) new Object();\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to X.ListInteger<? extends A>\n----------\n3. WARNING in X.java (at line 13)\n\tArrayList<String> as = (ArrayList<String>) new Object();\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to ArrayList<String>\n----------\n4. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n5. WARNING in X.java (at line 17)\n\tclass ListInteger<T extends Base> extends ArrayList<T> {\n\t      ^^^^^^^^^^^\nThe serializable class ListInteger does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void testIssue3897_4() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\n\nclass A<T extends I> {\n    T i;\n}\n\npublic class X {\n    public static void main(String[] args) {\n        Object o = new A<>();\n\n        // 1. No warning in Javac; \"Unchecked cast\" warning in ECJ, even if the cast can never fail.\n        A<? extends I> a = (A<? extends I>) o;\n        // 2. No warning in either Javac or ECJ.\n        A<? extends I> b = (A<?>) o;\n\n        // 3. Works in Javac; error in ECJ.\n        if (o instanceof A<? extends I> c) {\n            I i = c.i;\n            System.out.println(i);\n        }\n\n        // 4. Works in both Javac and ECJ.\n        if (o instanceof A<?> c) {\n            // Type checks in ECJ and Javac. Both considers b.i to have type I.\n            I i = c.i;\n            System.out.println(i);\n        }\n\n        System.out.println(o);\n        System.out.println(a);\n        Zork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 31)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testIssue3897_5() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\nclass Test2 {\n\tpublic static void main(String[] args) {\n\t\tList<Integer> x = new ArrayList<Integer>();\n\t\tif (x instanceof ArrayList<Integer>) { // OK\n\t\t\tSystem.out.println(\"ArrayList of Integers\");\n\t\t}\n\t\tif (x instanceof ArrayList<String>) { // error\n\t\t\tSystem.out.println(\"ArrayList of Strings\");\n\t\t}\n\t\tif (x instanceof ArrayList<Object>) { // error\n\t\t\tSystem.out.println(\"ArrayList of Objects\");\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tif (x instanceof ArrayList<String>) { // error\n\t    ^\nType List<Integer> cannot be safely cast to ArrayList<String>\n----------\n2. ERROR in X.java (at line 13)\n\tif (x instanceof ArrayList<Object>) { // error\n\t    ^\nType List<Integer> cannot be safely cast to ArrayList<Object>\n----------\n");
    }
}

