/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;

public class InterfaceMethodsTest_9
extends AbstractComparableTest {
    public static Test suite() {
        return InterfaceMethodsTest_9.buildMinimalComplianceTestSuite(InterfaceMethodsTest_9.testClass(), 64);
    }

    public static Test setUpTest(Test test) throws Exception {
        TestCase.setUpTest(test);
        RegressionTestSetup suite = new RegressionTestSetup(0x350000L);
        suite.addTest(test);
        return suite;
    }

    public static Class testClass() {
        return InterfaceMethodsTest_9.class;
    }

    public InterfaceMethodsTest_9(String name) {
        super(name);
    }

    public void testBug488662_001() {
        this.runConformTest(new String[]{"I.java", "public interface I {\n@SuppressWarnings(\"unused\")\n    private void foo()  {}\n}\n"}, "");
    }

    public void testBug488662_002() {
        this.runConformTest(new String[]{"I.java", "public interface I {\n@SuppressWarnings(\"unused\")\n    private static void foo()  {}\n}\n"}, "");
    }

    public void testBug488662_003() {
        this.runConformTest(new String[]{"I.java", "public interface I {\n@SuppressWarnings(\"unused\")\n    private strictfp void foo()  {}\n}\n"}, "");
    }

    public void testBug488662_004() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n@SuppressWarnings(\"unused\")\n    private void foo();\n}\n"}, "----------\n1. ERROR in I.java (at line 3)\n\tprivate void foo();\n\t             ^^^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void testBug488662_005() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n@SuppressWarnings(\"unused\")\n    private default void foo();\n}\n"}, "----------\n1. ERROR in I.java (at line 3)\n\tprivate default void foo();\n\t                     ^^^^^\nIllegal combination of modifiers for the private interface method foo; additionally only one of static and strictfp is permitted\n----------\n2. ERROR in I.java (at line 3)\n\tprivate default void foo();\n\t                     ^^^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void testBug488662_006() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n\tprivate abstract void foo();\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tprivate abstract void foo();\n\t                      ^^^^^\nIllegal combination of modifiers for the private interface method foo; additionally only one of static and strictfp is permitted\n----------\n");
    }

    public void testBug488662_007() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    private synchronized void foo();\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tprivate synchronized void foo();\n\t                          ^^^^^\nIllegal modifier for the interface method foo; only public, private, abstract, default, static and strictfp are permitted\n----------\n2. ERROR in I.java (at line 2)\n\tprivate synchronized void foo();\n\t                          ^^^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void testBug488662_008() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tpublic default void foo() {}\n}\npublic class X implements I{\n@SuppressWarnings(\"unused\")\n@Override\n\tprivate void foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tprivate void foo() {}\n\t             ^^^^^\nCannot reduce the visibility of the inherited method from I\n----------\n");
    }

    public void testBug488662_009() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tprivate  void foo() {\n\t}\n\tpublic default void bar() {\n\t\tfoo();\n\t}\n}\npublic class X implements I{\n\tpublic static void main(String[] args) {\n\t\tnew X().bar();\n\t}\n}\n"}, "");
    }

    public void testBug488662_010() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    private public void foo(){}\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tprivate public void foo(){}\n\t                    ^^^^^\nIllegal combination of modifiers for the private interface method foo; additionally only one of static and strictfp is permitted\n----------\n");
    }

    public void testBug488662_011() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    private protected void foo();\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tprivate protected void foo();\n\t                       ^^^^^\nIllegal modifier for the interface method foo; only public, private, abstract, default, static and strictfp are permitted\n----------\n2. ERROR in I.java (at line 2)\n\tprivate protected void foo();\n\t                       ^^^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void testBug488662_012() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    private private public default protected void foo();\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tprivate private public default protected void foo();\n\t                                              ^^^^^\nDuplicate modifier for the method foo in type I\n----------\n2. ERROR in I.java (at line 2)\n\tprivate private public default protected void foo();\n\t                                              ^^^^^\nIllegal modifier for the interface method foo; only public, private, abstract, default, static and strictfp are permitted\n----------\n3. ERROR in I.java (at line 2)\n\tprivate private public default protected void foo();\n\t                                              ^^^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void testBug517926() {
        this.runNegativeTest(new String[]{"I.java", "public interface I<T> {\n   private String name(T t){return null;}\n\tdefault String getName() { return name(null);}\n}\n", "A.java", "public class A implements I<String> {\n\t@Override\n\tpublic String name(String s) {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in A.java (at line 3)\n\tpublic String name(String s) {\n\t              ^^^^^^^^^^^^^^\nThe method name(String) of type A must override or implement a supertype method\n----------\n");
    }

    public void testBug521743() {
        this.runConformTest(new String[]{"FI.java", "interface FI {\n    private <T> void foo(Class c){}\n}\ninterface FI2 extends FI {\n    default <T> void foo(Class<T> c) {}\n}"}, "");
    }

    public void testBug520795() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    private static void foo(){};\n\tdefault void bar() {\n\t\tfoo();\n\t}}\n", "X.java", "public class X {\npublic static void main(String[] args) {\n\tI.foo();\n}}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI.foo();\n\t  ^^^\nThe method foo() from the type I is not visible\n----------\n");
    }

    public void testBug520795a() {
        this.runConformTest(new String[]{"X.java", "public class X {\ninterface I {\n   private static void foo(){};\n\tdefault void bar() {\n\t\tfoo();\n\t}}\npublic static void main(String[] args) {\n\tI.foo();\n}}\n"});
    }

    public void testBug520795b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\npublic interface I {\n   private static void foo(){};\n\tvoid bar();}\npublic static void main(String[] args) {\n\tI i = () -> {};\n\ti.foo();\n}}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ti.foo();\n\t  ^^^\nThis static method of interface X.I can only be accessed as X.I.foo\n----------\n");
    }

    public void testBug520795c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\npublic interface I {\n   private static void foo(){};\n}\npublic interface J extends I {\n   default void goo(){I.super.foo();};\n\tvoid baz();}\npublic static void main(String[] args) {\n\tJ j = () -> {};\n\tj.goo();\n}}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tdefault void goo(){I.super.foo();};\n\t                           ^^^\nThis static method of interface X.I can only be accessed as X.I.foo\n----------\n");
    }

    public void testBug518272() {
        this.runConformTest(new String[]{"GeneratedAccessorBug.java", "public interface GeneratedAccessorBug {\n  void hello();\n  private static void foo() {}\n  public static void bar() {\n    new GeneratedAccessorBug() {\n      public void hello() {\n        foo();\n      }\n    }.hello();\n  }\n  public static void main(String[] args) {\n    GeneratedAccessorBug.bar();\n  }\n}"});
    }
}

