/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.util.FloatUtil;

public class InternalHexFloatTest
extends AbstractRegressionTest {
    public InternalHexFloatTest(String name) {
        super(name);
    }

    public static Test suite() {
        return InternalHexFloatTest.buildMinimalComplianceTestSuite(InternalHexFloatTest.testClass(), 32);
    }

    public static Class testClass() {
        return InternalHexFloatTest.class;
    }

    public void test001() {
        ArrayList<DoubleTest> x = new ArrayList<DoubleTest>();
        x.add(new DoubleTest("0x0p0", 0L));
        x.add(new DoubleTest("0x0p0d", 0L));
        x.add(new DoubleTest("0x0p0D", 0L));
        x.add(new DoubleTest("0x0.0p0D", 0L));
        x.add(new DoubleTest("0x.0p0D", 0L));
        x.add(new DoubleTest("0x0.p0D", 0L));
        x.add(new DoubleTest("0x00000.00000000000p0D", 0L));
        x.add(new DoubleTest("0x0p99D", 0L));
        x.add(new DoubleTest("0x0p-99D", 0L));
        x.add(new DoubleTest("0x0p9999999D", 0L));
        x.add(new DoubleTest("0x0p-9999999D", 0L));
        x.add(new DoubleTest("0x0.8p0D", 4602678819172646912L));
        x.add(new DoubleTest("0x0.4p0D", 4598175219545276416L));
        x.add(new DoubleTest("0x0.2p0D", 4593671619917905920L));
        x.add(new DoubleTest("0x0.1p0D", 4589168020290535424L));
        x.add(new DoubleTest("0x0.08p0D", 4584664420663164928L));
        x.add(new DoubleTest("0x0.04p0D", 4580160821035794432L));
        x.add(new DoubleTest("0x0.02p0D", 4575657221408423936L));
        x.add(new DoubleTest("0x0.01p0D", 4571153621781053440L));
        x.add(new DoubleTest("0x0.010p0D", 4571153621781053440L));
        x.add(new DoubleTest("0x1p0D", 0x3FF0000000000000L));
        x.add(new DoubleTest("0x2p0D", 0x4000000000000000L));
        x.add(new DoubleTest("0x4p0D", 0x4010000000000000L));
        x.add(new DoubleTest("0x8p0D", 0x4020000000000000L));
        x.add(new DoubleTest("0x10p0D", 0x4030000000000000L));
        x.add(new DoubleTest("0x20p0D", 0x4040000000000000L));
        x.add(new DoubleTest("0x40p0D", 0x4050000000000000L));
        x.add(new DoubleTest("0x80p0D", 0x4060000000000000L));
        x.add(new DoubleTest("0x80.p0D", 0x4060000000000000L));
        x.add(new DoubleTest("0x80.8p0D", 4638725208377655296L));
        x.add(new DoubleTest("0x80.80p0D", 4638725208377655296L));
        x.add(new DoubleTest("0x123456789p0D", 4751918102823829504L));
        x.add(new DoubleTest("0xabcedfp0D", 4712306570375987200L));
        x.add(new DoubleTest("0xABCDEFp0D", 4712306441526968320L));
        x.add(new DoubleTest("0x0.0100000000000000000000000000000000000000000000000p0d", 4571153621781053440L));
        x.add(new DoubleTest("0x0.0000000000000000000000000000000000000000000000001p0d", 0x33B0000000000000L));
        x.add(new DoubleTest("0x10000000000000000000000000000000000000000000000000000p0d", 5543931141293080576L));
        x.add(new DoubleTest("0x823456789012380p0d", 4872972358808371783L));
        x.add(new DoubleTest("0xFFFFFFFFFFFFF80p0d", 4877398396442247167L));
        x.add(new DoubleTest("0xFFFFFFFFFFFFFC0p0d", 4877398396442247168L));
        x.add(new DoubleTest("0xFFFFFFFFFFFFFA0p0d", 4877398396442247167L));
        x.add(new DoubleTest("0xFFFFFFFFFFFFF81p0d", 4877398396442247167L));
        x.add(new DoubleTest("0x123456789abcd10p0d", 4860004493881425105L));
        x.add(new DoubleTest("0x123456789abcd18p0d", 4860004493881425106L));
        x.add(new DoubleTest("0x7FFFFFFFFFFFFC0p0d", 4872894796814876671L));
        x.add(new DoubleTest("0x7FFFFFFFFFFFFE0p0d", 4872894796814876672L));
        x.add(new DoubleTest("0x3FFFFFFFFFFFFE0p0d", 4868391197187506175L));
        x.add(new DoubleTest("0x3FFFFFFFFFFFFF0p0d", 4868391197187506176L));
        x.add(new DoubleTest("0x1FFFFFFFFFFFFF0p0d", 4863887597560135679L));
        x.add(new DoubleTest("0x1FFFFFFFFFFFFF8p0d", 4863887597560135680L));
        x.add(new DoubleTest("0x1p5000D", 0x7FF0000000000000L));
        x.add(new DoubleTest("0x1p-5000D", 9221120237041090560L));
        x.add(new DoubleTest("0x1.0p1022d", 9209861237972664320L));
        x.add(new DoubleTest("0x1.0p1023d", 9214364837600034816L));
        x.add(new DoubleTest("0x1.0p1024d", 0x7FF0000000000000L));
        x.add(new DoubleTest("0x1.0p-1022d", 0x10000000000000L));
        x.add(new DoubleTest("0x1.0p-1023d", 0x8000000000000L));
        x.add(new DoubleTest("0x1.0p-1024d", 0x4000000000000L));
        x.add(new DoubleTest("0x1.0p-1074d", 1L));
        x.add(new DoubleTest("0x1.0p-1075d", 9221120237041090560L));
        x.add(new DoubleTest("0x1.0p-1076d", 9221120237041090560L));
        x.add(new DoubleTest("0x1.0p-1077d", 9221120237041090560L));
        x.add(new DoubleTest("0x1.0p-1078d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.8p1023d", 9209861237972664320L));
        x.add(new DoubleTest("0x0.8p1024d", 9214364837600034816L));
        x.add(new DoubleTest("0x0.8p1025d", 0x7FF0000000000000L));
        x.add(new DoubleTest("0x0.8p-1021d", 0x10000000000000L));
        x.add(new DoubleTest("0x0.8p-1022d", 0x8000000000000L));
        x.add(new DoubleTest("0x0.8p-1023d", 0x4000000000000L));
        x.add(new DoubleTest("0x0.8p-1024d", 0x2000000000000L));
        x.add(new DoubleTest("0x0.8p-1074d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.8p-1075d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.8p-1076d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.4p-1021d", 0x8000000000000L));
        x.add(new DoubleTest("0x0.4p-1022d", 0x4000000000000L));
        x.add(new DoubleTest("0x0.4p-1023d", 0x2000000000000L));
        x.add(new DoubleTest("0x0.4p-1073d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.4p-1074d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.4p-1075d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.2p-1020d", 0x8000000000000L));
        x.add(new DoubleTest("0x0.2p-1021d", 0x4000000000000L));
        x.add(new DoubleTest("0x0.2p-1022d", 0x2000000000000L));
        x.add(new DoubleTest("0x0.2p-1072d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.2p-1073d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.2p-1074d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.1p-1019d", 0x8000000000000L));
        x.add(new DoubleTest("0x0.1p-1020d", 0x4000000000000L));
        x.add(new DoubleTest("0x0.1p-1021d", 0x2000000000000L));
        x.add(new DoubleTest("0x0.1p-1071d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.1p-1072d", 9221120237041090560L));
        x.add(new DoubleTest("0x0.1p-1073d", 9221120237041090560L));
        for (DoubleTest t : x) {
            long libExpectedBits;
            boolean isJ2SE5;
            String s = t.input;
            long expectedBits = t.output;
            double libExpected = 0.0;
            try {
                libExpected = Double.parseDouble(s);
                isJ2SE5 = true;
            }
            catch (NumberFormatException e) {
                isJ2SE5 = false;
            }
            double dActual = FloatUtil.valueOfHexDoubleLiteral((char[])s.toCharArray());
            long actualBits = Double.doubleToLongBits(dActual);
            if (isJ2SE5 && expectedBits != (libExpectedBits = Double.doubleToRawLongBits(libExpected)) && (!Double.isNaN(Double.longBitsToDouble(expectedBits)) || libExpected != 0.0)) {
                InternalHexFloatTest.assertEquals((String)("Test has wrong table value for " + s), (long)libExpectedBits, (long)expectedBits);
            }
            InternalHexFloatTest.assertEquals((String)("Wrong double value for " + s), (long)expectedBits, (long)actualBits);
        }
    }

    public void test002() {
        ArrayList<FloatTest> x = new ArrayList<FloatTest>();
        x.add(new FloatTest("0x0p0f", 0));
        x.add(new FloatTest("0x0p0F", 0));
        x.add(new FloatTest("0x0.0p0F", 0));
        x.add(new FloatTest("0x.0p0F", 0));
        x.add(new FloatTest("0x0.p0F", 0));
        x.add(new FloatTest("0x00000.00000000000p0F", 0));
        x.add(new FloatTest("0x0p99F", 0));
        x.add(new FloatTest("0x0p-99F", 0));
        x.add(new FloatTest("0x0p9999999F", 0));
        x.add(new FloatTest("0x0p-9999999F", 0));
        x.add(new FloatTest("0x0.8p0F", 0x3F000000));
        x.add(new FloatTest("0x0.4p0F", 1048576000));
        x.add(new FloatTest("0x0.2p0F", 0x3E000000));
        x.add(new FloatTest("0x0.1p0F", 1031798784));
        x.add(new FloatTest("0x0.08p0F", 0x3D000000));
        x.add(new FloatTest("0x0.04p0F", 1015021568));
        x.add(new FloatTest("0x0.02p0F", 0x3C000000));
        x.add(new FloatTest("0x0.01p0F", 998244352));
        x.add(new FloatTest("0x0.010p0F", 998244352));
        x.add(new FloatTest("0x1p0F", 1065353216));
        x.add(new FloatTest("0x2p0F", 0x40000000));
        x.add(new FloatTest("0x4p0F", 0x40800000));
        x.add(new FloatTest("0x8p0F", 0x41000000));
        x.add(new FloatTest("0x10p0F", 1098907648));
        x.add(new FloatTest("0x20p0F", 0x42000000));
        x.add(new FloatTest("0x40p0F", 1115684864));
        x.add(new FloatTest("0x80p0F", 0x43000000));
        x.add(new FloatTest("0x80.p0F", 0x43000000));
        x.add(new FloatTest("0x80.8p0F", 1124106240));
        x.add(new FloatTest("0x80.80p0F", 1124106240));
        x.add(new FloatTest("0x123456789p0F", 1334944436));
        x.add(new FloatTest("0xabcedfp0F", 1261162207));
        x.add(new FloatTest("0xABCDEFp0F", 1261161967));
        x.add(new FloatTest("0x0.000000000000000000000000000001p0f", 0x3800000));
        x.add(new FloatTest("0x10000000000000000000000000000000p0f", 2105540608));
        x.add(new FloatTest("0x823456p0f", 1258435670));
        x.add(new FloatTest("0xFFFFFF80p0f", 1333788672));
        x.add(new FloatTest("0xFFFFFF40p0f", 0x4F7FFFFF));
        x.add(new FloatTest("0xFFFFFF20p0f", 0x4F7FFFFF));
        x.add(new FloatTest("0x123456p0f", 1234281136));
        x.add(new FloatTest("0x7890abp0f", 1257316694));
        x.add(new FloatTest("0xcdefABp0f", 1263398827));
        x.add(new FloatTest("0xCDEFdep0f", 1263398878));
        x.add(new FloatTest("0x123456p0f", 1234281136));
        x.add(new FloatTest("0x7FFFFF8p0f", 0x4CFFFFFF));
        x.add(new FloatTest("0x3FFFFFCp0f", 1283457023));
        x.add(new FloatTest("0x1FFFFFEp0f", 0x4BFFFFFF));
        x.add(new FloatTest("0x1p5000F", 2139095040));
        x.add(new FloatTest("0x1p-5000F", 2143289344));
        x.add(new FloatTest("0x1.0p126f", 2122317824));
        x.add(new FloatTest("0x1.0p127f", 0x7F000000));
        x.add(new FloatTest("0x1.0p128f", 2139095040));
        x.add(new FloatTest("0x1.0p129f", 2139095040));
        x.add(new FloatTest("0x1.0p-127f", 0x400000));
        x.add(new FloatTest("0x1.0p-128f", 0x200000));
        x.add(new FloatTest("0x1.0p-129f", 0x100000));
        x.add(new FloatTest("0x1.0p-149f", 1));
        x.add(new FloatTest("0x1.0p-150f", 2143289344));
        x.add(new FloatTest("0x1.0p-151f", 2143289344));
        x.add(new FloatTest("0x0.8p127f", 2122317824));
        x.add(new FloatTest("0x0.8p128f", 0x7F000000));
        x.add(new FloatTest("0x0.8p129f", 2139095040));
        x.add(new FloatTest("0x0.8p-125f", 0x800000));
        x.add(new FloatTest("0x0.8p-126f", 0x400000));
        x.add(new FloatTest("0x0.8p-127f", 0x200000));
        x.add(new FloatTest("0x0.8p-128f", 0x100000));
        x.add(new FloatTest("0x0.8p-148f", 1));
        x.add(new FloatTest("0x0.8p-149f", 2143289344));
        x.add(new FloatTest("0x0.8p-150f", 2143289344));
        x.add(new FloatTest("0x0.4p-124f", 0x800000));
        x.add(new FloatTest("0x0.4p-125f", 0x400000));
        x.add(new FloatTest("0x0.4p-126f", 0x200000));
        x.add(new FloatTest("0x0.4p-147f", 1));
        x.add(new FloatTest("0x0.4p-148f", 2143289344));
        x.add(new FloatTest("0x0.4p-149f", 2143289344));
        x.add(new FloatTest("0x0.4p-150f", 2143289344));
        x.add(new FloatTest("0x0.2p-123f", 0x800000));
        x.add(new FloatTest("0x0.2p-124f", 0x400000));
        x.add(new FloatTest("0x0.2p-125f", 0x200000));
        x.add(new FloatTest("0x0.2p-126f", 0x100000));
        x.add(new FloatTest("0x0.2p-146f", 1));
        x.add(new FloatTest("0x0.2p-147f", 2143289344));
        x.add(new FloatTest("0x0.2p-148f", 2143289344));
        x.add(new FloatTest("0x0.2p-149f", 2143289344));
        x.add(new FloatTest("0x0.1p-122f", 0x800000));
        x.add(new FloatTest("0x0.1p-123f", 0x400000));
        x.add(new FloatTest("0x0.1p-124f", 0x200000));
        x.add(new FloatTest("0x0.1p-145f", 1));
        x.add(new FloatTest("0x0.1p-146f", 2143289344));
        x.add(new FloatTest("0x0.1p-147f", 2143289344));
        x.add(new FloatTest("0x0.1p-148f", 2143289344));
        for (FloatTest t : x) {
            int libExpectedBits;
            boolean isJ2SE5;
            String s = t.input;
            int expectedBits = t.output;
            float libExpected = 0.0f;
            try {
                libExpected = Float.parseFloat(s);
                isJ2SE5 = true;
            }
            catch (NumberFormatException e) {
                isJ2SE5 = false;
            }
            float dActual = FloatUtil.valueOfHexFloatLiteral((char[])s.toCharArray());
            long actualBits = Float.floatToIntBits(dActual);
            if (isJ2SE5 && expectedBits != (libExpectedBits = Float.floatToRawIntBits(libExpected)) && (!Float.isNaN(Float.intBitsToFloat(expectedBits)) || libExpected != 0.0f)) {
                InternalHexFloatTest.assertEquals((String)("Test has wrong table value for " + s), (int)libExpectedBits, (int)expectedBits);
            }
            InternalHexFloatTest.assertEquals((String)("Wrong float value for " + s), (long)expectedBits, (long)actualBits);
        }
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\n        System.out.println(-0Xf.aP1F);\n    }\n}"}, "-31.25");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\n        System.out.println(0X000.0000P5000);\n    }\n}"}, "0.0");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\n        System.out.println(-0X000.0000P5000F);\n    }\n}"}, "-0.0");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\n        System.out.println(0X000.eP-5000F);\n    }\n}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tSystem.out.println(0X000.eP-5000F);\r\n\t                   ^^^^^^^^^^^^^^\nThe literal 0X000.eP-5000F of type float is out of range \n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\n        System.out.println(0X000.eP5000F);\n    }\n}"}, "----------\n1. ERROR in X.java (at line 3)\r\n\tSystem.out.println(0X000.eP5000F);\r\n\t                   ^^^^^^^^^^^^^\nThe literal 0X000.eP5000F of type float is out of range \n----------\n");
    }

    static class DoubleTest {
        String input;
        long output;

        public DoubleTest(String input, long output) {
            this.input = input;
            this.output = output;
        }
    }

    static class FloatTest {
        String input;
        int output;

        public FloatTest(String input, int output) {
            this.input = input;
            this.output = output;
        }
    }
}

