/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;

public class InternalScannerTest
extends AbstractRegressionTest {
    public InternalScannerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return InternalScannerTest.buildAllCompliancesTestSuite(InternalScannerTest.testClass());
    }

    public static Class testClass() {
        return InternalScannerTest.class;
    }

    public void test001() {
        String source = "//Comment";
        Scanner scanner = new Scanner();
        scanner.setSource(source.toCharArray());
        TerminalToken token = TerminalToken.TokenNameNotAToken;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        InternalScannerTest.assertEquals((String)"Wrong token type", (Object)TerminalToken.TokenNameEOF, (Object)token);
        InternalScannerTest.assertEquals((String)"Wrong comment start", (int)0, (int)scanner.commentStarts[0]);
        InternalScannerTest.assertEquals((String)"Wrong comment start", (int)-9, (int)scanner.commentStops[0]);
    }

    public void test002() throws InvalidInputException {
        Scanner scanner = new Scanner();
        scanner.recordLineSeparator = true;
        scanner.setSource("a\nb\nc\n".toCharArray());
        TerminalToken token = TerminalToken.TokenNameNotAToken;
        while (token != TerminalToken.TokenNameEOF) {
            token = scanner.getNextToken();
        }
        scanner.setSource("a\nb\n".toCharArray());
        token = TerminalToken.TokenNameNotAToken;
        while (token != TerminalToken.TokenNameEOF) {
            token = scanner.getNextToken();
        }
        InternalScannerTest.assertEquals((String)"Wrong number of line ends", (int)2, (int)scanner.getLineEnds().length);
    }
}

