/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JEP181NestTest
extends AbstractComparableTest {
    String versionString = null;
    private static final String[] source_classic = JEP181NestTest.getTestSeriesClassic();

    public JEP181NestTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.versionString = AbstractCompilerTest.getVersionString(this.complianceLevel);
    }

    public static Test suite() {
        return JEP181NestTest.buildMinimalComplianceTestSuite(JEP181NestTest.testClass(), 256);
    }

    private static String[] getTestSeriesClassic() {
        return new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic class Y {\n\t\tclass Z {}\n\t}\n\tpublic static class A {\n\t\tpublic static class B {}\n\t\tpublic class C {}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic void foo() {\n\t\tSystem.out.println(\"foo\");\n\t}\n}\n"};
    }

    private String getClassFileContents(String classFileName, int mode) throws IOException, ClassFormatException {
        File f = new File(OUTPUT_DIR + File.separator + classFileName);
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", mode);
        return result;
    }

    private void verifyOutputPositive(String result, String expectedOutput) {
        this.verifyOutput(result, expectedOutput, true);
    }

    private void verifyOutputNegative(String result, String expectedOutput) {
        this.verifyOutput(result, expectedOutput, false);
    }

    private void verifyOutput(String result, String expectedOutput, boolean positive) {
        int index = result.indexOf(expectedOutput);
        if (positive) {
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
                System.out.println("...");
            }
            if (index == -1) {
                JEP181NestTest.assertEquals("Wrong contents", expectedOutput, result);
            }
        } else if (index != -1) {
            JEP181NestTest.assertEquals("Unexpected contents", "", result);
        }
    }

    public void testBug535851_001() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        this.runConformTest(source_classic, "SUCCESS", options);
        String expectedPartialOutput = "Nest Members:\n   #37 pack1/X$A,\n   #44 pack1/X$A$B,\n   #46 pack1/X$A$C,\n   #40 pack1/X$Y,\n   #48 pack1/X$Y$Z\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
    }

    public void testBug535851_002() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        this.runConformTest(source_classic, "SUCCESS", options);
        String expectedPartialOutput = "Nest Host: #17 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$A.class", 4);
    }

    public void testBug535851_003() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        this.runConformTest(source_classic, "SUCCESS", options);
        String unExpectedPartialOutput = "NestMembers:";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X$A.class", 4);
    }

    public void testBug535851_004() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        this.runConformTest(source_classic, "SUCCESS", options);
        String expectedPartialOutput = "Nest Host: #24 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$Y$Z.class", 4);
    }

    public void testBug535851_005() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        String[] files = new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic void foo() {\n\t\tY y = new Y() {\n\t\t    void bar() {}\n\t\t};\n       System.out.println(y.toString());\n\t}\n}\nabstract class Y {\n\tabstract void bar();\n}\n"};
        this.runConformTest(files, "SUCCESS", options);
        String expectedPartialOutput = "Nest Members:\n   #33 pack1/X$1\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        expectedPartialOutput = "Nest Host: #23 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$1.class", 4);
        this.verifyNegativeClassFile(expectedPartialOutput, "pack1/Y.class", 4);
    }

    public void testBug535851_006() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        String[] files = new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic void foo() {\n\t\tY y = new Y() {\n\t\t    void bar() {\n\t\t        Y y1 = new Y() {\n\t\t           void bar() {}\n\t\t        };\n               System.out.println(y1.toString());\n\t        }\n\t\t};\n       System.out.println(y.toString());\n\t}\n}\nabstract class Y {\n\tabstract void bar();\n}\n"};
        this.runConformTest(files, "SUCCESS", options);
        String expectedPartialOutput = "Nest Members:\n   #33 pack1/X$1,\n   #48 pack1/X$1$1\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        expectedPartialOutput = "Nest Host: #48 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$1.class", 4);
        expectedPartialOutput = "Nest Host: #28 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$1$1.class", 4);
        this.verifyNegativeClassFile(expectedPartialOutput, "pack1/Y.class", 4);
    }

    public void testBug535851_007() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        String[] files = new String[]{"pack1/X.java", "package pack1;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic void foo() {\n\t\tI i = ()->{\n\t\t\tY y = new Y() {\t\n\t\t\t\t@Override\n\t\t\t\tvoid bar() {\n\t\t\t\t\tY y1 = new Y() {\n\t\t\t\t\t\t@Override\n\t\t\t\t\t\tvoid bar() {}\n\t\t\t\t\t};\n\t\t\t\t\tSystem.out.println(y1);\n\t\t\t\t}\n\t\t\t};\n\t\t\tSystem.out.println(y.toString());\n\t\t};\n\t\ti.apply();\n\t}\n}\ninterface I {\n\tvoid apply();\n}\nabstract class Y {\n\tabstract void bar();\n}\n"};
        this.runConformTest(files, "SUCCESS", options);
        String expectedPartialOutput = "Nest Members:\n   #44 pack1/X$1,\n   #77 pack1/X$1$1\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        expectedPartialOutput = "Nest Host: #42 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$1.class", 4);
        expectedPartialOutput = "Nest Host: #28 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$1$1.class", 4);
        this.verifyNegativeClassFile(expectedPartialOutput, "pack1/Y.class", 4);
    }

    public void testBug535851_008() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        String[] files = new String[]{"pack1/X.java", "package pack1;\n\npublic class X {\n   public void foo() {\n       class Y {\n           // nothing\n       }\n       Y y = new Y();\n       System.out.println(\"SUCCESS\");\n   }\n   public static void main(String[] args) {\n       new X().foo();\n   }\n}\n"};
        this.runConformTest(files, "SUCCESS", options);
        String expectedPartialOutput = "Nest Members:\n   #15 pack1/X$1Y\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        expectedPartialOutput = "Nest Host: #22 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$1Y.class", 4);
    }

    public void testBug535918_001a() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_int = 100;\n\t\tpublic int pub_int = 200;\n\t\t\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = foo();\n\t\tSystem.out.println(\"SUCCESS:\" + sum);\n\t}\n\tpublic static int foo() {\n\t\tY y = new Y();\n\t\tint i = y.priv_int;\n\t\tint j = y.pub_int;\n\t\treturn i + j;\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n"}, "SUCCESS:300", options);
        String expectedPartialOutput = "getfield pack1.X$Y.priv_in";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        String unExpectedPartialOutput = "access$";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X$Y.class", 4);
    }

    public void testBug535918_001b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate static int priv_int = 100;\n\t\tpublic int pub_int = 200;\n\t\t\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = foo();\n\t\tSystem.out.println(\"SUCCESS:\" + sum);\n\t}\n\tpublic static int foo() {\n\t\tY y = new Y();\n\t\tint i = y.priv_int;\n\t\tint j = y.pub_int;\n\t\treturn i + j;\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n"}, "SUCCESS:300", options);
        String expectedPartialOutput = "getstatic pack1.X$Y.priv_int";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        expectedPartialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #50 pack1/X$Y\n" : "Nest Members:\n   #40 pack1/X$Y\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
        expectedPartialOutput = "Nest Host: #25 pack1/X\n";
        this.verifyClassFile(expectedPartialOutput, "pack1/X$Y.class", 4);
        String unExpectedPartialOutput = "invokestatic pack1.X$Y.access$";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X.class", 4);
        unExpectedPartialOutput = "access$";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X$Y.class", 4);
    }

    public void testBug535918_001c() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_int = 100;\n\t\tpublic int pub_int = 200;\n\t\t\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = foo();\n\t\tSystem.out.println(\"SUCCESS:\" + sum);\n\t}\n\tpublic static int foo() {\n\t\tY y = new Y();\n\t\tint i = y.priv_int;\n\t\tint j = y.pub_int;\n\t\treturn i + j;\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n"}, "SUCCESS:300", options);
        String unExpectedPartialOutput = "access$";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X$Y.class", 4);
    }

    public void testBug535918_002() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tprivate int priv_non_static_method() {\n\t\treturn 100;\n\t}\n\tpublic int pub_non_static_method() {\n\t\treturn priv_non_static_method();\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tint result =x.pub_non_static_method();\n\t\tSystem.out.println(result);\n\t}\n}\n"}, "100", options);
        String expectedPartialOutput = "invokevirtual pack1.X.priv_non_static_method()";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
    }

    public void testBug535918_003a() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate static int priv_int = 100;\n\t}\n\tpublic static class Z {\n\t\tpublic static int foo() {\n\t\t\tint i = Y.priv_int;\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = Z.foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #55 pack1/X$Y,\n   #17 pack1/X$Z" : "Nest Members:\n   #59 pack1/X$Y,\n   #17 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #22 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #26 pack1/X");
        this.verifyOutputPositive(XZFile, "getstatic pack1.X$Y.priv_int");
        this.verifyOutputNegative(XYFile, "access$");
        this.verifyOutputNegative(XZFile, "invokestatic pack1.X$Y.access$0");
    }

    public void testBug535918_003b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_int = 100;\n\t}\n\tpublic static class Z {\n\t\tpublic static int foo() {\n\t\t\tY y = new Y();\n\t\t\tint i = y.priv_int;\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = Z.foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #55 pack1/X$Y,\n   #17 pack1/X$Z" : "Nest Members:\n   #59 pack1/X$Y,\n   #17 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #21 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #29 pack1/X");
        this.verifyOutputPositive(XZFile, "getfield pack1.X$Y.priv_int");
        this.verifyOutputNegative(XYFile, "access$");
        this.verifyOutputNegative(XZFile, "invokestatic pack1.X$Y.access$0");
    }

    public void testBug535918_003c() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_int = 100;\n\t}\n\tpublic static class Z {\n\t\tpublic static int foo() {\n\t\t\tint i = new Y().priv_int;\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = Z.foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #55 pack1/X$Y,\n   #17 pack1/X$Z" : "Nest Members:\n   #59 pack1/X$Y,\n   #17 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #21 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #27 pack1/X");
        this.verifyOutputPositive(XZFile, "getfield pack1.X$Y.priv_int");
        this.verifyOutputNegative(XYFile, "access$");
        this.verifyOutputNegative(XZFile, "invokestatic pack1.X$Y.access$0");
    }

    public void testBug535918_003d() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate static int priv_int = 100;\n\t}\n\tpublic static class Z extends Y {\n\t\tpublic static int foo() {\n\t\t\tint i = Y.priv_int;\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = Z.foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #55 pack1/X$Y,\n   #17 pack1/X$Z" : "Nest Members:\n   #59 pack1/X$Y,\n   #17 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #22 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #24 pack1/X");
        this.verifyOutputPositive(XZFile, "getstatic pack1.X$Y.priv_int");
        this.verifyOutputNegative(XYFile, "access$");
        this.verifyOutputNegative(XZFile, "invokestatic pack1.X$Y.access$0");
    }

    public void testBug535918_003e() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y{\n\t\tprivate int priv_int = 100;\n\t}\n\tpublic static class Z extends Y {\n\t\tpublic static int foo() {\n\t\t\tY y = new Y();\n\t\t\tint i = y.priv_int;\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = Z.foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #55 pack1/X$Y,\n   #17 pack1/X$Z" : "Nest Members:\n   #59 pack1/X$Y,\n   #17 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #21 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #26 pack1/X");
        this.verifyOutputPositive(XZFile, "getfield pack1.X$Y.priv_int");
        this.verifyOutputNegative(XYFile, "access$");
        this.verifyOutputNegative(XZFile, "invokestatic pack1.X$Y.access$0");
    }

    public void testBug535918_003f() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y{\n\t\tprivate int priv_int = 100;\n\t}\n\tpublic static class Z extends Y {\n\t\tpublic int foo() {\n\t\t\tint i = super.priv_int;\n\t\t\treturn i;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = new Z().foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = this.complianceLevel < 0x350000L ? "Nest Members:\n   #55 pack1/X$Y,\n   #17 pack1/X$Z" : "Nest Members:\n   #60 pack1/X$Y,\n   #16 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #21 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #24 pack1/X");
        this.verifyOutputPositive(XZFile, "getfield pack1.X$Y.priv_int");
        this.verifyOutputNegative(XYFile, "access$");
        this.verifyOutputNegative(XZFile, "invokestatic pack1.X$Y.access$0");
    }

    public void testBug535918_004a() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tprivate static int priv_int = 100;\n\tpublic static class Y {\n\t\tpublic static int foo() {\n\t\t\treturn priv_int;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = Y.foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String partialOutput = "Nest Members:\n   #22 pack1/X$Y\n";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #17 pack1/X");
        this.verifyOutputPositive(XYFile, "getstatic pack1.X.priv_int");
        this.verifyOutputNegative(XFile, "access$");
        this.verifyOutputNegative(XFile, "invokestatic pack1.X.access$0()");
    }

    public void testBug535918_004b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tprivate int priv_int = 100;\n\tpublic class Y {\n\t\tpublic int foo() {\n\t\t\treturn priv_int;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = new X().new Y().foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n}\n"}, "SUCCESS:100", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String partialOutput = "Nest Members:\n   #20 pack1/X$Y\n";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #22 pack1/X");
        this.verifyOutputPositive(XYFile, "getfield pack1.X.priv_int");
        this.verifyOutputNegative(XFile, "access$");
        this.verifyOutputNegative(XYFile, "invokestatic pack1.X.access$0()");
    }

    public void testBug535918_005a() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tclass Y {\n\t\tclass Z {\n\t\t\tprivate Z() {\n\t\t\t}\n\t\t}\n\t\tZ d;\n\t\tprivate Y() {\n\t\t\tthis.d = new Z();\n\t\t}\n\t}\n\t@Override\n\tpublic String toString() {\n\t\treturn \"SUCCESS\";\n\t}\n  public static void main(String[] argv) {\n    System.out.println(new X());\n  }\n}\n"}, "SUCCESS", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XYZFile = this.getClassFileContents("pack1/X$Y$Z.class", 4);
        String partialOutput = "Nest Members:\n   #38 pack1/X$Y,\n   #42 pack1/X$Y$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #31 pack1/X");
        this.verifyOutputPositive(XYZFile, "Nest Host: #24 pack1/X");
        this.verifyOutputPositive(XYFile, "invokespecial pack1.X$Y$Z(pack1.X$Y)");
        this.verifyOutputNegative(XYZFile, "synthetic X$Y$Z");
        this.verifyOutputNegative(XYFile, "invokespecial pack1.X$Y$Z(pack1.X$Y, pack1.X$Y$Z)");
    }

    public void testBug535918_005b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tclass Z {\n\t\tprivate Z() {\n\t\t}\n\t}\n\tclass Y {\n\t\tZ d;\n\t\tprivate Y() {\n\t\t\tthis.d = new Z();\n\t\t}\n\t}\n\t@Override\n\tpublic String toString() {\n\t\treturn \"SUCCESS\";\n\t}\n  public static void main(String[] argv) {\n    System.out.println(new X());\n  }\n}\n"}, "SUCCESS", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = "Nest Members:\n   #38 pack1/X$Y,\n   #41 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #30 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #22 pack1/X");
        this.verifyOutputPositive(XYFile, "invokespecial pack1.X$Z(pack1.X)");
        this.verifyOutputNegative(XZFile, "synthetic X$Z");
        this.verifyOutputNegative(XYFile, "invokespecial pack1.X$Z(pack1.X$Y, pack1.X$Z)");
    }

    public void testBug535918_005c() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tclass Y {\n\t\tprivate Y() {\n\t\t}\n\t\tclass Z {\n\t\t\tY y;\n\t\t\tprivate Z() {\n\t\t\t\tthis.y = new Y();\n\t\t\t}\n\t\t}\n\t}\n\t@Override\n\tpublic String toString() {\n\t\treturn \"SUCCESS\";\n\t}\n  public static void main(String[] argv) {\n    System.out.println(new X());\n  }\n}\n"}, "SUCCESS", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XYZFile = this.getClassFileContents("pack1/X$Y$Z.class", 4);
        String partialOutput = "Nest Members:\n   #38 pack1/X$Y,\n   #42 pack1/X$Y$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #24 pack1/X");
        this.verifyOutputPositive(XYZFile, "Nest Host: #34 pack1/X");
        this.verifyOutputPositive(XYZFile, "invokespecial pack1.X$Y(pack1.X)");
        this.verifyOutputNegative(XYFile, "synthetic X$Y");
        this.verifyOutputNegative(XYZFile, "invokespecial pack1.X$Y(pack1.X, pack1.X$Y)");
    }

    public void testBug535918_005d() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\t  private class Y {\n\t    private Y() {\n\t      super();\n\t    }\n\t  }\n\t  private class Z extends Y {\n\t    private Z() {\n\t      super();\n\t    }\n\t  }\n  public static void main(String[] argv) {\n\t\t  System.out.println(\"SUCCESS\");\n\t  }\n}\n"}, "SUCCESS", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = "Nest Members:\n   #35 pack1/X$Y,\n   #38 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #22 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #21 pack1/X");
        this.verifyOutputPositive(XZFile, "invokespecial pack1.X$Y(pack1.X)");
        this.verifyOutputNegative(XYFile, "synthetic X$Y");
        this.verifyOutputNegative(XZFile, "invokespecial pack1.X$Y(pack1.X, pack1.X$Y)");
    }

    public void testBug535918_005e() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n  private static class Y<T> implements AutoCloseable {\n    private Y() {\n      super();\n    }\n    public void close() {\n    }\n  }\n  @SuppressWarnings(\"unused\")\nprivate static class Z extends Y<Object> {\n    private Z() {\n      super();\n    }\n  }\n  public static void main(String[] args) {\n\t  System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XZFile = this.getClassFileContents("pack1/X$Z.class", 4);
        String partialOutput = "Nest Members:\n   #35 pack1/X$Y,\n   #38 pack1/X$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #24 pack1/X");
        this.verifyOutputPositive(XZFile, "Nest Host: #19 pack1/X");
        this.verifyOutputPositive(XZFile, "invokespecial pack1.X$Y()");
        this.verifyOutputNegative(XYFile, "synthetic pack1.X$Y(pack1.X.Y arg0)");
        this.verifyOutputNegative(XZFile, "2  invokespecial pack1.X$Y(pack1.X$Y)");
    }

    public void testBug535918_005f() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"X.java", "interface I {\n  X makeX(int x);\n}\npublic class X {\n  void foo() {\n    class Y {\n    \tvoid f() {\n    \t\tI i = X::new;\n    \t\ti.makeX(123456);\n    \t}\n    }\n    new Y().f();\n  }\n  private X(int x) {\n    super();\n    System.out.println(\"SUCCESS\");\n  }\n  X() {\n    super();\n  }\n  public static void main(String[] args) {\n    new X().foo();\n  }\n}\n"}, "SUCCESS", options);
        String XFile = this.getClassFileContents("X.class", 4);
        String X1YFile = this.getClassFileContents("X$1Y.class", 4);
        String partialOutput = "Nest Members:\n   #8 X$1Y\n";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(X1YFile, "Nest Host: #33 X");
        this.verifyOutputNegative(X1YFile, "synthetic X$Y(pack1.X.Y arg0)");
    }

    public void testBug535918_005g() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_instance_method() {\n\t\t\treturn 100;\n\t\t}\n\t\tpublic int pub_instance_method() {\n\t\t\tint pri = priv_instance_method();\n\t\t\treturn 200 + pri;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n\tpublic static int foo() {\n\t\tY y = new Y();\n\t\tint i = y.priv_instance_method();\n\t\tint j = y.pub_instance_method();\n\t\treturn i + j;\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n"}, "SUCCESS:400", options);
        String expectedPartialOutput = "invokevirtual pack1.X$Y.priv_instance_method()";
        this.verifyClassFile(expectedPartialOutput, "pack1/X.class", 4);
    }

    public void testBug535918_005h() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_instance_method() {\n\t\t\treturn 100;\n\t\t}\n\t\tpublic int pub_instance_method() {\n\t\t\tint pri = priv_instance_method();\n\t\t\treturn 200 + pri;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n\tpublic static int foo() {\n\t\tY y = new Y();\n\t\tint i = y.priv_instance_method();\n\t\tint j = y.pub_instance_method();\n\t\treturn i + j;\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n"}, "SUCCESS:400", options);
        String unExpectedPartialOutput = "invokespecial pack1.X$Y.priv_instance_method()";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X.class", 4);
    }

    public void testBug535918_005i() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic static class Y {\n\t\tprivate int priv_instance_method() {\n\t\t\treturn 100;\n\t\t}\n\t\tpublic int pub_instance_method() {\n\t\t\tint pri = priv_instance_method();\n\t\t\treturn 200 + pri;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tint sum = foo();\n\t\tSystem.out.println(\"SUCCESS:\"+sum);\n\t}\n\tpublic static int foo() {\n\t\tY y = new Y();\n\t\tint i = y.priv_instance_method();\n\t\tint j = y.pub_instance_method();\n\t\treturn i + j;\n\t}\n\tpublic void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n"}, "SUCCESS:400", options);
        String unExpectedPartialOutput = "access$";
        this.verifyNegativeClassFile(unExpectedPartialOutput, "pack1/X$Y.class", 4);
    }

    public void testBug535918_005j() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\ninterface I {\n\tprivate void foo() {}\n\tpublic default void apply() {\n\t\tfoo();\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}\n"}, "", options);
        String IFile = this.getClassFileContents("pack1/I.class", 4);
        String partialOutput = "invokeinterface pack1.I.foo";
        this.verifyOutputPositive(IFile, partialOutput);
    }

    public void testBug535918_005k() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\ninterface I {\tprivate void foo() {}\t\tinterface J {\t\tpublic default void apply() {\t\t\tI i = new X();\t\t\ti.foo();\t\t}\t\t}}public class X implements I{\n}\n"}, "", options);
        String IFile = this.getClassFileContents("pack1/I$J.class", 4);
        String partialOutput = "invokeinterface pack1.I.foo";
        this.verifyOutputPositive(IFile, partialOutput);
    }

    public void testBug535918_0056a() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tprivate int priv_int;\n\n\tclass Y extends X {\n\t\tclass Z extends Y {\n\t\t\tpublic void foo() {\n\t\t\t\tX.Y.super.priv_int = 0;\n\t\t\t}\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().foo();\n\t}\n}\n"}, "", options);
        String XFile = this.getClassFileContents("pack1/X.class", 4);
        String XYFile = this.getClassFileContents("pack1/X$Y.class", 4);
        String XYZFile = this.getClassFileContents("pack1/X$Y$Z.class", 4);
        String partialOutput = "Nest Members:\n   #20 pack1/X$Y,\n   #18 pack1/X$Y$Z";
        this.verifyOutputPositive(XFile, partialOutput);
        this.verifyOutputPositive(XYFile, "Nest Host: #3 pack1/X");
        this.verifyOutputPositive(XYZFile, "Nest Host: #22 pack1/X");
        this.verifyOutputPositive(XYZFile, "putfield pack1.X.priv_int");
        this.verifyOutputNegative(XYFile, "synthetic X$Y");
        this.verifyOutputNegative(XYZFile, "invokestatic X.access$0(X, int)");
    }

    public void testBug545387_01() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\npublic class X {\n\tpublic class Inner1 {\n\t\tprivate void foo() {\n\t\t\tSystem.out.println(\"hello\");;\n\t\t}\n\t}\n\tpublic class Sub1 extends Inner1 {\n\t\tpublic class Sub2 {\n\t\t\tvoid testFoo() {\n\t\t\t\tSub1.super.foo();\n\t\t\t}\n\t\t}\n\t\tvoid testFoo() {\n\t\t\t(new Sub2()).testFoo();\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSub1 s1 = getS1();\n\t\ts1.testFoo();\n\t}\n\tpublic static Sub1 getS1() {\n\t\treturn new X().new Sub1();\n\t}\n}\n"}, "hello", options);
        String XSub1Sub2 = this.getClassFileContents("pack1/X$Sub1$Sub2.class", 4);
        this.verifyOutputPositive(XSub1Sub2, "Nest Host: #29 pack1/X");
    }

    public void testBug572190_01() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n       public void foo() {\n               new Thread(() -> {\n                       new Object() {\n                       };\n               });\n       }\n       public static void main(String[] args) {\n               System.out.println(0);\n       }\n}"}, "0");
        String XFile = this.getClassFileContents("X.class", 4);
        String expected = "Nest Members:\n   #41 X$1\nBootstrap methods:\n";
        String unexpectedOutput = "Nest Members:\n   #41 X$1,\n   #68 X$2\nBootstrap methods:\n";
        this.verifyOutputPositive(XFile, expected);
        this.verifyOutputNegative(XFile, unexpectedOutput);
    }

    public void testBug572190_02() throws Exception {
        this.runConformTest(new String[]{"pack1/X.java", "package pack1;\n\nimport pack1.XB.EF;\n\npublic class X {\n       private static int foo() {\n               return  EF.values().length;\n       }\n    public static void main(String argv[])   {\n       System.out.println(X.foo());\n    }\n    public enum ch { }\n}\n", "pack1/XA.java", "package pack1;\npublic class XA {\n    public enum EC {}\n}", "pack1/XB.java", "package pack1;\npublic class XB {\n    protected enum EF {}\n}"}, "0");
        String XFile = this.getClassFileContents("pack1/XB.class", 4);
        String expected = "Nest Members:\n   #17 pack1/XB$EF\n}";
        this.verifyOutputPositive(XFile, expected);
    }

    public static Class testClass() {
        return JEP181NestTest.class;
    }
}

