/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;

public class JEP286ReservedWordTest
extends AbstractRegressionTest {
    public static Class testClass() {
        return JEP286ReservedWordTest.class;
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
    }

    public static Test suite() {
        return JEP286ReservedWordTest.buildMinimalComplianceTestSuite(JEP286ReservedWordTest.testClass(), 32);
    }

    public JEP286ReservedWordTest(String testName) {
        super(testName);
    }

    public void test0001_class_var_warning() throws IOException {
        String classVar = "\tpublic class var { public int a; };\n";
        String classX = "public class X {\n" + classVar + "\t+\n}\n";
        String errorTail = "----------\n2. ERROR in X.java (at line 3)\n\t+\n\t^\nSyntax error on token \"+\", delete this token\n----------\n";
        if (Long.compare(this.complianceLevel, 0x360000L) >= 0) {
            this.runNegativeTest(new String[]{"X.java", classX}, "----------\n1. ERROR in X.java (at line 2)\n" + classVar + "\t             ^^^\n'var' is not a valid type name\n" + errorTail);
        } else {
            this.runNegativeTest(new String[]{"X.java", classX}, "----------\n1. WARNING in X.java (at line 2)\n" + classVar + "\t             ^^^\n'var' should not be used as an type name, since it is a reserved word from source level 10 on\n" + errorTail);
        }
    }

    public void test0002_interface_var_warning() throws IOException {
        String interfaceVar = "\tinterface var { };\n";
        String classX = "public class X {\n" + interfaceVar + "\t+\n}\n";
        String errorTail = "----------\n2. ERROR in X.java (at line 3)\n\t+\n\t^\nSyntax error on token \"+\", delete this token\n----------\n";
        if (Long.compare(this.complianceLevel, 0x360000L) >= 0) {
            this.runNegativeTest(new String[]{"X.java", classX}, "----------\n1. ERROR in X.java (at line 2)\n" + interfaceVar + "\t          ^^^\n'var' is not a valid type name\n" + errorTail);
        } else {
            this.runNegativeTest(new String[]{"X.java", classX}, "----------\n1. WARNING in X.java (at line 2)\n" + interfaceVar + "\t          ^^^\n'var' should not be used as an type name, since it is a reserved word from source level 10 on\n" + errorTail);
        }
    }

    public void testBug530920() throws IOException {
        String classX = "public class X<var extends Number> { }\n";
        this.runNegativeTest(new String[]{"X.java", classX}, Long.compare(this.complianceLevel, 0x360000L) >= 0 ? "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<var extends Number> { }\n\t               ^^^\n'var' is not allowed here\n" : "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<var extends Number> { }\n\t               ^^^\n'var' should not be used as an type name, since it is a reserved word from source level 10 on\n");
    }

    public void testBug530920a() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<var extends Number> var getNumber() {\n\t\treturn null;\n\t}\n}"}, Long.compare(this.complianceLevel, 0x360000L) >= 0 ? "----------\n1. ERROR in X.java (at line 2)\n\t<var extends Number> var getNumber() {\n\t ^^^\n'var' is not allowed here\n" : "----------\n1. WARNING in X.java (at line 2)\n\t<var extends Number> var getNumber() {\n\t ^^^\n'var' should not be used as an type name, since it is a reserved word from source level 10 on\n");
    }
}

