/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;

public class JEP323VarLambdaParamsTest
extends AbstractRegressionTest {
    public static Class testClass() {
        return JEP323VarLambdaParamsTest.class;
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
    }

    public static Test suite() {
        return JEP323VarLambdaParamsTest.buildMinimalComplianceTestSuite(JEP323VarLambdaParamsTest.testClass(), 256);
    }

    public JEP323VarLambdaParamsTest(String testName) {
        super(testName);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "11");
        options.put("org.eclipse.jdt.core.compiler.source", "11");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "11");
        return options;
    }

    public void testBug534787_positive_001() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var  x) -> {System.out.println(\"SUCCESS \" + x);};\n        lam.apply(20);\n    }\n}\ninterface I {\n    public void apply(Integer k);\n}\n"}, "SUCCESS 20");
    }

    public void testBug534787_positive_002() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var  x, var y) -> {System.out.println(\"SUCCESS \" + (x+y));};\n        lam.apply(20, 200);\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer l);\n}\n"}, "SUCCESS 220");
    }

    public void testBug534787_positive_003() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = var -> {System.out.println(\"SUCCESS \" + var);};\n        lam.apply(10);\n    }\n}\ninterface I {\n    public void apply(Integer k);\n}\n"}, "SUCCESS 10");
    }

    public void testBug534787_positive_004() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var var) -> {System.out.println(\"SUCCESS \" + var);};\n        lam.apply(10);\n    }\n}\ninterface I {\n    public void apply(Integer k);\n}\n"}, "SUCCESS 10");
    }

    public void testBug534787_negative_001() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var  x, y) -> {System.out.println(\"SUCCESS \" + x);};\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer z);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI lam = (var  x, y) -> {System.out.println(\"SUCCESS \" + x);};\n\t         ^^^\nSyntax error on token \"var\", ( expected after this token\n----------\n2. ERROR in X.java (at line 3)\n\tI lam = (var  x, y) -> {System.out.println(\"SUCCESS \" + x);};\n\t                  ^\nSyntax error on token \")\", delete this token\n----------\n3. ERROR in X.java (at line 3)\n\tI lam = (var  x, y) -> {System.out.println(\"SUCCESS \" + x);};\n\t                                                           ^\nSyntax error, insert \")\" to complete Expression\n----------\n4. ERROR in X.java (at line 3)\n\tI lam = (var  x, y) -> {System.out.println(\"SUCCESS \" + x);};\n\t                                                           ^\nSyntax error, insert \")\" to complete Expression\n----------\n");
    }

    public void testBug534787_negative_002() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var  x, Integer y) -> {System.out.println(\"SUCCESS \" + x);};\n        lam.apply(20, 200);\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer z);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI lam = (var  x, Integer y) -> {System.out.println(\"SUCCESS \" + x);};\n\t              ^\n'var' cannot be mixed with non-var parameters\n----------\n");
    }

    public void testBug534787_negative_003() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (Integer  x, var y) -> {System.out.println(\"SUCCESS \" + x);};\n        lam.apply(20, 200);\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer z);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI lam = (Integer  x, var y) -> {System.out.println(\"SUCCESS \" + x);};\n\t                         ^\n'var' cannot be mixed with non-var parameters\n----------\n");
    }

    public void testBug534787_negative_004() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var  x, var y, var...s) -> {System.out.println(\"SUCCESS \" + x);};\n        lam.apply(20, 200, \"hello\");\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer z, String s);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI lam = (var  x, var y, var...s) -> {System.out.println(\"SUCCESS \" + x);};\n\t                        ^^^\n'var' is not allowed as an element type of an array\n----------\n");
    }

    public void testBug534787_negative_005() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = (var  x, Integer y, var...s) -> {System.out.println(\"SUCCESS \" + x);};\n        lam.apply(20, 200, \"hello\");\n    }\n}\ninterface I {\n    public void apply(Integer k, Integer z, String s);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI lam = (var  x, Integer y, var...s) -> {System.out.println(\"SUCCESS \" + x);};\n\t              ^\n'var' cannot be mixed with non-var parameters\n----------\n2. ERROR in X.java (at line 3)\n\tI lam = (var  x, Integer y, var...s) -> {System.out.println(\"SUCCESS \" + x);};\n\t                            ^^^\n'var' is not allowed as an element type of an array\n----------\n");
    }

    public void testBug534787_negative_006() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        I lam = var  x -> {System.out.println(\"SUCCESS \" + x);};\n    }\n}\ninterface I {\n    public void apply(Integer k);\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tI lam = var  x -> {System.out.println(\"SUCCESS \" + x);};\n\t             ^\nSyntax error on token \"x\", delete this token\n----------\n");
    }

    public void testBug536159_01() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\npublic static void main(String[] args) {\n  FI x = (int i []) -> 5;\n    }\n}\ninterface FI {\n  public int foo (int i []);\n}"});
    }

    public void testBug536159_02() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\npublic static void main(String[] args) {\n  FI x = (int[] i []) -> 5;\n    }\n}\ninterface FI {\n  public int foo (int i [][]);\n}"});
    }

    public void testBug536159_03() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\npublic static void main(String[] args) {\n  FI x = (int i [][]) -> 5;\n    }\n}\ninterface FI {\n  public int foo (int i [][]);\n}"});
    }

    public void testBug536159_04() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\npublic static void main(String[] args) {\n  FI x = (var i []) -> 5;\n    }\n}\ninterface FI {\n  public int foo (int i []);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tFI x = (var i []) -> 5;\n\t        ^^^\n'var' is not allowed as an element type of an array\n----------\n");
    }

    public void testBug541532_01() throws IOException {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n\n\tpublic static void foo(List<String> list) {\n\t\tlist.stream()\n\t\t  .map((var s) -> s.toLowerCase())\n\t\t  .forEach(System.out::println);\n\n\t\tlist.stream()\n\t\t  .filter((var s) -> s.length() == 1)\n\t\t  .forEach(System.out::println);\n\t}\n\tpublic static void main(String[] args) {\n\t\tString[] greetings = {\"hello\", \"world\"};\n\t\tX.foo(Arrays.asList(greetings));\n\t}\n}\n"}, "hello\nworld");
    }

    public void testIssue4159() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit(int x);\n}\n\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = (var<String> x ) -> {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI i = (var<String> x ) -> {};\n\t       ^^^\n'var' cannot be used with type arguments\n----------\n");
    }
}

