/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;

public class JEP441SnippetsTest
extends AbstractRegressionTest9 {
    public static Class<?> testClass() {
        return JEP441SnippetsTest.class;
    }

    public static Test suite() {
        return JEP441SnippetsTest.buildMinimalComplianceTestSuite(JEP441SnippetsTest.testClass(), 262144);
    }

    public JEP441SnippetsTest(String testName) {
        super(testName);
    }

    public void test01() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic String formatterPatternSwitch(Object obj) {\n\t    return switch (obj) {\n\t        case Integer i -> String.format(\"int %d\", i);\n\t        case Long l    -> String.format(\"long %d\", l);\n\t        case Double d  -> String.format(\"double %f\", d);\n\t        case String s  -> String.format(\"String %s\", s);\n\t        default        -> obj.toString();\n\t    };\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn \"X X\";\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(formatterPatternSwitch(10));\n\t\tSystem.out.println(formatterPatternSwitch(10L));\n\t\tSystem.out.println(formatterPatternSwitch(10.0));\n\t\tSystem.out.println(formatterPatternSwitch(\"String\"));\n\t\tSystem.out.println(formatterPatternSwitch(new X()));\n\t}\n}\n"}, "int 10\nlong 10\ndouble 10.000000\nString String\nX X");
    }

    public void test02() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic void testFooBarNew(String s) {\n\t    switch (s) {\n\t        case null         -> System.out.println(\"Oops\");\n\t        case \"Foo\", \"Bar\" -> System.out.println(\"Great\");\n\t        default           -> System.out.println(\"Ok\");\n\t    }\n\t}\n\n\n\tpublic static void main(String[] args) {\n\t\ttestFooBarNew(null);\n\t\ttestFooBarNew(\"foo\");\n\t\ttestFooBarNew(\"Foo\");\n\t\ttestFooBarNew(\"Bar\");\n\t}\n}\n"}, "Oops\nOk\nGreat\nGreat");
    }

    public void test03() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic void testStringOld(String response) {\n\t    switch (response) {\n\t        case null -> { }\n\t        case String s -> {\n\t            if (s.equalsIgnoreCase(\"YES\"))\n\t                System.out.println(\"You got it\");\n\t            else if (s.equalsIgnoreCase(\"NO\"))\n\t                System.out.println(\"Shame\");\n\t            else\n\t                System.out.println(\"Sorry?\");\n\t        }\n\t    }\n\t}\n\n\tstatic void testStringNew(String response) {\n\t    switch (response) {\n\t        case null -> { }\n\t        case String s\n\t        when s.equalsIgnoreCase(\"YES\") -> {\n\t            System.out.println(\"You got it\");\n\t        }\n\t        case String s\n\t        when s.equalsIgnoreCase(\"NO\") -> {\n\t            System.out.println(\"Shame\");\n\t        }\n\t        case String s -> {\n\t            System.out.println(\"Sorry?\");\n\t        }\n\t    }\n\t}\n\n\tstatic void testStringEnhanced(String response) {\n\t    switch (response) {\n\t        case null -> { }\n\t        case \"y\", \"Y\" -> {\n\t            System.out.println(\"You got it\");\n\t        }\n\t        case \"n\", \"N\" -> {\n\t            System.out.println(\"Shame\");\n\t        }\n\t        case String s\n\t        when s.equalsIgnoreCase(\"YES\") -> {\n\t            System.out.println(\"You got it\");\n\t        }\n\t        case String s\n\t        when s.equalsIgnoreCase(\"NO\") -> {\n\t            System.out.println(\"Shame\");\n\t        }\n\t        case String s -> {\n\t            System.out.println(\"Sorry?\");\n\t        }\n\t    }\n\t}\n\n\n\tpublic static void main(String[] args) {\n\t\ttestStringOld(null);\n\t\ttestStringOld(\"Yes\");\n\t\ttestStringOld(\"NO\");\n\t\ttestStringOld(\"Bar\");\n\n\t\ttestStringNew(null);\n\t\ttestStringNew(\"Yes\");\n\t\ttestStringNew(\"NO\");\n\t\ttestStringNew(\"Bar\");\n\n\t\ttestStringEnhanced(null);\n\t\ttestStringEnhanced(\"Y\");\n\t\ttestStringEnhanced(\"y\");\n\t\ttestStringEnhanced(\"N\");\n\t\ttestStringEnhanced(\"n\");\n\t\ttestStringEnhanced(\"Yes\");\n\t\ttestStringEnhanced(\"NO\");\n\t\ttestStringEnhanced(\"Bar\");\n\n\t}\n}\n"}, "You got it\nShame\nSorry?\nYou got it\nShame\nSorry?\nYou got it\nYou got it\nShame\nShame\nYou got it\nShame\nSorry?");
    }

    public void test04() {
        this.runConformTest(new String[]{"X.java", "sealed interface CardClassification permits Suit, Tarot {\n}\n\nenum Suit implements CardClassification {\n\tCLUBS, DIAMONDS, HEARTS, SPADES\n}\n\nfinal class Tarot implements CardClassification {\n}\n\npublic class X {\n\tstatic void exhaustiveSwitchWithoutEnumSupport(CardClassification c) {\n\t    switch (c) {\n\t        case Suit s when s == Suit.CLUBS -> {\n\t            System.out.println(\"It's clubs\");\n\t        }\n\t        case Suit s when s == Suit.DIAMONDS -> {\n\t            System.out.println(\"It's diamonds\");\n\t        }\n\t        case Suit s when s == Suit.HEARTS -> {\n\t            System.out.println(\"It's hearts\");\n\t        }\n\t        case Suit s -> {\n\t            System.out.println(\"It's spades\");\n\t        }\n\t        case Tarot t -> {\n\t            System.out.println(\"It's a tarot\");\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\texhaustiveSwitchWithoutEnumSupport(Suit.CLUBS);\n\t\texhaustiveSwitchWithoutEnumSupport(Suit.DIAMONDS);\n\t\texhaustiveSwitchWithoutEnumSupport(Suit.HEARTS);\n\t\texhaustiveSwitchWithoutEnumSupport(Suit.SPADES);\n\t\texhaustiveSwitchWithoutEnumSupport(new Tarot());\n\t}\n}\n"}, "It's clubs\nIt's diamonds\nIt's hearts\nIt's spades\nIt's a tarot");
    }

    public void test05() {
        this.runConformTest(new String[]{"X.java", "sealed interface CardClassification permits Suit, Tarot {}\nenum Suit implements CardClassification { CLUBS, DIAMONDS, HEARTS, SPADES }\nfinal class Tarot implements CardClassification {}\npublic class X {\n\tstatic void exhaustiveSwitchWithBetterEnumSupport(CardClassification c) {\n\t    switch (c) {\n\t        case Suit.CLUBS -> {\n\t            System.out.println(\"It's clubs\");\n\t        }\n\t        case Suit.DIAMONDS -> {\n\t            System.out.println(\"It's diamonds\");\n\t        }\n\t        case Suit.HEARTS -> {\n\t            System.out.println(\"It's hearts\");\n\t        }\n\t        case Suit.SPADES -> {\n\t            System.out.println(\"It's spades\");\n\t        }\n\t        case Tarot t -> {\n\t            System.out.println(\"It's a tarot\");\n\t        }\n\t    }\n\t}\n\tpublic static void main(String[] args) {\n\t\texhaustiveSwitchWithBetterEnumSupport(Suit.CLUBS);\n\t\texhaustiveSwitchWithBetterEnumSupport(Suit.DIAMONDS);\n\t\texhaustiveSwitchWithBetterEnumSupport(Suit.HEARTS);\n\t\texhaustiveSwitchWithBetterEnumSupport(Suit.SPADES);\n\t\texhaustiveSwitchWithBetterEnumSupport(new Tarot());\n\t}\n}\n"}, "It's clubs\nIt's diamonds\nIt's hearts\nIt's spades\nIt's a tarot");
    }

    public void test06() {
        this.runConformTest(new String[]{"X.java", "// As of Java 21\nsealed interface Currency permits Coin {}\nenum Coin implements Currency { HEADS, TAILS }\n\npublic class X {\n\tstatic void goodEnumSwitch1(Currency c) {\n\t    switch (c) {\n\t        case Coin.HEADS -> {    // Qualified name of enum constant as a label\n\t            System.out.println(\"Heads\");\n\t        }\n\t        case Coin.TAILS -> {\n\t            System.out.println(\"Tails\");\n\t        }\n\t    }\n\t}\n\n\tstatic void goodEnumSwitch2(Coin c) {\n\t    switch (c) {\n\t        case HEADS -> {\n\t            System.out.println(\"Heads\");\n\t        }\n\t        case Coin.TAILS -> {    // Unnecessary qualification but allowed\n\t            System.out.println(\"Tails\");\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tgoodEnumSwitch1(Coin.HEADS);\n\t\tgoodEnumSwitch1(Coin.TAILS);\n\n\t\tgoodEnumSwitch2(Coin.HEADS);\n\t\tgoodEnumSwitch2(Coin.TAILS);\n\n\t}\n}\n"}, "Heads\nTails\nHeads\nTails");
    }

    public void test07() {
        this.runNegativeTest(new String[]{"X.java", "// As of Java 21\nsealed interface Currency permits Coin {}\nenum Coin implements Currency { HEADS, TAILS }\n\npublic class X {\n\tstatic void badEnumSwitch(Currency c) {\n\t    switch (c) {\n\t        case Coin.HEADS -> {\n\t            System.out.println(\"Heads\");\n\t        }\n\t        case TAILS -> {         // Error - TAILS must be qualified\n\t            System.out.println(\"Tails\");\n\t        }\n\t        default -> {\n\t            System.out.println(\"Some currency\");\n\t        }\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tcase TAILS -> {         // Error - TAILS must be qualified\n\t     ^^^^^\nTAILS cannot be resolved to a variable\n----------\n");
    }

    public void test08() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic void testNew(Object obj) {\n\t    switch (obj) {\n\t        case String s when s.length() == 4 -> System.out.println(\"Bad word!\");\n\t        case String s when s.length() == 1 -> System.out.println(\"Monsyllable\");\n\t        default -> System.out.println(\"  \");\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttestNew(\"X\");\n\t\ttestNew(\"***\");\n\t\ttestNew(\"*!#^\");\n\t}\n}\n"}, "Monsyllable\n  \nBad word!");
    }

    public void test09() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\trecord Point(int i, int j) {}\n\tenum Color { RED, GREEN, BLUE; }\n\n\tstatic void typeTester(Object obj) {\n\t    switch (obj) {\n\t        case null     -> System.out.println(\"null\");\n\t        case String s -> System.out.println(\"String\");\n\t        case Color c  -> System.out.println(\"Color: \" + c.toString());\n\t        case Point p  -> System.out.println(\"Record class: \" + p.toString());\n\t        case int[] ia -> System.out.println(\"Array of ints of length\" + ia.length);\n\t        default       -> System.out.println(\"Something else\");\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\ttypeTester(null);\n\t\ttypeTester(\"Hello\");\n\t\ttypeTester(Color.RED);\n\t\ttypeTester(new Point(0, 0));\n\t\ttypeTester(new int[10]);\n\t\ttypeTester(10);\n\t}\n}\n"}, "null\nString\nColor: RED\nRecord class: Point[i=0, j=0]\nArray of ints of length10\nSomething else");
    }

    public void test10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic void first(Object obj) {\n\t    switch (obj) {\n\t        case String s ->\n\t            System.out.println(\"A string: \" + s);\n\t        case CharSequence cs ->\n\t            System.out.println(\"A sequence of length \" + cs.length());\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfirst(\"Hello\");\n\t\tfirst(new StringBuilder(\"Hello\"));\n\t}\n}\n"}, "A string: Hello\nA sequence of length 5");
    }

    public void test11() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tstatic void first(Object obj) {\n\t    switch (obj) {\n\t        case CharSequence cs ->\n\t            System.out.println(\"A sequence of length \" + cs.length());\n\t        case String s ->\n\t            System.out.println(\"A string: \" + s);\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfirst(\"Hello\");\n\t\tfirst(new StringBuilder(\"Hello\"));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s ->\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test12() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tstatic void first(Object obj) {\n\t    switch (obj) {\n\t        case String s ->\n\t        \tSystem.out.println(\"A String: \" + s);\n\t        case String s when s.length() > 0 ->\n\t            System.out.println(\"A string: \" + s);\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfirst(\"Hello\");\n\t\tfirst(new StringBuilder(\"Hello\"));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s when s.length() > 0 ->\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test13() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic void first(Object obj) {\n\t    switch (obj) {\n\t        case String s when s.length() > 0 ->\n\t            System.out.println(\"A guarded string: \" + s);\n\t        case String s ->\n        \t\tSystem.out.println(\"A String: \" + s);\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfirst(\"Hello\");\n\t\tfirst(new StringBuilder(\"Hello\"));\n\t}\n}\n"}, "A guarded string: Hello");
    }

    public void test14() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tstatic void first(Object obj) {\n\t    switch (obj) {\n\t    \tcase String s when true ->\n\t    \t\tSystem.out.println(\"A pseudo guarded string: \" + s);\n\t        case String s when s.length() > 0 ->\n\t            System.out.println(\"A guarded string: \" + s);\n\t        case String s ->\n        \t\tSystem.out.println(\"A String: \" + s);\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfirst(\"Hello\");\n\t\tfirst(new StringBuilder(\"Hello\"));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tcase String s when s.length() > 0 ->\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 9)\n\tcase String s ->\n\t     ^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n");
    }

    public void test15() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void first(Integer obj) {\n\t    switch (obj) {\n\t    \tcase Integer i ->\n\t    \t\tSystem.out.println(\"An integer: \" + i);\n\t    \tcase 42 ->\n\t    \t\tSystem.out.println(\"42\");\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase 42 ->\n\t     ^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 8)\n\tdefault -> {\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void test16() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tenum E {\n\t\tONE, TWO;\n\t}\n\tstatic void first(E e) {\n\t    switch (e) {\n\t    \tcase E e1 ->\n\t    \t\tSystem.out.println(\"An ENUM: \" + e1);\n\t    \tcase ONE ->\n\t    \t\tSystem.out.println(\"42\");\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tstatic void second(E e) {\n\t    switch (e) {\n\t    \tcase ONE ->\n\t    \t\tSystem.out.println(\"An ENUM: \");\n\t    \tcase TWO ->\n\t    \t\tSystem.out.println(\"42\");\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tcase ONE ->\n\t     ^^^\nThis case label is dominated by one of the preceding case labels\n----------\n2. ERROR in X.java (at line 11)\n\tdefault -> {\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void test17() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void first(Object selector) {\n\t    switch (selector) {\n\t    \tcase String s when s.length() > 1 ->\n\t    \t\tSystem.out.println(\"Some string\");\n\t    \tcase \"Hello\" ->\n\t    \t\tSystem.out.println(\"42\");\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tstatic void second(String selector) {\n\t    switch (selector) {\n\t    \tcase String s when s.length() > 1 ->\n\t    \t\tSystem.out.println(\"Some string\");\n\t    \tcase \"Hello\" ->\n\t    \t\tSystem.out.println(\"42\");\n\t    \tcase String s ->\n\t    \t\tSystem.out.println(\"unconditional\");\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tstatic void third(String selector) {\n\t    switch (selector) {\n\t    \tcase String s when s.length() > 1 ->\n\t    \t\tSystem.out.println(\"Some string\");\n\t    \tcase String s ->\n    \t\t\tSystem.out.println(\"unconditional\");\n\t    \tcase \"Hello\" ->\n\t    \t\tSystem.out.println(\"42\");\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase \"Hello\" ->\n\t     ^^^^^^^\nCase constant of type String is incompatible with switch selector type Object\n----------\n2. ERROR in X.java (at line 22)\n\tdefault -> {\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n3. ERROR in X.java (at line 34)\n\tcase \"Hello\" ->\n\t     ^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n4. ERROR in X.java (at line 36)\n\tdefault -> {\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void test18() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic void first(Integer i) {\n\t\tswitch (i) {\n\t\t    case -1, 1 -> System.out.println(\"Special cases\");\n\t\t    case Integer j when j > 0 -> System.out.println(\"Positive integer cases\");\n\t\t    case Integer j -> System.out.println(\"All the remaining integers\");\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tfirst(-1);\n\t\tfirst(1);\n\t\tfirst(42);\n\t\tfirst(0);\n\t}\n}\n"}, "Special cases\nSpecial cases\nPositive integer cases\nAll the remaining integers");
    }

    public void test19() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t// As of Java 21\n\tstatic void matchAll(String s) {\n\t    switch(s) {\n\t        case String t:\n\t            System.out.println(t);\n\t            break;\n\t        default:\n\t            System.out.println(\"Something else\");  // Error - dominated!\n\t    }\n\t}\n\n\tstatic void matchAll2(String s) {\n\t    switch(s) {\n\t        case Object o:\n\t            System.out.println(\"An Object\");\n\t            break;\n\t        default:\n\t            System.out.println(\"Something else\");  // Error - dominated!\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tdefault:\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n2. ERROR in X.java (at line 18)\n\tdefault:\n\t^^^^^^^\nSwitch case cannot have both unconditional pattern and default label\n----------\n");
    }

    public void test20() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t// As of Java 21\n\tstatic int coverage(Object obj) {\n\t    return switch (obj) {           // Error - not exhaustive\n\t        case String s -> s.length();\n\t    };\n\t}\n\n\t// As of Java 21\n\tstatic int coverage(Object obj) {\n\t    return switch (obj) {           // Error - still not exhaustive\n\t        case String s  -> s.length();\n\t        case Integer i -> i;\n\t    };\n\t}\n\n\t// As of Java 21\n\tstatic int coverage(Object obj) {\n\t    return switch (obj) {\n\t        case String s  -> s.length();\n\t        case Integer i -> i;\n\t        default -> 0;\n\t    };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic int coverage(Object obj) {\n\t           ^^^^^^^^^^^^^^^^^^^^\nDuplicate method coverage(Object) in type X\n----------\n2. ERROR in X.java (at line 4)\n\treturn switch (obj) {           // Error - not exhaustive\n\t               ^^^\nA switch expression should have a default case\n----------\n3. ERROR in X.java (at line 10)\n\tstatic int coverage(Object obj) {\n\t           ^^^^^^^^^^^^^^^^^^^^\nDuplicate method coverage(Object) in type X\n----------\n4. ERROR in X.java (at line 11)\n\treturn switch (obj) {           // Error - still not exhaustive\n\t               ^^^\nA switch expression should have a default case\n----------\n5. ERROR in X.java (at line 18)\n\tstatic int coverage(Object obj) {\n\t           ^^^^^^^^^^^^^^^^^^^^\nDuplicate method coverage(Object) in type X\n----------\n");
    }

    public void test21() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tenum Color { RED, YELLOW, GREEN }\n\n\t// As of Java 21\n\tstatic int coverage(Color color) {\n\n\t\tint numLetters = switch (color) {   // Exhaustive!\n\t    \tcase RED -> 3;\n\t    \tcase GREEN -> 5;\n\t    \tcase YELLOW -> 6;\n\t\t};\n\n\t\tnumLetters = switch (color) {   // Error - not exhaustive!\n\t    \tcase RED -> 3;\n\t    \tcase GREEN -> 5;\n\t\t};\n\n\t\tnumLetters = switch (color) {\n\t    \tcase RED -> 3;\n\t    \tcase GREEN -> 5;\n\t    \tcase YELLOW -> 6;\n\t    \tdefault -> throw new UnsupportedOperationException(color.toString());\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tnumLetters = switch (color) {   // Error - not exhaustive!\n\t                     ^^^^^\nA Switch expression should cover all possible values\n----------\n");
    }

    public void test22() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tsealed interface S permits A, B, C {}\n\tfinal class A implements S {}\n\tfinal class B implements S {}\n\trecord C(int i) implements S {}    // Implicitly final\n\n\tstatic int testSealedExhaustive(S s) {\n\t    return switch (s) {\n\t        case A a -> 1;\n\t        case B b -> 2;\n\t        case C c -> 3;\n\t    };\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(testSealedExhaustive(new X().new A()));\n\t\tSystem.out.println(testSealedExhaustive(new X().new B()));\n\t\tSystem.out.println(testSealedExhaustive(new C(10)));\n\n\t}\n}\n"}, "1\n2\n3");
    }

    public void test23() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tsealed interface S permits A, B, C {}\n\tfinal class A implements S {}\n\tfinal class B implements S {}\n\trecord C(int i) implements S {}    // Implicitly final\n\n\tstatic int testSealedExhaustive(S s) {\n\t    return switch (s) {\n\t        case A a -> 1;\n\t        case B b -> 2;\n\t    };\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(testSealedExhaustive(new X().new A()));\n\t\tSystem.out.println(testSealedExhaustive(new X().new B()));\n\t\tSystem.out.println(testSealedExhaustive(new C(10)));\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\r\n\treturn switch (s) {\r\n\t               ^\nA switch expression should have a default case\n----------\n");
    }

    public void test24() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tsealed interface I<T> permits A, B {}\n\tfinal class A<X> implements I<String> {}\n\tfinal class B<Y> implements I<Y> {}\n\n\tstatic int testGenericSealedExhaustive(I<Integer> i) {\n\t    return switch (i) {\n\t        // Exhaustive as no A case possible!\n\t        case B<Integer> bi -> 42;\n\t    };\n\t}\n\n\tstatic int testGenericSealedExhaustive2(I<Integer> i) {\n\t    return switch (i) {\n\t        // Exhaustive as no A case possible!\n\t        case B<Integer> bi -> 42;\n\t        case A<Integer> ai -> 42;\n\t    };\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tfinal class A<X> implements I<String> {}\n\t              ^\nThe type parameter X is hiding the type X\n----------\n2. ERROR in X.java (at line 17)\n\tcase A<Integer> ai -> 42;\n\t     ^^^^^^^^^^^^^\nIncompatible operand types X.I<Integer> and X.A<Integer>\n----------\n");
    }

    public void test25() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t// As of Java 21\n\tsealed interface S permits A, B, C {}\n\tfinal class A implements S {}\n\tfinal class B implements S {}\n\trecord C(int i) implements S {}    // Implicitly final\n\n\tstatic void switchStatementExhaustive(S s) {\n\t    switch (s) {                   // Error - not exhaustive;\n\t                                   // missing clause for permitted class B!\n\t        case A a :\n\t            System.out.println(\"A\");\n\t            break;\n\t        case C c :\n\t            System.out.println(\"C\");\n\t            break;\n\t    };\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tswitch (s) {                   // Error - not exhaustive;\n\t        ^\nAn enhanced switch statement should be exhaustive; a default label expected\n----------\n");
    }

    public void test26() {
        if (this.complianceLevel < 0x420000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void testScope1(Object obj) {\n\t    switch (obj) {\n\t        case Character c\n\t        when c.charValue() == 7:\n\t            System.out.println(\"Ding!\");\n\t            break;\n\t        default:\n\t            break;\n\t    }\n\t}\n\n\tstatic void testScope2(Object obj) {\n\t    switch (obj) {\n\t        case Character c -> {\n\t            if (c.charValue() == 7) {\n\t                System.out.println(\"Ding!\");\n\t            }\n\t            System.out.println(\"Character\");\n\t        }\n\t        case Integer i ->\n\t            throw new IllegalStateException(\"Invalid Integer argument: \"\n\t                                            + i.intValue());\n\t        default -> {\n\t            break;\n\t        }\n\t    }\n\t}\n\n\tstatic void testScope3(Object obj) {\n\t    switch (obj) {\n\t        case Character c:\n\t            if (c.charValue() == 7) {\n\t                System.out.print(\"Ding \");\n\t            }\n\t            if (c.charValue() == 9) {\n\t                System.out.print(\"Tab \");\n\t            }\n\t            System.out.println(\"Character\");\n\t        default:\n\t            System.out.println(c);\n\t    }\n\t}\n\n\tstatic void testScopeError(Object obj) {\n\t    switch (obj) {\n\t        case Character c:\n\t            if (c.charValue() == 7) {\n\t                System.out.print(\"Ding \");\n\t            }\n\t            if (c.charValue() == 9) {\n\t                System.out.print(\"Tab \");\n\t            }\n\t            System.out.println(\"character\");\n\t        case Integer i:                 // Compile-time error\n\t            System.out.println(\"An integer \" + i);\n\t        default:\n\t            break;\n\t    }\n\t}\n\n\tstatic void testScopeError2(Object obj) {\n\t    switch (obj) {\n\t        case Character c:\n\t            if (c.charValue() == 7) {\n\t                System.out.print(\"Ding \");\n\t            }\n\t            if (c.charValue() == 9) {\n\t                System.out.print(\"Tab \");\n\t            }\n\t            System.out.println(\"character\");\n\t        case Character c, Integer i:                 // Compile-time error\n\t            System.out.println(\"An integer \" + i);\n\t        default:\n\t            break;\n\t    }\n\t}\n\n\tvoid testScope4(Object obj) {\n\t    switch (obj) {\n\t        case String s:\n\t            System.out.println(\"A string: \" + s);  // s in scope here!\n\t        default:\n\t            System.out.println(\"Done\");            // s not in scope here\n\t    }\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 41)\n\tSystem.out.println(c);\n\t                   ^\nc cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 55)\n\tcase Integer i:                 // Compile-time error\n\t^^^^^^^^^^^^^^\nIllegal fall-through to a pattern\n----------\n3. ERROR in X.java (at line 72)\n\tcase Character c, Integer i:                 // Compile-time error\n\t     ^^^^^^^^^^^\nThis case label is dominated by one of the preceding case labels\n----------\n4. ERROR in X.java (at line 72)\n\tcase Character c, Integer i:                 // Compile-time error\n\t               ^\nNamed pattern variables are not allowed here\n----------\n5. ERROR in X.java (at line 72)\n\tcase Character c, Integer i:                 // Compile-time error\n\t                          ^\nNamed pattern variables are not allowed here\n----------\n6. ERROR in X.java (at line 73)\n\tSystem.out.println(\"An integer \" + i);\n\t                                   ^\ni cannot be resolved to a variable\n----------\n");
    }

    public void test27() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic void nullMatch(Object obj) {\n\t    switch (obj) {\n\t        case null     -> System.out.println(\"null!\");\n\t        case String s -> System.out.println(\"String\");\n\t        default       -> System.out.println(\"Something else\");\n\t    }\n\t}\n\n\tstatic void nullMatch2(Object obj) {\n\t    switch (obj) {\n\t        case String s  -> System.out.println(\"String: \" + s);\n\t        case Integer i -> System.out.println(\"Integer\");\n\t        default        -> System.out.println(\"default\");\n\t    }\n\t}\n\n\tstatic void nullMatch3(Object obj) {\n\t    switch (obj) {\n\t    \tcase null      -> throw new NullPointerException();\n\t        case String s  -> System.out.println(\"String: \" + s);\n\t        case Integer i -> System.out.println(\"Integer\");\n\t        default        -> System.out.println(\"default\");\n\t    }\n\t}\n\n\tstatic void nullMatch4(Object obj) {\n\t    switch (obj) {\n\t        case String s  -> System.out.println(\"String: \" + s);\n\t        case Integer i -> System.out.println(\"Integer\");\n\t        case null, default        -> System.out.println(\"null|default\");\n\t    }\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnullMatch(null);\n\t\tint nulls = 0;\n\t\ttry {\n\t\t\tnullMatch2(null);\n\t\t} catch(NullPointerException npe) {\n\t\t\tnulls++;\n\t\t}\n\t\ttry {\n\t\t\tnullMatch3(null);\n\t\t} catch(NullPointerException npe) {\n\t\t\tnulls++;\n\t\t}\n\t\tnullMatch4(null);\n\t\tif (nulls == 2) {\n\t\t\tSystem.out.println(\"OK!\");\n\t\t}\n\n\t}\n}\n"}, "null!\nnull|default\nOK!");
    }

    public void test28() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t// As of Java 21\n\trecord R(int i) {\n\t    public int i() {    // bad (but legal) accessor method for i\n\t        return i / 0;\n\t    }\n\t}\n\n\tstatic void exampleAnR(R r) {\n\t    switch(r) {\n\t        case R(var i): System.out.println(i);\n\t    }\n\t}\n\n\tstatic void example(Object obj) {\n\t    switch (obj) {\n\t        case R r when (r.i / 0 == 1): System.out.println(\"It's an R!\");\n\t        default: break;\n\t    }\n\t}\n\n\tpublic static void main(String [] args) {\n\t\ttry {\n\t\t\texampleAnR(new R(42));\n\t\t} catch (MatchException m) {\n\t\t\tSystem.out.println(\"ME:Ok!\");\n\t\t}\n\n\t\ttry {\n\t\t\texample(new R(42));\n\t\t} catch (MatchException m) {\n\t\t\tSystem.out.println(\"Broken!\");\n\t\t} catch(ArithmeticException ae) {\n\t\t\tSystem.out.println(\"AE:Ok!\");\n\t\t}\n\t}\n\n}\n"}, "ME:Ok!\nAE:Ok!");
    }
}

