/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTestForInterface
extends JavadocTest {
    public JavadocTestForInterface(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        return JavadocTestForInterface.class;
    }

    public static Test suite() {
        return JavadocTestForInterface.buildAllCompliancesTestSuite(JavadocTestForInterface.javadocTestClass());
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    public void test001() {
        this.runConformTest(new String[]{"IX.java", "\t/**\n\t * Valid class javadoc\n\t * @author ffr\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test002() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid class javadoc\n\t * @param x Invalid tag\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 3)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid class javadoc\n\t * @throws NullPointerException Invalid tag\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 3)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid class javadoc\n\t * @exception NullPointerException Invalid tag\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 3)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid class javadoc\n\t * @return Invalid tag\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 3)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid class javadoc\n\t * @exception NullPointerException Invalid tag\n\t * @throws NullPointerException Invalid tag\n\t * @return Invalid tag\n\t * @param x Invalid tag\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 3)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in IX.java (at line 4)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in IX.java (at line 5)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in IX.java (at line 6)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        this.runConformTest(new String[]{"IX.java", "\t/**\n\t * Valid class javadoc\n\t * @author ffr\n\t */\npublic interface IX {\n\tpublic void foo();\n\t/**\n\t * Invalid javadoc comment\n\t */\n}\n"});
    }

    public void test008() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\tpublic void foo();\n\t/**\n\t * Invalid javadoc comment\n\t */\n}\n"});
    }

    public void test009() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid javadoc comment\n\t */\n}\n"});
    }

    public void test010() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid string references \n\t *\n\t * @see \"unterminated string\n\t * @see \"invalid\" no text allowed after the string\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 4)\n\t* @see \"unterminated string\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n2. ERROR in IX.java (at line 5)\n\t* @see \"invalid\" no text allowed after the string\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test011() {
        this.runConformTest(new String[]{"IX.java", "\t/**\n\t * Valid string references \n\t *\n\t * @see \"Valid normal string\"\n\t * @see \"Valid \\\"string containing\\\" \\\"double-quote\\\"\"\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test012() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid URL link references \n\t *\n\t * @see <a href=\"invalid\">invalid</a\n\t * @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 4)\n\t* @see <a href=\"invalid\">invalid</a\n\t                                ^^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in IX.java (at line 5)\n\t* @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        this.runConformTest(new String[]{"IX.java", "\t/**\n\t * Valid URL link references \n\t *\n\t * @see <a hReF = \"http://download.oracle.com/javase/6/docs/technotes/tools/windows/javadoc.html\">Valid URL link reference</A>\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test020() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Valid local classes references \n\t *\n\t * @see Visibility Valid ref: local class \n\t * @see Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see AbstractVisibility.AvcPublic Valid ref: visible inner class of local class \n\t * @see test.Visibility Valid ref: local class \n\t * @see test.Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see test.AbstractVisibility.AvcPublic Valid ref: visible inner class of local class \n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test021() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Invalid local classes references \n\t *\n\t * @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see Unknown Invalid ref: unknown class \n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 5)\n\t* @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n2. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n3. ERROR in test\\IX.java (at line 7)\n\t* @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.VcPrivate is not visible\n----------\n4. ERROR in test\\IX.java (at line 8)\n\t* @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.AvcPrivate is not visible\n----------\n5. ERROR in test\\IX.java (at line 9)\n\t* @see Unknown Invalid ref: unknown class \n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void test022() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see VisibilityPublic Valid ref: visible class through import => no warning on import\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test023() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Invalid external classes references \n\t *\n\t * @see VisibilityPackage Invalid ref: non visible class \n\t * @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see VisibilityPackage Invalid ref: non visible class \n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n");
    }

    public void test024() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see test.copy.VisibilityPublic Valid ref: visible class through import => no warning on import\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test030() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Valid local class field references\n\t *\n\t * @see Visibility#vf_public Valid ref: visible field\n\t * @see Visibility.VcPublic#vf_public Valid ref: visible field in visible inner class\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test031() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Invalid local class field references\n\t *\n\t * @see #x Invalid ref: non existent field\n\t * @see Visibility#unknown Invalid ref: non existent field\n\t * @see Visibility#vf_private Invalid ref: non visible field\n\t * @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t * @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t * @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 5)\n\t* @see #x Invalid ref: non existent field\n\t        ^\nJavadoc: x cannot be resolved or is not a field\n----------\n2. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility#unknown Invalid ref: non existent field\n\t                  ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n3. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility#vf_private Invalid ref: non visible field\n\t                  ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n4. ERROR in test\\IX.java (at line 8)\n\t* @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n5. ERROR in test\\IX.java (at line 9)\n\t* @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t                           ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n6. ERROR in test\\IX.java (at line 10)\n\t* @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test032() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Valid other package visible class fields references\n\t *\n\t * @see VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test033() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPackage#unknown Invalid ref to non existent field of other package non visible class\n\t * @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t * @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t * @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t * @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see VisibilityPackage#unknown Invalid ref to non existent field of other package non visible class\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t                        ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t                        ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n4. ERROR in test\\IX.java (at line 9)\n\t* @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\IX.java (at line 10)\n\t* @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t                                 ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n6. ERROR in test\\IX.java (at line 11)\n\t* @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t                                 ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test040() {
        this.runConformTest(new String[]{"IX.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references with array\n\t * \n\t * @see #smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) Valid local method reference\n\t * @see #smr_foo(char[], int[][], String[][][], Vector[][][][]) Valid local method reference\n\t * @see #smr_foo(char[],int[][],java.lang.String[][][],java.util.Vector[][][][]) Valid local method reference\n\t */  \npublic interface IX {\n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra);\n}\n"});
    }

    public void test041() {
        this.runNegativeTest(new String[]{"IX.java", "import java.util.Vector;\n\t/**\n\t * Invalid local methods references with array (non applicable arrays)\n\t * \n\t * @see #smr_foo(char[] , int[][], String[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t */  \npublic interface IX {\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra);\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @see #smr_foo(char[] , int[][], String[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type IX is not applicable for the arguments (char[], int[][], String[][], Vector[][][][])\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test042() {
        this.runConformTest(new String[]{"IX.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see #smr_foo() Valid local method reference\n\t * @see #smr_foo(boolean a1,int a2,byte a3,short a4,char a5,long a6,float a7,double a8) Valid local method reference\n\t * @see #smr_foo(java.lang.String, java.lang.String, int) Valid local method reference   \n\t * @see #smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic interface IX {\n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b);\n}\n"});
    }

    public void test043() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #unknown() Invalid ref: undefined local method reference\n\t */  \npublic interface IX {\n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 4)\n\t* @see #unknown() Invalid ref: undefined local method reference\n\t        ^^^^^^^\nJavadoc: The method unknown() is undefined for the type IX\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test044() {
        this.runNegativeTest(new String[]{"IX.java", "\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(int) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(float, long, char, short, byte, int, boolean) Invalid ref: local method not applicable\n\t * @see #smr_foo(String, String, int, String) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t * @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t */  \npublic interface IX {\n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b);\n}\n"}, "----------\n1. ERROR in IX.java (at line 4)\n\t* @see #smr_foo(int) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo() in the type IX is not applicable for the arguments (int)\n----------\n2. ERROR in IX.java (at line 5)\n\t* @see #smr_foo(float, long, char, short, byte, int, boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type IX is not applicable for the arguments (float, long, char, short, byte, int, boolean)\n----------\n3. ERROR in IX.java (at line 6)\n\t* @see #smr_foo(String, String, int, String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type IX is not applicable for the arguments (String, String, int, String)\n----------\n4. ERROR in IX.java (at line 7)\n\t* @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type IX is not applicable for the arguments (boolean)\n----------\n5. ERROR in IX.java (at line 8)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n6. ERROR in IX.java (at line 8)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                             ^^^^^^\nJavadoc: Vector cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test045() {
        this.runConformTest(new String[]{"IX.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see IX#smr_foo() Valid local method reference\n\t * @see IX#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see IX#smr_foo(String x, java.lang.String y, int z) Valid local method reference   \n\t * @see IX#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic interface IX {\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b);\n}\n"});
    }

    public void test046() {
        this.runConformTest(new String[]{"test/deep/qualified/name/p/IX.java", "package test.deep.qualified.name.p;\nimport java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.IX#smr_foo() Valid local method reference\n\t * @see test.deep.qualified.name.p.IX#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see test.deep.qualified.name.p.IX#smr_foo(String x, java.lang.String y, int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.IX#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic interface IX {\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, Vector v, boolean b);\n}\n"});
    }

    public void test047() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Valid package class methods references\n\t * \n\t * @see Visibility#vm_public() Valid ref: visible method\n\t * @see Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t * @see test.Visibility#vm_public() Valid ref: visible method\n\t * @see test.Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t */  \npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test048() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Invalid package class methods references (non-existence)\n\t * \n\t * @see Visibility#unknown() Invalid ref: non-existent method\n\t * @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t * @see Unknown#vm_public() Invalid ref: non-existent class\n\t * @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t */  \npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 5)\n\t* @see Visibility#unknown() Invalid ref: non-existent method\n\t                  ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility\n----------\n2. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t                           ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility.VcPublic\n----------\n3. ERROR in test\\IX.java (at line 7)\n\t* @see Unknown#vm_public() Invalid ref: non-existent class\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n4. ERROR in test\\IX.java (at line 8)\n\t* @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Visibility.Unknown cannot be resolved to a type\n----------\n");
    }

    public void test049() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Invalid package class methods references (non-visible)\n\t * \n\t * @see Visibility#vm_private() Invalid ref: non-visible method\n\t * @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t * @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t */  \npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 5)\n\t* @see Visibility#vm_private() Invalid ref: non-visible method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility is not visible\n----------\n2. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n3. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility.VcPublic is not visible\n----------\n");
    }

    public void test050() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Invalid package class methods references (non-applicable)\n\t * \n\t * @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t * @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t * @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t * @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t */  \npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 5)\n\t* @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility is not applicable for the arguments (int)\n----------\n2. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility is not applicable for the arguments (String)\n----------\n3. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility.VcPublic is not applicable for the arguments (Integer, byte)\n----------\n4. ERROR in test\\IX.java (at line 8)\n\t* @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility.VcPublic is not applicable for the arguments (Double, Boolean)\n----------\n");
    }

    public void test051() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Invalid other package non visible class methods references (non existent/visible arguments)\n\t * \n\t * @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t * @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"}, "----------\n1. WARNING in test\\IX.java (at line 2)\n\timport test.copy.*;\n\t       ^^^^^^^^^\nThe import test.copy is never used\n----------\n2. ERROR in test\\IX.java (at line 6)\n\t* @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n3. ERROR in test\\IX.java (at line 7)\n\t* @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n");
    }

    public void test052() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.VisibilityPublic;\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test053() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see test.copy.VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\npublic interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test060() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n\tpublic void foo(IX x) {\n\t x.foo();\n\t}\n}\n", "IX.java", "public interface IX {\n  /** \n   * \n   * ** \f  ** ** ** @deprecated */\n\tpublic void foo();\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tx.foo();\n\t  ^^^\nThe method foo() from the type IX is deprecated\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test061() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/** @deprecated */\n\tint x=0;\n\t/**\n\t * @see #x\n\t */\n\tvoid foo();\n}\n", "IY.java", "/** @deprecated */\npublic interface IY {\n\tint y=0;\n\t/**\n\t * @see IX#x\n\t * @see IY\n\t * @see IY#y\n\t */\n\tvoid foo();\n}\n", "X.java", "public class X {\n\tint x;\n\t/**\n\t * @see IX#x\n\t * @see IY\n\t * @see IY#y\n\t */\n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see IX#x\n\t          ^\nJavadoc: The field IX.x is deprecated\n----------\n2. ERROR in X.java (at line 5)\n\t* @see IY\n\t       ^^\nJavadoc: The type IY is deprecated\n----------\n3. ERROR in X.java (at line 6)\n\t* @see IY#y\n\t       ^^\nJavadoc: The type IY is deprecated\n----------\n4. ERROR in X.java (at line 6)\n\t* @see IY#y\n\t          ^\nJavadoc: The field IY.y is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo(IX x) {\n\t\tx.foo(2);\n\t}\n}\n", "IX.java", "public interface IX {\n  /** \n   * Valid tags with deprecation\n   *\n   * @param x Valid param tag\n   * @return Valid return tag\n   * @throws NullPointerException Valid throws tag\n   * @exception IllegalArgumentException Valid throws tag\n   * @see X Valid see tag\n   * @deprecated\n   */\n\tpublic String foo(int x);\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tx.foo(2);\n\t  ^^^\nThe method foo(int) from the type IX is deprecated\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo(IX x) {\n\t\tx.foo(2);\n\t}\n}\n", "IX.java", "public interface IX {\n  /** \n   * Invalid javadoc tags with valid deprecation\n   *\n   * @param\n   * @return String\n   * @throws Unknown\n   * @see \"Invalid\n   * @see Unknown\n   * @param x\n   * @deprecated\n   */\n\tpublic String foo(int x);\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tx.foo(2);\n\t  ^^^\nThe method foo(int) from the type IX is deprecated\n----------\n----------\n1. ERROR in IX.java (at line 5)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in IX.java (at line 7)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n3. ERROR in IX.java (at line 8)\n\t* @see \"Invalid\n\t       ^^^^^^^^\nJavadoc: Invalid reference\n----------\n4. ERROR in IX.java (at line 9)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n5. ERROR in IX.java (at line 10)\n\t* @param x\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n6. ERROR in IX.java (at line 13)\n\tpublic String foo(int x);\n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test064() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Valid @param: no tags, no args\n\t * Valid @throws/@exception: no tags, no thrown exception\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test065() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\tpublic void foo();\n}\n"});
    }

    public void test066() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid @param declaration: no arguments, 2 declared tags\n\t * @param x\n\t * \t\t\tInvalid param: not an argument on 2 lines\n\t * @param x Invalid param: not an argument\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 4)\n\t* @param x\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n2. ERROR in IX.java (at line 6)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test067() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t\n\t/**\n\t * Valid @param declaration: 3 arguments, 3 tags in right order\n\t * @param a Valid param\n\t * @param b Valid param \n\t * @param c Valid param\n\t */\n\tpublic void foo(int a, int b, int c);\n}\n"});
    }

    public void test068() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid @param declaration: 3 arguments, 3 correct tags in right order + 2 additional\n\t * @param a Valid param\n\t * @param x Invalid param: not an argument\n\t * @param b Valid param \n\t * @param y Invalid param: not an argument\n\t * @param c Valid param\n\t */\n\tpublic void foo(char a, char b, char c);\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n2. ERROR in IX.java (at line 7)\n\t* @param y Invalid param: not an argument\n\t         ^\nJavadoc: Parameter y is not declared\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test069() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid @param: all arguments are not documented\n\t */\n\tpublic void foo(double a, double b, double c);\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\tpublic void foo(double a, double b, double c);\n\t                       ^\nJavadoc: Missing tag for parameter a\n----------\n2. ERROR in IX.java (at line 5)\n\tpublic void foo(double a, double b, double c);\n\t                                 ^\nJavadoc: Missing tag for parameter b\n----------\n3. ERROR in IX.java (at line 5)\n\tpublic void foo(double a, double b, double c);\n\t                                           ^\nJavadoc: Missing tag for parameter c\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test070() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid @param: mix of all possible errors (missing a, not argument tag and duplicated)\n\t * @param c Valid param\n\t * @param x Invalid param: not an argument\n\t * @param b Valid param\n\t * @param c Invalid param: duplicated\n\t * @param\n\t */\n\tpublic void foo(double a, long b, int c);\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n2. ERROR in IX.java (at line 7)\n\t* @param c Invalid param: duplicated\n\t         ^\nJavadoc: Duplicate tag for parameter\n----------\n3. ERROR in IX.java (at line 8)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n4. ERROR in IX.java (at line 10)\n\tpublic void foo(double a, long b, int c);\n\t                       ^\nJavadoc: Missing tag for parameter a\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test071() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Valid @throws tags: documented exception are unchecked\n\t * @throws IllegalArgumentException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @exception NullPointerException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws java.awt.AWTError Valid unchecked exception (java.lang.Error subclass)\n\t * @exception OutOfMemoryError Valid unchecked exception (java.lang.Runtime subclass)\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test072() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * @throws java.awt.AWTexception Invalid exception: unknown type\n\t * @throws IOException Invalid exception: unknown type\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 3)\n\t* @throws java.awt.AWTexception Invalid exception: unknown type\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: java.awt.AWTexception cannot be resolved to a type\n----------\n2. ERROR in IX.java (at line 4)\n\t* @throws IOException Invalid exception: unknown type\n\t          ^^^^^^^^^^^\nJavadoc: IOException cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test073() {
        this.runNegativeTest(new String[]{"IX.java", "import java.io.FileNotFoundException;\npublic interface IX {\n\t/**\n\t * @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t * @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 4)\n\t* @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception EOFException is not declared\n----------\n2. ERROR in IX.java (at line 5)\n\t* @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception FileNotFoundException is not declared\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test074() {
        this.runNegativeTest(new String[]{"IX.java", "import java.io.FileNotFoundException;\npublic interface IX {\n\t/**\n\t * Invalid @throws tags: documented exception are unchecked but some thrown exception are invalid\n\t * @throws IllegalAccessException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws IllegalArgumentException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @exception NullPointerException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws java.awt.AWTError Valid unchecked exception (java.lang.Error subclass)\n\t * @exception OutOfMemoryError Valid unchecked exception (java.lang.Runtime subclass)\n\t */\n\tpublic void foo() throws\n\t\tIllegalAccessException, \n\t\tInvalidException, \n\t\tString, \n\t\tjava.io.EOFException, \n\t\tFileNotFoundException, \n\t\tIOException;\n}\n"}, "----------\n1. ERROR in IX.java (at line 13)\n\tInvalidException, \n\t^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n2. ERROR in IX.java (at line 14)\n\tString, \n\t^^^^^^\nNo exception of type String can be thrown; an exception type must be a subclass of Throwable\n----------\n3. ERROR in IX.java (at line 15)\n\tjava.io.EOFException, \n\t^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception EOFException\n----------\n4. ERROR in IX.java (at line 16)\n\tFileNotFoundException, \n\t^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception FileNotFoundException\n----------\n5. ERROR in IX.java (at line 17)\n\tIOException;\n\t^^^^^^^^^^^\nIOException cannot be resolved to a type\n----------\n");
    }

    public void test080() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Valid return declaration\n\t *\n\t * @return Return an int\n\t */\n\tpublic int foo();\n}\n"});
    }

    public void test081() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Valid empty return declaration\n\t *\n\t * @return string\n\t */\n\tpublic String foo();\n}\n"});
    }

    public void test082() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Missing return declaration\n\t */\n\tpublic Object[] foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\tpublic Object[] foo();\n\t       ^^^^^^^^\nJavadoc: Missing tag for return type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test083() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid return declaration\n\t *\n\t * @return Dimension\n\t * @return Duplicated\n\t */\n\tpublic double foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 6)\n\t* @return Duplicated\n\t   ^^^^^^\nJavadoc: Duplicate tag for return type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test084() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid return declaration\n\t *\n\t * @return Invalid return on void method\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @return Invalid return on void method\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test090() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid string references \n\t *\n\t * @see \"unterminated string\n\t * @see \"invalid\" no text allowed after the string\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @see \"unterminated string\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n2. ERROR in IX.java (at line 6)\n\t* @see \"invalid\" no text allowed after the string\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test091() {
        this.runConformTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Valid string references \n\t *\n\t * @see \"Valid normal string\"\n\t * @see \"Valid \\\"string containing\\\" \\\"double-quote\\\"\"\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test092() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid URL link references \n\t *\n\t * @see <a\n\t * @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @see <a\n\t       ^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in IX.java (at line 6)\n\t* @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test095() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Valid local classes references \n\t *\n\t * @see Visibility Valid ref: local class \n\t * @see Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see AbstractVisibility.AvcPublic Valid ref: visible inner class of local class \n\t * @see test.Visibility Valid ref: local class \n\t * @see test.Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see test.AbstractVisibility.AvcPublic Valid ref: visible inner class of local class \n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test096() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Invalid local classes references \n\t *\n\t * @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see Unknown Invalid ref: unknown class \n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.VcPrivate is not visible\n----------\n4. ERROR in test\\IX.java (at line 9)\n\t* @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.AvcPrivate is not visible\n----------\n5. ERROR in test\\IX.java (at line 10)\n\t* @see Unknown Invalid ref: unknown class \n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void test097() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\npublic interface IX {\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see VisibilityPublic Valid ref: visible class through import => no warning on import\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test098() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\npublic interface IX {\n\t/**\n\t * Invalid external classes references \n\t *\n\t * @see VisibilityPackage Invalid ref: non visible class \n\t * @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 7)\n\t* @see VisibilityPackage Invalid ref: non visible class \n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\IX.java (at line 8)\n\t* @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n");
    }

    public void test099() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see test.copy.VisibilityPublic Valid ref: visible class through import => no warning on import\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test105() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Valid local class field references\n\t *\n\t * @see Visibility#vf_public Valid ref: visible field\n\t * @see Visibility.VcPublic#vf_public Valid ref: visible field in visible inner class\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test106() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Invalid local class field references\n\t *\n\t * @see #x Invalid ref: non existent field\n\t * @see Visibility#unknown Invalid ref: non existent field\n\t * @see Visibility#vf_private Invalid ref: non visible field\n\t * @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t * @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t * @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see #x Invalid ref: non existent field\n\t        ^\nJavadoc: x cannot be resolved or is not a field\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility#unknown Invalid ref: non existent field\n\t                  ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see Visibility#vf_private Invalid ref: non visible field\n\t                  ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n4. ERROR in test\\IX.java (at line 9)\n\t* @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n5. ERROR in test\\IX.java (at line 10)\n\t* @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t                           ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n6. ERROR in test\\IX.java (at line 11)\n\t* @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test107() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\npublic interface IX {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test108() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\npublic interface IX {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPackage#unknown Invalid ref to non existent field of other package non visible class\n\t * @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t * @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t * @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t * @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 7)\n\t* @see VisibilityPackage#unknown Invalid ref to non existent field of other package non visible class\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\IX.java (at line 8)\n\t* @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t                        ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n3. ERROR in test\\IX.java (at line 9)\n\t* @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t                        ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n4. ERROR in test\\IX.java (at line 10)\n\t* @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\IX.java (at line 11)\n\t* @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t                                 ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n6. ERROR in test\\IX.java (at line 12)\n\t* @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t                                 ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test110() {
        this.runConformTest(new String[]{"IX.java", "import java.util.Vector;\npublic interface IX {\n\t/**\n\t * Valid local methods references with array\n\t * \n\t * @see #smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) Valid local method reference\n\t * @see #smr_foo(char[], int[][], String[][][], Vector[][][][]) Valid local method reference\n\t * @see #smr_foo(char[],int[][],java.lang.String[][][],java.util.Vector[][][][]) Valid local method reference\n\t */  \n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra);\n}\n"});
    }

    public void test111() {
        this.runNegativeTest(new String[]{"IX.java", "import java.util.Vector;\npublic interface IX {\n\t/**\n\t * Invalid local methods references with array (non applicable arrays)\n\t * \n\t * @see #smr_foo(char[] , int[][], String[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t */  \n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra);\n}\n"}, "----------\n1. ERROR in IX.java (at line 6)\n\t* @see #smr_foo(char[] , int[][], String[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type IX is not applicable for the arguments (char[], int[][], String[][], Vector[][][][])\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test112() {
        this.runConformTest(new String[]{"IX.java", "import java.util.Vector;\npublic interface IX {\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see #smr_foo() Valid local method reference\n\t * @see #smr_foo(boolean a1,int a2,byte a3,short a4,char a5,long a6,float a7,double a8) Valid local method reference\n\t * @see #smr_foo(java.lang.String, java.lang.String, int) Valid local method reference   \n\t * @see #smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b);\n}\n"});
    }

    public void test113() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #unknown() Invalid ref: undefined local method reference\n\t */  \n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo();\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @see #unknown() Invalid ref: undefined local method reference\n\t        ^^^^^^^\nJavadoc: The method unknown() is undefined for the type IX\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test114() {
        this.runNegativeTest(new String[]{"IX.java", "public interface IX {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(int) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(float, long, char, short, byte, int, boolean) Invalid ref: local method not applicable\n\t * @see #smr_foo(String, String, int, String) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t * @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t */  \n\tpublic void foo();\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b);\n}\n"}, "----------\n1. ERROR in IX.java (at line 5)\n\t* @see #smr_foo(int) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo() in the type IX is not applicable for the arguments (int)\n----------\n2. ERROR in IX.java (at line 6)\n\t* @see #smr_foo(float, long, char, short, byte, int, boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type IX is not applicable for the arguments (float, long, char, short, byte, int, boolean)\n----------\n3. ERROR in IX.java (at line 7)\n\t* @see #smr_foo(String, String, int, String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type IX is not applicable for the arguments (String, String, int, String)\n----------\n4. ERROR in IX.java (at line 8)\n\t* @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type IX is not applicable for the arguments (boolean)\n----------\n5. ERROR in IX.java (at line 9)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n6. ERROR in IX.java (at line 9)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                             ^^^^^^\nJavadoc: Vector cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test115() {
        this.runConformTest(new String[]{"IX.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see IX#smr_foo() Valid local method reference\n\t * @see IX#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see IX#smr_foo(String x, java.lang.String y, int z) Valid local method reference   \n\t * @see IX#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic interface IX {\n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b);\n}\n"});
    }

    public void test116() {
        this.runConformTest(new String[]{"test/deep/qualified/name/p/IX.java", "package test.deep.qualified.name.p;\nimport java.util.Vector;\npublic interface IX {\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.IX#smr_foo() Valid local method reference\n\t * @see test.deep.qualified.name.p.IX#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see test.deep.qualified.name.p.IX#smr_foo(String x, java.lang.String y, int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.IX#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \n\tpublic void smr_foo();\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d);\n\tpublic void smr_foo(String str1, java.lang.String str2, int i);\n\tpublic void smr_foo(java.util.Hashtable h, Vector v, boolean b);\n}\n"});
    }

    public void test117() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Valid package class methods references\n\t * \n\t * @see Visibility#vm_public() Valid ref: visible method\n\t * @see Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t * @see test.Visibility#vm_public() Valid ref: visible method\n\t * @see test.Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t */  \n\tpublic void foo();\n}\n"});
    }

    public void test118() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Invalid package class methods references (non-existence)\n\t * \n\t * @see Visibility#unknown() Invalid ref: non-existent method\n\t * @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t * @see Unknown#vm_public() Invalid ref: non-existent class\n\t * @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t */  \n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility#unknown() Invalid ref: non-existent method\n\t                  ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t                           ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility.VcPublic\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see Unknown#vm_public() Invalid ref: non-existent class\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n4. ERROR in test\\IX.java (at line 9)\n\t* @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Visibility.Unknown cannot be resolved to a type\n----------\n");
    }

    public void test119() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Invalid package class methods references (non-visible)\n\t * \n\t * @see Visibility#vm_private() Invalid ref: non-visible method\n\t * @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t * @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t */  \n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility#vm_private() Invalid ref: non-visible method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility is not visible\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility.VcPublic is not visible\n----------\n");
    }

    public void test120() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Invalid package class methods references (non-applicable)\n\t * \n\t * @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t * @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t * @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t * @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t */  \n\tpublic void foo();\n}\n"}, "----------\n1. ERROR in test\\IX.java (at line 6)\n\t* @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility is not applicable for the arguments (int)\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility is not applicable for the arguments (String)\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility.VcPublic is not applicable for the arguments (Integer, byte)\n----------\n4. ERROR in test\\IX.java (at line 9)\n\t* @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility.VcPublic is not applicable for the arguments (Double, Boolean)\n----------\n");
    }

    public void test121() {
        this.runNegativeReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.*;\npublic interface IX {\n\t/**\n\t * Invalid other package non visible class methods references (non existent/visible arguments)\n\t * \n\t * @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t * @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t */\n\tpublic void foo();\n}\n"}, "----------\n1. WARNING in test\\IX.java (at line 2)\n\timport test.copy.*;\n\t       ^^^^^^^^^\nThe import test.copy is never used\n----------\n2. ERROR in test\\IX.java (at line 7)\n\t* @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n3. ERROR in test\\IX.java (at line 8)\n\t* @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n");
    }

    public void test122() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\nimport test.copy.VisibilityPublic;\npublic interface IX {\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\n\tpublic void foo();\n}\n"});
    }

    public void test123() {
        this.runConformReferenceTest(new String[]{"test/IX.java", "package test;\npublic interface IX {\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see test.copy.VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\n\tpublic void foo();\n}\n"});
    }
}

