/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;

public class JavadocTestForModule
extends AbstractBatchCompilerTest {
    public JavadocTestForModule(String name) {
        super(name);
    }

    public static Test suite() {
        return JavadocTestForModule.buildMinimalComplianceTestSuite(JavadocTestForModule.testClass(), 64);
    }

    public static Class<?> testClass() {
        return JavadocTestForModule.class;
    }

    protected void writeFileCollecting(List<String> collectedFiles, String directoryName, String fileName, String source) {
        this.writeFile(directoryName, fileName, source);
        collectedFiles.add(directoryName + File.separator + fileName);
    }

    protected void writeFile(String directoryName, String fileName, String source) {
        File directory = new File(directoryName);
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directoryName);
            return;
        }
        String filePath = directory.getAbsolutePath() + File.separator + fileName;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    void runConformModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory) {
        this.runConformModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, OUTPUT_DIR + File.separator + "javac");
    }

    void runConformModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String output) {
        for (String file : testFileNames) {
            commandLine.append(" \"").append(file).append("\"");
        }
        this.runConformModuleTest(new String[0], commandLine.toString(), expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, output, AbstractRegressionTest.JavacTestOptions.DEFAULT, null);
    }

    Set<String> runConformModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory) {
        return this.runConformModuleTest(testFiles, commandLine, expectedFailureErrOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, OUTPUT_DIR, AbstractRegressionTest.JavacTestOptions.DEFAULT, null);
    }

    Set<String> runConformModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String output, AbstractRegressionTest.JavacTestOptions options, String javacCommandLine) {
        this.runConformTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory);
        if (this.shouldRunJavac()) {
            File outputDir = new File(output);
            HashSet<String> outFiles = new HashSet<String>();
            this.walkOutFiles(output, outFiles, true);
            String[] testFileNames = new String[testFiles.length / 2];
            int i = 0;
            while (i < testFileNames.length) {
                testFileNames[i] = testFiles[i * 2];
                ++i;
            }
            if (javacCommandLine == null) {
                javacCommandLine = this.adjustForJavac(commandLine, null);
            }
            for (AbstractRegressionTest.JavacCompiler javacCompiler : javacCompilers) {
                if (javacCompiler.compliance < 0x350000L) continue;
                if (options.skip(javacCompiler)) {
                    System.err.println("Skip testing javac in " + this.testName());
                    continue;
                }
                StringBuilder log = new StringBuilder();
                try {
                    long compileResult = javacCompiler.compile(outputDir, javacCommandLine, testFileNames, log, false);
                    if (compileResult != 0L) {
                        System.err.println("Previous error was from " + this.testName());
                        JavadocTestForModule.fail((String)"Unexpected error from javac");
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new AssertionFailedError(e.getMessage());
                }
                HashSet<String> expectedFiles = new HashSet<String>(outFiles);
                this.walkOutFiles(output, expectedFiles, false);
                for (String missingFile : expectedFiles) {
                    System.err.println("Missing output file from javac:    " + missingFile);
                }
            }
            return outFiles;
        }
        return null;
    }

    void runNegativeModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch) {
        this.runNegativeModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, OUTPUT_DIR + File.separator + "javac");
    }

    void runNegativeModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch, String output) {
        this.runNegativeModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, output, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    void runNegativeModuleTest(List<String> testFileNames, StringBuilder commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch, String output, AbstractRegressionTest.JavacTestOptions options) {
        for (String file : testFileNames) {
            commandLine.append(" \"").append(file).append("\"");
        }
        this.runNegativeModuleTest(new String[0], commandLine.toString(), expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, output, options);
    }

    void runNegativeModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch) {
        this.runNegativeModuleTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, OUTPUT_DIR, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    void runNegativeModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch, String output, AbstractRegressionTest.JavacTestOptions options) {
        this.runNegativeTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory);
        if (this.shouldRunJavac()) {
            String[] testFileNames = new String[testFiles.length / 2];
            int i = 0;
            while (i < testFileNames.length) {
                testFileNames[i] = testFiles[i * 2];
                ++i;
            }
            File outputDir = new File(OUTPUT_DIR);
            HashSet<String> outFiles = new HashSet<String>();
            this.walkOutFiles(output, outFiles, true);
            for (AbstractRegressionTest.JavacCompiler javacCompiler : javacCompilers) {
                if (javacCompiler.compliance < 0x350000L) continue;
                AbstractRegressionTest.JavacTestOptions.Excuse excuse = options.excuseFor(javacCompiler);
                commandLine = this.adjustForJavac(commandLine, null);
                StringBuilder log = new StringBuilder();
                int mismatch = 0;
                try {
                    long compileResult = javacCompiler.compile(outputDir, commandLine, testFileNames, log);
                    if (compileResult == 0L) {
                        mismatch = 1;
                        javacErrorMatch = expectedFailureErrOutputString;
                        System.err.println("Previous error was from " + this.testName());
                    } else if (!log.toString().contains(javacErrorMatch)) {
                        mismatch = 4096;
                        System.err.println(this.testName() + ": Error match " + javacErrorMatch + " not found in \n" + log.toString());
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new AssertionFailedError(e.getMessage());
                }
                this.handleMismatch(javacCompiler, this.testName(), testFiles, javacErrorMatch, "", "", log, "", "", excuse, mismatch);
                HashSet<String> expectedFiles = new HashSet<String>(outFiles);
                this.walkOutFiles(output, expectedFiles, false);
                for (String missingFile : expectedFiles) {
                    System.err.println("Missing output file from javac:    " + missingFile);
                }
            }
        }
    }

    String adjustForJavac(String commandLine, String versionOptions) {
        String[] tokens = commandLine.split(" ");
        StringBuilder buf = new StringBuilder();
        boolean skipNext = false;
        int i = 0;
        while (i < tokens.length) {
            if (skipNext) {
                skipNext = false;
            } else if (tokens[i].trim().equals("-9")) {
                if (versionOptions == null) {
                    buf.append(' ').append(" --release 9 ");
                }
            } else if (tokens[i].trim().equals("-8")) {
                if (versionOptions == null) {
                    buf.append(' ').append(" --release 8 ");
                }
            } else if (tokens[i].startsWith("-warn") || tokens[i].startsWith("-err") || tokens[i].startsWith("-info")) {
                if (tokens[i].contains("exports") && !tokens[i].contains("-exports")) {
                    buf.append(" -Xlint:exports ");
                }
            } else if (tokens[i].trim().equals("-classNames")) {
                skipNext = true;
            } else if (tokens[i].trim().equals("-enableJavadoc")) {
                buf.append(" -Xdoclint:all ");
            } else {
                buf.append(tokens[i]).append(' ');
            }
            ++i;
        }
        if (versionOptions != null) {
            buf.append(versionOptions);
        }
        return buf.toString();
    }

    private void walkOutFiles(final String outputLocation, final Set<String> fileNames, final boolean add) {
        if (!new File(outputLocation).exists()) {
            return;
        }
        try {
            Files.walkFileTree(Path.of(outputLocation, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(".class")) {
                        if (add) {
                            fileNames.add(file.toString());
                        } else if (!fileNames.remove(file.toString())) {
                            System.err.println("Unexpected output file from javac: " + file.toString());
                        }
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.toString().equals(outputLocation)) {
                        try {
                            Files.delete(dir);
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AssertionFailedError(e.getMessage());
        }
    }

    public void testBug549855a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 5)\n\tprovides p.I1 with p.P1;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing provides tag\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 6)\n\tuses java.util.Currency;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing uses tag\n----------\n2 problems (2 errors)\n", false, "missing tags", OUTPUT_DIR, (AbstractRegressionTest.JavacTestOptions)AbstractRegressionTest.JavacTestOptions.JavacHasABug.NoWarningForMissingJavadocTag);
    }

    public void testBug549855b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n @provides p.I\n @uses java.util.Currenc\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 7)\n\tprovides p.I1 with p.P1;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing provides tag\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 8)\n\tuses java.util.Currency;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing uses tag\n----------\n2 problems (2 errors)\n", false, "service-type not found");
    }

    public void testBug549855c() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n @provides p.I1\n @uses java.util.Currency\n @provides p.I1\n @uses java.util.Currency\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 4)\n\t@provides p.I1\n\t          ^^^^\nJavadoc: Duplicate provides tag\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 5)\n\t@uses java.util.Currency\n\t      ^^^^^^^^^^^^^^^^^^\nJavadoc: Duplicate uses tag\n----------\n2 problems (2 errors)\n", false, "duplicate tags", OUTPUT_DIR, (AbstractRegressionTest.JavacTestOptions)AbstractRegressionTest.JavacTestOptions.JavacHasABug.NoWarningForDuplicateJavadocTag);
    }

    public void testBug549855d() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n @provides p.I1\n @uses java.util.Currency\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testBug549855e() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n @provides p.I1\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 7)\n\tuses java.util.Currency;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing uses tag\n----------\n1 problem (1 error)\n", false, "missing tags", OUTPUT_DIR, (AbstractRegressionTest.JavacTestOptions)AbstractRegressionTest.JavacTestOptions.JavacHasABug.NoWarningForMissingJavadocTag);
    }

    public void testBug549855f() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n @uses java.util.Currency\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 6)\n\tprovides p.I1 with p.P1;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing provides tag\n----------\n1 problem (1 error)\n", false, "missing tags", OUTPUT_DIR, (AbstractRegressionTest.JavacTestOptions)AbstractRegressionTest.JavacTestOptions.JavacHasABug.NoWarningForMissingJavadocTag);
    }

    public void testBug549855g() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 5)\n\tprovides p.I1 with p.P1;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing provides tag\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 6)\n\tuses java.util.Currency;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing uses tag\n----------\n2 problems (2 errors)\n", false, "missing tags", OUTPUT_DIR, (AbstractRegressionTest.JavacTestOptions)AbstractRegressionTest.JavacTestOptions.JavacHasABug.NoWarningForMissingJavadocTag);
    }

    public void testBug549855h() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "/**\n * @provides p.I\n * @uses java.util.Currenc\n */\nmodule mod.one { \n exports p;\n provides p.I1 with p.P1;\n uses java.util.Currency;\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "I1.java", "package p;\n/**\n * interface I1\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}");
        this.writeFileCollecting(files, moduleLoc + File.separator + "p", "P1.java", "package p;\n/**\n * class P1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ").append(moduleLoc + File.separator + "p" + File.separator + "I1.java ").append(moduleLoc + File.separator + "p" + File.separator + "P1.java");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 7)\n\tprovides p.I1 with p.P1;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing provides tag\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 8)\n\tuses java.util.Currency;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing uses tag\n----------\n2 problems (2 errors)\n", false, "reference not found");
    }

    public void testBug549855i() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String moduleLoc = directory + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n}");
        StringBuilder buffer = new StringBuilder();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -enableJavadoc ").append(" -err:allJavadoc ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-unused").append(" --module-source-path \"" + directory + "\" ").append(moduleLoc + File.separator + "module-info.java ");
        this.runNegativeModuleTest(new String[0], buffer.toString(), "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 1)\n\tmodule mod.one {\n\t^^^^^^^^^^^^^^^\nJavadoc: Missing comment for module declaration\n----------\n1 problem (1 error)\n", false, "no comment");
    }

    public void testBug562960() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = OUTPUT_DIR + File.separator + "src";
        String options = "-d " + OUTPUT_DIR + File.separator + out + " -9  -enableJavadoc  -err:allJavadoc  -classpath \"" + Util.getJavaClassLibsAsString() + "\" " + directory + File.separator + "Test.java";
        this.runNegativeModuleTest(new String[]{"src/Test.java", "/**\n * {@link sun.security.ssl.X509TrustManagerImpl}\n */\npublic class Test {}\n"}, options, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/Test.java (at line 2)\n\t* {@link sun.security.ssl.X509TrustManagerImpl}\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type sun.security.ssl.X509TrustManagerImpl is not accessible\n----------\n1 problem (1 error)\n", false, "reference not found");
    }

    class Runner
    extends AbstractRegressionTest.Runner {
        StringBuilder commandLine = new StringBuilder();
        String outputDir = OUTPUT_DIR + File.separator + "javac";
        List<String> fileNames = new ArrayList<String>();
        String javacVersionOptions;

        Runner() {
            this.javacTestOptions = AbstractRegressionTest.JavacTestOptions.DEFAULT;
            this.expectedOutputString = "";
            this.expectedErrorString = "";
        }

        void createFile(String directoryName, String fileName, String source) {
            JavadocTestForModule.this.writeFileCollecting(this.fileNames, directoryName, fileName, source);
        }

        Set<String> runConformModuleTest() {
            if (!this.fileNames.isEmpty()) {
                this.shouldFlushOutputDirectory = false;
                if (this.testFiles == null) {
                    this.testFiles = new String[0];
                }
                for (String fileName : this.fileNames) {
                    this.commandLine.append(" \"").append(fileName).append("\"");
                }
            }
            String commandLineString = this.commandLine.toString();
            String javacCommandLine = JavadocTestForModule.this.adjustForJavac(commandLineString, this.javacVersionOptions);
            return JavadocTestForModule.this.runConformModuleTest(this.testFiles, commandLineString, this.expectedOutputString, this.expectedErrorString, this.shouldFlushOutputDirectory, this.outputDir, this.javacTestOptions, javacCommandLine);
        }
    }
}

