/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTestForRecord
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportInvalidJavadocTags = "enabled";
    String reportInavlidJavadocTagsVisibility = "private";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocTagsOverriding = "enabled";
    String reportMissingJavadocComments = "error";
    String reportMissingJavadocCommentsVisibility = "protected";

    public JavadocTestForRecord(String name) {
        super(name);
    }

    public static Class<JavadocTestForRecord> testClass() {
        return JavadocTestForRecord.class;
    }

    public static Test suite() {
        return JavadocTestForRecord.buildMinimalComplianceTestSuite(JavadocTestForRecord.testClass(), 8192);
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocCommentsVisibility != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            if (this.reportMissingJavadocTagsOverriding != null) {
                options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", this.reportMissingJavadocTagsOverriding);
            }
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", this.reportInvalidJavadocTags);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInavlidJavadocTagsVisibility);
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "enabled");
        options.put("org.eclipse.jdt.core.compiler.release", "enabled");
        options.put("org.eclipse.jdt.core.compiler.compliance", "16");
        options.put("org.eclipse.jdt.core.compiler.source", "16");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "16");
        options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
        options.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        return options;
    }

    @Override
    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(testFiles, expectedCompilerLog, AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview("16"));
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput) {
        this.runConformTest(testFiles, expectedOutput, this.getCompilerOptions());
    }

    @Override
    protected void runConformTest(String[] testFiles, String expectedOutput, Map<String, String> customOptions) {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.testFiles = testFiles;
        runner.expectedOutputString = expectedOutput;
        runner.customOptions = customOptions;
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.forReleaseWithPreview("16");
        runner.runConformTest();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocTags = "enabled";
        this.reportInvalidJavadocVisibility = "private";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocTagsOverriding = "enabled";
        this.reportMissingJavadocComments = "error";
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public record X() {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic record X() {\n\t              ^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * @param radius radius of X\n\t */\npublic record X(int radius) {\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic void foo() {\n\t            ^^^^^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "\t\t/**  \n\t\t *   \n\t\t */  \npublic record X() {\n\t\t/**  \n\t\t *   @param args \n\t\t */  \n  public static void main(String[] args){\n     System.out.println(0);\n  }\n}"}, "0");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "\t\t/**  \n\t\t * @param a\n\t\t */  \n\t\tpublic record X(int a) {\n\t\t\t/**  \n\t\t\t *   @param args \n\t\t */  \n\t\t\tpublic static void main(String[] args){\n\t\t\t\tSystem.out.println(0);\n\t\t\t}\n\t\t}"}, "0");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "\t\t/**  \n\t\t */  \n\t\tpublic record X(int a) {\n\t\t\t/**  \n\t\t\t *   @param args \n\t\t\t */  \n\t\t\tpublic static void main(String[] args){\n\t\t\t\tSystem.out.println(0);\n\t\t\t}\n\t\t}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic record X(int a) {\n\t                    ^\nJavadoc: Missing tag for parameter a\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "\t\t/**  \n\t\t * @param a\n\t\t * @param a\n\t\t */  \n\t\tpublic record X(int a) {\n\t\t\t/**  \n\t\t\t *   @param args \n\t\t\t */  \n\t\t\tpublic static void main(String[] args){\n\t\t\t\tSystem.out.println(0);\n\t\t\t}\n\t\t}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param a\n\t         ^\nJavadoc: Duplicate tag for parameter\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "\t\t/**  \n\t\t * @param a\n\t\t * @param b\n\t\t */  \n\t\tpublic record X(int a) {\n\t\t\t/**  \n\t\t\t *   @param args \n\t\t\t */  \n\t\t\tpublic static void main(String[] args){\n\t\t\t\tSystem.out.println(0);\n\t\t\t}\n\t\t}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param b\n\t         ^\nJavadoc: Parameter b is not declared\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test_bug572367() {
        this.reportMissingJavadocCommentsVisibility = "private";
        this.runConformTest(new String[]{"X.java", "\t\t/**  \n\t\t * @param a\n\t\t */  \n\t\tpublic record X(int a) {\n\t\t\t/**  \n\t\t\t *   @param args \n\t\t */  \n\t\t\tpublic static void main(String[] args){\n\t\t\t\tSystem.out.println(0);\n\t\t\t}\n\t\t}"}, "0");
    }

    public void testGHIssue4158_1() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @param abc\n * @param abc\n * @param def\n * @param xyz\n * @return no return\n */\npublic record X(int abc, int def) {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param abc\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n2. ERROR in X.java (at line 3)\n\t* @param abc\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n3. ERROR in X.java (at line 5)\n\t* @param xyz\n\t         ^^^\nJavadoc: Parameter xyz is not declared\n----------\n4. ERROR in X.java (at line 6)\n\t* @return no return\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testGHIssue4158_2() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @param <T> a type param\n * @param <S> a type param\n * @param abc first\n * Javadoc with missing param tags\n */\npublic record X<U, V>(int abc, int def) {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* @param <T> a type param\n\t          ^\nJavadoc: T cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\t* @param <S> a type param\n\t          ^\nJavadoc: S cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\tpublic record X<U, V>(int abc, int def) {}\n\t                ^\nJavadoc: Missing tag for parameter U\n----------\n4. ERROR in X.java (at line 7)\n\tpublic record X<U, V>(int abc, int def) {}\n\t                   ^\nJavadoc: Missing tag for parameter V\n----------\n5. ERROR in X.java (at line 7)\n\tpublic record X<U, V>(int abc, int def) {}\n\t                                   ^^^\nJavadoc: Missing tag for parameter def\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

