/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment9;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BasicModule;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class JavadocTest_15
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportMissingJavadocDescription = "return_tag";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;
    String reportDeprecation = "error";
    String reportJavadocDeprecation = null;
    String processAnnotations = null;
    protected Map<String, IModule> moduleMap = new HashMap<String, IModule>();
    Map<String, String> file2module = new HashMap<String, String>();

    public JavadocTest_15(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        return JavadocTest_15.class;
    }

    public static Test suite() {
        return JavadocTest_15.buildMinimalComplianceTestSuite(JavadocTest_15.javadocTestClass(), 4096);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportJavadocDeprecation != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", this.reportJavadocDeprecation);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", "enabled");
            if (this.reportMissingJavadocCommentsVisibility != null) {
                options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
            }
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", "enabled");
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocDescription != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagDescription", this.reportMissingJavadocDescription);
        }
        if (this.processAnnotations != null) {
            options.put("org.eclipse.jdt.core.compiler.processAnnotations", this.processAnnotations);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", this.reportDeprecation);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    @Override
    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths, Map<String, String> options) {
        INameEnvironment[] classLibs;
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        INameEnvironment[] iNameEnvironmentArray = classLibs = this.getClassLibs(classPaths == null, options);
        int n = classLibs.length;
        int n2 = 0;
        while (n2 < n) {
            INameEnvironment nameEnvironment = iNameEnvironmentArray[n2];
            ((FileSystem)nameEnvironment).scanForModules(this.createParser());
            ++n2;
        }
        return new InMemoryNameEnvironment9(testFiles, this.moduleMap, classLibs);
    }

    Parser createParser() {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("org.eclipse.jdt.core.compiler.source", "9");
        return new Parser(new ProblemReporter(this.getErrorHandlingPolicy(), new CompilerOptions(opts), this.getProblemFactory()), false);
    }

    IModule extractModuleDesc(String fileName, String fileContent) {
        CompilationResult compilationResult;
        CompilationUnit cu;
        Parser parser;
        CompilationUnitDeclaration unit;
        if (fileName.toLowerCase().endsWith("module-info.java") && (unit = (parser = this.createParser()).parse((ICompilationUnit)(cu = new CompilationUnit(fileContent.toCharArray(), fileName, null)), compilationResult = new CompilationResult((ICompilationUnit)cu, 0, 1, 10))).isModuleInfo() && unit.moduleDeclaration != null) {
            return new BasicModule(unit.moduleDeclaration, null);
        }
        return null;
    }

    private void populateModuleMap(String[] modFiles) {
        int i = 0;
        while (i < modFiles.length) {
            IModule module = this.extractModuleDesc(modFiles[i], modFiles[i + 1]);
            if (module != null) {
                this.moduleMap.put(String.valueOf(module.name()), module);
            }
            i += 2;
        }
    }

    @Override
    protected CompilationUnit[] getCompilationUnits(String[] testFiles) {
        HashMap<String, char[]> moduleFiles = new HashMap<String, char[]>();
        int i = 0;
        while (i < testFiles.length) {
            IModule module = this.extractModuleDesc(testFiles[i], testFiles[i + 1]);
            if (module != null) {
                this.moduleMap.put(String.valueOf(module.name()), module);
                moduleFiles.put(testFiles[0], module.name());
            }
            i += 2;
        }
        CompilationUnit[] compilationUnits = Util.compilationUnits(testFiles);
        int i2 = 0;
        while (i2 < compilationUnits.length) {
            char[] fileName = compilationUnits[i2].getFileName();
            String fileNameString = String.valueOf(compilationUnits[i2].getFileName());
            if (CharOperation.endsWith((char[])fileName, (char[])TypeConstants.MODULE_INFO_FILE_NAME)) {
                compilationUnits[i2].module = (char[])moduleFiles.get(fileNameString.replace(File.separator, "/"));
            } else {
                String modName = this.file2module.get(fileNameString.replace(File.separator, "/"));
                if (modName != null) {
                    compilationUnits[i2].module = modName.toCharArray();
                }
            }
            ++i2;
        }
        return compilationUnits;
    }

    void associateToModule(String moduleName, String ... fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.file2module.put(fileName, moduleName);
            ++n2;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.moduleMap.clear();
        this.file2module.clear();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportMissingJavadocCommentsVisibility = "public";
        this.reportDeprecation = "error";
    }

    public void test001() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * @see mod.one/\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * @see mod.one/p.I1\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test002() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@link mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@link mod.one/p.I1}\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test003() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.I1}\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test004() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.P1#foo()}\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test005() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.P1#abc}\n */\npublic class P1 implements I1 {\n\tpublic int abc;\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test006() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.P1#abd}\n */\npublic class P1 implements I1 {\n\tpublic int abc;\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        String errorMsg = "----------\n1. ERROR in p\\P1.java (at line 4)\n\t* {@linkplain mod.one/p.P1#abd}\n\t                           ^^^\nJavadoc: abd cannot be resolved or is not a field\n----------\n";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runNegativeTest(testFiles, modFiles, errorMsg, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * @see mod.one/ abc\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * @see mod.one/p.I1 xyz\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test008() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@link mod.one/ abc}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@link mod.one/p.I1 xyz}\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test009() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/ abc}\n */\npublic interface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.I1 xyz}\n */\npublic class P1 implements I1 {\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runConformTest(testFiles, modFiles, "");
    }

    public void test010() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.on/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.P1#abc}\n */\npublic class P1 implements I1 {\n\tpublic int abc;\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        String errorMsg = "----------\n1. ERROR in p\\I1.java (at line 4)\n\t* {@linkplain mod.on/}\n\t              ^^^^^^\nJavadoc: mod.on cannot be resolved to a module\n----------\n";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runNegativeTest(testFiles, modFiles, errorMsg, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test011() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/p.P2#abc}\n */\npublic class P1 implements I1 {\n\tpublic int abc;\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        String errorMsg = "----------\n1. ERROR in p\\P1.java (at line 4)\n\t* {@linkplain mod.one/p.P2#abc}\n\t                      ^^^^\nJavadoc: p.P2 cannot be resolved to a type\n----------\n";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runNegativeTest(testFiles, modFiles, errorMsg, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test012() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String moduleInfo = "/**\n */\nmodule mod.one { \n exports p;\n}";
        String I1 = "package p;\n/**\n * interface I1\n * {@linkplain mod.one/}\n */\ninterface I1 {\n\t/**\n\t * Method foo\n    * @return int\n    */\n\tpublic int foo();\n}";
        String P1 = "package p;\n/**\n * class P1\n * {@linkplain mod.one/q.P1#abc}\n */\npublic class P1 implements I1 {\n\tpublic int abc;\n\t@Override\n\tpublic int foo() { return 0; }\n}";
        String errorMsg = "----------\n1. ERROR in p\\P1.java (at line 4)\n\t* {@linkplain mod.one/q.P1#abc}\n\t                      ^^^^\nJavadoc: q cannot be resolved to a type\n----------\n";
        this.associateToModule("mod.one", "p/I1.java");
        this.associateToModule("mod.one", "p/P1.java");
        String[] testFiles = new String[]{"p/I1.java", I1, "p/P1.java", P1};
        String[] modFiles = new String[]{"module-info.java", moduleInfo};
        this.populateModuleMap(modFiles);
        this.runNegativeTest(testFiles, modFiles, errorMsg, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

